// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleetRequest
type UpdateFleetInput struct {
	_ struct{} `type:"structure"`

	// The fleet attributes to delete.
	AttributesToDelete []FleetAttribute `type:"list"`

	// The desired capacity for the fleet.
	ComputeCapacity *ComputeCapacity `type:"structure"`

	// Deletes the VPC association for the specified fleet.
	DeleteVpcConfig *bool `deprecated:"true" type:"boolean"`

	// The description to display.
	Description *string `type:"string"`

	// The amount of time that a streaming session remains active after users disconnect.
	// If users try to reconnect to the streaming session after a disconnection
	// or network interruption within this time interval, they are connected to
	// their previous session. Otherwise, they are connected to a new session with
	// a new streaming instance.
	//
	// Specify a value between 60 and 360000.
	DisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The fleet name to display.
	DisplayName *string `type:"string"`

	// The name of the directory and organizational unit (OU) to use to join the
	// fleet to a Microsoft Active Directory domain.
	DomainJoinInfo *DomainJoinInfo `type:"structure"`

	// Enables or disables default internet access for the fleet.
	EnableDefaultInternetAccess *bool `type:"boolean"`

	// The amount of time that users can be idle (inactive) before they are disconnected
	// from their streaming session and the DisconnectTimeoutInSeconds time interval
	// begins. Users are notified before they are disconnected due to inactivity.
	// If users try to reconnect to the streaming session before the time interval
	// specified in DisconnectTimeoutInSeconds elapses, they are connected to their
	// previous session. Users are considered idle when they stop providing keyboard
	// or mouse input during their streaming session. File uploads and downloads,
	// audio in, audio out, and pixels changing do not qualify as user activity.
	// If users continue to be idle after the time interval in IdleDisconnectTimeoutInSeconds
	// elapses, they are disconnected.
	//
	// To prevent users from being disconnected due to inactivity, specify a value
	// of 0. Otherwise, specify a value between 60 and 3600. The default value is
	// 900.
	//
	// If you enable this feature, we recommend that you specify a value that corresponds
	// exactly to a whole number of minutes (for example, 60, 120, and 180). If
	// you don't do this, the value is rounded to the nearest minute. For example,
	// if you specify a value of 70, users are disconnected after 1 minute of inactivity.
	// If you specify a value that is at the midpoint between two different minutes,
	// the value is rounded up. For example, if you specify a value of 90, users
	// are disconnected after 2 minutes of inactivity.
	IdleDisconnectTimeoutInSeconds *int64 `type:"integer"`

	// The ARN of the public, private, or shared image to use.
	ImageArn *string `type:"string"`

	// The name of the image used to create the fleet.
	ImageName *string `min:"1" type:"string"`

	// The instance type to use when launching fleet instances. The following instance
	// types are available:
	//
	//    * stream.standard.medium
	//
	//    * stream.standard.large
	//
	//    * stream.compute.large
	//
	//    * stream.compute.xlarge
	//
	//    * stream.compute.2xlarge
	//
	//    * stream.compute.4xlarge
	//
	//    * stream.compute.8xlarge
	//
	//    * stream.memory.large
	//
	//    * stream.memory.xlarge
	//
	//    * stream.memory.2xlarge
	//
	//    * stream.memory.4xlarge
	//
	//    * stream.memory.8xlarge
	//
	//    * stream.graphics-design.large
	//
	//    * stream.graphics-design.xlarge
	//
	//    * stream.graphics-design.2xlarge
	//
	//    * stream.graphics-design.4xlarge
	//
	//    * stream.graphics-desktop.2xlarge
	//
	//    * stream.graphics-pro.4xlarge
	//
	//    * stream.graphics-pro.8xlarge
	//
	//    * stream.graphics-pro.16xlarge
	InstanceType *string `min:"1" type:"string"`

	// The maximum amount of time that a streaming session can remain active, in
	// seconds. If users are still connected to a streaming instance five minutes
	// before this limit is reached, they are prompted to save any open documents
	// before being disconnected. After this time elapses, the instance is terminated
	// and replaced by a new instance.
	//
	// Specify a value between 600 and 360000.
	MaxUserDurationInSeconds *int64 `type:"integer"`

	// A unique name for the fleet.
	Name *string `min:"1" type:"string"`

	// The VPC configuration for the fleet.
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateFleetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateFleetInput"}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ImageName", 1))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InstanceType", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if s.ComputeCapacity != nil {
		if err := s.ComputeCapacity.Validate(); err != nil {
			invalidParams.AddNested("ComputeCapacity", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleetResult
type UpdateFleetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the fleet.
	Fleet *Fleet `type:"structure"`
}

// String returns the string representation
func (s UpdateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateFleet = "UpdateFleet"

// UpdateFleetRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Updates the specified fleet.
//
// If the fleet is in the STOPPED state, you can update any attribute except
// the fleet name. If the fleet is in the RUNNING state, you can update the
// DisplayName, ComputeCapacity, ImageARN, ImageName, and DisconnectTimeoutInSeconds
// attributes. If the fleet is in the STARTING or STOPPING state, you can't
// update it.
//
//    // Example sending a request using UpdateFleetRequest.
//    req := client.UpdateFleetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet
func (c *Client) UpdateFleetRequest(input *UpdateFleetInput) UpdateFleetRequest {
	op := &aws.Operation{
		Name:       opUpdateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateFleetInput{}
	}

	req := c.newRequest(op, input, &UpdateFleetOutput{})
	return UpdateFleetRequest{Request: req, Input: input, Copy: c.UpdateFleetRequest}
}

// UpdateFleetRequest is the request type for the
// UpdateFleet API operation.
type UpdateFleetRequest struct {
	*aws.Request
	Input *UpdateFleetInput
	Copy  func(*UpdateFleetInput) UpdateFleetRequest
}

// Send marshals and sends the UpdateFleet API request.
func (r UpdateFleetRequest) Send(ctx context.Context) (*UpdateFleetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateFleetResponse{
		UpdateFleetOutput: r.Request.Data.(*UpdateFleetOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateFleetResponse is the response type for the
// UpdateFleet API operation.
type UpdateFleetResponse struct {
	*UpdateFleetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateFleet request.
func (r *UpdateFleetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
