// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycleMessage
type UpdateApplicationResourceLifecycleInput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// The lifecycle configuration.
	//
	// ResourceLifecycleConfig is a required field
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationResourceLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationResourceLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateApplicationResourceLifecycleInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.ResourceLifecycleConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceLifecycleConfig"))
	}
	if s.ResourceLifecycleConfig != nil {
		if err := s.ResourceLifecycleConfig.Validate(); err != nil {
			invalidParams.AddNested("ResourceLifecycleConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ApplicationResourceLifecycleDescriptionMessage
type UpdateApplicationResourceLifecycleOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application.
	ApplicationName *string `min:"1" type:"string"`

	// The lifecycle configuration.
	ResourceLifecycleConfig *ApplicationResourceLifecycleConfig `type:"structure"`
}

// String returns the string representation
func (s UpdateApplicationResourceLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateApplicationResourceLifecycle = "UpdateApplicationResourceLifecycle"

// UpdateApplicationResourceLifecycleRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Modifies lifecycle settings for an application.
//
//    // Example sending a request using UpdateApplicationResourceLifecycleRequest.
//    req := client.UpdateApplicationResourceLifecycleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/UpdateApplicationResourceLifecycle
func (c *Client) UpdateApplicationResourceLifecycleRequest(input *UpdateApplicationResourceLifecycleInput) UpdateApplicationResourceLifecycleRequest {
	op := &aws.Operation{
		Name:       opUpdateApplicationResourceLifecycle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationResourceLifecycleInput{}
	}

	req := c.newRequest(op, input, &UpdateApplicationResourceLifecycleOutput{})
	return UpdateApplicationResourceLifecycleRequest{Request: req, Input: input, Copy: c.UpdateApplicationResourceLifecycleRequest}
}

// UpdateApplicationResourceLifecycleRequest is the request type for the
// UpdateApplicationResourceLifecycle API operation.
type UpdateApplicationResourceLifecycleRequest struct {
	*aws.Request
	Input *UpdateApplicationResourceLifecycleInput
	Copy  func(*UpdateApplicationResourceLifecycleInput) UpdateApplicationResourceLifecycleRequest
}

// Send marshals and sends the UpdateApplicationResourceLifecycle API request.
func (r UpdateApplicationResourceLifecycleRequest) Send(ctx context.Context) (*UpdateApplicationResourceLifecycleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateApplicationResourceLifecycleResponse{
		UpdateApplicationResourceLifecycleOutput: r.Request.Data.(*UpdateApplicationResourceLifecycleOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateApplicationResourceLifecycleResponse is the response type for the
// UpdateApplicationResourceLifecycle API operation.
type UpdateApplicationResourceLifecycleResponse struct {
	*UpdateApplicationResourceLifecycleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateApplicationResourceLifecycle request.
func (r *UpdateApplicationResourceLifecycleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
