// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To add tags to a load balancer
//
// This example adds the specified tags to the specified load balancer.
func ExampleClient_AddTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.AddTagsInput{
		ResourceArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
		},
		Tags: []elasticloadbalancingv2.Tag{
			{
				Key:   aws.String("project"),
				Value: aws.String("lima"),
			},
			{
				Key:   aws.String("department"),
				Value: aws.String("digital-media"),
			},
		},
	}

	req := svc.AddTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTP listener
//
// This example creates an HTTP listener for the specified load balancer that forwards
// requests to the specified target group.
func ExampleClient_CreateListenerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.CreateListenerInput{
		DefaultActions: []elasticloadbalancingv2.Action{
			{
				TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
				Type:           elasticloadbalancingv2.ActionTypeEnumForward,
			},
		},
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
		Port:            aws.Int64(80),
		Protocol:        elasticloadbalancingv2.ProtocolEnumHttp,
	}

	req := svc.CreateListenerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateListenerException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateListenerException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyListenersException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyListenersException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyCertificatesException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyCertificatesException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyActionsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyActionsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an HTTPS listener
//
// This example creates an HTTPS listener for the specified load balancer that forwards
// requests to the specified target group. Note that you must specify an SSL certificate
// for an HTTPS listener. You can create and manage certificates using AWS Certificate
// Manager (ACM). Alternatively, you can create a certificate using SSL/TLS tools, get
// the certificate signed by a certificate authority (CA), and upload the certificate
// to AWS Identity and Access Management (IAM).
func ExampleClient_CreateListenerRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.CreateListenerInput{
		Certificates: []elasticloadbalancingv2.Certificate{
			{
				CertificateArn: aws.String("arn:aws:iam::123456789012:server-certificate/my-server-cert"),
			},
		},
		DefaultActions: []elasticloadbalancingv2.Action{
			{
				TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
				Type:           elasticloadbalancingv2.ActionTypeEnumForward,
			},
		},
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
		Port:            aws.Int64(443),
		Protocol:        elasticloadbalancingv2.ProtocolEnumHttps,
		SslPolicy:       aws.String("ELBSecurityPolicy-2015-05"),
	}

	req := svc.CreateListenerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateListenerException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateListenerException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyListenersException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyListenersException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyCertificatesException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyCertificatesException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyActionsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyActionsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an Internet-facing load balancer
//
// This example creates an Internet-facing load balancer and enables the Availability
// Zones for the specified subnets.
func ExampleClient_CreateLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.CreateLoadBalancerInput{
		Name: aws.String("my-load-balancer"),
		Subnets: []string{
			"subnet-b7d581c0",
			"subnet-8360a9e7",
		},
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateLoadBalancerNameException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateLoadBalancerNameException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyLoadBalancersException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyLoadBalancersException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeResourceInUseException:
				fmt.Println(elasticloadbalancingv2.ErrCodeResourceInUseException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeAllocationIdNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeAllocationIdNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeAvailabilityZoneNotSupportedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeAvailabilityZoneNotSupportedException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create an internal load balancer
//
// This example creates an internal load balancer and enables the Availability Zones
// for the specified subnets.
func ExampleClient_CreateLoadBalancerRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.CreateLoadBalancerInput{
		Name:   aws.String("my-internal-load-balancer"),
		Scheme: elasticloadbalancingv2.LoadBalancerSchemeEnumInternal,
		Subnets: []string{
			"subnet-b7d581c0",
			"subnet-8360a9e7",
		},
	}

	req := svc.CreateLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateLoadBalancerNameException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateLoadBalancerNameException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyLoadBalancersException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyLoadBalancersException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSecurityGroupException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSchemeException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSchemeException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTagsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeDuplicateTagKeysException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateTagKeysException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeResourceInUseException:
				fmt.Println(elasticloadbalancingv2.ErrCodeResourceInUseException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeAllocationIdNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeAllocationIdNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeAvailabilityZoneNotSupportedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeAvailabilityZoneNotSupportedException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a rule
//
// This example creates a rule that forwards requests to the specified target group
// if the URL contains the specified pattern (for example, /img/*).
func ExampleClient_CreateRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.CreateRuleInput{
		Actions: []elasticloadbalancingv2.Action{
			{
				TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
				Type:           elasticloadbalancingv2.ActionTypeEnumForward,
			},
		},
		Conditions: []elasticloadbalancingv2.RuleCondition{
			{
				Field: aws.String("path-pattern"),
				Values: []string{
					"/img/*",
				},
			},
		},
		ListenerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2"),
		Priority:    aws.Int64(10),
	}

	req := svc.CreateRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodePriorityInUseException:
				fmt.Println(elasticloadbalancingv2.ErrCodePriorityInUseException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetGroupsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetGroupsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRulesException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRulesException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyActionsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyActionsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To create a target group
//
// This example creates a target group that you can use to route traffic to targets
// using HTTP on port 80. This target group uses the default health check configuration.
func ExampleClient_CreateTargetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.CreateTargetGroupInput{
		Name:     aws.String("my-targets"),
		Port:     aws.Int64(80),
		Protocol: elasticloadbalancingv2.ProtocolEnumHttp,
		VpcId:    aws.String("vpc-3ac0fb5f"),
	}

	req := svc.CreateTargetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateTargetGroupNameException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateTargetGroupNameException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetGroupsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetGroupsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a listener
//
// This example deletes the specified listener.
func ExampleClient_DeleteListenerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DeleteListenerInput{
		ListenerArn: aws.String("arn:aws:elasticloadbalancing:ua-west-2:123456789012:listener/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2"),
	}

	req := svc.DeleteListenerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a load balancer
//
// This example deletes the specified load balancer.
func ExampleClient_DeleteLoadBalancerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DeleteLoadBalancerInput{
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
	}

	req := svc.DeleteLoadBalancerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeOperationNotPermittedException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeResourceInUseException:
				fmt.Println(elasticloadbalancingv2.ErrCodeResourceInUseException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a rule
//
// This example deletes the specified rule.
func ExampleClient_DeleteRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DeleteRuleInput{
		RuleArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2/1291d13826f405c3"),
	}

	req := svc.DeleteRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeRuleNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeRuleNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To delete a target group
//
// This example deletes the specified target group.
func ExampleClient_DeleteTargetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DeleteTargetGroupInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
	}

	req := svc.DeleteTargetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeResourceInUseException:
				fmt.Println(elasticloadbalancingv2.ErrCodeResourceInUseException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To deregister a target from a target group
//
// This example deregisters the specified instance from the specified target group.
func ExampleClient_DeregisterTargetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DeregisterTargetsInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
		Targets: []elasticloadbalancingv2.TargetDescription{
			{
				Id: aws.String("i-0f76fade"),
			},
		},
	}

	req := svc.DeregisterTargetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidTargetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidTargetException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a listener
//
// This example describes the specified listener.
func ExampleClient_DescribeListenersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeListenersInput{
		ListenerArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2",
		},
	}

	req := svc.DescribeListenersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe load balancer attributes
//
// This example describes the attributes of the specified load balancer.
func ExampleClient_DescribeLoadBalancerAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeLoadBalancerAttributesInput{
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
	}

	req := svc.DescribeLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a load balancer
//
// This example describes the specified load balancer.
func ExampleClient_DescribeLoadBalancersRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeLoadBalancersInput{
		LoadBalancerArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
		},
	}

	req := svc.DescribeLoadBalancersRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a rule
//
// This example describes the specified rule.
func ExampleClient_DescribeRulesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeRulesInput{
		RuleArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2/9683b2d02a6cabee",
		},
	}

	req := svc.DescribeRulesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeRuleNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeRuleNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a policy used for SSL negotiation
//
// This example describes the specified policy used for SSL negotiation.
func ExampleClient_DescribeSSLPoliciesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeSSLPoliciesInput{
		Names: []string{
			"ELBSecurityPolicy-2015-05",
		},
	}

	req := svc.DescribeSSLPoliciesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the tags assigned to a load balancer
//
// This example describes the tags assigned to the specified load balancer.
func ExampleClient_DescribeTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeTagsInput{
		ResourceArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
		},
	}

	req := svc.DescribeTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeRuleNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeRuleNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe target group attributes
//
// This example describes the attributes of the specified target group.
func ExampleClient_DescribeTargetGroupAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeTargetGroupAttributesInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
	}

	req := svc.DescribeTargetGroupAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe a target group
//
// This example describes the specified target group.
func ExampleClient_DescribeTargetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeTargetGroupsInput{
		TargetGroupArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067",
		},
	}

	req := svc.DescribeTargetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the health of the targets for a target group
//
// This example describes the health of the targets for the specified target group.
// One target is healthy but the other is not specified in an action, so it can't receive
// traffic from the load balancer.
func ExampleClient_DescribeTargetHealthRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeTargetHealthInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
	}

	req := svc.DescribeTargetHealthRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeInvalidTargetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidTargetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeHealthUnavailableException:
				fmt.Println(elasticloadbalancingv2.ErrCodeHealthUnavailableException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To describe the health of a target
//
// This example describes the health of the specified target. This target is healthy.
func ExampleClient_DescribeTargetHealthRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.DescribeTargetHealthInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
		Targets: []elasticloadbalancingv2.TargetDescription{
			{
				Id:   aws.String("i-0f76fade"),
				Port: aws.Int64(80),
			},
		},
	}

	req := svc.DescribeTargetHealthRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeInvalidTargetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidTargetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeHealthUnavailableException:
				fmt.Println(elasticloadbalancingv2.ErrCodeHealthUnavailableException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the default action for a listener
//
// This example changes the default action for the specified listener.
func ExampleClient_ModifyListenerRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyListenerInput{
		DefaultActions: []elasticloadbalancingv2.Action{
			{
				TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-new-targets/2453ed029918f21f"),
				Type:           elasticloadbalancingv2.ActionTypeEnumForward,
			},
		},
		ListenerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2"),
	}

	req := svc.ModifyListenerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateListenerException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateListenerException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyListenersException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyListenersException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyCertificatesException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyCertificatesException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyActionsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyActionsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the server certificate
//
// This example changes the server certificate for the specified HTTPS listener.
func ExampleClient_ModifyListenerRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyListenerInput{
		Certificates: []elasticloadbalancingv2.Certificate{
			{
				CertificateArn: aws.String("arn:aws:iam::123456789012:server-certificate/my-new-server-cert"),
			},
		},
		ListenerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:listener/app/my-load-balancer/50dc6c495c0c9188/0467ef3c8400ae65"),
	}

	req := svc.ModifyListenerRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeDuplicateListenerException:
				fmt.Println(elasticloadbalancingv2.ErrCodeDuplicateListenerException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyListenersException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyListenersException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyCertificatesException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyCertificatesException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSSLPolicyNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeCertificateNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeCertificateNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyActionsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyActionsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable deletion protection
//
// This example enables deletion protection for the specified load balancer.
func ExampleClient_ModifyLoadBalancerAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyLoadBalancerAttributesInput{
		Attributes: []elasticloadbalancingv2.LoadBalancerAttribute{
			{
				Key:   aws.String("deletion_protection.enabled"),
				Value: aws.String("true"),
			},
		},
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
	}

	req := svc.ModifyLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To change the idle timeout
//
// This example changes the idle timeout value for the specified load balancer.
func ExampleClient_ModifyLoadBalancerAttributesRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyLoadBalancerAttributesInput{
		Attributes: []elasticloadbalancingv2.LoadBalancerAttribute{
			{
				Key:   aws.String("idle_timeout.timeout_seconds"),
				Value: aws.String("30"),
			},
		},
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
	}

	req := svc.ModifyLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable access logs
//
// This example enables access logs for the specified load balancer. Note that the S3
// bucket must exist in the same region as the load balancer and must have a policy
// attached that grants access to the Elastic Load Balancing service.
func ExampleClient_ModifyLoadBalancerAttributesRequest_shared02() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyLoadBalancerAttributesInput{
		Attributes: []elasticloadbalancingv2.LoadBalancerAttribute{
			{
				Key:   aws.String("access_logs.s3.enabled"),
				Value: aws.String("true"),
			},
			{
				Key:   aws.String("access_logs.s3.bucket"),
				Value: aws.String("my-loadbalancer-logs"),
			},
			{
				Key:   aws.String("access_logs.s3.prefix"),
				Value: aws.String("myapp"),
			},
		},
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
	}

	req := svc.ModifyLoadBalancerAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify a rule
//
// This example modifies the condition for the specified rule.
func ExampleClient_ModifyRuleRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyRuleInput{
		Conditions: []elasticloadbalancingv2.RuleCondition{
			{
				Field: aws.String("path-pattern"),
				Values: []string{
					"/images/*",
				},
			},
		},
		RuleArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2/9683b2d02a6cabee"),
	}

	req := svc.ModifyRuleRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupAssociationLimitException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeIncompatibleProtocolsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeRuleNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeRuleNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeOperationNotPermittedException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeUnsupportedProtocolException:
				fmt.Println(elasticloadbalancingv2.ErrCodeUnsupportedProtocolException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyActionsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyActionsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidLoadBalancerActionException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the health check configuration for a target group
//
// This example changes the configuration of the health checks used to evaluate the
// health of the targets for the specified target group.
func ExampleClient_ModifyTargetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyTargetGroupInput{
		HealthCheckPort:     aws.String("443"),
		HealthCheckProtocol: elasticloadbalancingv2.ProtocolEnumHttps,
		TargetGroupArn:      aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-https-targets/2453ed029918f21f"),
	}

	req := svc.ModifyTargetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To modify the deregistration delay timeout
//
// This example sets the deregistration delay timeout to the specified value for the
// specified target group.
func ExampleClient_ModifyTargetGroupAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.ModifyTargetGroupAttributesInput{
		Attributes: []elasticloadbalancingv2.TargetGroupAttribute{
			{
				Key:   aws.String("deregistration_delay.timeout_seconds"),
				Value: aws.String("600"),
			},
		},
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
	}

	req := svc.ModifyTargetGroupAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To register targets with a target group
//
// This example registers the specified instances with the specified target group.
func ExampleClient_RegisterTargetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.RegisterTargetsInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targets/73e2d6bc24d8a067"),
		Targets: []elasticloadbalancingv2.TargetDescription{
			{
				Id: aws.String("i-80c8dd94"),
			},
			{
				Id: aws.String("i-ceddcd4d"),
			},
		},
	}

	req := svc.RegisterTargetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidTargetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidTargetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To register targets with a target group using port overrides
//
// This example registers the specified instance with the specified target group using
// multiple ports. This enables you to register ECS containers on the same instance
// as targets in the target group.
func ExampleClient_RegisterTargetsRequest_shared01() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.RegisterTargetsInput{
		TargetGroupArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-new-targets/3bb63f11dfb0faf9"),
		Targets: []elasticloadbalancingv2.TargetDescription{
			{
				Id:   aws.String("i-80c8dd94"),
				Port: aws.Int64(80),
			},
			{
				Id:   aws.String("i-80c8dd94"),
				Port: aws.Int64(766),
			},
		},
	}

	req := svc.RegisterTargetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTargetsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTargetsException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidTargetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidTargetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyRegistrationsForTargetIdException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To remove tags from a load balancer
//
// This example removes the specified tags from the specified load balancer.
func ExampleClient_RemoveTagsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.RemoveTagsInput{
		ResourceArns: []string{
			"arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188",
		},
		TagKeys: []string{
			"project",
			"department",
		},
	}

	req := svc.RemoveTagsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTargetGroupNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeListenerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeListenerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeRuleNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeRuleNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeTooManyTagsException:
				fmt.Println(elasticloadbalancingv2.ErrCodeTooManyTagsException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To set the rule priority
//
// This example sets the priority of the specified rule.
func ExampleClient_SetRulePrioritiesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.SetRulePrioritiesInput{
		RulePriorities: []elasticloadbalancingv2.RulePriorityPair{
			{
				Priority: aws.Int64(5),
				RuleArn:  aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:listener-rule/app/my-load-balancer/50dc6c495c0c9188/f2f7dc8efc522ab2/1291d13826f405c3"),
			},
		},
	}

	req := svc.SetRulePrioritiesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeRuleNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeRuleNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodePriorityInUseException:
				fmt.Println(elasticloadbalancingv2.ErrCodePriorityInUseException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeOperationNotPermittedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeOperationNotPermittedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To associate a security group with a load balancer
//
// This example associates the specified security group with the specified load balancer.
func ExampleClient_SetSecurityGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.SetSecurityGroupsInput{
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
		SecurityGroups: []string{
			"sg-5943793c",
		},
	}

	req := svc.SetSecurityGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSecurityGroupException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSecurityGroupException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// To enable Availability Zones for a load balancer
//
// This example enables the Availability Zones for the specified subnets for the specified
// load balancer.
func ExampleClient_SetSubnetsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := elasticloadbalancingv2.New(cfg)
	input := &elasticloadbalancingv2.SetSubnetsInput{
		LoadBalancerArn: aws.String("arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/50dc6c495c0c9188"),
		Subnets: []string{
			"subnet-8360a9e7",
			"subnet-b7d581c0",
		},
	}

	req := svc.SetSubnetsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeLoadBalancerNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidConfigurationRequestException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeSubnetNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeSubnetNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeInvalidSubnetException:
				fmt.Println(elasticloadbalancingv2.ErrCodeInvalidSubnetException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeAllocationIdNotFoundException:
				fmt.Println(elasticloadbalancingv2.ErrCodeAllocationIdNotFoundException, aerr.Error())
			case elasticloadbalancingv2.ErrCodeAvailabilityZoneNotSupportedException:
				fmt.Println(elasticloadbalancingv2.ErrCodeAvailabilityZoneNotSupportedException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
