// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStreamInput
type DeleteDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteDeliveryStreamInput"}

	if s.DeliveryStreamName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStreamOutput
type DeleteDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteDeliveryStream = "DeleteDeliveryStream"

// DeleteDeliveryStreamRequest returns a request value for making API operation for
// Amazon Kinesis Firehose.
//
// Deletes a delivery stream and its data.
//
// You can delete a delivery stream only if it is in ACTIVE or DELETING state,
// and not in the CREATING state. While the deletion request is in process,
// the delivery stream is in the DELETING state.
//
// To check the state of a delivery stream, use DescribeDeliveryStream.
//
// While the delivery stream is DELETING state, the service might continue to
// accept the records, but it doesn't make any guarantees with respect to delivering
// the data. Therefore, as a best practice, you should first stop any applications
// that are sending records before deleting a delivery stream.
//
//    // Example sending a request using DeleteDeliveryStreamRequest.
//    req := client.DeleteDeliveryStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStream
func (c *Client) DeleteDeliveryStreamRequest(input *DeleteDeliveryStreamInput) DeleteDeliveryStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryStreamInput{}
	}

	req := c.newRequest(op, input, &DeleteDeliveryStreamOutput{})
	return DeleteDeliveryStreamRequest{Request: req, Input: input, Copy: c.DeleteDeliveryStreamRequest}
}

// DeleteDeliveryStreamRequest is the request type for the
// DeleteDeliveryStream API operation.
type DeleteDeliveryStreamRequest struct {
	*aws.Request
	Input *DeleteDeliveryStreamInput
	Copy  func(*DeleteDeliveryStreamInput) DeleteDeliveryStreamRequest
}

// Send marshals and sends the DeleteDeliveryStream API request.
func (r DeleteDeliveryStreamRequest) Send(ctx context.Context) (*DeleteDeliveryStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteDeliveryStreamResponse{
		DeleteDeliveryStreamOutput: r.Request.Data.(*DeleteDeliveryStreamOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteDeliveryStreamResponse is the response type for the
// DeleteDeliveryStream API operation.
type DeleteDeliveryStreamResponse struct {
	*DeleteDeliveryStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteDeliveryStream request.
func (r *DeleteDeliveryStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
