// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionRequest
type DeletePartitionInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Data Catalog where the partition to be deleted resides. If
	// none is supplied, the AWS account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// The name of the catalog database in which the table in question resides.
	//
	// DatabaseName is a required field
	DatabaseName *string `min:"1" type:"string" required:"true"`

	// The values that define the partition.
	//
	// PartitionValues is a required field
	PartitionValues []string `type:"list" required:"true"`

	// The name of the table where the partition to be deleted is located.
	//
	// TableName is a required field
	TableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePartitionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePartitionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeletePartitionInput"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CatalogId", 1))
	}

	if s.DatabaseName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DatabaseName"))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DatabaseName", 1))
	}

	if s.PartitionValues == nil {
		invalidParams.Add(aws.NewErrParamRequired("PartitionValues"))
	}

	if s.TableName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TableName"))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartitionResponse
type DeletePartitionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePartitionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeletePartition = "DeletePartition"

// DeletePartitionRequest returns a request value for making API operation for
// AWS Glue.
//
// Deletes a specified partition.
//
//    // Example sending a request using DeletePartitionRequest.
//    req := client.DeletePartitionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/DeletePartition
func (c *Client) DeletePartitionRequest(input *DeletePartitionInput) DeletePartitionRequest {
	op := &aws.Operation{
		Name:       opDeletePartition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePartitionInput{}
	}

	req := c.newRequest(op, input, &DeletePartitionOutput{})
	return DeletePartitionRequest{Request: req, Input: input, Copy: c.DeletePartitionRequest}
}

// DeletePartitionRequest is the request type for the
// DeletePartition API operation.
type DeletePartitionRequest struct {
	*aws.Request
	Input *DeletePartitionInput
	Copy  func(*DeletePartitionInput) DeletePartitionRequest
}

// Send marshals and sends the DeletePartition API request.
func (r DeletePartitionRequest) Send(ctx context.Context) (*DeletePartitionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeletePartitionResponse{
		DeletePartitionOutput: r.Request.Data.(*DeletePartitionOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeletePartitionResponse is the response type for the
// DeletePartition API operation.
type DeletePartitionResponse struct {
	*DeletePartitionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeletePartition request.
func (r *DeletePartitionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
