// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersionRequest
type CreateFunctionDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// The default configuration that applies to all Lambda functions in the group.
	// Individual Lambda functions can override these settings.
	DefaultConfig *FunctionDefaultConfig `type:"structure"`

	// FunctionDefinitionId is a required field
	FunctionDefinitionId *string `location:"uri" locationName:"FunctionDefinitionId" type:"string" required:"true"`

	Functions []Function `type:"list"`
}

// String returns the string representation
func (s CreateFunctionDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFunctionDefinitionVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateFunctionDefinitionVersionInput"}

	if s.FunctionDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FunctionDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFunctionDefinitionVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.DefaultConfig != nil {
		v := s.DefaultConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultConfig", v, metadata)
	}
	if len(s.Functions) > 0 {
		v := s.Functions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Functions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AmznClientToken != nil {
		v := *s.AmznClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amzn-Client-Token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionDefinitionId != nil {
		v := *s.FunctionDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "FunctionDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersionResponse
type CreateFunctionDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateFunctionDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateFunctionDefinitionVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateFunctionDefinitionVersion = "CreateFunctionDefinitionVersion"

// CreateFunctionDefinitionVersionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Creates a version of a Lambda function definition that has already been defined.
//
//    // Example sending a request using CreateFunctionDefinitionVersionRequest.
//    req := client.CreateFunctionDefinitionVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateFunctionDefinitionVersion
func (c *Client) CreateFunctionDefinitionVersionRequest(input *CreateFunctionDefinitionVersionInput) CreateFunctionDefinitionVersionRequest {
	op := &aws.Operation{
		Name:       opCreateFunctionDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/functions/{FunctionDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateFunctionDefinitionVersionInput{}
	}

	req := c.newRequest(op, input, &CreateFunctionDefinitionVersionOutput{})
	return CreateFunctionDefinitionVersionRequest{Request: req, Input: input, Copy: c.CreateFunctionDefinitionVersionRequest}
}

// CreateFunctionDefinitionVersionRequest is the request type for the
// CreateFunctionDefinitionVersion API operation.
type CreateFunctionDefinitionVersionRequest struct {
	*aws.Request
	Input *CreateFunctionDefinitionVersionInput
	Copy  func(*CreateFunctionDefinitionVersionInput) CreateFunctionDefinitionVersionRequest
}

// Send marshals and sends the CreateFunctionDefinitionVersion API request.
func (r CreateFunctionDefinitionVersionRequest) Send(ctx context.Context) (*CreateFunctionDefinitionVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateFunctionDefinitionVersionResponse{
		CreateFunctionDefinitionVersionOutput: r.Request.Data.(*CreateFunctionDefinitionVersionOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateFunctionDefinitionVersionResponse is the response type for the
// CreateFunctionDefinitionVersion API operation.
type CreateFunctionDefinitionVersionResponse struct {
	*CreateFunctionDefinitionVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateFunctionDefinitionVersion request.
func (r *CreateFunctionDefinitionVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
