// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package inspector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplateRequest
type DeleteAssessmentTemplateInput struct {
	_ struct{} `type:"structure"`

	// The ARN that specifies the assessment template that you want to delete.
	//
	// AssessmentTemplateArn is a required field
	AssessmentTemplateArn *string `locationName:"assessmentTemplateArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAssessmentTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAssessmentTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAssessmentTemplateInput"}

	if s.AssessmentTemplateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AssessmentTemplateArn"))
	}
	if s.AssessmentTemplateArn != nil && len(*s.AssessmentTemplateArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AssessmentTemplateArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplateOutput
type DeleteAssessmentTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteAssessmentTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAssessmentTemplate = "DeleteAssessmentTemplate"

// DeleteAssessmentTemplateRequest returns a request value for making API operation for
// Amazon Inspector.
//
// Deletes the assessment template that is specified by the ARN of the assessment
// template.
//
//    // Example sending a request using DeleteAssessmentTemplateRequest.
//    req := client.DeleteAssessmentTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/inspector-2016-02-16/DeleteAssessmentTemplate
func (c *Client) DeleteAssessmentTemplateRequest(input *DeleteAssessmentTemplateInput) DeleteAssessmentTemplateRequest {
	op := &aws.Operation{
		Name:       opDeleteAssessmentTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAssessmentTemplateInput{}
	}

	req := c.newRequest(op, input, &DeleteAssessmentTemplateOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteAssessmentTemplateRequest{Request: req, Input: input, Copy: c.DeleteAssessmentTemplateRequest}
}

// DeleteAssessmentTemplateRequest is the request type for the
// DeleteAssessmentTemplate API operation.
type DeleteAssessmentTemplateRequest struct {
	*aws.Request
	Input *DeleteAssessmentTemplateInput
	Copy  func(*DeleteAssessmentTemplateInput) DeleteAssessmentTemplateRequest
}

// Send marshals and sends the DeleteAssessmentTemplate API request.
func (r DeleteAssessmentTemplateRequest) Send(ctx context.Context) (*DeleteAssessmentTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAssessmentTemplateResponse{
		DeleteAssessmentTemplateOutput: r.Request.Data.(*DeleteAssessmentTemplateOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAssessmentTemplateResponse is the response type for the
// DeleteAssessmentTemplate API operation.
type DeleteAssessmentTemplateResponse struct {
	*DeleteAssessmentTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAssessmentTemplate request.
func (r *DeleteAssessmentTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
