// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package licensemanager

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfigurationRequest
type UpdateLicenseConfigurationInput struct {
	_ struct{} `type:"structure"`

	// New human-friendly description of the license configuration.
	Description *string `type:"string"`

	// ARN for a license configuration.
	//
	// LicenseConfigurationArn is a required field
	LicenseConfigurationArn *string `type:"string" required:"true"`

	// New status of the license configuration (ACTIVE or INACTIVE).
	LicenseConfigurationStatus LicenseConfigurationStatus `type:"string" enum:"true"`

	// New number of licenses managed by the license configuration.
	LicenseCount *int64 `type:"long"`

	// Sets the number of available licenses as a hard limit.
	LicenseCountHardLimit *bool `type:"boolean"`

	// List of flexible text strings designating license rules.
	LicenseRules []string `type:"list"`

	// New name of the license configuration.
	Name *string `type:"string"`
}

// String returns the string representation
func (s UpdateLicenseConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLicenseConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateLicenseConfigurationInput"}

	if s.LicenseConfigurationArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("LicenseConfigurationArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfigurationResponse
type UpdateLicenseConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLicenseConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateLicenseConfiguration = "UpdateLicenseConfiguration"

// UpdateLicenseConfigurationRequest returns a request value for making API operation for
// AWS License Manager.
//
// Modifies the attributes of an existing license configuration object. A license
// configuration is an abstraction of a customer license agreement that can
// be consumed and enforced by License Manager. Components include specifications
// for the license type (Instances, cores, sockets, VCPUs), tenancy (shared
// or Dedicated Host), host affinity (how long a VM is associated with a host),
// the number of licenses purchased and used.
//
//    // Example sending a request using UpdateLicenseConfigurationRequest.
//    req := client.UpdateLicenseConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/license-manager-2018-08-01/UpdateLicenseConfiguration
func (c *Client) UpdateLicenseConfigurationRequest(input *UpdateLicenseConfigurationInput) UpdateLicenseConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateLicenseConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateLicenseConfigurationInput{}
	}

	req := c.newRequest(op, input, &UpdateLicenseConfigurationOutput{})
	return UpdateLicenseConfigurationRequest{Request: req, Input: input, Copy: c.UpdateLicenseConfigurationRequest}
}

// UpdateLicenseConfigurationRequest is the request type for the
// UpdateLicenseConfiguration API operation.
type UpdateLicenseConfigurationRequest struct {
	*aws.Request
	Input *UpdateLicenseConfigurationInput
	Copy  func(*UpdateLicenseConfigurationInput) UpdateLicenseConfigurationRequest
}

// Send marshals and sends the UpdateLicenseConfiguration API request.
func (r UpdateLicenseConfigurationRequest) Send(ctx context.Context) (*UpdateLicenseConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateLicenseConfigurationResponse{
		UpdateLicenseConfigurationOutput: r.Request.Data.(*UpdateLicenseConfigurationOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateLicenseConfigurationResponse is the response type for the
// UpdateLicenseConfiguration API operation.
type UpdateLicenseConfigurationResponse struct {
	*UpdateLicenseConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateLicenseConfiguration request.
func (r *UpdateLicenseConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
