// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pricing

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// The values of a given attribute, such as Throughput Optimized HDD or Provisioned
// IOPS for the Amazon EC2 volumeType attribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/AttributeValue
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// The specific value of an attributeName.
	Value *string `type:"string"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// The constraints that you want all returned products to match.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/Filter
type Filter struct {
	_ struct{} `type:"structure"`

	// The product metadata field that you want to filter on. You can filter by
	// just the service code to see all products for a specific service, filter
	// by just the attribute name to see a specific attribute for multiple services,
	// or use both a service code and an attribute name to retrieve only products
	// that match both fields.
	//
	// Valid values include: ServiceCode, and all attribute names
	//
	// For example, you can filter by the AmazonEC2 service code and the volumeType
	// attribute name to get the prices for only Amazon EC2 volumes.
	//
	// Field is a required field
	Field *string `type:"string" required:"true"`

	// The type of filter that you want to use.
	//
	// Valid values are: TERM_MATCH. TERM_MATCH returns only products that match
	// both the given filter field and the given value.
	//
	// Type is a required field
	Type FilterType `type:"string" required:"true" enum:"true"`

	// The service code or attribute value that you want to filter by. If you are
	// filtering by service code this is the actual service code, such as AmazonEC2.
	// If you are filtering by attribute name, this is the attribute value that
	// you want the returned products to match, such as a Provisioned IOPS volume.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Filter"}

	if s.Field == nil {
		invalidParams.Add(aws.NewErrParamRequired("Field"))
	}
	if len(s.Type) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The metadata for a service, such as the service code and available attribute
// names.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/Service
type Service struct {
	_ struct{} `type:"structure"`

	// The attributes that are available for this service.
	AttributeNames []string `type:"list"`

	// The code for the AWS service.
	ServiceCode *string `type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}
