// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackagesInput
type ListModelPackagesInput struct {
	_ struct{} `type:"structure"`

	// A filter that returns only model packages created after the specified time
	// (timestamp).
	CreationTimeAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A filter that returns only model packages created before the specified time
	// (timestamp).
	CreationTimeBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The maximum number of model packages to return in the response.
	MaxResults *int64 `min:"1" type:"integer"`

	// A string in the model package name. This filter returns only model packages
	// whose name contains the specified string.
	NameContains *string `type:"string"`

	// If the response to a previous ListModelPackages request was truncated, the
	// response includes a NextToken. To retrieve the next set of model packages,
	// use the token in the next request.
	NextToken *string `type:"string"`

	// The parameter by which to sort the results. The default is CreationTime.
	SortBy ModelPackageSortBy `type:"string" enum:"true"`

	// The sort order for the results. The default is Ascending.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListModelPackagesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelPackagesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListModelPackagesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackagesOutput
type ListModelPackagesOutput struct {
	_ struct{} `type:"structure"`

	// An array of ModelPackageSummary objects, each of which lists a model package.
	//
	// ModelPackageSummaryList is a required field
	ModelPackageSummaryList []ModelPackageSummary `type:"list" required:"true"`

	// If the response is truncated, Amazon SageMaker returns this token. To retrieve
	// the next set of model packages, use it in the subsequent request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListModelPackagesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListModelPackages = "ListModelPackages"

// ListModelPackagesRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Lists the model packages that have been created.
//
//    // Example sending a request using ListModelPackagesRequest.
//    req := client.ListModelPackagesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/ListModelPackages
func (c *Client) ListModelPackagesRequest(input *ListModelPackagesInput) ListModelPackagesRequest {
	op := &aws.Operation{
		Name:       opListModelPackages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListModelPackagesInput{}
	}

	req := c.newRequest(op, input, &ListModelPackagesOutput{})
	return ListModelPackagesRequest{Request: req, Input: input, Copy: c.ListModelPackagesRequest}
}

// ListModelPackagesRequest is the request type for the
// ListModelPackages API operation.
type ListModelPackagesRequest struct {
	*aws.Request
	Input *ListModelPackagesInput
	Copy  func(*ListModelPackagesInput) ListModelPackagesRequest
}

// Send marshals and sends the ListModelPackages API request.
func (r ListModelPackagesRequest) Send(ctx context.Context) (*ListModelPackagesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListModelPackagesResponse{
		ListModelPackagesOutput: r.Request.Data.(*ListModelPackagesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListModelPackagesResponse is the response type for the
// ListModelPackages API operation.
type ListModelPackagesResponse struct {
	*ListModelPackagesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListModelPackages request.
func (r *ListModelPackagesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
