// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJobRequest
type StopHyperParameterTuningJobInput struct {
	_ struct{} `type:"structure"`

	// The name of the tuning job to stop.
	//
	// HyperParameterTuningJobName is a required field
	HyperParameterTuningJobName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopHyperParameterTuningJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopHyperParameterTuningJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopHyperParameterTuningJobInput"}

	if s.HyperParameterTuningJobName == nil {
		invalidParams.Add(aws.NewErrParamRequired("HyperParameterTuningJobName"))
	}
	if s.HyperParameterTuningJobName != nil && len(*s.HyperParameterTuningJobName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("HyperParameterTuningJobName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJobOutput
type StopHyperParameterTuningJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopHyperParameterTuningJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopHyperParameterTuningJob = "StopHyperParameterTuningJob"

// StopHyperParameterTuningJobRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Stops a running hyperparameter tuning job and all running training jobs that
// the tuning job launched.
//
// All model artifacts output from the training jobs are stored in Amazon Simple
// Storage Service (Amazon S3). All data that the training jobs write to Amazon
// CloudWatch Logs are still available in CloudWatch. After the tuning job moves
// to the Stopped state, it releases all reserved resources for the tuning job.
//
//    // Example sending a request using StopHyperParameterTuningJobRequest.
//    req := client.StopHyperParameterTuningJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/StopHyperParameterTuningJob
func (c *Client) StopHyperParameterTuningJobRequest(input *StopHyperParameterTuningJobInput) StopHyperParameterTuningJobRequest {
	op := &aws.Operation{
		Name:       opStopHyperParameterTuningJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopHyperParameterTuningJobInput{}
	}

	req := c.newRequest(op, input, &StopHyperParameterTuningJobOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return StopHyperParameterTuningJobRequest{Request: req, Input: input, Copy: c.StopHyperParameterTuningJobRequest}
}

// StopHyperParameterTuningJobRequest is the request type for the
// StopHyperParameterTuningJob API operation.
type StopHyperParameterTuningJobRequest struct {
	*aws.Request
	Input *StopHyperParameterTuningJobInput
	Copy  func(*StopHyperParameterTuningJobInput) StopHyperParameterTuningJobRequest
}

// Send marshals and sends the StopHyperParameterTuningJob API request.
func (r StopHyperParameterTuningJobRequest) Send(ctx context.Context) (*StopHyperParameterTuningJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopHyperParameterTuningJobResponse{
		StopHyperParameterTuningJobOutput: r.Request.Data.(*StopHyperParameterTuningJobOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopHyperParameterTuningJobResponse is the response type for the
// StopHyperParameterTuningJob API operation.
type StopHyperParameterTuningJobResponse struct {
	*StopHyperParameterTuningJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopHyperParameterTuningJob request.
func (r *StopHyperParameterTuningJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
