// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The details of an AWS account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AccountDetails
type AccountDetails struct {
	_ struct{} `type:"structure"`

	// The ID of an AWS account.
	AccountId *string `type:"string"`

	// The email of an AWS account.
	Email *string `type:"string"`
}

// String returns the string representation
func (s AccountDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details of an AWS EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsEc2InstanceDetails
type AwsEc2InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The IAM profile ARN of the instance.
	IamInstanceProfileArn *string `type:"string"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ImageId *string `type:"string"`

	// The IPv4 addresses associated with the instance.
	IpV4Addresses []string `type:"list"`

	// The IPv6 addresses associated with the instance.
	IpV6Addresses []string `type:"list"`

	// The key name associated with the instance.
	KeyName *string `type:"string"`

	// The date/time the instance was launched.
	LaunchedAt *string `type:"string"`

	// The identifier of the subnet in which the instance was launched.
	SubnetId *string `type:"string"`

	// The instance type of the instance.
	Type *string `type:"string"`

	// The identifier of the VPC in which the instance was launched.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s AwsEc2InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsEc2InstanceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.IamInstanceProfileArn != nil {
		v := *s.IamInstanceProfileArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IamInstanceProfileArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.IpV4Addresses) > 0 {
		v := s.IpV4Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpV4Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if len(s.IpV6Addresses) > 0 {
		v := s.IpV6Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IpV6Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.KeyName != nil {
		v := *s.KeyName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "KeyName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchedAt != nil {
		v := *s.LaunchedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// AWS IAM access key details related to a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsIamAccessKeyDetails
type AwsIamAccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// The creation date/time of the IAM access key related to a finding.
	CreatedAt *string `type:"string"`

	// The status of the IAM access key related to a finding.
	Status AwsIamAccessKeyStatus `type:"string" enum:"true"`

	// The user associated with the IAM access key related to a finding.
	UserName *string `type:"string"`
}

// String returns the string representation
func (s AwsIamAccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsIamAccessKeyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UserName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details of an AWS S3 Bucket.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsS3BucketDetails
type AwsS3BucketDetails struct {
	_ struct{} `type:"structure"`

	// The canonical user ID of the owner of the S3 bucket.
	OwnerId *string `type:"string"`

	// The display name of the owner of the S3 bucket.
	OwnerName *string `type:"string"`
}

// String returns the string representation
func (s AwsS3BucketDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsS3BucketDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.OwnerId != nil {
		v := *s.OwnerId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.OwnerName != nil {
		v := *s.OwnerName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "OwnerName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides consistent format for the contents of the Security Hub-aggregated
// findings. AwsSecurityFinding format enables you to share findings between
// AWS security services and third-party solutions, and compliance checks.
//
// A finding is a potential security issue generated either by AWS services
// (GuardDuty, Inspector, Macie) or by the integrated third-party solutions
// and compliance checks.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsSecurityFinding
type AwsSecurityFinding struct {
	_ struct{} `type:"structure"`

	// The AWS account ID in which a finding is generated.
	//
	// AwsAccountId is a required field
	AwsAccountId *string `type:"string" required:"true"`

	// This data type is exclusive to findings that are generated as the result
	// of a check run against a specific rule in a supported standard (for example,
	// AWS CIS Foundations). Contains compliance-related finding details.
	Compliance *Compliance `type:"structure"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale. 0 equates zero
	// percent confidence and 100 equates to 100 percent confidence.
	Confidence *int64 `type:"integer"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was created by the security findings provider.
	//
	// CreatedAt is a required field
	CreatedAt *string `type:"string" required:"true"`

	// The level of importance assigned to the resources associated with the finding.
	// A score of 0 means the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality *int64 `type:"integer"`

	// A finding's description.
	//
	// In this release, Description is a required property.
	Description *string `type:"string"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was first observed by the security findings provider.
	FirstObservedAt *string `type:"string"`

	// This is the identifier for the solution-specific component (a discrete unit
	// of logic) that generated a finding. In various security findings provider's
	// solutions, this generator can be called a rule, a check, a detector, a plug-in,
	// etc.
	//
	// GeneratorId is a required field
	GeneratorId *string `type:"string" required:"true"`

	// The security findings provider-specific identifier for a finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was most recently observed by the security findings
	// provider.
	LastObservedAt *string `type:"string"`

	// A list of malware related to a finding.
	Malware []Malware `type:"list"`

	// The details of network-related information about a finding.
	Network *Network `type:"structure"`

	// A user-defined note added to a finding.
	Note *Note `type:"structure"`

	// The details of process-related information about a finding.
	Process *ProcessDetails `type:"structure"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) once this provider's product (solution
	// that generates findings) is registered with Security Hub.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`

	// A data type where security findings providers can include additional solution-specific
	// details that are not part of the defined AwsSecurityFinding format.
	ProductFields map[string]string `type:"map"`

	// The record state of a finding.
	RecordState RecordState `type:"string" enum:"true"`

	// A list of related findings.
	RelatedFindings []RelatedFinding `type:"list"`

	// An data type that describes the remediation options for a finding.
	Remediation *Remediation `type:"structure"`

	// A set of resource data types that describe the resources to which the finding
	// refers.
	//
	// Resources is a required field
	Resources []Resource `type:"list" required:"true"`

	// The schema version for which a finding is formatted.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `type:"string" required:"true"`

	// A finding's severity.
	//
	// Severity is a required field
	Severity *Severity `type:"structure" required:"true"`

	// A URL that links to a page about the current finding in the security findings
	// provider's solution.
	SourceUrl *string `type:"string"`

	// Threat intel details related to a finding.
	ThreatIntelIndicators []ThreatIntelIndicator `type:"list"`

	// A finding's title.
	//
	// In this release, Title is a required property.
	Title *string `type:"string"`

	// One or more finding types in the format of 'namespace/category/classifier'
	// that classify a finding.
	//
	// Valid namespace values are: Software and Configuration Checks | TTPs | Effects
	// | Unusual Behaviors | Sensitive Data Identifications
	//
	// Types is a required field
	Types []string `type:"list" required:"true"`

	// An ISO8601-formatted timestamp that indicates when the finding record was
	// last updated by the security findings provider.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields map[string]string `type:"map"`

	// Indicates the veracity of a finding.
	VerificationState VerificationState `type:"string" enum:"true"`

	// The workflow state of a finding.
	WorkflowState WorkflowState `type:"string" enum:"true"`
}

// String returns the string representation
func (s AwsSecurityFinding) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AwsSecurityFinding) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AwsSecurityFinding"}

	if s.AwsAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AwsAccountId"))
	}

	if s.CreatedAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("CreatedAt"))
	}

	if s.GeneratorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GeneratorId"))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.ProductArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductArn"))
	}

	if s.Resources == nil {
		invalidParams.Add(aws.NewErrParamRequired("Resources"))
	}

	if s.SchemaVersion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SchemaVersion"))
	}

	if s.Severity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Severity"))
	}

	if s.Types == nil {
		invalidParams.Add(aws.NewErrParamRequired("Types"))
	}

	if s.UpdatedAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedAt"))
	}
	if s.Malware != nil {
		for i, v := range s.Malware {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Malware", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Note != nil {
		if err := s.Note.Validate(); err != nil {
			invalidParams.AddNested("Note", err.(aws.ErrInvalidParams))
		}
	}
	if s.RelatedFindings != nil {
		for i, v := range s.RelatedFindings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RelatedFindings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Resources != nil {
		for i, v := range s.Resources {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Resources", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Severity != nil {
		if err := s.Severity.Validate(); err != nil {
			invalidParams.AddNested("Severity", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSecurityFinding) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsAccountId != nil {
		v := *s.AwsAccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AwsAccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Compliance != nil {
		v := s.Compliance

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Compliance", v, metadata)
	}
	if s.Confidence != nil {
		v := *s.Confidence

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Confidence", protocol.Int64Value(v), metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Criticality != nil {
		v := *s.Criticality

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Criticality", protocol.Int64Value(v), metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FirstObservedAt != nil {
		v := *s.FirstObservedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FirstObservedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GeneratorId != nil {
		v := *s.GeneratorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GeneratorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastObservedAt != nil {
		v := *s.LastObservedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastObservedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Malware) > 0 {
		v := s.Malware

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Malware", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Network != nil {
		v := s.Network

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Network", v, metadata)
	}
	if s.Note != nil {
		v := s.Note

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Note", v, metadata)
	}
	if s.Process != nil {
		v := s.Process

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Process", v, metadata)
	}
	if s.ProductArn != nil {
		v := *s.ProductArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductFields) > 0 {
		v := s.ProductFields

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "ProductFields", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.RecordState) > 0 {
		v := s.RecordState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.RelatedFindings) > 0 {
		v := s.RelatedFindings

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindings", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Remediation != nil {
		v := s.Remediation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Remediation", v, metadata)
	}
	if len(s.Resources) > 0 {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SchemaVersion != nil {
		v := *s.SchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Severity != nil {
		v := s.Severity

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Severity", v, metadata)
	}
	if s.SourceUrl != nil {
		v := *s.SourceUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ThreatIntelIndicators) > 0 {
		v := s.ThreatIntelIndicators

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicators", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Types) > 0 {
		v := s.Types

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Types", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.UserDefinedFields) > 0 {
		v := s.UserDefinedFields

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "UserDefinedFields", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.VerificationState) > 0 {
		v := s.VerificationState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "VerificationState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.WorkflowState) > 0 {
		v := s.WorkflowState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "WorkflowState", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A collection of attributes that are applied to all active Security Hub-aggregated
// findings and that result in a subset of findings that are included in this
// insight.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/AwsSecurityFindingFilters
type AwsSecurityFindingFilters struct {
	_ struct{} `type:"structure"`

	// The AWS account ID in which a finding is generated.
	AwsAccountId []StringFilter `type:"list"`

	// The name of the findings provider (company) that owns the solution (product)
	// that generates findings.
	CompanyName []StringFilter `type:"list"`

	// Exclusive to findings that are generated as the result of a check run against
	// a specific rule in a supported standard (for example, AWS CIS Foundations).
	// Contains compliance-related finding details.
	ComplianceStatus []StringFilter `type:"list"`

	// A finding's confidence. Confidence is defined as the likelihood that a finding
	// accurately identifies the behavior or issue that it was intended to identify.
	// Confidence is scored on a 0-100 basis using a ratio scale. 0 equates zero
	// percent confidence and 100 equates to 100 percent confidence.
	Confidence []NumberFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was created by the security findings provider.
	CreatedAt []DateFilter `type:"list"`

	// The level of importance assigned to the resources associated with the finding.
	// A score of 0 means the underlying resources have no criticality, and a score
	// of 100 is reserved for the most critical resources.
	Criticality []NumberFilter `type:"list"`

	// A finding's description.
	Description []StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was first observed by the security findings provider.
	FirstObservedAt []DateFilter `type:"list"`

	// This is the identifier for the solution-specific component (a discrete unit
	// of logic) that generated a finding. In various security findings provider's
	// solutions, this generator can be called a rule, a check, a detector, a plug-in,
	// etc.
	GeneratorId []StringFilter `type:"list"`

	// The security findings provider-specific identifier for a finding.
	Id []StringFilter `type:"list"`

	// A keyword for a finding.
	Keyword []KeywordFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the potential security
	// issue captured by a finding was most recently observed by the security findings
	// provider.
	LastObservedAt []DateFilter `type:"list"`

	// The name of the malware that was observed.
	MalwareName []StringFilter `type:"list"`

	// The filesystem path of the malware that was observed.
	MalwarePath []StringFilter `type:"list"`

	// The state of the malware that was observed.
	MalwareState []StringFilter `type:"list"`

	// The type of the malware that was observed.
	MalwareType []StringFilter `type:"list"`

	// The destination domain of network-related information about a finding.
	NetworkDestinationDomain []StringFilter `type:"list"`

	// The destination IPv4 address of network-related information about a finding.
	NetworkDestinationIpV4 []IpFilter `type:"list"`

	// The destination IPv6 address of network-related information about a finding.
	NetworkDestinationIpV6 []IpFilter `type:"list"`

	// The destination port of network-related information about a finding.
	NetworkDestinationPort []NumberFilter `type:"list"`

	// Indicates the direction of network traffic associated with a finding.
	NetworkDirection []StringFilter `type:"list"`

	// The protocol of network-related information about a finding.
	NetworkProtocol []StringFilter `type:"list"`

	// The source domain of network-related information about a finding.
	NetworkSourceDomain []StringFilter `type:"list"`

	// The source IPv4 address of network-related information about a finding.
	NetworkSourceIpV4 []IpFilter `type:"list"`

	// The source IPv6 address of network-related information about a finding.
	NetworkSourceIpV6 []IpFilter `type:"list"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	NetworkSourceMac []StringFilter `type:"list"`

	// The source port of network-related information about a finding.
	NetworkSourcePort []NumberFilter `type:"list"`

	// The text of a note.
	NoteText []StringFilter `type:"list"`

	// The timestamp of when the note was updated.
	NoteUpdatedAt []DateFilter `type:"list"`

	// The principal that created a note.
	NoteUpdatedBy []StringFilter `type:"list"`

	// The date/time that the process was launched.
	ProcessLaunchedAt []DateFilter `type:"list"`

	// The name of the process.
	ProcessName []StringFilter `type:"list"`

	// The parent process ID.
	ProcessParentPid []NumberFilter `type:"list"`

	// The path to the process executable.
	ProcessPath []StringFilter `type:"list"`

	// The process ID.
	ProcessPid []NumberFilter `type:"list"`

	// The date/time that the process was terminated.
	ProcessTerminatedAt []DateFilter `type:"list"`

	// The ARN generated by Security Hub that uniquely identifies a third-party
	// company (security findings provider) once this provider's product (solution
	// that generates findings) is registered with Security Hub.
	ProductArn []StringFilter `type:"list"`

	// A data type where security findings providers can include additional solution-specific
	// details that are not part of the defined AwsSecurityFinding format.
	ProductFields []MapFilter `type:"list"`

	// The name of the solution (product) that generates findings.
	ProductName []StringFilter `type:"list"`

	// The recommendation of what to do about the issue described in a finding.
	RecommendationText []StringFilter `type:"list"`

	// The updated record state for the finding.
	RecordState []StringFilter `type:"list"`

	// The solution-generated identifier for a related finding.
	RelatedFindingsId []StringFilter `type:"list"`

	// The ARN of the solution that generated a related finding.
	RelatedFindingsProductArn []StringFilter `type:"list"`

	// The IAM profile ARN of the instance.
	ResourceAwsEc2InstanceIamInstanceProfileArn []StringFilter `type:"list"`

	// The Amazon Machine Image (AMI) ID of the instance.
	ResourceAwsEc2InstanceImageId []StringFilter `type:"list"`

	// The IPv4 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV4Addresses []IpFilter `type:"list"`

	// The IPv6 addresses associated with the instance.
	ResourceAwsEc2InstanceIpV6Addresses []IpFilter `type:"list"`

	// The key name associated with the instance.
	ResourceAwsEc2InstanceKeyName []StringFilter `type:"list"`

	// The date/time the instance was launched.
	ResourceAwsEc2InstanceLaunchedAt []DateFilter `type:"list"`

	// The identifier of the subnet in which the instance was launched.
	ResourceAwsEc2InstanceSubnetId []StringFilter `type:"list"`

	// The instance type of the instance.
	ResourceAwsEc2InstanceType []StringFilter `type:"list"`

	// The identifier of the VPC in which the instance was launched.
	ResourceAwsEc2InstanceVpcId []StringFilter `type:"list"`

	// The creation date/time of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyCreatedAt []DateFilter `type:"list"`

	// The status of the IAM access key related to a finding.
	ResourceAwsIamAccessKeyStatus []StringFilter `type:"list"`

	// The user associated with the IAM access key related to a finding.
	ResourceAwsIamAccessKeyUserName []StringFilter `type:"list"`

	// The canonical user ID of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerId []StringFilter `type:"list"`

	// The display name of the owner of the S3 bucket.
	ResourceAwsS3BucketOwnerName []StringFilter `type:"list"`

	// The identifier of the image related to a finding.
	ResourceContainerImageId []StringFilter `type:"list"`

	// The name of the image related to a finding.
	ResourceContainerImageName []StringFilter `type:"list"`

	// The date/time that the container was started.
	ResourceContainerLaunchedAt []DateFilter `type:"list"`

	// The name of the container related to a finding.
	ResourceContainerName []StringFilter `type:"list"`

	// The details of a resource that does not have a specific sub-field for the
	// resource type defined.
	ResourceDetailsOther []MapFilter `type:"list"`

	// The canonical identifier for the given resource type.
	ResourceId []StringFilter `type:"list"`

	// The canonical AWS partition name to which the region is assigned.
	ResourcePartition []StringFilter `type:"list"`

	// The canonical AWS external region name where this resource is located.
	ResourceRegion []StringFilter `type:"list"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	ResourceTags []MapFilter `type:"list"`

	// Specifies the type of the resource for which details are provided.
	ResourceType []StringFilter `type:"list"`

	// The label of a finding's severity.
	SeverityLabel []StringFilter `type:"list"`

	// The normalized severity of a finding.
	SeverityNormalized []NumberFilter `type:"list"`

	// The native severity as defined by the security findings provider's solution
	// that generated the finding.
	SeverityProduct []NumberFilter `type:"list"`

	// A URL that links to a page about the current finding in the security findings
	// provider's solution.
	SourceUrl []StringFilter `type:"list"`

	// The category of a threat intel indicator.
	ThreatIntelIndicatorCategory []StringFilter `type:"list"`

	// The date/time of the last observation of a threat intel indicator.
	ThreatIntelIndicatorLastObservedAt []DateFilter `type:"list"`

	// The source of the threat intel.
	ThreatIntelIndicatorSource []StringFilter `type:"list"`

	// The URL for more details from the source of the threat intel.
	ThreatIntelIndicatorSourceUrl []StringFilter `type:"list"`

	// The type of a threat intel indicator.
	ThreatIntelIndicatorType []StringFilter `type:"list"`

	// The value of a threat intel indicator.
	ThreatIntelIndicatorValue []StringFilter `type:"list"`

	// A finding's title.
	Title []StringFilter `type:"list"`

	// A finding type in the format of 'namespace/category/classifier' that classifies
	// a finding.
	Type []StringFilter `type:"list"`

	// An ISO8601-formatted timestamp that indicates when the finding record was
	// last updated by the security findings provider.
	UpdatedAt []DateFilter `type:"list"`

	// A list of name/value string pairs associated with the finding. These are
	// custom, user-defined fields added to a finding.
	UserDefinedFields []MapFilter `type:"list"`

	// Indicates the veracity of a finding.
	VerificationState []StringFilter `type:"list"`

	// The workflow state of a finding.
	WorkflowState []StringFilter `type:"list"`
}

// String returns the string representation
func (s AwsSecurityFindingFilters) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsSecurityFindingFilters) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.AwsAccountId) > 0 {
		v := s.AwsAccountId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AwsAccountId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.CompanyName) > 0 {
		v := s.CompanyName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CompanyName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ComplianceStatus) > 0 {
		v := s.ComplianceStatus

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ComplianceStatus", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Confidence) > 0 {
		v := s.Confidence

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Confidence", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.CreatedAt) > 0 {
		v := s.CreatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CreatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Criticality) > 0 {
		v := s.Criticality

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Criticality", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Description) > 0 {
		v := s.Description

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Description", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.FirstObservedAt) > 0 {
		v := s.FirstObservedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "FirstObservedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.GeneratorId) > 0 {
		v := s.GeneratorId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "GeneratorId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Id) > 0 {
		v := s.Id

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Id", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Keyword) > 0 {
		v := s.Keyword

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Keyword", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.LastObservedAt) > 0 {
		v := s.LastObservedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "LastObservedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.MalwareName) > 0 {
		v := s.MalwareName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwareName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.MalwarePath) > 0 {
		v := s.MalwarePath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwarePath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.MalwareState) > 0 {
		v := s.MalwareState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwareState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.MalwareType) > 0 {
		v := s.MalwareType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "MalwareType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkDestinationDomain) > 0 {
		v := s.NetworkDestinationDomain

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationDomain", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkDestinationIpV4) > 0 {
		v := s.NetworkDestinationIpV4

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationIpV4", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkDestinationIpV6) > 0 {
		v := s.NetworkDestinationIpV6

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationIpV6", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkDestinationPort) > 0 {
		v := s.NetworkDestinationPort

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDestinationPort", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkDirection) > 0 {
		v := s.NetworkDirection

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkDirection", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkProtocol) > 0 {
		v := s.NetworkProtocol

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkProtocol", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkSourceDomain) > 0 {
		v := s.NetworkSourceDomain

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceDomain", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkSourceIpV4) > 0 {
		v := s.NetworkSourceIpV4

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceIpV4", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkSourceIpV6) > 0 {
		v := s.NetworkSourceIpV6

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceIpV6", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkSourceMac) > 0 {
		v := s.NetworkSourceMac

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourceMac", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NetworkSourcePort) > 0 {
		v := s.NetworkSourcePort

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NetworkSourcePort", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NoteText) > 0 {
		v := s.NoteText

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NoteText", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NoteUpdatedAt) > 0 {
		v := s.NoteUpdatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NoteUpdatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.NoteUpdatedBy) > 0 {
		v := s.NoteUpdatedBy

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "NoteUpdatedBy", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProcessLaunchedAt) > 0 {
		v := s.ProcessLaunchedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessLaunchedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProcessName) > 0 {
		v := s.ProcessName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProcessParentPid) > 0 {
		v := s.ProcessParentPid

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessParentPid", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProcessPath) > 0 {
		v := s.ProcessPath

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessPath", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProcessPid) > 0 {
		v := s.ProcessPid

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessPid", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProcessTerminatedAt) > 0 {
		v := s.ProcessTerminatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProcessTerminatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProductArn) > 0 {
		v := s.ProductArn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductArn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProductFields) > 0 {
		v := s.ProductFields

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ProductName) > 0 {
		v := s.ProductName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ProductName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.RecommendationText) > 0 {
		v := s.RecommendationText

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecommendationText", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.RecordState) > 0 {
		v := s.RecordState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RecordState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.RelatedFindingsId) > 0 {
		v := s.RelatedFindingsId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindingsId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.RelatedFindingsProductArn) > 0 {
		v := s.RelatedFindingsProductArn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RelatedFindingsProductArn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceIamInstanceProfileArn) > 0 {
		v := s.ResourceAwsEc2InstanceIamInstanceProfileArn

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceIamInstanceProfileArn", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceImageId) > 0 {
		v := s.ResourceAwsEc2InstanceImageId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceImageId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceIpV4Addresses) > 0 {
		v := s.ResourceAwsEc2InstanceIpV4Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceIpV4Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceIpV6Addresses) > 0 {
		v := s.ResourceAwsEc2InstanceIpV6Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceIpV6Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceKeyName) > 0 {
		v := s.ResourceAwsEc2InstanceKeyName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceKeyName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceLaunchedAt) > 0 {
		v := s.ResourceAwsEc2InstanceLaunchedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceLaunchedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceSubnetId) > 0 {
		v := s.ResourceAwsEc2InstanceSubnetId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceSubnetId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceType) > 0 {
		v := s.ResourceAwsEc2InstanceType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsEc2InstanceVpcId) > 0 {
		v := s.ResourceAwsEc2InstanceVpcId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsEc2InstanceVpcId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsIamAccessKeyCreatedAt) > 0 {
		v := s.ResourceAwsIamAccessKeyCreatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsIamAccessKeyCreatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsIamAccessKeyStatus) > 0 {
		v := s.ResourceAwsIamAccessKeyStatus

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsIamAccessKeyStatus", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsIamAccessKeyUserName) > 0 {
		v := s.ResourceAwsIamAccessKeyUserName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsIamAccessKeyUserName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsS3BucketOwnerId) > 0 {
		v := s.ResourceAwsS3BucketOwnerId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsS3BucketOwnerId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceAwsS3BucketOwnerName) > 0 {
		v := s.ResourceAwsS3BucketOwnerName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAwsS3BucketOwnerName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceContainerImageId) > 0 {
		v := s.ResourceContainerImageId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerImageId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceContainerImageName) > 0 {
		v := s.ResourceContainerImageName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerImageName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceContainerLaunchedAt) > 0 {
		v := s.ResourceContainerLaunchedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerLaunchedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceContainerName) > 0 {
		v := s.ResourceContainerName

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceContainerName", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceDetailsOther) > 0 {
		v := s.ResourceDetailsOther

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceDetailsOther", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceId) > 0 {
		v := s.ResourceId

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceId", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourcePartition) > 0 {
		v := s.ResourcePartition

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourcePartition", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceRegion) > 0 {
		v := s.ResourceRegion

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceRegion", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceTags) > 0 {
		v := s.ResourceTags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceTags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ResourceType) > 0 {
		v := s.ResourceType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SeverityLabel) > 0 {
		v := s.SeverityLabel

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SeverityLabel", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SeverityNormalized) > 0 {
		v := s.SeverityNormalized

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SeverityNormalized", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SeverityProduct) > 0 {
		v := s.SeverityProduct

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SeverityProduct", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.SourceUrl) > 0 {
		v := s.SourceUrl

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SourceUrl", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThreatIntelIndicatorCategory) > 0 {
		v := s.ThreatIntelIndicatorCategory

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorCategory", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThreatIntelIndicatorLastObservedAt) > 0 {
		v := s.ThreatIntelIndicatorLastObservedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorLastObservedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThreatIntelIndicatorSource) > 0 {
		v := s.ThreatIntelIndicatorSource

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorSource", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThreatIntelIndicatorSourceUrl) > 0 {
		v := s.ThreatIntelIndicatorSourceUrl

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorSourceUrl", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThreatIntelIndicatorType) > 0 {
		v := s.ThreatIntelIndicatorType

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.ThreatIntelIndicatorValue) > 0 {
		v := s.ThreatIntelIndicatorValue

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ThreatIntelIndicatorValue", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Title) > 0 {
		v := s.Title

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Title", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Type", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.UpdatedAt) > 0 {
		v := s.UpdatedAt

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UpdatedAt", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.UserDefinedFields) > 0 {
		v := s.UserDefinedFields

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "UserDefinedFields", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.VerificationState) > 0 {
		v := s.VerificationState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "VerificationState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.WorkflowState) > 0 {
		v := s.WorkflowState

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "WorkflowState", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Exclusive to findings that are generated as the result of a check run against
// a specific rule in a supported standard (for example, AWS CIS Foundations).
// Contains compliance-related finding details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Compliance
type Compliance struct {
	_ struct{} `type:"structure"`

	// Indicates the result of a compliance check.
	Status ComplianceStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Compliance) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Status) > 0 {
		v := s.Status

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Status", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Container details related to a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ContainerDetails
type ContainerDetails struct {
	_ struct{} `type:"structure"`

	// The identifier of the image related to a finding.
	ImageId *string `type:"string"`

	// The name of the image related to a finding.
	ImageName *string `type:"string"`

	// The date/time that the container was started.
	LaunchedAt *string `type:"string"`

	// The name of the container related to a finding.
	Name *string `type:"string"`
}

// String returns the string representation
func (s ContainerDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ContainerDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageName != nil {
		v := *s.ImageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ImageName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchedAt != nil {
		v := *s.LaunchedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A date filter for querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DateFilter
type DateFilter struct {
	_ struct{} `type:"structure"`

	// A date range for the date filter.
	DateRange *DateRange `type:"structure"`

	// An end date for the date filter.
	End *string `type:"string"`

	// A start date for the date filter.
	Start *string `type:"string"`
}

// String returns the string representation
func (s DateFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DateFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.DateRange != nil {
		v := s.DateRange

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DateRange", v, metadata)
	}
	if s.End != nil {
		v := *s.End

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "End", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Start != nil {
		v := *s.Start

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Start", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A date range for the date filter.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/DateRange
type DateRange struct {
	_ struct{} `type:"structure"`

	// A date range unit for the date filter.
	Unit DateRangeUnit `type:"string" enum:"true"`

	// A date range value for the date filter.
	Value *int64 `type:"integer"`
}

// String returns the string representation
func (s DateRange) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DateRange) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Unit) > 0 {
		v := s.Unit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Unit", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Includes details of the list of the findings that cannot be imported.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ImportFindingsError
type ImportFindingsError struct {
	_ struct{} `type:"structure"`

	// The code of the error made during the BatchImportFindings operation.
	//
	// ErrorCode is a required field
	ErrorCode *string `type:"string" required:"true"`

	// The message of the error made during the BatchImportFindings operation.
	//
	// ErrorMessage is a required field
	ErrorMessage *string `type:"string" required:"true"`

	// The id of the error made during the BatchImportFindings operation.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ImportFindingsError) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ImportFindingsError) MarshalFields(e protocol.FieldEncoder) error {
	if s.ErrorCode != nil {
		v := *s.ErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains information about a Security Hub insight.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Insight
type Insight struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that are applied to all active Security Hub-aggregated
	// findings and that result in a subset of findings that are included in this
	// insight.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute by which the insight's findings are grouped. This attribute
	// is used as a findings aggregator for the purposes of viewing and managing
	// multiple related findings under a single operand.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of a Security Hub insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The name of a Security Hub insight.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Insight) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Insight) MarshalFields(e protocol.FieldEncoder) error {
	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if s.GroupByAttribute != nil {
		v := *s.GroupByAttribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The insight result values returned by the GetInsightResults operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InsightResultValue
type InsightResultValue struct {
	_ struct{} `type:"structure"`

	// The number of findings returned for each GroupByAttributeValue.
	//
	// Count is a required field
	Count *int64 `type:"integer" required:"true"`

	// The value of the attribute by which the findings are grouped for the insight's
	// whose results are returned by the GetInsightResults operation.
	//
	// GroupByAttributeValue is a required field
	GroupByAttributeValue *string `type:"string" required:"true"`
}

// String returns the string representation
func (s InsightResultValue) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InsightResultValue) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Count", protocol.Int64Value(v), metadata)
	}
	if s.GroupByAttributeValue != nil {
		v := *s.GroupByAttributeValue

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttributeValue", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The insight results returned by the GetInsightResults operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/InsightResults
type InsightResults struct {
	_ struct{} `type:"structure"`

	// The attribute by which the findings are grouped for the insight's whose results
	// are returned by the GetInsightResults operation.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The ARN of the insight whose results are returned by the GetInsightResults
	// operation.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`

	// The list of insight result values returned by the GetInsightResults operation.
	//
	// ResultValues is a required field
	ResultValues []InsightResultValue `type:"list" required:"true"`
}

// String returns the string representation
func (s InsightResults) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InsightResults) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupByAttribute != nil {
		v := *s.GroupByAttribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ResultValues) > 0 {
		v := s.ResultValues

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResultValues", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// The details of an invitation sent to an AWS account by the Security Hub master
// account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Invitation
type Invitation struct {
	_ struct{} `type:"structure"`

	// The account ID of the master Security Hub account who sent the invitation.
	AccountId *string `type:"string"`

	// The ID of the invitation sent by the master Security Hub account.
	InvitationId *string `type:"string"`

	// The timestamp of when the invitation was sent.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The current relationship status between the inviter and invitee accounts.
	MemberStatus *string `type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invitation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.MemberStatus != nil {
		v := *s.MemberStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The IP filter for querying findings.>
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/IpFilter
type IpFilter struct {
	_ struct{} `type:"structure"`

	// Finding's CIDR value.
	Cidr *string `type:"string"`
}

// String returns the string representation
func (s IpFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IpFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Cidr != nil {
		v := *s.Cidr

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Cidr", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A keyword filter for querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/KeywordFilter
type KeywordFilter struct {
	_ struct{} `type:"structure"`

	// A value for the keyword.
	Value *string `type:"string"`
}

// String returns the string representation
func (s KeywordFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s KeywordFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A list of malware related to a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Malware
type Malware struct {
	_ struct{} `type:"structure"`

	// The name of the malware that was observed.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filesystem path of the malware that was observed.
	Path *string `type:"string"`

	// The state of the malware that was observed.
	State MalwareState `type:"string" enum:"true"`

	// The type of the malware that was observed.
	Type MalwareType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Malware) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Malware) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Malware"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Malware) MarshalFields(e protocol.FieldEncoder) error {
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// The map filter for querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/MapFilter
type MapFilter struct {
	_ struct{} `type:"structure"`

	// Represents the condition to be applied to a key value when querying for findings
	// with a map filter.
	Comparison MapFilterComparison `type:"string" enum:"true"`

	// The key of the map filter.
	Key *string `type:"string"`

	// The value for the key in the map filter.
	Value *string `type:"string"`
}

// String returns the string representation
func (s MapFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s MapFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparison) > 0 {
		v := s.Comparison

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comparison", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The details for a Security Hub member account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Member
type Member struct {
	_ struct{} `type:"structure"`

	// The AWS account ID of a Security Hub member account.
	AccountId *string `type:"string"`

	// The email of a Security Hub member account.
	Email *string `type:"string"`

	// Time stamp at which the member account was invited to Security Hub.
	InvitedAt *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The AWS account ID of the master Security Hub account to this member account.
	MasterId *string `type:"string"`

	// The status of the relationship between the member account and its master
	// account.
	MemberStatus *string `type:"string"`

	// Time stamp at which this member account was updated.
	UpdatedAt *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvitedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.MasterId != nil {
		v := *s.MasterId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MasterId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemberStatus != nil {
		v := *s.MemberStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemberStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	return nil
}

// The details of network-related information about a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Network
type Network struct {
	_ struct{} `type:"structure"`

	// The destination domain of network-related information about a finding.
	DestinationDomain *string `type:"string"`

	// The destination IPv4 address of network-related information about a finding.
	DestinationIpV4 *string `type:"string"`

	// The destination IPv6 address of network-related information about a finding.
	DestinationIpV6 *string `type:"string"`

	// The destination port of network-related information about a finding.
	DestinationPort *int64 `type:"integer"`

	// Indicates the direction of network traffic associated with a finding.
	Direction NetworkDirection `type:"string" enum:"true"`

	// The protocol of network-related information about a finding.
	Protocol *string `type:"string"`

	// The source domain of network-related information about a finding.
	SourceDomain *string `type:"string"`

	// The source IPv4 address of network-related information about a finding.
	SourceIpV4 *string `type:"string"`

	// The source IPv6 address of network-related information about a finding.
	SourceIpV6 *string `type:"string"`

	// The source media access control (MAC) address of network-related information
	// about a finding.
	SourceMac *string `type:"string"`

	// The source port of network-related information about a finding.
	SourcePort *int64 `type:"integer"`
}

// String returns the string representation
func (s Network) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Network) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationDomain != nil {
		v := *s.DestinationDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationIpV4 != nil {
		v := *s.DestinationIpV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationIpV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationIpV6 != nil {
		v := *s.DestinationIpV6

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationIpV6", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DestinationPort != nil {
		v := *s.DestinationPort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationPort", protocol.Int64Value(v), metadata)
	}
	if len(s.Direction) > 0 {
		v := s.Direction

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Direction", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Protocol != nil {
		v := *s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Protocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceDomain != nil {
		v := *s.SourceDomain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceDomain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceIpV4 != nil {
		v := *s.SourceIpV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceIpV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceIpV6 != nil {
		v := *s.SourceIpV6

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceIpV6", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceMac != nil {
		v := *s.SourceMac

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceMac", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourcePort != nil {
		v := *s.SourcePort

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourcePort", protocol.Int64Value(v), metadata)
	}
	return nil
}

// A user-defined note added to a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Note
type Note struct {
	_ struct{} `type:"structure"`

	// The text of a note.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The timestamp of when the note was updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `type:"string" required:"true"`

	// The principal that created a note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Note) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Note) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Note"}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}

	if s.UpdatedAt == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedAt"))
	}

	if s.UpdatedBy == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Note) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedBy != nil {
		v := *s.UpdatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The updated note.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/NoteUpdate
type NoteUpdate struct {
	_ struct{} `type:"structure"`

	// The updated note text.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`

	// The principal that updated the note.
	//
	// UpdatedBy is a required field
	UpdatedBy *string `type:"string" required:"true"`
}

// String returns the string representation
func (s NoteUpdate) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NoteUpdate) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "NoteUpdate"}

	if s.Text == nil {
		invalidParams.Add(aws.NewErrParamRequired("Text"))
	}

	if s.UpdatedBy == nil {
		invalidParams.Add(aws.NewErrParamRequired("UpdatedBy"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NoteUpdate) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedBy != nil {
		v := *s.UpdatedBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "UpdatedBy", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A number filter for querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/NumberFilter
type NumberFilter struct {
	_ struct{} `type:"structure"`

	// Represents the "equal to" condition to be applied to a single field when
	// querying for findings.
	Eq *float64 `type:"double"`

	// Represents the "greater than equal" condition to be applied to a single field
	// when querying for findings.
	Gte *float64 `type:"double"`

	// Represents the "less than equal" condition to be applied to a single field
	// when querying for findings.
	Lte *float64 `type:"double"`
}

// String returns the string representation
func (s NumberFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NumberFilter) MarshalFields(e protocol.FieldEncoder) error {
	if s.Eq != nil {
		v := *s.Eq

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Eq", protocol.Float64Value(v), metadata)
	}
	if s.Gte != nil {
		v := *s.Gte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Gte", protocol.Float64Value(v), metadata)
	}
	if s.Lte != nil {
		v := *s.Lte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Lte", protocol.Float64Value(v), metadata)
	}
	return nil
}

// The details of process-related information about a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ProcessDetails
type ProcessDetails struct {
	_ struct{} `type:"structure"`

	// The date/time that the process was launched.
	LaunchedAt *string `type:"string"`

	// The name of the process.
	Name *string `type:"string"`

	// The parent process ID.
	ParentPid *int64 `type:"integer"`

	// The path to the process executable.
	Path *string `type:"string"`

	// The process ID.
	Pid *int64 `type:"integer"`

	// The date/time that the process was terminated.
	TerminatedAt *string `type:"string"`
}

// String returns the string representation
func (s ProcessDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProcessDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.LaunchedAt != nil {
		v := *s.LaunchedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LaunchedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentPid != nil {
		v := *s.ParentPid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentPid", protocol.Int64Value(v), metadata)
	}
	if s.Path != nil {
		v := *s.Path

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Path", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Pid != nil {
		v := *s.Pid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Pid", protocol.Int64Value(v), metadata)
	}
	if s.TerminatedAt != nil {
		v := *s.TerminatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "TerminatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides a recommendation on how to remediate the issue identified within
// a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Recommendation
type Recommendation struct {
	_ struct{} `type:"structure"`

	// The recommendation of what to do about the issue described in a finding.
	Text *string `type:"string"`

	// A URL to link to general remediation information for the finding type of
	// a finding.
	Url *string `type:"string"`
}

// String returns the string representation
func (s Recommendation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Recommendation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Text != nil {
		v := *s.Text

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Text", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Url != nil {
		v := *s.Url

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Url", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Related finding's details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/RelatedFinding
type RelatedFinding struct {
	_ struct{} `type:"structure"`

	// The solution-generated identifier for a related finding.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The ARN of the solution that generated a related finding.
	//
	// ProductArn is a required field
	ProductArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RelatedFinding) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RelatedFinding) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RelatedFinding"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.ProductArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProductArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RelatedFinding) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductArn != nil {
		v := *s.ProductArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProductArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The remediation options for a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Remediation
type Remediation struct {
	_ struct{} `type:"structure"`

	// Provides a recommendation on how to remediate the issue identified within
	// a finding.
	Recommendation *Recommendation `type:"structure"`
}

// String returns the string representation
func (s Remediation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Remediation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Recommendation != nil {
		v := s.Recommendation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Recommendation", v, metadata)
	}
	return nil
}

// A resource data type that describes a resource to which the finding refers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// Provides additional details about the resource.
	Details *ResourceDetails `type:"structure"`

	// The canonical identifier for the given resource type.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// The canonical AWS partition name to which the region is assigned.
	Partition Partition `type:"string" enum:"true"`

	// The canonical AWS external region name where this resource is located.
	Region *string `type:"string"`

	// A list of AWS tags associated with a resource at the time the finding was
	// processed.
	Tags map[string]string `type:"map"`

	// Specifies the type of the resource for which details are provided.
	//
	// Type is a required field
	Type *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Resource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Resource"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}

	if s.Type == nil {
		invalidParams.Add(aws.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Details != nil {
		v := s.Details

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Details", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Partition) > 0 {
		v := s.Partition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Partition", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Provides additional details about the resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ResourceDetails
type ResourceDetails struct {
	_ struct{} `type:"structure"`

	// The details of an AWS EC2 instance.
	AwsEc2Instance *AwsEc2InstanceDetails `type:"structure"`

	// AWS IAM access key details related to a finding.
	AwsIamAccessKey *AwsIamAccessKeyDetails `type:"structure"`

	// The details of an AWS S3 Bucket.
	AwsS3Bucket *AwsS3BucketDetails `type:"structure"`

	// Container details related to a finding.
	Container *ContainerDetails `type:"structure"`

	// The details of a resource that does not have a specific sub-field for the
	// resource type defined.
	Other map[string]string `type:"map"`
}

// String returns the string representation
func (s ResourceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AwsEc2Instance != nil {
		v := s.AwsEc2Instance

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsEc2Instance", v, metadata)
	}
	if s.AwsIamAccessKey != nil {
		v := s.AwsIamAccessKey

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsIamAccessKey", v, metadata)
	}
	if s.AwsS3Bucket != nil {
		v := s.AwsS3Bucket

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "AwsS3Bucket", v, metadata)
	}
	if s.Container != nil {
		v := s.Container

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Container", v, metadata)
	}
	if len(s.Other) > 0 {
		v := s.Other

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Other", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The account details that could not be processed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Result
type Result struct {
	_ struct{} `type:"structure"`

	// An ID of the AWS account that could not be processed.
	AccountId *string `type:"string"`

	// The reason for why an account could not be processed.
	ProcessingResult *string `type:"string"`
}

// String returns the string representation
func (s Result) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Result) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProcessingResult != nil {
		v := *s.ProcessingResult

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ProcessingResult", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A finding's severity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/Severity
type Severity struct {
	_ struct{} `type:"structure"`

	// The normalized severity of a finding.
	//
	// Normalized is a required field
	Normalized *int64 `type:"integer" required:"true"`

	// The native severity as defined by the security findings provider's solution
	// that generated the finding.
	Product *float64 `type:"double"`
}

// String returns the string representation
func (s Severity) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Severity) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Severity"}

	if s.Normalized == nil {
		invalidParams.Add(aws.NewErrParamRequired("Normalized"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Severity) MarshalFields(e protocol.FieldEncoder) error {
	if s.Normalized != nil {
		v := *s.Normalized

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Normalized", protocol.Int64Value(v), metadata)
	}
	if s.Product != nil {
		v := *s.Product

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Product", protocol.Float64Value(v), metadata)
	}
	return nil
}

// A collection of attributes used for sorting findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/SortCriterion
type SortCriterion struct {
	_ struct{} `type:"structure"`

	// The finding attribute used for sorting findings.
	Field *string `type:"string"`

	// The order used for sorting findings.
	SortOrder SortOrder `type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriterion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SortCriterion) MarshalFields(e protocol.FieldEncoder) error {
	if s.Field != nil {
		v := *s.Field

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Field", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SortOrder) > 0 {
		v := s.SortOrder

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SortOrder", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A resource that represents your subscription to a supported standard.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StandardsSubscription
type StandardsSubscription struct {
	_ struct{} `type:"structure"`

	// The ARN of a standard.
	//
	// In this release, Security Hub only supports the CIS AWS Foundations standard.
	//
	// Its ARN is arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	// StandardsInput is a required field
	StandardsInput map[string]string `type:"map" required:"true"`

	// The standard's status.
	//
	// StandardsStatus is a required field
	StandardsStatus StandardsStatus `type:"string" required:"true" enum:"true"`

	// The ARN of a resource that represents your subscription to a supported standard.
	//
	// StandardsSubscriptionArn is a required field
	StandardsSubscriptionArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StandardsSubscription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StandardsSubscription) MarshalFields(e protocol.FieldEncoder) error {
	if s.StandardsArn != nil {
		v := *s.StandardsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StandardsInput) > 0 {
		v := s.StandardsInput

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "StandardsInput", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	if len(s.StandardsStatus) > 0 {
		v := s.StandardsStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsStatus", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.StandardsSubscriptionArn != nil {
		v := *s.StandardsSubscriptionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsSubscriptionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The standard that you want to enable.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StandardsSubscriptionRequest
type StandardsSubscriptionRequest struct {
	_ struct{} `type:"structure"`

	// The ARN of the standard that you want to enable.
	//
	// In this release, Security Hub only supports the CIS AWS Foundations standard.
	//
	// Its ARN is arn:aws:securityhub:::ruleset/cis-aws-foundations-benchmark/v/1.2.0.
	//
	// StandardsArn is a required field
	StandardsArn *string `type:"string" required:"true"`

	StandardsInput map[string]string `type:"map"`
}

// String returns the string representation
func (s StandardsSubscriptionRequest) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StandardsSubscriptionRequest) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StandardsSubscriptionRequest"}

	if s.StandardsArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("StandardsArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StandardsSubscriptionRequest) MarshalFields(e protocol.FieldEncoder) error {
	if s.StandardsArn != nil {
		v := *s.StandardsArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StandardsArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.StandardsInput) > 0 {
		v := s.StandardsInput

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "StandardsInput", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// A string filter for querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/StringFilter
type StringFilter struct {
	_ struct{} `type:"structure"`

	// Represents the condition to be applied to a string value when querying for
	// findings.
	Comparison StringFilterComparison `type:"string" enum:"true"`

	// The string filter value.
	Value *string `type:"string"`
}

// String returns the string representation
func (s StringFilter) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StringFilter) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Comparison) > 0 {
		v := s.Comparison

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Comparison", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Threat intel details related to a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/ThreatIntelIndicator
type ThreatIntelIndicator struct {
	_ struct{} `type:"structure"`

	// The category of a threat intel indicator.
	Category ThreatIntelIndicatorCategory `type:"string" enum:"true"`

	// The date/time of the last observation of a threat intel indicator.
	LastObservedAt *string `type:"string"`

	// The source of the threat intel.
	Source *string `type:"string"`

	// The URL for more details from the source of the threat intel.
	SourceUrl *string `type:"string"`

	// The type of a threat intel indicator.
	Type ThreatIntelIndicatorType `type:"string" enum:"true"`

	// The value of a threat intel indicator.
	Value *string `type:"string"`
}

// String returns the string representation
func (s ThreatIntelIndicator) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ThreatIntelIndicator) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Category) > 0 {
		v := s.Category

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Category", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.LastObservedAt != nil {
		v := *s.LastObservedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastObservedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Source != nil {
		v := *s.Source

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Source", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SourceUrl != nil {
		v := *s.SourceUrl

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourceUrl", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
