// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package shield

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccessRequest
type DescribeDRTAccessInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeDRTAccessInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccessResponse
type DescribeDRTAccessOutput struct {
	_ struct{} `type:"structure"`

	// The list of Amazon S3 buckets accessed by the DRT.
	LogBucketList []string `type:"list"`

	// The Amazon Resource Name (ARN) of the role the DRT used to access your AWS
	// account.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeDRTAccessOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeDRTAccess = "DescribeDRTAccess"

// DescribeDRTAccessRequest returns a request value for making API operation for
// AWS Shield.
//
// Returns the current role and list of Amazon S3 log buckets used by the DDoS
// Response team (DRT) to access your AWS account while assisting with attack
// mitigation.
//
//    // Example sending a request using DescribeDRTAccessRequest.
//    req := client.DescribeDRTAccessRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/shield-2016-06-02/DescribeDRTAccess
func (c *Client) DescribeDRTAccessRequest(input *DescribeDRTAccessInput) DescribeDRTAccessRequest {
	op := &aws.Operation{
		Name:       opDescribeDRTAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDRTAccessInput{}
	}

	req := c.newRequest(op, input, &DescribeDRTAccessOutput{})
	return DescribeDRTAccessRequest{Request: req, Input: input, Copy: c.DescribeDRTAccessRequest}
}

// DescribeDRTAccessRequest is the request type for the
// DescribeDRTAccess API operation.
type DescribeDRTAccessRequest struct {
	*aws.Request
	Input *DescribeDRTAccessInput
	Copy  func(*DescribeDRTAccessInput) DescribeDRTAccessRequest
}

// Send marshals and sends the DescribeDRTAccess API request.
func (r DescribeDRTAccessRequest) Send(ctx context.Context) (*DescribeDRTAccessResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeDRTAccessResponse{
		DescribeDRTAccessOutput: r.Request.Data.(*DescribeDRTAccessOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeDRTAccessResponse is the response type for the
// DescribeDRTAccess API operation.
type DescribeDRTAccessResponse struct {
	*DescribeDRTAccessOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeDRTAccess request.
func (r *DescribeDRTAccessResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
