// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobsRequest
type GetReplicationJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call. The default value
	// is 50. To retrieve the remaining results, make another call with the returned
	// NextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// The token for the next set of results.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The identifier of the replication job.
	ReplicationJobId *string `locationName:"replicationJobId" type:"string"`
}

// String returns the string representation
func (s GetReplicationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobsResponse
type GetReplicationJobsOutput struct {
	_ struct{} `type:"structure"`

	// The token required to retrieve the next set of results. This value is null
	// when there are no more results to return.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the replication jobs.
	ReplicationJobList []ReplicationJob `locationName:"replicationJobList" type:"list"`
}

// String returns the string representation
func (s GetReplicationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetReplicationJobs = "GetReplicationJobs"

// GetReplicationJobsRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Describes the specified replication job or all of your replication jobs.
//
//    // Example sending a request using GetReplicationJobsRequest.
//    req := client.GetReplicationJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetReplicationJobs
func (c *Client) GetReplicationJobsRequest(input *GetReplicationJobsInput) GetReplicationJobsRequest {
	op := &aws.Operation{
		Name:       opGetReplicationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetReplicationJobsInput{}
	}

	req := c.newRequest(op, input, &GetReplicationJobsOutput{})
	return GetReplicationJobsRequest{Request: req, Input: input, Copy: c.GetReplicationJobsRequest}
}

// GetReplicationJobsRequest is the request type for the
// GetReplicationJobs API operation.
type GetReplicationJobsRequest struct {
	*aws.Request
	Input *GetReplicationJobsInput
	Copy  func(*GetReplicationJobsInput) GetReplicationJobsRequest
}

// Send marshals and sends the GetReplicationJobs API request.
func (r GetReplicationJobsRequest) Send(ctx context.Context) (*GetReplicationJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetReplicationJobsResponse{
		GetReplicationJobsOutput: r.Request.Data.(*GetReplicationJobsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetReplicationJobsRequestPaginator returns a paginator for GetReplicationJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetReplicationJobsRequest(input)
//   p := sms.NewGetReplicationJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetReplicationJobsPaginator(req GetReplicationJobsRequest) GetReplicationJobsPaginator {
	return GetReplicationJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetReplicationJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetReplicationJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetReplicationJobsPaginator struct {
	aws.Pager
}

func (p *GetReplicationJobsPaginator) CurrentPage() *GetReplicationJobsOutput {
	return p.Pager.CurrentPage().(*GetReplicationJobsOutput)
}

// GetReplicationJobsResponse is the response type for the
// GetReplicationJobs API operation.
type GetReplicationJobsResponse struct {
	*GetReplicationJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetReplicationJobs request.
func (r *GetReplicationJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
