// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResourcesRequest
type GetResourcesInput struct {
	_ struct{} `type:"structure"`

	// The Amazon WorkDocs authentication token. Do not set this field when using
	// administrative API actions, as in accessing the API operation using AWS credentials.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string"`

	// The collection type.
	CollectionType ResourceCollectionType `location:"querystring" locationName:"collectionType" type:"string" enum:"true"`

	// The maximum number of resources to return.
	Limit *int64 `location:"querystring" locationName:"limit" min:"1" type:"integer"`

	// The marker for the next set of results. This marker was received from a previous
	// call.
	Marker *string `location:"querystring" locationName:"marker" min:"1" type:"string"`

	// The user ID for the resource collection. This is a required field for accessing
	// the API operation using IAM credentials.
	UserId *string `location:"querystring" locationName:"userId" min:"1" type:"string"`
}

// String returns the string representation
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetResourcesInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.UserId != nil && len(*s.UserId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetResourcesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.CollectionType) > 0 {
		v := s.CollectionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "collectionType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResourcesResponse
type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The documents in the specified collection.
	Documents []DocumentMetadata `type:"list"`

	// The folders in the specified folder.
	Folders []FolderMetadata `type:"list"`

	// The marker to use when requesting the next set of results. If there are no
	// additional results, the string is empty.
	Marker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetResourcesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Documents) > 0 {
		v := s.Documents

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Documents", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Folders) > 0 {
		v := s.Folders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Folders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Marker != nil {
		v := *s.Marker

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Marker", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetResources = "GetResources"

// GetResourcesRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Retrieves a collection of resources, including folders and documents. The
// only CollectionType supported is SHARED_WITH_ME.
//
//    // Example sending a request using GetResourcesRequest.
//    req := client.GetResourcesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/GetResources
func (c *Client) GetResourcesRequest(input *GetResourcesInput) GetResourcesRequest {
	op := &aws.Operation{
		Name:       opGetResources,
		HTTPMethod: "GET",
		HTTPPath:   "/api/v1/resources",
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	req := c.newRequest(op, input, &GetResourcesOutput{})
	return GetResourcesRequest{Request: req, Input: input, Copy: c.GetResourcesRequest}
}

// GetResourcesRequest is the request type for the
// GetResources API operation.
type GetResourcesRequest struct {
	*aws.Request
	Input *GetResourcesInput
	Copy  func(*GetResourcesInput) GetResourcesRequest
}

// Send marshals and sends the GetResources API request.
func (r GetResourcesRequest) Send(ctx context.Context) (*GetResourcesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetResourcesResponse{
		GetResourcesOutput: r.Request.Data.(*GetResourcesOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetResourcesResponse is the response type for the
// GetResources API operation.
type GetResourcesResponse struct {
	*GetResourcesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetResources request.
func (r *GetResourcesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
