// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package worklink

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomainRequest
type AssociateDomainInput struct {
	_ struct{} `type:"structure"`

	// The ARN of an issued ACM certificate that is valid for the domain being associated.
	//
	// AcmCertificateArn is a required field
	AcmCertificateArn *string `type:"string" required:"true"`

	// The name to display.
	DisplayName *string `type:"string"`

	// The fully qualified domain name (FQDN).
	//
	// DomainName is a required field
	DomainName *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// FleetArn is a required field
	FleetArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AssociateDomainInput"}

	if s.AcmCertificateArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("AcmCertificateArn"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 1))
	}

	if s.FleetArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetArn"))
	}
	if s.FleetArn != nil && len(*s.FleetArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("FleetArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateDomainInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.AcmCertificateArn != nil {
		v := *s.AcmCertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AcmCertificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DisplayName != nil {
		v := *s.DisplayName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DisplayName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DomainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FleetArn != nil {
		v := *s.FleetArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FleetArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomainResponse
type AssociateDomainOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AssociateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AssociateDomainOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opAssociateDomain = "AssociateDomain"

// AssociateDomainRequest returns a request value for making API operation for
// Amazon WorkLink.
//
// Specifies a domain to be associated to Amazon WorkLink.
//
//    // Example sending a request using AssociateDomainRequest.
//    req := client.AssociateDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/worklink-2018-09-25/AssociateDomain
func (c *Client) AssociateDomainRequest(input *AssociateDomainInput) AssociateDomainRequest {
	op := &aws.Operation{
		Name:       opAssociateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/associateDomain",
	}

	if input == nil {
		input = &AssociateDomainInput{}
	}

	req := c.newRequest(op, input, &AssociateDomainOutput{})
	return AssociateDomainRequest{Request: req, Input: input, Copy: c.AssociateDomainRequest}
}

// AssociateDomainRequest is the request type for the
// AssociateDomain API operation.
type AssociateDomainRequest struct {
	*aws.Request
	Input *AssociateDomainInput
	Copy  func(*AssociateDomainInput) AssociateDomainRequest
}

// Send marshals and sends the AssociateDomain API request.
func (r AssociateDomainRequest) Send(ctx context.Context) (*AssociateDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AssociateDomainResponse{
		AssociateDomainOutput: r.Request.Data.(*AssociateDomainOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AssociateDomainResponse is the response type for the
// AssociateDomain API operation.
type AssociateDomainResponse struct {
	*AssociateDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AssociateDomain request.
func (r *AssociateDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
