/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelativePathTypeAdapter
extends TypeAdapter<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(RelativePathTypeAdapter.class);
    private final Path basePath;

    public RelativePathTypeAdapter(Path basePath) {
        this.basePath = Objects.requireNonNull(basePath);
    }

    public void write(JsonWriter out, Path value) throws IOException {
        if (value == null) {
            out.nullValue();
        } else {
            Path resultPath;
            value = value.toAbsolutePath().normalize();
            try {
                resultPath = this.basePath.relativize(value);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Unable to build a relative path to {} - using absolute path", (Object)value);
                resultPath = value;
            }
            out.value(resultPath.toString());
        }
    }

    public Path read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        Path p = Paths.get(in.nextString(), new String[0]);
        if (p.isAbsolute()) {
            return p;
        }
        return this.basePath.resolve(p);
    }
}

