// Package training implements the Azure ARM Training service API version 3.1.
//
//
package training

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"github.com/satori/go.uuid"
	"io"
	"net/http"
)

// BaseClient is the base client for Training.
type BaseClient struct {
	autorest.Client
	APIKey   string
	Endpoint string
}

// New creates an instance of the BaseClient client.
func New(aPIKey string, endpoint string) BaseClient {
	return NewWithoutDefaults(aPIKey, endpoint)
}

// NewWithoutDefaults creates an instance of the BaseClient client.
func NewWithoutDefaults(aPIKey string, endpoint string) BaseClient {
	return BaseClient{
		Client:   autorest.NewClientWithUserAgent(UserAgent()),
		APIKey:   aPIKey,
		Endpoint: endpoint,
	}
}

// CreateImageRegions this API accepts a batch of image regions, and optionally tags, to update existing images with
// region information.
// There is a limit of 64 entries in the batch.
// Parameters:
// projectID - the project id.
// batch - batch of image regions which include a tag and bounding box. Limited to 64.
func (client BaseClient) CreateImageRegions(ctx context.Context, projectID uuid.UUID, batch ImageRegionCreateBatch) (result ImageRegionCreateSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateImageRegions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateImageRegionsPreparer(ctx, projectID, batch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImageRegions", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateImageRegionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImageRegions", resp, "Failure sending request")
		return
	}

	result, err = client.CreateImageRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImageRegions", resp, "Failure responding to request")
	}

	return
}

// CreateImageRegionsPreparer prepares the CreateImageRegions request.
func (client BaseClient) CreateImageRegionsPreparer(ctx context.Context, projectID uuid.UUID, batch ImageRegionCreateBatch) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/regions", pathParameters),
		autorest.WithJSON(batch),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateImageRegionsSender sends the CreateImageRegions request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateImageRegionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateImageRegionsResponder handles the response to the CreateImageRegions request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateImageRegionsResponder(resp *http.Response) (result ImageRegionCreateSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateImagesFromData this API accepts body content as multipart/form-data and application/octet-stream. When using
// multipart
// multiple image files can be sent at once, with a maximum of 64 files
// Parameters:
// projectID - the project id.
// imageData - binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports images up to 6MB.
// tagIds - the tags ids with which to tag each image. Limited to 20.
func (client BaseClient) CreateImagesFromData(ctx context.Context, projectID uuid.UUID, imageData io.ReadCloser, tagIds []uuid.UUID) (result ImageCreateSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateImagesFromData")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: tagIds,
			Constraints: []validation.Constraint{{Target: "tagIds", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "tagIds", Name: validation.MaxItems, Rule: 20, Chain: nil},
					{Target: "tagIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "CreateImagesFromData", err.Error())
	}

	req, err := client.CreateImagesFromDataPreparer(ctx, projectID, imageData, tagIds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromData", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateImagesFromDataSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromData", resp, "Failure sending request")
		return
	}

	result, err = client.CreateImagesFromDataResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromData", resp, "Failure responding to request")
	}

	return
}

// CreateImagesFromDataPreparer prepares the CreateImagesFromData request.
func (client BaseClient) CreateImagesFromDataPreparer(ctx context.Context, projectID uuid.UUID, imageData io.ReadCloser, tagIds []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if tagIds != nil && len(tagIds) > 0 {
		queryParameters["tagIds"] = autorest.Encode("query", tagIds, ",")
	}

	formDataParameters := map[string]interface{}{
		"imageData": imageData,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithMultiPartFormData(formDataParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateImagesFromDataSender sends the CreateImagesFromData request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateImagesFromDataSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateImagesFromDataResponder handles the response to the CreateImagesFromData request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateImagesFromDataResponder(resp *http.Response) (result ImageCreateSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateImagesFromFiles this API accepts a batch of files, and optionally tags, to create images. There is a limit of
// 64 images and 20 tags.
// Parameters:
// projectID - the project id.
// batch - the batch of image files to add. Limited to 64 images and 20 tags per batch.
func (client BaseClient) CreateImagesFromFiles(ctx context.Context, projectID uuid.UUID, batch ImageFileCreateBatch) (result ImageCreateSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateImagesFromFiles")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateImagesFromFilesPreparer(ctx, projectID, batch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromFiles", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateImagesFromFilesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromFiles", resp, "Failure sending request")
		return
	}

	result, err = client.CreateImagesFromFilesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromFiles", resp, "Failure responding to request")
	}

	return
}

// CreateImagesFromFilesPreparer prepares the CreateImagesFromFiles request.
func (client BaseClient) CreateImagesFromFilesPreparer(ctx context.Context, projectID uuid.UUID, batch ImageFileCreateBatch) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/files", pathParameters),
		autorest.WithJSON(batch),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateImagesFromFilesSender sends the CreateImagesFromFiles request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateImagesFromFilesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateImagesFromFilesResponder handles the response to the CreateImagesFromFiles request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateImagesFromFilesResponder(resp *http.Response) (result ImageCreateSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateImagesFromPredictions this API creates a batch of images from predicted images specified. There is a limit of
// 64 images and 20 tags.
// Parameters:
// projectID - the project id.
// batch - image and tag ids. Limited to 64 images and 20 tags per batch.
func (client BaseClient) CreateImagesFromPredictions(ctx context.Context, projectID uuid.UUID, batch ImageIDCreateBatch) (result ImageCreateSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateImagesFromPredictions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateImagesFromPredictionsPreparer(ctx, projectID, batch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromPredictions", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateImagesFromPredictionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromPredictions", resp, "Failure sending request")
		return
	}

	result, err = client.CreateImagesFromPredictionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromPredictions", resp, "Failure responding to request")
	}

	return
}

// CreateImagesFromPredictionsPreparer prepares the CreateImagesFromPredictions request.
func (client BaseClient) CreateImagesFromPredictionsPreparer(ctx context.Context, projectID uuid.UUID, batch ImageIDCreateBatch) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/predictions", pathParameters),
		autorest.WithJSON(batch),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateImagesFromPredictionsSender sends the CreateImagesFromPredictions request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateImagesFromPredictionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateImagesFromPredictionsResponder handles the response to the CreateImagesFromPredictions request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateImagesFromPredictionsResponder(resp *http.Response) (result ImageCreateSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateImagesFromUrls this API accepts a batch of urls, and optionally tags, to create images. There is a limit of 64
// images and 20 tags.
// Parameters:
// projectID - the project id.
// batch - image urls and tag ids. Limited to 64 images and 20 tags per batch.
func (client BaseClient) CreateImagesFromUrls(ctx context.Context, projectID uuid.UUID, batch ImageURLCreateBatch) (result ImageCreateSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateImagesFromUrls")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateImagesFromUrlsPreparer(ctx, projectID, batch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromUrls", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateImagesFromUrlsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromUrls", resp, "Failure sending request")
		return
	}

	result, err = client.CreateImagesFromUrlsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImagesFromUrls", resp, "Failure responding to request")
	}

	return
}

// CreateImagesFromUrlsPreparer prepares the CreateImagesFromUrls request.
func (client BaseClient) CreateImagesFromUrlsPreparer(ctx context.Context, projectID uuid.UUID, batch ImageURLCreateBatch) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/urls", pathParameters),
		autorest.WithJSON(batch),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateImagesFromUrlsSender sends the CreateImagesFromUrls request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateImagesFromUrlsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateImagesFromUrlsResponder handles the response to the CreateImagesFromUrls request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateImagesFromUrlsResponder(resp *http.Response) (result ImageCreateSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateImageTags sends the create image tags request.
// Parameters:
// projectID - the project id.
// batch - batch of image tags. Limited to 128 tags per batch.
func (client BaseClient) CreateImageTags(ctx context.Context, projectID uuid.UUID, batch ImageTagCreateBatch) (result ImageTagCreateSummary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateImageTags")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateImageTagsPreparer(ctx, projectID, batch)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImageTags", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateImageTagsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImageTags", resp, "Failure sending request")
		return
	}

	result, err = client.CreateImageTagsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateImageTags", resp, "Failure responding to request")
	}

	return
}

// CreateImageTagsPreparer prepares the CreateImageTags request.
func (client BaseClient) CreateImageTagsPreparer(ctx context.Context, projectID uuid.UUID, batch ImageTagCreateBatch) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/tags", pathParameters),
		autorest.WithJSON(batch),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateImageTagsSender sends the CreateImageTags request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateImageTagsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateImageTagsResponder handles the response to the CreateImageTags request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateImageTagsResponder(resp *http.Response) (result ImageTagCreateSummary, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateProject sends the create project request.
// Parameters:
// name - name of the project.
// description - the description of the project.
// domainID - the id of the domain to use for this project. Defaults to General.
// classificationType - the type of classifier to create for this project.
// targetExportPlatforms - list of platforms the trained model is intending exporting to.
func (client BaseClient) CreateProject(ctx context.Context, name string, description string, domainID *uuid.UUID, classificationType string, targetExportPlatforms []string) (result Project, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateProject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateProjectPreparer(ctx, name, description, domainID, classificationType, targetExportPlatforms)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateProject", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateProjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateProject", resp, "Failure sending request")
		return
	}

	result, err = client.CreateProjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateProject", resp, "Failure responding to request")
	}

	return
}

// CreateProjectPreparer prepares the CreateProject request.
func (client BaseClient) CreateProjectPreparer(ctx context.Context, name string, description string, domainID *uuid.UUID, classificationType string, targetExportPlatforms []string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	queryParameters := map[string]interface{}{
		"name": autorest.Encode("query", name),
	}
	if len(description) > 0 {
		queryParameters["description"] = autorest.Encode("query", description)
	}
	if domainID != nil {
		queryParameters["domainId"] = autorest.Encode("query", *domainID)
	}
	if len(string(classificationType)) > 0 {
		queryParameters["classificationType"] = autorest.Encode("query", classificationType)
	}
	if targetExportPlatforms != nil && len(targetExportPlatforms) > 0 {
		queryParameters["targetExportPlatforms"] = autorest.Encode("query", targetExportPlatforms, ",")
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPath("/projects"),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateProjectSender sends the CreateProject request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateProjectSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateProjectResponder handles the response to the CreateProject request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateProjectResponder(resp *http.Response) (result Project, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateTag sends the create tag request.
// Parameters:
// projectID - the project id.
// name - the tag name.
// description - optional description for the tag.
// typeParameter - optional type for the tag.
func (client BaseClient) CreateTag(ctx context.Context, projectID uuid.UUID, name string, description string, typeParameter string) (result Tag, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.CreateTag")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CreateTagPreparer(ctx, projectID, name, description, typeParameter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateTag", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateTagSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateTag", resp, "Failure sending request")
		return
	}

	result, err = client.CreateTagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "CreateTag", resp, "Failure responding to request")
	}

	return
}

// CreateTagPreparer prepares the CreateTag request.
func (client BaseClient) CreateTagPreparer(ctx context.Context, projectID uuid.UUID, name string, description string, typeParameter string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"name": autorest.Encode("query", name),
	}
	if len(description) > 0 {
		queryParameters["description"] = autorest.Encode("query", description)
	}
	if len(string(typeParameter)) > 0 {
		queryParameters["type"] = autorest.Encode("query", typeParameter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/tags", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateTagSender sends the CreateTag request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) CreateTagSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// CreateTagResponder handles the response to the CreateTag request. The method always
// closes the http.Response Body.
func (client BaseClient) CreateTagResponder(resp *http.Response) (result Tag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteImageRegions sends the delete image regions request.
// Parameters:
// projectID - the project id.
// regionIds - regions to delete. Limited to 64.
func (client BaseClient) DeleteImageRegions(ctx context.Context, projectID uuid.UUID, regionIds []uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteImageRegions")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: regionIds,
			Constraints: []validation.Constraint{{Target: "regionIds", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "regionIds", Name: validation.MaxItems, Rule: 64, Chain: nil},
					{Target: "regionIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "DeleteImageRegions", err.Error())
	}

	req, err := client.DeleteImageRegionsPreparer(ctx, projectID, regionIds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImageRegions", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteImageRegionsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImageRegions", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteImageRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImageRegions", resp, "Failure responding to request")
	}

	return
}

// DeleteImageRegionsPreparer prepares the DeleteImageRegions request.
func (client BaseClient) DeleteImageRegionsPreparer(ctx context.Context, projectID uuid.UUID, regionIds []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"regionIds": autorest.Encode("query", regionIds, ","),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/regions", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteImageRegionsSender sends the DeleteImageRegions request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteImageRegionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteImageRegionsResponder handles the response to the DeleteImageRegions request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteImageRegionsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteImages sends the delete images request.
// Parameters:
// projectID - the project id.
// imageIds - ids of the images to be deleted. Limited to 256 images per batch.
// allImages - flag to specify delete all images, specify this flag or a list of images. Using this flag will
// return a 202 response to indicate the images are being deleted.
// allIterations - removes these images from all iterations, not just the current workspace. Using this flag
// will return a 202 response to indicate the images are being deleted.
func (client BaseClient) DeleteImages(ctx context.Context, projectID uuid.UUID, imageIds []uuid.UUID, allImages *bool, allIterations *bool) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteImages")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageIds,
			Constraints: []validation.Constraint{{Target: "imageIds", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "imageIds", Name: validation.MaxItems, Rule: 256, Chain: nil},
					{Target: "imageIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "DeleteImages", err.Error())
	}

	req, err := client.DeleteImagesPreparer(ctx, projectID, imageIds, allImages, allIterations)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImages", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteImagesSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImages", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteImagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImages", resp, "Failure responding to request")
	}

	return
}

// DeleteImagesPreparer prepares the DeleteImages request.
func (client BaseClient) DeleteImagesPreparer(ctx context.Context, projectID uuid.UUID, imageIds []uuid.UUID, allImages *bool, allIterations *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if imageIds != nil && len(imageIds) > 0 {
		queryParameters["imageIds"] = autorest.Encode("query", imageIds, ",")
	}
	if allImages != nil {
		queryParameters["allImages"] = autorest.Encode("query", *allImages)
	}
	if allIterations != nil {
		queryParameters["allIterations"] = autorest.Encode("query", *allIterations)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteImagesSender sends the DeleteImages request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteImagesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteImagesResponder handles the response to the DeleteImages request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteImagesResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteImageTags sends the delete image tags request.
// Parameters:
// projectID - the project id.
// imageIds - image ids. Limited to 64 images.
// tagIds - tags to be deleted from the specified images. Limited to 20 tags.
func (client BaseClient) DeleteImageTags(ctx context.Context, projectID uuid.UUID, imageIds []uuid.UUID, tagIds []uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteImageTags")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageIds,
			Constraints: []validation.Constraint{{Target: "imageIds", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "imageIds", Name: validation.MaxItems, Rule: 64, Chain: nil},
					{Target: "imageIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}},
		{TargetValue: tagIds,
			Constraints: []validation.Constraint{{Target: "tagIds", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "tagIds", Name: validation.MaxItems, Rule: 20, Chain: nil},
					{Target: "tagIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "DeleteImageTags", err.Error())
	}

	req, err := client.DeleteImageTagsPreparer(ctx, projectID, imageIds, tagIds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImageTags", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteImageTagsSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImageTags", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteImageTagsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteImageTags", resp, "Failure responding to request")
	}

	return
}

// DeleteImageTagsPreparer prepares the DeleteImageTags request.
func (client BaseClient) DeleteImageTagsPreparer(ctx context.Context, projectID uuid.UUID, imageIds []uuid.UUID, tagIds []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"imageIds": autorest.Encode("query", imageIds, ","),
		"tagIds":   autorest.Encode("query", tagIds, ","),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/tags", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteImageTagsSender sends the DeleteImageTags request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteImageTagsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteImageTagsResponder handles the response to the DeleteImageTags request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteImageTagsResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteIteration sends the delete iteration request.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id.
func (client BaseClient) DeleteIteration(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteIteration")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteIterationPreparer(ctx, projectID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteIteration", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteIterationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteIteration", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteIterationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteIteration", resp, "Failure responding to request")
	}

	return
}

// DeleteIterationPreparer prepares the DeleteIteration request.
func (client BaseClient) DeleteIterationPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteIterationSender sends the DeleteIteration request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteIterationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteIterationResponder handles the response to the DeleteIteration request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteIterationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeletePrediction sends the delete prediction request.
// Parameters:
// projectID - the project id.
// ids - the prediction ids. Limited to 64.
func (client BaseClient) DeletePrediction(ctx context.Context, projectID uuid.UUID, ids []uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeletePrediction")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: ids,
			Constraints: []validation.Constraint{{Target: "ids", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "ids", Name: validation.MaxItems, Rule: 64, Chain: nil},
					{Target: "ids", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "DeletePrediction", err.Error())
	}

	req, err := client.DeletePredictionPreparer(ctx, projectID, ids)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeletePrediction", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeletePredictionSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeletePrediction", resp, "Failure sending request")
		return
	}

	result, err = client.DeletePredictionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeletePrediction", resp, "Failure responding to request")
	}

	return
}

// DeletePredictionPreparer prepares the DeletePrediction request.
func (client BaseClient) DeletePredictionPreparer(ctx context.Context, projectID uuid.UUID, ids []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"ids": autorest.Encode("query", ids, ","),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/predictions", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeletePredictionSender sends the DeletePrediction request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeletePredictionSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeletePredictionResponder handles the response to the DeletePrediction request. The method always
// closes the http.Response Body.
func (client BaseClient) DeletePredictionResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteProject sends the delete project request.
// Parameters:
// projectID - the project id.
func (client BaseClient) DeleteProject(ctx context.Context, projectID uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteProject")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteProjectPreparer(ctx, projectID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteProject", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteProjectSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteProject", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteProjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteProject", resp, "Failure responding to request")
	}

	return
}

// DeleteProjectPreparer prepares the DeleteProject request.
func (client BaseClient) DeleteProjectPreparer(ctx context.Context, projectID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteProjectSender sends the DeleteProject request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteProjectSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteProjectResponder handles the response to the DeleteProject request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteProjectResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteTag sends the delete tag request.
// Parameters:
// projectID - the project id.
// tagID - id of the tag to be deleted.
func (client BaseClient) DeleteTag(ctx context.Context, projectID uuid.UUID, tagID uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.DeleteTag")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteTagPreparer(ctx, projectID, tagID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteTag", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteTagSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteTag", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteTagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "DeleteTag", resp, "Failure responding to request")
	}

	return
}

// DeleteTagPreparer prepares the DeleteTag request.
func (client BaseClient) DeleteTagPreparer(ctx context.Context, projectID uuid.UUID, tagID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
		"tagId":     autorest.Encode("path", tagID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/tags/{tagId}", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteTagSender sends the DeleteTag request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) DeleteTagSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// DeleteTagResponder handles the response to the DeleteTag request. The method always
// closes the http.Response Body.
func (client BaseClient) DeleteTagResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExportIteration sends the export iteration request.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id.
// platform - the target platform.
// flavor - the flavor of the target platform.
func (client BaseClient) ExportIteration(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, platform string, flavor string) (result Export, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.ExportIteration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.ExportIterationPreparer(ctx, projectID, iterationID, platform, flavor)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "ExportIteration", nil, "Failure preparing request")
		return
	}

	resp, err := client.ExportIterationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "ExportIteration", resp, "Failure sending request")
		return
	}

	result, err = client.ExportIterationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "ExportIteration", resp, "Failure responding to request")
	}

	return
}

// ExportIterationPreparer prepares the ExportIteration request.
func (client BaseClient) ExportIterationPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, platform string, flavor string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"platform": autorest.Encode("query", platform),
	}
	if len(string(flavor)) > 0 {
		queryParameters["flavor"] = autorest.Encode("query", flavor)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/export", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ExportIterationSender sends the ExportIteration request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) ExportIterationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// ExportIterationResponder handles the response to the ExportIteration request. The method always
// closes the http.Response Body.
func (client BaseClient) ExportIterationResponder(resp *http.Response) (result Export, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomain sends the get domain request.
// Parameters:
// domainID - the id of the domain to get information about.
func (client BaseClient) GetDomain(ctx context.Context, domainID uuid.UUID) (result Domain, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetDomain")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDomainPreparer(ctx, domainID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetDomain", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetDomain", resp, "Failure responding to request")
	}

	return
}

// GetDomainPreparer prepares the GetDomain request.
func (client BaseClient) GetDomainPreparer(ctx context.Context, domainID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"domainId": autorest.Encode("path", domainID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/domains/{domainId}", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDomainSender sends the GetDomain request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetDomainSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetDomainResponder handles the response to the GetDomain request. The method always
// closes the http.Response Body.
func (client BaseClient) GetDomainResponder(resp *http.Response) (result Domain, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetDomains sends the get domains request.
func (client BaseClient) GetDomains(ctx context.Context) (result ListDomain, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetDomains")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetDomainsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetDomains", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetDomainsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetDomains", resp, "Failure sending request")
		return
	}

	result, err = client.GetDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetDomains", resp, "Failure responding to request")
	}

	return
}

// GetDomainsPreparer prepares the GetDomains request.
func (client BaseClient) GetDomainsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPath("/domains"),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetDomainsSender sends the GetDomains request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetDomainsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetDomainsResponder handles the response to the GetDomains request. The method always
// closes the http.Response Body.
func (client BaseClient) GetDomainsResponder(resp *http.Response) (result ListDomain, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetExports sends the get exports request.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id.
func (client BaseClient) GetExports(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (result ListExport, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetExports")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetExportsPreparer(ctx, projectID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetExports", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetExportsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetExports", resp, "Failure sending request")
		return
	}

	result, err = client.GetExportsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetExports", resp, "Failure responding to request")
	}

	return
}

// GetExportsPreparer prepares the GetExports request.
func (client BaseClient) GetExportsPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/export", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetExportsSender sends the GetExports request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetExportsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetExportsResponder handles the response to the GetExports request. The method always
// closes the http.Response Body.
func (client BaseClient) GetExportsResponder(resp *http.Response) (result ListExport, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetImagePerformanceCount the filtering is on an and/or relationship. For example, if the provided tag ids are for
// the "Dog" and
// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
// tagIds - a list of tags ids to filter the images to count. Defaults to all tags when null.
func (client BaseClient) GetImagePerformanceCount(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, tagIds []uuid.UUID) (result Int32, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetImagePerformanceCount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetImagePerformanceCountPreparer(ctx, projectID, iterationID, tagIds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagePerformanceCount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetImagePerformanceCountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagePerformanceCount", resp, "Failure sending request")
		return
	}

	result, err = client.GetImagePerformanceCountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagePerformanceCount", resp, "Failure responding to request")
	}

	return
}

// GetImagePerformanceCountPreparer prepares the GetImagePerformanceCount request.
func (client BaseClient) GetImagePerformanceCountPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, tagIds []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if tagIds != nil && len(tagIds) > 0 {
		queryParameters["tagIds"] = autorest.Encode("query", tagIds, ",")
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/performance/images/count", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetImagePerformanceCountSender sends the GetImagePerformanceCount request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetImagePerformanceCountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetImagePerformanceCountResponder handles the response to the GetImagePerformanceCount request. The method always
// closes the http.Response Body.
func (client BaseClient) GetImagePerformanceCountResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetImagePerformances this API supports batching and range selection. By default it will only return first 50 images
// matching images.
// Use the {take} and {skip} parameters to control how many images to return in a given batch.
// The filtering is on an and/or relationship. For example, if the provided tag ids are for the "Dog" and
// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
// tagIds - a list of tags ids to filter the images. Defaults to all tagged images when null. Limited to 20.
// orderBy - the ordering. Defaults to newest.
// take - maximum number of images to return. Defaults to 50, limited to 256.
// skip - number of images to skip before beginning the image batch. Defaults to 0.
func (client BaseClient) GetImagePerformances(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, tagIds []uuid.UUID, orderBy string, take *int32, skip *int32) (result ListImagePerformance, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetImagePerformances")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: tagIds,
			Constraints: []validation.Constraint{{Target: "tagIds", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "tagIds", Name: validation.MaxItems, Rule: 20, Chain: nil},
					{Target: "tagIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(256), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "GetImagePerformances", err.Error())
	}

	req, err := client.GetImagePerformancesPreparer(ctx, projectID, iterationID, tagIds, orderBy, take, skip)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagePerformances", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetImagePerformancesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagePerformances", resp, "Failure sending request")
		return
	}

	result, err = client.GetImagePerformancesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagePerformances", resp, "Failure responding to request")
	}

	return
}

// GetImagePerformancesPreparer prepares the GetImagePerformances request.
func (client BaseClient) GetImagePerformancesPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, tagIds []uuid.UUID, orderBy string, take *int32, skip *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if tagIds != nil && len(tagIds) > 0 {
		queryParameters["tagIds"] = autorest.Encode("query", tagIds, ",")
	}
	if len(string(orderBy)) > 0 {
		queryParameters["orderBy"] = autorest.Encode("query", orderBy)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 50)
	}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/performance/images", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetImagePerformancesSender sends the GetImagePerformances request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetImagePerformancesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetImagePerformancesResponder handles the response to the GetImagePerformances request. The method always
// closes the http.Response Body.
func (client BaseClient) GetImagePerformancesResponder(resp *http.Response) (result ListImagePerformance, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetImageRegionProposals this API will get region proposals for an image along with confidences for the region. It
// returns an empty array if no proposals are found.
// Parameters:
// projectID - the project id.
// imageID - the image id.
func (client BaseClient) GetImageRegionProposals(ctx context.Context, projectID uuid.UUID, imageID uuid.UUID) (result ImageRegionProposal, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetImageRegionProposals")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetImageRegionProposalsPreparer(ctx, projectID, imageID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImageRegionProposals", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetImageRegionProposalsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImageRegionProposals", resp, "Failure sending request")
		return
	}

	result, err = client.GetImageRegionProposalsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImageRegionProposals", resp, "Failure responding to request")
	}

	return
}

// GetImageRegionProposalsPreparer prepares the GetImageRegionProposals request.
func (client BaseClient) GetImageRegionProposalsPreparer(ctx context.Context, projectID uuid.UUID, imageID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"imageId":   autorest.Encode("path", imageID),
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/{imageId}/regionproposals", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetImageRegionProposalsSender sends the GetImageRegionProposals request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetImageRegionProposalsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetImageRegionProposalsResponder handles the response to the GetImageRegionProposals request. The method always
// closes the http.Response Body.
func (client BaseClient) GetImageRegionProposalsResponder(resp *http.Response) (result ImageRegionProposal, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetImagesByIds this API will return a set of Images for the specified tags and optionally iteration. If no iteration
// is specified the
// current workspace is used.
// Parameters:
// projectID - the project id.
// imageIds - the list of image ids to retrieve. Limited to 256.
// iterationID - the iteration id. Defaults to workspace.
func (client BaseClient) GetImagesByIds(ctx context.Context, projectID uuid.UUID, imageIds []uuid.UUID, iterationID *uuid.UUID) (result ListImage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetImagesByIds")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageIds,
			Constraints: []validation.Constraint{{Target: "imageIds", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "imageIds", Name: validation.MaxItems, Rule: 256, Chain: nil},
					{Target: "imageIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "GetImagesByIds", err.Error())
	}

	req, err := client.GetImagesByIdsPreparer(ctx, projectID, imageIds, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagesByIds", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetImagesByIdsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagesByIds", resp, "Failure sending request")
		return
	}

	result, err = client.GetImagesByIdsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetImagesByIds", resp, "Failure responding to request")
	}

	return
}

// GetImagesByIdsPreparer prepares the GetImagesByIds request.
func (client BaseClient) GetImagesByIdsPreparer(ctx context.Context, projectID uuid.UUID, imageIds []uuid.UUID, iterationID *uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if imageIds != nil && len(imageIds) > 0 {
		queryParameters["imageIds"] = autorest.Encode("query", imageIds, ",")
	}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/id", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetImagesByIdsSender sends the GetImagesByIds request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetImagesByIdsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetImagesByIdsResponder handles the response to the GetImagesByIds request. The method always
// closes the http.Response Body.
func (client BaseClient) GetImagesByIdsResponder(resp *http.Response) (result ListImage, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIteration sends the get iteration request.
// Parameters:
// projectID - the id of the project the iteration belongs to.
// iterationID - the id of the iteration to get.
func (client BaseClient) GetIteration(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (result Iteration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetIteration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetIterationPreparer(ctx, projectID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIteration", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIterationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIteration", resp, "Failure sending request")
		return
	}

	result, err = client.GetIterationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIteration", resp, "Failure responding to request")
	}

	return
}

// GetIterationPreparer prepares the GetIteration request.
func (client BaseClient) GetIterationPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIterationSender sends the GetIteration request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetIterationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetIterationResponder handles the response to the GetIteration request. The method always
// closes the http.Response Body.
func (client BaseClient) GetIterationResponder(resp *http.Response) (result Iteration, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIterationPerformance sends the get iteration performance request.
// Parameters:
// projectID - the id of the project the iteration belongs to.
// iterationID - the id of the iteration to get.
// threshold - the threshold used to determine true predictions.
// overlapThreshold - if applicable, the bounding box overlap threshold used to determine true predictions.
func (client BaseClient) GetIterationPerformance(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, threshold *float64, overlapThreshold *float64) (result IterationPerformance, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetIterationPerformance")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetIterationPerformancePreparer(ctx, projectID, iterationID, threshold, overlapThreshold)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIterationPerformance", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIterationPerformanceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIterationPerformance", resp, "Failure sending request")
		return
	}

	result, err = client.GetIterationPerformanceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIterationPerformance", resp, "Failure responding to request")
	}

	return
}

// GetIterationPerformancePreparer prepares the GetIterationPerformance request.
func (client BaseClient) GetIterationPerformancePreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, threshold *float64, overlapThreshold *float64) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if threshold != nil {
		queryParameters["threshold"] = autorest.Encode("query", *threshold)
	}
	if overlapThreshold != nil {
		queryParameters["overlapThreshold"] = autorest.Encode("query", *overlapThreshold)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/performance", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIterationPerformanceSender sends the GetIterationPerformance request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetIterationPerformanceSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetIterationPerformanceResponder handles the response to the GetIterationPerformance request. The method always
// closes the http.Response Body.
func (client BaseClient) GetIterationPerformanceResponder(resp *http.Response) (result IterationPerformance, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetIterations sends the get iterations request.
// Parameters:
// projectID - the project id.
func (client BaseClient) GetIterations(ctx context.Context, projectID uuid.UUID) (result ListIteration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetIterations")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetIterationsPreparer(ctx, projectID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIterations", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetIterationsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIterations", resp, "Failure sending request")
		return
	}

	result, err = client.GetIterationsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetIterations", resp, "Failure responding to request")
	}

	return
}

// GetIterationsPreparer prepares the GetIterations request.
func (client BaseClient) GetIterationsPreparer(ctx context.Context, projectID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetIterationsSender sends the GetIterations request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetIterationsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetIterationsResponder handles the response to the GetIterations request. The method always
// closes the http.Response Body.
func (client BaseClient) GetIterationsResponder(resp *http.Response) (result ListIteration, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProject sends the get project request.
// Parameters:
// projectID - the id of the project to get.
func (client BaseClient) GetProject(ctx context.Context, projectID uuid.UUID) (result Project, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetProject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetProjectPreparer(ctx, projectID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetProject", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetProject", resp, "Failure sending request")
		return
	}

	result, err = client.GetProjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetProject", resp, "Failure responding to request")
	}

	return
}

// GetProjectPreparer prepares the GetProject request.
func (client BaseClient) GetProjectPreparer(ctx context.Context, projectID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProjectSender sends the GetProject request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetProjectSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetProjectResponder handles the response to the GetProject request. The method always
// closes the http.Response Body.
func (client BaseClient) GetProjectResponder(resp *http.Response) (result Project, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetProjects sends the get projects request.
func (client BaseClient) GetProjects(ctx context.Context) (result ListProject, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetProjects")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetProjectsPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetProjects", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetProjectsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetProjects", resp, "Failure sending request")
		return
	}

	result, err = client.GetProjectsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetProjects", resp, "Failure responding to request")
	}

	return
}

// GetProjectsPreparer prepares the GetProjects request.
func (client BaseClient) GetProjectsPreparer(ctx context.Context) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPath("/projects"),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetProjectsSender sends the GetProjects request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetProjectsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetProjectsResponder handles the response to the GetProjects request. The method always
// closes the http.Response Body.
func (client BaseClient) GetProjectsResponder(resp *http.Response) (result ListProject, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTag sends the get tag request.
// Parameters:
// projectID - the project this tag belongs to.
// tagID - the tag id.
// iterationID - the iteration to retrieve this tag from. Optional, defaults to current training set.
func (client BaseClient) GetTag(ctx context.Context, projectID uuid.UUID, tagID uuid.UUID, iterationID *uuid.UUID) (result Tag, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetTag")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTagPreparer(ctx, projectID, tagID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTag", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTagSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTag", resp, "Failure sending request")
		return
	}

	result, err = client.GetTagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTag", resp, "Failure responding to request")
	}

	return
}

// GetTagPreparer prepares the GetTag request.
func (client BaseClient) GetTagPreparer(ctx context.Context, projectID uuid.UUID, tagID uuid.UUID, iterationID *uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
		"tagId":     autorest.Encode("path", tagID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/tags/{tagId}", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTagSender sends the GetTag request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetTagSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetTagResponder handles the response to the GetTag request. The method always
// closes the http.Response Body.
func (client BaseClient) GetTagResponder(resp *http.Response) (result Tag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTaggedImageCount the filtering is on an and/or relationship. For example, if the provided tag ids are for the
// "Dog" and
// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
// tagIds - a list of tags ids to filter the images to count. Defaults to all tags when null.
func (client BaseClient) GetTaggedImageCount(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID, tagIds []uuid.UUID) (result Int32, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetTaggedImageCount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTaggedImageCountPreparer(ctx, projectID, iterationID, tagIds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTaggedImageCount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTaggedImageCountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTaggedImageCount", resp, "Failure sending request")
		return
	}

	result, err = client.GetTaggedImageCountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTaggedImageCount", resp, "Failure responding to request")
	}

	return
}

// GetTaggedImageCountPreparer prepares the GetTaggedImageCount request.
func (client BaseClient) GetTaggedImageCountPreparer(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID, tagIds []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}
	if tagIds != nil && len(tagIds) > 0 {
		queryParameters["tagIds"] = autorest.Encode("query", tagIds, ",")
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/tagged/count", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTaggedImageCountSender sends the GetTaggedImageCount request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetTaggedImageCountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetTaggedImageCountResponder handles the response to the GetTaggedImageCount request. The method always
// closes the http.Response Body.
func (client BaseClient) GetTaggedImageCountResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTaggedImages this API supports batching and range selection. By default it will only return first 50 images
// matching images.
// Use the {take} and {skip} parameters to control how many images to return in a given batch.
// The filtering is on an and/or relationship. For example, if the provided tag ids are for the "Dog" and
// "Cat" tags, then only images tagged with Dog and/or Cat will be returned
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
// tagIds - a list of tags ids to filter the images. Defaults to all tagged images when null. Limited to 20.
// orderBy - the ordering. Defaults to newest.
// take - maximum number of images to return. Defaults to 50, limited to 256.
// skip - number of images to skip before beginning the image batch. Defaults to 0.
func (client BaseClient) GetTaggedImages(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID, tagIds []uuid.UUID, orderBy string, take *int32, skip *int32) (result ListImage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetTaggedImages")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: tagIds,
			Constraints: []validation.Constraint{{Target: "tagIds", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "tagIds", Name: validation.MaxItems, Rule: 20, Chain: nil},
					{Target: "tagIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}},
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(256), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "GetTaggedImages", err.Error())
	}

	req, err := client.GetTaggedImagesPreparer(ctx, projectID, iterationID, tagIds, orderBy, take, skip)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTaggedImages", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTaggedImagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTaggedImages", resp, "Failure sending request")
		return
	}

	result, err = client.GetTaggedImagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTaggedImages", resp, "Failure responding to request")
	}

	return
}

// GetTaggedImagesPreparer prepares the GetTaggedImages request.
func (client BaseClient) GetTaggedImagesPreparer(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID, tagIds []uuid.UUID, orderBy string, take *int32, skip *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}
	if tagIds != nil && len(tagIds) > 0 {
		queryParameters["tagIds"] = autorest.Encode("query", tagIds, ",")
	}
	if len(string(orderBy)) > 0 {
		queryParameters["orderBy"] = autorest.Encode("query", orderBy)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 50)
	}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/tagged", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTaggedImagesSender sends the GetTaggedImages request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetTaggedImagesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetTaggedImagesResponder handles the response to the GetTaggedImages request. The method always
// closes the http.Response Body.
func (client BaseClient) GetTaggedImagesResponder(resp *http.Response) (result ListImage, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetTags sends the get tags request.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
func (client BaseClient) GetTags(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID) (result ListTag, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetTags")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetTagsPreparer(ctx, projectID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTags", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetTagsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTags", resp, "Failure sending request")
		return
	}

	result, err = client.GetTagsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetTags", resp, "Failure responding to request")
	}

	return
}

// GetTagsPreparer prepares the GetTags request.
func (client BaseClient) GetTagsPreparer(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/tags", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetTagsSender sends the GetTags request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetTagsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetTagsResponder handles the response to the GetTags request. The method always
// closes the http.Response Body.
func (client BaseClient) GetTagsResponder(resp *http.Response) (result ListTag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetUntaggedImageCount this API returns the images which have no tags for a given project and optionally an
// iteration. If no iteration is specified the
// current workspace is used.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
func (client BaseClient) GetUntaggedImageCount(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID) (result Int32, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetUntaggedImageCount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetUntaggedImageCountPreparer(ctx, projectID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetUntaggedImageCount", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUntaggedImageCountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetUntaggedImageCount", resp, "Failure sending request")
		return
	}

	result, err = client.GetUntaggedImageCountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetUntaggedImageCount", resp, "Failure responding to request")
	}

	return
}

// GetUntaggedImageCountPreparer prepares the GetUntaggedImageCount request.
func (client BaseClient) GetUntaggedImageCountPreparer(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/untagged/count", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUntaggedImageCountSender sends the GetUntaggedImageCount request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetUntaggedImageCountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetUntaggedImageCountResponder handles the response to the GetUntaggedImageCount request. The method always
// closes the http.Response Body.
func (client BaseClient) GetUntaggedImageCountResponder(resp *http.Response) (result Int32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetUntaggedImages this API supports batching and range selection. By default it will only return first 50 images
// matching images.
// Use the {take} and {skip} parameters to control how many images to return in a given batch.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id. Defaults to workspace.
// orderBy - the ordering. Defaults to newest.
// take - maximum number of images to return. Defaults to 50, limited to 256.
// skip - number of images to skip before beginning the image batch. Defaults to 0.
func (client BaseClient) GetUntaggedImages(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID, orderBy string, take *int32, skip *int32) (result ListImage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetUntaggedImages")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: take,
			Constraints: []validation.Constraint{{Target: "take", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "take", Name: validation.InclusiveMaximum, Rule: int64(256), Chain: nil},
					{Target: "take", Name: validation.InclusiveMinimum, Rule: int64(0), Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "GetUntaggedImages", err.Error())
	}

	req, err := client.GetUntaggedImagesPreparer(ctx, projectID, iterationID, orderBy, take, skip)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetUntaggedImages", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetUntaggedImagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetUntaggedImages", resp, "Failure sending request")
		return
	}

	result, err = client.GetUntaggedImagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "GetUntaggedImages", resp, "Failure responding to request")
	}

	return
}

// GetUntaggedImagesPreparer prepares the GetUntaggedImages request.
func (client BaseClient) GetUntaggedImagesPreparer(ctx context.Context, projectID uuid.UUID, iterationID *uuid.UUID, orderBy string, take *int32, skip *int32) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}
	if len(string(orderBy)) > 0 {
		queryParameters["orderBy"] = autorest.Encode("query", orderBy)
	}
	if take != nil {
		queryParameters["take"] = autorest.Encode("query", *take)
	} else {
		queryParameters["take"] = autorest.Encode("query", 50)
	}
	if skip != nil {
		queryParameters["skip"] = autorest.Encode("query", *skip)
	} else {
		queryParameters["skip"] = autorest.Encode("query", 0)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/untagged", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetUntaggedImagesSender sends the GetUntaggedImages request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetUntaggedImagesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// GetUntaggedImagesResponder handles the response to the GetUntaggedImages request. The method always
// closes the http.Response Body.
func (client BaseClient) GetUntaggedImagesResponder(resp *http.Response) (result ListImage, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PublishIteration sends the publish iteration request.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id.
// publishName - the name to give the published iteration.
// predictionID - the id of the prediction resource to publish to.
func (client BaseClient) PublishIteration(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, publishName string, predictionID string) (result Bool, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.PublishIteration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PublishIterationPreparer(ctx, projectID, iterationID, publishName, predictionID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "PublishIteration", nil, "Failure preparing request")
		return
	}

	resp, err := client.PublishIterationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "PublishIteration", resp, "Failure sending request")
		return
	}

	result, err = client.PublishIterationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "PublishIteration", resp, "Failure responding to request")
	}

	return
}

// PublishIterationPreparer prepares the PublishIteration request.
func (client BaseClient) PublishIterationPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, publishName string, predictionID string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"predictionId": autorest.Encode("query", predictionID),
		"publishName":  autorest.Encode("query", publishName),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/publish", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PublishIterationSender sends the PublishIteration request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) PublishIterationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// PublishIterationResponder handles the response to the PublishIteration request. The method always
// closes the http.Response Body.
func (client BaseClient) PublishIterationResponder(resp *http.Response) (result Bool, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QueryPredictions sends the query predictions request.
// Parameters:
// projectID - the project id.
// query - parameters used to query the predictions. Limited to combining 2 tags.
func (client BaseClient) QueryPredictions(ctx context.Context, projectID uuid.UUID, query PredictionQueryToken) (result PredictionQueryResult, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.QueryPredictions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.QueryPredictionsPreparer(ctx, projectID, query)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QueryPredictions", nil, "Failure preparing request")
		return
	}

	resp, err := client.QueryPredictionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QueryPredictions", resp, "Failure sending request")
		return
	}

	result, err = client.QueryPredictionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QueryPredictions", resp, "Failure responding to request")
	}

	return
}

// QueryPredictionsPreparer prepares the QueryPredictions request.
func (client BaseClient) QueryPredictionsPreparer(ctx context.Context, projectID uuid.UUID, query PredictionQueryToken) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/predictions/query", pathParameters),
		autorest.WithJSON(query),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QueryPredictionsSender sends the QueryPredictions request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) QueryPredictionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// QueryPredictionsResponder handles the response to the QueryPredictions request. The method always
// closes the http.Response Body.
func (client BaseClient) QueryPredictionsResponder(resp *http.Response) (result PredictionQueryResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QuerySuggestedImageCount this API takes in tagIds to get count of untagged images per suggested tags for a given
// threshold.
// Parameters:
// projectID - the project id.
// iterationID - iterationId to use for the suggested tags and regions.
// query - model that contains tagIds, threshold and projectType to query by.
func (client BaseClient) QuerySuggestedImageCount(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, query TagFilter) (result SetInt32, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.QuerySuggestedImageCount")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.QuerySuggestedImageCountPreparer(ctx, projectID, iterationID, query)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuerySuggestedImageCount", nil, "Failure preparing request")
		return
	}

	resp, err := client.QuerySuggestedImageCountSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuerySuggestedImageCount", resp, "Failure sending request")
		return
	}

	result, err = client.QuerySuggestedImageCountResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuerySuggestedImageCount", resp, "Failure responding to request")
	}

	return
}

// QuerySuggestedImageCountPreparer prepares the QuerySuggestedImageCount request.
func (client BaseClient) QuerySuggestedImageCountPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, query TagFilter) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"iterationId": autorest.Encode("query", iterationID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/suggested/count", pathParameters),
		autorest.WithJSON(query),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QuerySuggestedImageCountSender sends the QuerySuggestedImageCount request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) QuerySuggestedImageCountSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// QuerySuggestedImageCountResponder handles the response to the QuerySuggestedImageCount request. The method always
// closes the http.Response Body.
func (client BaseClient) QuerySuggestedImageCountResponder(resp *http.Response) (result SetInt32, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QuerySuggestedImages this API will fetch untagged images filtered by suggested tags Ids. It returns an empty array
// if no images are found.
// Parameters:
// projectID - the project id.
// iterationID - iterationId to use for the suggested tags and regions.
// query - contains properties we need to query suggested images.
func (client BaseClient) QuerySuggestedImages(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, query SuggestedTagAndRegionQueryToken) (result SuggestedTagAndRegionQuery, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.QuerySuggestedImages")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.QuerySuggestedImagesPreparer(ctx, projectID, iterationID, query)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuerySuggestedImages", nil, "Failure preparing request")
		return
	}

	resp, err := client.QuerySuggestedImagesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuerySuggestedImages", resp, "Failure sending request")
		return
	}

	result, err = client.QuerySuggestedImagesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuerySuggestedImages", resp, "Failure responding to request")
	}

	return
}

// QuerySuggestedImagesPreparer prepares the QuerySuggestedImages request.
func (client BaseClient) QuerySuggestedImagesPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, query SuggestedTagAndRegionQueryToken) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"iterationId": autorest.Encode("query", iterationID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/images/suggested", pathParameters),
		autorest.WithJSON(query),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QuerySuggestedImagesSender sends the QuerySuggestedImages request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) QuerySuggestedImagesSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// QuerySuggestedImagesResponder handles the response to the QuerySuggestedImages request. The method always
// closes the http.Response Body.
func (client BaseClient) QuerySuggestedImagesResponder(resp *http.Response) (result SuggestedTagAndRegionQuery, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QuickTestImage sends the quick test image request.
// Parameters:
// projectID - the project id.
// imageData - binary image data. Supported formats are JPEG, GIF, PNG, and BMP. Supports images up to 6MB.
// iterationID - optional. Specifies the id of a particular iteration to evaluate against.
// The default iteration for the project will be used when not specified.
// store - optional. Specifies whether or not to store the result of this prediction. The default is true, to
// store.
func (client BaseClient) QuickTestImage(ctx context.Context, projectID uuid.UUID, imageData io.ReadCloser, iterationID *uuid.UUID, store *bool) (result ImagePrediction, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.QuickTestImage")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.QuickTestImagePreparer(ctx, projectID, imageData, iterationID, store)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuickTestImage", nil, "Failure preparing request")
		return
	}

	resp, err := client.QuickTestImageSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuickTestImage", resp, "Failure sending request")
		return
	}

	result, err = client.QuickTestImageResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuickTestImage", resp, "Failure responding to request")
	}

	return
}

// QuickTestImagePreparer prepares the QuickTestImage request.
func (client BaseClient) QuickTestImagePreparer(ctx context.Context, projectID uuid.UUID, imageData io.ReadCloser, iterationID *uuid.UUID, store *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}
	if store != nil {
		queryParameters["store"] = autorest.Encode("query", *store)
	} else {
		queryParameters["store"] = autorest.Encode("query", true)
	}

	formDataParameters := map[string]interface{}{
		"imageData": imageData,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/quicktest/image", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithMultiPartFormData(formDataParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QuickTestImageSender sends the QuickTestImage request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) QuickTestImageSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// QuickTestImageResponder handles the response to the QuickTestImage request. The method always
// closes the http.Response Body.
func (client BaseClient) QuickTestImageResponder(resp *http.Response) (result ImagePrediction, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// QuickTestImageURL sends the quick test image url request.
// Parameters:
// projectID - the project to evaluate against.
// imageURL - an ImageUrl that contains the url of the image to be evaluated.
// iterationID - optional. Specifies the id of a particular iteration to evaluate against.
// The default iteration for the project will be used when not specified.
// store - optional. Specifies whether or not to store the result of this prediction. The default is true, to
// store.
func (client BaseClient) QuickTestImageURL(ctx context.Context, projectID uuid.UUID, imageURL ImageURL, iterationID *uuid.UUID, store *bool) (result ImagePrediction, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.QuickTestImageURL")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageURL,
			Constraints: []validation.Constraint{{Target: "imageURL.URL", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "QuickTestImageURL", err.Error())
	}

	req, err := client.QuickTestImageURLPreparer(ctx, projectID, imageURL, iterationID, store)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuickTestImageURL", nil, "Failure preparing request")
		return
	}

	resp, err := client.QuickTestImageURLSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuickTestImageURL", resp, "Failure sending request")
		return
	}

	result, err = client.QuickTestImageURLResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "QuickTestImageURL", resp, "Failure responding to request")
	}

	return
}

// QuickTestImageURLPreparer prepares the QuickTestImageURL request.
func (client BaseClient) QuickTestImageURLPreparer(ctx context.Context, projectID uuid.UUID, imageURL ImageURL, iterationID *uuid.UUID, store *bool) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if iterationID != nil {
		queryParameters["iterationId"] = autorest.Encode("query", *iterationID)
	}
	if store != nil {
		queryParameters["store"] = autorest.Encode("query", *store)
	} else {
		queryParameters["store"] = autorest.Encode("query", true)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/quicktest/url", pathParameters),
		autorest.WithJSON(imageURL),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// QuickTestImageURLSender sends the QuickTestImageURL request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) QuickTestImageURLSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// QuickTestImageURLResponder handles the response to the QuickTestImageURL request. The method always
// closes the http.Response Body.
func (client BaseClient) QuickTestImageURLResponder(resp *http.Response) (result ImagePrediction, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// SuggestTagsAndRegions this API will get suggested tags and regions for an array/batch of untagged images along with
// confidences for the tags. It returns an empty array if no tags are found.
// There is a limit of 64 images in the batch.
// Parameters:
// projectID - the project id.
// iterationID - iterationId to use for tag and region suggestion.
// imageIds - array of image ids tag suggestion are needed for. Use GetUntaggedImages API to get imageIds.
func (client BaseClient) SuggestTagsAndRegions(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, imageIds []uuid.UUID) (result ListSuggestedTagAndRegion, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.SuggestTagsAndRegions")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: imageIds,
			Constraints: []validation.Constraint{{Target: "imageIds", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "imageIds", Name: validation.MaxItems, Rule: 64, Chain: nil},
					{Target: "imageIds", Name: validation.MinItems, Rule: 0, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("training.BaseClient", "SuggestTagsAndRegions", err.Error())
	}

	req, err := client.SuggestTagsAndRegionsPreparer(ctx, projectID, iterationID, imageIds)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "SuggestTagsAndRegions", nil, "Failure preparing request")
		return
	}

	resp, err := client.SuggestTagsAndRegionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "SuggestTagsAndRegions", resp, "Failure sending request")
		return
	}

	result, err = client.SuggestTagsAndRegionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "SuggestTagsAndRegions", resp, "Failure responding to request")
	}

	return
}

// SuggestTagsAndRegionsPreparer prepares the SuggestTagsAndRegions request.
func (client BaseClient) SuggestTagsAndRegionsPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, imageIds []uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{
		"imageIds":    autorest.Encode("query", imageIds, ","),
		"iterationId": autorest.Encode("query", iterationID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/tagsandregions/suggestions", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// SuggestTagsAndRegionsSender sends the SuggestTagsAndRegions request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) SuggestTagsAndRegionsSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// SuggestTagsAndRegionsResponder handles the response to the SuggestTagsAndRegions request. The method always
// closes the http.Response Body.
func (client BaseClient) SuggestTagsAndRegionsResponder(resp *http.Response) (result ListSuggestedTagAndRegion, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result.Value),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// TrainProject sends the train project request.
// Parameters:
// projectID - the project id.
// trainingType - the type of training to use to train the project (default: Regular).
// reservedBudgetInHours - the number of hours reserved as budget for training (if applicable).
// forceTrain - whether to force train even if dataset and configuration does not change (default: false).
// notificationEmailAddress - the email address to send notification to when training finishes (default: null).
func (client BaseClient) TrainProject(ctx context.Context, projectID uuid.UUID, trainingType string, reservedBudgetInHours *int32, forceTrain *bool, notificationEmailAddress string) (result Iteration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.TrainProject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.TrainProjectPreparer(ctx, projectID, trainingType, reservedBudgetInHours, forceTrain, notificationEmailAddress)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "TrainProject", nil, "Failure preparing request")
		return
	}

	resp, err := client.TrainProjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "TrainProject", resp, "Failure sending request")
		return
	}

	result, err = client.TrainProjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "TrainProject", resp, "Failure responding to request")
	}

	return
}

// TrainProjectPreparer prepares the TrainProject request.
func (client BaseClient) TrainProjectPreparer(ctx context.Context, projectID uuid.UUID, trainingType string, reservedBudgetInHours *int32, forceTrain *bool, notificationEmailAddress string) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	queryParameters := map[string]interface{}{}
	if len(string(trainingType)) > 0 {
		queryParameters["trainingType"] = autorest.Encode("query", trainingType)
	}
	if reservedBudgetInHours != nil {
		queryParameters["reservedBudgetInHours"] = autorest.Encode("query", *reservedBudgetInHours)
	} else {
		queryParameters["reservedBudgetInHours"] = autorest.Encode("query", 0)
	}
	if forceTrain != nil {
		queryParameters["forceTrain"] = autorest.Encode("query", *forceTrain)
	} else {
		queryParameters["forceTrain"] = autorest.Encode("query", false)
	}
	if len(notificationEmailAddress) > 0 {
		queryParameters["notificationEmailAddress"] = autorest.Encode("query", notificationEmailAddress)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/train", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TrainProjectSender sends the TrainProject request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) TrainProjectSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// TrainProjectResponder handles the response to the TrainProject request. The method always
// closes the http.Response Body.
func (client BaseClient) TrainProjectResponder(resp *http.Response) (result Iteration, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UnpublishIteration sends the unpublish iteration request.
// Parameters:
// projectID - the project id.
// iterationID - the iteration id.
func (client BaseClient) UnpublishIteration(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UnpublishIteration")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UnpublishIterationPreparer(ctx, projectID, iterationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UnpublishIteration", nil, "Failure preparing request")
		return
	}

	resp, err := client.UnpublishIterationSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UnpublishIteration", resp, "Failure sending request")
		return
	}

	result, err = client.UnpublishIterationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UnpublishIteration", resp, "Failure responding to request")
	}

	return
}

// UnpublishIterationPreparer prepares the UnpublishIteration request.
func (client BaseClient) UnpublishIterationPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}/publish", pathParameters),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UnpublishIterationSender sends the UnpublishIteration request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UnpublishIterationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UnpublishIterationResponder handles the response to the UnpublishIteration request. The method always
// closes the http.Response Body.
func (client BaseClient) UnpublishIterationResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateIteration sends the update iteration request.
// Parameters:
// projectID - project id.
// iterationID - iteration id.
// updatedIteration - the updated iteration model.
func (client BaseClient) UpdateIteration(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, updatedIteration Iteration) (result Iteration, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateIteration")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateIterationPreparer(ctx, projectID, iterationID, updatedIteration)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateIteration", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateIterationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateIteration", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateIterationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateIteration", resp, "Failure responding to request")
	}

	return
}

// UpdateIterationPreparer prepares the UpdateIteration request.
func (client BaseClient) UpdateIterationPreparer(ctx context.Context, projectID uuid.UUID, iterationID uuid.UUID, updatedIteration Iteration) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"iterationId": autorest.Encode("path", iterationID),
		"projectId":   autorest.Encode("path", projectID),
	}

	updatedIteration.ID = nil
	updatedIteration.Status = nil
	updatedIteration.Created = nil
	updatedIteration.LastModified = nil
	updatedIteration.TrainedAt = nil
	updatedIteration.ProjectID = nil
	updatedIteration.Exportable = nil
	updatedIteration.ExportableTo = nil
	updatedIteration.DomainID = nil
	updatedIteration.ClassificationType = ""
	updatedIteration.TrainingType = ""
	updatedIteration.ReservedBudgetInHours = nil
	updatedIteration.TrainingTimeInMinutes = nil
	updatedIteration.PublishName = nil
	updatedIteration.OriginalPublishResourceID = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/iterations/{iterationId}", pathParameters),
		autorest.WithJSON(updatedIteration),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateIterationSender sends the UpdateIteration request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateIterationSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateIterationResponder handles the response to the UpdateIteration request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateIterationResponder(resp *http.Response) (result Iteration, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateProject sends the update project request.
// Parameters:
// projectID - the id of the project to update.
// updatedProject - the updated project model.
func (client BaseClient) UpdateProject(ctx context.Context, projectID uuid.UUID, updatedProject Project) (result Project, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateProject")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateProjectPreparer(ctx, projectID, updatedProject)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateProject", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateProjectSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateProject", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateProjectResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateProject", resp, "Failure responding to request")
	}

	return
}

// UpdateProjectPreparer prepares the UpdateProject request.
func (client BaseClient) UpdateProjectPreparer(ctx context.Context, projectID uuid.UUID, updatedProject Project) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
	}

	updatedProject.ID = nil
	updatedProject.Created = nil
	updatedProject.LastModified = nil
	updatedProject.ThumbnailURI = nil
	updatedProject.DrModeEnabled = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}", pathParameters),
		autorest.WithJSON(updatedProject),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateProjectSender sends the UpdateProject request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateProjectSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateProjectResponder handles the response to the UpdateProject request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateProjectResponder(resp *http.Response) (result Project, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateTag sends the update tag request.
// Parameters:
// projectID - the project id.
// tagID - the id of the target tag.
// updatedTag - the updated tag model.
func (client BaseClient) UpdateTag(ctx context.Context, projectID uuid.UUID, tagID uuid.UUID, updatedTag Tag) (result Tag, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.UpdateTag")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.UpdateTagPreparer(ctx, projectID, tagID, updatedTag)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateTag", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateTagSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateTag", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateTagResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "training.BaseClient", "UpdateTag", resp, "Failure responding to request")
	}

	return
}

// UpdateTagPreparer prepares the UpdateTag request.
func (client BaseClient) UpdateTagPreparer(ctx context.Context, projectID uuid.UUID, tagID uuid.UUID, updatedTag Tag) (*http.Request, error) {
	urlParameters := map[string]interface{}{
		"Endpoint": client.Endpoint,
	}

	pathParameters := map[string]interface{}{
		"projectId": autorest.Encode("path", projectID),
		"tagId":     autorest.Encode("path", tagID),
	}

	updatedTag.ID = nil
	updatedTag.ImageCount = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithCustomBaseURL("{Endpoint}/customvision/v3.1/training", urlParameters),
		autorest.WithPathParameters("/projects/{projectId}/tags/{tagId}", pathParameters),
		autorest.WithJSON(updatedTag),
		autorest.WithHeader("Training-Key", client.APIKey))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateTagSender sends the UpdateTag request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) UpdateTagSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	return autorest.SendWithSender(client, req, sd...)
}

// UpdateTagResponder handles the response to the UpdateTag request. The method always
// closes the http.Response Body.
func (client BaseClient) UpdateTagResponder(resp *http.Response) (result Tag, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
