// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates an IPAM prefix list resolver target.
//
// An IPAM prefix list resolver target is an association between a specific
// customer-managed prefix list and an IPAM prefix list resolver. The target
// enables the resolver to synchronize CIDRs selected by its rules into the
// specified prefix list, which can then be referenced in Amazon Web Services
// resources.
//
// For more information about IPAM prefix list resolver, see [Automate prefix list updates with IPAM] in the Amazon VPC
// IPAM User Guide.
//
// [Automate prefix list updates with IPAM]: https://docs.aws.amazon.com/vpc/latest/ipam/automate-prefix-list-updates.html
func (c *Client) CreateIpamPrefixListResolverTarget(ctx context.Context, params *CreateIpamPrefixListResolverTargetInput, optFns ...func(*Options)) (*CreateIpamPrefixListResolverTargetOutput, error) {
	if params == nil {
		params = &CreateIpamPrefixListResolverTargetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateIpamPrefixListResolverTarget", params, optFns, c.addOperationCreateIpamPrefixListResolverTargetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateIpamPrefixListResolverTargetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateIpamPrefixListResolverTargetInput struct {

	// The ID of the IPAM prefix list resolver that will manage the synchronization of
	// CIDRs to the target prefix list.
	//
	// This member is required.
	IpamPrefixListResolverId *string

	// The ID of the managed prefix list that will be synchronized with CIDRs selected
	// by the IPAM prefix list resolver. This prefix list becomes an IPAM managed
	// prefix list.
	//
	// An IPAM-managed prefix list is a customer-managed prefix list that has been
	// associated with an IPAM prefix list resolver target. When a prefix list becomes
	// IPAM managed, its CIDRs are automatically synchronized based on the IPAM prefix
	// list resolver's CIDR selection rules, and direct CIDR modifications are
	// restricted.
	//
	// This member is required.
	PrefixListId *string

	// The Amazon Web Services Region where the prefix list is located. This is
	// required when referencing a prefix list in a different Region.
	//
	// This member is required.
	PrefixListRegion *string

	// Indicates whether the resolver target should automatically track the latest
	// version of the prefix list. When enabled, the target will always synchronize
	// with the most current version of the prefix list.
	//
	// Choose this for automatic updates when you want your prefix lists to stay
	// current with infrastructure changes without manual intervention.
	//
	// This member is required.
	TrackLatestVersion *bool

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html
	ClientToken *string

	// The specific version of the prefix list to target. If not specified, the
	// resolver will target the latest version.
	DesiredVersion *int64

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The tags to apply to the IPAM prefix list resolver target during creation. Tags
	// help you organize and manage your Amazon Web Services resources.
	TagSpecifications []types.TagSpecification

	noSmithyDocumentSerde
}

type CreateIpamPrefixListResolverTargetOutput struct {

	// Information about the IPAM prefix list resolver target that was created.
	IpamPrefixListResolverTarget *types.IpamPrefixListResolverTarget

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateIpamPrefixListResolverTargetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpCreateIpamPrefixListResolverTarget{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpCreateIpamPrefixListResolverTarget{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateIpamPrefixListResolverTarget"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateIpamPrefixListResolverTargetMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateIpamPrefixListResolverTargetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateIpamPrefixListResolverTarget(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateIpamPrefixListResolverTarget struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateIpamPrefixListResolverTarget) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateIpamPrefixListResolverTarget) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateIpamPrefixListResolverTargetInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateIpamPrefixListResolverTargetInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateIpamPrefixListResolverTargetMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateIpamPrefixListResolverTarget{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateIpamPrefixListResolverTarget(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateIpamPrefixListResolverTarget",
	}
}
