// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the CIDR entries for a specific version of an IPAM prefix list
// resolver. This shows the actual CIDRs that were selected and synchronized at a
// particular point in time.
func (c *Client) GetIpamPrefixListResolverVersionEntries(ctx context.Context, params *GetIpamPrefixListResolverVersionEntriesInput, optFns ...func(*Options)) (*GetIpamPrefixListResolverVersionEntriesOutput, error) {
	if params == nil {
		params = &GetIpamPrefixListResolverVersionEntriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIpamPrefixListResolverVersionEntries", params, optFns, c.addOperationGetIpamPrefixListResolverVersionEntriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIpamPrefixListResolverVersionEntriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIpamPrefixListResolverVersionEntriesInput struct {

	// The ID of the IPAM prefix list resolver whose version entries you want to
	// retrieve.
	//
	// This member is required.
	IpamPrefixListResolverId *string

	// The version number of the resolver for which to retrieve CIDR entries. If not
	// specified, the latest version is used.
	//
	// This member is required.
	IpamPrefixListResolverVersion *int64

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetIpamPrefixListResolverVersionEntriesOutput struct {

	// The CIDR entries for the specified resolver version.
	Entries []types.IpamPrefixListResolverVersionEntry

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIpamPrefixListResolverVersionEntriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetIpamPrefixListResolverVersionEntries{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetIpamPrefixListResolverVersionEntries{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIpamPrefixListResolverVersionEntries"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetIpamPrefixListResolverVersionEntriesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIpamPrefixListResolverVersionEntries(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// GetIpamPrefixListResolverVersionEntriesPaginatorOptions is the paginator
// options for GetIpamPrefixListResolverVersionEntries
type GetIpamPrefixListResolverVersionEntriesPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetIpamPrefixListResolverVersionEntriesPaginator is a paginator for
// GetIpamPrefixListResolverVersionEntries
type GetIpamPrefixListResolverVersionEntriesPaginator struct {
	options   GetIpamPrefixListResolverVersionEntriesPaginatorOptions
	client    GetIpamPrefixListResolverVersionEntriesAPIClient
	params    *GetIpamPrefixListResolverVersionEntriesInput
	nextToken *string
	firstPage bool
}

// NewGetIpamPrefixListResolverVersionEntriesPaginator returns a new
// GetIpamPrefixListResolverVersionEntriesPaginator
func NewGetIpamPrefixListResolverVersionEntriesPaginator(client GetIpamPrefixListResolverVersionEntriesAPIClient, params *GetIpamPrefixListResolverVersionEntriesInput, optFns ...func(*GetIpamPrefixListResolverVersionEntriesPaginatorOptions)) *GetIpamPrefixListResolverVersionEntriesPaginator {
	if params == nil {
		params = &GetIpamPrefixListResolverVersionEntriesInput{}
	}

	options := GetIpamPrefixListResolverVersionEntriesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetIpamPrefixListResolverVersionEntriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetIpamPrefixListResolverVersionEntriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetIpamPrefixListResolverVersionEntries page.
func (p *GetIpamPrefixListResolverVersionEntriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetIpamPrefixListResolverVersionEntriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetIpamPrefixListResolverVersionEntries(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetIpamPrefixListResolverVersionEntriesAPIClient is a client that implements
// the GetIpamPrefixListResolverVersionEntries operation.
type GetIpamPrefixListResolverVersionEntriesAPIClient interface {
	GetIpamPrefixListResolverVersionEntries(context.Context, *GetIpamPrefixListResolverVersionEntriesInput, ...func(*Options)) (*GetIpamPrefixListResolverVersionEntriesOutput, error)
}

var _ GetIpamPrefixListResolverVersionEntriesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetIpamPrefixListResolverVersionEntries(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIpamPrefixListResolverVersionEntries",
	}
}
