// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/aiplatform/v1beta1/model_garden_service.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// View enumeration of PublisherModel.
type PublisherModelView int32

const (
	// The default / unset value. The API will default to the BASIC view.
	PublisherModelView_PUBLISHER_MODEL_VIEW_UNSPECIFIED PublisherModelView = 0
	// Include basic metadata about the publisher model, but not the full
	// contents.
	PublisherModelView_PUBLISHER_MODEL_VIEW_BASIC PublisherModelView = 1
	// Include everything.
	PublisherModelView_PUBLISHER_MODEL_VIEW_FULL PublisherModelView = 2
	// Include: VersionId, ModelVersionExternalName, and SupportedActions.
	PublisherModelView_PUBLISHER_MODEL_VERSION_VIEW_BASIC PublisherModelView = 3
)

// Enum value maps for PublisherModelView.
var (
	PublisherModelView_name = map[int32]string{
		0: "PUBLISHER_MODEL_VIEW_UNSPECIFIED",
		1: "PUBLISHER_MODEL_VIEW_BASIC",
		2: "PUBLISHER_MODEL_VIEW_FULL",
		3: "PUBLISHER_MODEL_VERSION_VIEW_BASIC",
	}
	PublisherModelView_value = map[string]int32{
		"PUBLISHER_MODEL_VIEW_UNSPECIFIED":   0,
		"PUBLISHER_MODEL_VIEW_BASIC":         1,
		"PUBLISHER_MODEL_VIEW_FULL":          2,
		"PUBLISHER_MODEL_VERSION_VIEW_BASIC": 3,
	}
)

func (x PublisherModelView) Enum() *PublisherModelView {
	p := new(PublisherModelView)
	*p = x
	return p
}

func (x PublisherModelView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PublisherModelView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_enumTypes[0].Descriptor()
}

func (PublisherModelView) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_enumTypes[0]
}

func (x PublisherModelView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PublisherModelView.Descriptor instead.
func (PublisherModelView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{0}
}

// Request message for
// [ModelGardenService.GetPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.GetPublisherModel]
type GetPublisherModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The IETF BCP-47 language code representing the language in which
	// the publisher model's text information should be written in.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. PublisherModel view specifying which fields to read.
	View PublisherModelView `protobuf:"varint,3,opt,name=view,proto3,enum=google.cloud.aiplatform.v1beta1.PublisherModelView" json:"view,omitempty"`
	// Optional. Boolean indicates whether the requested model is a Hugging Face
	// model.
	IsHuggingFaceModel bool `protobuf:"varint,5,opt,name=is_hugging_face_model,json=isHuggingFaceModel,proto3" json:"is_hugging_face_model,omitempty"`
	// Optional. Token used to access Hugging Face gated models.
	HuggingFaceToken string `protobuf:"bytes,6,opt,name=hugging_face_token,json=huggingFaceToken,proto3" json:"hugging_face_token,omitempty"`
	// Optional. Whether to cnclude the deployment configs from the equivalent
	// Model Garden model if the requested model is a Hugging Face model.
	IncludeEquivalentModelGardenModelDeploymentConfigs bool `protobuf:"varint,7,opt,name=include_equivalent_model_garden_model_deployment_configs,json=includeEquivalentModelGardenModelDeploymentConfigs,proto3" json:"include_equivalent_model_garden_model_deployment_configs,omitempty"`
}

func (x *GetPublisherModelRequest) Reset() {
	*x = GetPublisherModelRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPublisherModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPublisherModelRequest) ProtoMessage() {}

func (x *GetPublisherModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPublisherModelRequest.ProtoReflect.Descriptor instead.
func (*GetPublisherModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{0}
}

func (x *GetPublisherModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetPublisherModelRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *GetPublisherModelRequest) GetView() PublisherModelView {
	if x != nil {
		return x.View
	}
	return PublisherModelView_PUBLISHER_MODEL_VIEW_UNSPECIFIED
}

func (x *GetPublisherModelRequest) GetIsHuggingFaceModel() bool {
	if x != nil {
		return x.IsHuggingFaceModel
	}
	return false
}

func (x *GetPublisherModelRequest) GetHuggingFaceToken() string {
	if x != nil {
		return x.HuggingFaceToken
	}
	return ""
}

func (x *GetPublisherModelRequest) GetIncludeEquivalentModelGardenModelDeploymentConfigs() bool {
	if x != nil {
		return x.IncludeEquivalentModelGardenModelDeploymentConfigs
	}
	return false
}

// Request message for
// [ModelGardenService.ListPublisherModels][google.cloud.aiplatform.v1beta1.ModelGardenService.ListPublisherModels].
type ListPublisherModelsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Publisher from which to list the PublisherModels.
	// Format: `publishers/{publisher}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The standard list filter.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The standard list page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The standard list page token.
	// Typically obtained via
	// [ListPublisherModelsResponse.next_page_token][google.cloud.aiplatform.v1beta1.ListPublisherModelsResponse.next_page_token]
	// of the previous
	// [ModelGardenService.ListPublisherModels][google.cloud.aiplatform.v1beta1.ModelGardenService.ListPublisherModels]
	// call.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. PublisherModel view specifying which fields to read.
	View PublisherModelView `protobuf:"varint,5,opt,name=view,proto3,enum=google.cloud.aiplatform.v1beta1.PublisherModelView" json:"view,omitempty"`
	// Optional. A comma-separated list of fields to order by, sorted in ascending
	// order. Use "desc" after a field name for descending.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The IETF BCP-47 language code representing the language in which
	// the publisher models' text information should be written in. If not set, by
	// default English (en).
	LanguageCode string `protobuf:"bytes,7,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. List all publisher model versions if the flag is set to true.
	ListAllVersions bool `protobuf:"varint,8,opt,name=list_all_versions,json=listAllVersions,proto3" json:"list_all_versions,omitempty"`
}

func (x *ListPublisherModelsRequest) Reset() {
	*x = ListPublisherModelsRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPublisherModelsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPublisherModelsRequest) ProtoMessage() {}

func (x *ListPublisherModelsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPublisherModelsRequest.ProtoReflect.Descriptor instead.
func (*ListPublisherModelsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{1}
}

func (x *ListPublisherModelsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPublisherModelsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListPublisherModelsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPublisherModelsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListPublisherModelsRequest) GetView() PublisherModelView {
	if x != nil {
		return x.View
	}
	return PublisherModelView_PUBLISHER_MODEL_VIEW_UNSPECIFIED
}

func (x *ListPublisherModelsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListPublisherModelsRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *ListPublisherModelsRequest) GetListAllVersions() bool {
	if x != nil {
		return x.ListAllVersions
	}
	return false
}

// Response message for
// [ModelGardenService.ListPublisherModels][google.cloud.aiplatform.v1beta1.ModelGardenService.ListPublisherModels].
type ListPublisherModelsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of PublisherModels in the requested page.
	PublisherModels []*PublisherModel `protobuf:"bytes,1,rep,name=publisher_models,json=publisherModels,proto3" json:"publisher_models,omitempty"`
	// A token to retrieve next page of results.
	// Pass to [ListPublisherModels.page_token][] to obtain that page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPublisherModelsResponse) Reset() {
	*x = ListPublisherModelsResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPublisherModelsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPublisherModelsResponse) ProtoMessage() {}

func (x *ListPublisherModelsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPublisherModelsResponse.ProtoReflect.Descriptor instead.
func (*ListPublisherModelsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{2}
}

func (x *ListPublisherModelsResponse) GetPublisherModels() []*PublisherModel {
	if x != nil {
		return x.PublisherModels
	}
	return nil
}

func (x *ListPublisherModelsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for
// [ModelGardenService.Deploy][google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy].
type DeployRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The artifacts to deploy.
	//
	// Types that are assignable to Artifacts:
	//
	//	*DeployRequest_PublisherModelName
	//	*DeployRequest_HuggingFaceModelId
	//	*DeployRequest_CustomModel_
	Artifacts isDeployRequest_Artifacts `protobuf_oneof:"artifacts"`
	// Required. The resource name of the Location to deploy the model in.
	// Format: `projects/{project}/locations/{location}`
	Destination string `protobuf:"bytes,4,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. The model config to use for the deployment.
	// If not specified, the default model config will be used.
	ModelConfig *DeployRequest_ModelConfig `protobuf:"bytes,5,opt,name=model_config,json=modelConfig,proto3" json:"model_config,omitempty"`
	// Optional. The endpoint config to use for the deployment.
	// If not specified, the default endpoint config will be used.
	EndpointConfig *DeployRequest_EndpointConfig `protobuf:"bytes,6,opt,name=endpoint_config,json=endpointConfig,proto3" json:"endpoint_config,omitempty"`
	// Optional. The deploy config to use for the deployment.
	// If not specified, the default deploy config will be used.
	DeployConfig *DeployRequest_DeployConfig `protobuf:"bytes,7,opt,name=deploy_config,json=deployConfig,proto3" json:"deploy_config,omitempty"`
}

func (x *DeployRequest) Reset() {
	*x = DeployRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest) ProtoMessage() {}

func (x *DeployRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest.ProtoReflect.Descriptor instead.
func (*DeployRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{3}
}

func (m *DeployRequest) GetArtifacts() isDeployRequest_Artifacts {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (x *DeployRequest) GetPublisherModelName() string {
	if x, ok := x.GetArtifacts().(*DeployRequest_PublisherModelName); ok {
		return x.PublisherModelName
	}
	return ""
}

func (x *DeployRequest) GetHuggingFaceModelId() string {
	if x, ok := x.GetArtifacts().(*DeployRequest_HuggingFaceModelId); ok {
		return x.HuggingFaceModelId
	}
	return ""
}

func (x *DeployRequest) GetCustomModel() *DeployRequest_CustomModel {
	if x, ok := x.GetArtifacts().(*DeployRequest_CustomModel_); ok {
		return x.CustomModel
	}
	return nil
}

func (x *DeployRequest) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DeployRequest) GetModelConfig() *DeployRequest_ModelConfig {
	if x != nil {
		return x.ModelConfig
	}
	return nil
}

func (x *DeployRequest) GetEndpointConfig() *DeployRequest_EndpointConfig {
	if x != nil {
		return x.EndpointConfig
	}
	return nil
}

func (x *DeployRequest) GetDeployConfig() *DeployRequest_DeployConfig {
	if x != nil {
		return x.DeployConfig
	}
	return nil
}

type isDeployRequest_Artifacts interface {
	isDeployRequest_Artifacts()
}

type DeployRequest_PublisherModelName struct {
	// The Model Garden model to deploy.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
	PublisherModelName string `protobuf:"bytes,1,opt,name=publisher_model_name,json=publisherModelName,proto3,oneof"`
}

type DeployRequest_HuggingFaceModelId struct {
	// The Hugging Face model to deploy.
	// Format: Hugging Face model ID like `google/gemma-2-2b-it`.
	HuggingFaceModelId string `protobuf:"bytes,2,opt,name=hugging_face_model_id,json=huggingFaceModelId,proto3,oneof"`
}

type DeployRequest_CustomModel_ struct {
	// The custom model to deploy from a Google Cloud Storage URI.
	CustomModel *DeployRequest_CustomModel `protobuf:"bytes,3,opt,name=custom_model,json=customModel,proto3,oneof"`
}

func (*DeployRequest_PublisherModelName) isDeployRequest_Artifacts() {}

func (*DeployRequest_HuggingFaceModelId) isDeployRequest_Artifacts() {}

func (*DeployRequest_CustomModel_) isDeployRequest_Artifacts() {}

// Request message for
// [ModelGardenService.DeployPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel].
//
// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/model_garden_service.proto.
type DeployPublisherModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The model to deploy.
	// Format:
	// 1. `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`.
	// 2. Hugging Face model ID like `google/gemma-2-2b-it`.
	// 3. Custom model Google Cloud Storage URI like `gs://bucket`.
	// 4. Custom model zip file like `https://example.com/a.zip`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The resource name of the Location to deploy the model in.
	// Format: `projects/{project}/locations/{location}`
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. The user-specified display name of the endpoint. If not set, a
	// default name will be used.
	EndpointDisplayName string `protobuf:"bytes,3,opt,name=endpoint_display_name,json=endpointDisplayName,proto3" json:"endpoint_display_name,omitempty"`
	// Optional. The dedicated resources to use for the endpoint. If not set, the
	// default resources will be used.
	DedicatedResources *DedicatedResources `protobuf:"bytes,4,opt,name=dedicated_resources,json=dedicatedResources,proto3" json:"dedicated_resources,omitempty"`
	// Optional. The user-specified display name of the uploaded model. If not
	// set, a default name will be used.
	ModelDisplayName string `protobuf:"bytes,5,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
	// Optional. The Hugging Face read access token used to access the model
	// artifacts of gated models.
	HuggingFaceAccessToken string `protobuf:"bytes,6,opt,name=hugging_face_access_token,json=huggingFaceAccessToken,proto3" json:"hugging_face_access_token,omitempty"`
	// Optional. Whether the user accepts the End User License Agreement (EULA)
	// for the model.
	AcceptEula bool `protobuf:"varint,7,opt,name=accept_eula,json=acceptEula,proto3" json:"accept_eula,omitempty"`
}

func (x *DeployPublisherModelRequest) Reset() {
	*x = DeployPublisherModelRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployPublisherModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployPublisherModelRequest) ProtoMessage() {}

func (x *DeployPublisherModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployPublisherModelRequest.ProtoReflect.Descriptor instead.
func (*DeployPublisherModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{4}
}

func (x *DeployPublisherModelRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *DeployPublisherModelRequest) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DeployPublisherModelRequest) GetEndpointDisplayName() string {
	if x != nil {
		return x.EndpointDisplayName
	}
	return ""
}

func (x *DeployPublisherModelRequest) GetDedicatedResources() *DedicatedResources {
	if x != nil {
		return x.DedicatedResources
	}
	return nil
}

func (x *DeployPublisherModelRequest) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

func (x *DeployPublisherModelRequest) GetHuggingFaceAccessToken() string {
	if x != nil {
		return x.HuggingFaceAccessToken
	}
	return ""
}

func (x *DeployPublisherModelRequest) GetAcceptEula() bool {
	if x != nil {
		return x.AcceptEula
	}
	return false
}

// Response message for
// [ModelGardenService.Deploy][google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy].
type DeployResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`
	PublisherModel string `protobuf:"bytes,1,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// Output only. The name of the Endpoint created.
	// Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The name of the Model created.
	// Format: `projects/{project}/locations/{location}/models/{model}`
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *DeployResponse) Reset() {
	*x = DeployResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployResponse) ProtoMessage() {}

func (x *DeployResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployResponse.ProtoReflect.Descriptor instead.
func (*DeployResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{5}
}

func (x *DeployResponse) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *DeployResponse) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *DeployResponse) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Response message for
// [ModelGardenService.DeployPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel].
//
// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/model_garden_service.proto.
type DeployPublisherModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`
	PublisherModel string `protobuf:"bytes,1,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// Output only. The name of the Endpoint created.
	// Format: `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Output only. The name of the Model created.
	// Format: `projects/{project}/locations/{location}/models/{model}`
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
}

func (x *DeployPublisherModelResponse) Reset() {
	*x = DeployPublisherModelResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployPublisherModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployPublisherModelResponse) ProtoMessage() {}

func (x *DeployPublisherModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployPublisherModelResponse.ProtoReflect.Descriptor instead.
func (*DeployPublisherModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{6}
}

func (x *DeployPublisherModelResponse) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *DeployPublisherModelResponse) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *DeployPublisherModelResponse) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

// Runtime operation information for
// [ModelGardenService.Deploy][google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy].
type DeployOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// Output only. The name of the model resource.
	PublisherModel string `protobuf:"bytes,2,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// Output only. The resource name of the Location to deploy the model in.
	// Format: `projects/{project}/locations/{location}`
	Destination string `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	// Output only. The project number where the deploy model request is sent.
	ProjectNumber int64 `protobuf:"varint,4,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// Output only. The model id to be used at query time.
	ModelId string `protobuf:"bytes,5,opt,name=model_id,json=modelId,proto3" json:"model_id,omitempty"`
}

func (x *DeployOperationMetadata) Reset() {
	*x = DeployOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployOperationMetadata) ProtoMessage() {}

func (x *DeployOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeployOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{7}
}

func (x *DeployOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *DeployOperationMetadata) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *DeployOperationMetadata) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DeployOperationMetadata) GetProjectNumber() int64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *DeployOperationMetadata) GetModelId() string {
	if x != nil {
		return x.ModelId
	}
	return ""
}

// Runtime operation information for
// [ModelGardenService.DeployPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel].
//
// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/model_garden_service.proto.
type DeployPublisherModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
	// Output only. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`
	PublisherModel string `protobuf:"bytes,2,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// Output only. The resource name of the Location to deploy the model in.
	// Format: `projects/{project}/locations/{location}`
	Destination string `protobuf:"bytes,3,opt,name=destination,proto3" json:"destination,omitempty"`
	// Output only. The project number where the deploy model request is sent.
	ProjectNumber int64 `protobuf:"varint,4,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
}

func (x *DeployPublisherModelOperationMetadata) Reset() {
	*x = DeployPublisherModelOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployPublisherModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployPublisherModelOperationMetadata) ProtoMessage() {}

func (x *DeployPublisherModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployPublisherModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*DeployPublisherModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{8}
}

func (x *DeployPublisherModelOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

func (x *DeployPublisherModelOperationMetadata) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *DeployPublisherModelOperationMetadata) GetDestination() string {
	if x != nil {
		return x.Destination
	}
	return ""
}

func (x *DeployPublisherModelOperationMetadata) GetProjectNumber() int64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

// Response message for
// [ModelGardenService.ExportPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.ExportPublisherModel].
type ExportPublisherModelResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`
	PublisherModel string `protobuf:"bytes,1,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// The destination uri of the model weights.
	DestinationUri string `protobuf:"bytes,2,opt,name=destination_uri,json=destinationUri,proto3" json:"destination_uri,omitempty"`
}

func (x *ExportPublisherModelResponse) Reset() {
	*x = ExportPublisherModelResponse{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportPublisherModelResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPublisherModelResponse) ProtoMessage() {}

func (x *ExportPublisherModelResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPublisherModelResponse.ProtoReflect.Descriptor instead.
func (*ExportPublisherModelResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{9}
}

func (x *ExportPublisherModelResponse) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *ExportPublisherModelResponse) GetDestinationUri() string {
	if x != nil {
		return x.DestinationUri
	}
	return ""
}

// Runtime operation information for
// [ModelGardenService.ExportPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.ExportPublisherModel].
type ExportPublisherModelOperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation generic information.
	GenericMetadata *GenericOperationMetadata `protobuf:"bytes,1,opt,name=generic_metadata,json=genericMetadata,proto3" json:"generic_metadata,omitempty"`
}

func (x *ExportPublisherModelOperationMetadata) Reset() {
	*x = ExportPublisherModelOperationMetadata{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportPublisherModelOperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPublisherModelOperationMetadata) ProtoMessage() {}

func (x *ExportPublisherModelOperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPublisherModelOperationMetadata.ProtoReflect.Descriptor instead.
func (*ExportPublisherModelOperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{10}
}

func (x *ExportPublisherModelOperationMetadata) GetGenericMetadata() *GenericOperationMetadata {
	if x != nil {
		return x.GenericMetadata
	}
	return nil
}

// Request message for
// [ModelGardenService.ExportPublisherModel][google.cloud.aiplatform.v1beta1.ModelGardenService.ExportPublisherModel].
type ExportPublisherModelRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}@{version_id}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}@001`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The target where we are exporting the model weights to
	Destination *GcsDestination `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Required. The Location to export the model weights from
	// Format: `projects/{project}/locations/{location}`
	Parent string `protobuf:"bytes,3,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *ExportPublisherModelRequest) Reset() {
	*x = ExportPublisherModelRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExportPublisherModelRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportPublisherModelRequest) ProtoMessage() {}

func (x *ExportPublisherModelRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportPublisherModelRequest.ProtoReflect.Descriptor instead.
func (*ExportPublisherModelRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{11}
}

func (x *ExportPublisherModelRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ExportPublisherModelRequest) GetDestination() *GcsDestination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *ExportPublisherModelRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Request message for
// [ModelGardenService.CheckPublisherModelEula][].
type CheckPublisherModelEulaAcceptanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project requesting access for named model. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}`
	PublisherModel string `protobuf:"bytes,2,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
}

func (x *CheckPublisherModelEulaAcceptanceRequest) Reset() {
	*x = CheckPublisherModelEulaAcceptanceRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckPublisherModelEulaAcceptanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckPublisherModelEulaAcceptanceRequest) ProtoMessage() {}

func (x *CheckPublisherModelEulaAcceptanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckPublisherModelEulaAcceptanceRequest.ProtoReflect.Descriptor instead.
func (*CheckPublisherModelEulaAcceptanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{12}
}

func (x *CheckPublisherModelEulaAcceptanceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CheckPublisherModelEulaAcceptanceRequest) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

// Request message for
// [ModelGardenService.AcceptPublisherModelEula][google.cloud.aiplatform.v1beta1.ModelGardenService.AcceptPublisherModelEula].
type AcceptPublisherModelEulaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project requesting access for named model. The format is
	// `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the PublisherModel resource.
	// Format:
	// `publishers/{publisher}/models/{publisher_model}`, or
	// `publishers/hf-{hugging-face-author}/models/{hugging-face-model-name}`
	PublisherModel string `protobuf:"bytes,2,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
}

func (x *AcceptPublisherModelEulaRequest) Reset() {
	*x = AcceptPublisherModelEulaRequest{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AcceptPublisherModelEulaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AcceptPublisherModelEulaRequest) ProtoMessage() {}

func (x *AcceptPublisherModelEulaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AcceptPublisherModelEulaRequest.ProtoReflect.Descriptor instead.
func (*AcceptPublisherModelEulaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{13}
}

func (x *AcceptPublisherModelEulaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *AcceptPublisherModelEulaRequest) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

// Response message for
// [ModelGardenService.UpdatePublisherModelEula][].
type PublisherModelEulaAcceptance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project number requesting access for named model.
	ProjectNumber int64 `protobuf:"varint,1,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The publisher model resource name.
	PublisherModel string `protobuf:"bytes,2,opt,name=publisher_model,json=publisherModel,proto3" json:"publisher_model,omitempty"`
	// The EULA content acceptance status.
	PublisherModelEulaAcked bool `protobuf:"varint,3,opt,name=publisher_model_eula_acked,json=publisherModelEulaAcked,proto3" json:"publisher_model_eula_acked,omitempty"`
}

func (x *PublisherModelEulaAcceptance) Reset() {
	*x = PublisherModelEulaAcceptance{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PublisherModelEulaAcceptance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PublisherModelEulaAcceptance) ProtoMessage() {}

func (x *PublisherModelEulaAcceptance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PublisherModelEulaAcceptance.ProtoReflect.Descriptor instead.
func (*PublisherModelEulaAcceptance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{14}
}

func (x *PublisherModelEulaAcceptance) GetProjectNumber() int64 {
	if x != nil {
		return x.ProjectNumber
	}
	return 0
}

func (x *PublisherModelEulaAcceptance) GetPublisherModel() string {
	if x != nil {
		return x.PublisherModel
	}
	return ""
}

func (x *PublisherModelEulaAcceptance) GetPublisherModelEulaAcked() bool {
	if x != nil {
		return x.PublisherModelEulaAcked
	}
	return false
}

// The custom model to deploy from model weights in a Google Cloud Storage URI
// or Model Registry model.
type DeployRequest_CustomModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The source of the custom model.
	//
	// Types that are assignable to ModelSource:
	//
	//	*DeployRequest_CustomModel_GcsUri
	ModelSource isDeployRequest_CustomModel_ModelSource `protobuf_oneof:"model_source"`
}

func (x *DeployRequest_CustomModel) Reset() {
	*x = DeployRequest_CustomModel{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_CustomModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_CustomModel) ProtoMessage() {}

func (x *DeployRequest_CustomModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_CustomModel.ProtoReflect.Descriptor instead.
func (*DeployRequest_CustomModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{3, 0}
}

func (m *DeployRequest_CustomModel) GetModelSource() isDeployRequest_CustomModel_ModelSource {
	if m != nil {
		return m.ModelSource
	}
	return nil
}

func (x *DeployRequest_CustomModel) GetGcsUri() string {
	if x, ok := x.GetModelSource().(*DeployRequest_CustomModel_GcsUri); ok {
		return x.GcsUri
	}
	return ""
}

type isDeployRequest_CustomModel_ModelSource interface {
	isDeployRequest_CustomModel_ModelSource()
}

type DeployRequest_CustomModel_GcsUri struct {
	// Immutable. The Google Cloud Storage URI of the custom model, storing
	// weights and config files (which can be used to infer the base model).
	GcsUri string `protobuf:"bytes,2,opt,name=gcs_uri,json=gcsUri,proto3,oneof"`
}

func (*DeployRequest_CustomModel_GcsUri) isDeployRequest_CustomModel_ModelSource() {}

// The model config to use for the deployment.
type DeployRequest_ModelConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether the user accepts the End User License Agreement (EULA)
	// for the model.
	AcceptEula bool `protobuf:"varint,1,opt,name=accept_eula,json=acceptEula,proto3" json:"accept_eula,omitempty"`
	// Optional. The Hugging Face read access token used to access the model
	// artifacts of gated models.
	HuggingFaceAccessToken string `protobuf:"bytes,2,opt,name=hugging_face_access_token,json=huggingFaceAccessToken,proto3" json:"hugging_face_access_token,omitempty"`
	// Optional. If true, the model will deploy with a cached version instead of
	// directly downloading the model artifacts from Hugging Face. This is
	// suitable for VPC-SC users with limited internet access.
	HuggingFaceCacheEnabled bool `protobuf:"varint,3,opt,name=hugging_face_cache_enabled,json=huggingFaceCacheEnabled,proto3" json:"hugging_face_cache_enabled,omitempty"`
	// Optional. The user-specified display name of the uploaded model. If not
	// set, a default name will be used.
	ModelDisplayName string `protobuf:"bytes,4,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
	// Optional. The specification of the container that is to be used when
	// deploying. If not set, the default container spec will be used.
	ContainerSpec *ModelContainerSpec `protobuf:"bytes,5,opt,name=container_spec,json=containerSpec,proto3" json:"container_spec,omitempty"`
	// Optional. The ID to use for the uploaded Model, which will become the
	// final component of the model resource name. When not provided, Vertex AI
	// will generate a value for this ID. When Model Registry model is provided,
	// this field will be ignored.
	//
	// This value may be up to 63 characters, and valid characters are
	// `[a-z0-9_-]`. The first character cannot be a number or hyphen.
	ModelUserId string `protobuf:"bytes,6,opt,name=model_user_id,json=modelUserId,proto3" json:"model_user_id,omitempty"`
}

func (x *DeployRequest_ModelConfig) Reset() {
	*x = DeployRequest_ModelConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_ModelConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_ModelConfig) ProtoMessage() {}

func (x *DeployRequest_ModelConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_ModelConfig.ProtoReflect.Descriptor instead.
func (*DeployRequest_ModelConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *DeployRequest_ModelConfig) GetAcceptEula() bool {
	if x != nil {
		return x.AcceptEula
	}
	return false
}

func (x *DeployRequest_ModelConfig) GetHuggingFaceAccessToken() string {
	if x != nil {
		return x.HuggingFaceAccessToken
	}
	return ""
}

func (x *DeployRequest_ModelConfig) GetHuggingFaceCacheEnabled() bool {
	if x != nil {
		return x.HuggingFaceCacheEnabled
	}
	return false
}

func (x *DeployRequest_ModelConfig) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

func (x *DeployRequest_ModelConfig) GetContainerSpec() *ModelContainerSpec {
	if x != nil {
		return x.ContainerSpec
	}
	return nil
}

func (x *DeployRequest_ModelConfig) GetModelUserId() string {
	if x != nil {
		return x.ModelUserId
	}
	return ""
}

// The endpoint config to use for the deployment.
type DeployRequest_EndpointConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The user-specified display name of the endpoint. If not set, a
	// default name will be used.
	EndpointDisplayName string `protobuf:"bytes,1,opt,name=endpoint_display_name,json=endpointDisplayName,proto3" json:"endpoint_display_name,omitempty"`
	// Optional. Deprecated. Use dedicated_endpoint_disabled instead.
	// If true, the endpoint will be exposed through a
	// dedicated DNS [Endpoint.dedicated_endpoint_dns]. Your request to the
	// dedicated DNS will be isolated from other users' traffic and will have
	// better performance and reliability. Note: Once you enabled dedicated
	// endpoint, you won't be able to send request to the shared DNS
	// {region}-aiplatform.googleapis.com. The limitations will be removed soon.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/model_garden_service.proto.
	DedicatedEndpointEnabled bool `protobuf:"varint,2,opt,name=dedicated_endpoint_enabled,json=dedicatedEndpointEnabled,proto3" json:"dedicated_endpoint_enabled,omitempty"`
	// Optional. By default, if dedicated endpoint is enabled and private
	// service connect config is not set, the endpoint will be exposed through a
	// dedicated DNS [Endpoint.dedicated_endpoint_dns]. If private service
	// connect config is set, the endpoint will be exposed through private
	// service connect. Your request to the dedicated DNS will be isolated from
	// other users' traffic and will have better performance and reliability.
	// Note: Once you enabled dedicated endpoint, you won't be able to send
	// request to the shared DNS {region}-aiplatform.googleapis.com. The
	// limitations will be removed soon.
	//
	// If this field is set to true, the dedicated endpoint will be disabled
	// and the deployed model will be exposed through the shared DNS
	// {region}-aiplatform.googleapis.com.
	DedicatedEndpointDisabled bool `protobuf:"varint,4,opt,name=dedicated_endpoint_disabled,json=dedicatedEndpointDisabled,proto3" json:"dedicated_endpoint_disabled,omitempty"`
	// Optional. Configuration for private service connect. If set, the endpoint
	// will be exposed through private service connect.
	PrivateServiceConnectConfig *PrivateServiceConnectConfig `protobuf:"bytes,5,opt,name=private_service_connect_config,json=privateServiceConnectConfig,proto3" json:"private_service_connect_config,omitempty"`
	// Optional. Immutable. The ID to use for endpoint, which will become the
	// final component of the endpoint resource name. If not provided, Vertex AI
	// will generate a value for this ID.
	//
	// If the first character is a letter, this value may be up to 63
	// characters, and valid characters are `[a-z0-9-]`. The last character must
	// be a letter or number.
	//
	// If the first character is a number, this value may be up to 9 characters,
	// and valid characters are `[0-9]` with no leading zeros.
	//
	// When using HTTP/JSON, this field is populated
	// based on a query string argument, such as `?endpoint_id=12345`. This is
	// the fallback for fields that are not included in either the URI or the
	// body.
	EndpointUserId string `protobuf:"bytes,3,opt,name=endpoint_user_id,json=endpointUserId,proto3" json:"endpoint_user_id,omitempty"`
}

func (x *DeployRequest_EndpointConfig) Reset() {
	*x = DeployRequest_EndpointConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_EndpointConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_EndpointConfig) ProtoMessage() {}

func (x *DeployRequest_EndpointConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_EndpointConfig.ProtoReflect.Descriptor instead.
func (*DeployRequest_EndpointConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{3, 2}
}

func (x *DeployRequest_EndpointConfig) GetEndpointDisplayName() string {
	if x != nil {
		return x.EndpointDisplayName
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/model_garden_service.proto.
func (x *DeployRequest_EndpointConfig) GetDedicatedEndpointEnabled() bool {
	if x != nil {
		return x.DedicatedEndpointEnabled
	}
	return false
}

func (x *DeployRequest_EndpointConfig) GetDedicatedEndpointDisabled() bool {
	if x != nil {
		return x.DedicatedEndpointDisabled
	}
	return false
}

func (x *DeployRequest_EndpointConfig) GetPrivateServiceConnectConfig() *PrivateServiceConnectConfig {
	if x != nil {
		return x.PrivateServiceConnectConfig
	}
	return nil
}

func (x *DeployRequest_EndpointConfig) GetEndpointUserId() string {
	if x != nil {
		return x.EndpointUserId
	}
	return ""
}

// The deploy config to use for the deployment.
type DeployRequest_DeployConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The dedicated resources to use for the endpoint. If not set,
	// the default resources will be used.
	DedicatedResources *DedicatedResources `protobuf:"bytes,1,opt,name=dedicated_resources,json=dedicatedResources,proto3" json:"dedicated_resources,omitempty"`
	// Optional. If true, enable the QMT fast tryout feature for this model if
	// possible.
	FastTryoutEnabled bool `protobuf:"varint,2,opt,name=fast_tryout_enabled,json=fastTryoutEnabled,proto3" json:"fast_tryout_enabled,omitempty"`
	// Optional. System labels for Model Garden deployments.
	// These labels are managed by Google and for tracking purposes only.
	SystemLabels map[string]string `protobuf:"bytes,3,rep,name=system_labels,json=systemLabels,proto3" json:"system_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *DeployRequest_DeployConfig) Reset() {
	*x = DeployRequest_DeployConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeployRequest_DeployConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeployRequest_DeployConfig) ProtoMessage() {}

func (x *DeployRequest_DeployConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeployRequest_DeployConfig.ProtoReflect.Descriptor instead.
func (*DeployRequest_DeployConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP(), []int{3, 3}
}

func (x *DeployRequest_DeployConfig) GetDedicatedResources() *DedicatedResources {
	if x != nil {
		return x.DedicatedResources
	}
	return nil
}

func (x *DeployRequest_DeployConfig) GetFastTryoutEnabled() bool {
	if x != nil {
		return x.FastTryoutEnabled
	}
	return false
}

func (x *DeployRequest_DeployConfig) GetSystemLabels() map[string]string {
	if x != nil {
		return x.SystemLabels
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_model_garden_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x67, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1c, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x69, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbe, 0x03, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x50,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61,
	0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x43, 0x6f, 0x64, 0x65, 0x12, 0x4c, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69,
	0x65, 0x77, 0x12, 0x36, 0x0a, 0x15, 0x69, 0x73, 0x5f, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67,
	0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x69, 0x73, 0x48, 0x75, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x46, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x31, 0x0a, 0x12, 0x68, 0x75,
	0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x68, 0x75, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x79, 0x0a,
	0x38, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c,
	0x65, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x67, 0x61, 0x72, 0x64, 0x65, 0x6e,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x32, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x45, 0x71, 0x75,
	0x69, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x47, 0x61, 0x72, 0x64,
	0x65, 0x6e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x22, 0xe5, 0x02, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x4c, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12,
	0x2f, 0x0a, 0x11, 0x6c, 0x69, 0x73, 0x74, 0x5f, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x6c, 0x69, 0x73, 0x74, 0x41, 0x6c, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x22, 0xa1, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x5a, 0x0a, 0x10, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xca, 0x0e, 0x0a, 0x0d, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x14, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x48, 0x00, 0x52, 0x12, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x15, 0x68, 0x75, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x12, 0x68, 0x75, 0x67, 0x67,
	0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x5f,
	0x0a, 0x0c, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x48, 0x00, 0x52, 0x0b, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x0c,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x6b, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x65, 0x0a,
	0x0d, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x1a, 0x3d, 0x0a, 0x0b, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x1e, 0x0a, 0x07, 0x67, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00, 0x52, 0x06, 0x67, 0x63, 0x73,
	0x55, 0x72, 0x69, 0x42, 0x0e, 0x0a, 0x0c, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x1a, 0xf2, 0x02, 0x0a, 0x0b, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x65, 0x75,
	0x6c, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x45, 0x75, 0x6c, 0x61, 0x12, 0x3e, 0x0a, 0x19, 0x68, 0x75, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x16, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x65, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x40, 0x0a, 0x1a, 0x68, 0x75, 0x67,
	0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65, 0x5f, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f,
	0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x17, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x46, 0x61, 0x63, 0x65, 0x43,
	0x61, 0x63, 0x68, 0x65, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x31, 0x0a, 0x12, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5f,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f,
	0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x27, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x1a, 0x8e, 0x03, 0x0a, 0x0e, 0x45, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x37, 0x0a, 0x15, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x13, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x43, 0x0a, 0x1a, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0, 0x41, 0x01, 0x18, 0x01, 0x52,
	0x18, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x43, 0x0a, 0x1b, 0x64, 0x65, 0x64,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f,
	0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x19, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x86,
	0x01, 0x0a, 0x1e, 0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x61, 0x74,
	0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1b, 0x70, 0x72, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x30, 0x0a, 0x10, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x06, 0xe0, 0x41, 0x05, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x55, 0x73, 0x65, 0x72, 0x49, 0x64, 0x1a, 0xe8, 0x02, 0x0a, 0x0c, 0x44, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x69, 0x0a, 0x13, 0x64, 0x65,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x33, 0x0a, 0x13, 0x66, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x72,
	0x79, 0x6f, 0x75, 0x74, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x66, 0x61, 0x73, 0x74, 0x54, 0x72, 0x79,
	0x6f, 0x75, 0x74, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x77, 0x0a, 0x0d, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x5f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x1a, 0x3f, 0x0a, 0x11, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x42, 0x0b, 0x0a, 0x09, 0x61, 0x72, 0x74, 0x69, 0x66, 0x61, 0x63, 0x74,
	0x73, 0x22, 0xc6, 0x03, 0x0a, 0x1b, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4b, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x15, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x69, 0x0a, 0x13, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x44, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x64, 0x65, 0x64, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x31, 0x0a,
	0x12, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x3e, 0x0a, 0x19, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x61, 0x63, 0x65,
	0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x16, 0x68, 0x75, 0x67, 0x67, 0x69, 0x6e,
	0x67, 0x46, 0x61, 0x63, 0x65, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x5f, 0x65, 0x75, 0x6c, 0x61, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x61, 0x63, 0x63, 0x65,
	0x70, 0x74, 0x45, 0x75, 0x6c, 0x61, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xf2, 0x01, 0x0a, 0x0e, 0x44,
	0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x59, 0x0a,
	0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x3d, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x22,
	0x84, 0x02, 0x0a, 0x1c, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x59, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x46, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x3a, 0x02, 0x18, 0x01, 0x22, 0xf3, 0x02, 0x0a, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x12, 0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x2a, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xe5, 0x02, 0x0a,
	0x25, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a, 0x0f,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x4b, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x3a, 0x02, 0x18, 0x01, 0x22, 0x70, 0x0a, 0x1c, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70,
	0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x27, 0x0a,
	0x0f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x55, 0x72, 0x69, 0x22, 0x8d, 0x01, 0x0a, 0x25, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x12, 0x64, 0x0a, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x6e,
	0x65, 0x72, 0x69, 0x63, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x0f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0xd1, 0x01, 0x0a, 0x1b, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x56, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a,
	0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xd2, 0x01, 0x0a, 0x28, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64,
	0x65, 0x6c, 0x45, 0x75, 0x6c, 0x61, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a,
	0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x59, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x0e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22,
	0xc9, 0x01, 0x0a, 0x1f, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x75, 0x6c, 0x61, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x59, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x0e, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0xab, 0x01, 0x0a, 0x1c,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x75,
	0x6c, 0x61, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0e,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
	0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3b, 0x0a, 0x1a,
	0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f,
	0x65, 0x75, 0x6c, 0x61, 0x5f, 0x61, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x17, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x45, 0x75, 0x6c, 0x61, 0x41, 0x63, 0x6b, 0x65, 0x64, 0x2a, 0xa1, 0x01, 0x0a, 0x12, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x69, 0x65, 0x77,
	0x12, 0x24, 0x0a, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f,
	0x44, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53,
	0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42,
	0x41, 0x53, 0x49, 0x43, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53,
	0x48, 0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46,
	0x55, 0x4c, 0x4c, 0x10, 0x02, 0x12, 0x26, 0x0a, 0x22, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x53, 0x48,
	0x45, 0x52, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x4c, 0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e,
	0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10, 0x03, 0x32, 0xd5, 0x0d,
	0x0a, 0x12, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x47, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0xb5, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x50, 0x75, 0x62, 0x6c,
	0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x47, 0x65, 0x74,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x22, 0x34, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x27, 0x12, 0x25, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a,
	0x13, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x73, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65,
	0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x36, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x27,
	0x12, 0x25, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x06, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x6b, 0xca, 0x41, 0x29, 0x0a, 0x0e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x17, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x12, 0x8e,
	0x02, 0x0a, 0x14, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x98, 0x01, 0xca, 0x41, 0x45, 0x0a, 0x1c, 0x44, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x47, 0x3a, 0x01, 0x2a, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x7b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x50, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x88, 0x02, 0x01, 0x12,
	0x95, 0x02, 0x0a, 0x14, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01, 0xca, 0x41, 0x45, 0x0a, 0x1c, 0x45, 0x78, 0x70,
	0x6f, 0x72, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x25, 0x45, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x51, 0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x85, 0x02, 0x0a, 0x21, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45,
	0x75, 0x6c, 0x61, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x49, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x45, 0x75, 0x6c, 0x61, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69,
	0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x75, 0x6c, 0x61, 0x41, 0x63, 0x63,
	0x65, 0x70, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x56, 0xda, 0x41, 0x16, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x3a, 0x01, 0x2a, 0x22, 0x32, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x47,
	0x61, 0x72, 0x64, 0x65, 0x6e, 0x45, 0x75, 0x6c, 0x61, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x12,
	0xf4, 0x01, 0x0a, 0x18, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45, 0x75, 0x6c, 0x61, 0x12, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x70, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f,
	0x64, 0x65, 0x6c, 0x45, 0x75, 0x6c, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x45,
	0x75, 0x6c, 0x61, 0x41, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x57, 0xda,
	0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
	0x65, 0x72, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x3a, 0x01,
	0x2a, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x47, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x45, 0x75, 0x6c, 0x61, 0x3a,
	0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xee, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x17, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x47, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes = make([]protoimpl.MessageInfo, 20)
var file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_goTypes = []any{
	(PublisherModelView)(0),                          // 0: google.cloud.aiplatform.v1beta1.PublisherModelView
	(*GetPublisherModelRequest)(nil),                 // 1: google.cloud.aiplatform.v1beta1.GetPublisherModelRequest
	(*ListPublisherModelsRequest)(nil),               // 2: google.cloud.aiplatform.v1beta1.ListPublisherModelsRequest
	(*ListPublisherModelsResponse)(nil),              // 3: google.cloud.aiplatform.v1beta1.ListPublisherModelsResponse
	(*DeployRequest)(nil),                            // 4: google.cloud.aiplatform.v1beta1.DeployRequest
	(*DeployPublisherModelRequest)(nil),              // 5: google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest
	(*DeployResponse)(nil),                           // 6: google.cloud.aiplatform.v1beta1.DeployResponse
	(*DeployPublisherModelResponse)(nil),             // 7: google.cloud.aiplatform.v1beta1.DeployPublisherModelResponse
	(*DeployOperationMetadata)(nil),                  // 8: google.cloud.aiplatform.v1beta1.DeployOperationMetadata
	(*DeployPublisherModelOperationMetadata)(nil),    // 9: google.cloud.aiplatform.v1beta1.DeployPublisherModelOperationMetadata
	(*ExportPublisherModelResponse)(nil),             // 10: google.cloud.aiplatform.v1beta1.ExportPublisherModelResponse
	(*ExportPublisherModelOperationMetadata)(nil),    // 11: google.cloud.aiplatform.v1beta1.ExportPublisherModelOperationMetadata
	(*ExportPublisherModelRequest)(nil),              // 12: google.cloud.aiplatform.v1beta1.ExportPublisherModelRequest
	(*CheckPublisherModelEulaAcceptanceRequest)(nil), // 13: google.cloud.aiplatform.v1beta1.CheckPublisherModelEulaAcceptanceRequest
	(*AcceptPublisherModelEulaRequest)(nil),          // 14: google.cloud.aiplatform.v1beta1.AcceptPublisherModelEulaRequest
	(*PublisherModelEulaAcceptance)(nil),             // 15: google.cloud.aiplatform.v1beta1.PublisherModelEulaAcceptance
	(*DeployRequest_CustomModel)(nil),                // 16: google.cloud.aiplatform.v1beta1.DeployRequest.CustomModel
	(*DeployRequest_ModelConfig)(nil),                // 17: google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
	(*DeployRequest_EndpointConfig)(nil),             // 18: google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
	(*DeployRequest_DeployConfig)(nil),               // 19: google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
	nil,                                              // 20: google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.SystemLabelsEntry
	(*PublisherModel)(nil),                           // 21: google.cloud.aiplatform.v1beta1.PublisherModel
	(*DedicatedResources)(nil),                       // 22: google.cloud.aiplatform.v1beta1.DedicatedResources
	(*GenericOperationMetadata)(nil),                 // 23: google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	(*GcsDestination)(nil),                           // 24: google.cloud.aiplatform.v1beta1.GcsDestination
	(*ModelContainerSpec)(nil),                       // 25: google.cloud.aiplatform.v1beta1.ModelContainerSpec
	(*PrivateServiceConnectConfig)(nil),              // 26: google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
	(*longrunningpb.Operation)(nil),                  // 27: google.longrunning.Operation
}
var file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_depIdxs = []int32{
	0,  // 0: google.cloud.aiplatform.v1beta1.GetPublisherModelRequest.view:type_name -> google.cloud.aiplatform.v1beta1.PublisherModelView
	0,  // 1: google.cloud.aiplatform.v1beta1.ListPublisherModelsRequest.view:type_name -> google.cloud.aiplatform.v1beta1.PublisherModelView
	21, // 2: google.cloud.aiplatform.v1beta1.ListPublisherModelsResponse.publisher_models:type_name -> google.cloud.aiplatform.v1beta1.PublisherModel
	16, // 3: google.cloud.aiplatform.v1beta1.DeployRequest.custom_model:type_name -> google.cloud.aiplatform.v1beta1.DeployRequest.CustomModel
	17, // 4: google.cloud.aiplatform.v1beta1.DeployRequest.model_config:type_name -> google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig
	18, // 5: google.cloud.aiplatform.v1beta1.DeployRequest.endpoint_config:type_name -> google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig
	19, // 6: google.cloud.aiplatform.v1beta1.DeployRequest.deploy_config:type_name -> google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig
	22, // 7: google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest.dedicated_resources:type_name -> google.cloud.aiplatform.v1beta1.DedicatedResources
	23, // 8: google.cloud.aiplatform.v1beta1.DeployOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	23, // 9: google.cloud.aiplatform.v1beta1.DeployPublisherModelOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	23, // 10: google.cloud.aiplatform.v1beta1.ExportPublisherModelOperationMetadata.generic_metadata:type_name -> google.cloud.aiplatform.v1beta1.GenericOperationMetadata
	24, // 11: google.cloud.aiplatform.v1beta1.ExportPublisherModelRequest.destination:type_name -> google.cloud.aiplatform.v1beta1.GcsDestination
	25, // 12: google.cloud.aiplatform.v1beta1.DeployRequest.ModelConfig.container_spec:type_name -> google.cloud.aiplatform.v1beta1.ModelContainerSpec
	26, // 13: google.cloud.aiplatform.v1beta1.DeployRequest.EndpointConfig.private_service_connect_config:type_name -> google.cloud.aiplatform.v1beta1.PrivateServiceConnectConfig
	22, // 14: google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.dedicated_resources:type_name -> google.cloud.aiplatform.v1beta1.DedicatedResources
	20, // 15: google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.system_labels:type_name -> google.cloud.aiplatform.v1beta1.DeployRequest.DeployConfig.SystemLabelsEntry
	1,  // 16: google.cloud.aiplatform.v1beta1.ModelGardenService.GetPublisherModel:input_type -> google.cloud.aiplatform.v1beta1.GetPublisherModelRequest
	2,  // 17: google.cloud.aiplatform.v1beta1.ModelGardenService.ListPublisherModels:input_type -> google.cloud.aiplatform.v1beta1.ListPublisherModelsRequest
	4,  // 18: google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy:input_type -> google.cloud.aiplatform.v1beta1.DeployRequest
	5,  // 19: google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel:input_type -> google.cloud.aiplatform.v1beta1.DeployPublisherModelRequest
	12, // 20: google.cloud.aiplatform.v1beta1.ModelGardenService.ExportPublisherModel:input_type -> google.cloud.aiplatform.v1beta1.ExportPublisherModelRequest
	13, // 21: google.cloud.aiplatform.v1beta1.ModelGardenService.CheckPublisherModelEulaAcceptance:input_type -> google.cloud.aiplatform.v1beta1.CheckPublisherModelEulaAcceptanceRequest
	14, // 22: google.cloud.aiplatform.v1beta1.ModelGardenService.AcceptPublisherModelEula:input_type -> google.cloud.aiplatform.v1beta1.AcceptPublisherModelEulaRequest
	21, // 23: google.cloud.aiplatform.v1beta1.ModelGardenService.GetPublisherModel:output_type -> google.cloud.aiplatform.v1beta1.PublisherModel
	3,  // 24: google.cloud.aiplatform.v1beta1.ModelGardenService.ListPublisherModels:output_type -> google.cloud.aiplatform.v1beta1.ListPublisherModelsResponse
	27, // 25: google.cloud.aiplatform.v1beta1.ModelGardenService.Deploy:output_type -> google.longrunning.Operation
	27, // 26: google.cloud.aiplatform.v1beta1.ModelGardenService.DeployPublisherModel:output_type -> google.longrunning.Operation
	27, // 27: google.cloud.aiplatform.v1beta1.ModelGardenService.ExportPublisherModel:output_type -> google.longrunning.Operation
	15, // 28: google.cloud.aiplatform.v1beta1.ModelGardenService.CheckPublisherModelEulaAcceptance:output_type -> google.cloud.aiplatform.v1beta1.PublisherModelEulaAcceptance
	15, // 29: google.cloud.aiplatform.v1beta1.ModelGardenService.AcceptPublisherModelEula:output_type -> google.cloud.aiplatform.v1beta1.PublisherModelEulaAcceptance
	23, // [23:30] is the sub-list for method output_type
	16, // [16:23] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_init() }
func file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_model_garden_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_io_proto_init()
	file_google_cloud_aiplatform_v1beta1_machine_resources_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_proto_init()
	file_google_cloud_aiplatform_v1beta1_operation_proto_init()
	file_google_cloud_aiplatform_v1beta1_publisher_model_proto_init()
	file_google_cloud_aiplatform_v1beta1_service_networking_proto_init()
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[3].OneofWrappers = []any{
		(*DeployRequest_PublisherModelName)(nil),
		(*DeployRequest_HuggingFaceModelId)(nil),
		(*DeployRequest_CustomModel_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes[15].OneofWrappers = []any{
		(*DeployRequest_CustomModel_GcsUri)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   20,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_model_garden_service_proto = out.File
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_model_garden_service_proto_depIdxs = nil
}
