%% Generated by lilypond-book
%% Options: [exampleindent=10.16\mm,indent=0\mm,line-width=160\mm]
\include "lilypond-book-preamble.ly"


% ****************************************************************
% Start cut-&-pastable-section
% ****************************************************************

#(ly:set-option 'eps-box-padding 3.000000)



\paper {
  indent = 0\mm
  line-width = 160\mm
  % offset the left padding, also add 1mm as lilypond creates cropped
  % images with a little space on the right
  line-width = #(- line-width (* mm  3.000000) (* mm 1))
}

\layout {
  
}




% ****************************************************************
% ly snippet:
% ****************************************************************
\sourcefilename "snippets/creating-custom-dynamics-in-midi-output.ly"
\sourcefileline 0
%% DO NOT EDIT this file manually; it was automatically
%% generated from the LilyPond Snippet Repository
%% (http://lsr.di.unimi.it).
%%
%% Make any changes in the LSR itself, or in
%% `Documentation/snippets/new/`, then run
%% `scripts/auxiliar/makelsr.pl`.
%%
%% This file is in the public domain.

\version "2.23.13"

\header {
%% Translation of GIT committish: a8a85e19654e46d725563e6deba44083ef137a2c
  texidocja = "
次の例は、デフォルトのリストには含まれていない強弱記号を作成し、@c
MIDI 出力に反映されるように音量値を割り当てる方法を示しています。

強弱記号 @code{\\rfz} は @code{0.9} の値が割り当てられています。
"
  doctitleja = "MIDI 出力でカスタム強弱記号を作成する"

%% Translation of GIT committish: 2f3474d9af596d677ed5b7ce720ae4d0954a6b51
  texidocit = "
L'esempio seguente mostra come creare un segno di dinamica, non incluso
nell'elenco predefinito, e assegnargli un valore specifico così che
possa essere usato per cambiare l'output MIDI.


Al segno di dinamica @code{\\rfz} viene assegnato il valore @code{0.9}.

"
  doctitleit = "Creare dinamiche personalizzate nell'output MIDI"

%% Translation of GIT committish: a3fd5364fc4f247579da0ed2bfea887ab37285c6
  texidocfr = "
L'exemple suivant illustre la manière de créer une indication de nuance,
absente de la liste par défaut, et de lui assigner une valeur spécifique
utile à la sortie MIDI.

L'indication de nuance @code{\\rfz} (@notation{rinforzando}) se voit
attribuer une valeur de @code{0.9}.
"

  doctitlefr = "Création de nuance particulière pour la sortie MIDI"

%% Translation of GIT committish: 7798429d60ba0d70cb640109f4965ba1454aca7e
  texidocca = "
L'exemple següent mostra com crear un marcatge dinàmic, que no està
inclòs a llista predeterminada, i assignar-lo a un valor específic
de manera que es pugui usar per afectar la sortida MIDI.

A la marca dinàmica @code{\\rfz} se li assigna un valor de @code{0.9}.

"
  doctitleca = "Creació de marques dinàmiques a la sortida MIDI"

  lsrtags = "midi, scheme-language"

  texidoc = "
The following example shows how to create a dynamic marking, not
included in the default list, and assign it a specific value so that it
can be used to affect MIDI output.

The dynamic mark @code{\\rfz} is assigned a value of @code{0.9}.
"

  doctitle = "Creating custom dynamics in MIDI output"
} % begin verbatim


#(define (myDynamics dynamic)
    (if (equal? dynamic "rfz")
      0.9
      (default-dynamic-absolute-volume dynamic)))

\score {
  \new Staff {
    \set Staff.midiInstrument = #"cello"
    \set Score.dynamicAbsoluteVolumeFunction = #myDynamics
    \new Voice {
      \relative {
        a'4\pp b c-\rfz
      }
    }
  }
  \layout {}
  \midi {}
}



% ****************************************************************
% end ly snippet
% ****************************************************************
