# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
# import os
# import sys
# sys.path.insert(0, os.path.abspath('.'))
try:
    import sphinx_rtd_theme
    has_theme = True
except ImportError:
    has_theme = False

try:
    import sphinx_last_updated_by_git
    has_updated_by_git = True
except ImportError:
    has_updated_by_git = False


# -- Project information -----------------------------------------------------

project = 'Freeciv21 Manual'
copyright = 'GPL-3.0-or-later, Freeciv21 and Freeciv Contributors'
author = 'Freeciv21 and Freeciv Contributors'

# The short X.Y version
version = ''
# The full version, including alpha/beta/rc tags
release = ''
# Adjust the title
html_title = 'Freeciv21 Manual'


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    'sphinx.ext.autodoc',
    'sphinx.ext.autosectionlabel',
    'sphinx.ext.doctest',
    'sphinx.ext.intersphinx',
    'sphinx.ext.todo',
    'sphinx.ext.ifconfig',
]
if has_theme:
    extensions.append('sphinx_rtd_theme')
if has_updated_by_git:
    extensions.append('sphinx_last_updated_by_git')

# See https://github.com/readthedocs/recommonmark#linking-to-headings-in-other-files
autosectionlabel_prefix_document = True

# sphinx_last_updated_by_git extension settings
git_untracked_check_dependencies = False
git_last_updated_timezone = 'UTC'
git_last_updated_metatags = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = 'en'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

#Enable the numbering of Figures
numfig = True


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
if has_theme:
    html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
html_theme_options = {
    'style_external_links': True
}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_css_files = [
  'theme_overrides.css',  # overrides for wide tables in RTD theme
]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

mathjax3_config = {
  'loader': {'load': ['[tex]/textmacros']},
  'tex': {'packages': {'[+]': ['textmacros']}}
}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'longturn-manualsdoc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',

    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',

    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, 'longturn-manuals.tex', 'longturn-manuals Documentation',
     'Longturn.net', 'manual'),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
  ('Manuals/Program/freeciv21-client', 'freeciv21-client', 'The client for the Freeciv21 game.', [author], 6),
  ('Manuals/Program/freeciv21-game-manual', 'freeciv21-game-manual', 'The game manual for the freeciv21-server.', [author], 6),
  ('Manuals/Program/freeciv21-manual', 'freeciv21-manual', 'Write a manual for a Freeciv21 ruleset.', [author], 6),
  ('Manuals/Program/freeciv21-modpack-qt', 'freeciv21-modpack-qt', 'GUI modpack installer for Freeciv21.', [author], 6),
  ('Manuals/Program/freeciv21-modpack', 'freeciv21-modpack', 'Command line modpack installer for Freeciv21.', [author], 6),
  ('Manuals/Program/freeciv21-ruleup', 'freeciv21-ruleup', 'Command line ruleset upgrade tool for Freeciv21.', [author], 6),
  ('Manuals/Program/freeciv21-server', 'freeciv21-server', 'The server for the Freeciv21 game.', [author], 6)

]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (master_doc, 'longturn-manuals', 'longturn-manuals Documentation',
     author, 'longturn-manuals', 'One line description of project.',
     'Miscellaneous'),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = 'longturn-manualsdoc'

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ['search.html']


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'python': ('https://docs.python.org/3', None)}

# -- Options for todo extension ----------------------------------------------

# If true, `todo` and `todoList` produce output, else they produce nothing.
todo_include_todos = True
