// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v4.24.4
// source: google/bigtable/v2/feature_flags.proto

package bigtable

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Feature flags supported or enabled by a client.
// This is intended to be sent as part of request metadata to assure the server
// that certain behaviors are safe to enable. This proto is meant to be
// serialized and websafe-base64 encoded under the `bigtable-features` metadata
// key. The value will remain constant for the lifetime of a client and due to
// HTTP2's HPACK compression, the request overhead will be tiny.
// This is an internal implementation detail and should not be used by end users
// directly.
type FeatureFlags struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Notify the server that the client supports reverse scans. The server will
	// reject ReadRowsRequests with the reverse bit set when this is absent.
	ReverseScans bool `protobuf:"varint,1,opt,name=reverse_scans,json=reverseScans,proto3" json:"reverse_scans,omitempty"`
	// Notify the server that the client enables batch write flow control by
	// requesting RateLimitInfo from MutateRowsResponse. Due to technical reasons,
	// this disables partial retries.
	MutateRowsRateLimit bool `protobuf:"varint,3,opt,name=mutate_rows_rate_limit,json=mutateRowsRateLimit,proto3" json:"mutate_rows_rate_limit,omitempty"`
	// Notify the server that the client enables batch write flow control by
	// requesting RateLimitInfo from MutateRowsResponse. With partial retries
	// enabled.
	MutateRowsRateLimit2 bool `protobuf:"varint,5,opt,name=mutate_rows_rate_limit2,json=mutateRowsRateLimit2,proto3" json:"mutate_rows_rate_limit2,omitempty"`
	// Notify the server that the client supports the last_scanned_row field
	// in ReadRowsResponse for long-running scans.
	LastScannedRowResponses bool `protobuf:"varint,4,opt,name=last_scanned_row_responses,json=lastScannedRowResponses,proto3" json:"last_scanned_row_responses,omitempty"`
	// Notify the server that the client supports using encoded routing cookie
	// strings to retry requests with.
	RoutingCookie bool `protobuf:"varint,6,opt,name=routing_cookie,json=routingCookie,proto3" json:"routing_cookie,omitempty"`
	// Notify the server that the client supports using retry info back off
	// durations to retry requests with.
	RetryInfo bool `protobuf:"varint,7,opt,name=retry_info,json=retryInfo,proto3" json:"retry_info,omitempty"`
	// Notify the server that the client has client side metrics enabled.
	ClientSideMetricsEnabled bool `protobuf:"varint,8,opt,name=client_side_metrics_enabled,json=clientSideMetricsEnabled,proto3" json:"client_side_metrics_enabled,omitempty"`
}

func (x *FeatureFlags) Reset() {
	*x = FeatureFlags{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_bigtable_v2_feature_flags_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FeatureFlags) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureFlags) ProtoMessage() {}

func (x *FeatureFlags) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_feature_flags_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureFlags.ProtoReflect.Descriptor instead.
func (*FeatureFlags) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_feature_flags_proto_rawDescGZIP(), []int{0}
}

func (x *FeatureFlags) GetReverseScans() bool {
	if x != nil {
		return x.ReverseScans
	}
	return false
}

func (x *FeatureFlags) GetMutateRowsRateLimit() bool {
	if x != nil {
		return x.MutateRowsRateLimit
	}
	return false
}

func (x *FeatureFlags) GetMutateRowsRateLimit2() bool {
	if x != nil {
		return x.MutateRowsRateLimit2
	}
	return false
}

func (x *FeatureFlags) GetLastScannedRowResponses() bool {
	if x != nil {
		return x.LastScannedRowResponses
	}
	return false
}

func (x *FeatureFlags) GetRoutingCookie() bool {
	if x != nil {
		return x.RoutingCookie
	}
	return false
}

func (x *FeatureFlags) GetRetryInfo() bool {
	if x != nil {
		return x.RetryInfo
	}
	return false
}

func (x *FeatureFlags) GetClientSideMetricsEnabled() bool {
	if x != nil {
		return x.ClientSideMetricsEnabled
	}
	return false
}

var File_google_bigtable_v2_feature_flags_proto protoreflect.FileDescriptor

var file_google_bigtable_v2_feature_flags_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x76, 0x32, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x66, 0x6c, 0x61,
	0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x22, 0xe1, 0x02, 0x0a,
	0x0c, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x12, 0x23, 0x0a,
	0x0d, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x0c, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x53, 0x63, 0x61,
	0x6e, 0x73, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x72, 0x6f, 0x77,
	0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x13, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x12, 0x35, 0x0a, 0x17, 0x6d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69,
	0x74, 0x32, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65,
	0x52, 0x6f, 0x77, 0x73, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x32, 0x12, 0x3b,
	0x0a, 0x1a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x72,
	0x6f, 0x77, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x17, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x52,
	0x6f, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72,
	0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x08, 0x52, 0x0d, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x6f, 0x6b,
	0x69, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x74, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x72, 0x65, 0x74, 0x72, 0x79, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x3d, 0x0a, 0x1b, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x69, 0x64, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x18, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x69,
	0x64, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x42, 0xbd, 0x01, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x42, 0x11, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x46, 0x6c, 0x61, 0x67, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2f, 0x76, 0x32, 0x3b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0xaa, 0x02, 0x18, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a, 0x56, 0x32,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_v2_feature_flags_proto_rawDescOnce sync.Once
	file_google_bigtable_v2_feature_flags_proto_rawDescData = file_google_bigtable_v2_feature_flags_proto_rawDesc
)

func file_google_bigtable_v2_feature_flags_proto_rawDescGZIP() []byte {
	file_google_bigtable_v2_feature_flags_proto_rawDescOnce.Do(func() {
		file_google_bigtable_v2_feature_flags_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_v2_feature_flags_proto_rawDescData)
	})
	return file_google_bigtable_v2_feature_flags_proto_rawDescData
}

var file_google_bigtable_v2_feature_flags_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_bigtable_v2_feature_flags_proto_goTypes = []interface{}{
	(*FeatureFlags)(nil), // 0: google.bigtable.v2.FeatureFlags
}
var file_google_bigtable_v2_feature_flags_proto_depIdxs = []int32{
	0, // [0:0] is the sub-list for method output_type
	0, // [0:0] is the sub-list for method input_type
	0, // [0:0] is the sub-list for extension type_name
	0, // [0:0] is the sub-list for extension extendee
	0, // [0:0] is the sub-list for field type_name
}

func init() { file_google_bigtable_v2_feature_flags_proto_init() }
func file_google_bigtable_v2_feature_flags_proto_init() {
	if File_google_bigtable_v2_feature_flags_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_bigtable_v2_feature_flags_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FeatureFlags); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_v2_feature_flags_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_v2_feature_flags_proto_goTypes,
		DependencyIndexes: file_google_bigtable_v2_feature_flags_proto_depIdxs,
		MessageInfos:      file_google_bigtable_v2_feature_flags_proto_msgTypes,
	}.Build()
	File_google_bigtable_v2_feature_flags_proto = out.File
	file_google_bigtable_v2_feature_flags_proto_rawDesc = nil
	file_google_bigtable_v2_feature_flags_proto_goTypes = nil
	file_google_bigtable_v2_feature_flags_proto_depIdxs = nil
}
