package videoanalyzerapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/videoanalyzer/mgmt/2021-05-01-preview/videoanalyzer"
	"github.com/Azure/go-autorest/autorest"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result videoanalyzer.OperationCollection, err error)
}

var _ OperationsClientAPI = (*videoanalyzer.OperationsClient)(nil)

// VideoAnalyzersClientAPI contains the set of methods on the VideoAnalyzersClient type.
type VideoAnalyzersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, parameters videoanalyzer.Model) (result videoanalyzer.Model, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string) (result videoanalyzer.Model, err error)
	List(ctx context.Context, resourceGroupName string) (result videoanalyzer.Collection, err error)
	ListBySubscription(ctx context.Context) (result videoanalyzer.Collection, err error)
	SyncStorageKeys(ctx context.Context, resourceGroupName string, accountName string, parameters videoanalyzer.SyncStorageKeysInput) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, parameters videoanalyzer.Update) (result videoanalyzer.Model, err error)
}

var _ VideoAnalyzersClientAPI = (*videoanalyzer.VideoAnalyzersClient)(nil)

// LocationsClientAPI contains the set of methods on the LocationsClient type.
type LocationsClientAPI interface {
	CheckNameAvailability(ctx context.Context, locationName string, parameters videoanalyzer.CheckNameAvailabilityRequest) (result videoanalyzer.CheckNameAvailabilityResponse, err error)
}

var _ LocationsClientAPI = (*videoanalyzer.LocationsClient)(nil)

// EdgeModulesClientAPI contains the set of methods on the EdgeModulesClient type.
type EdgeModulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, edgeModuleName string, parameters videoanalyzer.EdgeModuleEntity) (result videoanalyzer.EdgeModuleEntity, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, edgeModuleName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, edgeModuleName string) (result videoanalyzer.EdgeModuleEntity, err error)
	List(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, orderby string) (result videoanalyzer.EdgeModuleEntityCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, accountName string, filter string, top *int32, orderby string) (result videoanalyzer.EdgeModuleEntityCollectionIterator, err error)
	ListProvisioningToken(ctx context.Context, resourceGroupName string, accountName string, edgeModuleName string, parameters videoanalyzer.ListProvisioningTokenInput) (result videoanalyzer.EdgeModuleProvisioningToken, err error)
}

var _ EdgeModulesClientAPI = (*videoanalyzer.EdgeModulesClient)(nil)

// VideosClientAPI contains the set of methods on the VideosClient type.
type VideosClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, videoName string, parameters videoanalyzer.VideoEntity) (result videoanalyzer.VideoEntity, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, videoName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, videoName string) (result videoanalyzer.VideoEntity, err error)
	List(ctx context.Context, resourceGroupName string, accountName string, top *int32) (result videoanalyzer.VideoEntityCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, accountName string, top *int32) (result videoanalyzer.VideoEntityCollectionIterator, err error)
	ListStreamingToken(ctx context.Context, resourceGroupName string, accountName string, videoName string) (result videoanalyzer.VideoStreamingToken, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, videoName string, parameters videoanalyzer.VideoEntity) (result videoanalyzer.VideoEntity, err error)
}

var _ VideosClientAPI = (*videoanalyzer.VideosClient)(nil)

// AccessPoliciesClientAPI contains the set of methods on the AccessPoliciesClient type.
type AccessPoliciesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, accessPolicyName string, parameters videoanalyzer.AccessPolicyEntity) (result videoanalyzer.AccessPolicyEntity, err error)
	Delete(ctx context.Context, resourceGroupName string, accountName string, accessPolicyName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, accountName string, accessPolicyName string) (result videoanalyzer.AccessPolicyEntity, err error)
	List(ctx context.Context, resourceGroupName string, accountName string, top *int32) (result videoanalyzer.AccessPolicyEntityCollectionPage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, accountName string, top *int32) (result videoanalyzer.AccessPolicyEntityCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, accountName string, accessPolicyName string, parameters videoanalyzer.AccessPolicyEntity) (result videoanalyzer.AccessPolicyEntity, err error)
}

var _ AccessPoliciesClientAPI = (*videoanalyzer.AccessPoliciesClient)(nil)
