package webapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/web/mgmt/2021-01-15/web"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
)

// BaseClientAPI contains the set of methods on the BaseClient type.
type BaseClientAPI interface {
	CheckNameAvailability(ctx context.Context, request web.ResourceNameAvailabilityRequest) (result web.ResourceNameAvailability, err error)
	GenerateGithubAccessTokenForAppserviceCLIAsync(ctx context.Context, request web.AppserviceGithubTokenRequest) (result web.AppserviceGithubToken, err error)
	GetPublishingUser(ctx context.Context) (result web.User, err error)
	GetSourceControl(ctx context.Context, sourceControlType string) (result web.SourceControl, err error)
	GetSubscriptionDeploymentLocations(ctx context.Context) (result web.DeploymentLocations, err error)
	ListBillingMeters(ctx context.Context, billingLocation string, osType string) (result web.BillingMeterCollectionPage, err error)
	ListBillingMetersComplete(ctx context.Context, billingLocation string, osType string) (result web.BillingMeterCollectionIterator, err error)
	ListGeoRegions(ctx context.Context, sku web.SkuName, linuxWorkersEnabled *bool, xenonWorkersEnabled *bool, linuxDynamicWorkersEnabled *bool) (result web.GeoRegionCollectionPage, err error)
	ListGeoRegionsComplete(ctx context.Context, sku web.SkuName, linuxWorkersEnabled *bool, xenonWorkersEnabled *bool, linuxDynamicWorkersEnabled *bool) (result web.GeoRegionCollectionIterator, err error)
	ListPremierAddOnOffers(ctx context.Context) (result web.PremierAddOnOfferCollectionPage, err error)
	ListPremierAddOnOffersComplete(ctx context.Context) (result web.PremierAddOnOfferCollectionIterator, err error)
	ListSiteIdentifiersAssignedToHostName(ctx context.Context, nameIdentifier web.NameIdentifier) (result web.IdentifierCollectionPage, err error)
	ListSiteIdentifiersAssignedToHostNameComplete(ctx context.Context, nameIdentifier web.NameIdentifier) (result web.IdentifierCollectionIterator, err error)
	ListSkus(ctx context.Context) (result web.SkuInfos, err error)
	ListSourceControls(ctx context.Context) (result web.SourceControlCollectionPage, err error)
	ListSourceControlsComplete(ctx context.Context) (result web.SourceControlCollectionIterator, err error)
	Move(ctx context.Context, resourceGroupName string, moveResourceEnvelope web.CsmMoveResourceEnvelope) (result autorest.Response, err error)
	UpdatePublishingUser(ctx context.Context, userDetails web.User) (result web.User, err error)
	UpdateSourceControl(ctx context.Context, sourceControlType string, requestMessage web.SourceControl) (result web.SourceControl, err error)
	Validate(ctx context.Context, resourceGroupName string, validateRequest web.ValidateRequest) (result web.ValidateResponse, err error)
	ValidateMove(ctx context.Context, resourceGroupName string, moveResourceEnvelope web.CsmMoveResourceEnvelope) (result autorest.Response, err error)
	VerifyHostingEnvironmentVnet(ctx context.Context, parameters web.VnetParameters) (result web.VnetValidationFailureDetails, err error)
}

var _ BaseClientAPI = (*web.BaseClient)(nil)

// AppServiceCertificateOrdersClientAPI contains the set of methods on the AppServiceCertificateOrdersClient type.
type AppServiceCertificateOrdersClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName web.AppServiceCertificateOrder) (result web.AppServiceCertificateOrdersCreateOrUpdateFuture, err error)
	CreateOrUpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate web.AppServiceCertificateResource) (result web.AppServiceCertificateOrdersCreateOrUpdateCertificateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error)
	DeleteCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.AppServiceCertificateOrder, err error)
	GetCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string) (result web.AppServiceCertificateResource, err error)
	List(ctx context.Context) (result web.AppServiceCertificateOrderCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.AppServiceCertificateOrderCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.AppServiceCertificateOrderCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.AppServiceCertificateOrderCollectionIterator, err error)
	ListCertificates(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.AppServiceCertificateCollectionPage, err error)
	ListCertificatesComplete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.AppServiceCertificateCollectionIterator, err error)
	Reissue(ctx context.Context, resourceGroupName string, certificateOrderName string, reissueCertificateOrderRequest web.ReissueCertificateOrderRequest) (result autorest.Response, err error)
	Renew(ctx context.Context, resourceGroupName string, certificateOrderName string, renewCertificateOrderRequest web.RenewCertificateOrderRequest) (result autorest.Response, err error)
	ResendEmail(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error)
	ResendRequestEmails(ctx context.Context, resourceGroupName string, certificateOrderName string, nameIdentifier web.NameIdentifier) (result autorest.Response, err error)
	RetrieveCertificateActions(ctx context.Context, resourceGroupName string, name string) (result web.ListCertificateOrderAction, err error)
	RetrieveCertificateEmailHistory(ctx context.Context, resourceGroupName string, name string) (result web.ListCertificateEmail, err error)
	RetrieveSiteSeal(ctx context.Context, resourceGroupName string, certificateOrderName string, siteSealRequest web.SiteSealRequest) (result web.SiteSeal, err error)
	Update(ctx context.Context, resourceGroupName string, certificateOrderName string, certificateDistinguishedName web.AppServiceCertificateOrderPatchResource) (result web.AppServiceCertificateOrder, err error)
	UpdateCertificate(ctx context.Context, resourceGroupName string, certificateOrderName string, name string, keyVaultCertificate web.AppServiceCertificatePatchResource) (result web.AppServiceCertificateResource, err error)
	ValidatePurchaseInformation(ctx context.Context, appServiceCertificateOrder web.AppServiceCertificateOrder) (result autorest.Response, err error)
	VerifyDomainOwnership(ctx context.Context, resourceGroupName string, certificateOrderName string) (result autorest.Response, err error)
}

var _ AppServiceCertificateOrdersClientAPI = (*web.AppServiceCertificateOrdersClient)(nil)

// CertificateOrdersDiagnosticsClientAPI contains the set of methods on the CertificateOrdersDiagnosticsClient type.
type CertificateOrdersDiagnosticsClientAPI interface {
	GetAppServiceCertificateOrderDetectorResponse(ctx context.Context, resourceGroupName string, certificateOrderName string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	ListAppServiceCertificateOrderDetectorResponse(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.DetectorResponseCollectionPage, err error)
	ListAppServiceCertificateOrderDetectorResponseComplete(ctx context.Context, resourceGroupName string, certificateOrderName string) (result web.DetectorResponseCollectionIterator, err error)
}

var _ CertificateOrdersDiagnosticsClientAPI = (*web.CertificateOrdersDiagnosticsClient)(nil)

// CertificateRegistrationProviderClientAPI contains the set of methods on the CertificateRegistrationProviderClient type.
type CertificateRegistrationProviderClientAPI interface {
	ListOperations(ctx context.Context) (result web.CsmOperationCollectionPage, err error)
	ListOperationsComplete(ctx context.Context) (result web.CsmOperationCollectionIterator, err error)
}

var _ CertificateRegistrationProviderClientAPI = (*web.CertificateRegistrationProviderClient)(nil)

// DomainsClientAPI contains the set of methods on the DomainsClient type.
type DomainsClientAPI interface {
	CheckAvailability(ctx context.Context, identifier web.NameIdentifier) (result web.DomainAvailabilityCheckResult, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, domainName string, domain web.Domain) (result web.DomainsCreateOrUpdateFuture, err error)
	CreateOrUpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier web.DomainOwnershipIdentifier) (result web.DomainOwnershipIdentifier, err error)
	Delete(ctx context.Context, resourceGroupName string, domainName string, forceHardDeleteDomain *bool) (result autorest.Response, err error)
	DeleteOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, domainName string) (result web.Domain, err error)
	GetControlCenterSsoRequest(ctx context.Context) (result web.DomainControlCenterSsoRequest, err error)
	GetOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string) (result web.DomainOwnershipIdentifier, err error)
	List(ctx context.Context) (result web.DomainCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.DomainCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.DomainCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.DomainCollectionIterator, err error)
	ListOwnershipIdentifiers(ctx context.Context, resourceGroupName string, domainName string) (result web.DomainOwnershipIdentifierCollectionPage, err error)
	ListOwnershipIdentifiersComplete(ctx context.Context, resourceGroupName string, domainName string) (result web.DomainOwnershipIdentifierCollectionIterator, err error)
	ListRecommendations(ctx context.Context, parameters web.DomainRecommendationSearchParameters) (result web.NameIdentifierCollectionPage, err error)
	ListRecommendationsComplete(ctx context.Context, parameters web.DomainRecommendationSearchParameters) (result web.NameIdentifierCollectionIterator, err error)
	Renew(ctx context.Context, resourceGroupName string, domainName string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, domainName string, domain web.DomainPatchResource) (result web.Domain, err error)
	UpdateOwnershipIdentifier(ctx context.Context, resourceGroupName string, domainName string, name string, domainOwnershipIdentifier web.DomainOwnershipIdentifier) (result web.DomainOwnershipIdentifier, err error)
}

var _ DomainsClientAPI = (*web.DomainsClient)(nil)

// TopLevelDomainsClientAPI contains the set of methods on the TopLevelDomainsClient type.
type TopLevelDomainsClientAPI interface {
	Get(ctx context.Context, name string) (result web.TopLevelDomain, err error)
	List(ctx context.Context) (result web.TopLevelDomainCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.TopLevelDomainCollectionIterator, err error)
	ListAgreements(ctx context.Context, name string, agreementOption web.TopLevelDomainAgreementOption) (result web.TldLegalAgreementCollectionPage, err error)
	ListAgreementsComplete(ctx context.Context, name string, agreementOption web.TopLevelDomainAgreementOption) (result web.TldLegalAgreementCollectionIterator, err error)
}

var _ TopLevelDomainsClientAPI = (*web.TopLevelDomainsClient)(nil)

// DomainRegistrationProviderClientAPI contains the set of methods on the DomainRegistrationProviderClient type.
type DomainRegistrationProviderClientAPI interface {
	ListOperations(ctx context.Context) (result web.CsmOperationCollectionPage, err error)
	ListOperationsComplete(ctx context.Context) (result web.CsmOperationCollectionIterator, err error)
}

var _ DomainRegistrationProviderClientAPI = (*web.DomainRegistrationProviderClient)(nil)

// AppServiceEnvironmentsClientAPI contains the set of methods on the AppServiceEnvironmentsClient type.
type AppServiceEnvironmentsClientAPI interface {
	ApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper web.PrivateLinkConnectionApprovalRequestResource) (result web.AppServiceEnvironmentsApproveOrRejectPrivateEndpointConnectionFuture, err error)
	ChangeVnet(ctx context.Context, resourceGroupName string, name string, vnetInfo web.VirtualNetworkProfile) (result web.AppServiceEnvironmentsChangeVnetFuture, err error)
	ChangeVnetComplete(ctx context.Context, resourceGroupName string, name string, vnetInfo web.VirtualNetworkProfile) (result web.AppServiceEnvironmentsChangeVnetAllFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope web.AppServiceEnvironmentResource) (result web.AppServiceEnvironmentsCreateOrUpdateFuture, err error)
	CreateOrUpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope web.WorkerPoolResource) (result web.AppServiceEnvironmentsCreateOrUpdateMultiRolePoolFuture, err error)
	CreateOrUpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope web.WorkerPoolResource) (result web.AppServiceEnvironmentsCreateOrUpdateWorkerPoolFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, name string, forceDelete *bool) (result web.AppServiceEnvironmentsDeleteFuture, err error)
	DeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result web.AppServiceEnvironmentsDeletePrivateEndpointConnectionFuture, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentResource, err error)
	GetAseV3NetworkingConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.AseV3NetworkingConfiguration, err error)
	GetDiagnosticsItem(ctx context.Context, resourceGroupName string, name string, diagnosticsName string) (result web.HostingEnvironmentDiagnostics, err error)
	GetInboundNetworkDependenciesEndpoints(ctx context.Context, resourceGroupName string, name string) (result web.InboundEnvironmentEndpointCollectionPage, err error)
	GetInboundNetworkDependenciesEndpointsComplete(ctx context.Context, resourceGroupName string, name string) (result web.InboundEnvironmentEndpointCollectionIterator, err error)
	GetMultiRolePool(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolResource, err error)
	GetOutboundNetworkDependenciesEndpoints(ctx context.Context, resourceGroupName string, name string) (result web.OutboundEnvironmentEndpointCollectionPage, err error)
	GetOutboundNetworkDependenciesEndpointsComplete(ctx context.Context, resourceGroupName string, name string) (result web.OutboundEnvironmentEndpointCollectionIterator, err error)
	GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result web.RemotePrivateEndpointConnectionARMResource, err error)
	GetPrivateEndpointConnectionList(ctx context.Context, resourceGroupName string, name string) (result web.PrivateEndpointConnectionCollectionPage, err error)
	GetPrivateEndpointConnectionListComplete(ctx context.Context, resourceGroupName string, name string) (result web.PrivateEndpointConnectionCollectionIterator, err error)
	GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string) (result web.PrivateLinkResourcesWrapper, err error)
	GetVipInfo(ctx context.Context, resourceGroupName string, name string) (result web.AddressResponse, err error)
	GetWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.WorkerPoolResource, err error)
	List(ctx context.Context) (result web.AppServiceEnvironmentCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.AppServiceEnvironmentCollectionIterator, err error)
	ListAppServicePlans(ctx context.Context, resourceGroupName string, name string) (result web.AppServicePlanCollectionPage, err error)
	ListAppServicePlansComplete(ctx context.Context, resourceGroupName string, name string) (result web.AppServicePlanCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.AppServiceEnvironmentCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.AppServiceEnvironmentCollectionIterator, err error)
	ListCapacities(ctx context.Context, resourceGroupName string, name string) (result web.StampCapacityCollectionPage, err error)
	ListCapacitiesComplete(ctx context.Context, resourceGroupName string, name string) (result web.StampCapacityCollectionIterator, err error)
	ListDiagnostics(ctx context.Context, resourceGroupName string, name string) (result web.ListHostingEnvironmentDiagnostics, err error)
	ListMultiRoleMetricDefinitions(ctx context.Context, resourceGroupName string, name string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMultiRoleMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string) (result web.ResourceMetricDefinitionCollectionIterator, err error)
	ListMultiRolePoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, instance string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListMultiRolePoolInstanceMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, instance string) (result web.ResourceMetricDefinitionCollectionIterator, err error)
	ListMultiRolePools(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionPage, err error)
	ListMultiRolePoolsComplete(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionIterator, err error)
	ListMultiRolePoolSkus(ctx context.Context, resourceGroupName string, name string) (result web.SkuInfoCollectionPage, err error)
	ListMultiRolePoolSkusComplete(ctx context.Context, resourceGroupName string, name string) (result web.SkuInfoCollectionIterator, err error)
	ListMultiRoleUsages(ctx context.Context, resourceGroupName string, name string) (result web.UsageCollectionPage, err error)
	ListMultiRoleUsagesComplete(ctx context.Context, resourceGroupName string, name string) (result web.UsageCollectionIterator, err error)
	ListOperations(ctx context.Context, resourceGroupName string, name string) (result web.ListOperation, err error)
	ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionIterator, err error)
	ListWebApps(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.AppCollectionPage, err error)
	ListWebAppsComplete(ctx context.Context, resourceGroupName string, name string, propertiesToInclude string) (result web.AppCollectionIterator, err error)
	ListWebWorkerMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListWebWorkerMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.ResourceMetricDefinitionCollectionIterator, err error)
	ListWebWorkerUsages(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.UsageCollectionPage, err error)
	ListWebWorkerUsagesComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.UsageCollectionIterator, err error)
	ListWorkerPoolInstanceMetricDefinitions(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result web.ResourceMetricDefinitionCollectionPage, err error)
	ListWorkerPoolInstanceMetricDefinitionsComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string, instance string) (result web.ResourceMetricDefinitionCollectionIterator, err error)
	ListWorkerPools(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionPage, err error)
	ListWorkerPoolsComplete(ctx context.Context, resourceGroupName string, name string) (result web.WorkerPoolCollectionIterator, err error)
	ListWorkerPoolSkus(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.SkuInfoCollectionPage, err error)
	ListWorkerPoolSkusComplete(ctx context.Context, resourceGroupName string, name string, workerPoolName string) (result web.SkuInfoCollectionIterator, err error)
	Reboot(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	Resume(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentsResumeFuture, err error)
	ResumeComplete(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentsResumeAllFuture, err error)
	Suspend(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentsSuspendFuture, err error)
	SuspendComplete(ctx context.Context, resourceGroupName string, name string) (result web.AppServiceEnvironmentsSuspendAllFuture, err error)
	Update(ctx context.Context, resourceGroupName string, name string, hostingEnvironmentEnvelope web.AppServiceEnvironmentPatchResource) (result web.AppServiceEnvironmentResource, err error)
	UpdateAseNetworkingConfiguration(ctx context.Context, resourceGroupName string, name string, aseNetworkingConfiguration web.AseV3NetworkingConfiguration) (result web.AseV3NetworkingConfiguration, err error)
	UpdateMultiRolePool(ctx context.Context, resourceGroupName string, name string, multiRolePoolEnvelope web.WorkerPoolResource) (result web.WorkerPoolResource, err error)
	UpdateWorkerPool(ctx context.Context, resourceGroupName string, name string, workerPoolName string, workerPoolEnvelope web.WorkerPoolResource) (result web.WorkerPoolResource, err error)
}

var _ AppServiceEnvironmentsClientAPI = (*web.AppServiceEnvironmentsClient)(nil)

// AppServicePlansClientAPI contains the set of methods on the AppServicePlansClient type.
type AppServicePlansClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, appServicePlan web.AppServicePlan) (result web.AppServicePlansCreateOrUpdateFuture, err error)
	CreateOrUpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route web.VnetRoute) (result web.VnetRoute, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error)
	DeleteVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.AppServicePlan, err error)
	GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnection, err error)
	GetHybridConnectionPlanLimit(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnectionLimits, err error)
	GetRouteForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string) (result web.ListVnetRoute, err error)
	GetServerFarmSkus(ctx context.Context, resourceGroupName string, name string) (result web.SetObject, err error)
	GetVnetFromServerFarm(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.VnetInfo, err error)
	GetVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result web.VnetGateway, err error)
	List(ctx context.Context, detailed *bool) (result web.AppServicePlanCollectionPage, err error)
	ListComplete(ctx context.Context, detailed *bool) (result web.AppServicePlanCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.AppServicePlanCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.AppServicePlanCollectionIterator, err error)
	ListCapabilities(ctx context.Context, resourceGroupName string, name string) (result web.ListCapability, err error)
	ListHybridConnectionKeys(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnectionKey, err error)
	ListHybridConnections(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnectionCollectionPage, err error)
	ListHybridConnectionsComplete(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnectionCollectionIterator, err error)
	ListRoutesForVnet(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.ListVnetRoute, err error)
	ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionIterator, err error)
	ListVnets(ctx context.Context, resourceGroupName string, name string) (result web.ListVnetInfo, err error)
	ListWebApps(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result web.AppCollectionPage, err error)
	ListWebAppsComplete(ctx context.Context, resourceGroupName string, name string, skipToken string, filter string, top string) (result web.AppCollectionIterator, err error)
	ListWebAppsByHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.ResourceCollectionPage, err error)
	ListWebAppsByHybridConnectionComplete(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.ResourceCollectionIterator, err error)
	RebootWorker(ctx context.Context, resourceGroupName string, name string, workerName string) (result autorest.Response, err error)
	RestartWebApps(ctx context.Context, resourceGroupName string, name string, softRestart *bool) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, name string, appServicePlan web.AppServicePlanPatchResource) (result web.AppServicePlan, err error)
	UpdateVnetGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	UpdateVnetRoute(ctx context.Context, resourceGroupName string, name string, vnetName string, routeName string, route web.VnetRoute) (result web.VnetRoute, err error)
}

var _ AppServicePlansClientAPI = (*web.AppServicePlansClient)(nil)

// CertificatesClientAPI contains the set of methods on the CertificatesClient type.
type CertificatesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, certificateEnvelope web.Certificate) (result web.Certificate, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.Certificate, err error)
	List(ctx context.Context, filter string) (result web.CertificateCollectionPage, err error)
	ListComplete(ctx context.Context, filter string) (result web.CertificateCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.CertificateCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.CertificateCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, name string, certificateEnvelope web.CertificatePatchResource) (result web.Certificate, err error)
}

var _ CertificatesClientAPI = (*web.CertificatesClient)(nil)

// DeletedWebAppsClientAPI contains the set of methods on the DeletedWebAppsClient type.
type DeletedWebAppsClientAPI interface {
	GetDeletedWebAppByLocation(ctx context.Context, location string, deletedSiteID string) (result web.DeletedSite, err error)
	List(ctx context.Context) (result web.DeletedWebAppCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.DeletedWebAppCollectionIterator, err error)
	ListByLocation(ctx context.Context, location string) (result web.DeletedWebAppCollectionPage, err error)
	ListByLocationComplete(ctx context.Context, location string) (result web.DeletedWebAppCollectionIterator, err error)
}

var _ DeletedWebAppsClientAPI = (*web.DeletedWebAppsClient)(nil)

// DiagnosticsClientAPI contains the set of methods on the DiagnosticsClient type.
type DiagnosticsClientAPI interface {
	ExecuteSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticAnalysis, err error)
	ExecuteSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticAnalysis, err error)
	ExecuteSiteDetector(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticDetectorResponse, err error)
	ExecuteSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, diagnosticCategory string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DiagnosticDetectorResponse, err error)
	GetHostingEnvironmentDetectorResponse(ctx context.Context, resourceGroupName string, name string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	GetSiteAnalysis(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string) (result web.AnalysisDefinition, err error)
	GetSiteAnalysisSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, analysisName string, slot string) (result web.AnalysisDefinition, err error)
	GetSiteDetector(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string) (result web.DetectorDefinition, err error)
	GetSiteDetectorResponse(ctx context.Context, resourceGroupName string, siteName string, detectorName string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	GetSiteDetectorResponseSlot(ctx context.Context, resourceGroupName string, siteName string, detectorName string, slot string, startTime *date.Time, endTime *date.Time, timeGrain string) (result web.DetectorResponse, err error)
	GetSiteDetectorSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, detectorName string, slot string) (result web.DetectorDefinition, err error)
	GetSiteDiagnosticCategory(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticCategory, err error)
	GetSiteDiagnosticCategorySlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticCategory, err error)
	ListHostingEnvironmentDetectorResponses(ctx context.Context, resourceGroupName string, name string) (result web.DetectorResponseCollectionPage, err error)
	ListHostingEnvironmentDetectorResponsesComplete(ctx context.Context, resourceGroupName string, name string) (result web.DetectorResponseCollectionIterator, err error)
	ListSiteAnalyses(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticAnalysisCollectionPage, err error)
	ListSiteAnalysesComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticAnalysisCollectionIterator, err error)
	ListSiteAnalysesSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticAnalysisCollectionPage, err error)
	ListSiteAnalysesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticAnalysisCollectionIterator, err error)
	ListSiteDetectorResponses(ctx context.Context, resourceGroupName string, siteName string) (result web.DetectorResponseCollectionPage, err error)
	ListSiteDetectorResponsesComplete(ctx context.Context, resourceGroupName string, siteName string) (result web.DetectorResponseCollectionIterator, err error)
	ListSiteDetectorResponsesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result web.DetectorResponseCollectionPage, err error)
	ListSiteDetectorResponsesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, slot string) (result web.DetectorResponseCollectionIterator, err error)
	ListSiteDetectors(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticDetectorCollectionPage, err error)
	ListSiteDetectorsComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string) (result web.DiagnosticDetectorCollectionIterator, err error)
	ListSiteDetectorsSlot(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticDetectorCollectionPage, err error)
	ListSiteDetectorsSlotComplete(ctx context.Context, resourceGroupName string, siteName string, diagnosticCategory string, slot string) (result web.DiagnosticDetectorCollectionIterator, err error)
	ListSiteDiagnosticCategories(ctx context.Context, resourceGroupName string, siteName string) (result web.DiagnosticCategoryCollectionPage, err error)
	ListSiteDiagnosticCategoriesComplete(ctx context.Context, resourceGroupName string, siteName string) (result web.DiagnosticCategoryCollectionIterator, err error)
	ListSiteDiagnosticCategoriesSlot(ctx context.Context, resourceGroupName string, siteName string, slot string) (result web.DiagnosticCategoryCollectionPage, err error)
	ListSiteDiagnosticCategoriesSlotComplete(ctx context.Context, resourceGroupName string, siteName string, slot string) (result web.DiagnosticCategoryCollectionIterator, err error)
}

var _ DiagnosticsClientAPI = (*web.DiagnosticsClient)(nil)

// GlobalClientAPI contains the set of methods on the GlobalClient type.
type GlobalClientAPI interface {
	GetDeletedWebApp(ctx context.Context, deletedSiteID string) (result web.DeletedSite, err error)
	GetDeletedWebAppSnapshots(ctx context.Context, deletedSiteID string) (result web.ListSnapshot, err error)
	GetSubscriptionOperationWithAsyncResponse(ctx context.Context, location string, operationID string) (result autorest.Response, err error)
}

var _ GlobalClientAPI = (*web.GlobalClient)(nil)

// KubeEnvironmentsClientAPI contains the set of methods on the KubeEnvironmentsClient type.
type KubeEnvironmentsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, kubeEnvironmentEnvelope web.KubeEnvironment) (result web.KubeEnvironmentsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, name string) (result web.KubeEnvironmentsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.KubeEnvironment, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.KubeEnvironmentCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.KubeEnvironmentCollectionIterator, err error)
	ListBySubscription(ctx context.Context) (result web.KubeEnvironmentCollectionPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result web.KubeEnvironmentCollectionIterator, err error)
	Update(ctx context.Context, resourceGroupName string, name string, kubeEnvironmentEnvelope web.KubeEnvironmentPatchResource) (result web.KubeEnvironment, err error)
}

var _ KubeEnvironmentsClientAPI = (*web.KubeEnvironmentsClient)(nil)

// ProviderClientAPI contains the set of methods on the ProviderClient type.
type ProviderClientAPI interface {
	GetAvailableStacks(ctx context.Context, osTypeSelected string) (result web.ApplicationStackCollectionPage, err error)
	GetAvailableStacksComplete(ctx context.Context, osTypeSelected string) (result web.ApplicationStackCollectionIterator, err error)
	GetAvailableStacksOnPrem(ctx context.Context, osTypeSelected string) (result web.ApplicationStackCollectionPage, err error)
	GetAvailableStacksOnPremComplete(ctx context.Context, osTypeSelected string) (result web.ApplicationStackCollectionIterator, err error)
	GetFunctionAppStacks(ctx context.Context, stackOsType string) (result web.FunctionAppStackCollectionPage, err error)
	GetFunctionAppStacksComplete(ctx context.Context, stackOsType string) (result web.FunctionAppStackCollectionIterator, err error)
	GetFunctionAppStacksForLocation(ctx context.Context, location string, stackOsType string) (result web.FunctionAppStackCollectionPage, err error)
	GetFunctionAppStacksForLocationComplete(ctx context.Context, location string, stackOsType string) (result web.FunctionAppStackCollectionIterator, err error)
	GetWebAppStacks(ctx context.Context, stackOsType string) (result web.AppStackCollectionPage, err error)
	GetWebAppStacksComplete(ctx context.Context, stackOsType string) (result web.AppStackCollectionIterator, err error)
	GetWebAppStacksForLocation(ctx context.Context, location string, stackOsType string) (result web.AppStackCollectionPage, err error)
	GetWebAppStacksForLocationComplete(ctx context.Context, location string, stackOsType string) (result web.AppStackCollectionIterator, err error)
	ListOperations(ctx context.Context) (result web.CsmOperationCollectionPage, err error)
	ListOperationsComplete(ctx context.Context) (result web.CsmOperationCollectionIterator, err error)
}

var _ ProviderClientAPI = (*web.ProviderClient)(nil)

// RecommendationsClientAPI contains the set of methods on the RecommendationsClient type.
type RecommendationsClientAPI interface {
	DisableAllForHostingEnvironment(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string) (result autorest.Response, err error)
	DisableAllForWebApp(ctx context.Context, resourceGroupName string, siteName string) (result autorest.Response, err error)
	DisableRecommendationForHostingEnvironment(ctx context.Context, resourceGroupName string, environmentName string, name string, hostingEnvironmentName string) (result autorest.Response, err error)
	DisableRecommendationForSite(ctx context.Context, resourceGroupName string, siteName string, name string) (result autorest.Response, err error)
	DisableRecommendationForSubscription(ctx context.Context, name string) (result autorest.Response, err error)
	GetRuleDetailsByHostingEnvironment(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, name string, updateSeen *bool, recommendationID string) (result web.RecommendationRule, err error)
	GetRuleDetailsByWebApp(ctx context.Context, resourceGroupName string, siteName string, name string, updateSeen *bool, recommendationID string) (result web.RecommendationRule, err error)
	List(ctx context.Context, featured *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListComplete(ctx context.Context, featured *bool, filter string) (result web.RecommendationCollectionIterator, err error)
	ListHistoryForHostingEnvironment(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, expiredOnly *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListHistoryForHostingEnvironmentComplete(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, expiredOnly *bool, filter string) (result web.RecommendationCollectionIterator, err error)
	ListHistoryForWebApp(ctx context.Context, resourceGroupName string, siteName string, expiredOnly *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListHistoryForWebAppComplete(ctx context.Context, resourceGroupName string, siteName string, expiredOnly *bool, filter string) (result web.RecommendationCollectionIterator, err error)
	ListRecommendedRulesForHostingEnvironment(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, featured *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListRecommendedRulesForHostingEnvironmentComplete(ctx context.Context, resourceGroupName string, hostingEnvironmentName string, featured *bool, filter string) (result web.RecommendationCollectionIterator, err error)
	ListRecommendedRulesForWebApp(ctx context.Context, resourceGroupName string, siteName string, featured *bool, filter string) (result web.RecommendationCollectionPage, err error)
	ListRecommendedRulesForWebAppComplete(ctx context.Context, resourceGroupName string, siteName string, featured *bool, filter string) (result web.RecommendationCollectionIterator, err error)
	ResetAllFilters(ctx context.Context) (result autorest.Response, err error)
	ResetAllFiltersForHostingEnvironment(ctx context.Context, resourceGroupName string, environmentName string, hostingEnvironmentName string) (result autorest.Response, err error)
	ResetAllFiltersForWebApp(ctx context.Context, resourceGroupName string, siteName string) (result autorest.Response, err error)
}

var _ RecommendationsClientAPI = (*web.RecommendationsClient)(nil)

// ResourceHealthMetadataClientAPI contains the set of methods on the ResourceHealthMetadataClient type.
type ResourceHealthMetadataClientAPI interface {
	GetBySite(ctx context.Context, resourceGroupName string, name string) (result web.ResourceHealthMetadata, err error)
	GetBySiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ResourceHealthMetadata, err error)
	List(ctx context.Context) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.ResourceHealthMetadataCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.ResourceHealthMetadataCollectionIterator, err error)
	ListBySite(ctx context.Context, resourceGroupName string, name string) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListBySiteComplete(ctx context.Context, resourceGroupName string, name string) (result web.ResourceHealthMetadataCollectionIterator, err error)
	ListBySiteSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ResourceHealthMetadataCollectionPage, err error)
	ListBySiteSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ResourceHealthMetadataCollectionIterator, err error)
}

var _ ResourceHealthMetadataClientAPI = (*web.ResourceHealthMetadataClient)(nil)

// StaticSitesClientAPI contains the set of methods on the StaticSitesClient type.
type StaticSitesClientAPI interface {
	ApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper web.PrivateLinkConnectionApprovalRequestResource) (result web.StaticSitesApproveOrRejectPrivateEndpointConnectionFuture, err error)
	CreateOrUpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope web.StaticSiteARMResource) (result web.StaticSitesCreateOrUpdateStaticSiteFuture, err error)
	CreateOrUpdateStaticSiteAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	CreateOrUpdateStaticSiteBuildAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	CreateOrUpdateStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	CreateOrUpdateStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope web.StaticSiteCustomDomainRequestPropertiesARMResource) (result web.StaticSitesCreateOrUpdateStaticSiteCustomDomainFuture, err error)
	CreateOrUpdateStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	CreateUserRolesInvitationLink(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope web.StaticSiteUserInvitationRequestResource) (result web.StaticSiteUserInvitationResponseResource, err error)
	CreateZipDeploymentForStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteZipDeploymentEnvelope web.StaticSiteZipDeploymentARMResource) (result web.StaticSitesCreateZipDeploymentForStaticSiteFuture, err error)
	CreateZipDeploymentForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, staticSiteZipDeploymentEnvelope web.StaticSiteZipDeploymentARMResource) (result web.StaticSitesCreateZipDeploymentForStaticSiteBuildFuture, err error)
	DeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result web.StaticSitesDeletePrivateEndpointConnectionFuture, err error)
	DeleteStaticSite(ctx context.Context, resourceGroupName string, name string) (result web.StaticSitesDeleteStaticSiteFuture, err error)
	DeleteStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StaticSitesDeleteStaticSiteBuildFuture, err error)
	DeleteStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string) (result web.StaticSitesDeleteStaticSiteCustomDomainFuture, err error)
	DeleteStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string) (result autorest.Response, err error)
	DetachStaticSite(ctx context.Context, resourceGroupName string, name string) (result web.StaticSitesDetachStaticSiteFuture, err error)
	DetachUserProvidedFunctionAppFromStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string) (result autorest.Response, err error)
	DetachUserProvidedFunctionAppFromStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string) (result autorest.Response, err error)
	GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result web.RemotePrivateEndpointConnectionARMResource, err error)
	GetPrivateEndpointConnectionList(ctx context.Context, resourceGroupName string, name string) (result web.PrivateEndpointConnectionCollectionPage, err error)
	GetPrivateEndpointConnectionListComplete(ctx context.Context, resourceGroupName string, name string) (result web.PrivateEndpointConnectionCollectionIterator, err error)
	GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string) (result web.PrivateLinkResourcesWrapper, err error)
	GetStaticSite(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteARMResource, err error)
	GetStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StaticSiteBuildARMResource, err error)
	GetStaticSiteBuilds(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteBuildCollectionPage, err error)
	GetStaticSiteBuildsComplete(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteBuildCollectionIterator, err error)
	GetStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string) (result web.StaticSiteCustomDomainOverviewARMResource, err error)
	GetStaticSitesByResourceGroup(ctx context.Context, resourceGroupName string) (result web.StaticSiteCollectionPage, err error)
	GetStaticSitesByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result web.StaticSiteCollectionIterator, err error)
	GetUserProvidedFunctionAppForStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string) (result web.StaticSiteUserProvidedFunctionAppARMResource, err error)
	GetUserProvidedFunctionAppForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string) (result web.StaticSiteUserProvidedFunctionAppARMResource, err error)
	GetUserProvidedFunctionAppsForStaticSite(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteUserProvidedFunctionAppsCollectionPage, err error)
	GetUserProvidedFunctionAppsForStaticSiteComplete(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteUserProvidedFunctionAppsCollectionIterator, err error)
	GetUserProvidedFunctionAppsForStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StaticSiteUserProvidedFunctionAppsCollectionPage, err error)
	GetUserProvidedFunctionAppsForStaticSiteBuildComplete(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StaticSiteUserProvidedFunctionAppsCollectionIterator, err error)
	List(ctx context.Context) (result web.StaticSiteCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.StaticSiteCollectionIterator, err error)
	ListStaticSiteAppSettings(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListStaticSiteBuildAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StringDictionary, err error)
	ListStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StringDictionary, err error)
	ListStaticSiteBuildFunctions(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StaticSiteFunctionOverviewCollectionPage, err error)
	ListStaticSiteBuildFunctionsComplete(ctx context.Context, resourceGroupName string, name string, environmentName string) (result web.StaticSiteFunctionOverviewCollectionIterator, err error)
	ListStaticSiteConfiguredRoles(ctx context.Context, resourceGroupName string, name string) (result web.StringList, err error)
	ListStaticSiteCustomDomains(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteCustomDomainOverviewCollectionPage, err error)
	ListStaticSiteCustomDomainsComplete(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteCustomDomainOverviewCollectionIterator, err error)
	ListStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListStaticSiteFunctions(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteFunctionOverviewCollectionPage, err error)
	ListStaticSiteFunctionsComplete(ctx context.Context, resourceGroupName string, name string) (result web.StaticSiteFunctionOverviewCollectionIterator, err error)
	ListStaticSiteSecrets(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListStaticSiteUsers(ctx context.Context, resourceGroupName string, name string, authprovider string) (result web.StaticSiteUserCollectionPage, err error)
	ListStaticSiteUsersComplete(ctx context.Context, resourceGroupName string, name string, authprovider string) (result web.StaticSiteUserCollectionIterator, err error)
	PreviewWorkflow(ctx context.Context, location string, staticSitesWorkflowPreviewRequest web.StaticSitesWorkflowPreviewRequest) (result web.StaticSitesWorkflowPreview, err error)
	RegisterUserProvidedFunctionAppWithStaticSite(ctx context.Context, resourceGroupName string, name string, functionAppName string, staticSiteUserProvidedFunctionEnvelope web.StaticSiteUserProvidedFunctionAppARMResource, isForced *bool) (result web.StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteFuture, err error)
	RegisterUserProvidedFunctionAppWithStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, environmentName string, functionAppName string, staticSiteUserProvidedFunctionEnvelope web.StaticSiteUserProvidedFunctionAppARMResource, isForced *bool) (result web.StaticSitesRegisterUserProvidedFunctionAppWithStaticSiteBuildFuture, err error)
	ResetStaticSiteAPIKey(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope web.StaticSiteResetPropertiesARMResource) (result autorest.Response, err error)
	UpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope web.StaticSitePatchResource) (result web.StaticSiteARMResource, err error)
	UpdateStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope web.StaticSiteUserARMResource) (result web.StaticSiteUserARMResource, err error)
	ValidateCustomDomainCanBeAddedToStaticSite(ctx context.Context, resourceGroupName string, name string, domainName string, staticSiteCustomDomainRequestPropertiesEnvelope web.StaticSiteCustomDomainRequestPropertiesARMResource) (result web.StaticSitesValidateCustomDomainCanBeAddedToStaticSiteFuture, err error)
}

var _ StaticSitesClientAPI = (*web.StaticSitesClient)(nil)

// AppsClientAPI contains the set of methods on the AppsClient type.
type AppsClientAPI interface {
	AddPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOn) (result web.PremierAddOn, err error)
	AddPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOn, slot string) (result web.PremierAddOn, err error)
	AnalyzeCustomHostname(ctx context.Context, resourceGroupName string, name string, hostName string) (result web.CustomHostnameAnalysisResult, err error)
	AnalyzeCustomHostnameSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result web.CustomHostnameAnalysisResult, err error)
	ApplySlotConfigToProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result autorest.Response, err error)
	ApplySlotConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result autorest.Response, err error)
	ApproveOrRejectPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper web.PrivateLinkConnectionApprovalRequestResource) (result web.AppsApproveOrRejectPrivateEndpointConnectionFuture, err error)
	ApproveOrRejectPrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, privateEndpointWrapper web.PrivateLinkConnectionApprovalRequestResource, slot string) (result web.AppsApproveOrRejectPrivateEndpointConnectionSlotFuture, err error)
	Backup(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest) (result web.BackupItem, err error)
	BackupSlot(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest, slot string) (result web.BackupItem, err error)
	CreateDeployment(ctx context.Context, resourceGroupName string, name string, ID string, deployment web.Deployment) (result web.Deployment, err error)
	CreateDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string, deployment web.Deployment) (result web.Deployment, err error)
	CreateFunction(ctx context.Context, resourceGroupName string, name string, functionName string, functionEnvelope web.FunctionEnvelope) (result web.AppsCreateFunctionFuture, err error)
	CreateInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string, functionEnvelope web.FunctionEnvelope) (result web.AppsCreateInstanceFunctionSlotFuture, err error)
	CreateInstanceMSDeployOperation(ctx context.Context, resourceGroupName string, name string, instanceID string, mSDeploy web.MSDeploy) (result web.AppsCreateInstanceMSDeployOperationFuture, err error)
	CreateInstanceMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string, mSDeploy web.MSDeploy) (result web.AppsCreateInstanceMSDeployOperationSlotFuture, err error)
	CreateMSDeployOperation(ctx context.Context, resourceGroupName string, name string, mSDeploy web.MSDeploy) (result web.AppsCreateMSDeployOperationFuture, err error)
	CreateMSDeployOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, mSDeploy web.MSDeploy) (result web.AppsCreateMSDeployOperationSlotFuture, err error)
	CreateOrUpdate(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.Site) (result web.AppsCreateOrUpdateFuture, err error)
	CreateOrUpdateConfiguration(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource) (result web.SiteConfigResource, err error)
	CreateOrUpdateConfigurationSlot(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource, slot string) (result web.SiteConfigResource, err error)
	CreateOrUpdateDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier) (result web.Identifier, err error)
	CreateOrUpdateDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier, slot string) (result web.Identifier, err error)
	CreateOrUpdateFunctionSecret(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, key web.KeyInfo) (result web.KeyInfo, err error)
	CreateOrUpdateFunctionSecretSlot(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string, key web.KeyInfo) (result web.KeyInfo, err error)
	CreateOrUpdateHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding web.HostNameBinding) (result web.HostNameBinding, err error)
	CreateOrUpdateHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, hostName string, hostNameBinding web.HostNameBinding, slot string) (result web.HostNameBinding, err error)
	CreateOrUpdateHostSecret(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, key web.KeyInfo) (result web.KeyInfo, err error)
	CreateOrUpdateHostSecretSlot(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string, key web.KeyInfo) (result web.KeyInfo, err error)
	CreateOrUpdateHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection) (result web.HybridConnection, err error)
	CreateOrUpdateHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection, slot string) (result web.HybridConnection, err error)
	CreateOrUpdatePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate web.PublicCertificate) (result web.PublicCertificate, err error)
	CreateOrUpdatePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, publicCertificateName string, publicCertificate web.PublicCertificate, slot string) (result web.PublicCertificate, err error)
	CreateOrUpdateRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity) (result web.RelayServiceConnectionEntity, err error)
	CreateOrUpdateRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity, slot string) (result web.RelayServiceConnectionEntity, err error)
	CreateOrUpdateSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.Site, slot string) (result web.AppsCreateOrUpdateSlotFuture, err error)
	CreateOrUpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl) (result web.AppsCreateOrUpdateSourceControlFuture, err error)
	CreateOrUpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl, slot string) (result web.AppsCreateOrUpdateSourceControlSlotFuture, err error)
	CreateOrUpdateSwiftVirtualNetworkConnectionWithCheck(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork) (result web.SwiftVirtualNetwork, err error)
	CreateOrUpdateSwiftVirtualNetworkConnectionWithCheckSlot(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork, slot string) (result web.SwiftVirtualNetwork, err error)
	CreateOrUpdateVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo) (result web.VnetInfo, err error)
	CreateOrUpdateVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	CreateOrUpdateVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway, slot string) (result web.VnetGateway, err error)
	CreateOrUpdateVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo, slot string) (result web.VnetInfo, err error)
	Delete(ctx context.Context, resourceGroupName string, name string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (result autorest.Response, err error)
	DeleteBackup(ctx context.Context, resourceGroupName string, name string, backupID string) (result autorest.Response, err error)
	DeleteBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	DeleteBackupSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result autorest.Response, err error)
	DeleteContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	DeleteContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	DeleteDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result autorest.Response, err error)
	DeleteDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result autorest.Response, err error)
	DeleteDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (result autorest.Response, err error)
	DeleteDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result autorest.Response, err error)
	DeleteFunction(ctx context.Context, resourceGroupName string, name string, functionName string) (result autorest.Response, err error)
	DeleteFunctionSecret(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string) (result autorest.Response, err error)
	DeleteFunctionSecretSlot(ctx context.Context, resourceGroupName string, name string, functionName string, keyName string, slot string) (result autorest.Response, err error)
	DeleteHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result autorest.Response, err error)
	DeleteHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result autorest.Response, err error)
	DeleteHostSecret(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string) (result autorest.Response, err error)
	DeleteHostSecretSlot(ctx context.Context, resourceGroupName string, name string, keyType string, keyName string, slot string) (result autorest.Response, err error)
	DeleteHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result autorest.Response, err error)
	DeleteHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result autorest.Response, err error)
	DeleteInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result autorest.Response, err error)
	DeleteInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result autorest.Response, err error)
	DeleteInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result autorest.Response, err error)
	DeletePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result autorest.Response, err error)
	DeletePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result autorest.Response, err error)
	DeletePrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result web.AppsDeletePrivateEndpointConnectionFuture, err error)
	DeletePrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string) (result web.AppsDeletePrivateEndpointConnectionSlotFuture, err error)
	DeleteProcess(ctx context.Context, resourceGroupName string, name string, processID string) (result autorest.Response, err error)
	DeleteProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result autorest.Response, err error)
	DeletePublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (result autorest.Response, err error)
	DeletePublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (result autorest.Response, err error)
	DeleteRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result autorest.Response, err error)
	DeleteRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result autorest.Response, err error)
	DeleteSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result autorest.Response, err error)
	DeleteSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result autorest.Response, err error)
	DeleteSlot(ctx context.Context, resourceGroupName string, name string, slot string, deleteMetrics *bool, deleteEmptyServerFarm *bool) (result autorest.Response, err error)
	DeleteSourceControl(ctx context.Context, resourceGroupName string, name string, additionalFlags string) (result autorest.Response, err error)
	DeleteSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string, additionalFlags string) (result autorest.Response, err error)
	DeleteSwiftVirtualNetwork(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	DeleteSwiftVirtualNetworkSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	DeleteTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	DeleteTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	DeleteVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result autorest.Response, err error)
	DeleteVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result autorest.Response, err error)
	DiscoverBackup(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest) (result web.RestoreRequest, err error)
	DiscoverBackupSlot(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest, slot string) (result web.RestoreRequest, err error)
	GenerateNewSitePublishingPassword(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	GenerateNewSitePublishingPasswordSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	Get(ctx context.Context, resourceGroupName string, name string) (result web.Site, err error)
	GetAppSettingKeyVaultReference(ctx context.Context, resourceGroupName string, name string, appSettingKey string) (result web.APIKVReference, err error)
	GetAppSettingKeyVaultReferenceSlot(ctx context.Context, resourceGroupName string, name string, appSettingKey string, slot string) (result web.APIKVReference, err error)
	GetAppSettingsKeyVaultReferences(ctx context.Context, resourceGroupName string, name string) (result web.APIKVReferenceCollectionPage, err error)
	GetAppSettingsKeyVaultReferencesComplete(ctx context.Context, resourceGroupName string, name string) (result web.APIKVReferenceCollectionIterator, err error)
	GetAppSettingsKeyVaultReferencesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.APIKVReferenceCollectionPage, err error)
	GetAppSettingsKeyVaultReferencesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.APIKVReferenceCollectionIterator, err error)
	GetAuthSettings(ctx context.Context, resourceGroupName string, name string) (result web.SiteAuthSettings, err error)
	GetAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteAuthSettings, err error)
	GetAuthSettingsV2(ctx context.Context, resourceGroupName string, name string) (result web.SiteAuthSettingsV2, err error)
	GetAuthSettingsV2Slot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteAuthSettingsV2, err error)
	GetBackupConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.BackupRequest, err error)
	GetBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupRequest, err error)
	GetBackupStatus(ctx context.Context, resourceGroupName string, name string, backupID string) (result web.BackupItem, err error)
	GetBackupStatusSlot(ctx context.Context, resourceGroupName string, name string, backupID string, slot string) (result web.BackupItem, err error)
	GetConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigResource, err error)
	GetConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigResource, err error)
	GetConfigurationSnapshot(ctx context.Context, resourceGroupName string, name string, snapshotID string) (result web.SiteConfigResource, err error)
	GetConfigurationSnapshotSlot(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string) (result web.SiteConfigResource, err error)
	GetContainerLogsZip(ctx context.Context, resourceGroupName string, name string) (result web.ReadCloser, err error)
	GetContainerLogsZipSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ReadCloser, err error)
	GetContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.ContinuousWebJob, err error)
	GetContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.ContinuousWebJob, err error)
	GetDeployment(ctx context.Context, resourceGroupName string, name string, ID string) (result web.Deployment, err error)
	GetDeploymentSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result web.Deployment, err error)
	GetDiagnosticLogsConfiguration(ctx context.Context, resourceGroupName string, name string) (result web.SiteLogsConfig, err error)
	GetDiagnosticLogsConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteLogsConfig, err error)
	GetDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string) (result web.Identifier, err error)
	GetDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, slot string) (result web.Identifier, err error)
	GetFtpAllowed(ctx context.Context, resourceGroupName string, name string) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	GetFtpAllowedSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	GetFunction(ctx context.Context, resourceGroupName string, name string, functionName string) (result web.FunctionEnvelope, err error)
	GetFunctionsAdminToken(ctx context.Context, resourceGroupName string, name string) (result web.String, err error)
	GetFunctionsAdminTokenSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.String, err error)
	GetHostNameBinding(ctx context.Context, resourceGroupName string, name string, hostName string) (result web.HostNameBinding, err error)
	GetHostNameBindingSlot(ctx context.Context, resourceGroupName string, name string, slot string, hostName string) (result web.HostNameBinding, err error)
	GetHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string) (result web.HybridConnection, err error)
	GetHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, slot string) (result web.HybridConnection, err error)
	GetInstanceFunctionSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result web.FunctionEnvelope, err error)
	GetInstanceInfo(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.SiteInstanceStatus, err error)
	GetInstanceInfoSlot(ctx context.Context, resourceGroupName string, name string, instanceID string, slot string) (result web.SiteInstanceStatus, err error)
	GetInstanceMSDeployLog(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.MSDeployLog, err error)
	GetInstanceMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.MSDeployLog, err error)
	GetInstanceMsDeployStatus(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.MSDeployStatus, err error)
	GetInstanceMsDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.MSDeployStatus, err error)
	GetInstanceProcess(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessInfo, err error)
	GetInstanceProcessDump(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ReadCloser, err error)
	GetInstanceProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ReadCloser, err error)
	GetInstanceProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, instanceID string) (result web.ProcessModuleInfo, err error)
	GetInstanceProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string, instanceID string) (result web.ProcessModuleInfo, err error)
	GetInstanceProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessInfo, err error)
	GetMigrateMySQLStatus(ctx context.Context, resourceGroupName string, name string) (result web.MigrateMySQLStatus, err error)
	GetMigrateMySQLStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MigrateMySQLStatus, err error)
	GetMSDeployLog(ctx context.Context, resourceGroupName string, name string) (result web.MSDeployLog, err error)
	GetMSDeployLogSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MSDeployLog, err error)
	GetMSDeployStatus(ctx context.Context, resourceGroupName string, name string) (result web.MSDeployStatus, err error)
	GetMSDeployStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.MSDeployStatus, err error)
	GetNetworkTraceOperation(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetNetworkTraceOperationSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTraceOperationSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTraceOperationV2(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetNetworkTraces(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetNetworkTracesSlot(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTracesSlotV2(ctx context.Context, resourceGroupName string, name string, operationID string, slot string) (result web.ListNetworkTrace, err error)
	GetNetworkTracesV2(ctx context.Context, resourceGroupName string, name string, operationID string) (result web.ListNetworkTrace, err error)
	GetPremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string) (result web.PremierAddOn, err error)
	GetPremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, slot string) (result web.PremierAddOn, err error)
	GetPrivateAccess(ctx context.Context, resourceGroupName string, name string) (result web.PrivateAccess, err error)
	GetPrivateAccessSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PrivateAccess, err error)
	GetPrivateEndpointConnection(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result web.RemotePrivateEndpointConnectionARMResource, err error)
	GetPrivateEndpointConnectionList(ctx context.Context, resourceGroupName string, name string) (result web.PrivateEndpointConnectionCollectionPage, err error)
	GetPrivateEndpointConnectionListComplete(ctx context.Context, resourceGroupName string, name string) (result web.PrivateEndpointConnectionCollectionIterator, err error)
	GetPrivateEndpointConnectionListSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PrivateEndpointConnectionCollectionPage, err error)
	GetPrivateEndpointConnectionListSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PrivateEndpointConnectionCollectionIterator, err error)
	GetPrivateEndpointConnectionSlot(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, slot string) (result web.RemotePrivateEndpointConnectionARMResource, err error)
	GetPrivateLinkResources(ctx context.Context, resourceGroupName string, name string) (result web.PrivateLinkResourcesWrapper, err error)
	GetPrivateLinkResourcesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PrivateLinkResourcesWrapper, err error)
	GetProcess(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessInfo, err error)
	GetProcessDump(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ReadCloser, err error)
	GetProcessDumpSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ReadCloser, err error)
	GetProcessModule(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string) (result web.ProcessModuleInfo, err error)
	GetProcessModuleSlot(ctx context.Context, resourceGroupName string, name string, processID string, baseAddress string, slot string) (result web.ProcessModuleInfo, err error)
	GetProcessSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessInfo, err error)
	GetPublicCertificate(ctx context.Context, resourceGroupName string, name string, publicCertificateName string) (result web.PublicCertificate, err error)
	GetPublicCertificateSlot(ctx context.Context, resourceGroupName string, name string, slot string, publicCertificateName string) (result web.PublicCertificate, err error)
	GetRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string) (result web.RelayServiceConnectionEntity, err error)
	GetRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, slot string) (result web.RelayServiceConnectionEntity, err error)
	GetScmAllowed(ctx context.Context, resourceGroupName string, name string) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	GetScmAllowedSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	GetSiteConnectionStringKeyVaultReference(ctx context.Context, resourceGroupName string, name string, connectionStringKey string) (result web.APIKVReference, err error)
	GetSiteConnectionStringKeyVaultReferences(ctx context.Context, resourceGroupName string, name string) (result web.APIKVReferenceCollectionPage, err error)
	GetSiteConnectionStringKeyVaultReferencesComplete(ctx context.Context, resourceGroupName string, name string) (result web.APIKVReferenceCollectionIterator, err error)
	GetSiteConnectionStringKeyVaultReferenceSlot(ctx context.Context, resourceGroupName string, name string, connectionStringKey string, slot string) (result web.APIKVReference, err error)
	GetSiteConnectionStringKeyVaultReferencesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.APIKVReferenceCollectionPage, err error)
	GetSiteConnectionStringKeyVaultReferencesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.APIKVReferenceCollectionIterator, err error)
	GetSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result web.SiteExtensionInfo, err error)
	GetSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result web.SiteExtensionInfo, err error)
	GetSitePhpErrorLogFlag(ctx context.Context, resourceGroupName string, name string) (result web.SitePhpErrorLogFlag, err error)
	GetSitePhpErrorLogFlagSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SitePhpErrorLogFlag, err error)
	GetSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.Site, err error)
	GetSourceControl(ctx context.Context, resourceGroupName string, name string) (result web.SiteSourceControl, err error)
	GetSourceControlSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteSourceControl, err error)
	GetSwiftVirtualNetworkConnection(ctx context.Context, resourceGroupName string, name string) (result web.SwiftVirtualNetwork, err error)
	GetSwiftVirtualNetworkConnectionSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SwiftVirtualNetwork, err error)
	GetTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.TriggeredWebJob, err error)
	GetTriggeredWebJobHistory(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string) (result web.TriggeredJobHistory, err error)
	GetTriggeredWebJobHistorySlot(ctx context.Context, resourceGroupName string, name string, webJobName string, ID string, slot string) (result web.TriggeredJobHistory, err error)
	GetTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.TriggeredWebJob, err error)
	GetVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string) (result web.VnetInfo, err error)
	GetVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string) (result web.VnetGateway, err error)
	GetVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, slot string) (result web.VnetGateway, err error)
	GetVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, slot string) (result web.VnetInfo, err error)
	GetWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.Job, err error)
	GetWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.Job, err error)
	GetWebSiteContainerLogs(ctx context.Context, resourceGroupName string, name string) (result web.ReadCloser, err error)
	GetWebSiteContainerLogsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ReadCloser, err error)
	InstallSiteExtension(ctx context.Context, resourceGroupName string, name string, siteExtensionID string) (result web.AppsInstallSiteExtensionFuture, err error)
	InstallSiteExtensionSlot(ctx context.Context, resourceGroupName string, name string, siteExtensionID string, slot string) (result web.AppsInstallSiteExtensionSlotFuture, err error)
	IsCloneable(ctx context.Context, resourceGroupName string, name string) (result web.SiteCloneability, err error)
	IsCloneableSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteCloneability, err error)
	List(ctx context.Context) (result web.AppCollectionPage, err error)
	ListComplete(ctx context.Context) (result web.AppCollectionIterator, err error)
	ListApplicationSettings(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListApplicationSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.StringDictionary, err error)
	ListAzureStorageAccounts(ctx context.Context, resourceGroupName string, name string) (result web.AzureStoragePropertyDictionaryResource, err error)
	ListAzureStorageAccountsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AzureStoragePropertyDictionaryResource, err error)
	ListBackups(ctx context.Context, resourceGroupName string, name string) (result web.BackupItemCollectionPage, err error)
	ListBackupsComplete(ctx context.Context, resourceGroupName string, name string) (result web.BackupItemCollectionIterator, err error)
	ListBackupsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupItemCollectionPage, err error)
	ListBackupsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupItemCollectionIterator, err error)
	ListBackupStatusSecrets(ctx context.Context, resourceGroupName string, name string, backupID string, request web.BackupRequest) (result web.BackupItem, err error)
	ListBackupStatusSecretsSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request web.BackupRequest, slot string) (result web.BackupItem, err error)
	ListBasicPublishingCredentialsPolicies(ctx context.Context, resourceGroupName string, name string) (result web.PublishingCredentialsPoliciesCollectionPage, err error)
	ListBasicPublishingCredentialsPoliciesComplete(ctx context.Context, resourceGroupName string, name string) (result web.PublishingCredentialsPoliciesCollectionIterator, err error)
	ListBasicPublishingCredentialsPoliciesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PublishingCredentialsPoliciesCollectionPage, err error)
	ListBasicPublishingCredentialsPoliciesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PublishingCredentialsPoliciesCollectionIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string, includeSlots *bool) (result web.AppCollectionPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string, includeSlots *bool) (result web.AppCollectionIterator, err error)
	ListConfigurations(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigResourceCollectionPage, err error)
	ListConfigurationsComplete(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigResourceCollectionIterator, err error)
	ListConfigurationSnapshotInfo(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigurationSnapshotInfoCollectionPage, err error)
	ListConfigurationSnapshotInfoComplete(ctx context.Context, resourceGroupName string, name string) (result web.SiteConfigurationSnapshotInfoCollectionIterator, err error)
	ListConfigurationSnapshotInfoSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigurationSnapshotInfoCollectionPage, err error)
	ListConfigurationSnapshotInfoSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigurationSnapshotInfoCollectionIterator, err error)
	ListConfigurationsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigResourceCollectionPage, err error)
	ListConfigurationsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteConfigResourceCollectionIterator, err error)
	ListConnectionStrings(ctx context.Context, resourceGroupName string, name string) (result web.ConnectionStringDictionary, err error)
	ListConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ConnectionStringDictionary, err error)
	ListContinuousWebJobs(ctx context.Context, resourceGroupName string, name string) (result web.ContinuousWebJobCollectionPage, err error)
	ListContinuousWebJobsComplete(ctx context.Context, resourceGroupName string, name string) (result web.ContinuousWebJobCollectionIterator, err error)
	ListContinuousWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ContinuousWebJobCollectionPage, err error)
	ListContinuousWebJobsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ContinuousWebJobCollectionIterator, err error)
	ListDeploymentLog(ctx context.Context, resourceGroupName string, name string, ID string) (result web.Deployment, err error)
	ListDeploymentLogSlot(ctx context.Context, resourceGroupName string, name string, ID string, slot string) (result web.Deployment, err error)
	ListDeployments(ctx context.Context, resourceGroupName string, name string) (result web.DeploymentCollectionPage, err error)
	ListDeploymentsComplete(ctx context.Context, resourceGroupName string, name string) (result web.DeploymentCollectionIterator, err error)
	ListDeploymentsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.DeploymentCollectionPage, err error)
	ListDeploymentsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.DeploymentCollectionIterator, err error)
	ListDomainOwnershipIdentifiers(ctx context.Context, resourceGroupName string, name string) (result web.IdentifierCollectionPage, err error)
	ListDomainOwnershipIdentifiersComplete(ctx context.Context, resourceGroupName string, name string) (result web.IdentifierCollectionIterator, err error)
	ListDomainOwnershipIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.IdentifierCollectionPage, err error)
	ListDomainOwnershipIdentifiersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.IdentifierCollectionIterator, err error)
	ListFunctionKeys(ctx context.Context, resourceGroupName string, name string, functionName string) (result web.StringDictionary, err error)
	ListFunctionKeysSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result web.StringDictionary, err error)
	ListFunctions(ctx context.Context, resourceGroupName string, name string) (result web.FunctionEnvelopeCollectionPage, err error)
	ListFunctionsComplete(ctx context.Context, resourceGroupName string, name string) (result web.FunctionEnvelopeCollectionIterator, err error)
	ListFunctionSecrets(ctx context.Context, resourceGroupName string, name string, functionName string) (result web.FunctionSecrets, err error)
	ListFunctionSecretsSlot(ctx context.Context, resourceGroupName string, name string, functionName string, slot string) (result web.FunctionSecrets, err error)
	ListHostKeys(ctx context.Context, resourceGroupName string, name string) (result web.HostKeys, err error)
	ListHostKeysSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HostKeys, err error)
	ListHostNameBindings(ctx context.Context, resourceGroupName string, name string) (result web.HostNameBindingCollectionPage, err error)
	ListHostNameBindingsComplete(ctx context.Context, resourceGroupName string, name string) (result web.HostNameBindingCollectionIterator, err error)
	ListHostNameBindingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HostNameBindingCollectionPage, err error)
	ListHostNameBindingsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HostNameBindingCollectionIterator, err error)
	ListHybridConnections(ctx context.Context, resourceGroupName string, name string) (result web.HybridConnection, err error)
	ListHybridConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.HybridConnection, err error)
	ListInstanceFunctionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.FunctionEnvelopeCollectionPage, err error)
	ListInstanceFunctionsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.FunctionEnvelopeCollectionIterator, err error)
	ListInstanceIdentifiers(ctx context.Context, resourceGroupName string, name string) (result web.AppInstanceStatusCollectionPage, err error)
	ListInstanceIdentifiersComplete(ctx context.Context, resourceGroupName string, name string) (result web.AppInstanceStatusCollectionIterator, err error)
	ListInstanceIdentifiersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AppInstanceStatusCollectionPage, err error)
	ListInstanceIdentifiersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AppInstanceStatusCollectionIterator, err error)
	ListInstanceProcesses(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.ProcessInfoCollectionPage, err error)
	ListInstanceProcessesComplete(ctx context.Context, resourceGroupName string, name string, instanceID string) (result web.ProcessInfoCollectionIterator, err error)
	ListInstanceProcessesSlot(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.ProcessInfoCollectionPage, err error)
	ListInstanceProcessesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, instanceID string) (result web.ProcessInfoCollectionIterator, err error)
	ListInstanceProcessModules(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListInstanceProcessModulesComplete(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessModuleInfoCollectionIterator, err error)
	ListInstanceProcessModulesSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListInstanceProcessModulesSlotComplete(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessModuleInfoCollectionIterator, err error)
	ListInstanceProcessThreads(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListInstanceProcessThreadsComplete(ctx context.Context, resourceGroupName string, name string, processID string, instanceID string) (result web.ProcessThreadInfoCollectionIterator, err error)
	ListInstanceProcessThreadsSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListInstanceProcessThreadsSlotComplete(ctx context.Context, resourceGroupName string, name string, processID string, slot string, instanceID string) (result web.ProcessThreadInfoCollectionIterator, err error)
	ListMetadata(ctx context.Context, resourceGroupName string, name string) (result web.StringDictionary, err error)
	ListMetadataSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.StringDictionary, err error)
	ListNetworkFeatures(ctx context.Context, resourceGroupName string, name string, view string) (result web.NetworkFeatures, err error)
	ListNetworkFeaturesSlot(ctx context.Context, resourceGroupName string, name string, view string, slot string) (result web.NetworkFeatures, err error)
	ListPerfMonCounters(ctx context.Context, resourceGroupName string, name string, filter string) (result web.PerfMonCounterCollectionPage, err error)
	ListPerfMonCountersComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result web.PerfMonCounterCollectionIterator, err error)
	ListPerfMonCountersSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.PerfMonCounterCollectionPage, err error)
	ListPerfMonCountersSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.PerfMonCounterCollectionIterator, err error)
	ListPremierAddOns(ctx context.Context, resourceGroupName string, name string) (result web.PremierAddOn, err error)
	ListPremierAddOnsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PremierAddOn, err error)
	ListProcesses(ctx context.Context, resourceGroupName string, name string) (result web.ProcessInfoCollectionPage, err error)
	ListProcessesComplete(ctx context.Context, resourceGroupName string, name string) (result web.ProcessInfoCollectionIterator, err error)
	ListProcessesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ProcessInfoCollectionPage, err error)
	ListProcessesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ProcessInfoCollectionIterator, err error)
	ListProcessModules(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListProcessModulesComplete(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessModuleInfoCollectionIterator, err error)
	ListProcessModulesSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessModuleInfoCollectionPage, err error)
	ListProcessModulesSlotComplete(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessModuleInfoCollectionIterator, err error)
	ListProcessThreads(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListProcessThreadsComplete(ctx context.Context, resourceGroupName string, name string, processID string) (result web.ProcessThreadInfoCollectionIterator, err error)
	ListProcessThreadsSlot(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessThreadInfoCollectionPage, err error)
	ListProcessThreadsSlotComplete(ctx context.Context, resourceGroupName string, name string, processID string, slot string) (result web.ProcessThreadInfoCollectionIterator, err error)
	ListPublicCertificates(ctx context.Context, resourceGroupName string, name string) (result web.PublicCertificateCollectionPage, err error)
	ListPublicCertificatesComplete(ctx context.Context, resourceGroupName string, name string) (result web.PublicCertificateCollectionIterator, err error)
	ListPublicCertificatesSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PublicCertificateCollectionPage, err error)
	ListPublicCertificatesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PublicCertificateCollectionIterator, err error)
	ListPublishingCredentials(ctx context.Context, resourceGroupName string, name string) (result web.AppsListPublishingCredentialsFuture, err error)
	ListPublishingCredentialsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.AppsListPublishingCredentialsSlotFuture, err error)
	ListPublishingProfileXMLWithSecrets(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions web.CsmPublishingProfileOptions) (result web.ReadCloser, err error)
	ListPublishingProfileXMLWithSecretsSlot(ctx context.Context, resourceGroupName string, name string, publishingProfileOptions web.CsmPublishingProfileOptions, slot string) (result web.ReadCloser, err error)
	ListRelayServiceConnections(ctx context.Context, resourceGroupName string, name string) (result web.RelayServiceConnectionEntity, err error)
	ListRelayServiceConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.RelayServiceConnectionEntity, err error)
	ListSiteBackups(ctx context.Context, resourceGroupName string, name string) (result web.BackupItemCollectionPage, err error)
	ListSiteBackupsComplete(ctx context.Context, resourceGroupName string, name string) (result web.BackupItemCollectionIterator, err error)
	ListSiteBackupsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupItemCollectionPage, err error)
	ListSiteBackupsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.BackupItemCollectionIterator, err error)
	ListSiteExtensions(ctx context.Context, resourceGroupName string, name string) (result web.SiteExtensionInfoCollectionPage, err error)
	ListSiteExtensionsComplete(ctx context.Context, resourceGroupName string, name string) (result web.SiteExtensionInfoCollectionIterator, err error)
	ListSiteExtensionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteExtensionInfoCollectionPage, err error)
	ListSiteExtensionsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SiteExtensionInfoCollectionIterator, err error)
	ListSitePushSettings(ctx context.Context, resourceGroupName string, name string) (result web.PushSettings, err error)
	ListSitePushSettingsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.PushSettings, err error)
	ListSlotConfigurationNames(ctx context.Context, resourceGroupName string, name string) (result web.SlotConfigNamesResource, err error)
	ListSlotDifferencesFromProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.SlotDifferenceCollectionPage, err error)
	ListSlotDifferencesFromProductionComplete(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.SlotDifferenceCollectionIterator, err error)
	ListSlotDifferencesSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.SlotDifferenceCollectionPage, err error)
	ListSlotDifferencesSlotComplete(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.SlotDifferenceCollectionIterator, err error)
	ListSlots(ctx context.Context, resourceGroupName string, name string) (result web.AppCollectionPage, err error)
	ListSlotsComplete(ctx context.Context, resourceGroupName string, name string) (result web.AppCollectionIterator, err error)
	ListSnapshots(ctx context.Context, resourceGroupName string, name string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsComplete(ctx context.Context, resourceGroupName string, name string) (result web.SnapshotCollectionIterator, err error)
	ListSnapshotsFromDRSecondary(ctx context.Context, resourceGroupName string, name string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsFromDRSecondaryComplete(ctx context.Context, resourceGroupName string, name string) (result web.SnapshotCollectionIterator, err error)
	ListSnapshotsFromDRSecondarySlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsFromDRSecondarySlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SnapshotCollectionIterator, err error)
	ListSnapshotsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SnapshotCollectionPage, err error)
	ListSnapshotsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.SnapshotCollectionIterator, err error)
	ListSyncFunctionTriggers(ctx context.Context, resourceGroupName string, name string) (result web.FunctionSecrets, err error)
	ListSyncFunctionTriggersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.FunctionSecrets, err error)
	ListSyncStatus(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	ListSyncStatusSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	ListTriggeredWebJobHistory(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.TriggeredJobHistoryCollectionPage, err error)
	ListTriggeredWebJobHistoryComplete(ctx context.Context, resourceGroupName string, name string, webJobName string) (result web.TriggeredJobHistoryCollectionIterator, err error)
	ListTriggeredWebJobHistorySlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.TriggeredJobHistoryCollectionPage, err error)
	ListTriggeredWebJobHistorySlotComplete(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result web.TriggeredJobHistoryCollectionIterator, err error)
	ListTriggeredWebJobs(ctx context.Context, resourceGroupName string, name string) (result web.TriggeredWebJobCollectionPage, err error)
	ListTriggeredWebJobsComplete(ctx context.Context, resourceGroupName string, name string) (result web.TriggeredWebJobCollectionIterator, err error)
	ListTriggeredWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.TriggeredWebJobCollectionPage, err error)
	ListTriggeredWebJobsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.TriggeredWebJobCollectionIterator, err error)
	ListUsages(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListUsagesComplete(ctx context.Context, resourceGroupName string, name string, filter string) (result web.CsmUsageQuotaCollectionIterator, err error)
	ListUsagesSlot(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.CsmUsageQuotaCollectionPage, err error)
	ListUsagesSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string, filter string) (result web.CsmUsageQuotaCollectionIterator, err error)
	ListVnetConnections(ctx context.Context, resourceGroupName string, name string) (result web.ListVnetInfo, err error)
	ListVnetConnectionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.ListVnetInfo, err error)
	ListWebJobs(ctx context.Context, resourceGroupName string, name string) (result web.JobCollectionPage, err error)
	ListWebJobsComplete(ctx context.Context, resourceGroupName string, name string) (result web.JobCollectionIterator, err error)
	ListWebJobsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result web.JobCollectionPage, err error)
	ListWebJobsSlotComplete(ctx context.Context, resourceGroupName string, name string, slot string) (result web.JobCollectionIterator, err error)
	MigrateMySQL(ctx context.Context, resourceGroupName string, name string, migrationRequestEnvelope web.MigrateMySQLRequest) (result web.AppsMigrateMySQLFuture, err error)
	MigrateStorage(ctx context.Context, subscriptionName string, resourceGroupName string, name string, migrationOptions web.StorageMigrationOptions) (result web.AppsMigrateStorageFuture, err error)
	PutPrivateAccessVnet(ctx context.Context, resourceGroupName string, name string, access web.PrivateAccess) (result web.PrivateAccess, err error)
	PutPrivateAccessVnetSlot(ctx context.Context, resourceGroupName string, name string, access web.PrivateAccess, slot string) (result web.PrivateAccess, err error)
	RecoverSiteConfigurationSnapshot(ctx context.Context, resourceGroupName string, name string, snapshotID string) (result autorest.Response, err error)
	RecoverSiteConfigurationSnapshotSlot(ctx context.Context, resourceGroupName string, name string, snapshotID string, slot string) (result autorest.Response, err error)
	ResetProductionSlotConfig(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	ResetSlotConfigurationSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	Restart(ctx context.Context, resourceGroupName string, name string, softRestart *bool, synchronous *bool) (result autorest.Response, err error)
	RestartSlot(ctx context.Context, resourceGroupName string, name string, slot string, softRestart *bool, synchronous *bool) (result autorest.Response, err error)
	Restore(ctx context.Context, resourceGroupName string, name string, backupID string, request web.RestoreRequest) (result web.AppsRestoreFuture, err error)
	RestoreFromBackupBlob(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest) (result web.AppsRestoreFromBackupBlobFuture, err error)
	RestoreFromBackupBlobSlot(ctx context.Context, resourceGroupName string, name string, request web.RestoreRequest, slot string) (result web.AppsRestoreFromBackupBlobSlotFuture, err error)
	RestoreFromDeletedApp(ctx context.Context, resourceGroupName string, name string, restoreRequest web.DeletedAppRestoreRequest) (result web.AppsRestoreFromDeletedAppFuture, err error)
	RestoreFromDeletedAppSlot(ctx context.Context, resourceGroupName string, name string, restoreRequest web.DeletedAppRestoreRequest, slot string) (result web.AppsRestoreFromDeletedAppSlotFuture, err error)
	RestoreSlot(ctx context.Context, resourceGroupName string, name string, backupID string, request web.RestoreRequest, slot string) (result web.AppsRestoreSlotFuture, err error)
	RestoreSnapshot(ctx context.Context, resourceGroupName string, name string, restoreRequest web.SnapshotRestoreRequest) (result web.AppsRestoreSnapshotFuture, err error)
	RestoreSnapshotSlot(ctx context.Context, resourceGroupName string, name string, restoreRequest web.SnapshotRestoreRequest, slot string) (result web.AppsRestoreSnapshotSlotFuture, err error)
	RunTriggeredWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	RunTriggeredWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	Start(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StartContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	StartContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	StartNetworkTrace(ctx context.Context, resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartNetworkTraceFuture, err error)
	StartNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartNetworkTraceSlotFuture, err error)
	StartSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	StartWebSiteNetworkTrace(ctx context.Context, resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.String, err error)
	StartWebSiteNetworkTraceOperation(ctx context.Context, resourceGroupName string, name string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartWebSiteNetworkTraceOperationFuture, err error)
	StartWebSiteNetworkTraceOperationSlot(ctx context.Context, resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.AppsStartWebSiteNetworkTraceOperationSlotFuture, err error)
	StartWebSiteNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string, durationInSeconds *int32, maxFrameLength *int32, sasURL string) (result web.String, err error)
	Stop(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StopContinuousWebJob(ctx context.Context, resourceGroupName string, name string, webJobName string) (result autorest.Response, err error)
	StopContinuousWebJobSlot(ctx context.Context, resourceGroupName string, name string, webJobName string, slot string) (result autorest.Response, err error)
	StopNetworkTrace(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StopNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	StopSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	StopWebSiteNetworkTrace(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	StopWebSiteNetworkTraceSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	SwapSlotSlot(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity, slot string) (result web.AppsSwapSlotSlotFuture, err error)
	SwapSlotWithProduction(ctx context.Context, resourceGroupName string, name string, slotSwapEntity web.CsmSlotEntity) (result web.AppsSwapSlotWithProductionFuture, err error)
	SyncFunctions(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	SyncFunctionsSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	SyncFunctionTriggers(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	SyncFunctionTriggersSlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	SyncRepository(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error)
	SyncRepositorySlot(ctx context.Context, resourceGroupName string, name string, slot string) (result autorest.Response, err error)
	Update(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.SitePatchResource) (result web.Site, err error)
	UpdateApplicationSettings(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary) (result web.StringDictionary, err error)
	UpdateApplicationSettingsSlot(ctx context.Context, resourceGroupName string, name string, appSettings web.StringDictionary, slot string) (result web.StringDictionary, err error)
	UpdateAuthSettings(ctx context.Context, resourceGroupName string, name string, siteAuthSettings web.SiteAuthSettings) (result web.SiteAuthSettings, err error)
	UpdateAuthSettingsSlot(ctx context.Context, resourceGroupName string, name string, siteAuthSettings web.SiteAuthSettings, slot string) (result web.SiteAuthSettings, err error)
	UpdateAuthSettingsV2(ctx context.Context, resourceGroupName string, name string, siteAuthSettingsV2 web.SiteAuthSettingsV2) (result web.SiteAuthSettingsV2, err error)
	UpdateAuthSettingsV2Slot(ctx context.Context, resourceGroupName string, name string, siteAuthSettingsV2 web.SiteAuthSettingsV2, slot string) (result web.SiteAuthSettingsV2, err error)
	UpdateAzureStorageAccounts(ctx context.Context, resourceGroupName string, name string, azureStorageAccounts web.AzureStoragePropertyDictionaryResource) (result web.AzureStoragePropertyDictionaryResource, err error)
	UpdateAzureStorageAccountsSlot(ctx context.Context, resourceGroupName string, name string, azureStorageAccounts web.AzureStoragePropertyDictionaryResource, slot string) (result web.AzureStoragePropertyDictionaryResource, err error)
	UpdateBackupConfiguration(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest) (result web.BackupRequest, err error)
	UpdateBackupConfigurationSlot(ctx context.Context, resourceGroupName string, name string, request web.BackupRequest, slot string) (result web.BackupRequest, err error)
	UpdateConfiguration(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource) (result web.SiteConfigResource, err error)
	UpdateConfigurationSlot(ctx context.Context, resourceGroupName string, name string, siteConfig web.SiteConfigResource, slot string) (result web.SiteConfigResource, err error)
	UpdateConnectionStrings(ctx context.Context, resourceGroupName string, name string, connectionStrings web.ConnectionStringDictionary) (result web.ConnectionStringDictionary, err error)
	UpdateConnectionStringsSlot(ctx context.Context, resourceGroupName string, name string, connectionStrings web.ConnectionStringDictionary, slot string) (result web.ConnectionStringDictionary, err error)
	UpdateDiagnosticLogsConfig(ctx context.Context, resourceGroupName string, name string, siteLogsConfig web.SiteLogsConfig) (result web.SiteLogsConfig, err error)
	UpdateDiagnosticLogsConfigSlot(ctx context.Context, resourceGroupName string, name string, siteLogsConfig web.SiteLogsConfig, slot string) (result web.SiteLogsConfig, err error)
	UpdateDomainOwnershipIdentifier(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier) (result web.Identifier, err error)
	UpdateDomainOwnershipIdentifierSlot(ctx context.Context, resourceGroupName string, name string, domainOwnershipIdentifierName string, domainOwnershipIdentifier web.Identifier, slot string) (result web.Identifier, err error)
	UpdateFtpAllowed(ctx context.Context, resourceGroupName string, name string, csmPublishingAccessPoliciesEntity web.CsmPublishingCredentialsPoliciesEntity) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	UpdateFtpAllowedSlot(ctx context.Context, resourceGroupName string, name string, csmPublishingAccessPoliciesEntity web.CsmPublishingCredentialsPoliciesEntity, slot string) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	UpdateHybridConnection(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection) (result web.HybridConnection, err error)
	UpdateHybridConnectionSlot(ctx context.Context, resourceGroupName string, name string, namespaceName string, relayName string, connectionEnvelope web.HybridConnection, slot string) (result web.HybridConnection, err error)
	UpdateMetadata(ctx context.Context, resourceGroupName string, name string, metadata web.StringDictionary) (result web.StringDictionary, err error)
	UpdateMetadataSlot(ctx context.Context, resourceGroupName string, name string, metadata web.StringDictionary, slot string) (result web.StringDictionary, err error)
	UpdatePremierAddOn(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOnPatchResource) (result web.PremierAddOn, err error)
	UpdatePremierAddOnSlot(ctx context.Context, resourceGroupName string, name string, premierAddOnName string, premierAddOn web.PremierAddOnPatchResource, slot string) (result web.PremierAddOn, err error)
	UpdateRelayServiceConnection(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity) (result web.RelayServiceConnectionEntity, err error)
	UpdateRelayServiceConnectionSlot(ctx context.Context, resourceGroupName string, name string, entityName string, connectionEnvelope web.RelayServiceConnectionEntity, slot string) (result web.RelayServiceConnectionEntity, err error)
	UpdateScmAllowed(ctx context.Context, resourceGroupName string, name string, csmPublishingAccessPoliciesEntity web.CsmPublishingCredentialsPoliciesEntity) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	UpdateScmAllowedSlot(ctx context.Context, resourceGroupName string, name string, csmPublishingAccessPoliciesEntity web.CsmPublishingCredentialsPoliciesEntity, slot string) (result web.CsmPublishingCredentialsPoliciesEntity, err error)
	UpdateSitePushSettings(ctx context.Context, resourceGroupName string, name string, pushSettings web.PushSettings) (result web.PushSettings, err error)
	UpdateSitePushSettingsSlot(ctx context.Context, resourceGroupName string, name string, pushSettings web.PushSettings, slot string) (result web.PushSettings, err error)
	UpdateSlot(ctx context.Context, resourceGroupName string, name string, siteEnvelope web.SitePatchResource, slot string) (result web.Site, err error)
	UpdateSlotConfigurationNames(ctx context.Context, resourceGroupName string, name string, slotConfigNames web.SlotConfigNamesResource) (result web.SlotConfigNamesResource, err error)
	UpdateSourceControl(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl) (result web.SiteSourceControl, err error)
	UpdateSourceControlSlot(ctx context.Context, resourceGroupName string, name string, siteSourceControl web.SiteSourceControl, slot string) (result web.SiteSourceControl, err error)
	UpdateSwiftVirtualNetworkConnectionWithCheck(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork) (result web.SwiftVirtualNetwork, err error)
	UpdateSwiftVirtualNetworkConnectionWithCheckSlot(ctx context.Context, resourceGroupName string, name string, connectionEnvelope web.SwiftVirtualNetwork, slot string) (result web.SwiftVirtualNetwork, err error)
	UpdateVnetConnection(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo) (result web.VnetInfo, err error)
	UpdateVnetConnectionGateway(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway) (result web.VnetGateway, err error)
	UpdateVnetConnectionGatewaySlot(ctx context.Context, resourceGroupName string, name string, vnetName string, gatewayName string, connectionEnvelope web.VnetGateway, slot string) (result web.VnetGateway, err error)
	UpdateVnetConnectionSlot(ctx context.Context, resourceGroupName string, name string, vnetName string, connectionEnvelope web.VnetInfo, slot string) (result web.VnetInfo, err error)
}

var _ AppsClientAPI = (*web.AppsClient)(nil)
