package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSSLCertificateMatchDomainList invokes the cas.DescribeSSLCertificateMatchDomainList API synchronously
func (client *Client) DescribeSSLCertificateMatchDomainList(request *DescribeSSLCertificateMatchDomainListRequest) (response *DescribeSSLCertificateMatchDomainListResponse, err error) {
	response = CreateDescribeSSLCertificateMatchDomainListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSSLCertificateMatchDomainListWithChan invokes the cas.DescribeSSLCertificateMatchDomainList API asynchronously
func (client *Client) DescribeSSLCertificateMatchDomainListWithChan(request *DescribeSSLCertificateMatchDomainListRequest) (<-chan *DescribeSSLCertificateMatchDomainListResponse, <-chan error) {
	responseChan := make(chan *DescribeSSLCertificateMatchDomainListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSSLCertificateMatchDomainList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSSLCertificateMatchDomainListWithCallback invokes the cas.DescribeSSLCertificateMatchDomainList API asynchronously
func (client *Client) DescribeSSLCertificateMatchDomainListWithCallback(request *DescribeSSLCertificateMatchDomainListRequest, callback func(response *DescribeSSLCertificateMatchDomainListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSSLCertificateMatchDomainListResponse
		var err error
		defer close(result)
		response, err = client.DescribeSSLCertificateMatchDomainList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSSLCertificateMatchDomainListRequest is the request struct for api DescribeSSLCertificateMatchDomainList
type DescribeSSLCertificateMatchDomainListRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	ShowSize    requests.Integer `position:"Query" name:"ShowSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Domain      string           `position:"Query" name:"Domain"`
}

// DescribeSSLCertificateMatchDomainListResponse is the response struct for api DescribeSSLCertificateMatchDomainList
type DescribeSSLCertificateMatchDomainListResponse struct {
	*responses.BaseResponse
	RequestId    string            `json:"RequestId" xml:"RequestId"`
	TotalCount   int               `json:"TotalCount" xml:"TotalCount"`
	ShowSize     int               `json:"ShowSize" xml:"ShowSize"`
	CurrentPage  int               `json:"CurrentPage" xml:"CurrentPage"`
	PageCount    int               `json:"PageCount" xml:"PageCount"`
	CertMetaList []CertificateInfo `json:"CertMetaList" xml:"CertMetaList"`
}

// CreateDescribeSSLCertificateMatchDomainListRequest creates a request to invoke DescribeSSLCertificateMatchDomainList API
func CreateDescribeSSLCertificateMatchDomainListRequest() (request *DescribeSSLCertificateMatchDomainListRequest) {
	request = &DescribeSSLCertificateMatchDomainListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-06-19", "DescribeSSLCertificateMatchDomainList", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSSLCertificateMatchDomainListResponse creates a response to parse from DescribeSSLCertificateMatchDomainList response
func CreateDescribeSSLCertificateMatchDomainListResponse() (response *DescribeSSLCertificateMatchDomainListResponse) {
	response = &DescribeSSLCertificateMatchDomainListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
