package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnConfigGroupDetail invokes the dcdn.DescribeDcdnConfigGroupDetail API synchronously
func (client *Client) DescribeDcdnConfigGroupDetail(request *DescribeDcdnConfigGroupDetailRequest) (response *DescribeDcdnConfigGroupDetailResponse, err error) {
	response = CreateDescribeDcdnConfigGroupDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnConfigGroupDetailWithChan invokes the dcdn.DescribeDcdnConfigGroupDetail API asynchronously
func (client *Client) DescribeDcdnConfigGroupDetailWithChan(request *DescribeDcdnConfigGroupDetailRequest) (<-chan *DescribeDcdnConfigGroupDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnConfigGroupDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnConfigGroupDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnConfigGroupDetailWithCallback invokes the dcdn.DescribeDcdnConfigGroupDetail API asynchronously
func (client *Client) DescribeDcdnConfigGroupDetailWithCallback(request *DescribeDcdnConfigGroupDetailRequest, callback func(response *DescribeDcdnConfigGroupDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnConfigGroupDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnConfigGroupDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnConfigGroupDetailRequest is the request struct for api DescribeDcdnConfigGroupDetail
type DescribeDcdnConfigGroupDetailRequest struct {
	*requests.RpcRequest
	ConfigGroupName string           `position:"Query" name:"ConfigGroupName"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	ConfigGroupId   string           `position:"Query" name:"ConfigGroupId"`
}

// DescribeDcdnConfigGroupDetailResponse is the response struct for api DescribeDcdnConfigGroupDetail
type DescribeDcdnConfigGroupDetailResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ConfigGroupId   string `json:"ConfigGroupId" xml:"ConfigGroupId"`
	ConfigGroupName string `json:"ConfigGroupName" xml:"ConfigGroupName"`
	Description     string `json:"Description" xml:"Description"`
	BizName         string `json:"BizName" xml:"BizName"`
	CreateTime      string `json:"CreateTime" xml:"CreateTime"`
	UpdateTime      string `json:"UpdateTime" xml:"UpdateTime"`
}

// CreateDescribeDcdnConfigGroupDetailRequest creates a request to invoke DescribeDcdnConfigGroupDetail API
func CreateDescribeDcdnConfigGroupDetailRequest() (request *DescribeDcdnConfigGroupDetailRequest) {
	request = &DescribeDcdnConfigGroupDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnConfigGroupDetail", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnConfigGroupDetailResponse creates a response to parse from DescribeDcdnConfigGroupDetail response
func CreateDescribeDcdnConfigGroupDetailResponse() (response *DescribeDcdnConfigGroupDetailResponse) {
	response = &DescribeDcdnConfigGroupDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
