package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopEpnInstance invokes the ens.StopEpnInstance API synchronously
func (client *Client) StopEpnInstance(request *StopEpnInstanceRequest) (response *StopEpnInstanceResponse, err error) {
	response = CreateStopEpnInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// StopEpnInstanceWithChan invokes the ens.StopEpnInstance API asynchronously
func (client *Client) StopEpnInstanceWithChan(request *StopEpnInstanceRequest) (<-chan *StopEpnInstanceResponse, <-chan error) {
	responseChan := make(chan *StopEpnInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopEpnInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopEpnInstanceWithCallback invokes the ens.StopEpnInstance API asynchronously
func (client *Client) StopEpnInstanceWithCallback(request *StopEpnInstanceRequest, callback func(response *StopEpnInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopEpnInstanceResponse
		var err error
		defer close(result)
		response, err = client.StopEpnInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopEpnInstanceRequest is the request struct for api StopEpnInstance
type StopEpnInstanceRequest struct {
	*requests.RpcRequest
	EPNInstanceId string `position:"Query" name:"EPNInstanceId"`
}

// StopEpnInstanceResponse is the response struct for api StopEpnInstance
type StopEpnInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopEpnInstanceRequest creates a request to invoke StopEpnInstance API
func CreateStopEpnInstanceRequest() (request *StopEpnInstanceRequest) {
	request = &StopEpnInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "StopEpnInstance", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopEpnInstanceResponse creates a response to parse from StopEpnInstance response
func CreateStopEpnInstanceResponse() (response *StopEpnInstanceResponse) {
	response = &StopEpnInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
