package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindJoinPermissionToNodeGroup invokes the linkwan.BindJoinPermissionToNodeGroup API synchronously
func (client *Client) BindJoinPermissionToNodeGroup(request *BindJoinPermissionToNodeGroupRequest) (response *BindJoinPermissionToNodeGroupResponse, err error) {
	response = CreateBindJoinPermissionToNodeGroupResponse()
	err = client.DoAction(request, response)
	return
}

// BindJoinPermissionToNodeGroupWithChan invokes the linkwan.BindJoinPermissionToNodeGroup API asynchronously
func (client *Client) BindJoinPermissionToNodeGroupWithChan(request *BindJoinPermissionToNodeGroupRequest) (<-chan *BindJoinPermissionToNodeGroupResponse, <-chan error) {
	responseChan := make(chan *BindJoinPermissionToNodeGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindJoinPermissionToNodeGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindJoinPermissionToNodeGroupWithCallback invokes the linkwan.BindJoinPermissionToNodeGroup API asynchronously
func (client *Client) BindJoinPermissionToNodeGroupWithCallback(request *BindJoinPermissionToNodeGroupRequest, callback func(response *BindJoinPermissionToNodeGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindJoinPermissionToNodeGroupResponse
		var err error
		defer close(result)
		response, err = client.BindJoinPermissionToNodeGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindJoinPermissionToNodeGroupRequest is the request struct for api BindJoinPermissionToNodeGroup
type BindJoinPermissionToNodeGroupRequest struct {
	*requests.RpcRequest
	JoinPermissionId string `position:"Query" name:"JoinPermissionId"`
	NodeGroupId      string `position:"Query" name:"NodeGroupId"`
	ApiProduct       string `position:"Body" name:"ApiProduct"`
	ApiRevision      string `position:"Body" name:"ApiRevision"`
}

// BindJoinPermissionToNodeGroupResponse is the response struct for api BindJoinPermissionToNodeGroup
type BindJoinPermissionToNodeGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBindJoinPermissionToNodeGroupRequest creates a request to invoke BindJoinPermissionToNodeGroup API
func CreateBindJoinPermissionToNodeGroupRequest() (request *BindJoinPermissionToNodeGroupRequest) {
	request = &BindJoinPermissionToNodeGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "BindJoinPermissionToNodeGroup", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindJoinPermissionToNodeGroupResponse creates a response to parse from BindJoinPermissionToNodeGroup response
func CreateBindJoinPermissionToNodeGroupResponse() (response *BindJoinPermissionToNodeGroupResponse) {
	response = &BindJoinPermissionToNodeGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
