[![License](https://img.shields.io/badge/License-GPL%20v2-blue.svg)](https://gitlab.xfce.org/apps/xfdashboard/-/blob/master/COPYING)

# xfdashboard

Xfdashboard is maybe a Gnome shell and macOS Expose like dashboard for Xfce.

**Xfdashboard** provides a GNOME shell dashboard and macOS Mission Control
(e.g. Exposé and Spaces) like interface for use with the Xfce desktop. It can
be configured to run with any keyboard shortcut and when executed provides an
overview of applications currently open enabling the user to switch between
different applications. The search feature works like Xfce's app finder which
makes it convenient to search for and start applications.

----

### Homepage

[Xfdashboard documentation](https://docs.xfce.org/apps/xfdashboard/start)

### Changelog

See [NEWS](https://gitlab.xfce.org/apps/xfdashboard/-/blob/master/NEWS) for details on changes and fixes made in the current release.

### Source Code Repository

[xfdashboard source code](https://gitlab.xfce.org/apps/xfdashboard)

### Download a Release Tarball

[Xfdashboard archive](https://archive.xfce.org/src/apps/xfdashboard)
    or
[Xfdashboard tags](https://gitlab.xfce.org/apps/xfdashboard/-/tags)

### Installation

From source code repository: 

    % cd xfdashboard
    % meson setup build
    % meson compile -C build
    % meson install -C build

From release tarball:

    % tar xf xfdashboard-<version>.tar.bz2
    % cd xfdashboard-<version>
    % meson setup build
    % meson compile -C build
    % meson install -C build

### Uninstallation

From source code repository and release tarball:

    % ninja uninstall -C build

### Reporting Bugs

Visit the [reporting bugs](https://docs.xfce.org/apps/xfdashboard/bugs) page to view currently open bug reports and instructions on reporting new bugs or submitting bugfixes.
