// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Safe API
//
// APIs for using Oracle Data Safe.
//

package datasafe

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ScimQuerySelectionMode Indicates that the selection is a scimQuery.
type ScimQuerySelectionMode struct {

	// The scimQuery query parameter accepts filter expressions that use the syntax described in Section 3.2.2.2
	// of the System for Cross-Domain Identity Management (SCIM) specification, which is available
	// at RFC3339 (https://tools.ietf.org/html/draft-ietf-scim-api-12). In SCIM filtering expressions,
	// text, date, and time values must be enclosed in quotation marks, with date and time values using ISO-8601 format.
	// (Numeric and boolean values should not be quoted.)
	// **Example:** query=(dbUserName eq "PAY_APP")
	ScimQuery *string `mandatory:"true" json:"scimQuery"`
}

func (m ScimQuerySelectionMode) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ScimQuerySelectionMode) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m ScimQuerySelectionMode) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeScimQuerySelectionMode ScimQuerySelectionMode
	s := struct {
		DiscriminatorParam string `json:"selectionMode"`
		MarshalTypeScimQuerySelectionMode
	}{
		"SCIM_QUERY",
		(MarshalTypeScimQuerySelectionMode)(m),
	}

	return json.Marshal(&s)
}
