//go:build go1.9
// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/eng/tools/profileBuilder

package compute

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/compute/mgmt/2022-08-01/compute"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AccessLevel = original.AccessLevel

const (
	None  AccessLevel = original.None
	Read  AccessLevel = original.Read
	Write AccessLevel = original.Write
)

type AggregatedReplicationState = original.AggregatedReplicationState

const (
	Completed  AggregatedReplicationState = original.Completed
	Failed     AggregatedReplicationState = original.Failed
	InProgress AggregatedReplicationState = original.InProgress
	Unknown    AggregatedReplicationState = original.Unknown
)

type Architecture = original.Architecture

const (
	Arm64 Architecture = original.Arm64
	X64   Architecture = original.X64
)

type ArchitectureTypes = original.ArchitectureTypes

const (
	ArchitectureTypesArm64 ArchitectureTypes = original.ArchitectureTypesArm64
	ArchitectureTypesX64   ArchitectureTypes = original.ArchitectureTypesX64
)

type AvailabilitySetSkuTypes = original.AvailabilitySetSkuTypes

const (
	Aligned AvailabilitySetSkuTypes = original.Aligned
	Classic AvailabilitySetSkuTypes = original.Classic
)

type CachingTypes = original.CachingTypes

const (
	CachingTypesNone      CachingTypes = original.CachingTypesNone
	CachingTypesReadOnly  CachingTypes = original.CachingTypesReadOnly
	CachingTypesReadWrite CachingTypes = original.CachingTypesReadWrite
)

type CapacityReservationGroupInstanceViewTypes = original.CapacityReservationGroupInstanceViewTypes

const (
	InstanceView CapacityReservationGroupInstanceViewTypes = original.InstanceView
)

type CapacityReservationInstanceViewTypes = original.CapacityReservationInstanceViewTypes

const (
	CapacityReservationInstanceViewTypesInstanceView CapacityReservationInstanceViewTypes = original.CapacityReservationInstanceViewTypesInstanceView
)

type CloudServiceSlotType = original.CloudServiceSlotType

const (
	Production CloudServiceSlotType = original.Production
	Staging    CloudServiceSlotType = original.Staging
)

type CloudServiceUpgradeMode = original.CloudServiceUpgradeMode

const (
	Auto         CloudServiceUpgradeMode = original.Auto
	Manual       CloudServiceUpgradeMode = original.Manual
	Simultaneous CloudServiceUpgradeMode = original.Simultaneous
)

type ComponentNames = original.ComponentNames

const (
	MicrosoftWindowsShellSetup ComponentNames = original.MicrosoftWindowsShellSetup
)

type ConfidentialVMEncryptionType = original.ConfidentialVMEncryptionType

const (
	EncryptedVMGuestStateOnlyWithPmk ConfidentialVMEncryptionType = original.EncryptedVMGuestStateOnlyWithPmk
	EncryptedWithCmk                 ConfidentialVMEncryptionType = original.EncryptedWithCmk
	EncryptedWithPmk                 ConfidentialVMEncryptionType = original.EncryptedWithPmk
)

type ConsistencyModeTypes = original.ConsistencyModeTypes

const (
	ApplicationConsistent ConsistencyModeTypes = original.ApplicationConsistent
	CrashConsistent       ConsistencyModeTypes = original.CrashConsistent
	FileSystemConsistent  ConsistencyModeTypes = original.FileSystemConsistent
)

type DataAccessAuthMode = original.DataAccessAuthMode

const (
	DataAccessAuthModeAzureActiveDirectory DataAccessAuthMode = original.DataAccessAuthModeAzureActiveDirectory
	DataAccessAuthModeNone                 DataAccessAuthMode = original.DataAccessAuthModeNone
)

type DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypes

const (
	DedicatedHostLicenseTypesNone                   DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypesNone
	DedicatedHostLicenseTypesWindowsServerHybrid    DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypesWindowsServerHybrid
	DedicatedHostLicenseTypesWindowsServerPerpetual DedicatedHostLicenseTypes = original.DedicatedHostLicenseTypesWindowsServerPerpetual
)

type DeleteOptions = original.DeleteOptions

const (
	Delete DeleteOptions = original.Delete
	Detach DeleteOptions = original.Detach
)

type DiffDiskOptions = original.DiffDiskOptions

const (
	Local DiffDiskOptions = original.Local
)

type DiffDiskPlacement = original.DiffDiskPlacement

const (
	CacheDisk    DiffDiskPlacement = original.CacheDisk
	ResourceDisk DiffDiskPlacement = original.ResourceDisk
)

type DiskControllerTypes = original.DiskControllerTypes

const (
	NVMe DiskControllerTypes = original.NVMe
	SCSI DiskControllerTypes = original.SCSI
)

type DiskCreateOption = original.DiskCreateOption

const (
	Attach               DiskCreateOption = original.Attach
	Copy                 DiskCreateOption = original.Copy
	CopyStart            DiskCreateOption = original.CopyStart
	Empty                DiskCreateOption = original.Empty
	FromImage            DiskCreateOption = original.FromImage
	Import               DiskCreateOption = original.Import
	ImportSecure         DiskCreateOption = original.ImportSecure
	Restore              DiskCreateOption = original.Restore
	Upload               DiskCreateOption = original.Upload
	UploadPreparedSecure DiskCreateOption = original.UploadPreparedSecure
)

type DiskCreateOptionTypes = original.DiskCreateOptionTypes

const (
	DiskCreateOptionTypesAttach    DiskCreateOptionTypes = original.DiskCreateOptionTypesAttach
	DiskCreateOptionTypesEmpty     DiskCreateOptionTypes = original.DiskCreateOptionTypesEmpty
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = original.DiskCreateOptionTypesFromImage
)

type DiskDeleteOptionTypes = original.DiskDeleteOptionTypes

const (
	DiskDeleteOptionTypesDelete DiskDeleteOptionTypes = original.DiskDeleteOptionTypesDelete
	DiskDeleteOptionTypesDetach DiskDeleteOptionTypes = original.DiskDeleteOptionTypesDetach
)

type DiskDetachOptionTypes = original.DiskDetachOptionTypes

const (
	ForceDetach DiskDetachOptionTypes = original.ForceDetach
)

type DiskEncryptionSetIdentityType = original.DiskEncryptionSetIdentityType

const (
	DiskEncryptionSetIdentityTypeNone                       DiskEncryptionSetIdentityType = original.DiskEncryptionSetIdentityTypeNone
	DiskEncryptionSetIdentityTypeSystemAssigned             DiskEncryptionSetIdentityType = original.DiskEncryptionSetIdentityTypeSystemAssigned
	DiskEncryptionSetIdentityTypeSystemAssignedUserAssigned DiskEncryptionSetIdentityType = original.DiskEncryptionSetIdentityTypeSystemAssignedUserAssigned
	DiskEncryptionSetIdentityTypeUserAssigned               DiskEncryptionSetIdentityType = original.DiskEncryptionSetIdentityTypeUserAssigned
)

type DiskEncryptionSetType = original.DiskEncryptionSetType

const (
	ConfidentialVMEncryptedWithCustomerKey      DiskEncryptionSetType = original.ConfidentialVMEncryptedWithCustomerKey
	EncryptionAtRestWithCustomerKey             DiskEncryptionSetType = original.EncryptionAtRestWithCustomerKey
	EncryptionAtRestWithPlatformAndCustomerKeys DiskEncryptionSetType = original.EncryptionAtRestWithPlatformAndCustomerKeys
)

type DiskSecurityTypes = original.DiskSecurityTypes

const (
	ConfidentialVMDiskEncryptedWithCustomerKey             DiskSecurityTypes = original.ConfidentialVMDiskEncryptedWithCustomerKey
	ConfidentialVMDiskEncryptedWithPlatformKey             DiskSecurityTypes = original.ConfidentialVMDiskEncryptedWithPlatformKey
	ConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey DiskSecurityTypes = original.ConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey
	TrustedLaunch                                          DiskSecurityTypes = original.TrustedLaunch
)

type DiskState = original.DiskState

const (
	ActiveSAS       DiskState = original.ActiveSAS
	ActiveSASFrozen DiskState = original.ActiveSASFrozen
	ActiveUpload    DiskState = original.ActiveUpload
	Attached        DiskState = original.Attached
	Frozen          DiskState = original.Frozen
	ReadyToUpload   DiskState = original.ReadyToUpload
	Reserved        DiskState = original.Reserved
	Unattached      DiskState = original.Unattached
)

type DiskStorageAccountTypes = original.DiskStorageAccountTypes

const (
	PremiumLRS     DiskStorageAccountTypes = original.PremiumLRS
	PremiumV2LRS   DiskStorageAccountTypes = original.PremiumV2LRS
	PremiumZRS     DiskStorageAccountTypes = original.PremiumZRS
	StandardLRS    DiskStorageAccountTypes = original.StandardLRS
	StandardSSDLRS DiskStorageAccountTypes = original.StandardSSDLRS
	StandardSSDZRS DiskStorageAccountTypes = original.StandardSSDZRS
	UltraSSDLRS    DiskStorageAccountTypes = original.UltraSSDLRS
)

type EncryptionType = original.EncryptionType

const (
	EncryptionTypeEncryptionAtRestWithCustomerKey             EncryptionType = original.EncryptionTypeEncryptionAtRestWithCustomerKey
	EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys EncryptionType = original.EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys
	EncryptionTypeEncryptionAtRestWithPlatformKey             EncryptionType = original.EncryptionTypeEncryptionAtRestWithPlatformKey
)

type ExecutionState = original.ExecutionState

const (
	ExecutionStateCanceled  ExecutionState = original.ExecutionStateCanceled
	ExecutionStateFailed    ExecutionState = original.ExecutionStateFailed
	ExecutionStatePending   ExecutionState = original.ExecutionStatePending
	ExecutionStateRunning   ExecutionState = original.ExecutionStateRunning
	ExecutionStateSucceeded ExecutionState = original.ExecutionStateSucceeded
	ExecutionStateTimedOut  ExecutionState = original.ExecutionStateTimedOut
	ExecutionStateUnknown   ExecutionState = original.ExecutionStateUnknown
)

type ExpandTypesForGetCapacityReservationGroups = original.ExpandTypesForGetCapacityReservationGroups

const (
	VirtualMachineScaleSetVMsref ExpandTypesForGetCapacityReservationGroups = original.VirtualMachineScaleSetVMsref
	VirtualMachinesref           ExpandTypesForGetCapacityReservationGroups = original.VirtualMachinesref
)

type ExpandTypesForGetVMScaleSets = original.ExpandTypesForGetVMScaleSets

const (
	UserData ExpandTypesForGetVMScaleSets = original.UserData
)

type ExtendedLocationType = original.ExtendedLocationType

const (
	EdgeZone ExtendedLocationType = original.EdgeZone
)

type ExtendedLocationTypes = original.ExtendedLocationTypes

const (
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = original.ExtendedLocationTypesEdgeZone
)

type GalleryExpandParams = original.GalleryExpandParams

const (
	SharingProfileGroups GalleryExpandParams = original.SharingProfileGroups
)

type GalleryExtendedLocationType = original.GalleryExtendedLocationType

const (
	GalleryExtendedLocationTypeEdgeZone GalleryExtendedLocationType = original.GalleryExtendedLocationTypeEdgeZone
	GalleryExtendedLocationTypeUnknown  GalleryExtendedLocationType = original.GalleryExtendedLocationTypeUnknown
)

type GalleryProvisioningState = original.GalleryProvisioningState

const (
	GalleryProvisioningStateCreating  GalleryProvisioningState = original.GalleryProvisioningStateCreating
	GalleryProvisioningStateDeleting  GalleryProvisioningState = original.GalleryProvisioningStateDeleting
	GalleryProvisioningStateFailed    GalleryProvisioningState = original.GalleryProvisioningStateFailed
	GalleryProvisioningStateMigrating GalleryProvisioningState = original.GalleryProvisioningStateMigrating
	GalleryProvisioningStateSucceeded GalleryProvisioningState = original.GalleryProvisioningStateSucceeded
	GalleryProvisioningStateUpdating  GalleryProvisioningState = original.GalleryProvisioningStateUpdating
)

type GallerySharingPermissionTypes = original.GallerySharingPermissionTypes

const (
	Community GallerySharingPermissionTypes = original.Community
	Groups    GallerySharingPermissionTypes = original.Groups
	Private   GallerySharingPermissionTypes = original.Private
)

type HostCaching = original.HostCaching

const (
	HostCachingNone      HostCaching = original.HostCachingNone
	HostCachingReadOnly  HostCaching = original.HostCachingReadOnly
	HostCachingReadWrite HostCaching = original.HostCachingReadWrite
)

type HyperVGeneration = original.HyperVGeneration

const (
	V1 HyperVGeneration = original.V1
	V2 HyperVGeneration = original.V2
)

type HyperVGenerationType = original.HyperVGenerationType

const (
	HyperVGenerationTypeV1 HyperVGenerationType = original.HyperVGenerationTypeV1
	HyperVGenerationTypeV2 HyperVGenerationType = original.HyperVGenerationTypeV2
)

type HyperVGenerationTypes = original.HyperVGenerationTypes

const (
	HyperVGenerationTypesV1 HyperVGenerationTypes = original.HyperVGenerationTypesV1
	HyperVGenerationTypesV2 HyperVGenerationTypes = original.HyperVGenerationTypesV2
)

type IPVersion = original.IPVersion

const (
	IPv4 IPVersion = original.IPv4
	IPv6 IPVersion = original.IPv6
)

type IPVersions = original.IPVersions

const (
	IPVersionsIPv4 IPVersions = original.IPVersionsIPv4
	IPVersionsIPv6 IPVersions = original.IPVersionsIPv6
)

type InstanceViewTypes = original.InstanceViewTypes

const (
	InstanceViewTypesInstanceView InstanceViewTypes = original.InstanceViewTypesInstanceView
	InstanceViewTypesUserData     InstanceViewTypes = original.InstanceViewTypesUserData
)

type IntervalInMins = original.IntervalInMins

const (
	FiveMins   IntervalInMins = original.FiveMins
	SixtyMins  IntervalInMins = original.SixtyMins
	ThirtyMins IntervalInMins = original.ThirtyMins
	ThreeMins  IntervalInMins = original.ThreeMins
)

type LinuxPatchAssessmentMode = original.LinuxPatchAssessmentMode

const (
	AutomaticByPlatform LinuxPatchAssessmentMode = original.AutomaticByPlatform
	ImageDefault        LinuxPatchAssessmentMode = original.ImageDefault
)

type LinuxVMGuestPatchAutomaticByPlatformRebootSetting = original.LinuxVMGuestPatchAutomaticByPlatformRebootSetting

const (
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingAlways     LinuxVMGuestPatchAutomaticByPlatformRebootSetting = original.LinuxVMGuestPatchAutomaticByPlatformRebootSettingAlways
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingIfRequired LinuxVMGuestPatchAutomaticByPlatformRebootSetting = original.LinuxVMGuestPatchAutomaticByPlatformRebootSettingIfRequired
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever      LinuxVMGuestPatchAutomaticByPlatformRebootSetting = original.LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingUnknown    LinuxVMGuestPatchAutomaticByPlatformRebootSetting = original.LinuxVMGuestPatchAutomaticByPlatformRebootSettingUnknown
)

type LinuxVMGuestPatchMode = original.LinuxVMGuestPatchMode

const (
	LinuxVMGuestPatchModeAutomaticByPlatform LinuxVMGuestPatchMode = original.LinuxVMGuestPatchModeAutomaticByPlatform
	LinuxVMGuestPatchModeImageDefault        LinuxVMGuestPatchMode = original.LinuxVMGuestPatchModeImageDefault
)

type MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypes

const (
	MaintenanceOperationResultCodeTypesMaintenanceAborted   MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesMaintenanceAborted
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesMaintenanceCompleted
	MaintenanceOperationResultCodeTypesNone                 MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesNone
	MaintenanceOperationResultCodeTypesRetryLater           MaintenanceOperationResultCodeTypes = original.MaintenanceOperationResultCodeTypesRetryLater
)

type NetworkAPIVersion = original.NetworkAPIVersion

const (
	TwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne NetworkAPIVersion = original.TwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne
)

type NetworkAccessPolicy = original.NetworkAccessPolicy

const (
	AllowAll     NetworkAccessPolicy = original.AllowAll
	AllowPrivate NetworkAccessPolicy = original.AllowPrivate
	DenyAll      NetworkAccessPolicy = original.DenyAll
)

type OperatingSystemStateTypes = original.OperatingSystemStateTypes

const (
	Generalized OperatingSystemStateTypes = original.Generalized
	Specialized OperatingSystemStateTypes = original.Specialized
)

type OperatingSystemType = original.OperatingSystemType

const (
	Linux   OperatingSystemType = original.Linux
	Windows OperatingSystemType = original.Windows
)

type OperatingSystemTypes = original.OperatingSystemTypes

const (
	OperatingSystemTypesLinux   OperatingSystemTypes = original.OperatingSystemTypesLinux
	OperatingSystemTypesWindows OperatingSystemTypes = original.OperatingSystemTypesWindows
)

type OrchestrationMode = original.OrchestrationMode

const (
	Flexible OrchestrationMode = original.Flexible
	Uniform  OrchestrationMode = original.Uniform
)

type OrchestrationServiceNames = original.OrchestrationServiceNames

const (
	AutomaticRepairs OrchestrationServiceNames = original.AutomaticRepairs
)

type OrchestrationServiceState = original.OrchestrationServiceState

const (
	NotRunning OrchestrationServiceState = original.NotRunning
	Running    OrchestrationServiceState = original.Running
	Suspended  OrchestrationServiceState = original.Suspended
)

type OrchestrationServiceStateAction = original.OrchestrationServiceStateAction

const (
	Resume  OrchestrationServiceStateAction = original.Resume
	Suspend OrchestrationServiceStateAction = original.Suspend
)

type PassNames = original.PassNames

const (
	OobeSystem PassNames = original.OobeSystem
)

type PatchAssessmentState = original.PatchAssessmentState

const (
	PatchAssessmentStateAvailable PatchAssessmentState = original.PatchAssessmentStateAvailable
	PatchAssessmentStateUnknown   PatchAssessmentState = original.PatchAssessmentStateUnknown
)

type PatchInstallationState = original.PatchInstallationState

const (
	PatchInstallationStateExcluded    PatchInstallationState = original.PatchInstallationStateExcluded
	PatchInstallationStateFailed      PatchInstallationState = original.PatchInstallationStateFailed
	PatchInstallationStateInstalled   PatchInstallationState = original.PatchInstallationStateInstalled
	PatchInstallationStateNotSelected PatchInstallationState = original.PatchInstallationStateNotSelected
	PatchInstallationStatePending     PatchInstallationState = original.PatchInstallationStatePending
	PatchInstallationStateUnknown     PatchInstallationState = original.PatchInstallationStateUnknown
)

type PatchOperationStatus = original.PatchOperationStatus

const (
	PatchOperationStatusCompletedWithWarnings PatchOperationStatus = original.PatchOperationStatusCompletedWithWarnings
	PatchOperationStatusFailed                PatchOperationStatus = original.PatchOperationStatusFailed
	PatchOperationStatusInProgress            PatchOperationStatus = original.PatchOperationStatusInProgress
	PatchOperationStatusSucceeded             PatchOperationStatus = original.PatchOperationStatusSucceeded
	PatchOperationStatusUnknown               PatchOperationStatus = original.PatchOperationStatusUnknown
)

type PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningState

const (
	PrivateEndpointConnectionProvisioningStateCreating  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateCreating
	PrivateEndpointConnectionProvisioningStateDeleting  PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateDeleting
	PrivateEndpointConnectionProvisioningStateFailed    PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateFailed
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = original.PrivateEndpointConnectionProvisioningStateSucceeded
)

type PrivateEndpointServiceConnectionStatus = original.PrivateEndpointServiceConnectionStatus

const (
	Approved PrivateEndpointServiceConnectionStatus = original.Approved
	Pending  PrivateEndpointServiceConnectionStatus = original.Pending
	Rejected PrivateEndpointServiceConnectionStatus = original.Rejected
)

type ProtocolTypes = original.ProtocolTypes

const (
	HTTP  ProtocolTypes = original.HTTP
	HTTPS ProtocolTypes = original.HTTPS
)

type ProximityPlacementGroupType = original.ProximityPlacementGroupType

const (
	Standard ProximityPlacementGroupType = original.Standard
	Ultra    ProximityPlacementGroupType = original.Ultra
)

type PublicIPAddressSkuName = original.PublicIPAddressSkuName

const (
	PublicIPAddressSkuNameBasic    PublicIPAddressSkuName = original.PublicIPAddressSkuNameBasic
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = original.PublicIPAddressSkuNameStandard
)

type PublicIPAddressSkuTier = original.PublicIPAddressSkuTier

const (
	Global   PublicIPAddressSkuTier = original.Global
	Regional PublicIPAddressSkuTier = original.Regional
)

type PublicIPAllocationMethod = original.PublicIPAllocationMethod

const (
	Dynamic PublicIPAllocationMethod = original.Dynamic
	Static  PublicIPAllocationMethod = original.Static
)

type PublicNetworkAccess = original.PublicNetworkAccess

const (
	Disabled PublicNetworkAccess = original.Disabled
	Enabled  PublicNetworkAccess = original.Enabled
)

type RepairAction = original.RepairAction

const (
	Reimage RepairAction = original.Reimage
	Replace RepairAction = original.Replace
	Restart RepairAction = original.Restart
)

type ReplicationMode = original.ReplicationMode

const (
	Full    ReplicationMode = original.Full
	Shallow ReplicationMode = original.Shallow
)

type ReplicationState = original.ReplicationState

const (
	ReplicationStateCompleted   ReplicationState = original.ReplicationStateCompleted
	ReplicationStateFailed      ReplicationState = original.ReplicationStateFailed
	ReplicationStateReplicating ReplicationState = original.ReplicationStateReplicating
	ReplicationStateUnknown     ReplicationState = original.ReplicationStateUnknown
)

type ReplicationStatusTypes = original.ReplicationStatusTypes

const (
	ReplicationStatusTypesReplicationStatus ReplicationStatusTypes = original.ReplicationStatusTypesReplicationStatus
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone                       ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned             ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssignedUserAssigned
	ResourceIdentityTypeUserAssigned               ResourceIdentityType = original.ResourceIdentityTypeUserAssigned
)

type ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleType

const (
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeAutomatic
	ResourceSkuCapacityScaleTypeManual    ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeManual
	ResourceSkuCapacityScaleTypeNone      ResourceSkuCapacityScaleType = original.ResourceSkuCapacityScaleTypeNone
)

type ResourceSkuRestrictionsReasonCode = original.ResourceSkuRestrictionsReasonCode

const (
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = original.NotAvailableForSubscription
	QuotaID                     ResourceSkuRestrictionsReasonCode = original.QuotaID
)

type ResourceSkuRestrictionsType = original.ResourceSkuRestrictionsType

const (
	Location ResourceSkuRestrictionsType = original.Location
	Zone     ResourceSkuRestrictionsType = original.Zone
)

type RestorePointCollectionExpandOptions = original.RestorePointCollectionExpandOptions

const (
	RestorePoints RestorePointCollectionExpandOptions = original.RestorePoints
)

type RestorePointExpandOptions = original.RestorePointExpandOptions

const (
	RestorePointExpandOptionsInstanceView RestorePointExpandOptions = original.RestorePointExpandOptionsInstanceView
)

type RollingUpgradeActionType = original.RollingUpgradeActionType

const (
	Cancel RollingUpgradeActionType = original.Cancel
	Start  RollingUpgradeActionType = original.Start
)

type RollingUpgradeStatusCode = original.RollingUpgradeStatusCode

const (
	RollingUpgradeStatusCodeCancelled      RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeCancelled
	RollingUpgradeStatusCodeCompleted      RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeCompleted
	RollingUpgradeStatusCodeFaulted        RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeFaulted
	RollingUpgradeStatusCodeRollingForward RollingUpgradeStatusCode = original.RollingUpgradeStatusCodeRollingForward
)

type SecurityEncryptionTypes = original.SecurityEncryptionTypes

const (
	DiskWithVMGuestState SecurityEncryptionTypes = original.DiskWithVMGuestState
	VMGuestStateOnly     SecurityEncryptionTypes = original.VMGuestStateOnly
)

type SecurityTypes = original.SecurityTypes

const (
	SecurityTypesConfidentialVM SecurityTypes = original.SecurityTypesConfidentialVM
	SecurityTypesTrustedLaunch  SecurityTypes = original.SecurityTypesTrustedLaunch
)

type SelectPermissions = original.SelectPermissions

const (
	Permissions SelectPermissions = original.Permissions
)

type SettingNames = original.SettingNames

const (
	AutoLogon          SettingNames = original.AutoLogon
	FirstLogonCommands SettingNames = original.FirstLogonCommands
)

type SharedGalleryHostCaching = original.SharedGalleryHostCaching

const (
	SharedGalleryHostCachingNone      SharedGalleryHostCaching = original.SharedGalleryHostCachingNone
	SharedGalleryHostCachingReadOnly  SharedGalleryHostCaching = original.SharedGalleryHostCachingReadOnly
	SharedGalleryHostCachingReadWrite SharedGalleryHostCaching = original.SharedGalleryHostCachingReadWrite
)

type SharedToValues = original.SharedToValues

const (
	Tenant SharedToValues = original.Tenant
)

type SharingProfileGroupTypes = original.SharingProfileGroupTypes

const (
	AADTenants    SharingProfileGroupTypes = original.AADTenants
	Subscriptions SharingProfileGroupTypes = original.Subscriptions
)

type SharingState = original.SharingState

const (
	SharingStateFailed     SharingState = original.SharingStateFailed
	SharingStateInProgress SharingState = original.SharingStateInProgress
	SharingStateSucceeded  SharingState = original.SharingStateSucceeded
	SharingStateUnknown    SharingState = original.SharingStateUnknown
)

type SharingUpdateOperationTypes = original.SharingUpdateOperationTypes

const (
	Add             SharingUpdateOperationTypes = original.Add
	EnableCommunity SharingUpdateOperationTypes = original.EnableCommunity
	Remove          SharingUpdateOperationTypes = original.Remove
	Reset           SharingUpdateOperationTypes = original.Reset
)

type SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypes

const (
	SnapshotStorageAccountTypesPremiumLRS  SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypesPremiumLRS
	SnapshotStorageAccountTypesStandardLRS SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypesStandardLRS
	SnapshotStorageAccountTypesStandardZRS SnapshotStorageAccountTypes = original.SnapshotStorageAccountTypesStandardZRS
)

type StatusLevelTypes = original.StatusLevelTypes

const (
	Error   StatusLevelTypes = original.Error
	Info    StatusLevelTypes = original.Info
	Warning StatusLevelTypes = original.Warning
)

type StorageAccountType = original.StorageAccountType

const (
	StorageAccountTypePremiumLRS  StorageAccountType = original.StorageAccountTypePremiumLRS
	StorageAccountTypeStandardLRS StorageAccountType = original.StorageAccountTypeStandardLRS
	StorageAccountTypeStandardZRS StorageAccountType = original.StorageAccountTypeStandardZRS
)

type StorageAccountTypes = original.StorageAccountTypes

const (
	StorageAccountTypesPremiumLRS     StorageAccountTypes = original.StorageAccountTypesPremiumLRS
	StorageAccountTypesPremiumV2LRS   StorageAccountTypes = original.StorageAccountTypesPremiumV2LRS
	StorageAccountTypesPremiumZRS     StorageAccountTypes = original.StorageAccountTypesPremiumZRS
	StorageAccountTypesStandardLRS    StorageAccountTypes = original.StorageAccountTypesStandardLRS
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = original.StorageAccountTypesStandardSSDLRS
	StorageAccountTypesStandardSSDZRS StorageAccountTypes = original.StorageAccountTypesStandardSSDZRS
	StorageAccountTypesUltraSSDLRS    StorageAccountTypes = original.StorageAccountTypesUltraSSDLRS
)

type UpgradeMode = original.UpgradeMode

const (
	UpgradeModeAutomatic UpgradeMode = original.UpgradeModeAutomatic
	UpgradeModeManual    UpgradeMode = original.UpgradeModeManual
	UpgradeModeRolling   UpgradeMode = original.UpgradeModeRolling
)

type UpgradeOperationInvoker = original.UpgradeOperationInvoker

const (
	UpgradeOperationInvokerPlatform UpgradeOperationInvoker = original.UpgradeOperationInvokerPlatform
	UpgradeOperationInvokerUnknown  UpgradeOperationInvoker = original.UpgradeOperationInvokerUnknown
	UpgradeOperationInvokerUser     UpgradeOperationInvoker = original.UpgradeOperationInvokerUser
)

type UpgradeState = original.UpgradeState

const (
	UpgradeStateCancelled      UpgradeState = original.UpgradeStateCancelled
	UpgradeStateCompleted      UpgradeState = original.UpgradeStateCompleted
	UpgradeStateFaulted        UpgradeState = original.UpgradeStateFaulted
	UpgradeStateRollingForward UpgradeState = original.UpgradeStateRollingForward
)

type VMDiskTypes = original.VMDiskTypes

const (
	VMDiskTypesNone      VMDiskTypes = original.VMDiskTypesNone
	VMDiskTypesUnmanaged VMDiskTypes = original.VMDiskTypesUnmanaged
)

type VMGuestPatchClassificationLinux = original.VMGuestPatchClassificationLinux

const (
	Critical VMGuestPatchClassificationLinux = original.Critical
	Other    VMGuestPatchClassificationLinux = original.Other
	Security VMGuestPatchClassificationLinux = original.Security
)

type VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindows

const (
	VMGuestPatchClassificationWindowsCritical     VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsCritical
	VMGuestPatchClassificationWindowsDefinition   VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsDefinition
	VMGuestPatchClassificationWindowsFeaturePack  VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsFeaturePack
	VMGuestPatchClassificationWindowsSecurity     VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsSecurity
	VMGuestPatchClassificationWindowsServicePack  VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsServicePack
	VMGuestPatchClassificationWindowsTools        VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsTools
	VMGuestPatchClassificationWindowsUpdateRollUp VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsUpdateRollUp
	VMGuestPatchClassificationWindowsUpdates      VMGuestPatchClassificationWindows = original.VMGuestPatchClassificationWindowsUpdates
)

type VMGuestPatchRebootBehavior = original.VMGuestPatchRebootBehavior

const (
	VMGuestPatchRebootBehaviorAlwaysRequiresReboot VMGuestPatchRebootBehavior = original.VMGuestPatchRebootBehaviorAlwaysRequiresReboot
	VMGuestPatchRebootBehaviorCanRequestReboot     VMGuestPatchRebootBehavior = original.VMGuestPatchRebootBehaviorCanRequestReboot
	VMGuestPatchRebootBehaviorNeverReboots         VMGuestPatchRebootBehavior = original.VMGuestPatchRebootBehaviorNeverReboots
	VMGuestPatchRebootBehaviorUnknown              VMGuestPatchRebootBehavior = original.VMGuestPatchRebootBehaviorUnknown
)

type VMGuestPatchRebootSetting = original.VMGuestPatchRebootSetting

const (
	Always     VMGuestPatchRebootSetting = original.Always
	IfRequired VMGuestPatchRebootSetting = original.IfRequired
	Never      VMGuestPatchRebootSetting = original.Never
)

type VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatus

const (
	VMGuestPatchRebootStatusCompleted VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatusCompleted
	VMGuestPatchRebootStatusFailed    VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatusFailed
	VMGuestPatchRebootStatusNotNeeded VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatusNotNeeded
	VMGuestPatchRebootStatusRequired  VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatusRequired
	VMGuestPatchRebootStatusStarted   VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatusStarted
	VMGuestPatchRebootStatusUnknown   VMGuestPatchRebootStatus = original.VMGuestPatchRebootStatusUnknown
)

type VirtualMachineEvictionPolicyTypes = original.VirtualMachineEvictionPolicyTypes

const (
	VirtualMachineEvictionPolicyTypesDeallocate VirtualMachineEvictionPolicyTypes = original.VirtualMachineEvictionPolicyTypesDeallocate
	VirtualMachineEvictionPolicyTypesDelete     VirtualMachineEvictionPolicyTypes = original.VirtualMachineEvictionPolicyTypesDelete
)

type VirtualMachinePriorityTypes = original.VirtualMachinePriorityTypes

const (
	Low     VirtualMachinePriorityTypes = original.Low
	Regular VirtualMachinePriorityTypes = original.Regular
	Spot    VirtualMachinePriorityTypes = original.Spot
)

type VirtualMachineScaleSetScaleInRules = original.VirtualMachineScaleSetScaleInRules

const (
	Default  VirtualMachineScaleSetScaleInRules = original.Default
	NewestVM VirtualMachineScaleSetScaleInRules = original.NewestVM
	OldestVM VirtualMachineScaleSetScaleInRules = original.OldestVM
)

type VirtualMachineScaleSetSkuScaleType = original.VirtualMachineScaleSetSkuScaleType

const (
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = original.VirtualMachineScaleSetSkuScaleTypeAutomatic
	VirtualMachineScaleSetSkuScaleTypeNone      VirtualMachineScaleSetSkuScaleType = original.VirtualMachineScaleSetSkuScaleTypeNone
)

type VirtualMachineSizeTypes = original.VirtualMachineSizeTypes

const (
	BasicA0          VirtualMachineSizeTypes = original.BasicA0
	BasicA1          VirtualMachineSizeTypes = original.BasicA1
	BasicA2          VirtualMachineSizeTypes = original.BasicA2
	BasicA3          VirtualMachineSizeTypes = original.BasicA3
	BasicA4          VirtualMachineSizeTypes = original.BasicA4
	StandardA0       VirtualMachineSizeTypes = original.StandardA0
	StandardA1       VirtualMachineSizeTypes = original.StandardA1
	StandardA10      VirtualMachineSizeTypes = original.StandardA10
	StandardA11      VirtualMachineSizeTypes = original.StandardA11
	StandardA1V2     VirtualMachineSizeTypes = original.StandardA1V2
	StandardA2       VirtualMachineSizeTypes = original.StandardA2
	StandardA2mV2    VirtualMachineSizeTypes = original.StandardA2mV2
	StandardA2V2     VirtualMachineSizeTypes = original.StandardA2V2
	StandardA3       VirtualMachineSizeTypes = original.StandardA3
	StandardA4       VirtualMachineSizeTypes = original.StandardA4
	StandardA4mV2    VirtualMachineSizeTypes = original.StandardA4mV2
	StandardA4V2     VirtualMachineSizeTypes = original.StandardA4V2
	StandardA5       VirtualMachineSizeTypes = original.StandardA5
	StandardA6       VirtualMachineSizeTypes = original.StandardA6
	StandardA7       VirtualMachineSizeTypes = original.StandardA7
	StandardA8       VirtualMachineSizeTypes = original.StandardA8
	StandardA8mV2    VirtualMachineSizeTypes = original.StandardA8mV2
	StandardA8V2     VirtualMachineSizeTypes = original.StandardA8V2
	StandardA9       VirtualMachineSizeTypes = original.StandardA9
	StandardB1ms     VirtualMachineSizeTypes = original.StandardB1ms
	StandardB1s      VirtualMachineSizeTypes = original.StandardB1s
	StandardB2ms     VirtualMachineSizeTypes = original.StandardB2ms
	StandardB2s      VirtualMachineSizeTypes = original.StandardB2s
	StandardB4ms     VirtualMachineSizeTypes = original.StandardB4ms
	StandardB8ms     VirtualMachineSizeTypes = original.StandardB8ms
	StandardD1       VirtualMachineSizeTypes = original.StandardD1
	StandardD11      VirtualMachineSizeTypes = original.StandardD11
	StandardD11V2    VirtualMachineSizeTypes = original.StandardD11V2
	StandardD12      VirtualMachineSizeTypes = original.StandardD12
	StandardD12V2    VirtualMachineSizeTypes = original.StandardD12V2
	StandardD13      VirtualMachineSizeTypes = original.StandardD13
	StandardD13V2    VirtualMachineSizeTypes = original.StandardD13V2
	StandardD14      VirtualMachineSizeTypes = original.StandardD14
	StandardD14V2    VirtualMachineSizeTypes = original.StandardD14V2
	StandardD15V2    VirtualMachineSizeTypes = original.StandardD15V2
	StandardD16sV3   VirtualMachineSizeTypes = original.StandardD16sV3
	StandardD16V3    VirtualMachineSizeTypes = original.StandardD16V3
	StandardD1V2     VirtualMachineSizeTypes = original.StandardD1V2
	StandardD2       VirtualMachineSizeTypes = original.StandardD2
	StandardD2sV3    VirtualMachineSizeTypes = original.StandardD2sV3
	StandardD2V2     VirtualMachineSizeTypes = original.StandardD2V2
	StandardD2V3     VirtualMachineSizeTypes = original.StandardD2V3
	StandardD3       VirtualMachineSizeTypes = original.StandardD3
	StandardD32sV3   VirtualMachineSizeTypes = original.StandardD32sV3
	StandardD32V3    VirtualMachineSizeTypes = original.StandardD32V3
	StandardD3V2     VirtualMachineSizeTypes = original.StandardD3V2
	StandardD4       VirtualMachineSizeTypes = original.StandardD4
	StandardD4sV3    VirtualMachineSizeTypes = original.StandardD4sV3
	StandardD4V2     VirtualMachineSizeTypes = original.StandardD4V2
	StandardD4V3     VirtualMachineSizeTypes = original.StandardD4V3
	StandardD5V2     VirtualMachineSizeTypes = original.StandardD5V2
	StandardD64sV3   VirtualMachineSizeTypes = original.StandardD64sV3
	StandardD64V3    VirtualMachineSizeTypes = original.StandardD64V3
	StandardD8sV3    VirtualMachineSizeTypes = original.StandardD8sV3
	StandardD8V3     VirtualMachineSizeTypes = original.StandardD8V3
	StandardDS1      VirtualMachineSizeTypes = original.StandardDS1
	StandardDS11     VirtualMachineSizeTypes = original.StandardDS11
	StandardDS11V2   VirtualMachineSizeTypes = original.StandardDS11V2
	StandardDS12     VirtualMachineSizeTypes = original.StandardDS12
	StandardDS12V2   VirtualMachineSizeTypes = original.StandardDS12V2
	StandardDS13     VirtualMachineSizeTypes = original.StandardDS13
	StandardDS132V2  VirtualMachineSizeTypes = original.StandardDS132V2
	StandardDS134V2  VirtualMachineSizeTypes = original.StandardDS134V2
	StandardDS13V2   VirtualMachineSizeTypes = original.StandardDS13V2
	StandardDS14     VirtualMachineSizeTypes = original.StandardDS14
	StandardDS144V2  VirtualMachineSizeTypes = original.StandardDS144V2
	StandardDS148V2  VirtualMachineSizeTypes = original.StandardDS148V2
	StandardDS14V2   VirtualMachineSizeTypes = original.StandardDS14V2
	StandardDS15V2   VirtualMachineSizeTypes = original.StandardDS15V2
	StandardDS1V2    VirtualMachineSizeTypes = original.StandardDS1V2
	StandardDS2      VirtualMachineSizeTypes = original.StandardDS2
	StandardDS2V2    VirtualMachineSizeTypes = original.StandardDS2V2
	StandardDS3      VirtualMachineSizeTypes = original.StandardDS3
	StandardDS3V2    VirtualMachineSizeTypes = original.StandardDS3V2
	StandardDS4      VirtualMachineSizeTypes = original.StandardDS4
	StandardDS4V2    VirtualMachineSizeTypes = original.StandardDS4V2
	StandardDS5V2    VirtualMachineSizeTypes = original.StandardDS5V2
	StandardE16sV3   VirtualMachineSizeTypes = original.StandardE16sV3
	StandardE16V3    VirtualMachineSizeTypes = original.StandardE16V3
	StandardE2sV3    VirtualMachineSizeTypes = original.StandardE2sV3
	StandardE2V3     VirtualMachineSizeTypes = original.StandardE2V3
	StandardE3216V3  VirtualMachineSizeTypes = original.StandardE3216V3
	StandardE328sV3  VirtualMachineSizeTypes = original.StandardE328sV3
	StandardE32sV3   VirtualMachineSizeTypes = original.StandardE32sV3
	StandardE32V3    VirtualMachineSizeTypes = original.StandardE32V3
	StandardE4sV3    VirtualMachineSizeTypes = original.StandardE4sV3
	StandardE4V3     VirtualMachineSizeTypes = original.StandardE4V3
	StandardE6416sV3 VirtualMachineSizeTypes = original.StandardE6416sV3
	StandardE6432sV3 VirtualMachineSizeTypes = original.StandardE6432sV3
	StandardE64sV3   VirtualMachineSizeTypes = original.StandardE64sV3
	StandardE64V3    VirtualMachineSizeTypes = original.StandardE64V3
	StandardE8sV3    VirtualMachineSizeTypes = original.StandardE8sV3
	StandardE8V3     VirtualMachineSizeTypes = original.StandardE8V3
	StandardF1       VirtualMachineSizeTypes = original.StandardF1
	StandardF16      VirtualMachineSizeTypes = original.StandardF16
	StandardF16s     VirtualMachineSizeTypes = original.StandardF16s
	StandardF16sV2   VirtualMachineSizeTypes = original.StandardF16sV2
	StandardF1s      VirtualMachineSizeTypes = original.StandardF1s
	StandardF2       VirtualMachineSizeTypes = original.StandardF2
	StandardF2s      VirtualMachineSizeTypes = original.StandardF2s
	StandardF2sV2    VirtualMachineSizeTypes = original.StandardF2sV2
	StandardF32sV2   VirtualMachineSizeTypes = original.StandardF32sV2
	StandardF4       VirtualMachineSizeTypes = original.StandardF4
	StandardF4s      VirtualMachineSizeTypes = original.StandardF4s
	StandardF4sV2    VirtualMachineSizeTypes = original.StandardF4sV2
	StandardF64sV2   VirtualMachineSizeTypes = original.StandardF64sV2
	StandardF72sV2   VirtualMachineSizeTypes = original.StandardF72sV2
	StandardF8       VirtualMachineSizeTypes = original.StandardF8
	StandardF8s      VirtualMachineSizeTypes = original.StandardF8s
	StandardF8sV2    VirtualMachineSizeTypes = original.StandardF8sV2
	StandardG1       VirtualMachineSizeTypes = original.StandardG1
	StandardG2       VirtualMachineSizeTypes = original.StandardG2
	StandardG3       VirtualMachineSizeTypes = original.StandardG3
	StandardG4       VirtualMachineSizeTypes = original.StandardG4
	StandardG5       VirtualMachineSizeTypes = original.StandardG5
	StandardGS1      VirtualMachineSizeTypes = original.StandardGS1
	StandardGS2      VirtualMachineSizeTypes = original.StandardGS2
	StandardGS3      VirtualMachineSizeTypes = original.StandardGS3
	StandardGS4      VirtualMachineSizeTypes = original.StandardGS4
	StandardGS44     VirtualMachineSizeTypes = original.StandardGS44
	StandardGS48     VirtualMachineSizeTypes = original.StandardGS48
	StandardGS5      VirtualMachineSizeTypes = original.StandardGS5
	StandardGS516    VirtualMachineSizeTypes = original.StandardGS516
	StandardGS58     VirtualMachineSizeTypes = original.StandardGS58
	StandardH16      VirtualMachineSizeTypes = original.StandardH16
	StandardH16m     VirtualMachineSizeTypes = original.StandardH16m
	StandardH16mr    VirtualMachineSizeTypes = original.StandardH16mr
	StandardH16r     VirtualMachineSizeTypes = original.StandardH16r
	StandardH8       VirtualMachineSizeTypes = original.StandardH8
	StandardH8m      VirtualMachineSizeTypes = original.StandardH8m
	StandardL16s     VirtualMachineSizeTypes = original.StandardL16s
	StandardL32s     VirtualMachineSizeTypes = original.StandardL32s
	StandardL4s      VirtualMachineSizeTypes = original.StandardL4s
	StandardL8s      VirtualMachineSizeTypes = original.StandardL8s
	StandardM12832ms VirtualMachineSizeTypes = original.StandardM12832ms
	StandardM12864ms VirtualMachineSizeTypes = original.StandardM12864ms
	StandardM128ms   VirtualMachineSizeTypes = original.StandardM128ms
	StandardM128s    VirtualMachineSizeTypes = original.StandardM128s
	StandardM6416ms  VirtualMachineSizeTypes = original.StandardM6416ms
	StandardM6432ms  VirtualMachineSizeTypes = original.StandardM6432ms
	StandardM64ms    VirtualMachineSizeTypes = original.StandardM64ms
	StandardM64s     VirtualMachineSizeTypes = original.StandardM64s
	StandardNC12     VirtualMachineSizeTypes = original.StandardNC12
	StandardNC12sV2  VirtualMachineSizeTypes = original.StandardNC12sV2
	StandardNC12sV3  VirtualMachineSizeTypes = original.StandardNC12sV3
	StandardNC24     VirtualMachineSizeTypes = original.StandardNC24
	StandardNC24r    VirtualMachineSizeTypes = original.StandardNC24r
	StandardNC24rsV2 VirtualMachineSizeTypes = original.StandardNC24rsV2
	StandardNC24rsV3 VirtualMachineSizeTypes = original.StandardNC24rsV3
	StandardNC24sV2  VirtualMachineSizeTypes = original.StandardNC24sV2
	StandardNC24sV3  VirtualMachineSizeTypes = original.StandardNC24sV3
	StandardNC6      VirtualMachineSizeTypes = original.StandardNC6
	StandardNC6sV2   VirtualMachineSizeTypes = original.StandardNC6sV2
	StandardNC6sV3   VirtualMachineSizeTypes = original.StandardNC6sV3
	StandardND12s    VirtualMachineSizeTypes = original.StandardND12s
	StandardND24rs   VirtualMachineSizeTypes = original.StandardND24rs
	StandardND24s    VirtualMachineSizeTypes = original.StandardND24s
	StandardND6s     VirtualMachineSizeTypes = original.StandardND6s
	StandardNV12     VirtualMachineSizeTypes = original.StandardNV12
	StandardNV24     VirtualMachineSizeTypes = original.StandardNV24
	StandardNV6      VirtualMachineSizeTypes = original.StandardNV6
)

type WindowsPatchAssessmentMode = original.WindowsPatchAssessmentMode

const (
	WindowsPatchAssessmentModeAutomaticByPlatform WindowsPatchAssessmentMode = original.WindowsPatchAssessmentModeAutomaticByPlatform
	WindowsPatchAssessmentModeImageDefault        WindowsPatchAssessmentMode = original.WindowsPatchAssessmentModeImageDefault
)

type WindowsVMGuestPatchAutomaticByPlatformRebootSetting = original.WindowsVMGuestPatchAutomaticByPlatformRebootSetting

const (
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingAlways     WindowsVMGuestPatchAutomaticByPlatformRebootSetting = original.WindowsVMGuestPatchAutomaticByPlatformRebootSettingAlways
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingIfRequired WindowsVMGuestPatchAutomaticByPlatformRebootSetting = original.WindowsVMGuestPatchAutomaticByPlatformRebootSettingIfRequired
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever      WindowsVMGuestPatchAutomaticByPlatformRebootSetting = original.WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingUnknown    WindowsVMGuestPatchAutomaticByPlatformRebootSetting = original.WindowsVMGuestPatchAutomaticByPlatformRebootSettingUnknown
)

type WindowsVMGuestPatchMode = original.WindowsVMGuestPatchMode

const (
	WindowsVMGuestPatchModeAutomaticByOS       WindowsVMGuestPatchMode = original.WindowsVMGuestPatchModeAutomaticByOS
	WindowsVMGuestPatchModeAutomaticByPlatform WindowsVMGuestPatchMode = original.WindowsVMGuestPatchModeAutomaticByPlatform
	WindowsVMGuestPatchModeManual              WindowsVMGuestPatchMode = original.WindowsVMGuestPatchModeManual
)

type APIEntityReference = original.APIEntityReference
type APIError = original.APIError
type APIErrorBase = original.APIErrorBase
type AccessURI = original.AccessURI
type AdditionalCapabilities = original.AdditionalCapabilities
type AdditionalUnattendContent = original.AdditionalUnattendContent
type ApplicationProfile = original.ApplicationProfile
type AutomaticOSUpgradePolicy = original.AutomaticOSUpgradePolicy
type AutomaticOSUpgradeProperties = original.AutomaticOSUpgradeProperties
type AutomaticRepairsPolicy = original.AutomaticRepairsPolicy
type AvailabilitySet = original.AvailabilitySet
type AvailabilitySetListResult = original.AvailabilitySetListResult
type AvailabilitySetListResultIterator = original.AvailabilitySetListResultIterator
type AvailabilitySetListResultPage = original.AvailabilitySetListResultPage
type AvailabilitySetProperties = original.AvailabilitySetProperties
type AvailabilitySetUpdate = original.AvailabilitySetUpdate
type AvailabilitySetsClient = original.AvailabilitySetsClient
type AvailablePatchSummary = original.AvailablePatchSummary
type BaseClient = original.BaseClient
type BillingProfile = original.BillingProfile
type BootDiagnostics = original.BootDiagnostics
type BootDiagnosticsInstanceView = original.BootDiagnosticsInstanceView
type CapacityReservation = original.CapacityReservation
type CapacityReservationGroup = original.CapacityReservationGroup
type CapacityReservationGroupInstanceView = original.CapacityReservationGroupInstanceView
type CapacityReservationGroupListResult = original.CapacityReservationGroupListResult
type CapacityReservationGroupListResultIterator = original.CapacityReservationGroupListResultIterator
type CapacityReservationGroupListResultPage = original.CapacityReservationGroupListResultPage
type CapacityReservationGroupProperties = original.CapacityReservationGroupProperties
type CapacityReservationGroupUpdate = original.CapacityReservationGroupUpdate
type CapacityReservationGroupsClient = original.CapacityReservationGroupsClient
type CapacityReservationInstanceView = original.CapacityReservationInstanceView
type CapacityReservationInstanceViewWithName = original.CapacityReservationInstanceViewWithName
type CapacityReservationListResult = original.CapacityReservationListResult
type CapacityReservationListResultIterator = original.CapacityReservationListResultIterator
type CapacityReservationListResultPage = original.CapacityReservationListResultPage
type CapacityReservationProfile = original.CapacityReservationProfile
type CapacityReservationProperties = original.CapacityReservationProperties
type CapacityReservationUpdate = original.CapacityReservationUpdate
type CapacityReservationUtilization = original.CapacityReservationUtilization
type CapacityReservationsClient = original.CapacityReservationsClient
type CapacityReservationsCreateOrUpdateFuture = original.CapacityReservationsCreateOrUpdateFuture
type CapacityReservationsDeleteFuture = original.CapacityReservationsDeleteFuture
type CapacityReservationsUpdateFuture = original.CapacityReservationsUpdateFuture
type CloudError = original.CloudError
type CloudService = original.CloudService
type CloudServiceExtensionProfile = original.CloudServiceExtensionProfile
type CloudServiceExtensionProperties = original.CloudServiceExtensionProperties
type CloudServiceInstanceView = original.CloudServiceInstanceView
type CloudServiceListResult = original.CloudServiceListResult
type CloudServiceListResultIterator = original.CloudServiceListResultIterator
type CloudServiceListResultPage = original.CloudServiceListResultPage
type CloudServiceNetworkProfile = original.CloudServiceNetworkProfile
type CloudServiceOperatingSystemsClient = original.CloudServiceOperatingSystemsClient
type CloudServiceOsProfile = original.CloudServiceOsProfile
type CloudServiceProperties = original.CloudServiceProperties
type CloudServiceRole = original.CloudServiceRole
type CloudServiceRoleInstancesClient = original.CloudServiceRoleInstancesClient
type CloudServiceRoleInstancesDeleteFuture = original.CloudServiceRoleInstancesDeleteFuture
type CloudServiceRoleInstancesRebuildFuture = original.CloudServiceRoleInstancesRebuildFuture
type CloudServiceRoleInstancesReimageFuture = original.CloudServiceRoleInstancesReimageFuture
type CloudServiceRoleInstancesRestartFuture = original.CloudServiceRoleInstancesRestartFuture
type CloudServiceRoleListResult = original.CloudServiceRoleListResult
type CloudServiceRoleListResultIterator = original.CloudServiceRoleListResultIterator
type CloudServiceRoleListResultPage = original.CloudServiceRoleListResultPage
type CloudServiceRoleProfile = original.CloudServiceRoleProfile
type CloudServiceRoleProfileProperties = original.CloudServiceRoleProfileProperties
type CloudServiceRoleProperties = original.CloudServiceRoleProperties
type CloudServiceRoleSku = original.CloudServiceRoleSku
type CloudServiceRolesClient = original.CloudServiceRolesClient
type CloudServiceUpdate = original.CloudServiceUpdate
type CloudServiceVaultAndSecretReference = original.CloudServiceVaultAndSecretReference
type CloudServiceVaultCertificate = original.CloudServiceVaultCertificate
type CloudServiceVaultSecretGroup = original.CloudServiceVaultSecretGroup
type CloudServicesClient = original.CloudServicesClient
type CloudServicesCreateOrUpdateFuture = original.CloudServicesCreateOrUpdateFuture
type CloudServicesDeleteFuture = original.CloudServicesDeleteFuture
type CloudServicesDeleteInstancesFuture = original.CloudServicesDeleteInstancesFuture
type CloudServicesPowerOffFuture = original.CloudServicesPowerOffFuture
type CloudServicesRebuildFuture = original.CloudServicesRebuildFuture
type CloudServicesReimageFuture = original.CloudServicesReimageFuture
type CloudServicesRestartFuture = original.CloudServicesRestartFuture
type CloudServicesStartFuture = original.CloudServicesStartFuture
type CloudServicesUpdateDomainClient = original.CloudServicesUpdateDomainClient
type CloudServicesUpdateDomainWalkUpdateDomainFuture = original.CloudServicesUpdateDomainWalkUpdateDomainFuture
type CloudServicesUpdateFuture = original.CloudServicesUpdateFuture
type CommunityGalleriesClient = original.CommunityGalleriesClient
type CommunityGallery = original.CommunityGallery
type CommunityGalleryIdentifier = original.CommunityGalleryIdentifier
type CommunityGalleryImage = original.CommunityGalleryImage
type CommunityGalleryImageList = original.CommunityGalleryImageList
type CommunityGalleryImageListIterator = original.CommunityGalleryImageListIterator
type CommunityGalleryImageListPage = original.CommunityGalleryImageListPage
type CommunityGalleryImageProperties = original.CommunityGalleryImageProperties
type CommunityGalleryImageVersion = original.CommunityGalleryImageVersion
type CommunityGalleryImageVersionList = original.CommunityGalleryImageVersionList
type CommunityGalleryImageVersionListIterator = original.CommunityGalleryImageVersionListIterator
type CommunityGalleryImageVersionListPage = original.CommunityGalleryImageVersionListPage
type CommunityGalleryImageVersionProperties = original.CommunityGalleryImageVersionProperties
type CommunityGalleryImageVersionsClient = original.CommunityGalleryImageVersionsClient
type CommunityGalleryImagesClient = original.CommunityGalleryImagesClient
type CommunityGalleryInfo = original.CommunityGalleryInfo
type CopyCompletionError = original.CopyCompletionError
type CreationData = original.CreationData
type DataDisk = original.DataDisk
type DataDiskImage = original.DataDiskImage
type DataDiskImageEncryption = original.DataDiskImageEncryption
type DedicatedHost = original.DedicatedHost
type DedicatedHostAllocatableVM = original.DedicatedHostAllocatableVM
type DedicatedHostAvailableCapacity = original.DedicatedHostAvailableCapacity
type DedicatedHostGroup = original.DedicatedHostGroup
type DedicatedHostGroupInstanceView = original.DedicatedHostGroupInstanceView
type DedicatedHostGroupListResult = original.DedicatedHostGroupListResult
type DedicatedHostGroupListResultIterator = original.DedicatedHostGroupListResultIterator
type DedicatedHostGroupListResultPage = original.DedicatedHostGroupListResultPage
type DedicatedHostGroupProperties = original.DedicatedHostGroupProperties
type DedicatedHostGroupPropertiesAdditionalCapabilities = original.DedicatedHostGroupPropertiesAdditionalCapabilities
type DedicatedHostGroupUpdate = original.DedicatedHostGroupUpdate
type DedicatedHostGroupsClient = original.DedicatedHostGroupsClient
type DedicatedHostInstanceView = original.DedicatedHostInstanceView
type DedicatedHostInstanceViewWithName = original.DedicatedHostInstanceViewWithName
type DedicatedHostListResult = original.DedicatedHostListResult
type DedicatedHostListResultIterator = original.DedicatedHostListResultIterator
type DedicatedHostListResultPage = original.DedicatedHostListResultPage
type DedicatedHostProperties = original.DedicatedHostProperties
type DedicatedHostUpdate = original.DedicatedHostUpdate
type DedicatedHostsClient = original.DedicatedHostsClient
type DedicatedHostsCreateOrUpdateFuture = original.DedicatedHostsCreateOrUpdateFuture
type DedicatedHostsDeleteFuture = original.DedicatedHostsDeleteFuture
type DedicatedHostsRestartFuture = original.DedicatedHostsRestartFuture
type DedicatedHostsUpdateFuture = original.DedicatedHostsUpdateFuture
type DiagnosticsProfile = original.DiagnosticsProfile
type DiffDiskSettings = original.DiffDiskSettings
type Disallowed = original.Disallowed
type DisallowedConfiguration = original.DisallowedConfiguration
type Disk = original.Disk
type DiskAccess = original.DiskAccess
type DiskAccessList = original.DiskAccessList
type DiskAccessListIterator = original.DiskAccessListIterator
type DiskAccessListPage = original.DiskAccessListPage
type DiskAccessProperties = original.DiskAccessProperties
type DiskAccessUpdate = original.DiskAccessUpdate
type DiskAccessesClient = original.DiskAccessesClient
type DiskAccessesCreateOrUpdateFuture = original.DiskAccessesCreateOrUpdateFuture
type DiskAccessesDeleteAPrivateEndpointConnectionFuture = original.DiskAccessesDeleteAPrivateEndpointConnectionFuture
type DiskAccessesDeleteFuture = original.DiskAccessesDeleteFuture
type DiskAccessesUpdateAPrivateEndpointConnectionFuture = original.DiskAccessesUpdateAPrivateEndpointConnectionFuture
type DiskAccessesUpdateFuture = original.DiskAccessesUpdateFuture
type DiskEncryptionSet = original.DiskEncryptionSet
type DiskEncryptionSetList = original.DiskEncryptionSetList
type DiskEncryptionSetListIterator = original.DiskEncryptionSetListIterator
type DiskEncryptionSetListPage = original.DiskEncryptionSetListPage
type DiskEncryptionSetParameters = original.DiskEncryptionSetParameters
type DiskEncryptionSetUpdate = original.DiskEncryptionSetUpdate
type DiskEncryptionSetUpdateProperties = original.DiskEncryptionSetUpdateProperties
type DiskEncryptionSetsClient = original.DiskEncryptionSetsClient
type DiskEncryptionSetsCreateOrUpdateFuture = original.DiskEncryptionSetsCreateOrUpdateFuture
type DiskEncryptionSetsDeleteFuture = original.DiskEncryptionSetsDeleteFuture
type DiskEncryptionSetsUpdateFuture = original.DiskEncryptionSetsUpdateFuture
type DiskEncryptionSettings = original.DiskEncryptionSettings
type DiskImageEncryption = original.DiskImageEncryption
type DiskInstanceView = original.DiskInstanceView
type DiskList = original.DiskList
type DiskListIterator = original.DiskListIterator
type DiskListPage = original.DiskListPage
type DiskProperties = original.DiskProperties
type DiskRestorePoint = original.DiskRestorePoint
type DiskRestorePointClient = original.DiskRestorePointClient
type DiskRestorePointGrantAccessFuture = original.DiskRestorePointGrantAccessFuture
type DiskRestorePointInstanceView = original.DiskRestorePointInstanceView
type DiskRestorePointList = original.DiskRestorePointList
type DiskRestorePointListIterator = original.DiskRestorePointListIterator
type DiskRestorePointListPage = original.DiskRestorePointListPage
type DiskRestorePointProperties = original.DiskRestorePointProperties
type DiskRestorePointReplicationStatus = original.DiskRestorePointReplicationStatus
type DiskRestorePointRevokeAccessFuture = original.DiskRestorePointRevokeAccessFuture
type DiskSecurityProfile = original.DiskSecurityProfile
type DiskSku = original.DiskSku
type DiskUpdate = original.DiskUpdate
type DiskUpdateProperties = original.DiskUpdateProperties
type DisksClient = original.DisksClient
type DisksCreateOrUpdateFuture = original.DisksCreateOrUpdateFuture
type DisksDeleteFuture = original.DisksDeleteFuture
type DisksGrantAccessFuture = original.DisksGrantAccessFuture
type DisksRevokeAccessFuture = original.DisksRevokeAccessFuture
type DisksUpdateFuture = original.DisksUpdateFuture
type Encryption = original.Encryption
type EncryptionImages = original.EncryptionImages
type EncryptionSetIdentity = original.EncryptionSetIdentity
type EncryptionSetProperties = original.EncryptionSetProperties
type EncryptionSettingsCollection = original.EncryptionSettingsCollection
type EncryptionSettingsElement = original.EncryptionSettingsElement
type ExtendedLocation = original.ExtendedLocation
type Extension = original.Extension
type GalleriesClient = original.GalleriesClient
type GalleriesCreateOrUpdateFuture = original.GalleriesCreateOrUpdateFuture
type GalleriesDeleteFuture = original.GalleriesDeleteFuture
type GalleriesUpdateFuture = original.GalleriesUpdateFuture
type Gallery = original.Gallery
type GalleryApplication = original.GalleryApplication
type GalleryApplicationList = original.GalleryApplicationList
type GalleryApplicationListIterator = original.GalleryApplicationListIterator
type GalleryApplicationListPage = original.GalleryApplicationListPage
type GalleryApplicationProperties = original.GalleryApplicationProperties
type GalleryApplicationUpdate = original.GalleryApplicationUpdate
type GalleryApplicationVersion = original.GalleryApplicationVersion
type GalleryApplicationVersionList = original.GalleryApplicationVersionList
type GalleryApplicationVersionListIterator = original.GalleryApplicationVersionListIterator
type GalleryApplicationVersionListPage = original.GalleryApplicationVersionListPage
type GalleryApplicationVersionProperties = original.GalleryApplicationVersionProperties
type GalleryApplicationVersionPublishingProfile = original.GalleryApplicationVersionPublishingProfile
type GalleryApplicationVersionUpdate = original.GalleryApplicationVersionUpdate
type GalleryApplicationVersionsClient = original.GalleryApplicationVersionsClient
type GalleryApplicationVersionsCreateOrUpdateFuture = original.GalleryApplicationVersionsCreateOrUpdateFuture
type GalleryApplicationVersionsDeleteFuture = original.GalleryApplicationVersionsDeleteFuture
type GalleryApplicationVersionsUpdateFuture = original.GalleryApplicationVersionsUpdateFuture
type GalleryApplicationsClient = original.GalleryApplicationsClient
type GalleryApplicationsCreateOrUpdateFuture = original.GalleryApplicationsCreateOrUpdateFuture
type GalleryApplicationsDeleteFuture = original.GalleryApplicationsDeleteFuture
type GalleryApplicationsUpdateFuture = original.GalleryApplicationsUpdateFuture
type GalleryArtifactPublishingProfileBase = original.GalleryArtifactPublishingProfileBase
type GalleryArtifactSource = original.GalleryArtifactSource
type GalleryArtifactVersionSource = original.GalleryArtifactVersionSource
type GalleryDataDiskImage = original.GalleryDataDiskImage
type GalleryDiskImage = original.GalleryDiskImage
type GalleryExtendedLocation = original.GalleryExtendedLocation
type GalleryIdentifier = original.GalleryIdentifier
type GalleryImage = original.GalleryImage
type GalleryImageFeature = original.GalleryImageFeature
type GalleryImageIdentifier = original.GalleryImageIdentifier
type GalleryImageList = original.GalleryImageList
type GalleryImageListIterator = original.GalleryImageListIterator
type GalleryImageListPage = original.GalleryImageListPage
type GalleryImageProperties = original.GalleryImageProperties
type GalleryImageUpdate = original.GalleryImageUpdate
type GalleryImageVersion = original.GalleryImageVersion
type GalleryImageVersionList = original.GalleryImageVersionList
type GalleryImageVersionListIterator = original.GalleryImageVersionListIterator
type GalleryImageVersionListPage = original.GalleryImageVersionListPage
type GalleryImageVersionProperties = original.GalleryImageVersionProperties
type GalleryImageVersionPublishingProfile = original.GalleryImageVersionPublishingProfile
type GalleryImageVersionStorageProfile = original.GalleryImageVersionStorageProfile
type GalleryImageVersionUpdate = original.GalleryImageVersionUpdate
type GalleryImageVersionsClient = original.GalleryImageVersionsClient
type GalleryImageVersionsCreateOrUpdateFuture = original.GalleryImageVersionsCreateOrUpdateFuture
type GalleryImageVersionsDeleteFuture = original.GalleryImageVersionsDeleteFuture
type GalleryImageVersionsUpdateFuture = original.GalleryImageVersionsUpdateFuture
type GalleryImagesClient = original.GalleryImagesClient
type GalleryImagesCreateOrUpdateFuture = original.GalleryImagesCreateOrUpdateFuture
type GalleryImagesDeleteFuture = original.GalleryImagesDeleteFuture
type GalleryImagesUpdateFuture = original.GalleryImagesUpdateFuture
type GalleryList = original.GalleryList
type GalleryListIterator = original.GalleryListIterator
type GalleryListPage = original.GalleryListPage
type GalleryOSDiskImage = original.GalleryOSDiskImage
type GalleryProperties = original.GalleryProperties
type GallerySharingProfileClient = original.GallerySharingProfileClient
type GallerySharingProfileUpdateFuture = original.GallerySharingProfileUpdateFuture
type GalleryTargetExtendedLocation = original.GalleryTargetExtendedLocation
type GalleryUpdate = original.GalleryUpdate
type GrantAccessData = original.GrantAccessData
type HardwareProfile = original.HardwareProfile
type Image = original.Image
type ImageDataDisk = original.ImageDataDisk
type ImageDisk = original.ImageDisk
type ImageDiskReference = original.ImageDiskReference
type ImageListResult = original.ImageListResult
type ImageListResultIterator = original.ImageListResultIterator
type ImageListResultPage = original.ImageListResultPage
type ImageOSDisk = original.ImageOSDisk
type ImageProperties = original.ImageProperties
type ImagePurchasePlan = original.ImagePurchasePlan
type ImageReference = original.ImageReference
type ImageStorageProfile = original.ImageStorageProfile
type ImageUpdate = original.ImageUpdate
type ImagesClient = original.ImagesClient
type ImagesCreateOrUpdateFuture = original.ImagesCreateOrUpdateFuture
type ImagesDeleteFuture = original.ImagesDeleteFuture
type ImagesUpdateFuture = original.ImagesUpdateFuture
type InnerError = original.InnerError
type InstanceSku = original.InstanceSku
type InstanceViewStatus = original.InstanceViewStatus
type InstanceViewStatusesSummary = original.InstanceViewStatusesSummary
type KeyForDiskEncryptionSet = original.KeyForDiskEncryptionSet
type KeyVaultAndKeyReference = original.KeyVaultAndKeyReference
type KeyVaultAndSecretReference = original.KeyVaultAndSecretReference
type KeyVaultKeyReference = original.KeyVaultKeyReference
type KeyVaultSecretReference = original.KeyVaultSecretReference
type LastPatchInstallationSummary = original.LastPatchInstallationSummary
type LinuxConfiguration = original.LinuxConfiguration
type LinuxParameters = original.LinuxParameters
type LinuxPatchSettings = original.LinuxPatchSettings
type LinuxVMGuestPatchAutomaticByPlatformSettings = original.LinuxVMGuestPatchAutomaticByPlatformSettings
type ListUsagesResult = original.ListUsagesResult
type ListUsagesResultIterator = original.ListUsagesResultIterator
type ListUsagesResultPage = original.ListUsagesResultPage
type ListVirtualMachineExtensionImage = original.ListVirtualMachineExtensionImage
type ListVirtualMachineImageResource = original.ListVirtualMachineImageResource
type LoadBalancerConfiguration = original.LoadBalancerConfiguration
type LoadBalancerConfigurationProperties = original.LoadBalancerConfigurationProperties
type LoadBalancerFrontendIPConfiguration = original.LoadBalancerFrontendIPConfiguration
type LoadBalancerFrontendIPConfigurationProperties = original.LoadBalancerFrontendIPConfigurationProperties
type LogAnalyticsClient = original.LogAnalyticsClient
type LogAnalyticsExportRequestRateByIntervalFuture = original.LogAnalyticsExportRequestRateByIntervalFuture
type LogAnalyticsExportThrottledRequestsFuture = original.LogAnalyticsExportThrottledRequestsFuture
type LogAnalyticsInputBase = original.LogAnalyticsInputBase
type LogAnalyticsOperationResult = original.LogAnalyticsOperationResult
type LogAnalyticsOutput = original.LogAnalyticsOutput
type MaintenanceRedeployStatus = original.MaintenanceRedeployStatus
type ManagedArtifact = original.ManagedArtifact
type ManagedDiskParameters = original.ManagedDiskParameters
type NetworkInterfaceReference = original.NetworkInterfaceReference
type NetworkInterfaceReferenceProperties = original.NetworkInterfaceReferenceProperties
type NetworkProfile = original.NetworkProfile
type OSDisk = original.OSDisk
type OSDiskImage = original.OSDiskImage
type OSDiskImageEncryption = original.OSDiskImageEncryption
type OSDiskImageSecurityProfile = original.OSDiskImageSecurityProfile
type OSFamily = original.OSFamily
type OSFamilyListResult = original.OSFamilyListResult
type OSFamilyListResultIterator = original.OSFamilyListResultIterator
type OSFamilyListResultPage = original.OSFamilyListResultPage
type OSFamilyProperties = original.OSFamilyProperties
type OSProfile = original.OSProfile
type OSVersion = original.OSVersion
type OSVersionListResult = original.OSVersionListResult
type OSVersionListResultIterator = original.OSVersionListResultIterator
type OSVersionListResultPage = original.OSVersionListResultPage
type OSVersionProperties = original.OSVersionProperties
type OSVersionPropertiesBase = original.OSVersionPropertiesBase
type OperationListResult = original.OperationListResult
type OperationValue = original.OperationValue
type OperationValueDisplay = original.OperationValueDisplay
type OperationsClient = original.OperationsClient
type OrchestrationServiceStateInput = original.OrchestrationServiceStateInput
type OrchestrationServiceSummary = original.OrchestrationServiceSummary
type PatchInstallationDetail = original.PatchInstallationDetail
type PatchSettings = original.PatchSettings
type PirCommunityGalleryResource = original.PirCommunityGalleryResource
type PirResource = original.PirResource
type PirSharedGalleryResource = original.PirSharedGalleryResource
type Plan = original.Plan
type PriorityMixPolicy = original.PriorityMixPolicy
type PrivateEndpoint = original.PrivateEndpoint
type PrivateEndpointConnection = original.PrivateEndpointConnection
type PrivateEndpointConnectionListResult = original.PrivateEndpointConnectionListResult
type PrivateEndpointConnectionListResultIterator = original.PrivateEndpointConnectionListResultIterator
type PrivateEndpointConnectionListResultPage = original.PrivateEndpointConnectionListResultPage
type PrivateEndpointConnectionProperties = original.PrivateEndpointConnectionProperties
type PrivateLinkResource = original.PrivateLinkResource
type PrivateLinkResourceListResult = original.PrivateLinkResourceListResult
type PrivateLinkResourceProperties = original.PrivateLinkResourceProperties
type PrivateLinkServiceConnectionState = original.PrivateLinkServiceConnectionState
type PropertyUpdatesInProgress = original.PropertyUpdatesInProgress
type ProximityPlacementGroup = original.ProximityPlacementGroup
type ProximityPlacementGroupListResult = original.ProximityPlacementGroupListResult
type ProximityPlacementGroupListResultIterator = original.ProximityPlacementGroupListResultIterator
type ProximityPlacementGroupListResultPage = original.ProximityPlacementGroupListResultPage
type ProximityPlacementGroupProperties = original.ProximityPlacementGroupProperties
type ProximityPlacementGroupPropertiesIntent = original.ProximityPlacementGroupPropertiesIntent
type ProximityPlacementGroupUpdate = original.ProximityPlacementGroupUpdate
type ProximityPlacementGroupsClient = original.ProximityPlacementGroupsClient
type ProxyOnlyResource = original.ProxyOnlyResource
type ProxyResource = original.ProxyResource
type PublicIPAddressSku = original.PublicIPAddressSku
type PurchasePlan = original.PurchasePlan
type ReadCloser = original.ReadCloser
type RecommendedMachineConfiguration = original.RecommendedMachineConfiguration
type RecoveryWalkResponse = original.RecoveryWalkResponse
type RegionalReplicationStatus = original.RegionalReplicationStatus
type RegionalSharingStatus = original.RegionalSharingStatus
type ReplicationStatus = original.ReplicationStatus
type RequestRateByIntervalInput = original.RequestRateByIntervalInput
type Resource = original.Resource
type ResourceInstanceViewStatus = original.ResourceInstanceViewStatus
type ResourceRange = original.ResourceRange
type ResourceSku = original.ResourceSku
type ResourceSkuCapabilities = original.ResourceSkuCapabilities
type ResourceSkuCapacity = original.ResourceSkuCapacity
type ResourceSkuCosts = original.ResourceSkuCosts
type ResourceSkuLocationInfo = original.ResourceSkuLocationInfo
type ResourceSkuRestrictionInfo = original.ResourceSkuRestrictionInfo
type ResourceSkuRestrictions = original.ResourceSkuRestrictions
type ResourceSkuZoneDetails = original.ResourceSkuZoneDetails
type ResourceSkusClient = original.ResourceSkusClient
type ResourceSkusResult = original.ResourceSkusResult
type ResourceSkusResultIterator = original.ResourceSkusResultIterator
type ResourceSkusResultPage = original.ResourceSkusResultPage
type ResourceURIList = original.ResourceURIList
type ResourceURIListIterator = original.ResourceURIListIterator
type ResourceURIListPage = original.ResourceURIListPage
type ResourceWithOptionalLocation = original.ResourceWithOptionalLocation
type RestorePoint = original.RestorePoint
type RestorePointCollection = original.RestorePointCollection
type RestorePointCollectionListResult = original.RestorePointCollectionListResult
type RestorePointCollectionListResultIterator = original.RestorePointCollectionListResultIterator
type RestorePointCollectionListResultPage = original.RestorePointCollectionListResultPage
type RestorePointCollectionProperties = original.RestorePointCollectionProperties
type RestorePointCollectionSourceProperties = original.RestorePointCollectionSourceProperties
type RestorePointCollectionUpdate = original.RestorePointCollectionUpdate
type RestorePointCollectionsClient = original.RestorePointCollectionsClient
type RestorePointCollectionsDeleteFuture = original.RestorePointCollectionsDeleteFuture
type RestorePointInstanceView = original.RestorePointInstanceView
type RestorePointProperties = original.RestorePointProperties
type RestorePointSourceMetadata = original.RestorePointSourceMetadata
type RestorePointSourceVMDataDisk = original.RestorePointSourceVMDataDisk
type RestorePointSourceVMOSDisk = original.RestorePointSourceVMOSDisk
type RestorePointSourceVMStorageProfile = original.RestorePointSourceVMStorageProfile
type RestorePointsClient = original.RestorePointsClient
type RestorePointsCreateFuture = original.RestorePointsCreateFuture
type RestorePointsDeleteFuture = original.RestorePointsDeleteFuture
type RetrieveBootDiagnosticsDataResult = original.RetrieveBootDiagnosticsDataResult
type RoleInstance = original.RoleInstance
type RoleInstanceInstanceView = original.RoleInstanceInstanceView
type RoleInstanceListResult = original.RoleInstanceListResult
type RoleInstanceListResultIterator = original.RoleInstanceListResultIterator
type RoleInstanceListResultPage = original.RoleInstanceListResultPage
type RoleInstanceNetworkProfile = original.RoleInstanceNetworkProfile
type RoleInstanceProperties = original.RoleInstanceProperties
type RoleInstances = original.RoleInstances
type RollbackStatusInfo = original.RollbackStatusInfo
type RollingUpgradePolicy = original.RollingUpgradePolicy
type RollingUpgradeProgressInfo = original.RollingUpgradeProgressInfo
type RollingUpgradeRunningStatus = original.RollingUpgradeRunningStatus
type RollingUpgradeStatusInfo = original.RollingUpgradeStatusInfo
type RollingUpgradeStatusInfoProperties = original.RollingUpgradeStatusInfoProperties
type RunCommandDocument = original.RunCommandDocument
type RunCommandDocumentBase = original.RunCommandDocumentBase
type RunCommandInput = original.RunCommandInput
type RunCommandInputParameter = original.RunCommandInputParameter
type RunCommandListResult = original.RunCommandListResult
type RunCommandListResultIterator = original.RunCommandListResultIterator
type RunCommandListResultPage = original.RunCommandListResultPage
type RunCommandParameterDefinition = original.RunCommandParameterDefinition
type RunCommandResult = original.RunCommandResult
type SSHConfiguration = original.SSHConfiguration
type SSHPublicKey = original.SSHPublicKey
type SSHPublicKeyGenerateKeyPairResult = original.SSHPublicKeyGenerateKeyPairResult
type SSHPublicKeyResource = original.SSHPublicKeyResource
type SSHPublicKeyResourceProperties = original.SSHPublicKeyResourceProperties
type SSHPublicKeyUpdateResource = original.SSHPublicKeyUpdateResource
type SSHPublicKeysClient = original.SSHPublicKeysClient
type SSHPublicKeysGroupListResult = original.SSHPublicKeysGroupListResult
type SSHPublicKeysGroupListResultIterator = original.SSHPublicKeysGroupListResultIterator
type SSHPublicKeysGroupListResultPage = original.SSHPublicKeysGroupListResultPage
type ScaleInPolicy = original.ScaleInPolicy
type ScheduledEventsProfile = original.ScheduledEventsProfile
type SecurityProfile = original.SecurityProfile
type ShareInfoElement = original.ShareInfoElement
type SharedGalleriesClient = original.SharedGalleriesClient
type SharedGallery = original.SharedGallery
type SharedGalleryDataDiskImage = original.SharedGalleryDataDiskImage
type SharedGalleryDiskImage = original.SharedGalleryDiskImage
type SharedGalleryIdentifier = original.SharedGalleryIdentifier
type SharedGalleryImage = original.SharedGalleryImage
type SharedGalleryImageList = original.SharedGalleryImageList
type SharedGalleryImageListIterator = original.SharedGalleryImageListIterator
type SharedGalleryImageListPage = original.SharedGalleryImageListPage
type SharedGalleryImageProperties = original.SharedGalleryImageProperties
type SharedGalleryImageVersion = original.SharedGalleryImageVersion
type SharedGalleryImageVersionList = original.SharedGalleryImageVersionList
type SharedGalleryImageVersionListIterator = original.SharedGalleryImageVersionListIterator
type SharedGalleryImageVersionListPage = original.SharedGalleryImageVersionListPage
type SharedGalleryImageVersionProperties = original.SharedGalleryImageVersionProperties
type SharedGalleryImageVersionStorageProfile = original.SharedGalleryImageVersionStorageProfile
type SharedGalleryImageVersionsClient = original.SharedGalleryImageVersionsClient
type SharedGalleryImagesClient = original.SharedGalleryImagesClient
type SharedGalleryList = original.SharedGalleryList
type SharedGalleryListIterator = original.SharedGalleryListIterator
type SharedGalleryListPage = original.SharedGalleryListPage
type SharedGalleryOSDiskImage = original.SharedGalleryOSDiskImage
type SharingProfile = original.SharingProfile
type SharingProfileGroup = original.SharingProfileGroup
type SharingStatus = original.SharingStatus
type SharingUpdate = original.SharingUpdate
type Sku = original.Sku
type Snapshot = original.Snapshot
type SnapshotList = original.SnapshotList
type SnapshotListIterator = original.SnapshotListIterator
type SnapshotListPage = original.SnapshotListPage
type SnapshotProperties = original.SnapshotProperties
type SnapshotSku = original.SnapshotSku
type SnapshotUpdate = original.SnapshotUpdate
type SnapshotUpdateProperties = original.SnapshotUpdateProperties
type SnapshotsClient = original.SnapshotsClient
type SnapshotsCreateOrUpdateFuture = original.SnapshotsCreateOrUpdateFuture
type SnapshotsDeleteFuture = original.SnapshotsDeleteFuture
type SnapshotsGrantAccessFuture = original.SnapshotsGrantAccessFuture
type SnapshotsRevokeAccessFuture = original.SnapshotsRevokeAccessFuture
type SnapshotsUpdateFuture = original.SnapshotsUpdateFuture
type SoftDeletePolicy = original.SoftDeletePolicy
type SourceVault = original.SourceVault
type SpotRestorePolicy = original.SpotRestorePolicy
type StatusCodeCount = original.StatusCodeCount
type StorageProfile = original.StorageProfile
type SubResource = original.SubResource
type SubResourceReadOnly = original.SubResourceReadOnly
type SubResourceWithColocationStatus = original.SubResourceWithColocationStatus
type SupportedCapabilities = original.SupportedCapabilities
type SystemData = original.SystemData
type TargetRegion = original.TargetRegion
type TerminateNotificationProfile = original.TerminateNotificationProfile
type ThrottledRequestsInput = original.ThrottledRequestsInput
type UefiSettings = original.UefiSettings
type UpdateDomain = original.UpdateDomain
type UpdateDomainListResult = original.UpdateDomainListResult
type UpdateDomainListResultIterator = original.UpdateDomainListResultIterator
type UpdateDomainListResultPage = original.UpdateDomainListResultPage
type UpdateResource = original.UpdateResource
type UpdateResourceDefinition = original.UpdateResourceDefinition
type UpgradeOperationHistoricalStatusInfo = original.UpgradeOperationHistoricalStatusInfo
type UpgradeOperationHistoricalStatusInfoProperties = original.UpgradeOperationHistoricalStatusInfoProperties
type UpgradeOperationHistoryStatus = original.UpgradeOperationHistoryStatus
type UpgradePolicy = original.UpgradePolicy
type Usage = original.Usage
type UsageClient = original.UsageClient
type UsageName = original.UsageName
type UserArtifactManage = original.UserArtifactManage
type UserArtifactSettings = original.UserArtifactSettings
type UserArtifactSource = original.UserArtifactSource
type UserAssignedIdentitiesValue = original.UserAssignedIdentitiesValue
type VMDiskSecurityProfile = original.VMDiskSecurityProfile
type VMGalleryApplication = original.VMGalleryApplication
type VMImagesInEdgeZoneListResult = original.VMImagesInEdgeZoneListResult
type VMScaleSetConvertToSinglePlacementGroupInput = original.VMScaleSetConvertToSinglePlacementGroupInput
type VMSizeProperties = original.VMSizeProperties
type VaultCertificate = original.VaultCertificate
type VaultSecretGroup = original.VaultSecretGroup
type VirtualHardDisk = original.VirtualHardDisk
type VirtualMachine = original.VirtualMachine
type VirtualMachineAgentInstanceView = original.VirtualMachineAgentInstanceView
type VirtualMachineAssessPatchesResult = original.VirtualMachineAssessPatchesResult
type VirtualMachineCaptureParameters = original.VirtualMachineCaptureParameters
type VirtualMachineCaptureResult = original.VirtualMachineCaptureResult
type VirtualMachineExtension = original.VirtualMachineExtension
type VirtualMachineExtensionHandlerInstanceView = original.VirtualMachineExtensionHandlerInstanceView
type VirtualMachineExtensionImage = original.VirtualMachineExtensionImage
type VirtualMachineExtensionImageProperties = original.VirtualMachineExtensionImageProperties
type VirtualMachineExtensionImagesClient = original.VirtualMachineExtensionImagesClient
type VirtualMachineExtensionInstanceView = original.VirtualMachineExtensionInstanceView
type VirtualMachineExtensionProperties = original.VirtualMachineExtensionProperties
type VirtualMachineExtensionUpdate = original.VirtualMachineExtensionUpdate
type VirtualMachineExtensionUpdateProperties = original.VirtualMachineExtensionUpdateProperties
type VirtualMachineExtensionsClient = original.VirtualMachineExtensionsClient
type VirtualMachineExtensionsCreateOrUpdateFuture = original.VirtualMachineExtensionsCreateOrUpdateFuture
type VirtualMachineExtensionsDeleteFuture = original.VirtualMachineExtensionsDeleteFuture
type VirtualMachineExtensionsListResult = original.VirtualMachineExtensionsListResult
type VirtualMachineExtensionsUpdateFuture = original.VirtualMachineExtensionsUpdateFuture
type VirtualMachineHealthStatus = original.VirtualMachineHealthStatus
type VirtualMachineIPTag = original.VirtualMachineIPTag
type VirtualMachineIdentity = original.VirtualMachineIdentity
type VirtualMachineImage = original.VirtualMachineImage
type VirtualMachineImageFeature = original.VirtualMachineImageFeature
type VirtualMachineImageProperties = original.VirtualMachineImageProperties
type VirtualMachineImageResource = original.VirtualMachineImageResource
type VirtualMachineImagesClient = original.VirtualMachineImagesClient
type VirtualMachineImagesEdgeZoneClient = original.VirtualMachineImagesEdgeZoneClient
type VirtualMachineInstallPatchesParameters = original.VirtualMachineInstallPatchesParameters
type VirtualMachineInstallPatchesResult = original.VirtualMachineInstallPatchesResult
type VirtualMachineInstanceView = original.VirtualMachineInstanceView
type VirtualMachineListResult = original.VirtualMachineListResult
type VirtualMachineListResultIterator = original.VirtualMachineListResultIterator
type VirtualMachineListResultPage = original.VirtualMachineListResultPage
type VirtualMachineNetworkInterfaceConfiguration = original.VirtualMachineNetworkInterfaceConfiguration
type VirtualMachineNetworkInterfaceConfigurationProperties = original.VirtualMachineNetworkInterfaceConfigurationProperties
type VirtualMachineNetworkInterfaceDNSSettingsConfiguration = original.VirtualMachineNetworkInterfaceDNSSettingsConfiguration
type VirtualMachineNetworkInterfaceIPConfiguration = original.VirtualMachineNetworkInterfaceIPConfiguration
type VirtualMachineNetworkInterfaceIPConfigurationProperties = original.VirtualMachineNetworkInterfaceIPConfigurationProperties
type VirtualMachinePatchStatus = original.VirtualMachinePatchStatus
type VirtualMachineProperties = original.VirtualMachineProperties
type VirtualMachinePublicIPAddressConfiguration = original.VirtualMachinePublicIPAddressConfiguration
type VirtualMachinePublicIPAddressConfigurationProperties = original.VirtualMachinePublicIPAddressConfigurationProperties
type VirtualMachinePublicIPAddressDNSSettingsConfiguration = original.VirtualMachinePublicIPAddressDNSSettingsConfiguration
type VirtualMachineReimageParameters = original.VirtualMachineReimageParameters
type VirtualMachineRunCommand = original.VirtualMachineRunCommand
type VirtualMachineRunCommandInstanceView = original.VirtualMachineRunCommandInstanceView
type VirtualMachineRunCommandProperties = original.VirtualMachineRunCommandProperties
type VirtualMachineRunCommandScriptSource = original.VirtualMachineRunCommandScriptSource
type VirtualMachineRunCommandUpdate = original.VirtualMachineRunCommandUpdate
type VirtualMachineRunCommandsClient = original.VirtualMachineRunCommandsClient
type VirtualMachineRunCommandsCreateOrUpdateFuture = original.VirtualMachineRunCommandsCreateOrUpdateFuture
type VirtualMachineRunCommandsDeleteFuture = original.VirtualMachineRunCommandsDeleteFuture
type VirtualMachineRunCommandsListResult = original.VirtualMachineRunCommandsListResult
type VirtualMachineRunCommandsListResultIterator = original.VirtualMachineRunCommandsListResultIterator
type VirtualMachineRunCommandsListResultPage = original.VirtualMachineRunCommandsListResultPage
type VirtualMachineRunCommandsUpdateFuture = original.VirtualMachineRunCommandsUpdateFuture
type VirtualMachineScaleSet = original.VirtualMachineScaleSet
type VirtualMachineScaleSetDataDisk = original.VirtualMachineScaleSetDataDisk
type VirtualMachineScaleSetExtension = original.VirtualMachineScaleSetExtension
type VirtualMachineScaleSetExtensionListResult = original.VirtualMachineScaleSetExtensionListResult
type VirtualMachineScaleSetExtensionListResultIterator = original.VirtualMachineScaleSetExtensionListResultIterator
type VirtualMachineScaleSetExtensionListResultPage = original.VirtualMachineScaleSetExtensionListResultPage
type VirtualMachineScaleSetExtensionProfile = original.VirtualMachineScaleSetExtensionProfile
type VirtualMachineScaleSetExtensionProperties = original.VirtualMachineScaleSetExtensionProperties
type VirtualMachineScaleSetExtensionUpdate = original.VirtualMachineScaleSetExtensionUpdate
type VirtualMachineScaleSetExtensionsClient = original.VirtualMachineScaleSetExtensionsClient
type VirtualMachineScaleSetExtensionsCreateOrUpdateFuture = original.VirtualMachineScaleSetExtensionsCreateOrUpdateFuture
type VirtualMachineScaleSetExtensionsDeleteFuture = original.VirtualMachineScaleSetExtensionsDeleteFuture
type VirtualMachineScaleSetExtensionsUpdateFuture = original.VirtualMachineScaleSetExtensionsUpdateFuture
type VirtualMachineScaleSetHardwareProfile = original.VirtualMachineScaleSetHardwareProfile
type VirtualMachineScaleSetIPConfiguration = original.VirtualMachineScaleSetIPConfiguration
type VirtualMachineScaleSetIPConfigurationProperties = original.VirtualMachineScaleSetIPConfigurationProperties
type VirtualMachineScaleSetIPTag = original.VirtualMachineScaleSetIPTag
type VirtualMachineScaleSetIdentity = original.VirtualMachineScaleSetIdentity
type VirtualMachineScaleSetInstanceView = original.VirtualMachineScaleSetInstanceView
type VirtualMachineScaleSetInstanceViewStatusesSummary = original.VirtualMachineScaleSetInstanceViewStatusesSummary
type VirtualMachineScaleSetListOSUpgradeHistory = original.VirtualMachineScaleSetListOSUpgradeHistory
type VirtualMachineScaleSetListOSUpgradeHistoryIterator = original.VirtualMachineScaleSetListOSUpgradeHistoryIterator
type VirtualMachineScaleSetListOSUpgradeHistoryPage = original.VirtualMachineScaleSetListOSUpgradeHistoryPage
type VirtualMachineScaleSetListResult = original.VirtualMachineScaleSetListResult
type VirtualMachineScaleSetListResultIterator = original.VirtualMachineScaleSetListResultIterator
type VirtualMachineScaleSetListResultPage = original.VirtualMachineScaleSetListResultPage
type VirtualMachineScaleSetListSkusResult = original.VirtualMachineScaleSetListSkusResult
type VirtualMachineScaleSetListSkusResultIterator = original.VirtualMachineScaleSetListSkusResultIterator
type VirtualMachineScaleSetListSkusResultPage = original.VirtualMachineScaleSetListSkusResultPage
type VirtualMachineScaleSetListWithLinkResult = original.VirtualMachineScaleSetListWithLinkResult
type VirtualMachineScaleSetListWithLinkResultIterator = original.VirtualMachineScaleSetListWithLinkResultIterator
type VirtualMachineScaleSetListWithLinkResultPage = original.VirtualMachineScaleSetListWithLinkResultPage
type VirtualMachineScaleSetManagedDiskParameters = original.VirtualMachineScaleSetManagedDiskParameters
type VirtualMachineScaleSetNetworkConfiguration = original.VirtualMachineScaleSetNetworkConfiguration
type VirtualMachineScaleSetNetworkConfigurationDNSSettings = original.VirtualMachineScaleSetNetworkConfigurationDNSSettings
type VirtualMachineScaleSetNetworkConfigurationProperties = original.VirtualMachineScaleSetNetworkConfigurationProperties
type VirtualMachineScaleSetNetworkProfile = original.VirtualMachineScaleSetNetworkProfile
type VirtualMachineScaleSetOSDisk = original.VirtualMachineScaleSetOSDisk
type VirtualMachineScaleSetOSProfile = original.VirtualMachineScaleSetOSProfile
type VirtualMachineScaleSetProperties = original.VirtualMachineScaleSetProperties
type VirtualMachineScaleSetPublicIPAddressConfiguration = original.VirtualMachineScaleSetPublicIPAddressConfiguration
type VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings = original.VirtualMachineScaleSetPublicIPAddressConfigurationDNSSettings
type VirtualMachineScaleSetPublicIPAddressConfigurationProperties = original.VirtualMachineScaleSetPublicIPAddressConfigurationProperties
type VirtualMachineScaleSetReimageParameters = original.VirtualMachineScaleSetReimageParameters
type VirtualMachineScaleSetRollingUpgradesCancelFuture = original.VirtualMachineScaleSetRollingUpgradesCancelFuture
type VirtualMachineScaleSetRollingUpgradesClient = original.VirtualMachineScaleSetRollingUpgradesClient
type VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture = original.VirtualMachineScaleSetRollingUpgradesStartExtensionUpgradeFuture
type VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture = original.VirtualMachineScaleSetRollingUpgradesStartOSUpgradeFuture
type VirtualMachineScaleSetSku = original.VirtualMachineScaleSetSku
type VirtualMachineScaleSetSkuCapacity = original.VirtualMachineScaleSetSkuCapacity
type VirtualMachineScaleSetStorageProfile = original.VirtualMachineScaleSetStorageProfile
type VirtualMachineScaleSetUpdate = original.VirtualMachineScaleSetUpdate
type VirtualMachineScaleSetUpdateIPConfiguration = original.VirtualMachineScaleSetUpdateIPConfiguration
type VirtualMachineScaleSetUpdateIPConfigurationProperties = original.VirtualMachineScaleSetUpdateIPConfigurationProperties
type VirtualMachineScaleSetUpdateNetworkConfiguration = original.VirtualMachineScaleSetUpdateNetworkConfiguration
type VirtualMachineScaleSetUpdateNetworkConfigurationProperties = original.VirtualMachineScaleSetUpdateNetworkConfigurationProperties
type VirtualMachineScaleSetUpdateNetworkProfile = original.VirtualMachineScaleSetUpdateNetworkProfile
type VirtualMachineScaleSetUpdateOSDisk = original.VirtualMachineScaleSetUpdateOSDisk
type VirtualMachineScaleSetUpdateOSProfile = original.VirtualMachineScaleSetUpdateOSProfile
type VirtualMachineScaleSetUpdateProperties = original.VirtualMachineScaleSetUpdateProperties
type VirtualMachineScaleSetUpdatePublicIPAddressConfiguration = original.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
type VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties = original.VirtualMachineScaleSetUpdatePublicIPAddressConfigurationProperties
type VirtualMachineScaleSetUpdateStorageProfile = original.VirtualMachineScaleSetUpdateStorageProfile
type VirtualMachineScaleSetUpdateVMProfile = original.VirtualMachineScaleSetUpdateVMProfile
type VirtualMachineScaleSetVM = original.VirtualMachineScaleSetVM
type VirtualMachineScaleSetVMExtension = original.VirtualMachineScaleSetVMExtension
type VirtualMachineScaleSetVMExtensionUpdate = original.VirtualMachineScaleSetVMExtensionUpdate
type VirtualMachineScaleSetVMExtensionsClient = original.VirtualMachineScaleSetVMExtensionsClient
type VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture = original.VirtualMachineScaleSetVMExtensionsCreateOrUpdateFuture
type VirtualMachineScaleSetVMExtensionsDeleteFuture = original.VirtualMachineScaleSetVMExtensionsDeleteFuture
type VirtualMachineScaleSetVMExtensionsListResult = original.VirtualMachineScaleSetVMExtensionsListResult
type VirtualMachineScaleSetVMExtensionsSummary = original.VirtualMachineScaleSetVMExtensionsSummary
type VirtualMachineScaleSetVMExtensionsUpdateFuture = original.VirtualMachineScaleSetVMExtensionsUpdateFuture
type VirtualMachineScaleSetVMInstanceIDs = original.VirtualMachineScaleSetVMInstanceIDs
type VirtualMachineScaleSetVMInstanceRequiredIDs = original.VirtualMachineScaleSetVMInstanceRequiredIDs
type VirtualMachineScaleSetVMInstanceView = original.VirtualMachineScaleSetVMInstanceView
type VirtualMachineScaleSetVMListResult = original.VirtualMachineScaleSetVMListResult
type VirtualMachineScaleSetVMListResultIterator = original.VirtualMachineScaleSetVMListResultIterator
type VirtualMachineScaleSetVMListResultPage = original.VirtualMachineScaleSetVMListResultPage
type VirtualMachineScaleSetVMNetworkProfileConfiguration = original.VirtualMachineScaleSetVMNetworkProfileConfiguration
type VirtualMachineScaleSetVMProfile = original.VirtualMachineScaleSetVMProfile
type VirtualMachineScaleSetVMProperties = original.VirtualMachineScaleSetVMProperties
type VirtualMachineScaleSetVMProtectionPolicy = original.VirtualMachineScaleSetVMProtectionPolicy
type VirtualMachineScaleSetVMReimageParameters = original.VirtualMachineScaleSetVMReimageParameters
type VirtualMachineScaleSetVMRunCommandsClient = original.VirtualMachineScaleSetVMRunCommandsClient
type VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture = original.VirtualMachineScaleSetVMRunCommandsCreateOrUpdateFuture
type VirtualMachineScaleSetVMRunCommandsDeleteFuture = original.VirtualMachineScaleSetVMRunCommandsDeleteFuture
type VirtualMachineScaleSetVMRunCommandsUpdateFuture = original.VirtualMachineScaleSetVMRunCommandsUpdateFuture
type VirtualMachineScaleSetVMsClient = original.VirtualMachineScaleSetVMsClient
type VirtualMachineScaleSetVMsDeallocateFuture = original.VirtualMachineScaleSetVMsDeallocateFuture
type VirtualMachineScaleSetVMsDeleteFuture = original.VirtualMachineScaleSetVMsDeleteFuture
type VirtualMachineScaleSetVMsPerformMaintenanceFuture = original.VirtualMachineScaleSetVMsPerformMaintenanceFuture
type VirtualMachineScaleSetVMsPowerOffFuture = original.VirtualMachineScaleSetVMsPowerOffFuture
type VirtualMachineScaleSetVMsRedeployFuture = original.VirtualMachineScaleSetVMsRedeployFuture
type VirtualMachineScaleSetVMsReimageAllFuture = original.VirtualMachineScaleSetVMsReimageAllFuture
type VirtualMachineScaleSetVMsReimageFuture = original.VirtualMachineScaleSetVMsReimageFuture
type VirtualMachineScaleSetVMsRestartFuture = original.VirtualMachineScaleSetVMsRestartFuture
type VirtualMachineScaleSetVMsRunCommandFuture = original.VirtualMachineScaleSetVMsRunCommandFuture
type VirtualMachineScaleSetVMsStartFuture = original.VirtualMachineScaleSetVMsStartFuture
type VirtualMachineScaleSetVMsUpdateFuture = original.VirtualMachineScaleSetVMsUpdateFuture
type VirtualMachineScaleSetsClient = original.VirtualMachineScaleSetsClient
type VirtualMachineScaleSetsCreateOrUpdateFuture = original.VirtualMachineScaleSetsCreateOrUpdateFuture
type VirtualMachineScaleSetsDeallocateFuture = original.VirtualMachineScaleSetsDeallocateFuture
type VirtualMachineScaleSetsDeleteFuture = original.VirtualMachineScaleSetsDeleteFuture
type VirtualMachineScaleSetsDeleteInstancesFuture = original.VirtualMachineScaleSetsDeleteInstancesFuture
type VirtualMachineScaleSetsPerformMaintenanceFuture = original.VirtualMachineScaleSetsPerformMaintenanceFuture
type VirtualMachineScaleSetsPowerOffFuture = original.VirtualMachineScaleSetsPowerOffFuture
type VirtualMachineScaleSetsRedeployFuture = original.VirtualMachineScaleSetsRedeployFuture
type VirtualMachineScaleSetsReimageAllFuture = original.VirtualMachineScaleSetsReimageAllFuture
type VirtualMachineScaleSetsReimageFuture = original.VirtualMachineScaleSetsReimageFuture
type VirtualMachineScaleSetsRestartFuture = original.VirtualMachineScaleSetsRestartFuture
type VirtualMachineScaleSetsSetOrchestrationServiceStateFuture = original.VirtualMachineScaleSetsSetOrchestrationServiceStateFuture
type VirtualMachineScaleSetsStartFuture = original.VirtualMachineScaleSetsStartFuture
type VirtualMachineScaleSetsUpdateFuture = original.VirtualMachineScaleSetsUpdateFuture
type VirtualMachineScaleSetsUpdateInstancesFuture = original.VirtualMachineScaleSetsUpdateInstancesFuture
type VirtualMachineSize = original.VirtualMachineSize
type VirtualMachineSizeListResult = original.VirtualMachineSizeListResult
type VirtualMachineSizesClient = original.VirtualMachineSizesClient
type VirtualMachineSoftwarePatchProperties = original.VirtualMachineSoftwarePatchProperties
type VirtualMachineStatusCodeCount = original.VirtualMachineStatusCodeCount
type VirtualMachineUpdate = original.VirtualMachineUpdate
type VirtualMachinesAssessPatchesFuture = original.VirtualMachinesAssessPatchesFuture
type VirtualMachinesCaptureFuture = original.VirtualMachinesCaptureFuture
type VirtualMachinesClient = original.VirtualMachinesClient
type VirtualMachinesConvertToManagedDisksFuture = original.VirtualMachinesConvertToManagedDisksFuture
type VirtualMachinesCreateOrUpdateFuture = original.VirtualMachinesCreateOrUpdateFuture
type VirtualMachinesDeallocateFuture = original.VirtualMachinesDeallocateFuture
type VirtualMachinesDeleteFuture = original.VirtualMachinesDeleteFuture
type VirtualMachinesInstallPatchesFuture = original.VirtualMachinesInstallPatchesFuture
type VirtualMachinesPerformMaintenanceFuture = original.VirtualMachinesPerformMaintenanceFuture
type VirtualMachinesPowerOffFuture = original.VirtualMachinesPowerOffFuture
type VirtualMachinesReapplyFuture = original.VirtualMachinesReapplyFuture
type VirtualMachinesRedeployFuture = original.VirtualMachinesRedeployFuture
type VirtualMachinesReimageFuture = original.VirtualMachinesReimageFuture
type VirtualMachinesRestartFuture = original.VirtualMachinesRestartFuture
type VirtualMachinesRunCommandFuture = original.VirtualMachinesRunCommandFuture
type VirtualMachinesStartFuture = original.VirtualMachinesStartFuture
type VirtualMachinesUpdateFuture = original.VirtualMachinesUpdateFuture
type WinRMConfiguration = original.WinRMConfiguration
type WinRMListener = original.WinRMListener
type WindowsConfiguration = original.WindowsConfiguration
type WindowsParameters = original.WindowsParameters
type WindowsVMGuestPatchAutomaticByPlatformSettings = original.WindowsVMGuestPatchAutomaticByPlatformSettings

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAvailabilitySetListResultIterator(page AvailabilitySetListResultPage) AvailabilitySetListResultIterator {
	return original.NewAvailabilitySetListResultIterator(page)
}
func NewAvailabilitySetListResultPage(cur AvailabilitySetListResult, getNextPage func(context.Context, AvailabilitySetListResult) (AvailabilitySetListResult, error)) AvailabilitySetListResultPage {
	return original.NewAvailabilitySetListResultPage(cur, getNextPage)
}
func NewAvailabilitySetsClient(subscriptionID string) AvailabilitySetsClient {
	return original.NewAvailabilitySetsClient(subscriptionID)
}
func NewAvailabilitySetsClientWithBaseURI(baseURI string, subscriptionID string) AvailabilitySetsClient {
	return original.NewAvailabilitySetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCapacityReservationGroupListResultIterator(page CapacityReservationGroupListResultPage) CapacityReservationGroupListResultIterator {
	return original.NewCapacityReservationGroupListResultIterator(page)
}
func NewCapacityReservationGroupListResultPage(cur CapacityReservationGroupListResult, getNextPage func(context.Context, CapacityReservationGroupListResult) (CapacityReservationGroupListResult, error)) CapacityReservationGroupListResultPage {
	return original.NewCapacityReservationGroupListResultPage(cur, getNextPage)
}
func NewCapacityReservationGroupsClient(subscriptionID string) CapacityReservationGroupsClient {
	return original.NewCapacityReservationGroupsClient(subscriptionID)
}
func NewCapacityReservationGroupsClientWithBaseURI(baseURI string, subscriptionID string) CapacityReservationGroupsClient {
	return original.NewCapacityReservationGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCapacityReservationListResultIterator(page CapacityReservationListResultPage) CapacityReservationListResultIterator {
	return original.NewCapacityReservationListResultIterator(page)
}
func NewCapacityReservationListResultPage(cur CapacityReservationListResult, getNextPage func(context.Context, CapacityReservationListResult) (CapacityReservationListResult, error)) CapacityReservationListResultPage {
	return original.NewCapacityReservationListResultPage(cur, getNextPage)
}
func NewCapacityReservationsClient(subscriptionID string) CapacityReservationsClient {
	return original.NewCapacityReservationsClient(subscriptionID)
}
func NewCapacityReservationsClientWithBaseURI(baseURI string, subscriptionID string) CapacityReservationsClient {
	return original.NewCapacityReservationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCloudServiceListResultIterator(page CloudServiceListResultPage) CloudServiceListResultIterator {
	return original.NewCloudServiceListResultIterator(page)
}
func NewCloudServiceListResultPage(cur CloudServiceListResult, getNextPage func(context.Context, CloudServiceListResult) (CloudServiceListResult, error)) CloudServiceListResultPage {
	return original.NewCloudServiceListResultPage(cur, getNextPage)
}
func NewCloudServiceOperatingSystemsClient(subscriptionID string) CloudServiceOperatingSystemsClient {
	return original.NewCloudServiceOperatingSystemsClient(subscriptionID)
}
func NewCloudServiceOperatingSystemsClientWithBaseURI(baseURI string, subscriptionID string) CloudServiceOperatingSystemsClient {
	return original.NewCloudServiceOperatingSystemsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCloudServiceRoleInstancesClient(subscriptionID string) CloudServiceRoleInstancesClient {
	return original.NewCloudServiceRoleInstancesClient(subscriptionID)
}
func NewCloudServiceRoleInstancesClientWithBaseURI(baseURI string, subscriptionID string) CloudServiceRoleInstancesClient {
	return original.NewCloudServiceRoleInstancesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCloudServiceRoleListResultIterator(page CloudServiceRoleListResultPage) CloudServiceRoleListResultIterator {
	return original.NewCloudServiceRoleListResultIterator(page)
}
func NewCloudServiceRoleListResultPage(cur CloudServiceRoleListResult, getNextPage func(context.Context, CloudServiceRoleListResult) (CloudServiceRoleListResult, error)) CloudServiceRoleListResultPage {
	return original.NewCloudServiceRoleListResultPage(cur, getNextPage)
}
func NewCloudServiceRolesClient(subscriptionID string) CloudServiceRolesClient {
	return original.NewCloudServiceRolesClient(subscriptionID)
}
func NewCloudServiceRolesClientWithBaseURI(baseURI string, subscriptionID string) CloudServiceRolesClient {
	return original.NewCloudServiceRolesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCloudServicesClient(subscriptionID string) CloudServicesClient {
	return original.NewCloudServicesClient(subscriptionID)
}
func NewCloudServicesClientWithBaseURI(baseURI string, subscriptionID string) CloudServicesClient {
	return original.NewCloudServicesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCloudServicesUpdateDomainClient(subscriptionID string) CloudServicesUpdateDomainClient {
	return original.NewCloudServicesUpdateDomainClient(subscriptionID)
}
func NewCloudServicesUpdateDomainClientWithBaseURI(baseURI string, subscriptionID string) CloudServicesUpdateDomainClient {
	return original.NewCloudServicesUpdateDomainClientWithBaseURI(baseURI, subscriptionID)
}
func NewCommunityGalleriesClient(subscriptionID string) CommunityGalleriesClient {
	return original.NewCommunityGalleriesClient(subscriptionID)
}
func NewCommunityGalleriesClientWithBaseURI(baseURI string, subscriptionID string) CommunityGalleriesClient {
	return original.NewCommunityGalleriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewCommunityGalleryImageListIterator(page CommunityGalleryImageListPage) CommunityGalleryImageListIterator {
	return original.NewCommunityGalleryImageListIterator(page)
}
func NewCommunityGalleryImageListPage(cur CommunityGalleryImageList, getNextPage func(context.Context, CommunityGalleryImageList) (CommunityGalleryImageList, error)) CommunityGalleryImageListPage {
	return original.NewCommunityGalleryImageListPage(cur, getNextPage)
}
func NewCommunityGalleryImageVersionListIterator(page CommunityGalleryImageVersionListPage) CommunityGalleryImageVersionListIterator {
	return original.NewCommunityGalleryImageVersionListIterator(page)
}
func NewCommunityGalleryImageVersionListPage(cur CommunityGalleryImageVersionList, getNextPage func(context.Context, CommunityGalleryImageVersionList) (CommunityGalleryImageVersionList, error)) CommunityGalleryImageVersionListPage {
	return original.NewCommunityGalleryImageVersionListPage(cur, getNextPage)
}
func NewCommunityGalleryImageVersionsClient(subscriptionID string) CommunityGalleryImageVersionsClient {
	return original.NewCommunityGalleryImageVersionsClient(subscriptionID)
}
func NewCommunityGalleryImageVersionsClientWithBaseURI(baseURI string, subscriptionID string) CommunityGalleryImageVersionsClient {
	return original.NewCommunityGalleryImageVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewCommunityGalleryImagesClient(subscriptionID string) CommunityGalleryImagesClient {
	return original.NewCommunityGalleryImagesClient(subscriptionID)
}
func NewCommunityGalleryImagesClientWithBaseURI(baseURI string, subscriptionID string) CommunityGalleryImagesClient {
	return original.NewCommunityGalleryImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDedicatedHostGroupListResultIterator(page DedicatedHostGroupListResultPage) DedicatedHostGroupListResultIterator {
	return original.NewDedicatedHostGroupListResultIterator(page)
}
func NewDedicatedHostGroupListResultPage(cur DedicatedHostGroupListResult, getNextPage func(context.Context, DedicatedHostGroupListResult) (DedicatedHostGroupListResult, error)) DedicatedHostGroupListResultPage {
	return original.NewDedicatedHostGroupListResultPage(cur, getNextPage)
}
func NewDedicatedHostGroupsClient(subscriptionID string) DedicatedHostGroupsClient {
	return original.NewDedicatedHostGroupsClient(subscriptionID)
}
func NewDedicatedHostGroupsClientWithBaseURI(baseURI string, subscriptionID string) DedicatedHostGroupsClient {
	return original.NewDedicatedHostGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDedicatedHostListResultIterator(page DedicatedHostListResultPage) DedicatedHostListResultIterator {
	return original.NewDedicatedHostListResultIterator(page)
}
func NewDedicatedHostListResultPage(cur DedicatedHostListResult, getNextPage func(context.Context, DedicatedHostListResult) (DedicatedHostListResult, error)) DedicatedHostListResultPage {
	return original.NewDedicatedHostListResultPage(cur, getNextPage)
}
func NewDedicatedHostsClient(subscriptionID string) DedicatedHostsClient {
	return original.NewDedicatedHostsClient(subscriptionID)
}
func NewDedicatedHostsClientWithBaseURI(baseURI string, subscriptionID string) DedicatedHostsClient {
	return original.NewDedicatedHostsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskAccessListIterator(page DiskAccessListPage) DiskAccessListIterator {
	return original.NewDiskAccessListIterator(page)
}
func NewDiskAccessListPage(cur DiskAccessList, getNextPage func(context.Context, DiskAccessList) (DiskAccessList, error)) DiskAccessListPage {
	return original.NewDiskAccessListPage(cur, getNextPage)
}
func NewDiskAccessesClient(subscriptionID string) DiskAccessesClient {
	return original.NewDiskAccessesClient(subscriptionID)
}
func NewDiskAccessesClientWithBaseURI(baseURI string, subscriptionID string) DiskAccessesClient {
	return original.NewDiskAccessesClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskEncryptionSetListIterator(page DiskEncryptionSetListPage) DiskEncryptionSetListIterator {
	return original.NewDiskEncryptionSetListIterator(page)
}
func NewDiskEncryptionSetListPage(cur DiskEncryptionSetList, getNextPage func(context.Context, DiskEncryptionSetList) (DiskEncryptionSetList, error)) DiskEncryptionSetListPage {
	return original.NewDiskEncryptionSetListPage(cur, getNextPage)
}
func NewDiskEncryptionSetsClient(subscriptionID string) DiskEncryptionSetsClient {
	return original.NewDiskEncryptionSetsClient(subscriptionID)
}
func NewDiskEncryptionSetsClientWithBaseURI(baseURI string, subscriptionID string) DiskEncryptionSetsClient {
	return original.NewDiskEncryptionSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskListIterator(page DiskListPage) DiskListIterator {
	return original.NewDiskListIterator(page)
}
func NewDiskListPage(cur DiskList, getNextPage func(context.Context, DiskList) (DiskList, error)) DiskListPage {
	return original.NewDiskListPage(cur, getNextPage)
}
func NewDiskRestorePointClient(subscriptionID string) DiskRestorePointClient {
	return original.NewDiskRestorePointClient(subscriptionID)
}
func NewDiskRestorePointClientWithBaseURI(baseURI string, subscriptionID string) DiskRestorePointClient {
	return original.NewDiskRestorePointClientWithBaseURI(baseURI, subscriptionID)
}
func NewDiskRestorePointListIterator(page DiskRestorePointListPage) DiskRestorePointListIterator {
	return original.NewDiskRestorePointListIterator(page)
}
func NewDiskRestorePointListPage(cur DiskRestorePointList, getNextPage func(context.Context, DiskRestorePointList) (DiskRestorePointList, error)) DiskRestorePointListPage {
	return original.NewDiskRestorePointListPage(cur, getNextPage)
}
func NewDisksClient(subscriptionID string) DisksClient {
	return original.NewDisksClient(subscriptionID)
}
func NewDisksClientWithBaseURI(baseURI string, subscriptionID string) DisksClient {
	return original.NewDisksClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleriesClient(subscriptionID string) GalleriesClient {
	return original.NewGalleriesClient(subscriptionID)
}
func NewGalleriesClientWithBaseURI(baseURI string, subscriptionID string) GalleriesClient {
	return original.NewGalleriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryApplicationListIterator(page GalleryApplicationListPage) GalleryApplicationListIterator {
	return original.NewGalleryApplicationListIterator(page)
}
func NewGalleryApplicationListPage(cur GalleryApplicationList, getNextPage func(context.Context, GalleryApplicationList) (GalleryApplicationList, error)) GalleryApplicationListPage {
	return original.NewGalleryApplicationListPage(cur, getNextPage)
}
func NewGalleryApplicationVersionListIterator(page GalleryApplicationVersionListPage) GalleryApplicationVersionListIterator {
	return original.NewGalleryApplicationVersionListIterator(page)
}
func NewGalleryApplicationVersionListPage(cur GalleryApplicationVersionList, getNextPage func(context.Context, GalleryApplicationVersionList) (GalleryApplicationVersionList, error)) GalleryApplicationVersionListPage {
	return original.NewGalleryApplicationVersionListPage(cur, getNextPage)
}
func NewGalleryApplicationVersionsClient(subscriptionID string) GalleryApplicationVersionsClient {
	return original.NewGalleryApplicationVersionsClient(subscriptionID)
}
func NewGalleryApplicationVersionsClientWithBaseURI(baseURI string, subscriptionID string) GalleryApplicationVersionsClient {
	return original.NewGalleryApplicationVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryApplicationsClient(subscriptionID string) GalleryApplicationsClient {
	return original.NewGalleryApplicationsClient(subscriptionID)
}
func NewGalleryApplicationsClientWithBaseURI(baseURI string, subscriptionID string) GalleryApplicationsClient {
	return original.NewGalleryApplicationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryImageListIterator(page GalleryImageListPage) GalleryImageListIterator {
	return original.NewGalleryImageListIterator(page)
}
func NewGalleryImageListPage(cur GalleryImageList, getNextPage func(context.Context, GalleryImageList) (GalleryImageList, error)) GalleryImageListPage {
	return original.NewGalleryImageListPage(cur, getNextPage)
}
func NewGalleryImageVersionListIterator(page GalleryImageVersionListPage) GalleryImageVersionListIterator {
	return original.NewGalleryImageVersionListIterator(page)
}
func NewGalleryImageVersionListPage(cur GalleryImageVersionList, getNextPage func(context.Context, GalleryImageVersionList) (GalleryImageVersionList, error)) GalleryImageVersionListPage {
	return original.NewGalleryImageVersionListPage(cur, getNextPage)
}
func NewGalleryImageVersionsClient(subscriptionID string) GalleryImageVersionsClient {
	return original.NewGalleryImageVersionsClient(subscriptionID)
}
func NewGalleryImageVersionsClientWithBaseURI(baseURI string, subscriptionID string) GalleryImageVersionsClient {
	return original.NewGalleryImageVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryImagesClient(subscriptionID string) GalleryImagesClient {
	return original.NewGalleryImagesClient(subscriptionID)
}
func NewGalleryImagesClientWithBaseURI(baseURI string, subscriptionID string) GalleryImagesClient {
	return original.NewGalleryImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewGalleryListIterator(page GalleryListPage) GalleryListIterator {
	return original.NewGalleryListIterator(page)
}
func NewGalleryListPage(cur GalleryList, getNextPage func(context.Context, GalleryList) (GalleryList, error)) GalleryListPage {
	return original.NewGalleryListPage(cur, getNextPage)
}
func NewGallerySharingProfileClient(subscriptionID string) GallerySharingProfileClient {
	return original.NewGallerySharingProfileClient(subscriptionID)
}
func NewGallerySharingProfileClientWithBaseURI(baseURI string, subscriptionID string) GallerySharingProfileClient {
	return original.NewGallerySharingProfileClientWithBaseURI(baseURI, subscriptionID)
}
func NewImageListResultIterator(page ImageListResultPage) ImageListResultIterator {
	return original.NewImageListResultIterator(page)
}
func NewImageListResultPage(cur ImageListResult, getNextPage func(context.Context, ImageListResult) (ImageListResult, error)) ImageListResultPage {
	return original.NewImageListResultPage(cur, getNextPage)
}
func NewImagesClient(subscriptionID string) ImagesClient {
	return original.NewImagesClient(subscriptionID)
}
func NewImagesClientWithBaseURI(baseURI string, subscriptionID string) ImagesClient {
	return original.NewImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewListUsagesResultIterator(page ListUsagesResultPage) ListUsagesResultIterator {
	return original.NewListUsagesResultIterator(page)
}
func NewListUsagesResultPage(cur ListUsagesResult, getNextPage func(context.Context, ListUsagesResult) (ListUsagesResult, error)) ListUsagesResultPage {
	return original.NewListUsagesResultPage(cur, getNextPage)
}
func NewLogAnalyticsClient(subscriptionID string) LogAnalyticsClient {
	return original.NewLogAnalyticsClient(subscriptionID)
}
func NewLogAnalyticsClientWithBaseURI(baseURI string, subscriptionID string) LogAnalyticsClient {
	return original.NewLogAnalyticsClientWithBaseURI(baseURI, subscriptionID)
}
func NewOSFamilyListResultIterator(page OSFamilyListResultPage) OSFamilyListResultIterator {
	return original.NewOSFamilyListResultIterator(page)
}
func NewOSFamilyListResultPage(cur OSFamilyListResult, getNextPage func(context.Context, OSFamilyListResult) (OSFamilyListResult, error)) OSFamilyListResultPage {
	return original.NewOSFamilyListResultPage(cur, getNextPage)
}
func NewOSVersionListResultIterator(page OSVersionListResultPage) OSVersionListResultIterator {
	return original.NewOSVersionListResultIterator(page)
}
func NewOSVersionListResultPage(cur OSVersionListResult, getNextPage func(context.Context, OSVersionListResult) (OSVersionListResult, error)) OSVersionListResultPage {
	return original.NewOSVersionListResultPage(cur, getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewPrivateEndpointConnectionListResultIterator(page PrivateEndpointConnectionListResultPage) PrivateEndpointConnectionListResultIterator {
	return original.NewPrivateEndpointConnectionListResultIterator(page)
}
func NewPrivateEndpointConnectionListResultPage(cur PrivateEndpointConnectionListResult, getNextPage func(context.Context, PrivateEndpointConnectionListResult) (PrivateEndpointConnectionListResult, error)) PrivateEndpointConnectionListResultPage {
	return original.NewPrivateEndpointConnectionListResultPage(cur, getNextPage)
}
func NewProximityPlacementGroupListResultIterator(page ProximityPlacementGroupListResultPage) ProximityPlacementGroupListResultIterator {
	return original.NewProximityPlacementGroupListResultIterator(page)
}
func NewProximityPlacementGroupListResultPage(cur ProximityPlacementGroupListResult, getNextPage func(context.Context, ProximityPlacementGroupListResult) (ProximityPlacementGroupListResult, error)) ProximityPlacementGroupListResultPage {
	return original.NewProximityPlacementGroupListResultPage(cur, getNextPage)
}
func NewProximityPlacementGroupsClient(subscriptionID string) ProximityPlacementGroupsClient {
	return original.NewProximityPlacementGroupsClient(subscriptionID)
}
func NewProximityPlacementGroupsClientWithBaseURI(baseURI string, subscriptionID string) ProximityPlacementGroupsClient {
	return original.NewProximityPlacementGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkusClient(subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClient(subscriptionID)
}
func NewResourceSkusClientWithBaseURI(baseURI string, subscriptionID string) ResourceSkusClient {
	return original.NewResourceSkusClientWithBaseURI(baseURI, subscriptionID)
}
func NewResourceSkusResultIterator(page ResourceSkusResultPage) ResourceSkusResultIterator {
	return original.NewResourceSkusResultIterator(page)
}
func NewResourceSkusResultPage(cur ResourceSkusResult, getNextPage func(context.Context, ResourceSkusResult) (ResourceSkusResult, error)) ResourceSkusResultPage {
	return original.NewResourceSkusResultPage(cur, getNextPage)
}
func NewResourceURIListIterator(page ResourceURIListPage) ResourceURIListIterator {
	return original.NewResourceURIListIterator(page)
}
func NewResourceURIListPage(cur ResourceURIList, getNextPage func(context.Context, ResourceURIList) (ResourceURIList, error)) ResourceURIListPage {
	return original.NewResourceURIListPage(cur, getNextPage)
}
func NewRestorePointCollectionListResultIterator(page RestorePointCollectionListResultPage) RestorePointCollectionListResultIterator {
	return original.NewRestorePointCollectionListResultIterator(page)
}
func NewRestorePointCollectionListResultPage(cur RestorePointCollectionListResult, getNextPage func(context.Context, RestorePointCollectionListResult) (RestorePointCollectionListResult, error)) RestorePointCollectionListResultPage {
	return original.NewRestorePointCollectionListResultPage(cur, getNextPage)
}
func NewRestorePointCollectionsClient(subscriptionID string) RestorePointCollectionsClient {
	return original.NewRestorePointCollectionsClient(subscriptionID)
}
func NewRestorePointCollectionsClientWithBaseURI(baseURI string, subscriptionID string) RestorePointCollectionsClient {
	return original.NewRestorePointCollectionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRestorePointsClient(subscriptionID string) RestorePointsClient {
	return original.NewRestorePointsClient(subscriptionID)
}
func NewRestorePointsClientWithBaseURI(baseURI string, subscriptionID string) RestorePointsClient {
	return original.NewRestorePointsClientWithBaseURI(baseURI, subscriptionID)
}
func NewRoleInstanceListResultIterator(page RoleInstanceListResultPage) RoleInstanceListResultIterator {
	return original.NewRoleInstanceListResultIterator(page)
}
func NewRoleInstanceListResultPage(cur RoleInstanceListResult, getNextPage func(context.Context, RoleInstanceListResult) (RoleInstanceListResult, error)) RoleInstanceListResultPage {
	return original.NewRoleInstanceListResultPage(cur, getNextPage)
}
func NewRunCommandListResultIterator(page RunCommandListResultPage) RunCommandListResultIterator {
	return original.NewRunCommandListResultIterator(page)
}
func NewRunCommandListResultPage(cur RunCommandListResult, getNextPage func(context.Context, RunCommandListResult) (RunCommandListResult, error)) RunCommandListResultPage {
	return original.NewRunCommandListResultPage(cur, getNextPage)
}
func NewSSHPublicKeysClient(subscriptionID string) SSHPublicKeysClient {
	return original.NewSSHPublicKeysClient(subscriptionID)
}
func NewSSHPublicKeysClientWithBaseURI(baseURI string, subscriptionID string) SSHPublicKeysClient {
	return original.NewSSHPublicKeysClientWithBaseURI(baseURI, subscriptionID)
}
func NewSSHPublicKeysGroupListResultIterator(page SSHPublicKeysGroupListResultPage) SSHPublicKeysGroupListResultIterator {
	return original.NewSSHPublicKeysGroupListResultIterator(page)
}
func NewSSHPublicKeysGroupListResultPage(cur SSHPublicKeysGroupListResult, getNextPage func(context.Context, SSHPublicKeysGroupListResult) (SSHPublicKeysGroupListResult, error)) SSHPublicKeysGroupListResultPage {
	return original.NewSSHPublicKeysGroupListResultPage(cur, getNextPage)
}
func NewSharedGalleriesClient(subscriptionID string) SharedGalleriesClient {
	return original.NewSharedGalleriesClient(subscriptionID)
}
func NewSharedGalleriesClientWithBaseURI(baseURI string, subscriptionID string) SharedGalleriesClient {
	return original.NewSharedGalleriesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSharedGalleryImageListIterator(page SharedGalleryImageListPage) SharedGalleryImageListIterator {
	return original.NewSharedGalleryImageListIterator(page)
}
func NewSharedGalleryImageListPage(cur SharedGalleryImageList, getNextPage func(context.Context, SharedGalleryImageList) (SharedGalleryImageList, error)) SharedGalleryImageListPage {
	return original.NewSharedGalleryImageListPage(cur, getNextPage)
}
func NewSharedGalleryImageVersionListIterator(page SharedGalleryImageVersionListPage) SharedGalleryImageVersionListIterator {
	return original.NewSharedGalleryImageVersionListIterator(page)
}
func NewSharedGalleryImageVersionListPage(cur SharedGalleryImageVersionList, getNextPage func(context.Context, SharedGalleryImageVersionList) (SharedGalleryImageVersionList, error)) SharedGalleryImageVersionListPage {
	return original.NewSharedGalleryImageVersionListPage(cur, getNextPage)
}
func NewSharedGalleryImageVersionsClient(subscriptionID string) SharedGalleryImageVersionsClient {
	return original.NewSharedGalleryImageVersionsClient(subscriptionID)
}
func NewSharedGalleryImageVersionsClientWithBaseURI(baseURI string, subscriptionID string) SharedGalleryImageVersionsClient {
	return original.NewSharedGalleryImageVersionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSharedGalleryImagesClient(subscriptionID string) SharedGalleryImagesClient {
	return original.NewSharedGalleryImagesClient(subscriptionID)
}
func NewSharedGalleryImagesClientWithBaseURI(baseURI string, subscriptionID string) SharedGalleryImagesClient {
	return original.NewSharedGalleryImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewSharedGalleryListIterator(page SharedGalleryListPage) SharedGalleryListIterator {
	return original.NewSharedGalleryListIterator(page)
}
func NewSharedGalleryListPage(cur SharedGalleryList, getNextPage func(context.Context, SharedGalleryList) (SharedGalleryList, error)) SharedGalleryListPage {
	return original.NewSharedGalleryListPage(cur, getNextPage)
}
func NewSnapshotListIterator(page SnapshotListPage) SnapshotListIterator {
	return original.NewSnapshotListIterator(page)
}
func NewSnapshotListPage(cur SnapshotList, getNextPage func(context.Context, SnapshotList) (SnapshotList, error)) SnapshotListPage {
	return original.NewSnapshotListPage(cur, getNextPage)
}
func NewSnapshotsClient(subscriptionID string) SnapshotsClient {
	return original.NewSnapshotsClient(subscriptionID)
}
func NewSnapshotsClientWithBaseURI(baseURI string, subscriptionID string) SnapshotsClient {
	return original.NewSnapshotsClientWithBaseURI(baseURI, subscriptionID)
}
func NewUpdateDomainListResultIterator(page UpdateDomainListResultPage) UpdateDomainListResultIterator {
	return original.NewUpdateDomainListResultIterator(page)
}
func NewUpdateDomainListResultPage(cur UpdateDomainListResult, getNextPage func(context.Context, UpdateDomainListResult) (UpdateDomainListResult, error)) UpdateDomainListResultPage {
	return original.NewUpdateDomainListResultPage(cur, getNextPage)
}
func NewUsageClient(subscriptionID string) UsageClient {
	return original.NewUsageClient(subscriptionID)
}
func NewUsageClientWithBaseURI(baseURI string, subscriptionID string) UsageClient {
	return original.NewUsageClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineExtensionImagesClient(subscriptionID string) VirtualMachineExtensionImagesClient {
	return original.NewVirtualMachineExtensionImagesClient(subscriptionID)
}
func NewVirtualMachineExtensionImagesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineExtensionImagesClient {
	return original.NewVirtualMachineExtensionImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineExtensionsClient(subscriptionID string) VirtualMachineExtensionsClient {
	return original.NewVirtualMachineExtensionsClient(subscriptionID)
}
func NewVirtualMachineExtensionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineExtensionsClient {
	return original.NewVirtualMachineExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineImagesClient(subscriptionID string) VirtualMachineImagesClient {
	return original.NewVirtualMachineImagesClient(subscriptionID)
}
func NewVirtualMachineImagesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineImagesClient {
	return original.NewVirtualMachineImagesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineImagesEdgeZoneClient(subscriptionID string) VirtualMachineImagesEdgeZoneClient {
	return original.NewVirtualMachineImagesEdgeZoneClient(subscriptionID)
}
func NewVirtualMachineImagesEdgeZoneClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineImagesEdgeZoneClient {
	return original.NewVirtualMachineImagesEdgeZoneClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineListResultIterator(page VirtualMachineListResultPage) VirtualMachineListResultIterator {
	return original.NewVirtualMachineListResultIterator(page)
}
func NewVirtualMachineListResultPage(cur VirtualMachineListResult, getNextPage func(context.Context, VirtualMachineListResult) (VirtualMachineListResult, error)) VirtualMachineListResultPage {
	return original.NewVirtualMachineListResultPage(cur, getNextPage)
}
func NewVirtualMachineRunCommandsClient(subscriptionID string) VirtualMachineRunCommandsClient {
	return original.NewVirtualMachineRunCommandsClient(subscriptionID)
}
func NewVirtualMachineRunCommandsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineRunCommandsClient {
	return original.NewVirtualMachineRunCommandsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineRunCommandsListResultIterator(page VirtualMachineRunCommandsListResultPage) VirtualMachineRunCommandsListResultIterator {
	return original.NewVirtualMachineRunCommandsListResultIterator(page)
}
func NewVirtualMachineRunCommandsListResultPage(cur VirtualMachineRunCommandsListResult, getNextPage func(context.Context, VirtualMachineRunCommandsListResult) (VirtualMachineRunCommandsListResult, error)) VirtualMachineRunCommandsListResultPage {
	return original.NewVirtualMachineRunCommandsListResultPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetExtensionListResultIterator(page VirtualMachineScaleSetExtensionListResultPage) VirtualMachineScaleSetExtensionListResultIterator {
	return original.NewVirtualMachineScaleSetExtensionListResultIterator(page)
}
func NewVirtualMachineScaleSetExtensionListResultPage(cur VirtualMachineScaleSetExtensionListResult, getNextPage func(context.Context, VirtualMachineScaleSetExtensionListResult) (VirtualMachineScaleSetExtensionListResult, error)) VirtualMachineScaleSetExtensionListResultPage {
	return original.NewVirtualMachineScaleSetExtensionListResultPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetExtensionsClient(subscriptionID string) VirtualMachineScaleSetExtensionsClient {
	return original.NewVirtualMachineScaleSetExtensionsClient(subscriptionID)
}
func NewVirtualMachineScaleSetExtensionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetExtensionsClient {
	return original.NewVirtualMachineScaleSetExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetListOSUpgradeHistoryIterator(page VirtualMachineScaleSetListOSUpgradeHistoryPage) VirtualMachineScaleSetListOSUpgradeHistoryIterator {
	return original.NewVirtualMachineScaleSetListOSUpgradeHistoryIterator(page)
}
func NewVirtualMachineScaleSetListOSUpgradeHistoryPage(cur VirtualMachineScaleSetListOSUpgradeHistory, getNextPage func(context.Context, VirtualMachineScaleSetListOSUpgradeHistory) (VirtualMachineScaleSetListOSUpgradeHistory, error)) VirtualMachineScaleSetListOSUpgradeHistoryPage {
	return original.NewVirtualMachineScaleSetListOSUpgradeHistoryPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetListResultIterator(page VirtualMachineScaleSetListResultPage) VirtualMachineScaleSetListResultIterator {
	return original.NewVirtualMachineScaleSetListResultIterator(page)
}
func NewVirtualMachineScaleSetListResultPage(cur VirtualMachineScaleSetListResult, getNextPage func(context.Context, VirtualMachineScaleSetListResult) (VirtualMachineScaleSetListResult, error)) VirtualMachineScaleSetListResultPage {
	return original.NewVirtualMachineScaleSetListResultPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetListSkusResultIterator(page VirtualMachineScaleSetListSkusResultPage) VirtualMachineScaleSetListSkusResultIterator {
	return original.NewVirtualMachineScaleSetListSkusResultIterator(page)
}
func NewVirtualMachineScaleSetListSkusResultPage(cur VirtualMachineScaleSetListSkusResult, getNextPage func(context.Context, VirtualMachineScaleSetListSkusResult) (VirtualMachineScaleSetListSkusResult, error)) VirtualMachineScaleSetListSkusResultPage {
	return original.NewVirtualMachineScaleSetListSkusResultPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetListWithLinkResultIterator(page VirtualMachineScaleSetListWithLinkResultPage) VirtualMachineScaleSetListWithLinkResultIterator {
	return original.NewVirtualMachineScaleSetListWithLinkResultIterator(page)
}
func NewVirtualMachineScaleSetListWithLinkResultPage(cur VirtualMachineScaleSetListWithLinkResult, getNextPage func(context.Context, VirtualMachineScaleSetListWithLinkResult) (VirtualMachineScaleSetListWithLinkResult, error)) VirtualMachineScaleSetListWithLinkResultPage {
	return original.NewVirtualMachineScaleSetListWithLinkResultPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetRollingUpgradesClient(subscriptionID string) VirtualMachineScaleSetRollingUpgradesClient {
	return original.NewVirtualMachineScaleSetRollingUpgradesClient(subscriptionID)
}
func NewVirtualMachineScaleSetRollingUpgradesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetRollingUpgradesClient {
	return original.NewVirtualMachineScaleSetRollingUpgradesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetVMExtensionsClient(subscriptionID string) VirtualMachineScaleSetVMExtensionsClient {
	return original.NewVirtualMachineScaleSetVMExtensionsClient(subscriptionID)
}
func NewVirtualMachineScaleSetVMExtensionsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetVMExtensionsClient {
	return original.NewVirtualMachineScaleSetVMExtensionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetVMListResultIterator(page VirtualMachineScaleSetVMListResultPage) VirtualMachineScaleSetVMListResultIterator {
	return original.NewVirtualMachineScaleSetVMListResultIterator(page)
}
func NewVirtualMachineScaleSetVMListResultPage(cur VirtualMachineScaleSetVMListResult, getNextPage func(context.Context, VirtualMachineScaleSetVMListResult) (VirtualMachineScaleSetVMListResult, error)) VirtualMachineScaleSetVMListResultPage {
	return original.NewVirtualMachineScaleSetVMListResultPage(cur, getNextPage)
}
func NewVirtualMachineScaleSetVMRunCommandsClient(subscriptionID string) VirtualMachineScaleSetVMRunCommandsClient {
	return original.NewVirtualMachineScaleSetVMRunCommandsClient(subscriptionID)
}
func NewVirtualMachineScaleSetVMRunCommandsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetVMRunCommandsClient {
	return original.NewVirtualMachineScaleSetVMRunCommandsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetVMsClient(subscriptionID string) VirtualMachineScaleSetVMsClient {
	return original.NewVirtualMachineScaleSetVMsClient(subscriptionID)
}
func NewVirtualMachineScaleSetVMsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetVMsClient {
	return original.NewVirtualMachineScaleSetVMsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineScaleSetsClient(subscriptionID string) VirtualMachineScaleSetsClient {
	return original.NewVirtualMachineScaleSetsClient(subscriptionID)
}
func NewVirtualMachineScaleSetsClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineScaleSetsClient {
	return original.NewVirtualMachineScaleSetsClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachineSizesClient(subscriptionID string) VirtualMachineSizesClient {
	return original.NewVirtualMachineSizesClient(subscriptionID)
}
func NewVirtualMachineSizesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachineSizesClient {
	return original.NewVirtualMachineSizesClientWithBaseURI(baseURI, subscriptionID)
}
func NewVirtualMachinesClient(subscriptionID string) VirtualMachinesClient {
	return original.NewVirtualMachinesClient(subscriptionID)
}
func NewVirtualMachinesClientWithBaseURI(baseURI string, subscriptionID string) VirtualMachinesClient {
	return original.NewVirtualMachinesClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAccessLevelValues() []AccessLevel {
	return original.PossibleAccessLevelValues()
}
func PossibleAggregatedReplicationStateValues() []AggregatedReplicationState {
	return original.PossibleAggregatedReplicationStateValues()
}
func PossibleArchitectureTypesValues() []ArchitectureTypes {
	return original.PossibleArchitectureTypesValues()
}
func PossibleArchitectureValues() []Architecture {
	return original.PossibleArchitectureValues()
}
func PossibleAvailabilitySetSkuTypesValues() []AvailabilitySetSkuTypes {
	return original.PossibleAvailabilitySetSkuTypesValues()
}
func PossibleCachingTypesValues() []CachingTypes {
	return original.PossibleCachingTypesValues()
}
func PossibleCapacityReservationGroupInstanceViewTypesValues() []CapacityReservationGroupInstanceViewTypes {
	return original.PossibleCapacityReservationGroupInstanceViewTypesValues()
}
func PossibleCapacityReservationInstanceViewTypesValues() []CapacityReservationInstanceViewTypes {
	return original.PossibleCapacityReservationInstanceViewTypesValues()
}
func PossibleCloudServiceSlotTypeValues() []CloudServiceSlotType {
	return original.PossibleCloudServiceSlotTypeValues()
}
func PossibleCloudServiceUpgradeModeValues() []CloudServiceUpgradeMode {
	return original.PossibleCloudServiceUpgradeModeValues()
}
func PossibleComponentNamesValues() []ComponentNames {
	return original.PossibleComponentNamesValues()
}
func PossibleConfidentialVMEncryptionTypeValues() []ConfidentialVMEncryptionType {
	return original.PossibleConfidentialVMEncryptionTypeValues()
}
func PossibleConsistencyModeTypesValues() []ConsistencyModeTypes {
	return original.PossibleConsistencyModeTypesValues()
}
func PossibleDataAccessAuthModeValues() []DataAccessAuthMode {
	return original.PossibleDataAccessAuthModeValues()
}
func PossibleDedicatedHostLicenseTypesValues() []DedicatedHostLicenseTypes {
	return original.PossibleDedicatedHostLicenseTypesValues()
}
func PossibleDeleteOptionsValues() []DeleteOptions {
	return original.PossibleDeleteOptionsValues()
}
func PossibleDiffDiskOptionsValues() []DiffDiskOptions {
	return original.PossibleDiffDiskOptionsValues()
}
func PossibleDiffDiskPlacementValues() []DiffDiskPlacement {
	return original.PossibleDiffDiskPlacementValues()
}
func PossibleDiskControllerTypesValues() []DiskControllerTypes {
	return original.PossibleDiskControllerTypesValues()
}
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return original.PossibleDiskCreateOptionTypesValues()
}
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return original.PossibleDiskCreateOptionValues()
}
func PossibleDiskDeleteOptionTypesValues() []DiskDeleteOptionTypes {
	return original.PossibleDiskDeleteOptionTypesValues()
}
func PossibleDiskDetachOptionTypesValues() []DiskDetachOptionTypes {
	return original.PossibleDiskDetachOptionTypesValues()
}
func PossibleDiskEncryptionSetIdentityTypeValues() []DiskEncryptionSetIdentityType {
	return original.PossibleDiskEncryptionSetIdentityTypeValues()
}
func PossibleDiskEncryptionSetTypeValues() []DiskEncryptionSetType {
	return original.PossibleDiskEncryptionSetTypeValues()
}
func PossibleDiskSecurityTypesValues() []DiskSecurityTypes {
	return original.PossibleDiskSecurityTypesValues()
}
func PossibleDiskStateValues() []DiskState {
	return original.PossibleDiskStateValues()
}
func PossibleDiskStorageAccountTypesValues() []DiskStorageAccountTypes {
	return original.PossibleDiskStorageAccountTypesValues()
}
func PossibleEncryptionTypeValues() []EncryptionType {
	return original.PossibleEncryptionTypeValues()
}
func PossibleExecutionStateValues() []ExecutionState {
	return original.PossibleExecutionStateValues()
}
func PossibleExpandTypesForGetCapacityReservationGroupsValues() []ExpandTypesForGetCapacityReservationGroups {
	return original.PossibleExpandTypesForGetCapacityReservationGroupsValues()
}
func PossibleExpandTypesForGetVMScaleSetsValues() []ExpandTypesForGetVMScaleSets {
	return original.PossibleExpandTypesForGetVMScaleSetsValues()
}
func PossibleExtendedLocationTypeValues() []ExtendedLocationType {
	return original.PossibleExtendedLocationTypeValues()
}
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return original.PossibleExtendedLocationTypesValues()
}
func PossibleGalleryExpandParamsValues() []GalleryExpandParams {
	return original.PossibleGalleryExpandParamsValues()
}
func PossibleGalleryExtendedLocationTypeValues() []GalleryExtendedLocationType {
	return original.PossibleGalleryExtendedLocationTypeValues()
}
func PossibleGalleryProvisioningStateValues() []GalleryProvisioningState {
	return original.PossibleGalleryProvisioningStateValues()
}
func PossibleGallerySharingPermissionTypesValues() []GallerySharingPermissionTypes {
	return original.PossibleGallerySharingPermissionTypesValues()
}
func PossibleHostCachingValues() []HostCaching {
	return original.PossibleHostCachingValues()
}
func PossibleHyperVGenerationTypeValues() []HyperVGenerationType {
	return original.PossibleHyperVGenerationTypeValues()
}
func PossibleHyperVGenerationTypesValues() []HyperVGenerationTypes {
	return original.PossibleHyperVGenerationTypesValues()
}
func PossibleHyperVGenerationValues() []HyperVGeneration {
	return original.PossibleHyperVGenerationValues()
}
func PossibleIPVersionValues() []IPVersion {
	return original.PossibleIPVersionValues()
}
func PossibleIPVersionsValues() []IPVersions {
	return original.PossibleIPVersionsValues()
}
func PossibleInstanceViewTypesValues() []InstanceViewTypes {
	return original.PossibleInstanceViewTypesValues()
}
func PossibleIntervalInMinsValues() []IntervalInMins {
	return original.PossibleIntervalInMinsValues()
}
func PossibleLinuxPatchAssessmentModeValues() []LinuxPatchAssessmentMode {
	return original.PossibleLinuxPatchAssessmentModeValues()
}
func PossibleLinuxVMGuestPatchAutomaticByPlatformRebootSettingValues() []LinuxVMGuestPatchAutomaticByPlatformRebootSetting {
	return original.PossibleLinuxVMGuestPatchAutomaticByPlatformRebootSettingValues()
}
func PossibleLinuxVMGuestPatchModeValues() []LinuxVMGuestPatchMode {
	return original.PossibleLinuxVMGuestPatchModeValues()
}
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return original.PossibleMaintenanceOperationResultCodeTypesValues()
}
func PossibleNetworkAPIVersionValues() []NetworkAPIVersion {
	return original.PossibleNetworkAPIVersionValues()
}
func PossibleNetworkAccessPolicyValues() []NetworkAccessPolicy {
	return original.PossibleNetworkAccessPolicyValues()
}
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return original.PossibleOperatingSystemStateTypesValues()
}
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return original.PossibleOperatingSystemTypeValues()
}
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return original.PossibleOperatingSystemTypesValues()
}
func PossibleOrchestrationModeValues() []OrchestrationMode {
	return original.PossibleOrchestrationModeValues()
}
func PossibleOrchestrationServiceNamesValues() []OrchestrationServiceNames {
	return original.PossibleOrchestrationServiceNamesValues()
}
func PossibleOrchestrationServiceStateActionValues() []OrchestrationServiceStateAction {
	return original.PossibleOrchestrationServiceStateActionValues()
}
func PossibleOrchestrationServiceStateValues() []OrchestrationServiceState {
	return original.PossibleOrchestrationServiceStateValues()
}
func PossiblePassNamesValues() []PassNames {
	return original.PossiblePassNamesValues()
}
func PossiblePatchAssessmentStateValues() []PatchAssessmentState {
	return original.PossiblePatchAssessmentStateValues()
}
func PossiblePatchInstallationStateValues() []PatchInstallationState {
	return original.PossiblePatchInstallationStateValues()
}
func PossiblePatchOperationStatusValues() []PatchOperationStatus {
	return original.PossiblePatchOperationStatusValues()
}
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return original.PossiblePrivateEndpointConnectionProvisioningStateValues()
}
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return original.PossiblePrivateEndpointServiceConnectionStatusValues()
}
func PossibleProtocolTypesValues() []ProtocolTypes {
	return original.PossibleProtocolTypesValues()
}
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return original.PossibleProximityPlacementGroupTypeValues()
}
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return original.PossiblePublicIPAddressSkuNameValues()
}
func PossiblePublicIPAddressSkuTierValues() []PublicIPAddressSkuTier {
	return original.PossiblePublicIPAddressSkuTierValues()
}
func PossiblePublicIPAllocationMethodValues() []PublicIPAllocationMethod {
	return original.PossiblePublicIPAllocationMethodValues()
}
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return original.PossiblePublicNetworkAccessValues()
}
func PossibleRepairActionValues() []RepairAction {
	return original.PossibleRepairActionValues()
}
func PossibleReplicationModeValues() []ReplicationMode {
	return original.PossibleReplicationModeValues()
}
func PossibleReplicationStateValues() []ReplicationState {
	return original.PossibleReplicationStateValues()
}
func PossibleReplicationStatusTypesValues() []ReplicationStatusTypes {
	return original.PossibleReplicationStatusTypesValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return original.PossibleResourceSkuCapacityScaleTypeValues()
}
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return original.PossibleResourceSkuRestrictionsReasonCodeValues()
}
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return original.PossibleResourceSkuRestrictionsTypeValues()
}
func PossibleRestorePointCollectionExpandOptionsValues() []RestorePointCollectionExpandOptions {
	return original.PossibleRestorePointCollectionExpandOptionsValues()
}
func PossibleRestorePointExpandOptionsValues() []RestorePointExpandOptions {
	return original.PossibleRestorePointExpandOptionsValues()
}
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return original.PossibleRollingUpgradeActionTypeValues()
}
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return original.PossibleRollingUpgradeStatusCodeValues()
}
func PossibleSecurityEncryptionTypesValues() []SecurityEncryptionTypes {
	return original.PossibleSecurityEncryptionTypesValues()
}
func PossibleSecurityTypesValues() []SecurityTypes {
	return original.PossibleSecurityTypesValues()
}
func PossibleSelectPermissionsValues() []SelectPermissions {
	return original.PossibleSelectPermissionsValues()
}
func PossibleSettingNamesValues() []SettingNames {
	return original.PossibleSettingNamesValues()
}
func PossibleSharedGalleryHostCachingValues() []SharedGalleryHostCaching {
	return original.PossibleSharedGalleryHostCachingValues()
}
func PossibleSharedToValuesValues() []SharedToValues {
	return original.PossibleSharedToValuesValues()
}
func PossibleSharingProfileGroupTypesValues() []SharingProfileGroupTypes {
	return original.PossibleSharingProfileGroupTypesValues()
}
func PossibleSharingStateValues() []SharingState {
	return original.PossibleSharingStateValues()
}
func PossibleSharingUpdateOperationTypesValues() []SharingUpdateOperationTypes {
	return original.PossibleSharingUpdateOperationTypesValues()
}
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return original.PossibleSnapshotStorageAccountTypesValues()
}
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return original.PossibleStatusLevelTypesValues()
}
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return original.PossibleStorageAccountTypeValues()
}
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return original.PossibleStorageAccountTypesValues()
}
func PossibleUpgradeModeValues() []UpgradeMode {
	return original.PossibleUpgradeModeValues()
}
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return original.PossibleUpgradeOperationInvokerValues()
}
func PossibleUpgradeStateValues() []UpgradeState {
	return original.PossibleUpgradeStateValues()
}
func PossibleVMDiskTypesValues() []VMDiskTypes {
	return original.PossibleVMDiskTypesValues()
}
func PossibleVMGuestPatchClassificationLinuxValues() []VMGuestPatchClassificationLinux {
	return original.PossibleVMGuestPatchClassificationLinuxValues()
}
func PossibleVMGuestPatchClassificationWindowsValues() []VMGuestPatchClassificationWindows {
	return original.PossibleVMGuestPatchClassificationWindowsValues()
}
func PossibleVMGuestPatchRebootBehaviorValues() []VMGuestPatchRebootBehavior {
	return original.PossibleVMGuestPatchRebootBehaviorValues()
}
func PossibleVMGuestPatchRebootSettingValues() []VMGuestPatchRebootSetting {
	return original.PossibleVMGuestPatchRebootSettingValues()
}
func PossibleVMGuestPatchRebootStatusValues() []VMGuestPatchRebootStatus {
	return original.PossibleVMGuestPatchRebootStatusValues()
}
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return original.PossibleVirtualMachineEvictionPolicyTypesValues()
}
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return original.PossibleVirtualMachinePriorityTypesValues()
}
func PossibleVirtualMachineScaleSetScaleInRulesValues() []VirtualMachineScaleSetScaleInRules {
	return original.PossibleVirtualMachineScaleSetScaleInRulesValues()
}
func PossibleVirtualMachineScaleSetSkuScaleTypeValues() []VirtualMachineScaleSetSkuScaleType {
	return original.PossibleVirtualMachineScaleSetSkuScaleTypeValues()
}
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return original.PossibleVirtualMachineSizeTypesValues()
}
func PossibleWindowsPatchAssessmentModeValues() []WindowsPatchAssessmentMode {
	return original.PossibleWindowsPatchAssessmentModeValues()
}
func PossibleWindowsVMGuestPatchAutomaticByPlatformRebootSettingValues() []WindowsVMGuestPatchAutomaticByPlatformRebootSetting {
	return original.PossibleWindowsVMGuestPatchAutomaticByPlatformRebootSettingValues()
}
func PossibleWindowsVMGuestPatchModeValues() []WindowsVMGuestPatchMode {
	return original.PossibleWindowsVMGuestPatchModeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
