package attestationapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/attestation/2018-09-01/attestation"
)

// PolicyClientAPI contains the set of methods on the PolicyClient type.
type PolicyClientAPI interface {
	Get(ctx context.Context, tenantBaseURL string, tee attestation.TeeKind) (result attestation.SetObject, err error)
	PrepareToSet(ctx context.Context, tenantBaseURL string, tee attestation.TeeKind, policyJws string) (result attestation.SetObject, err error)
	Reset(ctx context.Context, tenantBaseURL string, tee attestation.TeeKind, policyJws string) (result attestation.SetObject, err error)
	Set(ctx context.Context, tenantBaseURL string, tee attestation.TeeKind, newAttestationPolicy string) (result attestation.SetObject, err error)
}

var _ PolicyClientAPI = (*attestation.PolicyClient)(nil)

// PolicyCertificatesClientAPI contains the set of methods on the PolicyCertificatesClient type.
type PolicyCertificatesClientAPI interface {
	Add(ctx context.Context, tenantBaseURL string, policyCertificateToAdd string) (result attestation.SetObject, err error)
	Get(ctx context.Context, tenantBaseURL string) (result attestation.SetObject, err error)
	Remove(ctx context.Context, tenantBaseURL string, policyCertificateToRemove string) (result attestation.SetObject, err error)
}

var _ PolicyCertificatesClientAPI = (*attestation.PolicyCertificatesClient)(nil)

// SigningCertificatesClientAPI contains the set of methods on the SigningCertificatesClient type.
type SigningCertificatesClientAPI interface {
	Get(ctx context.Context, tenantBaseURL string) (result attestation.SetObject, err error)
}

var _ SigningCertificatesClientAPI = (*attestation.SigningCertificatesClient)(nil)

// MetadataConfigurationClientAPI contains the set of methods on the MetadataConfigurationClient type.
type MetadataConfigurationClientAPI interface {
	Get(ctx context.Context, tenantBaseURL string) (result attestation.SetObject, err error)
}

var _ MetadataConfigurationClientAPI = (*attestation.MetadataConfigurationClient)(nil)
