// Code generated by smithy-go-codegen DO NOT EDIT.

package sns

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sns/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a topic to which notifications can be published. Users can create at
// most 100,000 standard topics (at most 1,000 FIFO topics). For more information,
// see [Creating an Amazon SNS topic]in the Amazon SNS Developer Guide. This action is idempotent, so if the
// requester already owns a topic with the specified name, that topic's ARN is
// returned without creating a new topic.
//
// [Creating an Amazon SNS topic]: https://docs.aws.amazon.com/sns/latest/dg/sns-create-topic.html
func (c *Client) CreateTopic(ctx context.Context, params *CreateTopicInput, optFns ...func(*Options)) (*CreateTopicOutput, error) {
	if params == nil {
		params = &CreateTopicInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTopic", params, optFns, c.addOperationCreateTopicMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTopicOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input for CreateTopic action.
type CreateTopicInput struct {

	// The name of the topic you want to create.
	//
	// Constraints: Topic names must be made up of only uppercase and lowercase ASCII
	// letters, numbers, underscores, and hyphens, and must be between 1 and 256
	// characters long.
	//
	// For a FIFO (first-in-first-out) topic, the name must end with the .fifo suffix.
	//
	// This member is required.
	Name *string

	// A map of attributes with their corresponding values.
	//
	// The following lists names, descriptions, and values of the special request
	// parameters that the CreateTopic action uses:
	//
	//   - DeliveryPolicy – The policy that defines how Amazon SNS retries failed
	//   deliveries to HTTP/S endpoints.
	//
	//   - DisplayName – The display name to use for a topic with SMS subscriptions.
	//
	//   - Policy – The policy that defines who can access your topic. By default, only
	//   the topic owner can publish or subscribe to the topic.
	//
	//   - TracingConfig – Tracing mode of an Amazon SNS topic. By default
	//   TracingConfig is set to PassThrough , and the topic passes through the tracing
	//   header it receives from an Amazon SNS publisher to its subscriptions. If set to
	//   Active , Amazon SNS will vend X-Ray segment data to topic owner account if the
	//   sampled flag in the tracing header is true. This is only supported on standard
	//   topics.
	//
	//   - HTTP
	//
	//   - HTTPSuccessFeedbackRoleArn – Indicates successful message delivery status
	//   for an Amazon SNS topic that is subscribed to an HTTP endpoint.
	//
	//   - HTTPSuccessFeedbackSampleRate – Indicates percentage of successful messages
	//   to sample for an Amazon SNS topic that is subscribed to an HTTP endpoint.
	//
	//   - HTTPFailureFeedbackRoleArn – Indicates failed message delivery status for an
	//   Amazon SNS topic that is subscribed to an HTTP endpoint.
	//
	//   - Amazon Data Firehose
	//
	//   - FirehoseSuccessFeedbackRoleArn – Indicates successful message delivery
	//   status for an Amazon SNS topic that is subscribed to an Amazon Data Firehose
	//   endpoint.
	//
	//   - FirehoseSuccessFeedbackSampleRate – Indicates percentage of successful
	//   messages to sample for an Amazon SNS topic that is subscribed to an Amazon Data
	//   Firehose endpoint.
	//
	//   - FirehoseFailureFeedbackRoleArn – Indicates failed message delivery status
	//   for an Amazon SNS topic that is subscribed to an Amazon Data Firehose endpoint.
	//
	//   - Lambda
	//
	//   - LambdaSuccessFeedbackRoleArn – Indicates successful message delivery status
	//   for an Amazon SNS topic that is subscribed to an Lambda endpoint.
	//
	//   - LambdaSuccessFeedbackSampleRate – Indicates percentage of successful
	//   messages to sample for an Amazon SNS topic that is subscribed to an Lambda
	//   endpoint.
	//
	//   - LambdaFailureFeedbackRoleArn – Indicates failed message delivery status for
	//   an Amazon SNS topic that is subscribed to an Lambda endpoint.
	//
	//   - Platform application endpoint
	//
	//   - ApplicationSuccessFeedbackRoleArn – Indicates successful message delivery
	//   status for an Amazon SNS topic that is subscribed to a platform application
	//   endpoint.
	//
	//   - ApplicationSuccessFeedbackSampleRate – Indicates percentage of successful
	//   messages to sample for an Amazon SNS topic that is subscribed to an platform
	//   application endpoint.
	//
	//   - ApplicationFailureFeedbackRoleArn – Indicates failed message delivery status
	//   for an Amazon SNS topic that is subscribed to an platform application endpoint.
	//
	// In addition to being able to configure topic attributes for message delivery
	//   status of notification messages sent to Amazon SNS application endpoints, you
	//   can also configure application attributes for the delivery status of push
	//   notification messages sent to push notification services.
	//
	// For example, For more information, see [Using Amazon SNS Application Attributes for Message Delivery Status].
	//
	//   - Amazon SQS
	//
	//   - SQSSuccessFeedbackRoleArn – Indicates successful message delivery status for
	//   an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
	//
	//   - SQSSuccessFeedbackSampleRate – Indicates percentage of successful messages
	//   to sample for an Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
	//
	//   - SQSFailureFeedbackRoleArn – Indicates failed message delivery status for an
	//   Amazon SNS topic that is subscribed to an Amazon SQS endpoint.
	//
	// The SuccessFeedbackRoleArn and FailureFeedbackRoleArn attributes are used to
	// give Amazon SNS write access to use CloudWatch Logs on your behalf. The
	// SuccessFeedbackSampleRate attribute is for specifying the sample rate percentage
	// (0-100) of successfully delivered messages. After you configure the
	// FailureFeedbackRoleArn attribute, then all failed message deliveries generate
	// CloudWatch Logs.
	//
	// The following attribute applies only to [server-side encryption]:
	//
	//   - KmsMasterKeyId – The ID of an Amazon Web Services managed customer master
	//   key (CMK) for Amazon SNS or a custom CMK. For more information, see [Key Terms]. For
	//   more examples, see [KeyId]in the Key Management Service API Reference.
	//
	// The following attributes apply only to [FIFO topics]:
	//
	//   - ArchivePolicy – The policy that sets the retention period for messages
	//   stored in the message archive of an Amazon SNS FIFO topic.
	//
	//   - ContentBasedDeduplication – Enables content-based deduplication for FIFO
	//   topics.
	//
	//   - By default, ContentBasedDeduplication is set to false . If you create a FIFO
	//   topic and this attribute is false , you must specify a value for the
	//   MessageDeduplicationId parameter for the [Publish]action.
	//
	//   - When you set ContentBasedDeduplication to true , Amazon SNS uses a SHA-256
	//   hash to generate the MessageDeduplicationId using the body of the message (but
	//   not the attributes of the message).
	//
	// (Optional) To override the generated value, you can specify a value for the
	//   MessageDeduplicationId parameter for the Publish action.
	//
	//   - FifoThroughputScope – Enables higher throughput for your FIFO topic by
	//   adjusting the scope of deduplication. This attribute has two possible values:
	//
	//   - Topic – The scope of message deduplication is across the entire topic. This
	//   is the default value and maintains existing behavior, with a maximum throughput
	//   of 3000 messages per second or 20MB per second, whichever comes first.
	//
	//   - MessageGroup – The scope of deduplication is within each individual message
	//   group, which enables higher throughput per topic subject to regional quotas. For
	//   more information on quotas or to request an increase, see [Amazon SNS service quotas]in the Amazon Web
	//   Services General Reference.
	//
	// [Amazon SNS service quotas]: https://docs.aws.amazon.com/general/latest/gr/sns.html
	// [Using Amazon SNS Application Attributes for Message Delivery Status]: https://docs.aws.amazon.com/sns/latest/dg/sns-msg-status.html
	// [server-side encryption]: https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html
	// [Key Terms]: https://docs.aws.amazon.com/sns/latest/dg/sns-server-side-encryption.html#sse-key-terms
	// [KeyId]: https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters
	// [Publish]: https://docs.aws.amazon.com/sns/latest/api/API_Publish.html
	// [FIFO topics]: https://docs.aws.amazon.com/sns/latest/dg/sns-fifo-topics.html
	Attributes map[string]string

	// The body of the policy document you want to use for this topic.
	//
	// You can only add one policy per topic.
	//
	// The policy must be in JSON string format.
	//
	// Length Constraints: Maximum length of 30,720.
	DataProtectionPolicy *string

	// The list of tags to add to a new topic.
	//
	// To be able to tag a topic on creation, you must have the sns:CreateTopic and
	// sns:TagResource permissions.
	Tags []types.Tag

	noSmithyDocumentSerde
}

// Response from CreateTopic action.
type CreateTopicOutput struct {

	// The Amazon Resource Name (ARN) assigned to the created topic.
	TopicArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTopicMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpCreateTopic{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpCreateTopic{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTopic"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTopicValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTopic(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTopic(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTopic",
	}
}
