// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/essentialcontacts/v1/service.proto

package essentialcontactspb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EssentialContactsService_CreateContact_FullMethodName   = "/google.cloud.essentialcontacts.v1.EssentialContactsService/CreateContact"
	EssentialContactsService_UpdateContact_FullMethodName   = "/google.cloud.essentialcontacts.v1.EssentialContactsService/UpdateContact"
	EssentialContactsService_ListContacts_FullMethodName    = "/google.cloud.essentialcontacts.v1.EssentialContactsService/ListContacts"
	EssentialContactsService_GetContact_FullMethodName      = "/google.cloud.essentialcontacts.v1.EssentialContactsService/GetContact"
	EssentialContactsService_DeleteContact_FullMethodName   = "/google.cloud.essentialcontacts.v1.EssentialContactsService/DeleteContact"
	EssentialContactsService_ComputeContacts_FullMethodName = "/google.cloud.essentialcontacts.v1.EssentialContactsService/ComputeContacts"
	EssentialContactsService_SendTestMessage_FullMethodName = "/google.cloud.essentialcontacts.v1.EssentialContactsService/SendTestMessage"
)

// EssentialContactsServiceClient is the client API for EssentialContactsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EssentialContactsServiceClient interface {
	// Adds a new contact for a resource.
	CreateContact(ctx context.Context, in *CreateContactRequest, opts ...grpc.CallOption) (*Contact, error)
	// Updates a contact.
	// Note: A contact's email address cannot be changed.
	UpdateContact(ctx context.Context, in *UpdateContactRequest, opts ...grpc.CallOption) (*Contact, error)
	// Lists the contacts that have been set on a resource.
	ListContacts(ctx context.Context, in *ListContactsRequest, opts ...grpc.CallOption) (*ListContactsResponse, error)
	// Gets a single contact.
	GetContact(ctx context.Context, in *GetContactRequest, opts ...grpc.CallOption) (*Contact, error)
	// Deletes a contact.
	DeleteContact(ctx context.Context, in *DeleteContactRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all contacts for the resource that are subscribed to the
	// specified notification categories, including contacts inherited from
	// any parent resources.
	ComputeContacts(ctx context.Context, in *ComputeContactsRequest, opts ...grpc.CallOption) (*ComputeContactsResponse, error)
	// Allows a contact admin to send a test message to contact to verify that it
	// has been configured correctly.
	SendTestMessage(ctx context.Context, in *SendTestMessageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type essentialContactsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEssentialContactsServiceClient(cc grpc.ClientConnInterface) EssentialContactsServiceClient {
	return &essentialContactsServiceClient{cc}
}

func (c *essentialContactsServiceClient) CreateContact(ctx context.Context, in *CreateContactRequest, opts ...grpc.CallOption) (*Contact, error) {
	out := new(Contact)
	err := c.cc.Invoke(ctx, EssentialContactsService_CreateContact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *essentialContactsServiceClient) UpdateContact(ctx context.Context, in *UpdateContactRequest, opts ...grpc.CallOption) (*Contact, error) {
	out := new(Contact)
	err := c.cc.Invoke(ctx, EssentialContactsService_UpdateContact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *essentialContactsServiceClient) ListContacts(ctx context.Context, in *ListContactsRequest, opts ...grpc.CallOption) (*ListContactsResponse, error) {
	out := new(ListContactsResponse)
	err := c.cc.Invoke(ctx, EssentialContactsService_ListContacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *essentialContactsServiceClient) GetContact(ctx context.Context, in *GetContactRequest, opts ...grpc.CallOption) (*Contact, error) {
	out := new(Contact)
	err := c.cc.Invoke(ctx, EssentialContactsService_GetContact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *essentialContactsServiceClient) DeleteContact(ctx context.Context, in *DeleteContactRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, EssentialContactsService_DeleteContact_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *essentialContactsServiceClient) ComputeContacts(ctx context.Context, in *ComputeContactsRequest, opts ...grpc.CallOption) (*ComputeContactsResponse, error) {
	out := new(ComputeContactsResponse)
	err := c.cc.Invoke(ctx, EssentialContactsService_ComputeContacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *essentialContactsServiceClient) SendTestMessage(ctx context.Context, in *SendTestMessageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, EssentialContactsService_SendTestMessage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EssentialContactsServiceServer is the server API for EssentialContactsService service.
// All implementations should embed UnimplementedEssentialContactsServiceServer
// for forward compatibility
type EssentialContactsServiceServer interface {
	// Adds a new contact for a resource.
	CreateContact(context.Context, *CreateContactRequest) (*Contact, error)
	// Updates a contact.
	// Note: A contact's email address cannot be changed.
	UpdateContact(context.Context, *UpdateContactRequest) (*Contact, error)
	// Lists the contacts that have been set on a resource.
	ListContacts(context.Context, *ListContactsRequest) (*ListContactsResponse, error)
	// Gets a single contact.
	GetContact(context.Context, *GetContactRequest) (*Contact, error)
	// Deletes a contact.
	DeleteContact(context.Context, *DeleteContactRequest) (*emptypb.Empty, error)
	// Lists all contacts for the resource that are subscribed to the
	// specified notification categories, including contacts inherited from
	// any parent resources.
	ComputeContacts(context.Context, *ComputeContactsRequest) (*ComputeContactsResponse, error)
	// Allows a contact admin to send a test message to contact to verify that it
	// has been configured correctly.
	SendTestMessage(context.Context, *SendTestMessageRequest) (*emptypb.Empty, error)
}

// UnimplementedEssentialContactsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedEssentialContactsServiceServer struct {
}

func (UnimplementedEssentialContactsServiceServer) CreateContact(context.Context, *CreateContactRequest) (*Contact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateContact not implemented")
}
func (UnimplementedEssentialContactsServiceServer) UpdateContact(context.Context, *UpdateContactRequest) (*Contact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateContact not implemented")
}
func (UnimplementedEssentialContactsServiceServer) ListContacts(context.Context, *ListContactsRequest) (*ListContactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListContacts not implemented")
}
func (UnimplementedEssentialContactsServiceServer) GetContact(context.Context, *GetContactRequest) (*Contact, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetContact not implemented")
}
func (UnimplementedEssentialContactsServiceServer) DeleteContact(context.Context, *DeleteContactRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteContact not implemented")
}
func (UnimplementedEssentialContactsServiceServer) ComputeContacts(context.Context, *ComputeContactsRequest) (*ComputeContactsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ComputeContacts not implemented")
}
func (UnimplementedEssentialContactsServiceServer) SendTestMessage(context.Context, *SendTestMessageRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendTestMessage not implemented")
}

// UnsafeEssentialContactsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EssentialContactsServiceServer will
// result in compilation errors.
type UnsafeEssentialContactsServiceServer interface {
	mustEmbedUnimplementedEssentialContactsServiceServer()
}

func RegisterEssentialContactsServiceServer(s grpc.ServiceRegistrar, srv EssentialContactsServiceServer) {
	s.RegisterService(&EssentialContactsService_ServiceDesc, srv)
}

func _EssentialContactsService_CreateContact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).CreateContact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_CreateContact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).CreateContact(ctx, req.(*CreateContactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EssentialContactsService_UpdateContact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).UpdateContact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_UpdateContact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).UpdateContact(ctx, req.(*UpdateContactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EssentialContactsService_ListContacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListContactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).ListContacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_ListContacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).ListContacts(ctx, req.(*ListContactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EssentialContactsService_GetContact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetContactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).GetContact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_GetContact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).GetContact(ctx, req.(*GetContactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EssentialContactsService_DeleteContact_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteContactRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).DeleteContact(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_DeleteContact_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).DeleteContact(ctx, req.(*DeleteContactRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EssentialContactsService_ComputeContacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ComputeContactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).ComputeContacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_ComputeContacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).ComputeContacts(ctx, req.(*ComputeContactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EssentialContactsService_SendTestMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendTestMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EssentialContactsServiceServer).SendTestMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EssentialContactsService_SendTestMessage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EssentialContactsServiceServer).SendTestMessage(ctx, req.(*SendTestMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EssentialContactsService_ServiceDesc is the grpc.ServiceDesc for EssentialContactsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EssentialContactsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.essentialcontacts.v1.EssentialContactsService",
	HandlerType: (*EssentialContactsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateContact",
			Handler:    _EssentialContactsService_CreateContact_Handler,
		},
		{
			MethodName: "UpdateContact",
			Handler:    _EssentialContactsService_UpdateContact_Handler,
		},
		{
			MethodName: "ListContacts",
			Handler:    _EssentialContactsService_ListContacts_Handler,
		},
		{
			MethodName: "GetContact",
			Handler:    _EssentialContactsService_GetContact_Handler,
		},
		{
			MethodName: "DeleteContact",
			Handler:    _EssentialContactsService_DeleteContact_Handler,
		},
		{
			MethodName: "ComputeContacts",
			Handler:    _EssentialContactsService_ComputeContacts_Handler,
		},
		{
			MethodName: "SendTestMessage",
			Handler:    _EssentialContactsService_SendTestMessage_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/essentialcontacts/v1/service.proto",
}
