// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/cloud/certificatemanager/v1/certificate_issuance_config.proto

package certificatemanagerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of keypair to generate.
type CertificateIssuanceConfig_KeyAlgorithm int32

const (
	// Unspecified key algorithm.
	CertificateIssuanceConfig_KEY_ALGORITHM_UNSPECIFIED CertificateIssuanceConfig_KeyAlgorithm = 0
	// Specifies RSA with a 2048-bit modulus.
	CertificateIssuanceConfig_RSA_2048 CertificateIssuanceConfig_KeyAlgorithm = 1
	// Specifies ECDSA with curve P256.
	CertificateIssuanceConfig_ECDSA_P256 CertificateIssuanceConfig_KeyAlgorithm = 4
)

// Enum value maps for CertificateIssuanceConfig_KeyAlgorithm.
var (
	CertificateIssuanceConfig_KeyAlgorithm_name = map[int32]string{
		0: "KEY_ALGORITHM_UNSPECIFIED",
		1: "RSA_2048",
		4: "ECDSA_P256",
	}
	CertificateIssuanceConfig_KeyAlgorithm_value = map[string]int32{
		"KEY_ALGORITHM_UNSPECIFIED": 0,
		"RSA_2048":                  1,
		"ECDSA_P256":                4,
	}
)

func (x CertificateIssuanceConfig_KeyAlgorithm) Enum() *CertificateIssuanceConfig_KeyAlgorithm {
	p := new(CertificateIssuanceConfig_KeyAlgorithm)
	*p = x
	return p
}

func (x CertificateIssuanceConfig_KeyAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CertificateIssuanceConfig_KeyAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_enumTypes[0].Descriptor()
}

func (CertificateIssuanceConfig_KeyAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_enumTypes[0]
}

func (x CertificateIssuanceConfig_KeyAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CertificateIssuanceConfig_KeyAlgorithm.Descriptor instead.
func (CertificateIssuanceConfig_KeyAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{5, 0}
}

// Request for the `ListCertificateIssuanceConfigs` method.
type ListCertificateIssuanceConfigsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the certificate should be
	// listed, specified in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of certificate configs to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListCertificateIssuanceConfigsResponse`.
	// Indicates that this is a continuation of a prior
	// `ListCertificateIssuanceConfigs` call, and that the system should return
	// the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filter expression to restrict the Certificates Configs returned.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// A list of Certificate Config field names used to specify the order of the
	// returned results. The default sorting order is ascending. To specify
	// descending order for a field, add a suffix `" desc"`.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCertificateIssuanceConfigsRequest) Reset() {
	*x = ListCertificateIssuanceConfigsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificateIssuanceConfigsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificateIssuanceConfigsRequest) ProtoMessage() {}

func (x *ListCertificateIssuanceConfigsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificateIssuanceConfigsRequest.ProtoReflect.Descriptor instead.
func (*ListCertificateIssuanceConfigsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{0}
}

func (x *ListCertificateIssuanceConfigsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCertificateIssuanceConfigsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCertificateIssuanceConfigsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCertificateIssuanceConfigsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCertificateIssuanceConfigsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response for the `ListCertificateIssuanceConfigs` method.
type ListCertificateIssuanceConfigsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of certificate configs for the parent resource.
	CertificateIssuanceConfigs []*CertificateIssuanceConfig `protobuf:"bytes,1,rep,name=certificate_issuance_configs,json=certificateIssuanceConfigs,proto3" json:"certificate_issuance_configs,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCertificateIssuanceConfigsResponse) Reset() {
	*x = ListCertificateIssuanceConfigsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListCertificateIssuanceConfigsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCertificateIssuanceConfigsResponse) ProtoMessage() {}

func (x *ListCertificateIssuanceConfigsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCertificateIssuanceConfigsResponse.ProtoReflect.Descriptor instead.
func (*ListCertificateIssuanceConfigsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{1}
}

func (x *ListCertificateIssuanceConfigsResponse) GetCertificateIssuanceConfigs() []*CertificateIssuanceConfig {
	if x != nil {
		return x.CertificateIssuanceConfigs
	}
	return nil
}

func (x *ListCertificateIssuanceConfigsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCertificateIssuanceConfigsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request for the `GetCertificateIssuanceConfig` method.
type GetCertificateIssuanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate issuance config to describe. Must be in
	// the format `projects/*/locations/*/certificateIssuanceConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCertificateIssuanceConfigRequest) Reset() {
	*x = GetCertificateIssuanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCertificateIssuanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCertificateIssuanceConfigRequest) ProtoMessage() {}

func (x *GetCertificateIssuanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCertificateIssuanceConfigRequest.ProtoReflect.Descriptor instead.
func (*GetCertificateIssuanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{2}
}

func (x *GetCertificateIssuanceConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for the `CreateCertificateIssuanceConfig` method.
type CreateCertificateIssuanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the certificate issuance config. Must be
	// in the format `projects/*/locations/*`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A user-provided name of the certificate config.
	CertificateIssuanceConfigId string `protobuf:"bytes,2,opt,name=certificate_issuance_config_id,json=certificateIssuanceConfigId,proto3" json:"certificate_issuance_config_id,omitempty"`
	// Required. A definition of the certificate issuance config to create.
	CertificateIssuanceConfig *CertificateIssuanceConfig `protobuf:"bytes,3,opt,name=certificate_issuance_config,json=certificateIssuanceConfig,proto3" json:"certificate_issuance_config,omitempty"`
}

func (x *CreateCertificateIssuanceConfigRequest) Reset() {
	*x = CreateCertificateIssuanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCertificateIssuanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCertificateIssuanceConfigRequest) ProtoMessage() {}

func (x *CreateCertificateIssuanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCertificateIssuanceConfigRequest.ProtoReflect.Descriptor instead.
func (*CreateCertificateIssuanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{3}
}

func (x *CreateCertificateIssuanceConfigRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCertificateIssuanceConfigRequest) GetCertificateIssuanceConfigId() string {
	if x != nil {
		return x.CertificateIssuanceConfigId
	}
	return ""
}

func (x *CreateCertificateIssuanceConfigRequest) GetCertificateIssuanceConfig() *CertificateIssuanceConfig {
	if x != nil {
		return x.CertificateIssuanceConfig
	}
	return nil
}

// Request for the `DeleteCertificateIssuanceConfig` method.
type DeleteCertificateIssuanceConfigRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the certificate issuance config to delete. Must be in
	// the format `projects/*/locations/*/certificateIssuanceConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteCertificateIssuanceConfigRequest) Reset() {
	*x = DeleteCertificateIssuanceConfigRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCertificateIssuanceConfigRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCertificateIssuanceConfigRequest) ProtoMessage() {}

func (x *DeleteCertificateIssuanceConfigRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCertificateIssuanceConfigRequest.ProtoReflect.Descriptor instead.
func (*DeleteCertificateIssuanceConfigRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{4}
}

func (x *DeleteCertificateIssuanceConfigRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// CertificateIssuanceConfig specifies how to issue and manage a certificate.
type CertificateIssuanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A user-defined name of the certificate issuance config.
	// CertificateIssuanceConfig names must be unique globally and match pattern
	// `projects/*/locations/*/certificateIssuanceConfigs/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The creation timestamp of a CertificateIssuanceConfig.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last update timestamp of a CertificateIssuanceConfig.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Set of labels associated with a CertificateIssuanceConfig.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// One or more paragraphs of text description of a CertificateIssuanceConfig.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Required. The CA that issues the workload certificate. It includes the CA
	// address, type, authentication to CA service, etc.
	CertificateAuthorityConfig *CertificateIssuanceConfig_CertificateAuthorityConfig `protobuf:"bytes,6,opt,name=certificate_authority_config,json=certificateAuthorityConfig,proto3" json:"certificate_authority_config,omitempty"`
	// Required. Workload certificate lifetime requested.
	Lifetime *durationpb.Duration `protobuf:"bytes,7,opt,name=lifetime,proto3" json:"lifetime,omitempty"`
	// Required. Specifies the percentage of elapsed time of the certificate
	// lifetime to wait before renewing the certificate. Must be a number between
	// 1-99, inclusive.
	RotationWindowPercentage int32 `protobuf:"varint,8,opt,name=rotation_window_percentage,json=rotationWindowPercentage,proto3" json:"rotation_window_percentage,omitempty"`
	// Required. The key algorithm to use when generating the private key.
	KeyAlgorithm CertificateIssuanceConfig_KeyAlgorithm `protobuf:"varint,9,opt,name=key_algorithm,json=keyAlgorithm,proto3,enum=google.cloud.certificatemanager.v1.CertificateIssuanceConfig_KeyAlgorithm" json:"key_algorithm,omitempty"`
}

func (x *CertificateIssuanceConfig) Reset() {
	*x = CertificateIssuanceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateIssuanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateIssuanceConfig) ProtoMessage() {}

func (x *CertificateIssuanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateIssuanceConfig.ProtoReflect.Descriptor instead.
func (*CertificateIssuanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{5}
}

func (x *CertificateIssuanceConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CertificateIssuanceConfig) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CertificateIssuanceConfig) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *CertificateIssuanceConfig) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *CertificateIssuanceConfig) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *CertificateIssuanceConfig) GetCertificateAuthorityConfig() *CertificateIssuanceConfig_CertificateAuthorityConfig {
	if x != nil {
		return x.CertificateAuthorityConfig
	}
	return nil
}

func (x *CertificateIssuanceConfig) GetLifetime() *durationpb.Duration {
	if x != nil {
		return x.Lifetime
	}
	return nil
}

func (x *CertificateIssuanceConfig) GetRotationWindowPercentage() int32 {
	if x != nil {
		return x.RotationWindowPercentage
	}
	return 0
}

func (x *CertificateIssuanceConfig) GetKeyAlgorithm() CertificateIssuanceConfig_KeyAlgorithm {
	if x != nil {
		return x.KeyAlgorithm
	}
	return CertificateIssuanceConfig_KEY_ALGORITHM_UNSPECIFIED
}

// The CA that issues the workload certificate. It includes CA address, type,
// authentication to CA service, etc.
type CertificateIssuanceConfig_CertificateAuthorityConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Kind:
	//
	//	*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_
	Kind isCertificateIssuanceConfig_CertificateAuthorityConfig_Kind `protobuf_oneof:"kind"`
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig) Reset() {
	*x = CertificateIssuanceConfig_CertificateAuthorityConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateIssuanceConfig_CertificateAuthorityConfig) ProtoMessage() {}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateIssuanceConfig_CertificateAuthorityConfig.ProtoReflect.Descriptor instead.
func (*CertificateIssuanceConfig_CertificateAuthorityConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{5, 0}
}

func (m *CertificateIssuanceConfig_CertificateAuthorityConfig) GetKind() isCertificateIssuanceConfig_CertificateAuthorityConfig_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig) GetCertificateAuthorityServiceConfig() *CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig {
	if x, ok := x.GetKind().(*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_); ok {
		return x.CertificateAuthorityServiceConfig
	}
	return nil
}

type isCertificateIssuanceConfig_CertificateAuthorityConfig_Kind interface {
	isCertificateIssuanceConfig_CertificateAuthorityConfig_Kind()
}

type CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_ struct {
	// Defines a CertificateAuthorityServiceConfig.
	CertificateAuthorityServiceConfig *CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig `protobuf:"bytes,1,opt,name=certificate_authority_service_config,json=certificateAuthorityServiceConfig,proto3,oneof"`
}

func (*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_) isCertificateIssuanceConfig_CertificateAuthorityConfig_Kind() {
}

// Contains information required to contact CA service.
type CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A CA pool resource used to issue a certificate.
	// The CA pool string has a relative resource path following the form
	// "projects/{project}/locations/{location}/caPools/{ca_pool}".
	CaPool string `protobuf:"bytes,1,opt,name=ca_pool,json=caPool,proto3" json:"ca_pool,omitempty"`
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig) Reset() {
	*x = CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig) ProtoMessage() {
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig.ProtoReflect.Descriptor instead.
func (*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP(), []int{5, 0, 0}
}

func (x *CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig) GetCaPool() string {
	if x != nil {
		return x.CaPool
	}
	return ""
}

var File_google_cloud_certificatemanager_v1_certificate_issuance_config_proto protoreflect.FileDescriptor

var file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDesc = []byte{
	0x0a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd9, 0x01, 0x0a, 0x25, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65,
	0x72, 0x42, 0x79, 0x22, 0xf3, 0x01, 0x0a, 0x26, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x7f,
	0x0a, 0x1c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x73,
	0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x1a, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x7e, 0x0a, 0x23, 0x47, 0x65, 0x74,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x43,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x02, 0x0a, 0x26, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x1e, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x1b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x49,
	0x64, 0x12, 0x82, 0x01, 0x0a, 0x1b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x19, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x81, 0x01, 0x0a, 0x26, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x57, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x43, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x3d, 0x0a, 0x3b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
	0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdb, 0x0a, 0x0a, 0x19, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e,
	0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x61, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9f, 0x01, 0x0a, 0x1c, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73,
	0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1a, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
	0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x3a, 0x0a, 0x08, 0x6c, 0x69, 0x66, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c, 0x69, 0x66, 0x65, 0x74,
	0x69, 0x6d, 0x65, 0x12, 0x41, 0x0a, 0x1a, 0x72, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61, 0x67,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x18, 0x72, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x50, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x12, 0x74, 0x0a, 0x0d, 0x6b, 0x65, 0x79, 0x5f, 0x61, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73,
	0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4b, 0x65, 0x79,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x6b, 0x65, 0x79, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x1a, 0xdb, 0x02, 0x0a,
	0x1a, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0xcd, 0x01, 0x0a, 0x24,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x7a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x48, 0x00, 0x52, 0x21, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x65, 0x0a, 0x21, 0x43,
	0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72,
	0x69, 0x74, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x40, 0x0a, 0x07, 0x63, 0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x27, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x70, 0x72, 0x69, 0x76, 0x61,
	0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x63, 0x61, 0x50, 0x6f,
	0x6f, 0x6c, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4b, 0x0a, 0x0c, 0x4b, 0x65, 0x79, 0x41, 0x6c, 0x67, 0x6f,
	0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1d, 0x0a, 0x19, 0x4b, 0x45, 0x59, 0x5f, 0x41, 0x4c, 0x47,
	0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x53, 0x41, 0x5f, 0x32, 0x30, 0x34, 0x38,
	0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x45, 0x43, 0x44, 0x53, 0x41, 0x5f, 0x50, 0x32, 0x35, 0x36,
	0x10, 0x04, 0x3a, 0xa3, 0x01, 0xea, 0x41, 0x9f, 0x01, 0x0a, 0x3b, 0x63, 0x65, 0x72, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x60, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49, 0x73, 0x73, 0x75, 0x61,
	0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2f, 0x7b, 0x63, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x69, 0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x7d, 0x42, 0xf3, 0x02, 0xea, 0x41, 0x5c, 0x0a, 0x1f,
	0x70, 0x72, 0x69, 0x76, 0x61, 0x74, 0x65, 0x63, 0x61, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x12,
	0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x63, 0x61, 0x50, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x7b, 0x63, 0x61, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x0a, 0x26, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x65, 0x72,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x42, 0x1e, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x49,
	0x73, 0x73, 0x75, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x56, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x63, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x22, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x43, 0x65, 0x72, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x25, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a,
	0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescOnce sync.Once
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescData = file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDesc
)

func file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescGZIP() []byte {
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescOnce.Do(func() {
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescData)
	})
	return file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDescData
}

var file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_goTypes = []any{
	(CertificateIssuanceConfig_KeyAlgorithm)(0),                  // 0: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
	(*ListCertificateIssuanceConfigsRequest)(nil),                // 1: google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsRequest
	(*ListCertificateIssuanceConfigsResponse)(nil),               // 2: google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsResponse
	(*GetCertificateIssuanceConfigRequest)(nil),                  // 3: google.cloud.certificatemanager.v1.GetCertificateIssuanceConfigRequest
	(*CreateCertificateIssuanceConfigRequest)(nil),               // 4: google.cloud.certificatemanager.v1.CreateCertificateIssuanceConfigRequest
	(*DeleteCertificateIssuanceConfigRequest)(nil),               // 5: google.cloud.certificatemanager.v1.DeleteCertificateIssuanceConfigRequest
	(*CertificateIssuanceConfig)(nil),                            // 6: google.cloud.certificatemanager.v1.CertificateIssuanceConfig
	(*CertificateIssuanceConfig_CertificateAuthorityConfig)(nil), // 7: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
	nil, // 8: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.LabelsEntry
	(*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig)(nil), // 9: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig
	(*timestamppb.Timestamp)(nil), // 10: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),   // 11: google.protobuf.Duration
}
var file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_depIdxs = []int32{
	6,  // 0: google.cloud.certificatemanager.v1.ListCertificateIssuanceConfigsResponse.certificate_issuance_configs:type_name -> google.cloud.certificatemanager.v1.CertificateIssuanceConfig
	6,  // 1: google.cloud.certificatemanager.v1.CreateCertificateIssuanceConfigRequest.certificate_issuance_config:type_name -> google.cloud.certificatemanager.v1.CertificateIssuanceConfig
	10, // 2: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.create_time:type_name -> google.protobuf.Timestamp
	10, // 3: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.update_time:type_name -> google.protobuf.Timestamp
	8,  // 4: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.labels:type_name -> google.cloud.certificatemanager.v1.CertificateIssuanceConfig.LabelsEntry
	7,  // 5: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.certificate_authority_config:type_name -> google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig
	11, // 6: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.lifetime:type_name -> google.protobuf.Duration
	0,  // 7: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.key_algorithm:type_name -> google.cloud.certificatemanager.v1.CertificateIssuanceConfig.KeyAlgorithm
	9,  // 8: google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.certificate_authority_service_config:type_name -> google.cloud.certificatemanager.v1.CertificateIssuanceConfig.CertificateAuthorityConfig.CertificateAuthorityServiceConfig
	9,  // [9:9] is the sub-list for method output_type
	9,  // [9:9] is the sub-list for method input_type
	9,  // [9:9] is the sub-list for extension type_name
	9,  // [9:9] is the sub-list for extension extendee
	0,  // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_init() }
func file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_init() {
	if File_google_cloud_certificatemanager_v1_certificate_issuance_config_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ListCertificateIssuanceConfigsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ListCertificateIssuanceConfigsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*GetCertificateIssuanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*CreateCertificateIssuanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*DeleteCertificateIssuanceConfigRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*CertificateIssuanceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*CertificateIssuanceConfig_CertificateAuthorityConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes[6].OneofWrappers = []any{
		(*CertificateIssuanceConfig_CertificateAuthorityConfig_CertificateAuthorityServiceConfig_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_goTypes,
		DependencyIndexes: file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_depIdxs,
		EnumInfos:         file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_enumTypes,
		MessageInfos:      file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_msgTypes,
	}.Build()
	File_google_cloud_certificatemanager_v1_certificate_issuance_config_proto = out.File
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_rawDesc = nil
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_goTypes = nil
	file_google_cloud_certificatemanager_v1_certificate_issuance_config_proto_depIdxs = nil
}
