// Code generated by smithy-go-codegen DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cognitoidentityprovider/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Given a user pool ID, returns configuration for sign-in with WebAuthn
// authenticators and for multi-factor authentication (MFA). This operation
// describes the following:
//
//   - The WebAuthn relying party (RP) ID and user-verification settings.
//
//   - The required, optional, or disabled state of MFA for all user pool users.
//
//   - The message templates for email and SMS MFA.
//
//   - The enabled or disabled state of time-based one-time password (TOTP) MFA.
//
// Amazon Cognito evaluates Identity and Access Management (IAM) policies in
// requests for this API operation. For this operation, you must use IAM
// credentials to authorize requests, and you must grant yourself the corresponding
// IAM permission in a policy.
//
// # Learn more
//
// [Signing Amazon Web Services API Requests]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]
//
// [Using the Amazon Cognito user pools API and user pool endpoints]: https://docs.aws.amazon.com/cognito/latest/developerguide/user-pools-API-operations.html
// [Signing Amazon Web Services API Requests]: https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html
func (c *Client) GetUserPoolMfaConfig(ctx context.Context, params *GetUserPoolMfaConfigInput, optFns ...func(*Options)) (*GetUserPoolMfaConfigOutput, error) {
	if params == nil {
		params = &GetUserPoolMfaConfigInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetUserPoolMfaConfig", params, optFns, c.addOperationGetUserPoolMfaConfigMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetUserPoolMfaConfigOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetUserPoolMfaConfigInput struct {

	// The ID of the user pool where you want to query WebAuthn and MFA configuration.
	//
	// This member is required.
	UserPoolId *string

	noSmithyDocumentSerde
}

type GetUserPoolMfaConfigOutput struct {

	// Shows configuration for user pool email message MFA and sign-in with one-time
	// passwords (OTPs). Includes the subject and body of the email message template
	// for sign-in and MFA messages. To activate this setting, your user pool must be
	// in the [Essentials tier]or higher.
	//
	// [Essentials tier]: https://docs.aws.amazon.com/cognito/latest/developerguide/feature-plans-features-essentials.html
	EmailMfaConfiguration *types.EmailMfaConfigType

	// Displays the state of multi-factor authentication (MFA) as on, off, or
	// optional. When ON , all users must set up MFA before they can sign in. When
	// OPTIONAL , your application must make a client-side determination of whether a
	// user wants to register an MFA device. For user pools with adaptive
	// authentication with threat protection, choose OPTIONAL .
	//
	// When MfaConfiguration is OPTIONAL , managed login doesn't automatically prompt
	// users to set up MFA. Amazon Cognito generates MFA prompts in API responses and
	// in managed login for users who have chosen and configured a preferred MFA
	// factor.
	MfaConfiguration types.UserPoolMfaType

	// Shows user pool configuration for SMS message MFA. Includes the message
	// template and the SMS message sending configuration for Amazon SNS.
	SmsMfaConfiguration *types.SmsMfaConfigType

	// Shows user pool configuration for time-based one-time password (TOTP) MFA.
	// Includes TOTP enabled or disabled state.
	SoftwareTokenMfaConfiguration *types.SoftwareTokenMfaConfigType

	// Shows user pool configuration for sign-in with passkey authenticators like
	// biometric devices and security keys. Passkeys are not eligible MFA factors. They
	// are instead an eligible primary sign-in factor for [choice-based authentication], or the USER_AUTH flow.
	//
	// [choice-based authentication]: https://docs.aws.amazon.com/cognito/latest/developerguide/authentication-flows-selection-sdk.html#authentication-flows-selection-choice
	WebAuthnConfiguration *types.WebAuthnConfigurationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetUserPoolMfaConfigMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetUserPoolMfaConfig{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetUserPoolMfaConfig{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetUserPoolMfaConfig"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetUserPoolMfaConfigValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetUserPoolMfaConfig(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetUserPoolMfaConfig(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetUserPoolMfaConfig",
	}
}
