// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package protovalidate

import (
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestVariable(t *testing.T) {
	t.Parallel()

	v := variable{Name: "this", Val: "foo"}
	out, ok := v.ResolveName("this")
	assert.True(t, ok)
	assert.Equal(t, v.Val, out)
	_, ok = v.ResolveName("that")
	assert.False(t, ok)
}
