// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.1
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/tuning_job.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Supported adapter sizes for tuning.
type SupervisedHyperParameters_AdapterSize int32

const (
	// Adapter size is unspecified.
	SupervisedHyperParameters_ADAPTER_SIZE_UNSPECIFIED SupervisedHyperParameters_AdapterSize = 0
	// Adapter size 1.
	SupervisedHyperParameters_ADAPTER_SIZE_ONE SupervisedHyperParameters_AdapterSize = 1
	// Adapter size 4.
	SupervisedHyperParameters_ADAPTER_SIZE_FOUR SupervisedHyperParameters_AdapterSize = 2
	// Adapter size 8.
	SupervisedHyperParameters_ADAPTER_SIZE_EIGHT SupervisedHyperParameters_AdapterSize = 3
	// Adapter size 16.
	SupervisedHyperParameters_ADAPTER_SIZE_SIXTEEN SupervisedHyperParameters_AdapterSize = 4
)

// Enum value maps for SupervisedHyperParameters_AdapterSize.
var (
	SupervisedHyperParameters_AdapterSize_name = map[int32]string{
		0: "ADAPTER_SIZE_UNSPECIFIED",
		1: "ADAPTER_SIZE_ONE",
		2: "ADAPTER_SIZE_FOUR",
		3: "ADAPTER_SIZE_EIGHT",
		4: "ADAPTER_SIZE_SIXTEEN",
	}
	SupervisedHyperParameters_AdapterSize_value = map[string]int32{
		"ADAPTER_SIZE_UNSPECIFIED": 0,
		"ADAPTER_SIZE_ONE":         1,
		"ADAPTER_SIZE_FOUR":        2,
		"ADAPTER_SIZE_EIGHT":       3,
		"ADAPTER_SIZE_SIXTEEN":     4,
	}
)

func (x SupervisedHyperParameters_AdapterSize) Enum() *SupervisedHyperParameters_AdapterSize {
	p := new(SupervisedHyperParameters_AdapterSize)
	*p = x
	return p
}

func (x SupervisedHyperParameters_AdapterSize) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SupervisedHyperParameters_AdapterSize) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes[0].Descriptor()
}

func (SupervisedHyperParameters_AdapterSize) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes[0]
}

func (x SupervisedHyperParameters_AdapterSize) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SupervisedHyperParameters_AdapterSize.Descriptor instead.
func (SupervisedHyperParameters_AdapterSize) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{5, 0}
}

// Represents a TuningJob that runs with Google owned models.
type TuningJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceModel:
	//
	//	*TuningJob_BaseModel
	SourceModel isTuningJob_SourceModel `protobuf_oneof:"source_model"`
	// Types that are assignable to TuningSpec:
	//
	//	*TuningJob_SupervisedTuningSpec
	TuningSpec isTuningJob_TuningSpec `protobuf_oneof:"tuning_spec"`
	// Output only. Identifier. Resource name of a TuningJob. Format:
	// `projects/{project}/locations/{location}/tuningJobs/{tuning_job}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The display name of the
	// [TunedModel][google.cloud.aiplatform.v1.Model]. The name can be up to 128
	// characters long and can consist of any UTF-8 characters.
	TunedModelDisplayName string `protobuf:"bytes,2,opt,name=tuned_model_display_name,json=tunedModelDisplayName,proto3" json:"tuned_model_display_name,omitempty"`
	// Optional. The description of the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The detailed state of the job.
	State JobState `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.JobState" json:"state,omitempty"`
	// Output only. Time when the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] for the first time
	// entered the `JOB_STATE_RUNNING` state.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the TuningJob entered any of the following
	// [JobStates][google.cloud.aiplatform.v1.JobState]: `JOB_STATE_SUCCEEDED`,
	// `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`, `JOB_STATE_EXPIRED`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Time when the
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] was most recently
	// updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Only populated when job's state is `JOB_STATE_FAILED` or
	// `JOB_STATE_CANCELLED`.
	Error *status.Status `protobuf:"bytes,11,opt,name=error,proto3" json:"error,omitempty"`
	// Optional. The labels with user-defined metadata to organize
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob] and generated resources
	// such as [Model][google.cloud.aiplatform.v1.Model] and
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint].
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The Experiment associated with this
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	Experiment string `protobuf:"bytes,13,opt,name=experiment,proto3" json:"experiment,omitempty"`
	// Output only. The tuned model resources assiociated with this
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	TunedModel *TunedModel `protobuf:"bytes,14,opt,name=tuned_model,json=tunedModel,proto3" json:"tuned_model,omitempty"`
	// Output only. The tuning data statistics associated with this
	// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
	TuningDataStats *TuningDataStats `protobuf:"bytes,15,opt,name=tuning_data_stats,json=tuningDataStats,proto3" json:"tuning_data_stats,omitempty"`
	// Customer-managed encryption key options for a TuningJob. If this is set,
	// then all resources created by the TuningJob will be encrypted with the
	// provided encryption key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,16,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
}

func (x *TuningJob) Reset() {
	*x = TuningJob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TuningJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningJob) ProtoMessage() {}

func (x *TuningJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningJob.ProtoReflect.Descriptor instead.
func (*TuningJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{0}
}

func (m *TuningJob) GetSourceModel() isTuningJob_SourceModel {
	if m != nil {
		return m.SourceModel
	}
	return nil
}

func (x *TuningJob) GetBaseModel() string {
	if x, ok := x.GetSourceModel().(*TuningJob_BaseModel); ok {
		return x.BaseModel
	}
	return ""
}

func (m *TuningJob) GetTuningSpec() isTuningJob_TuningSpec {
	if m != nil {
		return m.TuningSpec
	}
	return nil
}

func (x *TuningJob) GetSupervisedTuningSpec() *SupervisedTuningSpec {
	if x, ok := x.GetTuningSpec().(*TuningJob_SupervisedTuningSpec); ok {
		return x.SupervisedTuningSpec
	}
	return nil
}

func (x *TuningJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TuningJob) GetTunedModelDisplayName() string {
	if x != nil {
		return x.TunedModelDisplayName
	}
	return ""
}

func (x *TuningJob) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TuningJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *TuningJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TuningJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *TuningJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *TuningJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TuningJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *TuningJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *TuningJob) GetExperiment() string {
	if x != nil {
		return x.Experiment
	}
	return ""
}

func (x *TuningJob) GetTunedModel() *TunedModel {
	if x != nil {
		return x.TunedModel
	}
	return nil
}

func (x *TuningJob) GetTuningDataStats() *TuningDataStats {
	if x != nil {
		return x.TuningDataStats
	}
	return nil
}

func (x *TuningJob) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

type isTuningJob_SourceModel interface {
	isTuningJob_SourceModel()
}

type TuningJob_BaseModel struct {
	// The base model that is being tuned, e.g., "gemini-1.0-pro-002".
	BaseModel string `protobuf:"bytes,4,opt,name=base_model,json=baseModel,proto3,oneof"`
}

func (*TuningJob_BaseModel) isTuningJob_SourceModel() {}

type isTuningJob_TuningSpec interface {
	isTuningJob_TuningSpec()
}

type TuningJob_SupervisedTuningSpec struct {
	// Tuning Spec for Supervised Fine Tuning.
	SupervisedTuningSpec *SupervisedTuningSpec `protobuf:"bytes,5,opt,name=supervised_tuning_spec,json=supervisedTuningSpec,proto3,oneof"`
}

func (*TuningJob_SupervisedTuningSpec) isTuningJob_TuningSpec() {}

// The Model Registry Model and Online Prediction Endpoint assiociated with
// this [TuningJob][google.cloud.aiplatform.v1.TuningJob].
type TunedModel struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the TunedModel. Format:
	// `projects/{project}/locations/{location}/models/{model}`.
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. A resource name of an Endpoint. Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`.
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
}

func (x *TunedModel) Reset() {
	*x = TunedModel{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TunedModel) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TunedModel) ProtoMessage() {}

func (x *TunedModel) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TunedModel.ProtoReflect.Descriptor instead.
func (*TunedModel) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{1}
}

func (x *TunedModel) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *TunedModel) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

// Dataset distribution for Supervised Tuning.
type SupervisedTuningDatasetDistribution struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Sum of a given population of values.
	Sum int64 `protobuf:"varint,1,opt,name=sum,proto3" json:"sum,omitempty"`
	// Output only. The minimum of the population values.
	Min float64 `protobuf:"fixed64,2,opt,name=min,proto3" json:"min,omitempty"`
	// Output only. The maximum of the population values.
	Max float64 `protobuf:"fixed64,3,opt,name=max,proto3" json:"max,omitempty"`
	// Output only. The arithmetic mean of the values in the population.
	Mean float64 `protobuf:"fixed64,4,opt,name=mean,proto3" json:"mean,omitempty"`
	// Output only. The median of the values in the population.
	Median float64 `protobuf:"fixed64,5,opt,name=median,proto3" json:"median,omitempty"`
	// Output only. The 5th percentile of the values in the population.
	P5 float64 `protobuf:"fixed64,6,opt,name=p5,proto3" json:"p5,omitempty"`
	// Output only. The 95th percentile of the values in the population.
	P95 float64 `protobuf:"fixed64,7,opt,name=p95,proto3" json:"p95,omitempty"`
	// Output only. Defines the histogram bucket.
	Buckets []*SupervisedTuningDatasetDistribution_DatasetBucket `protobuf:"bytes,8,rep,name=buckets,proto3" json:"buckets,omitempty"`
}

func (x *SupervisedTuningDatasetDistribution) Reset() {
	*x = SupervisedTuningDatasetDistribution{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupervisedTuningDatasetDistribution) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningDatasetDistribution) ProtoMessage() {}

func (x *SupervisedTuningDatasetDistribution) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningDatasetDistribution.ProtoReflect.Descriptor instead.
func (*SupervisedTuningDatasetDistribution) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{2}
}

func (x *SupervisedTuningDatasetDistribution) GetSum() int64 {
	if x != nil {
		return x.Sum
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMin() float64 {
	if x != nil {
		return x.Min
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMax() float64 {
	if x != nil {
		return x.Max
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMean() float64 {
	if x != nil {
		return x.Mean
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetMedian() float64 {
	if x != nil {
		return x.Median
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetP5() float64 {
	if x != nil {
		return x.P5
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetP95() float64 {
	if x != nil {
		return x.P95
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution) GetBuckets() []*SupervisedTuningDatasetDistribution_DatasetBucket {
	if x != nil {
		return x.Buckets
	}
	return nil
}

// Tuning data statistics for Supervised Tuning.
type SupervisedTuningDataStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of examples in the tuning dataset.
	TuningDatasetExampleCount int64 `protobuf:"varint,1,opt,name=tuning_dataset_example_count,json=tuningDatasetExampleCount,proto3" json:"tuning_dataset_example_count,omitempty"`
	// Output only. Number of tuning characters in the tuning dataset.
	TotalTuningCharacterCount int64 `protobuf:"varint,2,opt,name=total_tuning_character_count,json=totalTuningCharacterCount,proto3" json:"total_tuning_character_count,omitempty"`
	// Output only. Number of billable characters in the tuning dataset.
	TotalBillableCharacterCount int64 `protobuf:"varint,3,opt,name=total_billable_character_count,json=totalBillableCharacterCount,proto3" json:"total_billable_character_count,omitempty"`
	// Output only. Number of tuning steps for this Tuning Job.
	TuningStepCount int64 `protobuf:"varint,4,opt,name=tuning_step_count,json=tuningStepCount,proto3" json:"tuning_step_count,omitempty"`
	// Output only. Dataset distributions for the user input tokens.
	UserInputTokenDistribution *SupervisedTuningDatasetDistribution `protobuf:"bytes,5,opt,name=user_input_token_distribution,json=userInputTokenDistribution,proto3" json:"user_input_token_distribution,omitempty"`
	// Output only. Dataset distributions for the user output tokens.
	UserOutputTokenDistribution *SupervisedTuningDatasetDistribution `protobuf:"bytes,6,opt,name=user_output_token_distribution,json=userOutputTokenDistribution,proto3" json:"user_output_token_distribution,omitempty"`
	// Output only. Dataset distributions for the messages per example.
	UserMessagePerExampleDistribution *SupervisedTuningDatasetDistribution `protobuf:"bytes,7,opt,name=user_message_per_example_distribution,json=userMessagePerExampleDistribution,proto3" json:"user_message_per_example_distribution,omitempty"`
	// Output only. Sample user messages in the training dataset uri.
	UserDatasetExamples []*Content `protobuf:"bytes,8,rep,name=user_dataset_examples,json=userDatasetExamples,proto3" json:"user_dataset_examples,omitempty"`
}

func (x *SupervisedTuningDataStats) Reset() {
	*x = SupervisedTuningDataStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupervisedTuningDataStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningDataStats) ProtoMessage() {}

func (x *SupervisedTuningDataStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningDataStats.ProtoReflect.Descriptor instead.
func (*SupervisedTuningDataStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{3}
}

func (x *SupervisedTuningDataStats) GetTuningDatasetExampleCount() int64 {
	if x != nil {
		return x.TuningDatasetExampleCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTotalTuningCharacterCount() int64 {
	if x != nil {
		return x.TotalTuningCharacterCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTotalBillableCharacterCount() int64 {
	if x != nil {
		return x.TotalBillableCharacterCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetTuningStepCount() int64 {
	if x != nil {
		return x.TuningStepCount
	}
	return 0
}

func (x *SupervisedTuningDataStats) GetUserInputTokenDistribution() *SupervisedTuningDatasetDistribution {
	if x != nil {
		return x.UserInputTokenDistribution
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetUserOutputTokenDistribution() *SupervisedTuningDatasetDistribution {
	if x != nil {
		return x.UserOutputTokenDistribution
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetUserMessagePerExampleDistribution() *SupervisedTuningDatasetDistribution {
	if x != nil {
		return x.UserMessagePerExampleDistribution
	}
	return nil
}

func (x *SupervisedTuningDataStats) GetUserDatasetExamples() []*Content {
	if x != nil {
		return x.UserDatasetExamples
	}
	return nil
}

// The tuning data statistic values for
// [TuningJob][google.cloud.aiplatform.v1.TuningJob].
type TuningDataStats struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to TuningDataStats:
	//
	//	*TuningDataStats_SupervisedTuningDataStats
	TuningDataStats isTuningDataStats_TuningDataStats `protobuf_oneof:"tuning_data_stats"`
}

func (x *TuningDataStats) Reset() {
	*x = TuningDataStats{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TuningDataStats) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TuningDataStats) ProtoMessage() {}

func (x *TuningDataStats) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TuningDataStats.ProtoReflect.Descriptor instead.
func (*TuningDataStats) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{4}
}

func (m *TuningDataStats) GetTuningDataStats() isTuningDataStats_TuningDataStats {
	if m != nil {
		return m.TuningDataStats
	}
	return nil
}

func (x *TuningDataStats) GetSupervisedTuningDataStats() *SupervisedTuningDataStats {
	if x, ok := x.GetTuningDataStats().(*TuningDataStats_SupervisedTuningDataStats); ok {
		return x.SupervisedTuningDataStats
	}
	return nil
}

type isTuningDataStats_TuningDataStats interface {
	isTuningDataStats_TuningDataStats()
}

type TuningDataStats_SupervisedTuningDataStats struct {
	// The SFT Tuning data stats.
	SupervisedTuningDataStats *SupervisedTuningDataStats `protobuf:"bytes,1,opt,name=supervised_tuning_data_stats,json=supervisedTuningDataStats,proto3,oneof"`
}

func (*TuningDataStats_SupervisedTuningDataStats) isTuningDataStats_TuningDataStats() {}

// Hyperparameters for SFT.
type SupervisedHyperParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Number of complete passes the model makes over the entire
	// training dataset during training.
	EpochCount int64 `protobuf:"varint,1,opt,name=epoch_count,json=epochCount,proto3" json:"epoch_count,omitempty"`
	// Optional. Multiplier for adjusting the default learning rate.
	LearningRateMultiplier float64 `protobuf:"fixed64,2,opt,name=learning_rate_multiplier,json=learningRateMultiplier,proto3" json:"learning_rate_multiplier,omitempty"`
	// Optional. Adapter size for tuning.
	AdapterSize SupervisedHyperParameters_AdapterSize `protobuf:"varint,3,opt,name=adapter_size,json=adapterSize,proto3,enum=google.cloud.aiplatform.v1beta1.SupervisedHyperParameters_AdapterSize" json:"adapter_size,omitempty"`
}

func (x *SupervisedHyperParameters) Reset() {
	*x = SupervisedHyperParameters{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupervisedHyperParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedHyperParameters) ProtoMessage() {}

func (x *SupervisedHyperParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedHyperParameters.ProtoReflect.Descriptor instead.
func (*SupervisedHyperParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{5}
}

func (x *SupervisedHyperParameters) GetEpochCount() int64 {
	if x != nil {
		return x.EpochCount
	}
	return 0
}

func (x *SupervisedHyperParameters) GetLearningRateMultiplier() float64 {
	if x != nil {
		return x.LearningRateMultiplier
	}
	return 0
}

func (x *SupervisedHyperParameters) GetAdapterSize() SupervisedHyperParameters_AdapterSize {
	if x != nil {
		return x.AdapterSize
	}
	return SupervisedHyperParameters_ADAPTER_SIZE_UNSPECIFIED
}

// Tuning Spec for Supervised Tuning.
type SupervisedTuningSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Cloud Storage path to file containing training dataset for
	// tuning. The dataset must be formatted as a JSONL file.
	TrainingDatasetUri string `protobuf:"bytes,1,opt,name=training_dataset_uri,json=trainingDatasetUri,proto3" json:"training_dataset_uri,omitempty"`
	// Optional. Cloud Storage path to file containing validation dataset for
	// tuning. The dataset must be formatted as a JSONL file.
	ValidationDatasetUri string `protobuf:"bytes,2,opt,name=validation_dataset_uri,json=validationDatasetUri,proto3" json:"validation_dataset_uri,omitempty"`
	// Optional. Hyperparameters for SFT.
	HyperParameters *SupervisedHyperParameters `protobuf:"bytes,3,opt,name=hyper_parameters,json=hyperParameters,proto3" json:"hyper_parameters,omitempty"`
}

func (x *SupervisedTuningSpec) Reset() {
	*x = SupervisedTuningSpec{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupervisedTuningSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningSpec) ProtoMessage() {}

func (x *SupervisedTuningSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningSpec.ProtoReflect.Descriptor instead.
func (*SupervisedTuningSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{6}
}

func (x *SupervisedTuningSpec) GetTrainingDatasetUri() string {
	if x != nil {
		return x.TrainingDatasetUri
	}
	return ""
}

func (x *SupervisedTuningSpec) GetValidationDatasetUri() string {
	if x != nil {
		return x.ValidationDatasetUri
	}
	return ""
}

func (x *SupervisedTuningSpec) GetHyperParameters() *SupervisedHyperParameters {
	if x != nil {
		return x.HyperParameters
	}
	return nil
}

// Dataset bucket used to create a histogram for the distribution given a
// population of values.
type SupervisedTuningDatasetDistribution_DatasetBucket struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Number of values in the bucket.
	Count float64 `protobuf:"fixed64,1,opt,name=count,proto3" json:"count,omitempty"`
	// Output only. Left bound of the bucket.
	Left float64 `protobuf:"fixed64,2,opt,name=left,proto3" json:"left,omitempty"`
	// Output only. Right bound of the bucket.
	Right float64 `protobuf:"fixed64,3,opt,name=right,proto3" json:"right,omitempty"`
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) Reset() {
	*x = SupervisedTuningDatasetDistribution_DatasetBucket{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SupervisedTuningDatasetDistribution_DatasetBucket) ProtoMessage() {}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SupervisedTuningDatasetDistribution_DatasetBucket.ProtoReflect.Descriptor instead.
func (*SupervisedTuningDatasetDistribution_DatasetBucket) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP(), []int{2, 0}
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) GetCount() float64 {
	if x != nil {
		return x.Count
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) GetLeft() float64 {
	if x != nil {
		return x.Left
	}
	return 0
}

func (x *SupervisedTuningDatasetDistribution_DatasetBucket) GetRight() float64 {
	if x != nil {
		return x.Right
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_tuning_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x9e, 0x0a, 0x0a, 0x09, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x1f,
	0x0a, 0x0a, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x09, 0x62, 0x61, 0x73, 0x65, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x6d, 0x0a, 0x16, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x5f, 0x74, 0x75,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69,
	0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x48, 0x01, 0x52, 0x14, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76,
	0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1a,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x08, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x3c, 0x0a, 0x18, 0x74, 0x75,
	0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x15, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x44, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0b,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65,
	0x72, 0x72, 0x6f, 0x72, 0x12, 0x53, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x49, 0x0a, 0x0a, 0x65, 0x78, 0x70,
	0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x52, 0x0a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a, 0x0b, 0x74, 0x75, 0x6e, 0x65, 0x64, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x65,
	0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x74, 0x75, 0x6e,
	0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x61, 0x0a, 0x11, 0x74, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x53, 0x70, 0x65, 0x63, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a,
	0x80, 0x01, 0xea, 0x41, 0x7d, 0x0a, 0x23, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x12, 0x3f, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b,
	0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x2a, 0x0a, 0x74, 0x75, 0x6e,
	0x69, 0x6e, 0x67, 0x4a, 0x6f, 0x62, 0x73, 0x32, 0x09, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a,
	0x6f, 0x62, 0x42, 0x0e, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x42, 0x0d, 0x0a, 0x0b, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x22, 0x93, 0x01, 0x0a, 0x0a, 0x54, 0x75, 0x6e, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c,
	0x12, 0x3d, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x27, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12,
	0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x22, 0x9f, 0x03, 0x0a, 0x23, 0x53, 0x75, 0x70, 0x65,
	0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x15, 0x0a, 0x03, 0x73, 0x75, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12, 0x15, 0x0a, 0x03, 0x6d, 0x69, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x6d, 0x69, 0x6e, 0x12, 0x15, 0x0a,
	0x03, 0x6d, 0x61, 0x78, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x03, 0x6d, 0x61, 0x78, 0x12, 0x17, 0x0a, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6d, 0x65, 0x61, 0x6e, 0x12, 0x1b, 0x0a,
	0x06, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x06, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x12, 0x13, 0x0a, 0x02, 0x70, 0x35,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x02, 0x70, 0x35, 0x12,
	0x15, 0x0a, 0x03, 0x70, 0x39, 0x35, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x03, 0x70, 0x39, 0x35, 0x12, 0x71, 0x0a, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76,
	0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x1a, 0x5e, 0x0a, 0x0d, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x12, 0x19, 0x0a, 0x05, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6c, 0x65, 0x66, 0x74, 0x12, 0x19,
	0x0a, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0xc3, 0x06, 0x0a, 0x19, 0x53, 0x75,
	0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x44, 0x0a, 0x1c, 0x74, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c,
	0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x19, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x44, 0x0a,
	0x1c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x54,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x48, 0x0a, 0x1e, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c,
	0x6c, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x43,
	0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x2f, 0x0a,
	0x11, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x74,
	0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x8c,
	0x01, 0x0a, 0x1d, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1a, 0x75, 0x73, 0x65, 0x72, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01,
	0x0a, 0x1e, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1b, 0x75, 0x73, 0x65, 0x72, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x9b,
	0x01, 0x0a, 0x25, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x70, 0x65, 0x72, 0x5f, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x74,
	0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e,
	0x67, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x21, 0x75, 0x73, 0x65, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x44, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x15,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x65, 0x78, 0x61,
	0x6d, 0x70, 0x6c, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x75, 0x73, 0x65, 0x72,
	0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x22,
	0xa5, 0x01, 0x0a, 0x0f, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x12, 0x7d, 0x0a, 0x1c, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65,
	0x64, 0x5f, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74,
	0x61, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65,
	0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x61, 0x74, 0x73, 0x48, 0x00, 0x52, 0x19, 0x73, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69,
	0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x74, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x22, 0xfd, 0x02, 0x0a, 0x19, 0x53, 0x75, 0x70, 0x65,
	0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x65, 0x70, 0x6f, 0x63, 0x68, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3d, 0x0a, 0x18, 0x6c,
	0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x16, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x74, 0x65,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69, 0x65, 0x72, 0x12, 0x6e, 0x0a, 0x0c, 0x61, 0x64,
	0x61, 0x70, 0x74, 0x65, 0x72, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x53, 0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x48, 0x79, 0x70,
	0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2e, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x61,
	0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x0b, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x65, 0x72, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x41, 0x44,
	0x41, 0x50, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x44, 0x41, 0x50,
	0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x15,
	0x0a, 0x11, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x46,
	0x4f, 0x55, 0x52, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52,
	0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x45, 0x49, 0x47, 0x48, 0x54, 0x10, 0x03, 0x12, 0x18, 0x0a,
	0x14, 0x41, 0x44, 0x41, 0x50, 0x54, 0x45, 0x52, 0x5f, 0x53, 0x49, 0x5a, 0x45, 0x5f, 0x53, 0x49,
	0x58, 0x54, 0x45, 0x45, 0x4e, 0x10, 0x04, 0x22, 0xf4, 0x01, 0x0a, 0x14, 0x53, 0x75, 0x70, 0x65,
	0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x35, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x12, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x44, 0x61, 0x74,
	0x61, 0x73, 0x65, 0x74, 0x55, 0x72, 0x69, 0x12, 0x39, 0x0a, 0x16, 0x76, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x55,
	0x72, 0x69, 0x12, 0x6a, 0x0a, 0x10, 0x68, 0x79, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53,
	0x75, 0x70, 0x65, 0x72, 0x76, 0x69, 0x73, 0x65, 0x64, 0x48, 0x79, 0x70, 0x65, 0x72, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x68,
	0x79, 0x70, 0x65, 0x72, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0xe5,
	0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0e, 0x54, 0x75, 0x6e, 0x69, 0x6e, 0x67, 0x4a, 0x6f,
	0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes = make([]protoimpl.MessageInfo, 9)
var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_goTypes = []interface{}{
	(SupervisedHyperParameters_AdapterSize)(0),  // 0: google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.AdapterSize
	(*TuningJob)(nil),                           // 1: google.cloud.aiplatform.v1beta1.TuningJob
	(*TunedModel)(nil),                          // 2: google.cloud.aiplatform.v1beta1.TunedModel
	(*SupervisedTuningDatasetDistribution)(nil), // 3: google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	(*SupervisedTuningDataStats)(nil),           // 4: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats
	(*TuningDataStats)(nil),                     // 5: google.cloud.aiplatform.v1beta1.TuningDataStats
	(*SupervisedHyperParameters)(nil),           // 6: google.cloud.aiplatform.v1beta1.SupervisedHyperParameters
	(*SupervisedTuningSpec)(nil),                // 7: google.cloud.aiplatform.v1beta1.SupervisedTuningSpec
	nil,                                         // 8: google.cloud.aiplatform.v1beta1.TuningJob.LabelsEntry
	(*SupervisedTuningDatasetDistribution_DatasetBucket)(nil), // 9: google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution.DatasetBucket
	(JobState)(0),                 // 10: google.cloud.aiplatform.v1beta1.JobState
	(*timestamppb.Timestamp)(nil), // 11: google.protobuf.Timestamp
	(*status.Status)(nil),         // 12: google.rpc.Status
	(*EncryptionSpec)(nil),        // 13: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*Content)(nil),               // 14: google.cloud.aiplatform.v1beta1.Content
}
var file_google_cloud_aiplatform_v1beta1_tuning_job_proto_depIdxs = []int32{
	7,  // 0: google.cloud.aiplatform.v1beta1.TuningJob.supervised_tuning_spec:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningSpec
	10, // 1: google.cloud.aiplatform.v1beta1.TuningJob.state:type_name -> google.cloud.aiplatform.v1beta1.JobState
	11, // 2: google.cloud.aiplatform.v1beta1.TuningJob.create_time:type_name -> google.protobuf.Timestamp
	11, // 3: google.cloud.aiplatform.v1beta1.TuningJob.start_time:type_name -> google.protobuf.Timestamp
	11, // 4: google.cloud.aiplatform.v1beta1.TuningJob.end_time:type_name -> google.protobuf.Timestamp
	11, // 5: google.cloud.aiplatform.v1beta1.TuningJob.update_time:type_name -> google.protobuf.Timestamp
	12, // 6: google.cloud.aiplatform.v1beta1.TuningJob.error:type_name -> google.rpc.Status
	8,  // 7: google.cloud.aiplatform.v1beta1.TuningJob.labels:type_name -> google.cloud.aiplatform.v1beta1.TuningJob.LabelsEntry
	2,  // 8: google.cloud.aiplatform.v1beta1.TuningJob.tuned_model:type_name -> google.cloud.aiplatform.v1beta1.TunedModel
	5,  // 9: google.cloud.aiplatform.v1beta1.TuningJob.tuning_data_stats:type_name -> google.cloud.aiplatform.v1beta1.TuningDataStats
	13, // 10: google.cloud.aiplatform.v1beta1.TuningJob.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	9,  // 11: google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution.buckets:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution.DatasetBucket
	3,  // 12: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_input_token_distribution:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	3,  // 13: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_output_token_distribution:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	3,  // 14: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_message_per_example_distribution:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDatasetDistribution
	14, // 15: google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats.user_dataset_examples:type_name -> google.cloud.aiplatform.v1beta1.Content
	4,  // 16: google.cloud.aiplatform.v1beta1.TuningDataStats.supervised_tuning_data_stats:type_name -> google.cloud.aiplatform.v1beta1.SupervisedTuningDataStats
	0,  // 17: google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.adapter_size:type_name -> google.cloud.aiplatform.v1beta1.SupervisedHyperParameters.AdapterSize
	6,  // 18: google.cloud.aiplatform.v1beta1.SupervisedTuningSpec.hyper_parameters:type_name -> google.cloud.aiplatform.v1beta1.SupervisedHyperParameters
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_tuning_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_tuning_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_tuning_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_init()
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_job_state_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TuningJob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TunedModel); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupervisedTuningDatasetDistribution); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupervisedTuningDataStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TuningDataStats); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupervisedHyperParameters); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupervisedTuningSpec); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SupervisedTuningDatasetDistribution_DatasetBucket); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*TuningJob_BaseModel)(nil),
		(*TuningJob_SupervisedTuningSpec)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*TuningDataStats_SupervisedTuningDataStats)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   9,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_tuning_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_tuning_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_tuning_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_tuning_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_tuning_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_tuning_job_proto_depIdxs = nil
}
