// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1/evaluation_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Pairwise prediction autorater preference.
type PairwiseChoice int32

const (
	// Unspecified prediction choice.
	PairwiseChoice_PAIRWISE_CHOICE_UNSPECIFIED PairwiseChoice = 0
	// Baseline prediction wins
	PairwiseChoice_BASELINE PairwiseChoice = 1
	// Candidate prediction wins
	PairwiseChoice_CANDIDATE PairwiseChoice = 2
	// Winner cannot be determined
	PairwiseChoice_TIE PairwiseChoice = 3
)

// Enum value maps for PairwiseChoice.
var (
	PairwiseChoice_name = map[int32]string{
		0: "PAIRWISE_CHOICE_UNSPECIFIED",
		1: "BASELINE",
		2: "CANDIDATE",
		3: "TIE",
	}
	PairwiseChoice_value = map[string]int32{
		"PAIRWISE_CHOICE_UNSPECIFIED": 0,
		"BASELINE":                    1,
		"CANDIDATE":                   2,
		"TIE":                         3,
	}
)

func (x PairwiseChoice) Enum() *PairwiseChoice {
	p := new(PairwiseChoice)
	*p = x
	return p
}

func (x PairwiseChoice) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PairwiseChoice) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes[0].Descriptor()
}

func (PairwiseChoice) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes[0]
}

func (x PairwiseChoice) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PairwiseChoice.Descriptor instead.
func (PairwiseChoice) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{0}
}

// Comet version options.
type CometSpec_CometVersion int32

const (
	// Comet version unspecified.
	CometSpec_COMET_VERSION_UNSPECIFIED CometSpec_CometVersion = 0
	// Comet 22 for translation + source + reference
	// (source-reference-combined).
	CometSpec_COMET_22_SRC_REF CometSpec_CometVersion = 2
)

// Enum value maps for CometSpec_CometVersion.
var (
	CometSpec_CometVersion_name = map[int32]string{
		0: "COMET_VERSION_UNSPECIFIED",
		2: "COMET_22_SRC_REF",
	}
	CometSpec_CometVersion_value = map[string]int32{
		"COMET_VERSION_UNSPECIFIED": 0,
		"COMET_22_SRC_REF":          2,
	}
)

func (x CometSpec_CometVersion) Enum() *CometSpec_CometVersion {
	p := new(CometSpec_CometVersion)
	*p = x
	return p
}

func (x CometSpec_CometVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CometSpec_CometVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes[1].Descriptor()
}

func (CometSpec_CometVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes[1]
}

func (x CometSpec_CometVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CometSpec_CometVersion.Descriptor instead.
func (CometSpec_CometVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{102, 0}
}

// MetricX Version options.
type MetricxSpec_MetricxVersion int32

const (
	// MetricX version unspecified.
	MetricxSpec_METRICX_VERSION_UNSPECIFIED MetricxSpec_MetricxVersion = 0
	// MetricX 2024 (2.6) for translation + reference (reference-based).
	MetricxSpec_METRICX_24_REF MetricxSpec_MetricxVersion = 1
	// MetricX 2024 (2.6) for translation + source (QE).
	MetricxSpec_METRICX_24_SRC MetricxSpec_MetricxVersion = 2
	// MetricX 2024 (2.6) for translation + source + reference
	// (source-reference-combined).
	MetricxSpec_METRICX_24_SRC_REF MetricxSpec_MetricxVersion = 3
)

// Enum value maps for MetricxSpec_MetricxVersion.
var (
	MetricxSpec_MetricxVersion_name = map[int32]string{
		0: "METRICX_VERSION_UNSPECIFIED",
		1: "METRICX_24_REF",
		2: "METRICX_24_SRC",
		3: "METRICX_24_SRC_REF",
	}
	MetricxSpec_MetricxVersion_value = map[string]int32{
		"METRICX_VERSION_UNSPECIFIED": 0,
		"METRICX_24_REF":              1,
		"METRICX_24_SRC":              2,
		"METRICX_24_SRC_REF":          3,
	}
)

func (x MetricxSpec_MetricxVersion) Enum() *MetricxSpec_MetricxVersion {
	p := new(MetricxSpec_MetricxVersion)
	*p = x
	return p
}

func (x MetricxSpec_MetricxVersion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricxSpec_MetricxVersion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes[2].Descriptor()
}

func (MetricxSpec_MetricxVersion) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes[2]
}

func (x MetricxSpec_MetricxVersion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MetricxSpec_MetricxVersion.Descriptor instead.
func (MetricxSpec_MetricxVersion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{106, 0}
}

// Request message for EvaluationService.EvaluateInstances.
type EvaluateInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instances and specs for evaluation
	//
	// Types that are assignable to MetricInputs:
	//
	//	*EvaluateInstancesRequest_ExactMatchInput
	//	*EvaluateInstancesRequest_BleuInput
	//	*EvaluateInstancesRequest_RougeInput
	//	*EvaluateInstancesRequest_FluencyInput
	//	*EvaluateInstancesRequest_CoherenceInput
	//	*EvaluateInstancesRequest_SafetyInput
	//	*EvaluateInstancesRequest_GroundednessInput
	//	*EvaluateInstancesRequest_FulfillmentInput
	//	*EvaluateInstancesRequest_SummarizationQualityInput
	//	*EvaluateInstancesRequest_PairwiseSummarizationQualityInput
	//	*EvaluateInstancesRequest_SummarizationHelpfulnessInput
	//	*EvaluateInstancesRequest_SummarizationVerbosityInput
	//	*EvaluateInstancesRequest_QuestionAnsweringQualityInput
	//	*EvaluateInstancesRequest_PairwiseQuestionAnsweringQualityInput
	//	*EvaluateInstancesRequest_QuestionAnsweringRelevanceInput
	//	*EvaluateInstancesRequest_QuestionAnsweringHelpfulnessInput
	//	*EvaluateInstancesRequest_QuestionAnsweringCorrectnessInput
	//	*EvaluateInstancesRequest_PointwiseMetricInput
	//	*EvaluateInstancesRequest_PairwiseMetricInput
	//	*EvaluateInstancesRequest_ToolCallValidInput
	//	*EvaluateInstancesRequest_ToolNameMatchInput
	//	*EvaluateInstancesRequest_ToolParameterKeyMatchInput
	//	*EvaluateInstancesRequest_ToolParameterKvMatchInput
	//	*EvaluateInstancesRequest_CometInput
	//	*EvaluateInstancesRequest_MetricxInput
	MetricInputs isEvaluateInstancesRequest_MetricInputs `protobuf_oneof:"metric_inputs"`
	// Required. The resource name of the Location to evaluate the instances.
	// Format: `projects/{project}/locations/{location}`
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
}

func (x *EvaluateInstancesRequest) Reset() {
	*x = EvaluateInstancesRequest{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluateInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateInstancesRequest) ProtoMessage() {}

func (x *EvaluateInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateInstancesRequest.ProtoReflect.Descriptor instead.
func (*EvaluateInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{0}
}

func (m *EvaluateInstancesRequest) GetMetricInputs() isEvaluateInstancesRequest_MetricInputs {
	if m != nil {
		return m.MetricInputs
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetExactMatchInput() *ExactMatchInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_ExactMatchInput); ok {
		return x.ExactMatchInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetBleuInput() *BleuInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_BleuInput); ok {
		return x.BleuInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetRougeInput() *RougeInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_RougeInput); ok {
		return x.RougeInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetFluencyInput() *FluencyInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_FluencyInput); ok {
		return x.FluencyInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetCoherenceInput() *CoherenceInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_CoherenceInput); ok {
		return x.CoherenceInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetSafetyInput() *SafetyInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_SafetyInput); ok {
		return x.SafetyInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetGroundednessInput() *GroundednessInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_GroundednessInput); ok {
		return x.GroundednessInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetFulfillmentInput() *FulfillmentInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_FulfillmentInput); ok {
		return x.FulfillmentInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetSummarizationQualityInput() *SummarizationQualityInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_SummarizationQualityInput); ok {
		return x.SummarizationQualityInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetPairwiseSummarizationQualityInput() *PairwiseSummarizationQualityInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_PairwiseSummarizationQualityInput); ok {
		return x.PairwiseSummarizationQualityInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetSummarizationHelpfulnessInput() *SummarizationHelpfulnessInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_SummarizationHelpfulnessInput); ok {
		return x.SummarizationHelpfulnessInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetSummarizationVerbosityInput() *SummarizationVerbosityInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_SummarizationVerbosityInput); ok {
		return x.SummarizationVerbosityInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetQuestionAnsweringQualityInput() *QuestionAnsweringQualityInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_QuestionAnsweringQualityInput); ok {
		return x.QuestionAnsweringQualityInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetPairwiseQuestionAnsweringQualityInput() *PairwiseQuestionAnsweringQualityInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_PairwiseQuestionAnsweringQualityInput); ok {
		return x.PairwiseQuestionAnsweringQualityInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetQuestionAnsweringRelevanceInput() *QuestionAnsweringRelevanceInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_QuestionAnsweringRelevanceInput); ok {
		return x.QuestionAnsweringRelevanceInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetQuestionAnsweringHelpfulnessInput() *QuestionAnsweringHelpfulnessInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_QuestionAnsweringHelpfulnessInput); ok {
		return x.QuestionAnsweringHelpfulnessInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetQuestionAnsweringCorrectnessInput() *QuestionAnsweringCorrectnessInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_QuestionAnsweringCorrectnessInput); ok {
		return x.QuestionAnsweringCorrectnessInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetPointwiseMetricInput() *PointwiseMetricInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_PointwiseMetricInput); ok {
		return x.PointwiseMetricInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetPairwiseMetricInput() *PairwiseMetricInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_PairwiseMetricInput); ok {
		return x.PairwiseMetricInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetToolCallValidInput() *ToolCallValidInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_ToolCallValidInput); ok {
		return x.ToolCallValidInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetToolNameMatchInput() *ToolNameMatchInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_ToolNameMatchInput); ok {
		return x.ToolNameMatchInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetToolParameterKeyMatchInput() *ToolParameterKeyMatchInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_ToolParameterKeyMatchInput); ok {
		return x.ToolParameterKeyMatchInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetToolParameterKvMatchInput() *ToolParameterKVMatchInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_ToolParameterKvMatchInput); ok {
		return x.ToolParameterKvMatchInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetCometInput() *CometInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_CometInput); ok {
		return x.CometInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetMetricxInput() *MetricxInput {
	if x, ok := x.GetMetricInputs().(*EvaluateInstancesRequest_MetricxInput); ok {
		return x.MetricxInput
	}
	return nil
}

func (x *EvaluateInstancesRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

type isEvaluateInstancesRequest_MetricInputs interface {
	isEvaluateInstancesRequest_MetricInputs()
}

type EvaluateInstancesRequest_ExactMatchInput struct {
	// Auto metric instances.
	// Instances and metric spec for exact match metric.
	ExactMatchInput *ExactMatchInput `protobuf:"bytes,2,opt,name=exact_match_input,json=exactMatchInput,proto3,oneof"`
}

type EvaluateInstancesRequest_BleuInput struct {
	// Instances and metric spec for bleu metric.
	BleuInput *BleuInput `protobuf:"bytes,3,opt,name=bleu_input,json=bleuInput,proto3,oneof"`
}

type EvaluateInstancesRequest_RougeInput struct {
	// Instances and metric spec for rouge metric.
	RougeInput *RougeInput `protobuf:"bytes,4,opt,name=rouge_input,json=rougeInput,proto3,oneof"`
}

type EvaluateInstancesRequest_FluencyInput struct {
	// LLM-based metric instance.
	// General text generation metrics, applicable to other categories.
	// Input for fluency metric.
	FluencyInput *FluencyInput `protobuf:"bytes,5,opt,name=fluency_input,json=fluencyInput,proto3,oneof"`
}

type EvaluateInstancesRequest_CoherenceInput struct {
	// Input for coherence metric.
	CoherenceInput *CoherenceInput `protobuf:"bytes,6,opt,name=coherence_input,json=coherenceInput,proto3,oneof"`
}

type EvaluateInstancesRequest_SafetyInput struct {
	// Input for safety metric.
	SafetyInput *SafetyInput `protobuf:"bytes,8,opt,name=safety_input,json=safetyInput,proto3,oneof"`
}

type EvaluateInstancesRequest_GroundednessInput struct {
	// Input for groundedness metric.
	GroundednessInput *GroundednessInput `protobuf:"bytes,9,opt,name=groundedness_input,json=groundednessInput,proto3,oneof"`
}

type EvaluateInstancesRequest_FulfillmentInput struct {
	// Input for fulfillment metric.
	FulfillmentInput *FulfillmentInput `protobuf:"bytes,12,opt,name=fulfillment_input,json=fulfillmentInput,proto3,oneof"`
}

type EvaluateInstancesRequest_SummarizationQualityInput struct {
	// Input for summarization quality metric.
	SummarizationQualityInput *SummarizationQualityInput `protobuf:"bytes,7,opt,name=summarization_quality_input,json=summarizationQualityInput,proto3,oneof"`
}

type EvaluateInstancesRequest_PairwiseSummarizationQualityInput struct {
	// Input for pairwise summarization quality metric.
	PairwiseSummarizationQualityInput *PairwiseSummarizationQualityInput `protobuf:"bytes,23,opt,name=pairwise_summarization_quality_input,json=pairwiseSummarizationQualityInput,proto3,oneof"`
}

type EvaluateInstancesRequest_SummarizationHelpfulnessInput struct {
	// Input for summarization helpfulness metric.
	SummarizationHelpfulnessInput *SummarizationHelpfulnessInput `protobuf:"bytes,14,opt,name=summarization_helpfulness_input,json=summarizationHelpfulnessInput,proto3,oneof"`
}

type EvaluateInstancesRequest_SummarizationVerbosityInput struct {
	// Input for summarization verbosity metric.
	SummarizationVerbosityInput *SummarizationVerbosityInput `protobuf:"bytes,15,opt,name=summarization_verbosity_input,json=summarizationVerbosityInput,proto3,oneof"`
}

type EvaluateInstancesRequest_QuestionAnsweringQualityInput struct {
	// Input for question answering quality metric.
	QuestionAnsweringQualityInput *QuestionAnsweringQualityInput `protobuf:"bytes,10,opt,name=question_answering_quality_input,json=questionAnsweringQualityInput,proto3,oneof"`
}

type EvaluateInstancesRequest_PairwiseQuestionAnsweringQualityInput struct {
	// Input for pairwise question answering quality metric.
	PairwiseQuestionAnsweringQualityInput *PairwiseQuestionAnsweringQualityInput `protobuf:"bytes,24,opt,name=pairwise_question_answering_quality_input,json=pairwiseQuestionAnsweringQualityInput,proto3,oneof"`
}

type EvaluateInstancesRequest_QuestionAnsweringRelevanceInput struct {
	// Input for question answering relevance metric.
	QuestionAnsweringRelevanceInput *QuestionAnsweringRelevanceInput `protobuf:"bytes,16,opt,name=question_answering_relevance_input,json=questionAnsweringRelevanceInput,proto3,oneof"`
}

type EvaluateInstancesRequest_QuestionAnsweringHelpfulnessInput struct {
	// Input for question answering helpfulness
	// metric.
	QuestionAnsweringHelpfulnessInput *QuestionAnsweringHelpfulnessInput `protobuf:"bytes,17,opt,name=question_answering_helpfulness_input,json=questionAnsweringHelpfulnessInput,proto3,oneof"`
}

type EvaluateInstancesRequest_QuestionAnsweringCorrectnessInput struct {
	// Input for question answering correctness
	// metric.
	QuestionAnsweringCorrectnessInput *QuestionAnsweringCorrectnessInput `protobuf:"bytes,18,opt,name=question_answering_correctness_input,json=questionAnsweringCorrectnessInput,proto3,oneof"`
}

type EvaluateInstancesRequest_PointwiseMetricInput struct {
	// Input for pointwise metric.
	PointwiseMetricInput *PointwiseMetricInput `protobuf:"bytes,28,opt,name=pointwise_metric_input,json=pointwiseMetricInput,proto3,oneof"`
}

type EvaluateInstancesRequest_PairwiseMetricInput struct {
	// Input for pairwise metric.
	PairwiseMetricInput *PairwiseMetricInput `protobuf:"bytes,29,opt,name=pairwise_metric_input,json=pairwiseMetricInput,proto3,oneof"`
}

type EvaluateInstancesRequest_ToolCallValidInput struct {
	// Tool call metric instances.
	// Input for tool call valid metric.
	ToolCallValidInput *ToolCallValidInput `protobuf:"bytes,19,opt,name=tool_call_valid_input,json=toolCallValidInput,proto3,oneof"`
}

type EvaluateInstancesRequest_ToolNameMatchInput struct {
	// Input for tool name match metric.
	ToolNameMatchInput *ToolNameMatchInput `protobuf:"bytes,20,opt,name=tool_name_match_input,json=toolNameMatchInput,proto3,oneof"`
}

type EvaluateInstancesRequest_ToolParameterKeyMatchInput struct {
	// Input for tool parameter key match metric.
	ToolParameterKeyMatchInput *ToolParameterKeyMatchInput `protobuf:"bytes,21,opt,name=tool_parameter_key_match_input,json=toolParameterKeyMatchInput,proto3,oneof"`
}

type EvaluateInstancesRequest_ToolParameterKvMatchInput struct {
	// Input for tool parameter key value match metric.
	ToolParameterKvMatchInput *ToolParameterKVMatchInput `protobuf:"bytes,22,opt,name=tool_parameter_kv_match_input,json=toolParameterKvMatchInput,proto3,oneof"`
}

type EvaluateInstancesRequest_CometInput struct {
	// Translation metrics.
	// Input for Comet metric.
	CometInput *CometInput `protobuf:"bytes,31,opt,name=comet_input,json=cometInput,proto3,oneof"`
}

type EvaluateInstancesRequest_MetricxInput struct {
	// Input for Metricx metric.
	MetricxInput *MetricxInput `protobuf:"bytes,32,opt,name=metricx_input,json=metricxInput,proto3,oneof"`
}

func (*EvaluateInstancesRequest_ExactMatchInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_BleuInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_RougeInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_FluencyInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_CoherenceInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_SafetyInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_GroundednessInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_FulfillmentInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_SummarizationQualityInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_PairwiseSummarizationQualityInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_SummarizationHelpfulnessInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_SummarizationVerbosityInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_QuestionAnsweringQualityInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_PairwiseQuestionAnsweringQualityInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_QuestionAnsweringRelevanceInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_QuestionAnsweringHelpfulnessInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_QuestionAnsweringCorrectnessInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_PointwiseMetricInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_PairwiseMetricInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_ToolCallValidInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_ToolNameMatchInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_ToolParameterKeyMatchInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_ToolParameterKvMatchInput) isEvaluateInstancesRequest_MetricInputs() {
}

func (*EvaluateInstancesRequest_CometInput) isEvaluateInstancesRequest_MetricInputs() {}

func (*EvaluateInstancesRequest_MetricxInput) isEvaluateInstancesRequest_MetricInputs() {}

// Response message for EvaluationService.EvaluateInstances.
type EvaluateInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Evaluation results will be served in the same order as presented in
	// EvaluationRequest.instances.
	//
	// Types that are assignable to EvaluationResults:
	//
	//	*EvaluateInstancesResponse_ExactMatchResults
	//	*EvaluateInstancesResponse_BleuResults
	//	*EvaluateInstancesResponse_RougeResults
	//	*EvaluateInstancesResponse_FluencyResult
	//	*EvaluateInstancesResponse_CoherenceResult
	//	*EvaluateInstancesResponse_SafetyResult
	//	*EvaluateInstancesResponse_GroundednessResult
	//	*EvaluateInstancesResponse_FulfillmentResult
	//	*EvaluateInstancesResponse_SummarizationQualityResult
	//	*EvaluateInstancesResponse_PairwiseSummarizationQualityResult
	//	*EvaluateInstancesResponse_SummarizationHelpfulnessResult
	//	*EvaluateInstancesResponse_SummarizationVerbosityResult
	//	*EvaluateInstancesResponse_QuestionAnsweringQualityResult
	//	*EvaluateInstancesResponse_PairwiseQuestionAnsweringQualityResult
	//	*EvaluateInstancesResponse_QuestionAnsweringRelevanceResult
	//	*EvaluateInstancesResponse_QuestionAnsweringHelpfulnessResult
	//	*EvaluateInstancesResponse_QuestionAnsweringCorrectnessResult
	//	*EvaluateInstancesResponse_PointwiseMetricResult
	//	*EvaluateInstancesResponse_PairwiseMetricResult
	//	*EvaluateInstancesResponse_ToolCallValidResults
	//	*EvaluateInstancesResponse_ToolNameMatchResults
	//	*EvaluateInstancesResponse_ToolParameterKeyMatchResults
	//	*EvaluateInstancesResponse_ToolParameterKvMatchResults
	//	*EvaluateInstancesResponse_CometResult
	//	*EvaluateInstancesResponse_MetricxResult
	EvaluationResults isEvaluateInstancesResponse_EvaluationResults `protobuf_oneof:"evaluation_results"`
}

func (x *EvaluateInstancesResponse) Reset() {
	*x = EvaluateInstancesResponse{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EvaluateInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EvaluateInstancesResponse) ProtoMessage() {}

func (x *EvaluateInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EvaluateInstancesResponse.ProtoReflect.Descriptor instead.
func (*EvaluateInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{1}
}

func (m *EvaluateInstancesResponse) GetEvaluationResults() isEvaluateInstancesResponse_EvaluationResults {
	if m != nil {
		return m.EvaluationResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetExactMatchResults() *ExactMatchResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_ExactMatchResults); ok {
		return x.ExactMatchResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetBleuResults() *BleuResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_BleuResults); ok {
		return x.BleuResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetRougeResults() *RougeResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_RougeResults); ok {
		return x.RougeResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetFluencyResult() *FluencyResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_FluencyResult); ok {
		return x.FluencyResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetCoherenceResult() *CoherenceResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_CoherenceResult); ok {
		return x.CoherenceResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetSafetyResult() *SafetyResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_SafetyResult); ok {
		return x.SafetyResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetGroundednessResult() *GroundednessResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_GroundednessResult); ok {
		return x.GroundednessResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetFulfillmentResult() *FulfillmentResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_FulfillmentResult); ok {
		return x.FulfillmentResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetSummarizationQualityResult() *SummarizationQualityResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_SummarizationQualityResult); ok {
		return x.SummarizationQualityResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetPairwiseSummarizationQualityResult() *PairwiseSummarizationQualityResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_PairwiseSummarizationQualityResult); ok {
		return x.PairwiseSummarizationQualityResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetSummarizationHelpfulnessResult() *SummarizationHelpfulnessResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_SummarizationHelpfulnessResult); ok {
		return x.SummarizationHelpfulnessResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetSummarizationVerbosityResult() *SummarizationVerbosityResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_SummarizationVerbosityResult); ok {
		return x.SummarizationVerbosityResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetQuestionAnsweringQualityResult() *QuestionAnsweringQualityResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_QuestionAnsweringQualityResult); ok {
		return x.QuestionAnsweringQualityResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetPairwiseQuestionAnsweringQualityResult() *PairwiseQuestionAnsweringQualityResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_PairwiseQuestionAnsweringQualityResult); ok {
		return x.PairwiseQuestionAnsweringQualityResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetQuestionAnsweringRelevanceResult() *QuestionAnsweringRelevanceResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_QuestionAnsweringRelevanceResult); ok {
		return x.QuestionAnsweringRelevanceResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetQuestionAnsweringHelpfulnessResult() *QuestionAnsweringHelpfulnessResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_QuestionAnsweringHelpfulnessResult); ok {
		return x.QuestionAnsweringHelpfulnessResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetQuestionAnsweringCorrectnessResult() *QuestionAnsweringCorrectnessResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_QuestionAnsweringCorrectnessResult); ok {
		return x.QuestionAnsweringCorrectnessResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetPointwiseMetricResult() *PointwiseMetricResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_PointwiseMetricResult); ok {
		return x.PointwiseMetricResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetPairwiseMetricResult() *PairwiseMetricResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_PairwiseMetricResult); ok {
		return x.PairwiseMetricResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetToolCallValidResults() *ToolCallValidResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_ToolCallValidResults); ok {
		return x.ToolCallValidResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetToolNameMatchResults() *ToolNameMatchResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_ToolNameMatchResults); ok {
		return x.ToolNameMatchResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetToolParameterKeyMatchResults() *ToolParameterKeyMatchResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_ToolParameterKeyMatchResults); ok {
		return x.ToolParameterKeyMatchResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetToolParameterKvMatchResults() *ToolParameterKVMatchResults {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_ToolParameterKvMatchResults); ok {
		return x.ToolParameterKvMatchResults
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetCometResult() *CometResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_CometResult); ok {
		return x.CometResult
	}
	return nil
}

func (x *EvaluateInstancesResponse) GetMetricxResult() *MetricxResult {
	if x, ok := x.GetEvaluationResults().(*EvaluateInstancesResponse_MetricxResult); ok {
		return x.MetricxResult
	}
	return nil
}

type isEvaluateInstancesResponse_EvaluationResults interface {
	isEvaluateInstancesResponse_EvaluationResults()
}

type EvaluateInstancesResponse_ExactMatchResults struct {
	// Auto metric evaluation results.
	// Results for exact match metric.
	ExactMatchResults *ExactMatchResults `protobuf:"bytes,1,opt,name=exact_match_results,json=exactMatchResults,proto3,oneof"`
}

type EvaluateInstancesResponse_BleuResults struct {
	// Results for bleu metric.
	BleuResults *BleuResults `protobuf:"bytes,2,opt,name=bleu_results,json=bleuResults,proto3,oneof"`
}

type EvaluateInstancesResponse_RougeResults struct {
	// Results for rouge metric.
	RougeResults *RougeResults `protobuf:"bytes,3,opt,name=rouge_results,json=rougeResults,proto3,oneof"`
}

type EvaluateInstancesResponse_FluencyResult struct {
	// LLM-based metric evaluation result.
	// General text generation metrics, applicable to other categories.
	// Result for fluency metric.
	FluencyResult *FluencyResult `protobuf:"bytes,4,opt,name=fluency_result,json=fluencyResult,proto3,oneof"`
}

type EvaluateInstancesResponse_CoherenceResult struct {
	// Result for coherence metric.
	CoherenceResult *CoherenceResult `protobuf:"bytes,5,opt,name=coherence_result,json=coherenceResult,proto3,oneof"`
}

type EvaluateInstancesResponse_SafetyResult struct {
	// Result for safety metric.
	SafetyResult *SafetyResult `protobuf:"bytes,7,opt,name=safety_result,json=safetyResult,proto3,oneof"`
}

type EvaluateInstancesResponse_GroundednessResult struct {
	// Result for groundedness metric.
	GroundednessResult *GroundednessResult `protobuf:"bytes,8,opt,name=groundedness_result,json=groundednessResult,proto3,oneof"`
}

type EvaluateInstancesResponse_FulfillmentResult struct {
	// Result for fulfillment metric.
	FulfillmentResult *FulfillmentResult `protobuf:"bytes,11,opt,name=fulfillment_result,json=fulfillmentResult,proto3,oneof"`
}

type EvaluateInstancesResponse_SummarizationQualityResult struct {
	// Summarization only metrics.
	// Result for summarization quality metric.
	SummarizationQualityResult *SummarizationQualityResult `protobuf:"bytes,6,opt,name=summarization_quality_result,json=summarizationQualityResult,proto3,oneof"`
}

type EvaluateInstancesResponse_PairwiseSummarizationQualityResult struct {
	// Result for pairwise summarization quality metric.
	PairwiseSummarizationQualityResult *PairwiseSummarizationQualityResult `protobuf:"bytes,22,opt,name=pairwise_summarization_quality_result,json=pairwiseSummarizationQualityResult,proto3,oneof"`
}

type EvaluateInstancesResponse_SummarizationHelpfulnessResult struct {
	// Result for summarization helpfulness metric.
	SummarizationHelpfulnessResult *SummarizationHelpfulnessResult `protobuf:"bytes,13,opt,name=summarization_helpfulness_result,json=summarizationHelpfulnessResult,proto3,oneof"`
}

type EvaluateInstancesResponse_SummarizationVerbosityResult struct {
	// Result for summarization verbosity metric.
	SummarizationVerbosityResult *SummarizationVerbosityResult `protobuf:"bytes,14,opt,name=summarization_verbosity_result,json=summarizationVerbosityResult,proto3,oneof"`
}

type EvaluateInstancesResponse_QuestionAnsweringQualityResult struct {
	// Question answering only metrics.
	// Result for question answering quality metric.
	QuestionAnsweringQualityResult *QuestionAnsweringQualityResult `protobuf:"bytes,9,opt,name=question_answering_quality_result,json=questionAnsweringQualityResult,proto3,oneof"`
}

type EvaluateInstancesResponse_PairwiseQuestionAnsweringQualityResult struct {
	// Result for pairwise question answering quality metric.
	PairwiseQuestionAnsweringQualityResult *PairwiseQuestionAnsweringQualityResult `protobuf:"bytes,23,opt,name=pairwise_question_answering_quality_result,json=pairwiseQuestionAnsweringQualityResult,proto3,oneof"`
}

type EvaluateInstancesResponse_QuestionAnsweringRelevanceResult struct {
	// Result for question answering relevance metric.
	QuestionAnsweringRelevanceResult *QuestionAnsweringRelevanceResult `protobuf:"bytes,15,opt,name=question_answering_relevance_result,json=questionAnsweringRelevanceResult,proto3,oneof"`
}

type EvaluateInstancesResponse_QuestionAnsweringHelpfulnessResult struct {
	// Result for question answering helpfulness metric.
	QuestionAnsweringHelpfulnessResult *QuestionAnsweringHelpfulnessResult `protobuf:"bytes,16,opt,name=question_answering_helpfulness_result,json=questionAnsweringHelpfulnessResult,proto3,oneof"`
}

type EvaluateInstancesResponse_QuestionAnsweringCorrectnessResult struct {
	// Result for question answering correctness metric.
	QuestionAnsweringCorrectnessResult *QuestionAnsweringCorrectnessResult `protobuf:"bytes,17,opt,name=question_answering_correctness_result,json=questionAnsweringCorrectnessResult,proto3,oneof"`
}

type EvaluateInstancesResponse_PointwiseMetricResult struct {
	// Generic metrics.
	// Result for pointwise metric.
	PointwiseMetricResult *PointwiseMetricResult `protobuf:"bytes,27,opt,name=pointwise_metric_result,json=pointwiseMetricResult,proto3,oneof"`
}

type EvaluateInstancesResponse_PairwiseMetricResult struct {
	// Result for pairwise metric.
	PairwiseMetricResult *PairwiseMetricResult `protobuf:"bytes,28,opt,name=pairwise_metric_result,json=pairwiseMetricResult,proto3,oneof"`
}

type EvaluateInstancesResponse_ToolCallValidResults struct {
	// Tool call metrics.
	//
	//	Results for tool call valid metric.
	ToolCallValidResults *ToolCallValidResults `protobuf:"bytes,18,opt,name=tool_call_valid_results,json=toolCallValidResults,proto3,oneof"`
}

type EvaluateInstancesResponse_ToolNameMatchResults struct {
	// Results for tool name match metric.
	ToolNameMatchResults *ToolNameMatchResults `protobuf:"bytes,19,opt,name=tool_name_match_results,json=toolNameMatchResults,proto3,oneof"`
}

type EvaluateInstancesResponse_ToolParameterKeyMatchResults struct {
	// Results for tool parameter key match  metric.
	ToolParameterKeyMatchResults *ToolParameterKeyMatchResults `protobuf:"bytes,20,opt,name=tool_parameter_key_match_results,json=toolParameterKeyMatchResults,proto3,oneof"`
}

type EvaluateInstancesResponse_ToolParameterKvMatchResults struct {
	// Results for tool parameter key value match metric.
	ToolParameterKvMatchResults *ToolParameterKVMatchResults `protobuf:"bytes,21,opt,name=tool_parameter_kv_match_results,json=toolParameterKvMatchResults,proto3,oneof"`
}

type EvaluateInstancesResponse_CometResult struct {
	// Translation metrics.
	// Result for Comet metric.
	CometResult *CometResult `protobuf:"bytes,29,opt,name=comet_result,json=cometResult,proto3,oneof"`
}

type EvaluateInstancesResponse_MetricxResult struct {
	// Result for Metricx metric.
	MetricxResult *MetricxResult `protobuf:"bytes,30,opt,name=metricx_result,json=metricxResult,proto3,oneof"`
}

func (*EvaluateInstancesResponse_ExactMatchResults) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_BleuResults) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_RougeResults) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_FluencyResult) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_CoherenceResult) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_SafetyResult) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_GroundednessResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_FulfillmentResult) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_SummarizationQualityResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_PairwiseSummarizationQualityResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_SummarizationHelpfulnessResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_SummarizationVerbosityResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_QuestionAnsweringQualityResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_PairwiseQuestionAnsweringQualityResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_QuestionAnsweringRelevanceResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_QuestionAnsweringHelpfulnessResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_QuestionAnsweringCorrectnessResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_PointwiseMetricResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_PairwiseMetricResult) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_ToolCallValidResults) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_ToolNameMatchResults) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_ToolParameterKeyMatchResults) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_ToolParameterKvMatchResults) isEvaluateInstancesResponse_EvaluationResults() {
}

func (*EvaluateInstancesResponse_CometResult) isEvaluateInstancesResponse_EvaluationResults() {}

func (*EvaluateInstancesResponse_MetricxResult) isEvaluateInstancesResponse_EvaluationResults() {}

// Input for exact match metric.
type ExactMatchInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for exact match metric.
	MetricSpec *ExactMatchSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated exact match instances.
	Instances []*ExactMatchInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ExactMatchInput) Reset() {
	*x = ExactMatchInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExactMatchInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExactMatchInput) ProtoMessage() {}

func (x *ExactMatchInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExactMatchInput.ProtoReflect.Descriptor instead.
func (*ExactMatchInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{2}
}

func (x *ExactMatchInput) GetMetricSpec() *ExactMatchSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *ExactMatchInput) GetInstances() []*ExactMatchInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for exact match instance.
type ExactMatchInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *ExactMatchInstance) Reset() {
	*x = ExactMatchInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExactMatchInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExactMatchInstance) ProtoMessage() {}

func (x *ExactMatchInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExactMatchInstance.ProtoReflect.Descriptor instead.
func (*ExactMatchInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{3}
}

func (x *ExactMatchInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *ExactMatchInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Spec for exact match metric - returns 1 if prediction and reference exactly
// matches, otherwise 0.
type ExactMatchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExactMatchSpec) Reset() {
	*x = ExactMatchSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExactMatchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExactMatchSpec) ProtoMessage() {}

func (x *ExactMatchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExactMatchSpec.ProtoReflect.Descriptor instead.
func (*ExactMatchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{4}
}

// Results for exact match metric.
type ExactMatchResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Exact match metric values.
	ExactMatchMetricValues []*ExactMatchMetricValue `protobuf:"bytes,1,rep,name=exact_match_metric_values,json=exactMatchMetricValues,proto3" json:"exact_match_metric_values,omitempty"`
}

func (x *ExactMatchResults) Reset() {
	*x = ExactMatchResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExactMatchResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExactMatchResults) ProtoMessage() {}

func (x *ExactMatchResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExactMatchResults.ProtoReflect.Descriptor instead.
func (*ExactMatchResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{5}
}

func (x *ExactMatchResults) GetExactMatchMetricValues() []*ExactMatchMetricValue {
	if x != nil {
		return x.ExactMatchMetricValues
	}
	return nil
}

// Exact match metric value for an instance.
type ExactMatchMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Exact match score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *ExactMatchMetricValue) Reset() {
	*x = ExactMatchMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExactMatchMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExactMatchMetricValue) ProtoMessage() {}

func (x *ExactMatchMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExactMatchMetricValue.ProtoReflect.Descriptor instead.
func (*ExactMatchMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{6}
}

func (x *ExactMatchMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for bleu metric.
type BleuInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for bleu score metric.
	MetricSpec *BleuSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated bleu instances.
	Instances []*BleuInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *BleuInput) Reset() {
	*x = BleuInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BleuInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BleuInput) ProtoMessage() {}

func (x *BleuInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BleuInput.ProtoReflect.Descriptor instead.
func (*BleuInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{7}
}

func (x *BleuInput) GetMetricSpec() *BleuSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *BleuInput) GetInstances() []*BleuInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for bleu instance.
type BleuInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *BleuInstance) Reset() {
	*x = BleuInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BleuInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BleuInstance) ProtoMessage() {}

func (x *BleuInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BleuInstance.ProtoReflect.Descriptor instead.
func (*BleuInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{8}
}

func (x *BleuInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *BleuInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Spec for bleu score metric - calculates the precision of n-grams in the
// prediction as compared to reference - returns a score ranging between 0 to 1.
type BleuSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use_effective_order to compute bleu score.
	UseEffectiveOrder bool `protobuf:"varint,1,opt,name=use_effective_order,json=useEffectiveOrder,proto3" json:"use_effective_order,omitempty"`
}

func (x *BleuSpec) Reset() {
	*x = BleuSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BleuSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BleuSpec) ProtoMessage() {}

func (x *BleuSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BleuSpec.ProtoReflect.Descriptor instead.
func (*BleuSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{9}
}

func (x *BleuSpec) GetUseEffectiveOrder() bool {
	if x != nil {
		return x.UseEffectiveOrder
	}
	return false
}

// Results for bleu metric.
type BleuResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Bleu metric values.
	BleuMetricValues []*BleuMetricValue `protobuf:"bytes,1,rep,name=bleu_metric_values,json=bleuMetricValues,proto3" json:"bleu_metric_values,omitempty"`
}

func (x *BleuResults) Reset() {
	*x = BleuResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BleuResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BleuResults) ProtoMessage() {}

func (x *BleuResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BleuResults.ProtoReflect.Descriptor instead.
func (*BleuResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{10}
}

func (x *BleuResults) GetBleuMetricValues() []*BleuMetricValue {
	if x != nil {
		return x.BleuMetricValues
	}
	return nil
}

// Bleu metric value for an instance.
type BleuMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Bleu score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *BleuMetricValue) Reset() {
	*x = BleuMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BleuMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BleuMetricValue) ProtoMessage() {}

func (x *BleuMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BleuMetricValue.ProtoReflect.Descriptor instead.
func (*BleuMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{11}
}

func (x *BleuMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for rouge metric.
type RougeInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for rouge score metric.
	MetricSpec *RougeSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated rouge instances.
	Instances []*RougeInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *RougeInput) Reset() {
	*x = RougeInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RougeInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RougeInput) ProtoMessage() {}

func (x *RougeInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RougeInput.ProtoReflect.Descriptor instead.
func (*RougeInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{12}
}

func (x *RougeInput) GetMetricSpec() *RougeSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *RougeInput) GetInstances() []*RougeInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for rouge instance.
type RougeInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *RougeInstance) Reset() {
	*x = RougeInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RougeInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RougeInstance) ProtoMessage() {}

func (x *RougeInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RougeInstance.ProtoReflect.Descriptor instead.
func (*RougeInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{13}
}

func (x *RougeInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *RougeInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Spec for rouge score metric - calculates the recall of n-grams in prediction
// as compared to reference - returns a score ranging between 0 and 1.
type RougeSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Supported rouge types are rougen[1-9], rougeL, and rougeLsum.
	RougeType string `protobuf:"bytes,1,opt,name=rouge_type,json=rougeType,proto3" json:"rouge_type,omitempty"`
	// Optional. Whether to use stemmer to compute rouge score.
	UseStemmer bool `protobuf:"varint,2,opt,name=use_stemmer,json=useStemmer,proto3" json:"use_stemmer,omitempty"`
	// Optional. Whether to split summaries while using rougeLsum.
	SplitSummaries bool `protobuf:"varint,3,opt,name=split_summaries,json=splitSummaries,proto3" json:"split_summaries,omitempty"`
}

func (x *RougeSpec) Reset() {
	*x = RougeSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RougeSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RougeSpec) ProtoMessage() {}

func (x *RougeSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RougeSpec.ProtoReflect.Descriptor instead.
func (*RougeSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{14}
}

func (x *RougeSpec) GetRougeType() string {
	if x != nil {
		return x.RougeType
	}
	return ""
}

func (x *RougeSpec) GetUseStemmer() bool {
	if x != nil {
		return x.UseStemmer
	}
	return false
}

func (x *RougeSpec) GetSplitSummaries() bool {
	if x != nil {
		return x.SplitSummaries
	}
	return false
}

// Results for rouge metric.
type RougeResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Rouge metric values.
	RougeMetricValues []*RougeMetricValue `protobuf:"bytes,1,rep,name=rouge_metric_values,json=rougeMetricValues,proto3" json:"rouge_metric_values,omitempty"`
}

func (x *RougeResults) Reset() {
	*x = RougeResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RougeResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RougeResults) ProtoMessage() {}

func (x *RougeResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RougeResults.ProtoReflect.Descriptor instead.
func (*RougeResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{15}
}

func (x *RougeResults) GetRougeMetricValues() []*RougeMetricValue {
	if x != nil {
		return x.RougeMetricValues
	}
	return nil
}

// Rouge metric value for an instance.
type RougeMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Rouge score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *RougeMetricValue) Reset() {
	*x = RougeMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RougeMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RougeMetricValue) ProtoMessage() {}

func (x *RougeMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RougeMetricValue.ProtoReflect.Descriptor instead.
func (*RougeMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{16}
}

func (x *RougeMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for coherence metric.
type CoherenceInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for coherence score metric.
	MetricSpec *CoherenceSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Coherence instance.
	Instance *CoherenceInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *CoherenceInput) Reset() {
	*x = CoherenceInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoherenceInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoherenceInput) ProtoMessage() {}

func (x *CoherenceInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoherenceInput.ProtoReflect.Descriptor instead.
func (*CoherenceInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{17}
}

func (x *CoherenceInput) GetMetricSpec() *CoherenceSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *CoherenceInput) GetInstance() *CoherenceInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for coherence instance.
type CoherenceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
}

func (x *CoherenceInstance) Reset() {
	*x = CoherenceInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoherenceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoherenceInstance) ProtoMessage() {}

func (x *CoherenceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoherenceInstance.ProtoReflect.Descriptor instead.
func (*CoherenceInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{18}
}

func (x *CoherenceInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

// Spec for coherence score metric.
type CoherenceSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *CoherenceSpec) Reset() {
	*x = CoherenceSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoherenceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoherenceSpec) ProtoMessage() {}

func (x *CoherenceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoherenceSpec.ProtoReflect.Descriptor instead.
func (*CoherenceSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{19}
}

func (x *CoherenceSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for coherence result.
type CoherenceResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Coherence score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for coherence score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for coherence score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *CoherenceResult) Reset() {
	*x = CoherenceResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CoherenceResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CoherenceResult) ProtoMessage() {}

func (x *CoherenceResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CoherenceResult.ProtoReflect.Descriptor instead.
func (*CoherenceResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{20}
}

func (x *CoherenceResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *CoherenceResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *CoherenceResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for fluency metric.
type FluencyInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for fluency score metric.
	MetricSpec *FluencySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Fluency instance.
	Instance *FluencyInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *FluencyInput) Reset() {
	*x = FluencyInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FluencyInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FluencyInput) ProtoMessage() {}

func (x *FluencyInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FluencyInput.ProtoReflect.Descriptor instead.
func (*FluencyInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{21}
}

func (x *FluencyInput) GetMetricSpec() *FluencySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *FluencyInput) GetInstance() *FluencyInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for fluency instance.
type FluencyInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
}

func (x *FluencyInstance) Reset() {
	*x = FluencyInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FluencyInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FluencyInstance) ProtoMessage() {}

func (x *FluencyInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FluencyInstance.ProtoReflect.Descriptor instead.
func (*FluencyInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{22}
}

func (x *FluencyInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

// Spec for fluency score metric.
type FluencySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *FluencySpec) Reset() {
	*x = FluencySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FluencySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FluencySpec) ProtoMessage() {}

func (x *FluencySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FluencySpec.ProtoReflect.Descriptor instead.
func (*FluencySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{23}
}

func (x *FluencySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for fluency result.
type FluencyResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Fluency score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for fluency score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for fluency score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *FluencyResult) Reset() {
	*x = FluencyResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FluencyResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FluencyResult) ProtoMessage() {}

func (x *FluencyResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FluencyResult.ProtoReflect.Descriptor instead.
func (*FluencyResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{24}
}

func (x *FluencyResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *FluencyResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *FluencyResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for safety metric.
type SafetyInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for safety metric.
	MetricSpec *SafetySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Safety instance.
	Instance *SafetyInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *SafetyInput) Reset() {
	*x = SafetyInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetyInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetyInput) ProtoMessage() {}

func (x *SafetyInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetyInput.ProtoReflect.Descriptor instead.
func (*SafetyInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{25}
}

func (x *SafetyInput) GetMetricSpec() *SafetySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *SafetyInput) GetInstance() *SafetyInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for safety instance.
type SafetyInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
}

func (x *SafetyInstance) Reset() {
	*x = SafetyInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetyInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetyInstance) ProtoMessage() {}

func (x *SafetyInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetyInstance.ProtoReflect.Descriptor instead.
func (*SafetyInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{26}
}

func (x *SafetyInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

// Spec for safety metric.
type SafetySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SafetySpec) Reset() {
	*x = SafetySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySpec) ProtoMessage() {}

func (x *SafetySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySpec.ProtoReflect.Descriptor instead.
func (*SafetySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{27}
}

func (x *SafetySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for safety result.
type SafetyResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Safety score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for safety score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for safety score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *SafetyResult) Reset() {
	*x = SafetyResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SafetyResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetyResult) ProtoMessage() {}

func (x *SafetyResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetyResult.ProtoReflect.Descriptor instead.
func (*SafetyResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{28}
}

func (x *SafetyResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *SafetyResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *SafetyResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for groundedness metric.
type GroundednessInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for groundedness metric.
	MetricSpec *GroundednessSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Groundedness instance.
	Instance *GroundednessInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *GroundednessInput) Reset() {
	*x = GroundednessInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundednessInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundednessInput) ProtoMessage() {}

func (x *GroundednessInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundednessInput.ProtoReflect.Descriptor instead.
func (*GroundednessInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{29}
}

func (x *GroundednessInput) GetMetricSpec() *GroundednessSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *GroundednessInput) GetInstance() *GroundednessInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for groundedness instance.
type GroundednessInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Background information provided in context used to compare
	// against the prediction.
	Context *string `protobuf:"bytes,2,opt,name=context,proto3,oneof" json:"context,omitempty"`
}

func (x *GroundednessInstance) Reset() {
	*x = GroundednessInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundednessInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundednessInstance) ProtoMessage() {}

func (x *GroundednessInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundednessInstance.ProtoReflect.Descriptor instead.
func (*GroundednessInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{30}
}

func (x *GroundednessInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *GroundednessInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

// Spec for groundedness metric.
type GroundednessSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *GroundednessSpec) Reset() {
	*x = GroundednessSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundednessSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundednessSpec) ProtoMessage() {}

func (x *GroundednessSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundednessSpec.ProtoReflect.Descriptor instead.
func (*GroundednessSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{31}
}

func (x *GroundednessSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for groundedness result.
type GroundednessResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Groundedness score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for groundedness score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for groundedness score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *GroundednessResult) Reset() {
	*x = GroundednessResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroundednessResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroundednessResult) ProtoMessage() {}

func (x *GroundednessResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroundednessResult.ProtoReflect.Descriptor instead.
func (*GroundednessResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{32}
}

func (x *GroundednessResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *GroundednessResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *GroundednessResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for fulfillment metric.
type FulfillmentInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for fulfillment score metric.
	MetricSpec *FulfillmentSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Fulfillment instance.
	Instance *FulfillmentInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *FulfillmentInput) Reset() {
	*x = FulfillmentInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FulfillmentInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillmentInput) ProtoMessage() {}

func (x *FulfillmentInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillmentInput.ProtoReflect.Descriptor instead.
func (*FulfillmentInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{33}
}

func (x *FulfillmentInput) GetMetricSpec() *FulfillmentSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *FulfillmentInput) GetInstance() *FulfillmentInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for fulfillment instance.
type FulfillmentInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Inference instruction prompt to compare prediction with.
	Instruction *string `protobuf:"bytes,2,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *FulfillmentInstance) Reset() {
	*x = FulfillmentInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FulfillmentInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillmentInstance) ProtoMessage() {}

func (x *FulfillmentInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillmentInstance.ProtoReflect.Descriptor instead.
func (*FulfillmentInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{34}
}

func (x *FulfillmentInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *FulfillmentInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for fulfillment metric.
type FulfillmentSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *FulfillmentSpec) Reset() {
	*x = FulfillmentSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FulfillmentSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillmentSpec) ProtoMessage() {}

func (x *FulfillmentSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillmentSpec.ProtoReflect.Descriptor instead.
func (*FulfillmentSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{35}
}

func (x *FulfillmentSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for fulfillment result.
type FulfillmentResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Fulfillment score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for fulfillment score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for fulfillment score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *FulfillmentResult) Reset() {
	*x = FulfillmentResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FulfillmentResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FulfillmentResult) ProtoMessage() {}

func (x *FulfillmentResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FulfillmentResult.ProtoReflect.Descriptor instead.
func (*FulfillmentResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{36}
}

func (x *FulfillmentResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *FulfillmentResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *FulfillmentResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for summarization quality metric.
type SummarizationQualityInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for summarization quality score metric.
	MetricSpec *SummarizationQualitySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Summarization quality instance.
	Instance *SummarizationQualityInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *SummarizationQualityInput) Reset() {
	*x = SummarizationQualityInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationQualityInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationQualityInput) ProtoMessage() {}

func (x *SummarizationQualityInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationQualityInput.ProtoReflect.Descriptor instead.
func (*SummarizationQualityInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{37}
}

func (x *SummarizationQualityInput) GetMetricSpec() *SummarizationQualitySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *SummarizationQualityInput) GetInstance() *SummarizationQualityInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for summarization quality instance.
type SummarizationQualityInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Required. Text to be summarized.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. Summarization prompt for LLM.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *SummarizationQualityInstance) Reset() {
	*x = SummarizationQualityInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationQualityInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationQualityInstance) ProtoMessage() {}

func (x *SummarizationQualityInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationQualityInstance.ProtoReflect.Descriptor instead.
func (*SummarizationQualityInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{38}
}

func (x *SummarizationQualityInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *SummarizationQualityInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *SummarizationQualityInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *SummarizationQualityInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for summarization quality score metric.
type SummarizationQualitySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute summarization
	// quality.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SummarizationQualitySpec) Reset() {
	*x = SummarizationQualitySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationQualitySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationQualitySpec) ProtoMessage() {}

func (x *SummarizationQualitySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationQualitySpec.ProtoReflect.Descriptor instead.
func (*SummarizationQualitySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{39}
}

func (x *SummarizationQualitySpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *SummarizationQualitySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for summarization quality result.
type SummarizationQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Summarization Quality score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for summarization quality score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for summarization quality score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *SummarizationQualityResult) Reset() {
	*x = SummarizationQualityResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationQualityResult) ProtoMessage() {}

func (x *SummarizationQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationQualityResult.ProtoReflect.Descriptor instead.
func (*SummarizationQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{40}
}

func (x *SummarizationQualityResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *SummarizationQualityResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *SummarizationQualityResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for pairwise summarization quality metric.
type PairwiseSummarizationQualityInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for pairwise summarization quality score metric.
	MetricSpec *PairwiseSummarizationQualitySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Pairwise summarization quality instance.
	Instance *PairwiseSummarizationQualityInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *PairwiseSummarizationQualityInput) Reset() {
	*x = PairwiseSummarizationQualityInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseSummarizationQualityInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseSummarizationQualityInput) ProtoMessage() {}

func (x *PairwiseSummarizationQualityInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseSummarizationQualityInput.ProtoReflect.Descriptor instead.
func (*PairwiseSummarizationQualityInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{41}
}

func (x *PairwiseSummarizationQualityInput) GetMetricSpec() *PairwiseSummarizationQualitySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *PairwiseSummarizationQualityInput) GetInstance() *PairwiseSummarizationQualityInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for pairwise summarization quality instance.
type PairwiseSummarizationQualityInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the candidate model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Output of the baseline model.
	BaselinePrediction *string `protobuf:"bytes,2,opt,name=baseline_prediction,json=baselinePrediction,proto3,oneof" json:"baseline_prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,3,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Required. Text to be summarized.
	Context *string `protobuf:"bytes,4,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. Summarization prompt for LLM.
	Instruction *string `protobuf:"bytes,5,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *PairwiseSummarizationQualityInstance) Reset() {
	*x = PairwiseSummarizationQualityInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseSummarizationQualityInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseSummarizationQualityInstance) ProtoMessage() {}

func (x *PairwiseSummarizationQualityInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseSummarizationQualityInstance.ProtoReflect.Descriptor instead.
func (*PairwiseSummarizationQualityInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{42}
}

func (x *PairwiseSummarizationQualityInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *PairwiseSummarizationQualityInstance) GetBaselinePrediction() string {
	if x != nil && x.BaselinePrediction != nil {
		return *x.BaselinePrediction
	}
	return ""
}

func (x *PairwiseSummarizationQualityInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *PairwiseSummarizationQualityInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *PairwiseSummarizationQualityInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for pairwise summarization quality score metric.
type PairwiseSummarizationQualitySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute pairwise
	// summarization quality.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PairwiseSummarizationQualitySpec) Reset() {
	*x = PairwiseSummarizationQualitySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseSummarizationQualitySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseSummarizationQualitySpec) ProtoMessage() {}

func (x *PairwiseSummarizationQualitySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseSummarizationQualitySpec.ProtoReflect.Descriptor instead.
func (*PairwiseSummarizationQualitySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{43}
}

func (x *PairwiseSummarizationQualitySpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *PairwiseSummarizationQualitySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for pairwise summarization quality result.
type PairwiseSummarizationQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Pairwise summarization prediction choice.
	PairwiseChoice PairwiseChoice `protobuf:"varint,1,opt,name=pairwise_choice,json=pairwiseChoice,proto3,enum=google.cloud.aiplatform.v1.PairwiseChoice" json:"pairwise_choice,omitempty"`
	// Output only. Explanation for summarization quality score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for summarization quality score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *PairwiseSummarizationQualityResult) Reset() {
	*x = PairwiseSummarizationQualityResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseSummarizationQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseSummarizationQualityResult) ProtoMessage() {}

func (x *PairwiseSummarizationQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseSummarizationQualityResult.ProtoReflect.Descriptor instead.
func (*PairwiseSummarizationQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{44}
}

func (x *PairwiseSummarizationQualityResult) GetPairwiseChoice() PairwiseChoice {
	if x != nil {
		return x.PairwiseChoice
	}
	return PairwiseChoice_PAIRWISE_CHOICE_UNSPECIFIED
}

func (x *PairwiseSummarizationQualityResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *PairwiseSummarizationQualityResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for summarization helpfulness metric.
type SummarizationHelpfulnessInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for summarization helpfulness score metric.
	MetricSpec *SummarizationHelpfulnessSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Summarization helpfulness instance.
	Instance *SummarizationHelpfulnessInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *SummarizationHelpfulnessInput) Reset() {
	*x = SummarizationHelpfulnessInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationHelpfulnessInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationHelpfulnessInput) ProtoMessage() {}

func (x *SummarizationHelpfulnessInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationHelpfulnessInput.ProtoReflect.Descriptor instead.
func (*SummarizationHelpfulnessInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{45}
}

func (x *SummarizationHelpfulnessInput) GetMetricSpec() *SummarizationHelpfulnessSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *SummarizationHelpfulnessInput) GetInstance() *SummarizationHelpfulnessInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for summarization helpfulness instance.
type SummarizationHelpfulnessInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Required. Text to be summarized.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Optional. Summarization prompt for LLM.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *SummarizationHelpfulnessInstance) Reset() {
	*x = SummarizationHelpfulnessInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationHelpfulnessInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationHelpfulnessInstance) ProtoMessage() {}

func (x *SummarizationHelpfulnessInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationHelpfulnessInstance.ProtoReflect.Descriptor instead.
func (*SummarizationHelpfulnessInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{46}
}

func (x *SummarizationHelpfulnessInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *SummarizationHelpfulnessInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *SummarizationHelpfulnessInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *SummarizationHelpfulnessInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for summarization helpfulness score metric.
type SummarizationHelpfulnessSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute summarization
	// helpfulness.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SummarizationHelpfulnessSpec) Reset() {
	*x = SummarizationHelpfulnessSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationHelpfulnessSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationHelpfulnessSpec) ProtoMessage() {}

func (x *SummarizationHelpfulnessSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationHelpfulnessSpec.ProtoReflect.Descriptor instead.
func (*SummarizationHelpfulnessSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{47}
}

func (x *SummarizationHelpfulnessSpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *SummarizationHelpfulnessSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for summarization helpfulness result.
type SummarizationHelpfulnessResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Summarization Helpfulness score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for summarization helpfulness score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for summarization helpfulness score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *SummarizationHelpfulnessResult) Reset() {
	*x = SummarizationHelpfulnessResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationHelpfulnessResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationHelpfulnessResult) ProtoMessage() {}

func (x *SummarizationHelpfulnessResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationHelpfulnessResult.ProtoReflect.Descriptor instead.
func (*SummarizationHelpfulnessResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{48}
}

func (x *SummarizationHelpfulnessResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *SummarizationHelpfulnessResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *SummarizationHelpfulnessResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for summarization verbosity metric.
type SummarizationVerbosityInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for summarization verbosity score metric.
	MetricSpec *SummarizationVerbositySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Summarization verbosity instance.
	Instance *SummarizationVerbosityInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *SummarizationVerbosityInput) Reset() {
	*x = SummarizationVerbosityInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationVerbosityInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationVerbosityInput) ProtoMessage() {}

func (x *SummarizationVerbosityInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationVerbosityInput.ProtoReflect.Descriptor instead.
func (*SummarizationVerbosityInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{49}
}

func (x *SummarizationVerbosityInput) GetMetricSpec() *SummarizationVerbositySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *SummarizationVerbosityInput) GetInstance() *SummarizationVerbosityInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for summarization verbosity instance.
type SummarizationVerbosityInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Required. Text to be summarized.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Optional. Summarization prompt for LLM.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *SummarizationVerbosityInstance) Reset() {
	*x = SummarizationVerbosityInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationVerbosityInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationVerbosityInstance) ProtoMessage() {}

func (x *SummarizationVerbosityInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationVerbosityInstance.ProtoReflect.Descriptor instead.
func (*SummarizationVerbosityInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{50}
}

func (x *SummarizationVerbosityInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *SummarizationVerbosityInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *SummarizationVerbosityInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *SummarizationVerbosityInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for summarization verbosity score metric.
type SummarizationVerbositySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute summarization
	// verbosity.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SummarizationVerbositySpec) Reset() {
	*x = SummarizationVerbositySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationVerbositySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationVerbositySpec) ProtoMessage() {}

func (x *SummarizationVerbositySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationVerbositySpec.ProtoReflect.Descriptor instead.
func (*SummarizationVerbositySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{51}
}

func (x *SummarizationVerbositySpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *SummarizationVerbositySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for summarization verbosity result.
type SummarizationVerbosityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Summarization Verbosity score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for summarization verbosity score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for summarization verbosity score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *SummarizationVerbosityResult) Reset() {
	*x = SummarizationVerbosityResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SummarizationVerbosityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SummarizationVerbosityResult) ProtoMessage() {}

func (x *SummarizationVerbosityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SummarizationVerbosityResult.ProtoReflect.Descriptor instead.
func (*SummarizationVerbosityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{52}
}

func (x *SummarizationVerbosityResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *SummarizationVerbosityResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *SummarizationVerbosityResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for question answering quality metric.
type QuestionAnsweringQualityInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for question answering quality score metric.
	MetricSpec *QuestionAnsweringQualitySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Question answering quality instance.
	Instance *QuestionAnsweringQualityInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *QuestionAnsweringQualityInput) Reset() {
	*x = QuestionAnsweringQualityInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringQualityInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringQualityInput) ProtoMessage() {}

func (x *QuestionAnsweringQualityInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringQualityInput.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringQualityInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{53}
}

func (x *QuestionAnsweringQualityInput) GetMetricSpec() *QuestionAnsweringQualitySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *QuestionAnsweringQualityInput) GetInstance() *QuestionAnsweringQualityInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for question answering quality instance.
type QuestionAnsweringQualityInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Required. Text to answer the question.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. Question Answering prompt for LLM.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *QuestionAnsweringQualityInstance) Reset() {
	*x = QuestionAnsweringQualityInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringQualityInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringQualityInstance) ProtoMessage() {}

func (x *QuestionAnsweringQualityInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringQualityInstance.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringQualityInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{54}
}

func (x *QuestionAnsweringQualityInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *QuestionAnsweringQualityInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *QuestionAnsweringQualityInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *QuestionAnsweringQualityInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for question answering quality score metric.
type QuestionAnsweringQualitySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute question answering
	// quality.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *QuestionAnsweringQualitySpec) Reset() {
	*x = QuestionAnsweringQualitySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringQualitySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringQualitySpec) ProtoMessage() {}

func (x *QuestionAnsweringQualitySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringQualitySpec.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringQualitySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{55}
}

func (x *QuestionAnsweringQualitySpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *QuestionAnsweringQualitySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for question answering quality result.
type QuestionAnsweringQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Question Answering Quality score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for question answering quality score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for question answering quality score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *QuestionAnsweringQualityResult) Reset() {
	*x = QuestionAnsweringQualityResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringQualityResult) ProtoMessage() {}

func (x *QuestionAnsweringQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringQualityResult.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{56}
}

func (x *QuestionAnsweringQualityResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *QuestionAnsweringQualityResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *QuestionAnsweringQualityResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for pairwise question answering quality metric.
type PairwiseQuestionAnsweringQualityInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for pairwise question answering quality score metric.
	MetricSpec *PairwiseQuestionAnsweringQualitySpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Pairwise question answering quality instance.
	Instance *PairwiseQuestionAnsweringQualityInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *PairwiseQuestionAnsweringQualityInput) Reset() {
	*x = PairwiseQuestionAnsweringQualityInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseQuestionAnsweringQualityInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseQuestionAnsweringQualityInput) ProtoMessage() {}

func (x *PairwiseQuestionAnsweringQualityInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseQuestionAnsweringQualityInput.ProtoReflect.Descriptor instead.
func (*PairwiseQuestionAnsweringQualityInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{57}
}

func (x *PairwiseQuestionAnsweringQualityInput) GetMetricSpec() *PairwiseQuestionAnsweringQualitySpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *PairwiseQuestionAnsweringQualityInput) GetInstance() *PairwiseQuestionAnsweringQualityInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for pairwise question answering quality instance.
type PairwiseQuestionAnsweringQualityInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the candidate model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Output of the baseline model.
	BaselinePrediction *string `protobuf:"bytes,2,opt,name=baseline_prediction,json=baselinePrediction,proto3,oneof" json:"baseline_prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,3,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Required. Text to answer the question.
	Context *string `protobuf:"bytes,4,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. Question Answering prompt for LLM.
	Instruction *string `protobuf:"bytes,5,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *PairwiseQuestionAnsweringQualityInstance) Reset() {
	*x = PairwiseQuestionAnsweringQualityInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseQuestionAnsweringQualityInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseQuestionAnsweringQualityInstance) ProtoMessage() {}

func (x *PairwiseQuestionAnsweringQualityInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseQuestionAnsweringQualityInstance.ProtoReflect.Descriptor instead.
func (*PairwiseQuestionAnsweringQualityInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{58}
}

func (x *PairwiseQuestionAnsweringQualityInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *PairwiseQuestionAnsweringQualityInstance) GetBaselinePrediction() string {
	if x != nil && x.BaselinePrediction != nil {
		return *x.BaselinePrediction
	}
	return ""
}

func (x *PairwiseQuestionAnsweringQualityInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *PairwiseQuestionAnsweringQualityInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *PairwiseQuestionAnsweringQualityInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for pairwise question answering quality score metric.
type PairwiseQuestionAnsweringQualitySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute question answering
	// quality.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *PairwiseQuestionAnsweringQualitySpec) Reset() {
	*x = PairwiseQuestionAnsweringQualitySpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseQuestionAnsweringQualitySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseQuestionAnsweringQualitySpec) ProtoMessage() {}

func (x *PairwiseQuestionAnsweringQualitySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseQuestionAnsweringQualitySpec.ProtoReflect.Descriptor instead.
func (*PairwiseQuestionAnsweringQualitySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{59}
}

func (x *PairwiseQuestionAnsweringQualitySpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *PairwiseQuestionAnsweringQualitySpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for pairwise question answering quality result.
type PairwiseQuestionAnsweringQualityResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Pairwise question answering prediction choice.
	PairwiseChoice PairwiseChoice `protobuf:"varint,1,opt,name=pairwise_choice,json=pairwiseChoice,proto3,enum=google.cloud.aiplatform.v1.PairwiseChoice" json:"pairwise_choice,omitempty"`
	// Output only. Explanation for question answering quality score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for question answering quality score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *PairwiseQuestionAnsweringQualityResult) Reset() {
	*x = PairwiseQuestionAnsweringQualityResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseQuestionAnsweringQualityResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseQuestionAnsweringQualityResult) ProtoMessage() {}

func (x *PairwiseQuestionAnsweringQualityResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseQuestionAnsweringQualityResult.ProtoReflect.Descriptor instead.
func (*PairwiseQuestionAnsweringQualityResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{60}
}

func (x *PairwiseQuestionAnsweringQualityResult) GetPairwiseChoice() PairwiseChoice {
	if x != nil {
		return x.PairwiseChoice
	}
	return PairwiseChoice_PAIRWISE_CHOICE_UNSPECIFIED
}

func (x *PairwiseQuestionAnsweringQualityResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *PairwiseQuestionAnsweringQualityResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for question answering relevance metric.
type QuestionAnsweringRelevanceInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for question answering relevance score metric.
	MetricSpec *QuestionAnsweringRelevanceSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Question answering relevance instance.
	Instance *QuestionAnsweringRelevanceInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *QuestionAnsweringRelevanceInput) Reset() {
	*x = QuestionAnsweringRelevanceInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringRelevanceInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringRelevanceInput) ProtoMessage() {}

func (x *QuestionAnsweringRelevanceInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringRelevanceInput.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringRelevanceInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{61}
}

func (x *QuestionAnsweringRelevanceInput) GetMetricSpec() *QuestionAnsweringRelevanceSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *QuestionAnsweringRelevanceInput) GetInstance() *QuestionAnsweringRelevanceInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for question answering relevance instance.
type QuestionAnsweringRelevanceInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Optional. Text provided as context to answer the question.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. The question asked and other instruction in the inference prompt.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *QuestionAnsweringRelevanceInstance) Reset() {
	*x = QuestionAnsweringRelevanceInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringRelevanceInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringRelevanceInstance) ProtoMessage() {}

func (x *QuestionAnsweringRelevanceInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringRelevanceInstance.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringRelevanceInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{62}
}

func (x *QuestionAnsweringRelevanceInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *QuestionAnsweringRelevanceInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *QuestionAnsweringRelevanceInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *QuestionAnsweringRelevanceInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for question answering relevance metric.
type QuestionAnsweringRelevanceSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute question answering
	// relevance.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *QuestionAnsweringRelevanceSpec) Reset() {
	*x = QuestionAnsweringRelevanceSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringRelevanceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringRelevanceSpec) ProtoMessage() {}

func (x *QuestionAnsweringRelevanceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringRelevanceSpec.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringRelevanceSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{63}
}

func (x *QuestionAnsweringRelevanceSpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *QuestionAnsweringRelevanceSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for question answering relevance result.
type QuestionAnsweringRelevanceResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Question Answering Relevance score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for question answering relevance score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for question answering relevance score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *QuestionAnsweringRelevanceResult) Reset() {
	*x = QuestionAnsweringRelevanceResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringRelevanceResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringRelevanceResult) ProtoMessage() {}

func (x *QuestionAnsweringRelevanceResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringRelevanceResult.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringRelevanceResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{64}
}

func (x *QuestionAnsweringRelevanceResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *QuestionAnsweringRelevanceResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *QuestionAnsweringRelevanceResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for question answering helpfulness metric.
type QuestionAnsweringHelpfulnessInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for question answering helpfulness score metric.
	MetricSpec *QuestionAnsweringHelpfulnessSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Question answering helpfulness instance.
	Instance *QuestionAnsweringHelpfulnessInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *QuestionAnsweringHelpfulnessInput) Reset() {
	*x = QuestionAnsweringHelpfulnessInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringHelpfulnessInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringHelpfulnessInput) ProtoMessage() {}

func (x *QuestionAnsweringHelpfulnessInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringHelpfulnessInput.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringHelpfulnessInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{65}
}

func (x *QuestionAnsweringHelpfulnessInput) GetMetricSpec() *QuestionAnsweringHelpfulnessSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *QuestionAnsweringHelpfulnessInput) GetInstance() *QuestionAnsweringHelpfulnessInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for question answering helpfulness instance.
type QuestionAnsweringHelpfulnessInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Optional. Text provided as context to answer the question.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. The question asked and other instruction in the inference prompt.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *QuestionAnsweringHelpfulnessInstance) Reset() {
	*x = QuestionAnsweringHelpfulnessInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringHelpfulnessInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringHelpfulnessInstance) ProtoMessage() {}

func (x *QuestionAnsweringHelpfulnessInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringHelpfulnessInstance.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringHelpfulnessInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{66}
}

func (x *QuestionAnsweringHelpfulnessInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *QuestionAnsweringHelpfulnessInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *QuestionAnsweringHelpfulnessInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *QuestionAnsweringHelpfulnessInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for question answering helpfulness metric.
type QuestionAnsweringHelpfulnessSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute question answering
	// helpfulness.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *QuestionAnsweringHelpfulnessSpec) Reset() {
	*x = QuestionAnsweringHelpfulnessSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringHelpfulnessSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringHelpfulnessSpec) ProtoMessage() {}

func (x *QuestionAnsweringHelpfulnessSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringHelpfulnessSpec.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringHelpfulnessSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{67}
}

func (x *QuestionAnsweringHelpfulnessSpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *QuestionAnsweringHelpfulnessSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for question answering helpfulness result.
type QuestionAnsweringHelpfulnessResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Question Answering Helpfulness score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for question answering helpfulness score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for question answering helpfulness score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *QuestionAnsweringHelpfulnessResult) Reset() {
	*x = QuestionAnsweringHelpfulnessResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringHelpfulnessResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringHelpfulnessResult) ProtoMessage() {}

func (x *QuestionAnsweringHelpfulnessResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringHelpfulnessResult.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringHelpfulnessResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{68}
}

func (x *QuestionAnsweringHelpfulnessResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *QuestionAnsweringHelpfulnessResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *QuestionAnsweringHelpfulnessResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for question answering correctness metric.
type QuestionAnsweringCorrectnessInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for question answering correctness score metric.
	MetricSpec *QuestionAnsweringCorrectnessSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Question answering correctness instance.
	Instance *QuestionAnsweringCorrectnessInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *QuestionAnsweringCorrectnessInput) Reset() {
	*x = QuestionAnsweringCorrectnessInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringCorrectnessInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringCorrectnessInput) ProtoMessage() {}

func (x *QuestionAnsweringCorrectnessInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringCorrectnessInput.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringCorrectnessInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{69}
}

func (x *QuestionAnsweringCorrectnessInput) GetMetricSpec() *QuestionAnsweringCorrectnessSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *QuestionAnsweringCorrectnessInput) GetInstance() *QuestionAnsweringCorrectnessInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for question answering correctness instance.
type QuestionAnsweringCorrectnessInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Optional. Text provided as context to answer the question.
	Context *string `protobuf:"bytes,3,opt,name=context,proto3,oneof" json:"context,omitempty"`
	// Required. The question asked and other instruction in the inference prompt.
	Instruction *string `protobuf:"bytes,4,opt,name=instruction,proto3,oneof" json:"instruction,omitempty"`
}

func (x *QuestionAnsweringCorrectnessInstance) Reset() {
	*x = QuestionAnsweringCorrectnessInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringCorrectnessInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringCorrectnessInstance) ProtoMessage() {}

func (x *QuestionAnsweringCorrectnessInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringCorrectnessInstance.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringCorrectnessInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{70}
}

func (x *QuestionAnsweringCorrectnessInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *QuestionAnsweringCorrectnessInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *QuestionAnsweringCorrectnessInstance) GetContext() string {
	if x != nil && x.Context != nil {
		return *x.Context
	}
	return ""
}

func (x *QuestionAnsweringCorrectnessInstance) GetInstruction() string {
	if x != nil && x.Instruction != nil {
		return *x.Instruction
	}
	return ""
}

// Spec for question answering correctness metric.
type QuestionAnsweringCorrectnessSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use instance.reference to compute question answering
	// correctness.
	UseReference bool `protobuf:"varint,1,opt,name=use_reference,json=useReference,proto3" json:"use_reference,omitempty"`
	// Optional. Which version to use for evaluation.
	Version int32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *QuestionAnsweringCorrectnessSpec) Reset() {
	*x = QuestionAnsweringCorrectnessSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringCorrectnessSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringCorrectnessSpec) ProtoMessage() {}

func (x *QuestionAnsweringCorrectnessSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringCorrectnessSpec.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringCorrectnessSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{71}
}

func (x *QuestionAnsweringCorrectnessSpec) GetUseReference() bool {
	if x != nil {
		return x.UseReference
	}
	return false
}

func (x *QuestionAnsweringCorrectnessSpec) GetVersion() int32 {
	if x != nil {
		return x.Version
	}
	return 0
}

// Spec for question answering correctness result.
type QuestionAnsweringCorrectnessResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Question Answering Correctness score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for question answering correctness score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
	// Output only. Confidence for question answering correctness score.
	Confidence *float32 `protobuf:"fixed32,3,opt,name=confidence,proto3,oneof" json:"confidence,omitempty"`
}

func (x *QuestionAnsweringCorrectnessResult) Reset() {
	*x = QuestionAnsweringCorrectnessResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *QuestionAnsweringCorrectnessResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*QuestionAnsweringCorrectnessResult) ProtoMessage() {}

func (x *QuestionAnsweringCorrectnessResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use QuestionAnsweringCorrectnessResult.ProtoReflect.Descriptor instead.
func (*QuestionAnsweringCorrectnessResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{72}
}

func (x *QuestionAnsweringCorrectnessResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *QuestionAnsweringCorrectnessResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

func (x *QuestionAnsweringCorrectnessResult) GetConfidence() float32 {
	if x != nil && x.Confidence != nil {
		return *x.Confidence
	}
	return 0
}

// Input for pointwise metric.
type PointwiseMetricInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for pointwise metric.
	MetricSpec *PointwiseMetricSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Pointwise metric instance.
	Instance *PointwiseMetricInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *PointwiseMetricInput) Reset() {
	*x = PointwiseMetricInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PointwiseMetricInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PointwiseMetricInput) ProtoMessage() {}

func (x *PointwiseMetricInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PointwiseMetricInput.ProtoReflect.Descriptor instead.
func (*PointwiseMetricInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{73}
}

func (x *PointwiseMetricInput) GetMetricSpec() *PointwiseMetricSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *PointwiseMetricInput) GetInstance() *PointwiseMetricInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Pointwise metric instance. Usually one instance corresponds to one row in an
// evaluation dataset.
type PointwiseMetricInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance for pointwise metric.
	//
	// Types that are assignable to Instance:
	//
	//	*PointwiseMetricInstance_JsonInstance
	Instance isPointwiseMetricInstance_Instance `protobuf_oneof:"instance"`
}

func (x *PointwiseMetricInstance) Reset() {
	*x = PointwiseMetricInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PointwiseMetricInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PointwiseMetricInstance) ProtoMessage() {}

func (x *PointwiseMetricInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PointwiseMetricInstance.ProtoReflect.Descriptor instead.
func (*PointwiseMetricInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{74}
}

func (m *PointwiseMetricInstance) GetInstance() isPointwiseMetricInstance_Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (x *PointwiseMetricInstance) GetJsonInstance() string {
	if x, ok := x.GetInstance().(*PointwiseMetricInstance_JsonInstance); ok {
		return x.JsonInstance
	}
	return ""
}

type isPointwiseMetricInstance_Instance interface {
	isPointwiseMetricInstance_Instance()
}

type PointwiseMetricInstance_JsonInstance struct {
	// Instance specified as a json string. String key-value pairs are expected
	// in the json_instance to render
	// PointwiseMetricSpec.instance_prompt_template.
	JsonInstance string `protobuf:"bytes,1,opt,name=json_instance,json=jsonInstance,proto3,oneof"`
}

func (*PointwiseMetricInstance_JsonInstance) isPointwiseMetricInstance_Instance() {}

// Spec for pointwise metric.
type PointwiseMetricSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Metric prompt template for pointwise metric.
	MetricPromptTemplate *string `protobuf:"bytes,1,opt,name=metric_prompt_template,json=metricPromptTemplate,proto3,oneof" json:"metric_prompt_template,omitempty"`
}

func (x *PointwiseMetricSpec) Reset() {
	*x = PointwiseMetricSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PointwiseMetricSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PointwiseMetricSpec) ProtoMessage() {}

func (x *PointwiseMetricSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PointwiseMetricSpec.ProtoReflect.Descriptor instead.
func (*PointwiseMetricSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{75}
}

func (x *PointwiseMetricSpec) GetMetricPromptTemplate() string {
	if x != nil && x.MetricPromptTemplate != nil {
		return *x.MetricPromptTemplate
	}
	return ""
}

// Spec for pointwise metric result.
type PointwiseMetricResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Pointwise metric score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
	// Output only. Explanation for pointwise metric score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
}

func (x *PointwiseMetricResult) Reset() {
	*x = PointwiseMetricResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PointwiseMetricResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PointwiseMetricResult) ProtoMessage() {}

func (x *PointwiseMetricResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PointwiseMetricResult.ProtoReflect.Descriptor instead.
func (*PointwiseMetricResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{76}
}

func (x *PointwiseMetricResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

func (x *PointwiseMetricResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

// Input for pairwise metric.
type PairwiseMetricInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for pairwise metric.
	MetricSpec *PairwiseMetricSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Pairwise metric instance.
	Instance *PairwiseMetricInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *PairwiseMetricInput) Reset() {
	*x = PairwiseMetricInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseMetricInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseMetricInput) ProtoMessage() {}

func (x *PairwiseMetricInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseMetricInput.ProtoReflect.Descriptor instead.
func (*PairwiseMetricInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{77}
}

func (x *PairwiseMetricInput) GetMetricSpec() *PairwiseMetricSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *PairwiseMetricInput) GetInstance() *PairwiseMetricInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Pairwise metric instance. Usually one instance corresponds to one row in an
// evaluation dataset.
type PairwiseMetricInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance for pairwise metric.
	//
	// Types that are assignable to Instance:
	//
	//	*PairwiseMetricInstance_JsonInstance
	Instance isPairwiseMetricInstance_Instance `protobuf_oneof:"instance"`
}

func (x *PairwiseMetricInstance) Reset() {
	*x = PairwiseMetricInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseMetricInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseMetricInstance) ProtoMessage() {}

func (x *PairwiseMetricInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseMetricInstance.ProtoReflect.Descriptor instead.
func (*PairwiseMetricInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{78}
}

func (m *PairwiseMetricInstance) GetInstance() isPairwiseMetricInstance_Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (x *PairwiseMetricInstance) GetJsonInstance() string {
	if x, ok := x.GetInstance().(*PairwiseMetricInstance_JsonInstance); ok {
		return x.JsonInstance
	}
	return ""
}

type isPairwiseMetricInstance_Instance interface {
	isPairwiseMetricInstance_Instance()
}

type PairwiseMetricInstance_JsonInstance struct {
	// Instance specified as a json string. String key-value pairs are expected
	// in the json_instance to render
	// PairwiseMetricSpec.instance_prompt_template.
	JsonInstance string `protobuf:"bytes,1,opt,name=json_instance,json=jsonInstance,proto3,oneof"`
}

func (*PairwiseMetricInstance_JsonInstance) isPairwiseMetricInstance_Instance() {}

// Spec for pairwise metric.
type PairwiseMetricSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Metric prompt template for pairwise metric.
	MetricPromptTemplate *string `protobuf:"bytes,1,opt,name=metric_prompt_template,json=metricPromptTemplate,proto3,oneof" json:"metric_prompt_template,omitempty"`
}

func (x *PairwiseMetricSpec) Reset() {
	*x = PairwiseMetricSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseMetricSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseMetricSpec) ProtoMessage() {}

func (x *PairwiseMetricSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseMetricSpec.ProtoReflect.Descriptor instead.
func (*PairwiseMetricSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{79}
}

func (x *PairwiseMetricSpec) GetMetricPromptTemplate() string {
	if x != nil && x.MetricPromptTemplate != nil {
		return *x.MetricPromptTemplate
	}
	return ""
}

// Spec for pairwise metric result.
type PairwiseMetricResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Pairwise metric choice.
	PairwiseChoice PairwiseChoice `protobuf:"varint,1,opt,name=pairwise_choice,json=pairwiseChoice,proto3,enum=google.cloud.aiplatform.v1.PairwiseChoice" json:"pairwise_choice,omitempty"`
	// Output only. Explanation for pairwise metric score.
	Explanation string `protobuf:"bytes,2,opt,name=explanation,proto3" json:"explanation,omitempty"`
}

func (x *PairwiseMetricResult) Reset() {
	*x = PairwiseMetricResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PairwiseMetricResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PairwiseMetricResult) ProtoMessage() {}

func (x *PairwiseMetricResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PairwiseMetricResult.ProtoReflect.Descriptor instead.
func (*PairwiseMetricResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{80}
}

func (x *PairwiseMetricResult) GetPairwiseChoice() PairwiseChoice {
	if x != nil {
		return x.PairwiseChoice
	}
	return PairwiseChoice_PAIRWISE_CHOICE_UNSPECIFIED
}

func (x *PairwiseMetricResult) GetExplanation() string {
	if x != nil {
		return x.Explanation
	}
	return ""
}

// Input for tool call valid metric.
type ToolCallValidInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for tool call valid metric.
	MetricSpec *ToolCallValidSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated tool call valid instances.
	Instances []*ToolCallValidInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ToolCallValidInput) Reset() {
	*x = ToolCallValidInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallValidInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallValidInput) ProtoMessage() {}

func (x *ToolCallValidInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallValidInput.ProtoReflect.Descriptor instead.
func (*ToolCallValidInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{81}
}

func (x *ToolCallValidInput) GetMetricSpec() *ToolCallValidSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *ToolCallValidInput) GetInstances() []*ToolCallValidInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for tool call valid metric.
type ToolCallValidSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ToolCallValidSpec) Reset() {
	*x = ToolCallValidSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallValidSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallValidSpec) ProtoMessage() {}

func (x *ToolCallValidSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallValidSpec.ProtoReflect.Descriptor instead.
func (*ToolCallValidSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{82}
}

// Spec for tool call valid instance.
type ToolCallValidInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *ToolCallValidInstance) Reset() {
	*x = ToolCallValidInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallValidInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallValidInstance) ProtoMessage() {}

func (x *ToolCallValidInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallValidInstance.ProtoReflect.Descriptor instead.
func (*ToolCallValidInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{83}
}

func (x *ToolCallValidInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *ToolCallValidInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Results for tool call valid metric.
type ToolCallValidResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool call valid metric values.
	ToolCallValidMetricValues []*ToolCallValidMetricValue `protobuf:"bytes,1,rep,name=tool_call_valid_metric_values,json=toolCallValidMetricValues,proto3" json:"tool_call_valid_metric_values,omitempty"`
}

func (x *ToolCallValidResults) Reset() {
	*x = ToolCallValidResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallValidResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallValidResults) ProtoMessage() {}

func (x *ToolCallValidResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallValidResults.ProtoReflect.Descriptor instead.
func (*ToolCallValidResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{84}
}

func (x *ToolCallValidResults) GetToolCallValidMetricValues() []*ToolCallValidMetricValue {
	if x != nil {
		return x.ToolCallValidMetricValues
	}
	return nil
}

// Tool call valid metric value for an instance.
type ToolCallValidMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool call valid score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *ToolCallValidMetricValue) Reset() {
	*x = ToolCallValidMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolCallValidMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolCallValidMetricValue) ProtoMessage() {}

func (x *ToolCallValidMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolCallValidMetricValue.ProtoReflect.Descriptor instead.
func (*ToolCallValidMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{85}
}

func (x *ToolCallValidMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for tool name match metric.
type ToolNameMatchInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for tool name match metric.
	MetricSpec *ToolNameMatchSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated tool name match instances.
	Instances []*ToolNameMatchInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ToolNameMatchInput) Reset() {
	*x = ToolNameMatchInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolNameMatchInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolNameMatchInput) ProtoMessage() {}

func (x *ToolNameMatchInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolNameMatchInput.ProtoReflect.Descriptor instead.
func (*ToolNameMatchInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{86}
}

func (x *ToolNameMatchInput) GetMetricSpec() *ToolNameMatchSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *ToolNameMatchInput) GetInstances() []*ToolNameMatchInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for tool name match metric.
type ToolNameMatchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ToolNameMatchSpec) Reset() {
	*x = ToolNameMatchSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolNameMatchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolNameMatchSpec) ProtoMessage() {}

func (x *ToolNameMatchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolNameMatchSpec.ProtoReflect.Descriptor instead.
func (*ToolNameMatchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{87}
}

// Spec for tool name match instance.
type ToolNameMatchInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *ToolNameMatchInstance) Reset() {
	*x = ToolNameMatchInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolNameMatchInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolNameMatchInstance) ProtoMessage() {}

func (x *ToolNameMatchInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolNameMatchInstance.ProtoReflect.Descriptor instead.
func (*ToolNameMatchInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{88}
}

func (x *ToolNameMatchInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *ToolNameMatchInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Results for tool name match metric.
type ToolNameMatchResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool name match metric values.
	ToolNameMatchMetricValues []*ToolNameMatchMetricValue `protobuf:"bytes,1,rep,name=tool_name_match_metric_values,json=toolNameMatchMetricValues,proto3" json:"tool_name_match_metric_values,omitempty"`
}

func (x *ToolNameMatchResults) Reset() {
	*x = ToolNameMatchResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolNameMatchResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolNameMatchResults) ProtoMessage() {}

func (x *ToolNameMatchResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolNameMatchResults.ProtoReflect.Descriptor instead.
func (*ToolNameMatchResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{89}
}

func (x *ToolNameMatchResults) GetToolNameMatchMetricValues() []*ToolNameMatchMetricValue {
	if x != nil {
		return x.ToolNameMatchMetricValues
	}
	return nil
}

// Tool name match metric value for an instance.
type ToolNameMatchMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool name match score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *ToolNameMatchMetricValue) Reset() {
	*x = ToolNameMatchMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolNameMatchMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolNameMatchMetricValue) ProtoMessage() {}

func (x *ToolNameMatchMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolNameMatchMetricValue.ProtoReflect.Descriptor instead.
func (*ToolNameMatchMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{90}
}

func (x *ToolNameMatchMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for tool parameter key match metric.
type ToolParameterKeyMatchInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for tool parameter key match metric.
	MetricSpec *ToolParameterKeyMatchSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated tool parameter key match instances.
	Instances []*ToolParameterKeyMatchInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ToolParameterKeyMatchInput) Reset() {
	*x = ToolParameterKeyMatchInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKeyMatchInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKeyMatchInput) ProtoMessage() {}

func (x *ToolParameterKeyMatchInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKeyMatchInput.ProtoReflect.Descriptor instead.
func (*ToolParameterKeyMatchInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{91}
}

func (x *ToolParameterKeyMatchInput) GetMetricSpec() *ToolParameterKeyMatchSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *ToolParameterKeyMatchInput) GetInstances() []*ToolParameterKeyMatchInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for tool parameter key match metric.
type ToolParameterKeyMatchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ToolParameterKeyMatchSpec) Reset() {
	*x = ToolParameterKeyMatchSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKeyMatchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKeyMatchSpec) ProtoMessage() {}

func (x *ToolParameterKeyMatchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKeyMatchSpec.ProtoReflect.Descriptor instead.
func (*ToolParameterKeyMatchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{92}
}

// Spec for tool parameter key match instance.
type ToolParameterKeyMatchInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *ToolParameterKeyMatchInstance) Reset() {
	*x = ToolParameterKeyMatchInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKeyMatchInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKeyMatchInstance) ProtoMessage() {}

func (x *ToolParameterKeyMatchInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKeyMatchInstance.ProtoReflect.Descriptor instead.
func (*ToolParameterKeyMatchInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{93}
}

func (x *ToolParameterKeyMatchInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *ToolParameterKeyMatchInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Results for tool parameter key match metric.
type ToolParameterKeyMatchResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool parameter key match metric values.
	ToolParameterKeyMatchMetricValues []*ToolParameterKeyMatchMetricValue `protobuf:"bytes,1,rep,name=tool_parameter_key_match_metric_values,json=toolParameterKeyMatchMetricValues,proto3" json:"tool_parameter_key_match_metric_values,omitempty"`
}

func (x *ToolParameterKeyMatchResults) Reset() {
	*x = ToolParameterKeyMatchResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKeyMatchResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKeyMatchResults) ProtoMessage() {}

func (x *ToolParameterKeyMatchResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKeyMatchResults.ProtoReflect.Descriptor instead.
func (*ToolParameterKeyMatchResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{94}
}

func (x *ToolParameterKeyMatchResults) GetToolParameterKeyMatchMetricValues() []*ToolParameterKeyMatchMetricValue {
	if x != nil {
		return x.ToolParameterKeyMatchMetricValues
	}
	return nil
}

// Tool parameter key match metric value for an instance.
type ToolParameterKeyMatchMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool parameter key match score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *ToolParameterKeyMatchMetricValue) Reset() {
	*x = ToolParameterKeyMatchMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKeyMatchMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKeyMatchMetricValue) ProtoMessage() {}

func (x *ToolParameterKeyMatchMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKeyMatchMetricValue.ProtoReflect.Descriptor instead.
func (*ToolParameterKeyMatchMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{95}
}

func (x *ToolParameterKeyMatchMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for tool parameter key value match metric.
type ToolParameterKVMatchInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for tool parameter key value match metric.
	MetricSpec *ToolParameterKVMatchSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Repeated tool parameter key value match instances.
	Instances []*ToolParameterKVMatchInstance `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
}

func (x *ToolParameterKVMatchInput) Reset() {
	*x = ToolParameterKVMatchInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKVMatchInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKVMatchInput) ProtoMessage() {}

func (x *ToolParameterKVMatchInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKVMatchInput.ProtoReflect.Descriptor instead.
func (*ToolParameterKVMatchInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{96}
}

func (x *ToolParameterKVMatchInput) GetMetricSpec() *ToolParameterKVMatchSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *ToolParameterKVMatchInput) GetInstances() []*ToolParameterKVMatchInstance {
	if x != nil {
		return x.Instances
	}
	return nil
}

// Spec for tool parameter key value match metric.
type ToolParameterKVMatchSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Whether to use STRICT string match on parameter values.
	UseStrictStringMatch bool `protobuf:"varint,1,opt,name=use_strict_string_match,json=useStrictStringMatch,proto3" json:"use_strict_string_match,omitempty"`
}

func (x *ToolParameterKVMatchSpec) Reset() {
	*x = ToolParameterKVMatchSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKVMatchSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKVMatchSpec) ProtoMessage() {}

func (x *ToolParameterKVMatchSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKVMatchSpec.ProtoReflect.Descriptor instead.
func (*ToolParameterKVMatchSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{97}
}

func (x *ToolParameterKVMatchSpec) GetUseStrictStringMatch() bool {
	if x != nil {
		return x.UseStrictStringMatch
	}
	return false
}

// Spec for tool parameter key value match instance.
type ToolParameterKVMatchInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Required. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
}

func (x *ToolParameterKVMatchInstance) Reset() {
	*x = ToolParameterKVMatchInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKVMatchInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKVMatchInstance) ProtoMessage() {}

func (x *ToolParameterKVMatchInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKVMatchInstance.ProtoReflect.Descriptor instead.
func (*ToolParameterKVMatchInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{98}
}

func (x *ToolParameterKVMatchInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *ToolParameterKVMatchInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

// Results for tool parameter key value match metric.
type ToolParameterKVMatchResults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool parameter key value match metric values.
	ToolParameterKvMatchMetricValues []*ToolParameterKVMatchMetricValue `protobuf:"bytes,1,rep,name=tool_parameter_kv_match_metric_values,json=toolParameterKvMatchMetricValues,proto3" json:"tool_parameter_kv_match_metric_values,omitempty"`
}

func (x *ToolParameterKVMatchResults) Reset() {
	*x = ToolParameterKVMatchResults{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKVMatchResults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKVMatchResults) ProtoMessage() {}

func (x *ToolParameterKVMatchResults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKVMatchResults.ProtoReflect.Descriptor instead.
func (*ToolParameterKVMatchResults) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{99}
}

func (x *ToolParameterKVMatchResults) GetToolParameterKvMatchMetricValues() []*ToolParameterKVMatchMetricValue {
	if x != nil {
		return x.ToolParameterKvMatchMetricValues
	}
	return nil
}

// Tool parameter key value match metric value for an instance.
type ToolParameterKVMatchMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Tool parameter key value match score.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *ToolParameterKVMatchMetricValue) Reset() {
	*x = ToolParameterKVMatchMetricValue{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ToolParameterKVMatchMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ToolParameterKVMatchMetricValue) ProtoMessage() {}

func (x *ToolParameterKVMatchMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ToolParameterKVMatchMetricValue.ProtoReflect.Descriptor instead.
func (*ToolParameterKVMatchMetricValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{100}
}

func (x *ToolParameterKVMatchMetricValue) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for Comet metric.
type CometInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for comet metric.
	MetricSpec *CometSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Comet instance.
	Instance *CometInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *CometInput) Reset() {
	*x = CometInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CometInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CometInput) ProtoMessage() {}

func (x *CometInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CometInput.ProtoReflect.Descriptor instead.
func (*CometInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{101}
}

func (x *CometInput) GetMetricSpec() *CometSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *CometInput) GetInstance() *CometInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for Comet metric.
type CometSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Which version to use for evaluation.
	Version *CometSpec_CometVersion `protobuf:"varint,1,opt,name=version,proto3,enum=google.cloud.aiplatform.v1.CometSpec_CometVersion,oneof" json:"version,omitempty"`
	// Optional. Source language in BCP-47 format.
	SourceLanguage string `protobuf:"bytes,2,opt,name=source_language,json=sourceLanguage,proto3" json:"source_language,omitempty"`
	// Optional. Target language in BCP-47 format. Covers both prediction and
	// reference.
	TargetLanguage string `protobuf:"bytes,3,opt,name=target_language,json=targetLanguage,proto3" json:"target_language,omitempty"`
}

func (x *CometSpec) Reset() {
	*x = CometSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CometSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CometSpec) ProtoMessage() {}

func (x *CometSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CometSpec.ProtoReflect.Descriptor instead.
func (*CometSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{102}
}

func (x *CometSpec) GetVersion() CometSpec_CometVersion {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return CometSpec_COMET_VERSION_UNSPECIFIED
}

func (x *CometSpec) GetSourceLanguage() string {
	if x != nil {
		return x.SourceLanguage
	}
	return ""
}

func (x *CometSpec) GetTargetLanguage() string {
	if x != nil {
		return x.TargetLanguage
	}
	return ""
}

// Spec for Comet instance - The fields used for evaluation are dependent on the
// comet version.
type CometInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Optional. Source text in original language.
	Source *string `protobuf:"bytes,3,opt,name=source,proto3,oneof" json:"source,omitempty"`
}

func (x *CometInstance) Reset() {
	*x = CometInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CometInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CometInstance) ProtoMessage() {}

func (x *CometInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CometInstance.ProtoReflect.Descriptor instead.
func (*CometInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{103}
}

func (x *CometInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *CometInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *CometInstance) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

// Spec for Comet result - calculates the comet score for the given instance
// using the version specified in the spec.
type CometResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Comet score. Range depends on version.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *CometResult) Reset() {
	*x = CometResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CometResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CometResult) ProtoMessage() {}

func (x *CometResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CometResult.ProtoReflect.Descriptor instead.
func (*CometResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{104}
}

func (x *CometResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

// Input for MetricX metric.
type MetricxInput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Spec for Metricx metric.
	MetricSpec *MetricxSpec `protobuf:"bytes,1,opt,name=metric_spec,json=metricSpec,proto3" json:"metric_spec,omitempty"`
	// Required. Metricx instance.
	Instance *MetricxInstance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *MetricxInput) Reset() {
	*x = MetricxInput{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricxInput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricxInput) ProtoMessage() {}

func (x *MetricxInput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricxInput.ProtoReflect.Descriptor instead.
func (*MetricxInput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{105}
}

func (x *MetricxInput) GetMetricSpec() *MetricxSpec {
	if x != nil {
		return x.MetricSpec
	}
	return nil
}

func (x *MetricxInput) GetInstance() *MetricxInstance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// Spec for MetricX metric.
type MetricxSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Which version to use for evaluation.
	Version *MetricxSpec_MetricxVersion `protobuf:"varint,1,opt,name=version,proto3,enum=google.cloud.aiplatform.v1.MetricxSpec_MetricxVersion,oneof" json:"version,omitempty"`
	// Optional. Source language in BCP-47 format.
	SourceLanguage string `protobuf:"bytes,2,opt,name=source_language,json=sourceLanguage,proto3" json:"source_language,omitempty"`
	// Optional. Target language in BCP-47 format. Covers both prediction and
	// reference.
	TargetLanguage string `protobuf:"bytes,3,opt,name=target_language,json=targetLanguage,proto3" json:"target_language,omitempty"`
}

func (x *MetricxSpec) Reset() {
	*x = MetricxSpec{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricxSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricxSpec) ProtoMessage() {}

func (x *MetricxSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricxSpec.ProtoReflect.Descriptor instead.
func (*MetricxSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{106}
}

func (x *MetricxSpec) GetVersion() MetricxSpec_MetricxVersion {
	if x != nil && x.Version != nil {
		return *x.Version
	}
	return MetricxSpec_METRICX_VERSION_UNSPECIFIED
}

func (x *MetricxSpec) GetSourceLanguage() string {
	if x != nil {
		return x.SourceLanguage
	}
	return ""
}

func (x *MetricxSpec) GetTargetLanguage() string {
	if x != nil {
		return x.TargetLanguage
	}
	return ""
}

// Spec for MetricX instance - The fields used for evaluation are dependent on
// the MetricX version.
type MetricxInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Output of the evaluated model.
	Prediction *string `protobuf:"bytes,1,opt,name=prediction,proto3,oneof" json:"prediction,omitempty"`
	// Optional. Ground truth used to compare against the prediction.
	Reference *string `protobuf:"bytes,2,opt,name=reference,proto3,oneof" json:"reference,omitempty"`
	// Optional. Source text in original language.
	Source *string `protobuf:"bytes,3,opt,name=source,proto3,oneof" json:"source,omitempty"`
}

func (x *MetricxInstance) Reset() {
	*x = MetricxInstance{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricxInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricxInstance) ProtoMessage() {}

func (x *MetricxInstance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricxInstance.ProtoReflect.Descriptor instead.
func (*MetricxInstance) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{107}
}

func (x *MetricxInstance) GetPrediction() string {
	if x != nil && x.Prediction != nil {
		return *x.Prediction
	}
	return ""
}

func (x *MetricxInstance) GetReference() string {
	if x != nil && x.Reference != nil {
		return *x.Reference
	}
	return ""
}

func (x *MetricxInstance) GetSource() string {
	if x != nil && x.Source != nil {
		return *x.Source
	}
	return ""
}

// Spec for MetricX result - calculates the MetricX score for the given instance
// using the version specified in the spec.
type MetricxResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. MetricX score. Range depends on version.
	Score *float32 `protobuf:"fixed32,1,opt,name=score,proto3,oneof" json:"score,omitempty"`
}

func (x *MetricxResult) Reset() {
	*x = MetricxResult{}
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricxResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricxResult) ProtoMessage() {}

func (x *MetricxResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MetricxResult.ProtoReflect.Descriptor instead.
func (*MetricxResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP(), []int{108}
}

func (x *MetricxResult) GetScore() float32 {
	if x != nil && x.Score != nil {
		return *x.Score
	}
	return 0
}

var File_google_cloud_aiplatform_v1_evaluation_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x61,
	0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xae, 0x16, 0x0a, 0x18, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x59, 0x0a, 0x11, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0f, 0x65, 0x78, 0x61,
	0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x46, 0x0a, 0x0a,
	0x62, 0x6c, 0x65, 0x75, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c,
	0x65, 0x75, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6c, 0x65, 0x75, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x49, 0x0a, 0x0b, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x48, 0x00, 0x52, 0x0a, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12,
	0x4f, 0x0a, 0x0d, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x48, 0x00, 0x52, 0x0c, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x55, 0x0a, 0x0f, 0x63, 0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0e, 0x63, 0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4c, 0x0a, 0x0c, 0x73, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5e, 0x0a, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65,
	0x64, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x48, 0x00, 0x52, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5b, 0x0a, 0x11, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00,
	0x52, 0x10, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x77, 0x0a, 0x1b, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00,
	0x52, 0x19, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x90, 0x01, 0x0a, 0x24,
	0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x21, 0x70, 0x61, 0x69,
	0x72, 0x77, 0x69, 0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x83,
	0x01, 0x0a, 0x1f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x68, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x1d, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x12, 0x7d, 0x0a, 0x1d, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x5f,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x1b, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x84, 0x01, 0x0a, 0x20, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x1d, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x9d, 0x01, 0x0a, 0x29, 0x70,
	0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x18, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72,
	0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x48, 0x00, 0x52, 0x25, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x8a, 0x01, 0x0a, 0x22, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x1f, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x90, 0x01, 0x0a, 0x24, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x68,
	0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x21, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75,
	0x6c, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x90, 0x01, 0x0a, 0x24, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x5f, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x21, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72,
	0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x68, 0x0a,
	0x16, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48,
	0x00, 0x52, 0x14, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x65, 0x0a, 0x15, 0x70, 0x61, 0x69, 0x72, 0x77,
	0x69, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x13, 0x70, 0x61, 0x69, 0x72, 0x77,
	0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x63,
	0x0a, 0x15, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43,
	0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52,
	0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x63, 0x0a, 0x15, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x48, 0x00, 0x52, 0x12, 0x74, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x7c, 0x0a, 0x1e, 0x74, 0x6f, 0x6f, 0x6c,
	0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6d,
	0x61, 0x74, 0x63, 0x68, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x1a, 0x74, 0x6f, 0x6f, 0x6c,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x79, 0x0a, 0x1d, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x76, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x19, 0x74, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x76, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x49, 0x0a, 0x0b, 0x63, 0x6f, 0x6d, 0x65, 0x74, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x18, 0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00,
	0x52, 0x0a, 0x63, 0x6f, 0x6d, 0x65, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4f, 0x0a, 0x0d,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x5f, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x20, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52,
	0x0c, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x45, 0x0a,
	0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x73, 0x22, 0xcf, 0x16, 0x0a, 0x19, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x5f, 0x0a, 0x13, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74,
	0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x48,
	0x00, 0x52, 0x11, 0x65, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x4c, 0x0a, 0x0c, 0x62, 0x6c, 0x65, 0x75, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x65, 0x75, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0b, 0x62, 0x6c, 0x65, 0x75, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x73, 0x12, 0x4f, 0x0a, 0x0d, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x48, 0x00, 0x52, 0x0c, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x52, 0x0a, 0x0e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x58, 0x0a, 0x10, 0x63, 0x6f, 0x68, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x0f, 0x63, 0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x4f, 0x0a, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x61, 0x0a, 0x13, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65,
	0x73, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f,
	0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48,
	0x00, 0x52, 0x12, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x5e, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46,
	0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x11, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x7a, 0x0a, 0x1c, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1a, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x93, 0x01, 0x0a, 0x25, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x73,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x71, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x16, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x48, 0x00, 0x52, 0x22, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x86, 0x01, 0x0a, 0x20, 0x73, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x68, 0x65, 0x6c, 0x70, 0x66, 0x75,
	0x6c, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c,
	0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x1e, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48,
	0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x80, 0x01, 0x0a, 0x1e, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x76, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1c, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x87, 0x01, 0x0a, 0x21, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x1e, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0xa0, 0x01,
	0x0a, 0x2a, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x17, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x26, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69,
	0x73, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x8d, 0x01, 0x0a, 0x23, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63,
	0x65, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c,
	0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x20,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x93, 0x01, 0x0a, 0x25, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x68, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e,
	0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x48,
	0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x22, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x93, 0x01, 0x0a, 0x25, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x63, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x22, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65,
	0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x6b, 0x0a, 0x17,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74,
	0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x15, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x68, 0x0a, 0x16, 0x70, 0x61, 0x69,
	0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x72, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x18, 0x1c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00, 0x52, 0x14, 0x70,
	0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x69, 0x0a, 0x17, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x12,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x48, 0x00, 0x52, 0x14, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61,
	0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x69,
	0x0a, 0x17, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x48, 0x00, 0x52, 0x14, 0x74, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x82, 0x01, 0x0a, 0x20, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b,
	0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x48, 0x00,
	0x52, 0x1c, 0x74, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b,
	0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x7f,
	0x0a, 0x1f, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x5f, 0x6b, 0x76, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x48, 0x00, 0x52, 0x1b, 0x74, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x4b, 0x76, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12,
	0x4c, 0x0a, 0x0c, 0x63, 0x6f, 0x6d, 0x65, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x48, 0x00,
	0x52, 0x0b, 0x63, 0x6f, 0x6d, 0x65, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x52, 0x0a,
	0x0e, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18,
	0x1e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x48, 0x00, 0x52, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x42, 0x14, 0x0a, 0x12, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x22, 0xb6, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x61, 0x63,
	0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x50, 0x0a, 0x0b, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x51, 0x0a,
	0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x22, 0x83, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01,
	0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x10, 0x0a, 0x0e, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x22, 0x86, 0x01, 0x0a, 0x11, 0x45, 0x78, 0x61,
	0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x71,
	0x0a, 0x19, 0x65, 0x78, 0x61, 0x63, 0x74, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x65, 0x78, 0x61, 0x63, 0x74,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x22, 0x41, 0x0a, 0x15, 0x45, 0x78, 0x61, 0x63, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x22, 0xa4, 0x01, 0x0a, 0x09, 0x42, 0x6c, 0x65, 0x75, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x4a, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x65, 0x75, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4b,
	0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x6c, 0x65, 0x75, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x7d, 0x0a, 0x0c, 0x42,
	0x6c, 0x65, 0x75, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x3f, 0x0a, 0x08, 0x42, 0x6c,
	0x65, 0x75, 0x53, 0x70, 0x65, 0x63, 0x12, 0x33, 0x0a, 0x13, 0x75, 0x73, 0x65, 0x5f, 0x65, 0x66,
	0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x75, 0x73, 0x65, 0x45, 0x66, 0x66,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x22, 0x6d, 0x0a, 0x0b, 0x42,
	0x6c, 0x65, 0x75, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x5e, 0x0a, 0x12, 0x62, 0x6c,
	0x65, 0x75, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6c, 0x65, 0x75, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x62, 0x6c, 0x65, 0x75, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x3b, 0x0a, 0x0f, 0x42, 0x6c,
	0x65, 0x75, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xa7, 0x01, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x67,
	0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x22, 0x7e, 0x0a, 0x0d, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x22, 0x83, 0x01, 0x0a, 0x09, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x74, 0x65, 0x6d, 0x6d,
	0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75,
	0x73, 0x65, 0x53, 0x74, 0x65, 0x6d, 0x6d, 0x65, 0x72, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x70, 0x6c,
	0x69, 0x74, 0x5f, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x65, 0x73, 0x22, 0x71, 0x0a, 0x0c, 0x52, 0x6f, 0x75, 0x67, 0x65,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x61, 0x0a, 0x13, 0x72, 0x6f, 0x75, 0x67, 0x65,
	0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x6f, 0x75, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x6f, 0x75, 0x67, 0x65, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x3c, 0x0a, 0x10, 0x52, 0x6f,
	0x75, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08,
	0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x0e, 0x43, 0x6f, 0x68,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4f, 0x0a, 0x0b, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4e, 0x0a, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x68, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x4c, 0x0a, 0x11,
	0x43, 0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x2e, 0x0a, 0x0d, 0x43, 0x6f,
	0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0x0a, 0x0f, 0x43,
	0x6f, 0x68, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xab, 0x01, 0x0a, 0x0c, 0x46, 0x6c, 0x75,
	0x65, 0x6e, 0x63, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4d, 0x0a, 0x0b, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x75, 0x65,
	0x6e, 0x63, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x4a, 0x0a, 0x0f, 0x46, 0x6c, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x2c, 0x0a, 0x0b, 0x46, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0x99, 0x01, 0x0a, 0x0d, 0x46, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xa8, 0x01, 0x0a,
	0x0b, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4c, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4b, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x49, 0x0a, 0x0e, 0x53, 0x61, 0x66, 0x65, 0x74,
	0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x2b, 0x0a, 0x0a, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22,
	0x98, 0x01, 0x0a, 0x0c, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x11, 0x47,
	0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74,
	0x12, 0x52, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x51, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x7f, 0x0a, 0x14, 0x47, 0x72, 0x6f, 0x75, 0x6e,
	0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48,
	0x01, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x22, 0x31, 0x0a, 0x10, 0x47, 0x72, 0x6f, 0x75,
	0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x9e, 0x01, 0x0a, 0x12,
	0x47, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xb7, 0x01, 0x0a,
	0x10, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x51, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x50, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x8a, 0x01, 0x0a, 0x13, 0x46, 0x75, 0x6c, 0x66, 0x69,
	0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28,
	0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x01, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x30, 0x0a, 0x0f, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x01, 0x0a, 0x11, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c,
	0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06,
	0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xd2, 0x01, 0x0a, 0x19, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x5a, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x59, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xf9, 0x01, 0x0a, 0x1c, 0x53,
	0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c,
	0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x63, 0x0a, 0x18, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70,
	0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c,
	0x75, 0x73, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa6, 0x01, 0x0a, 0x1a,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63,
	0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00,
	0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f,
	0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x22, 0xea, 0x01, 0x0a, 0x21, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73,
	0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x62, 0x0a, 0x0b, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69,
	0x72, 0x77, 0x69, 0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x61,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61,
	0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0xd4, 0x02, 0x0a, 0x24, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x53, 0x75,
	0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x13, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65,
	0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x12, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69,
	0x6e, 0x65, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x04, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c,
	0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08,
	0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x20, 0x50, 0x61, 0x69, 0x72,
	0x77, 0x69, 0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d,
	0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xde, 0x01, 0x0a, 0x22, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69,
	0x73, 0x65, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x58, 0x0a, 0x0f,
	0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65,
	0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a,
	0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64,
	0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xde, 0x01, 0x0a, 0x1d, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e,
	0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5e, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e,
	0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5d, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x20, 0x53, 0x75, 0x6d, 0x6d,
	0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c,
	0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a,
	0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22,
	0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88,
	0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0b,
	0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x1c, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e,
	0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x5f, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0xaa, 0x01, 0x0a, 0x1e, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65,
	0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d,
	0x0a, 0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xd8, 0x01,
	0x0a, 0x1b, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56,
	0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5c, 0x0a,
	0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72,
	0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5b, 0x0a, 0x08, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x6d, 0x6d, 0x61,
	0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74,
	0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xfb, 0x01, 0x0a, 0x1e, 0x53, 0x75, 0x6d,
	0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73,
	0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a,
	0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01,
	0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0b, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x65, 0x0a, 0x1a, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x75, 0x73, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa8, 0x01,
	0x0a, 0x1c, 0x53, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56,
	0x65, 0x72, 0x62, 0x6f, 0x73, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e,
	0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42,
	0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xde, 0x01, 0x0a, 0x1d, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5e, 0x0a, 0x0b, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5d, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xfd, 0x01, 0x0a, 0x20, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28,
	0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03,
	0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a,
	0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0x0a, 0x1c, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xaa, 0x01, 0x0a, 0x1e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41,
	0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65,
	0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22,
	0xf6, 0x01, 0x0a, 0x25, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61,
	0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x66, 0x0a, 0x0b, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72,
	0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x65, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xd8, 0x02, 0x0a, 0x28, 0x50, 0x61, 0x69,
	0x72, 0x77, 0x69, 0x73, 0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00,
	0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x39, 0x0a, 0x13, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x01, 0x52, 0x12, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x02, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x04, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x16, 0x0a, 0x14, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x6f, 0x0a, 0x24, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75,
	0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x52, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x22, 0xe2, 0x01, 0x0a, 0x26, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73,
	0x65, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12,
	0x58, 0x0a, 0x0f, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x6f, 0x69,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x43, 0x68,
	0x6f, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x61, 0x69, 0x72, 0x77,
	0x69, 0x73, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xe4, 0x01, 0x0a, 0x1f, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52,
	0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x60, 0x0a,
	0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x5f, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x22, 0xff, 0x01, 0x0a, 0x22, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01,
	0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a,
	0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x69, 0x0a, 0x1e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0c, 0x75, 0x73, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d,
	0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xac, 0x01,
	0x0a, 0x20, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72,
	0x69, 0x6e, 0x67, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88,
	0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xea, 0x01, 0x0a,
	0x21, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x62, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73,
	0x73, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x61, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e,
	0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65,
	0x73, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x24, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x48,
	0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x07, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x48, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a,
	0x0c, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a,
	0x20, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75,
	0x73, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x22, 0x51,
	0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x48, 0x65, 0x6c, 0x70, 0x66, 0x75, 0x6c, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88,
	0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xea, 0x01, 0x0a, 0x21,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x70, 0x75,
	0x74, 0x12, 0x62, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77,
	0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x61, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73,
	0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73,
	0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x24, 0x51, 0x75, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x07, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x03, 0x52, 0x0b, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6b, 0x0a, 0x20,
	0x51, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e,
	0x67, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x28, 0x0a, 0x0d, 0x75, 0x73, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x75, 0x73,
	0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xae, 0x01, 0x0a, 0x22, 0x51, 0x75,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x6e, 0x73, 0x77, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74,
	0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01,
	0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c,
	0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x01, 0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x42, 0x0d, 0x0a, 0x0b, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xc3, 0x01, 0x0a, 0x14, 0x50,
	0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e,
	0x70, 0x75, 0x74, 0x12, 0x55, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x54, 0x0a, 0x08, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x77,
	0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x22, 0x4c, 0x0a, 0x17, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x6a,
	0x73, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x6a, 0x73, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x42, 0x0a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x70,
	0x0a, 0x13, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3e, 0x0a, 0x16, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x14, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x88, 0x01, 0x01, 0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x22, 0x68, 0x0a, 0x15, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52,
	0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x25, 0x0a, 0x0b, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xc0, 0x01, 0x0a, 0x13, 0x50,
	0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x70,
	0x75, 0x74, 0x12, 0x54, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x53, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x4b, 0x0a,
	0x16, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x0a, 0x0d, 0x6a, 0x73, 0x6f, 0x6e, 0x5f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00,
	0x52, 0x0c, 0x6a, 0x73, 0x6f, 0x6e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x0a,
	0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x6f, 0x0a, 0x12, 0x50, 0x61,
	0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x3e, 0x0a, 0x16, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x70,
	0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x14, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x19, 0x0a, 0x17, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x70, 0x72, 0x6f, 0x6d,
	0x70, 0x74, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x14,
	0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x58, 0x0a, 0x0f, 0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65,
	0x5f, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x69, 0x72, 0x77,
	0x69, 0x73, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x70, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12, 0x25,
	0x0a, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xbf, 0x01, 0x0a, 0x12, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61,
	0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x53, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x53, 0x70, 0x65, 0x63,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x54, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x13, 0x0a, 0x11, 0x54, 0x6f, 0x6f, 0x6c, 0x43,
	0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x53, 0x70, 0x65, 0x63, 0x22, 0x86, 0x01, 0x0a,
	0x15, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48,
	0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x93, 0x01, 0x0a, 0x14, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61,
	0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x7b,
	0x0a, 0x1d, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x69,
	0x64, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x19, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x44, 0x0a, 0x18, 0x54,
	0x6f, 0x6f, 0x6c, 0x43, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73,
	0x63, 0x6f, 0x72, 0x65, 0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72,
	0x65, 0x22, 0xbf, 0x01, 0x0a, 0x12, 0x54, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x53, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x54, 0x0a,
	0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f,
	0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x22, 0x13, 0x0a, 0x11, 0x54, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x22, 0x86, 0x01, 0x0a, 0x15, 0x54, 0x6f, 0x6f,
	0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x22, 0x93, 0x01, 0x0a, 0x14, 0x54, 0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x7b, 0x0a, 0x1d, 0x74, 0x6f,
	0x6f, 0x6c, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x19, 0x74, 0x6f,
	0x6f, 0x6c, 0x4e, 0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x44, 0x0a, 0x18, 0x54, 0x6f, 0x6f, 0x6c, 0x4e,
	0x61, 0x6d, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xd7, 0x01,
	0x0a, 0x1a, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b,
	0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5b, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5c, 0x0a, 0x09, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x1b, 0x0a, 0x19, 0x54, 0x6f, 0x6f, 0x6c, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x70, 0x65, 0x63, 0x22, 0x8e, 0x01, 0x0a, 0x1d, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48,
	0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x1c, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x52,
	0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x94, 0x01, 0x0a, 0x26, 0x74, 0x6f, 0x6f, 0x6c, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x21, 0x74, 0x6f, 0x6f, 0x6c,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65, 0x79, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x4c, 0x0a,
	0x20, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x65,
	0x79, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x19,
	0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d,
	0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x5a, 0x0a, 0x0b, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61, 0x74, 0x63, 0x68,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5b, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x22, 0x56, 0x0a, 0x18, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3a,
	0x0a, 0x17, 0x75, 0x73, 0x65, 0x5f, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x5f, 0x73, 0x74, 0x72,
	0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x75, 0x73, 0x65, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x22, 0x8d, 0x01, 0x0a, 0x1c, 0x54,
	0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x01, 0x52,
	0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a,
	0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x22, 0xb1, 0x01, 0x0a, 0x1b, 0x54,
	0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61,
	0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x25, 0x74,
	0x6f, 0x6f, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x6b, 0x76,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x56, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x20, 0x74, 0x6f,
	0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b, 0x76, 0x4d, 0x61, 0x74,
	0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x4b,
	0x0a, 0x1f, 0x54, 0x6f, 0x6f, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4b,
	0x56, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xa5, 0x01, 0x0a, 0x0a,
	0x43, 0x6f, 0x6d, 0x65, 0x74, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4b, 0x0a, 0x0b, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4a, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x22, 0x90, 0x02, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x53, 0x70, 0x65,
	0x63, 0x12, 0x56, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x65, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x22, 0x43, 0x0a, 0x0c, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x43, 0x4f, 0x4d, 0x45, 0x54, 0x5f, 0x56,
	0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x43, 0x4f, 0x4d, 0x45, 0x54, 0x5f, 0x32, 0x32,
	0x5f, 0x53, 0x52, 0x43, 0x5f, 0x52, 0x45, 0x46, 0x10, 0x02, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xab, 0x01, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x65, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88,
	0x01, 0x01, 0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48,
	0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b,
	0x5f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x22, 0x37, 0x0a, 0x0b, 0x43, 0x6f, 0x6d, 0x65, 0x74, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xab, 0x01,
	0x0a, 0x0c, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x12, 0x4d,
	0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x4c, 0x0a,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x78, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0xc4, 0x02, 0x0a, 0x0b,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x53, 0x70, 0x65, 0x63, 0x12, 0x5a, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x78, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4c, 0x61, 0x6e,
	0x67, 0x75, 0x61, 0x67, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x4c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x22, 0x71, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x58,
	0x5f, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49,
	0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43,
	0x58, 0x5f, 0x32, 0x34, 0x5f, 0x52, 0x45, 0x46, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4d, 0x45,
	0x54, 0x52, 0x49, 0x43, 0x58, 0x5f, 0x32, 0x34, 0x5f, 0x53, 0x52, 0x43, 0x10, 0x02, 0x12, 0x16,
	0x0a, 0x12, 0x4d, 0x45, 0x54, 0x52, 0x49, 0x43, 0x58, 0x5f, 0x32, 0x34, 0x5f, 0x53, 0x52, 0x43,
	0x5f, 0x52, 0x45, 0x46, 0x10, 0x03, 0x42, 0x0a, 0x0a, 0x08, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x22, 0xad, 0x01, 0x0a, 0x0f, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x28, 0x0a, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48,
	0x00, 0x52, 0x0a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x26, 0x0a, 0x09, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x09, 0x72, 0x65, 0x66, 0x65,
	0x72, 0x65, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x20, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x88, 0x01, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x5f, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x39, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x78, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x12, 0x1e, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65,
	0x88, 0x01, 0x01, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x2a, 0x57, 0x0a,
	0x0e, 0x50, 0x61, 0x69, 0x72, 0x77, 0x69, 0x73, 0x65, 0x43, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x12,
	0x1f, 0x0a, 0x1b, 0x50, 0x41, 0x49, 0x52, 0x57, 0x49, 0x53, 0x45, 0x5f, 0x43, 0x48, 0x4f, 0x49,
	0x43, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x0c, 0x0a, 0x08, 0x42, 0x41, 0x53, 0x45, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x41, 0x4e, 0x44, 0x49, 0x44, 0x41, 0x54, 0x45, 0x10, 0x02, 0x12, 0x07, 0x0a,
	0x03, 0x54, 0x49, 0x45, 0x10, 0x03, 0x32, 0xa9, 0x02, 0x0a, 0x11, 0x45, 0x76, 0x61, 0x6c, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc4, 0x01, 0x0a,
	0x11, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xd4, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x45, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a,
	0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa,
	0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescData = file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes = make([]protoimpl.MessageInfo, 109)
var file_google_cloud_aiplatform_v1_evaluation_service_proto_goTypes = []any{
	(PairwiseChoice)(0),                              // 0: google.cloud.aiplatform.v1.PairwiseChoice
	(CometSpec_CometVersion)(0),                      // 1: google.cloud.aiplatform.v1.CometSpec.CometVersion
	(MetricxSpec_MetricxVersion)(0),                  // 2: google.cloud.aiplatform.v1.MetricxSpec.MetricxVersion
	(*EvaluateInstancesRequest)(nil),                 // 3: google.cloud.aiplatform.v1.EvaluateInstancesRequest
	(*EvaluateInstancesResponse)(nil),                // 4: google.cloud.aiplatform.v1.EvaluateInstancesResponse
	(*ExactMatchInput)(nil),                          // 5: google.cloud.aiplatform.v1.ExactMatchInput
	(*ExactMatchInstance)(nil),                       // 6: google.cloud.aiplatform.v1.ExactMatchInstance
	(*ExactMatchSpec)(nil),                           // 7: google.cloud.aiplatform.v1.ExactMatchSpec
	(*ExactMatchResults)(nil),                        // 8: google.cloud.aiplatform.v1.ExactMatchResults
	(*ExactMatchMetricValue)(nil),                    // 9: google.cloud.aiplatform.v1.ExactMatchMetricValue
	(*BleuInput)(nil),                                // 10: google.cloud.aiplatform.v1.BleuInput
	(*BleuInstance)(nil),                             // 11: google.cloud.aiplatform.v1.BleuInstance
	(*BleuSpec)(nil),                                 // 12: google.cloud.aiplatform.v1.BleuSpec
	(*BleuResults)(nil),                              // 13: google.cloud.aiplatform.v1.BleuResults
	(*BleuMetricValue)(nil),                          // 14: google.cloud.aiplatform.v1.BleuMetricValue
	(*RougeInput)(nil),                               // 15: google.cloud.aiplatform.v1.RougeInput
	(*RougeInstance)(nil),                            // 16: google.cloud.aiplatform.v1.RougeInstance
	(*RougeSpec)(nil),                                // 17: google.cloud.aiplatform.v1.RougeSpec
	(*RougeResults)(nil),                             // 18: google.cloud.aiplatform.v1.RougeResults
	(*RougeMetricValue)(nil),                         // 19: google.cloud.aiplatform.v1.RougeMetricValue
	(*CoherenceInput)(nil),                           // 20: google.cloud.aiplatform.v1.CoherenceInput
	(*CoherenceInstance)(nil),                        // 21: google.cloud.aiplatform.v1.CoherenceInstance
	(*CoherenceSpec)(nil),                            // 22: google.cloud.aiplatform.v1.CoherenceSpec
	(*CoherenceResult)(nil),                          // 23: google.cloud.aiplatform.v1.CoherenceResult
	(*FluencyInput)(nil),                             // 24: google.cloud.aiplatform.v1.FluencyInput
	(*FluencyInstance)(nil),                          // 25: google.cloud.aiplatform.v1.FluencyInstance
	(*FluencySpec)(nil),                              // 26: google.cloud.aiplatform.v1.FluencySpec
	(*FluencyResult)(nil),                            // 27: google.cloud.aiplatform.v1.FluencyResult
	(*SafetyInput)(nil),                              // 28: google.cloud.aiplatform.v1.SafetyInput
	(*SafetyInstance)(nil),                           // 29: google.cloud.aiplatform.v1.SafetyInstance
	(*SafetySpec)(nil),                               // 30: google.cloud.aiplatform.v1.SafetySpec
	(*SafetyResult)(nil),                             // 31: google.cloud.aiplatform.v1.SafetyResult
	(*GroundednessInput)(nil),                        // 32: google.cloud.aiplatform.v1.GroundednessInput
	(*GroundednessInstance)(nil),                     // 33: google.cloud.aiplatform.v1.GroundednessInstance
	(*GroundednessSpec)(nil),                         // 34: google.cloud.aiplatform.v1.GroundednessSpec
	(*GroundednessResult)(nil),                       // 35: google.cloud.aiplatform.v1.GroundednessResult
	(*FulfillmentInput)(nil),                         // 36: google.cloud.aiplatform.v1.FulfillmentInput
	(*FulfillmentInstance)(nil),                      // 37: google.cloud.aiplatform.v1.FulfillmentInstance
	(*FulfillmentSpec)(nil),                          // 38: google.cloud.aiplatform.v1.FulfillmentSpec
	(*FulfillmentResult)(nil),                        // 39: google.cloud.aiplatform.v1.FulfillmentResult
	(*SummarizationQualityInput)(nil),                // 40: google.cloud.aiplatform.v1.SummarizationQualityInput
	(*SummarizationQualityInstance)(nil),             // 41: google.cloud.aiplatform.v1.SummarizationQualityInstance
	(*SummarizationQualitySpec)(nil),                 // 42: google.cloud.aiplatform.v1.SummarizationQualitySpec
	(*SummarizationQualityResult)(nil),               // 43: google.cloud.aiplatform.v1.SummarizationQualityResult
	(*PairwiseSummarizationQualityInput)(nil),        // 44: google.cloud.aiplatform.v1.PairwiseSummarizationQualityInput
	(*PairwiseSummarizationQualityInstance)(nil),     // 45: google.cloud.aiplatform.v1.PairwiseSummarizationQualityInstance
	(*PairwiseSummarizationQualitySpec)(nil),         // 46: google.cloud.aiplatform.v1.PairwiseSummarizationQualitySpec
	(*PairwiseSummarizationQualityResult)(nil),       // 47: google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
	(*SummarizationHelpfulnessInput)(nil),            // 48: google.cloud.aiplatform.v1.SummarizationHelpfulnessInput
	(*SummarizationHelpfulnessInstance)(nil),         // 49: google.cloud.aiplatform.v1.SummarizationHelpfulnessInstance
	(*SummarizationHelpfulnessSpec)(nil),             // 50: google.cloud.aiplatform.v1.SummarizationHelpfulnessSpec
	(*SummarizationHelpfulnessResult)(nil),           // 51: google.cloud.aiplatform.v1.SummarizationHelpfulnessResult
	(*SummarizationVerbosityInput)(nil),              // 52: google.cloud.aiplatform.v1.SummarizationVerbosityInput
	(*SummarizationVerbosityInstance)(nil),           // 53: google.cloud.aiplatform.v1.SummarizationVerbosityInstance
	(*SummarizationVerbositySpec)(nil),               // 54: google.cloud.aiplatform.v1.SummarizationVerbositySpec
	(*SummarizationVerbosityResult)(nil),             // 55: google.cloud.aiplatform.v1.SummarizationVerbosityResult
	(*QuestionAnsweringQualityInput)(nil),            // 56: google.cloud.aiplatform.v1.QuestionAnsweringQualityInput
	(*QuestionAnsweringQualityInstance)(nil),         // 57: google.cloud.aiplatform.v1.QuestionAnsweringQualityInstance
	(*QuestionAnsweringQualitySpec)(nil),             // 58: google.cloud.aiplatform.v1.QuestionAnsweringQualitySpec
	(*QuestionAnsweringQualityResult)(nil),           // 59: google.cloud.aiplatform.v1.QuestionAnsweringQualityResult
	(*PairwiseQuestionAnsweringQualityInput)(nil),    // 60: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityInput
	(*PairwiseQuestionAnsweringQualityInstance)(nil), // 61: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityInstance
	(*PairwiseQuestionAnsweringQualitySpec)(nil),     // 62: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualitySpec
	(*PairwiseQuestionAnsweringQualityResult)(nil),   // 63: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
	(*QuestionAnsweringRelevanceInput)(nil),          // 64: google.cloud.aiplatform.v1.QuestionAnsweringRelevanceInput
	(*QuestionAnsweringRelevanceInstance)(nil),       // 65: google.cloud.aiplatform.v1.QuestionAnsweringRelevanceInstance
	(*QuestionAnsweringRelevanceSpec)(nil),           // 66: google.cloud.aiplatform.v1.QuestionAnsweringRelevanceSpec
	(*QuestionAnsweringRelevanceResult)(nil),         // 67: google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult
	(*QuestionAnsweringHelpfulnessInput)(nil),        // 68: google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessInput
	(*QuestionAnsweringHelpfulnessInstance)(nil),     // 69: google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessInstance
	(*QuestionAnsweringHelpfulnessSpec)(nil),         // 70: google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessSpec
	(*QuestionAnsweringHelpfulnessResult)(nil),       // 71: google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
	(*QuestionAnsweringCorrectnessInput)(nil),        // 72: google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessInput
	(*QuestionAnsweringCorrectnessInstance)(nil),     // 73: google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessInstance
	(*QuestionAnsweringCorrectnessSpec)(nil),         // 74: google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessSpec
	(*QuestionAnsweringCorrectnessResult)(nil),       // 75: google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
	(*PointwiseMetricInput)(nil),                     // 76: google.cloud.aiplatform.v1.PointwiseMetricInput
	(*PointwiseMetricInstance)(nil),                  // 77: google.cloud.aiplatform.v1.PointwiseMetricInstance
	(*PointwiseMetricSpec)(nil),                      // 78: google.cloud.aiplatform.v1.PointwiseMetricSpec
	(*PointwiseMetricResult)(nil),                    // 79: google.cloud.aiplatform.v1.PointwiseMetricResult
	(*PairwiseMetricInput)(nil),                      // 80: google.cloud.aiplatform.v1.PairwiseMetricInput
	(*PairwiseMetricInstance)(nil),                   // 81: google.cloud.aiplatform.v1.PairwiseMetricInstance
	(*PairwiseMetricSpec)(nil),                       // 82: google.cloud.aiplatform.v1.PairwiseMetricSpec
	(*PairwiseMetricResult)(nil),                     // 83: google.cloud.aiplatform.v1.PairwiseMetricResult
	(*ToolCallValidInput)(nil),                       // 84: google.cloud.aiplatform.v1.ToolCallValidInput
	(*ToolCallValidSpec)(nil),                        // 85: google.cloud.aiplatform.v1.ToolCallValidSpec
	(*ToolCallValidInstance)(nil),                    // 86: google.cloud.aiplatform.v1.ToolCallValidInstance
	(*ToolCallValidResults)(nil),                     // 87: google.cloud.aiplatform.v1.ToolCallValidResults
	(*ToolCallValidMetricValue)(nil),                 // 88: google.cloud.aiplatform.v1.ToolCallValidMetricValue
	(*ToolNameMatchInput)(nil),                       // 89: google.cloud.aiplatform.v1.ToolNameMatchInput
	(*ToolNameMatchSpec)(nil),                        // 90: google.cloud.aiplatform.v1.ToolNameMatchSpec
	(*ToolNameMatchInstance)(nil),                    // 91: google.cloud.aiplatform.v1.ToolNameMatchInstance
	(*ToolNameMatchResults)(nil),                     // 92: google.cloud.aiplatform.v1.ToolNameMatchResults
	(*ToolNameMatchMetricValue)(nil),                 // 93: google.cloud.aiplatform.v1.ToolNameMatchMetricValue
	(*ToolParameterKeyMatchInput)(nil),               // 94: google.cloud.aiplatform.v1.ToolParameterKeyMatchInput
	(*ToolParameterKeyMatchSpec)(nil),                // 95: google.cloud.aiplatform.v1.ToolParameterKeyMatchSpec
	(*ToolParameterKeyMatchInstance)(nil),            // 96: google.cloud.aiplatform.v1.ToolParameterKeyMatchInstance
	(*ToolParameterKeyMatchResults)(nil),             // 97: google.cloud.aiplatform.v1.ToolParameterKeyMatchResults
	(*ToolParameterKeyMatchMetricValue)(nil),         // 98: google.cloud.aiplatform.v1.ToolParameterKeyMatchMetricValue
	(*ToolParameterKVMatchInput)(nil),                // 99: google.cloud.aiplatform.v1.ToolParameterKVMatchInput
	(*ToolParameterKVMatchSpec)(nil),                 // 100: google.cloud.aiplatform.v1.ToolParameterKVMatchSpec
	(*ToolParameterKVMatchInstance)(nil),             // 101: google.cloud.aiplatform.v1.ToolParameterKVMatchInstance
	(*ToolParameterKVMatchResults)(nil),              // 102: google.cloud.aiplatform.v1.ToolParameterKVMatchResults
	(*ToolParameterKVMatchMetricValue)(nil),          // 103: google.cloud.aiplatform.v1.ToolParameterKVMatchMetricValue
	(*CometInput)(nil),                               // 104: google.cloud.aiplatform.v1.CometInput
	(*CometSpec)(nil),                                // 105: google.cloud.aiplatform.v1.CometSpec
	(*CometInstance)(nil),                            // 106: google.cloud.aiplatform.v1.CometInstance
	(*CometResult)(nil),                              // 107: google.cloud.aiplatform.v1.CometResult
	(*MetricxInput)(nil),                             // 108: google.cloud.aiplatform.v1.MetricxInput
	(*MetricxSpec)(nil),                              // 109: google.cloud.aiplatform.v1.MetricxSpec
	(*MetricxInstance)(nil),                          // 110: google.cloud.aiplatform.v1.MetricxInstance
	(*MetricxResult)(nil),                            // 111: google.cloud.aiplatform.v1.MetricxResult
}
var file_google_cloud_aiplatform_v1_evaluation_service_proto_depIdxs = []int32{
	5,   // 0: google.cloud.aiplatform.v1.EvaluateInstancesRequest.exact_match_input:type_name -> google.cloud.aiplatform.v1.ExactMatchInput
	10,  // 1: google.cloud.aiplatform.v1.EvaluateInstancesRequest.bleu_input:type_name -> google.cloud.aiplatform.v1.BleuInput
	15,  // 2: google.cloud.aiplatform.v1.EvaluateInstancesRequest.rouge_input:type_name -> google.cloud.aiplatform.v1.RougeInput
	24,  // 3: google.cloud.aiplatform.v1.EvaluateInstancesRequest.fluency_input:type_name -> google.cloud.aiplatform.v1.FluencyInput
	20,  // 4: google.cloud.aiplatform.v1.EvaluateInstancesRequest.coherence_input:type_name -> google.cloud.aiplatform.v1.CoherenceInput
	28,  // 5: google.cloud.aiplatform.v1.EvaluateInstancesRequest.safety_input:type_name -> google.cloud.aiplatform.v1.SafetyInput
	32,  // 6: google.cloud.aiplatform.v1.EvaluateInstancesRequest.groundedness_input:type_name -> google.cloud.aiplatform.v1.GroundednessInput
	36,  // 7: google.cloud.aiplatform.v1.EvaluateInstancesRequest.fulfillment_input:type_name -> google.cloud.aiplatform.v1.FulfillmentInput
	40,  // 8: google.cloud.aiplatform.v1.EvaluateInstancesRequest.summarization_quality_input:type_name -> google.cloud.aiplatform.v1.SummarizationQualityInput
	44,  // 9: google.cloud.aiplatform.v1.EvaluateInstancesRequest.pairwise_summarization_quality_input:type_name -> google.cloud.aiplatform.v1.PairwiseSummarizationQualityInput
	48,  // 10: google.cloud.aiplatform.v1.EvaluateInstancesRequest.summarization_helpfulness_input:type_name -> google.cloud.aiplatform.v1.SummarizationHelpfulnessInput
	52,  // 11: google.cloud.aiplatform.v1.EvaluateInstancesRequest.summarization_verbosity_input:type_name -> google.cloud.aiplatform.v1.SummarizationVerbosityInput
	56,  // 12: google.cloud.aiplatform.v1.EvaluateInstancesRequest.question_answering_quality_input:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringQualityInput
	60,  // 13: google.cloud.aiplatform.v1.EvaluateInstancesRequest.pairwise_question_answering_quality_input:type_name -> google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityInput
	64,  // 14: google.cloud.aiplatform.v1.EvaluateInstancesRequest.question_answering_relevance_input:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringRelevanceInput
	68,  // 15: google.cloud.aiplatform.v1.EvaluateInstancesRequest.question_answering_helpfulness_input:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessInput
	72,  // 16: google.cloud.aiplatform.v1.EvaluateInstancesRequest.question_answering_correctness_input:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessInput
	76,  // 17: google.cloud.aiplatform.v1.EvaluateInstancesRequest.pointwise_metric_input:type_name -> google.cloud.aiplatform.v1.PointwiseMetricInput
	80,  // 18: google.cloud.aiplatform.v1.EvaluateInstancesRequest.pairwise_metric_input:type_name -> google.cloud.aiplatform.v1.PairwiseMetricInput
	84,  // 19: google.cloud.aiplatform.v1.EvaluateInstancesRequest.tool_call_valid_input:type_name -> google.cloud.aiplatform.v1.ToolCallValidInput
	89,  // 20: google.cloud.aiplatform.v1.EvaluateInstancesRequest.tool_name_match_input:type_name -> google.cloud.aiplatform.v1.ToolNameMatchInput
	94,  // 21: google.cloud.aiplatform.v1.EvaluateInstancesRequest.tool_parameter_key_match_input:type_name -> google.cloud.aiplatform.v1.ToolParameterKeyMatchInput
	99,  // 22: google.cloud.aiplatform.v1.EvaluateInstancesRequest.tool_parameter_kv_match_input:type_name -> google.cloud.aiplatform.v1.ToolParameterKVMatchInput
	104, // 23: google.cloud.aiplatform.v1.EvaluateInstancesRequest.comet_input:type_name -> google.cloud.aiplatform.v1.CometInput
	108, // 24: google.cloud.aiplatform.v1.EvaluateInstancesRequest.metricx_input:type_name -> google.cloud.aiplatform.v1.MetricxInput
	8,   // 25: google.cloud.aiplatform.v1.EvaluateInstancesResponse.exact_match_results:type_name -> google.cloud.aiplatform.v1.ExactMatchResults
	13,  // 26: google.cloud.aiplatform.v1.EvaluateInstancesResponse.bleu_results:type_name -> google.cloud.aiplatform.v1.BleuResults
	18,  // 27: google.cloud.aiplatform.v1.EvaluateInstancesResponse.rouge_results:type_name -> google.cloud.aiplatform.v1.RougeResults
	27,  // 28: google.cloud.aiplatform.v1.EvaluateInstancesResponse.fluency_result:type_name -> google.cloud.aiplatform.v1.FluencyResult
	23,  // 29: google.cloud.aiplatform.v1.EvaluateInstancesResponse.coherence_result:type_name -> google.cloud.aiplatform.v1.CoherenceResult
	31,  // 30: google.cloud.aiplatform.v1.EvaluateInstancesResponse.safety_result:type_name -> google.cloud.aiplatform.v1.SafetyResult
	35,  // 31: google.cloud.aiplatform.v1.EvaluateInstancesResponse.groundedness_result:type_name -> google.cloud.aiplatform.v1.GroundednessResult
	39,  // 32: google.cloud.aiplatform.v1.EvaluateInstancesResponse.fulfillment_result:type_name -> google.cloud.aiplatform.v1.FulfillmentResult
	43,  // 33: google.cloud.aiplatform.v1.EvaluateInstancesResponse.summarization_quality_result:type_name -> google.cloud.aiplatform.v1.SummarizationQualityResult
	47,  // 34: google.cloud.aiplatform.v1.EvaluateInstancesResponse.pairwise_summarization_quality_result:type_name -> google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult
	51,  // 35: google.cloud.aiplatform.v1.EvaluateInstancesResponse.summarization_helpfulness_result:type_name -> google.cloud.aiplatform.v1.SummarizationHelpfulnessResult
	55,  // 36: google.cloud.aiplatform.v1.EvaluateInstancesResponse.summarization_verbosity_result:type_name -> google.cloud.aiplatform.v1.SummarizationVerbosityResult
	59,  // 37: google.cloud.aiplatform.v1.EvaluateInstancesResponse.question_answering_quality_result:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringQualityResult
	63,  // 38: google.cloud.aiplatform.v1.EvaluateInstancesResponse.pairwise_question_answering_quality_result:type_name -> google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult
	67,  // 39: google.cloud.aiplatform.v1.EvaluateInstancesResponse.question_answering_relevance_result:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringRelevanceResult
	71,  // 40: google.cloud.aiplatform.v1.EvaluateInstancesResponse.question_answering_helpfulness_result:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessResult
	75,  // 41: google.cloud.aiplatform.v1.EvaluateInstancesResponse.question_answering_correctness_result:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessResult
	79,  // 42: google.cloud.aiplatform.v1.EvaluateInstancesResponse.pointwise_metric_result:type_name -> google.cloud.aiplatform.v1.PointwiseMetricResult
	83,  // 43: google.cloud.aiplatform.v1.EvaluateInstancesResponse.pairwise_metric_result:type_name -> google.cloud.aiplatform.v1.PairwiseMetricResult
	87,  // 44: google.cloud.aiplatform.v1.EvaluateInstancesResponse.tool_call_valid_results:type_name -> google.cloud.aiplatform.v1.ToolCallValidResults
	92,  // 45: google.cloud.aiplatform.v1.EvaluateInstancesResponse.tool_name_match_results:type_name -> google.cloud.aiplatform.v1.ToolNameMatchResults
	97,  // 46: google.cloud.aiplatform.v1.EvaluateInstancesResponse.tool_parameter_key_match_results:type_name -> google.cloud.aiplatform.v1.ToolParameterKeyMatchResults
	102, // 47: google.cloud.aiplatform.v1.EvaluateInstancesResponse.tool_parameter_kv_match_results:type_name -> google.cloud.aiplatform.v1.ToolParameterKVMatchResults
	107, // 48: google.cloud.aiplatform.v1.EvaluateInstancesResponse.comet_result:type_name -> google.cloud.aiplatform.v1.CometResult
	111, // 49: google.cloud.aiplatform.v1.EvaluateInstancesResponse.metricx_result:type_name -> google.cloud.aiplatform.v1.MetricxResult
	7,   // 50: google.cloud.aiplatform.v1.ExactMatchInput.metric_spec:type_name -> google.cloud.aiplatform.v1.ExactMatchSpec
	6,   // 51: google.cloud.aiplatform.v1.ExactMatchInput.instances:type_name -> google.cloud.aiplatform.v1.ExactMatchInstance
	9,   // 52: google.cloud.aiplatform.v1.ExactMatchResults.exact_match_metric_values:type_name -> google.cloud.aiplatform.v1.ExactMatchMetricValue
	12,  // 53: google.cloud.aiplatform.v1.BleuInput.metric_spec:type_name -> google.cloud.aiplatform.v1.BleuSpec
	11,  // 54: google.cloud.aiplatform.v1.BleuInput.instances:type_name -> google.cloud.aiplatform.v1.BleuInstance
	14,  // 55: google.cloud.aiplatform.v1.BleuResults.bleu_metric_values:type_name -> google.cloud.aiplatform.v1.BleuMetricValue
	17,  // 56: google.cloud.aiplatform.v1.RougeInput.metric_spec:type_name -> google.cloud.aiplatform.v1.RougeSpec
	16,  // 57: google.cloud.aiplatform.v1.RougeInput.instances:type_name -> google.cloud.aiplatform.v1.RougeInstance
	19,  // 58: google.cloud.aiplatform.v1.RougeResults.rouge_metric_values:type_name -> google.cloud.aiplatform.v1.RougeMetricValue
	22,  // 59: google.cloud.aiplatform.v1.CoherenceInput.metric_spec:type_name -> google.cloud.aiplatform.v1.CoherenceSpec
	21,  // 60: google.cloud.aiplatform.v1.CoherenceInput.instance:type_name -> google.cloud.aiplatform.v1.CoherenceInstance
	26,  // 61: google.cloud.aiplatform.v1.FluencyInput.metric_spec:type_name -> google.cloud.aiplatform.v1.FluencySpec
	25,  // 62: google.cloud.aiplatform.v1.FluencyInput.instance:type_name -> google.cloud.aiplatform.v1.FluencyInstance
	30,  // 63: google.cloud.aiplatform.v1.SafetyInput.metric_spec:type_name -> google.cloud.aiplatform.v1.SafetySpec
	29,  // 64: google.cloud.aiplatform.v1.SafetyInput.instance:type_name -> google.cloud.aiplatform.v1.SafetyInstance
	34,  // 65: google.cloud.aiplatform.v1.GroundednessInput.metric_spec:type_name -> google.cloud.aiplatform.v1.GroundednessSpec
	33,  // 66: google.cloud.aiplatform.v1.GroundednessInput.instance:type_name -> google.cloud.aiplatform.v1.GroundednessInstance
	38,  // 67: google.cloud.aiplatform.v1.FulfillmentInput.metric_spec:type_name -> google.cloud.aiplatform.v1.FulfillmentSpec
	37,  // 68: google.cloud.aiplatform.v1.FulfillmentInput.instance:type_name -> google.cloud.aiplatform.v1.FulfillmentInstance
	42,  // 69: google.cloud.aiplatform.v1.SummarizationQualityInput.metric_spec:type_name -> google.cloud.aiplatform.v1.SummarizationQualitySpec
	41,  // 70: google.cloud.aiplatform.v1.SummarizationQualityInput.instance:type_name -> google.cloud.aiplatform.v1.SummarizationQualityInstance
	46,  // 71: google.cloud.aiplatform.v1.PairwiseSummarizationQualityInput.metric_spec:type_name -> google.cloud.aiplatform.v1.PairwiseSummarizationQualitySpec
	45,  // 72: google.cloud.aiplatform.v1.PairwiseSummarizationQualityInput.instance:type_name -> google.cloud.aiplatform.v1.PairwiseSummarizationQualityInstance
	0,   // 73: google.cloud.aiplatform.v1.PairwiseSummarizationQualityResult.pairwise_choice:type_name -> google.cloud.aiplatform.v1.PairwiseChoice
	50,  // 74: google.cloud.aiplatform.v1.SummarizationHelpfulnessInput.metric_spec:type_name -> google.cloud.aiplatform.v1.SummarizationHelpfulnessSpec
	49,  // 75: google.cloud.aiplatform.v1.SummarizationHelpfulnessInput.instance:type_name -> google.cloud.aiplatform.v1.SummarizationHelpfulnessInstance
	54,  // 76: google.cloud.aiplatform.v1.SummarizationVerbosityInput.metric_spec:type_name -> google.cloud.aiplatform.v1.SummarizationVerbositySpec
	53,  // 77: google.cloud.aiplatform.v1.SummarizationVerbosityInput.instance:type_name -> google.cloud.aiplatform.v1.SummarizationVerbosityInstance
	58,  // 78: google.cloud.aiplatform.v1.QuestionAnsweringQualityInput.metric_spec:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringQualitySpec
	57,  // 79: google.cloud.aiplatform.v1.QuestionAnsweringQualityInput.instance:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringQualityInstance
	62,  // 80: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityInput.metric_spec:type_name -> google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualitySpec
	61,  // 81: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityInput.instance:type_name -> google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityInstance
	0,   // 82: google.cloud.aiplatform.v1.PairwiseQuestionAnsweringQualityResult.pairwise_choice:type_name -> google.cloud.aiplatform.v1.PairwiseChoice
	66,  // 83: google.cloud.aiplatform.v1.QuestionAnsweringRelevanceInput.metric_spec:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringRelevanceSpec
	65,  // 84: google.cloud.aiplatform.v1.QuestionAnsweringRelevanceInput.instance:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringRelevanceInstance
	70,  // 85: google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessInput.metric_spec:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessSpec
	69,  // 86: google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessInput.instance:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringHelpfulnessInstance
	74,  // 87: google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessInput.metric_spec:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessSpec
	73,  // 88: google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessInput.instance:type_name -> google.cloud.aiplatform.v1.QuestionAnsweringCorrectnessInstance
	78,  // 89: google.cloud.aiplatform.v1.PointwiseMetricInput.metric_spec:type_name -> google.cloud.aiplatform.v1.PointwiseMetricSpec
	77,  // 90: google.cloud.aiplatform.v1.PointwiseMetricInput.instance:type_name -> google.cloud.aiplatform.v1.PointwiseMetricInstance
	82,  // 91: google.cloud.aiplatform.v1.PairwiseMetricInput.metric_spec:type_name -> google.cloud.aiplatform.v1.PairwiseMetricSpec
	81,  // 92: google.cloud.aiplatform.v1.PairwiseMetricInput.instance:type_name -> google.cloud.aiplatform.v1.PairwiseMetricInstance
	0,   // 93: google.cloud.aiplatform.v1.PairwiseMetricResult.pairwise_choice:type_name -> google.cloud.aiplatform.v1.PairwiseChoice
	85,  // 94: google.cloud.aiplatform.v1.ToolCallValidInput.metric_spec:type_name -> google.cloud.aiplatform.v1.ToolCallValidSpec
	86,  // 95: google.cloud.aiplatform.v1.ToolCallValidInput.instances:type_name -> google.cloud.aiplatform.v1.ToolCallValidInstance
	88,  // 96: google.cloud.aiplatform.v1.ToolCallValidResults.tool_call_valid_metric_values:type_name -> google.cloud.aiplatform.v1.ToolCallValidMetricValue
	90,  // 97: google.cloud.aiplatform.v1.ToolNameMatchInput.metric_spec:type_name -> google.cloud.aiplatform.v1.ToolNameMatchSpec
	91,  // 98: google.cloud.aiplatform.v1.ToolNameMatchInput.instances:type_name -> google.cloud.aiplatform.v1.ToolNameMatchInstance
	93,  // 99: google.cloud.aiplatform.v1.ToolNameMatchResults.tool_name_match_metric_values:type_name -> google.cloud.aiplatform.v1.ToolNameMatchMetricValue
	95,  // 100: google.cloud.aiplatform.v1.ToolParameterKeyMatchInput.metric_spec:type_name -> google.cloud.aiplatform.v1.ToolParameterKeyMatchSpec
	96,  // 101: google.cloud.aiplatform.v1.ToolParameterKeyMatchInput.instances:type_name -> google.cloud.aiplatform.v1.ToolParameterKeyMatchInstance
	98,  // 102: google.cloud.aiplatform.v1.ToolParameterKeyMatchResults.tool_parameter_key_match_metric_values:type_name -> google.cloud.aiplatform.v1.ToolParameterKeyMatchMetricValue
	100, // 103: google.cloud.aiplatform.v1.ToolParameterKVMatchInput.metric_spec:type_name -> google.cloud.aiplatform.v1.ToolParameterKVMatchSpec
	101, // 104: google.cloud.aiplatform.v1.ToolParameterKVMatchInput.instances:type_name -> google.cloud.aiplatform.v1.ToolParameterKVMatchInstance
	103, // 105: google.cloud.aiplatform.v1.ToolParameterKVMatchResults.tool_parameter_kv_match_metric_values:type_name -> google.cloud.aiplatform.v1.ToolParameterKVMatchMetricValue
	105, // 106: google.cloud.aiplatform.v1.CometInput.metric_spec:type_name -> google.cloud.aiplatform.v1.CometSpec
	106, // 107: google.cloud.aiplatform.v1.CometInput.instance:type_name -> google.cloud.aiplatform.v1.CometInstance
	1,   // 108: google.cloud.aiplatform.v1.CometSpec.version:type_name -> google.cloud.aiplatform.v1.CometSpec.CometVersion
	109, // 109: google.cloud.aiplatform.v1.MetricxInput.metric_spec:type_name -> google.cloud.aiplatform.v1.MetricxSpec
	110, // 110: google.cloud.aiplatform.v1.MetricxInput.instance:type_name -> google.cloud.aiplatform.v1.MetricxInstance
	2,   // 111: google.cloud.aiplatform.v1.MetricxSpec.version:type_name -> google.cloud.aiplatform.v1.MetricxSpec.MetricxVersion
	3,   // 112: google.cloud.aiplatform.v1.EvaluationService.EvaluateInstances:input_type -> google.cloud.aiplatform.v1.EvaluateInstancesRequest
	4,   // 113: google.cloud.aiplatform.v1.EvaluationService.EvaluateInstances:output_type -> google.cloud.aiplatform.v1.EvaluateInstancesResponse
	113, // [113:114] is the sub-list for method output_type
	112, // [112:113] is the sub-list for method input_type
	112, // [112:112] is the sub-list for extension type_name
	112, // [112:112] is the sub-list for extension extendee
	0,   // [0:112] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_evaluation_service_proto_init() }
func file_google_cloud_aiplatform_v1_evaluation_service_proto_init() {
	if File_google_cloud_aiplatform_v1_evaluation_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[0].OneofWrappers = []any{
		(*EvaluateInstancesRequest_ExactMatchInput)(nil),
		(*EvaluateInstancesRequest_BleuInput)(nil),
		(*EvaluateInstancesRequest_RougeInput)(nil),
		(*EvaluateInstancesRequest_FluencyInput)(nil),
		(*EvaluateInstancesRequest_CoherenceInput)(nil),
		(*EvaluateInstancesRequest_SafetyInput)(nil),
		(*EvaluateInstancesRequest_GroundednessInput)(nil),
		(*EvaluateInstancesRequest_FulfillmentInput)(nil),
		(*EvaluateInstancesRequest_SummarizationQualityInput)(nil),
		(*EvaluateInstancesRequest_PairwiseSummarizationQualityInput)(nil),
		(*EvaluateInstancesRequest_SummarizationHelpfulnessInput)(nil),
		(*EvaluateInstancesRequest_SummarizationVerbosityInput)(nil),
		(*EvaluateInstancesRequest_QuestionAnsweringQualityInput)(nil),
		(*EvaluateInstancesRequest_PairwiseQuestionAnsweringQualityInput)(nil),
		(*EvaluateInstancesRequest_QuestionAnsweringRelevanceInput)(nil),
		(*EvaluateInstancesRequest_QuestionAnsweringHelpfulnessInput)(nil),
		(*EvaluateInstancesRequest_QuestionAnsweringCorrectnessInput)(nil),
		(*EvaluateInstancesRequest_PointwiseMetricInput)(nil),
		(*EvaluateInstancesRequest_PairwiseMetricInput)(nil),
		(*EvaluateInstancesRequest_ToolCallValidInput)(nil),
		(*EvaluateInstancesRequest_ToolNameMatchInput)(nil),
		(*EvaluateInstancesRequest_ToolParameterKeyMatchInput)(nil),
		(*EvaluateInstancesRequest_ToolParameterKvMatchInput)(nil),
		(*EvaluateInstancesRequest_CometInput)(nil),
		(*EvaluateInstancesRequest_MetricxInput)(nil),
	}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[1].OneofWrappers = []any{
		(*EvaluateInstancesResponse_ExactMatchResults)(nil),
		(*EvaluateInstancesResponse_BleuResults)(nil),
		(*EvaluateInstancesResponse_RougeResults)(nil),
		(*EvaluateInstancesResponse_FluencyResult)(nil),
		(*EvaluateInstancesResponse_CoherenceResult)(nil),
		(*EvaluateInstancesResponse_SafetyResult)(nil),
		(*EvaluateInstancesResponse_GroundednessResult)(nil),
		(*EvaluateInstancesResponse_FulfillmentResult)(nil),
		(*EvaluateInstancesResponse_SummarizationQualityResult)(nil),
		(*EvaluateInstancesResponse_PairwiseSummarizationQualityResult)(nil),
		(*EvaluateInstancesResponse_SummarizationHelpfulnessResult)(nil),
		(*EvaluateInstancesResponse_SummarizationVerbosityResult)(nil),
		(*EvaluateInstancesResponse_QuestionAnsweringQualityResult)(nil),
		(*EvaluateInstancesResponse_PairwiseQuestionAnsweringQualityResult)(nil),
		(*EvaluateInstancesResponse_QuestionAnsweringRelevanceResult)(nil),
		(*EvaluateInstancesResponse_QuestionAnsweringHelpfulnessResult)(nil),
		(*EvaluateInstancesResponse_QuestionAnsweringCorrectnessResult)(nil),
		(*EvaluateInstancesResponse_PointwiseMetricResult)(nil),
		(*EvaluateInstancesResponse_PairwiseMetricResult)(nil),
		(*EvaluateInstancesResponse_ToolCallValidResults)(nil),
		(*EvaluateInstancesResponse_ToolNameMatchResults)(nil),
		(*EvaluateInstancesResponse_ToolParameterKeyMatchResults)(nil),
		(*EvaluateInstancesResponse_ToolParameterKvMatchResults)(nil),
		(*EvaluateInstancesResponse_CometResult)(nil),
		(*EvaluateInstancesResponse_MetricxResult)(nil),
	}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[3].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[6].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[8].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[11].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[13].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[16].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[18].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[20].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[22].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[24].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[26].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[28].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[30].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[32].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[34].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[36].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[38].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[40].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[42].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[44].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[46].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[48].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[50].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[52].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[54].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[56].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[58].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[60].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[62].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[64].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[66].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[68].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[70].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[72].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[74].OneofWrappers = []any{
		(*PointwiseMetricInstance_JsonInstance)(nil),
	}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[75].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[76].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[78].OneofWrappers = []any{
		(*PairwiseMetricInstance_JsonInstance)(nil),
	}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[79].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[83].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[85].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[88].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[90].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[93].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[95].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[98].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[100].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[102].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[103].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[104].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[106].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[107].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes[108].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   109,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_evaluation_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_evaluation_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_evaluation_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_evaluation_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_evaluation_service_proto = out.File
	file_google_cloud_aiplatform_v1_evaluation_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_evaluation_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_evaluation_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// EvaluationServiceClient is the client API for EvaluationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EvaluationServiceClient interface {
	// Evaluates instances based on a given metric.
	EvaluateInstances(ctx context.Context, in *EvaluateInstancesRequest, opts ...grpc.CallOption) (*EvaluateInstancesResponse, error)
}

type evaluationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEvaluationServiceClient(cc grpc.ClientConnInterface) EvaluationServiceClient {
	return &evaluationServiceClient{cc}
}

func (c *evaluationServiceClient) EvaluateInstances(ctx context.Context, in *EvaluateInstancesRequest, opts ...grpc.CallOption) (*EvaluateInstancesResponse, error) {
	out := new(EvaluateInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.EvaluationService/EvaluateInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EvaluationServiceServer is the server API for EvaluationService service.
type EvaluationServiceServer interface {
	// Evaluates instances based on a given metric.
	EvaluateInstances(context.Context, *EvaluateInstancesRequest) (*EvaluateInstancesResponse, error)
}

// UnimplementedEvaluationServiceServer can be embedded to have forward compatible implementations.
type UnimplementedEvaluationServiceServer struct {
}

func (*UnimplementedEvaluationServiceServer) EvaluateInstances(context.Context, *EvaluateInstancesRequest) (*EvaluateInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EvaluateInstances not implemented")
}

func RegisterEvaluationServiceServer(s *grpc.Server, srv EvaluationServiceServer) {
	s.RegisterService(&_EvaluationService_serviceDesc, srv)
}

func _EvaluationService_EvaluateInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EvaluateInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EvaluationServiceServer).EvaluateInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.EvaluationService/EvaluateInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EvaluationServiceServer).EvaluateInstances(ctx, req.(*EvaluateInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EvaluationService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.EvaluationService",
	HandlerType: (*EvaluationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "EvaluateInstances",
			Handler:    _EvaluationService_EvaluateInstances_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/evaluation_service.proto",
}
