// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/aiplatform/v1/dataset_service.proto

package aiplatformpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	DatasetService_CreateDataset_FullMethodName         = "/google.cloud.aiplatform.v1.DatasetService/CreateDataset"
	DatasetService_GetDataset_FullMethodName            = "/google.cloud.aiplatform.v1.DatasetService/GetDataset"
	DatasetService_UpdateDataset_FullMethodName         = "/google.cloud.aiplatform.v1.DatasetService/UpdateDataset"
	DatasetService_ListDatasets_FullMethodName          = "/google.cloud.aiplatform.v1.DatasetService/ListDatasets"
	DatasetService_DeleteDataset_FullMethodName         = "/google.cloud.aiplatform.v1.DatasetService/DeleteDataset"
	DatasetService_ImportData_FullMethodName            = "/google.cloud.aiplatform.v1.DatasetService/ImportData"
	DatasetService_ExportData_FullMethodName            = "/google.cloud.aiplatform.v1.DatasetService/ExportData"
	DatasetService_CreateDatasetVersion_FullMethodName  = "/google.cloud.aiplatform.v1.DatasetService/CreateDatasetVersion"
	DatasetService_UpdateDatasetVersion_FullMethodName  = "/google.cloud.aiplatform.v1.DatasetService/UpdateDatasetVersion"
	DatasetService_DeleteDatasetVersion_FullMethodName  = "/google.cloud.aiplatform.v1.DatasetService/DeleteDatasetVersion"
	DatasetService_GetDatasetVersion_FullMethodName     = "/google.cloud.aiplatform.v1.DatasetService/GetDatasetVersion"
	DatasetService_ListDatasetVersions_FullMethodName   = "/google.cloud.aiplatform.v1.DatasetService/ListDatasetVersions"
	DatasetService_RestoreDatasetVersion_FullMethodName = "/google.cloud.aiplatform.v1.DatasetService/RestoreDatasetVersion"
	DatasetService_ListDataItems_FullMethodName         = "/google.cloud.aiplatform.v1.DatasetService/ListDataItems"
	DatasetService_SearchDataItems_FullMethodName       = "/google.cloud.aiplatform.v1.DatasetService/SearchDataItems"
	DatasetService_ListSavedQueries_FullMethodName      = "/google.cloud.aiplatform.v1.DatasetService/ListSavedQueries"
	DatasetService_DeleteSavedQuery_FullMethodName      = "/google.cloud.aiplatform.v1.DatasetService/DeleteSavedQuery"
	DatasetService_GetAnnotationSpec_FullMethodName     = "/google.cloud.aiplatform.v1.DatasetService/GetAnnotationSpec"
	DatasetService_ListAnnotations_FullMethodName       = "/google.cloud.aiplatform.v1.DatasetService/ListAnnotations"
)

// DatasetServiceClient is the client API for DatasetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DatasetServiceClient interface {
	// Creates a Dataset.
	CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Dataset.
	GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Updates a Dataset.
	UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error)
	// Lists Datasets in a Location.
	ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error)
	// Deletes a Dataset.
	DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports data into a Dataset.
	ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Exports data from a Dataset.
	ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Create a version from a Dataset.
	CreateDatasetVersion(ctx context.Context, in *CreateDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a DatasetVersion.
	UpdateDatasetVersion(ctx context.Context, in *UpdateDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error)
	// Deletes a Dataset version.
	DeleteDatasetVersion(ctx context.Context, in *DeleteDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a Dataset version.
	GetDatasetVersion(ctx context.Context, in *GetDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error)
	// Lists DatasetVersions in a Dataset.
	ListDatasetVersions(ctx context.Context, in *ListDatasetVersionsRequest, opts ...grpc.CallOption) (*ListDatasetVersionsResponse, error)
	// Restores a dataset version.
	RestoreDatasetVersion(ctx context.Context, in *RestoreDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DataItems in a Dataset.
	ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error)
	// Searches DataItems in a Dataset.
	SearchDataItems(ctx context.Context, in *SearchDataItemsRequest, opts ...grpc.CallOption) (*SearchDataItemsResponse, error)
	// Lists SavedQueries in a Dataset.
	ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error)
	// Deletes a SavedQuery.
	DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an AnnotationSpec.
	GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error)
	// Lists Annotations belongs to a dataitem
	// This RPC is only available in InternalDatasetService. It is only used for
	// exporting conversation data to CCAI Insights.
	ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error)
}

type datasetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDatasetServiceClient(cc grpc.ClientConnInterface) DatasetServiceClient {
	return &datasetServiceClient{cc}
}

func (c *datasetServiceClient) CreateDataset(ctx context.Context, in *CreateDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_CreateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) GetDataset(ctx context.Context, in *GetDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, DatasetService_GetDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) UpdateDataset(ctx context.Context, in *UpdateDatasetRequest, opts ...grpc.CallOption) (*Dataset, error) {
	out := new(Dataset)
	err := c.cc.Invoke(ctx, DatasetService_UpdateDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListDatasets(ctx context.Context, in *ListDatasetsRequest, opts ...grpc.CallOption) (*ListDatasetsResponse, error) {
	out := new(ListDatasetsResponse)
	err := c.cc.Invoke(ctx, DatasetService_ListDatasets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) DeleteDataset(ctx context.Context, in *DeleteDatasetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_DeleteDataset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ImportData(ctx context.Context, in *ImportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_ImportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ExportData(ctx context.Context, in *ExportDataRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_ExportData_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) CreateDatasetVersion(ctx context.Context, in *CreateDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_CreateDatasetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) UpdateDatasetVersion(ctx context.Context, in *UpdateDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error) {
	out := new(DatasetVersion)
	err := c.cc.Invoke(ctx, DatasetService_UpdateDatasetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) DeleteDatasetVersion(ctx context.Context, in *DeleteDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_DeleteDatasetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) GetDatasetVersion(ctx context.Context, in *GetDatasetVersionRequest, opts ...grpc.CallOption) (*DatasetVersion, error) {
	out := new(DatasetVersion)
	err := c.cc.Invoke(ctx, DatasetService_GetDatasetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListDatasetVersions(ctx context.Context, in *ListDatasetVersionsRequest, opts ...grpc.CallOption) (*ListDatasetVersionsResponse, error) {
	out := new(ListDatasetVersionsResponse)
	err := c.cc.Invoke(ctx, DatasetService_ListDatasetVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) RestoreDatasetVersion(ctx context.Context, in *RestoreDatasetVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_RestoreDatasetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListDataItems(ctx context.Context, in *ListDataItemsRequest, opts ...grpc.CallOption) (*ListDataItemsResponse, error) {
	out := new(ListDataItemsResponse)
	err := c.cc.Invoke(ctx, DatasetService_ListDataItems_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) SearchDataItems(ctx context.Context, in *SearchDataItemsRequest, opts ...grpc.CallOption) (*SearchDataItemsResponse, error) {
	out := new(SearchDataItemsResponse)
	err := c.cc.Invoke(ctx, DatasetService_SearchDataItems_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListSavedQueries(ctx context.Context, in *ListSavedQueriesRequest, opts ...grpc.CallOption) (*ListSavedQueriesResponse, error) {
	out := new(ListSavedQueriesResponse)
	err := c.cc.Invoke(ctx, DatasetService_ListSavedQueries_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) DeleteSavedQuery(ctx context.Context, in *DeleteSavedQueryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, DatasetService_DeleteSavedQuery_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) GetAnnotationSpec(ctx context.Context, in *GetAnnotationSpecRequest, opts ...grpc.CallOption) (*AnnotationSpec, error) {
	out := new(AnnotationSpec)
	err := c.cc.Invoke(ctx, DatasetService_GetAnnotationSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datasetServiceClient) ListAnnotations(ctx context.Context, in *ListAnnotationsRequest, opts ...grpc.CallOption) (*ListAnnotationsResponse, error) {
	out := new(ListAnnotationsResponse)
	err := c.cc.Invoke(ctx, DatasetService_ListAnnotations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatasetServiceServer is the server API for DatasetService service.
// All implementations should embed UnimplementedDatasetServiceServer
// for forward compatibility
type DatasetServiceServer interface {
	// Creates a Dataset.
	CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error)
	// Gets a Dataset.
	GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error)
	// Updates a Dataset.
	UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error)
	// Lists Datasets in a Location.
	ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error)
	// Deletes a Dataset.
	DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error)
	// Imports data into a Dataset.
	ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error)
	// Exports data from a Dataset.
	ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error)
	// Create a version from a Dataset.
	CreateDatasetVersion(context.Context, *CreateDatasetVersionRequest) (*longrunningpb.Operation, error)
	// Updates a DatasetVersion.
	UpdateDatasetVersion(context.Context, *UpdateDatasetVersionRequest) (*DatasetVersion, error)
	// Deletes a Dataset version.
	DeleteDatasetVersion(context.Context, *DeleteDatasetVersionRequest) (*longrunningpb.Operation, error)
	// Gets a Dataset version.
	GetDatasetVersion(context.Context, *GetDatasetVersionRequest) (*DatasetVersion, error)
	// Lists DatasetVersions in a Dataset.
	ListDatasetVersions(context.Context, *ListDatasetVersionsRequest) (*ListDatasetVersionsResponse, error)
	// Restores a dataset version.
	RestoreDatasetVersion(context.Context, *RestoreDatasetVersionRequest) (*longrunningpb.Operation, error)
	// Lists DataItems in a Dataset.
	ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error)
	// Searches DataItems in a Dataset.
	SearchDataItems(context.Context, *SearchDataItemsRequest) (*SearchDataItemsResponse, error)
	// Lists SavedQueries in a Dataset.
	ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error)
	// Deletes a SavedQuery.
	DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*longrunningpb.Operation, error)
	// Gets an AnnotationSpec.
	GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error)
	// Lists Annotations belongs to a dataitem
	// This RPC is only available in InternalDatasetService. It is only used for
	// exporting conversation data to CCAI Insights.
	ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error)
}

// UnimplementedDatasetServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDatasetServiceServer struct {
}

func (UnimplementedDatasetServiceServer) CreateDataset(context.Context, *CreateDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDataset not implemented")
}
func (UnimplementedDatasetServiceServer) GetDataset(context.Context, *GetDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDataset not implemented")
}
func (UnimplementedDatasetServiceServer) UpdateDataset(context.Context, *UpdateDatasetRequest) (*Dataset, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDataset not implemented")
}
func (UnimplementedDatasetServiceServer) ListDatasets(context.Context, *ListDatasetsRequest) (*ListDatasetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasets not implemented")
}
func (UnimplementedDatasetServiceServer) DeleteDataset(context.Context, *DeleteDatasetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDataset not implemented")
}
func (UnimplementedDatasetServiceServer) ImportData(context.Context, *ImportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportData not implemented")
}
func (UnimplementedDatasetServiceServer) ExportData(context.Context, *ExportDataRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportData not implemented")
}
func (UnimplementedDatasetServiceServer) CreateDatasetVersion(context.Context, *CreateDatasetVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatasetVersion not implemented")
}
func (UnimplementedDatasetServiceServer) UpdateDatasetVersion(context.Context, *UpdateDatasetVersionRequest) (*DatasetVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDatasetVersion not implemented")
}
func (UnimplementedDatasetServiceServer) DeleteDatasetVersion(context.Context, *DeleteDatasetVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDatasetVersion not implemented")
}
func (UnimplementedDatasetServiceServer) GetDatasetVersion(context.Context, *GetDatasetVersionRequest) (*DatasetVersion, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatasetVersion not implemented")
}
func (UnimplementedDatasetServiceServer) ListDatasetVersions(context.Context, *ListDatasetVersionsRequest) (*ListDatasetVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatasetVersions not implemented")
}
func (UnimplementedDatasetServiceServer) RestoreDatasetVersion(context.Context, *RestoreDatasetVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreDatasetVersion not implemented")
}
func (UnimplementedDatasetServiceServer) ListDataItems(context.Context, *ListDataItemsRequest) (*ListDataItemsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDataItems not implemented")
}
func (UnimplementedDatasetServiceServer) SearchDataItems(context.Context, *SearchDataItemsRequest) (*SearchDataItemsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchDataItems not implemented")
}
func (UnimplementedDatasetServiceServer) ListSavedQueries(context.Context, *ListSavedQueriesRequest) (*ListSavedQueriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSavedQueries not implemented")
}
func (UnimplementedDatasetServiceServer) DeleteSavedQuery(context.Context, *DeleteSavedQueryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSavedQuery not implemented")
}
func (UnimplementedDatasetServiceServer) GetAnnotationSpec(context.Context, *GetAnnotationSpecRequest) (*AnnotationSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAnnotationSpec not implemented")
}
func (UnimplementedDatasetServiceServer) ListAnnotations(context.Context, *ListAnnotationsRequest) (*ListAnnotationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAnnotations not implemented")
}

// UnsafeDatasetServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DatasetServiceServer will
// result in compilation errors.
type UnsafeDatasetServiceServer interface {
	mustEmbedUnimplementedDatasetServiceServer()
}

func RegisterDatasetServiceServer(s grpc.ServiceRegistrar, srv DatasetServiceServer) {
	s.RegisterService(&DatasetService_ServiceDesc, srv)
}

func _DatasetService_CreateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).CreateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_CreateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).CreateDataset(ctx, req.(*CreateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_GetDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).GetDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_GetDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).GetDataset(ctx, req.(*GetDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_UpdateDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).UpdateDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_UpdateDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).UpdateDataset(ctx, req.(*UpdateDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListDatasets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListDatasets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ListDatasets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListDatasets(ctx, req.(*ListDatasetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_DeleteDataset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).DeleteDataset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_DeleteDataset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).DeleteDataset(ctx, req.(*DeleteDatasetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ImportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ImportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ImportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ImportData(ctx, req.(*ImportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ExportData_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ExportData(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ExportData_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ExportData(ctx, req.(*ExportDataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_CreateDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).CreateDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_CreateDatasetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).CreateDatasetVersion(ctx, req.(*CreateDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_UpdateDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).UpdateDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_UpdateDatasetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).UpdateDatasetVersion(ctx, req.(*UpdateDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_DeleteDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).DeleteDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_DeleteDatasetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).DeleteDatasetVersion(ctx, req.(*DeleteDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_GetDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).GetDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_GetDatasetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).GetDatasetVersion(ctx, req.(*GetDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListDatasetVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatasetVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListDatasetVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ListDatasetVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListDatasetVersions(ctx, req.(*ListDatasetVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_RestoreDatasetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreDatasetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).RestoreDatasetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_RestoreDatasetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).RestoreDatasetVersion(ctx, req.(*RestoreDatasetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ListDataItems_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListDataItems(ctx, req.(*ListDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_SearchDataItems_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchDataItemsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).SearchDataItems(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_SearchDataItems_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).SearchDataItems(ctx, req.(*SearchDataItemsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListSavedQueries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSavedQueriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListSavedQueries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ListSavedQueries_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListSavedQueries(ctx, req.(*ListSavedQueriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_DeleteSavedQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSavedQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).DeleteSavedQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_DeleteSavedQuery_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).DeleteSavedQuery(ctx, req.(*DeleteSavedQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_GetAnnotationSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAnnotationSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).GetAnnotationSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_GetAnnotationSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).GetAnnotationSpec(ctx, req.(*GetAnnotationSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatasetService_ListAnnotations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAnnotationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatasetServiceServer).ListAnnotations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DatasetService_ListAnnotations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatasetServiceServer).ListAnnotations(ctx, req.(*ListAnnotationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DatasetService_ServiceDesc is the grpc.ServiceDesc for DatasetService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DatasetService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.DatasetService",
	HandlerType: (*DatasetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDataset",
			Handler:    _DatasetService_CreateDataset_Handler,
		},
		{
			MethodName: "GetDataset",
			Handler:    _DatasetService_GetDataset_Handler,
		},
		{
			MethodName: "UpdateDataset",
			Handler:    _DatasetService_UpdateDataset_Handler,
		},
		{
			MethodName: "ListDatasets",
			Handler:    _DatasetService_ListDatasets_Handler,
		},
		{
			MethodName: "DeleteDataset",
			Handler:    _DatasetService_DeleteDataset_Handler,
		},
		{
			MethodName: "ImportData",
			Handler:    _DatasetService_ImportData_Handler,
		},
		{
			MethodName: "ExportData",
			Handler:    _DatasetService_ExportData_Handler,
		},
		{
			MethodName: "CreateDatasetVersion",
			Handler:    _DatasetService_CreateDatasetVersion_Handler,
		},
		{
			MethodName: "UpdateDatasetVersion",
			Handler:    _DatasetService_UpdateDatasetVersion_Handler,
		},
		{
			MethodName: "DeleteDatasetVersion",
			Handler:    _DatasetService_DeleteDatasetVersion_Handler,
		},
		{
			MethodName: "GetDatasetVersion",
			Handler:    _DatasetService_GetDatasetVersion_Handler,
		},
		{
			MethodName: "ListDatasetVersions",
			Handler:    _DatasetService_ListDatasetVersions_Handler,
		},
		{
			MethodName: "RestoreDatasetVersion",
			Handler:    _DatasetService_RestoreDatasetVersion_Handler,
		},
		{
			MethodName: "ListDataItems",
			Handler:    _DatasetService_ListDataItems_Handler,
		},
		{
			MethodName: "SearchDataItems",
			Handler:    _DatasetService_SearchDataItems_Handler,
		},
		{
			MethodName: "ListSavedQueries",
			Handler:    _DatasetService_ListSavedQueries_Handler,
		},
		{
			MethodName: "DeleteSavedQuery",
			Handler:    _DatasetService_DeleteSavedQuery_Handler,
		},
		{
			MethodName: "GetAnnotationSpec",
			Handler:    _DatasetService_GetAnnotationSpec_Handler,
		},
		{
			MethodName: "ListAnnotations",
			Handler:    _DatasetService_ListAnnotations_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/aiplatform/v1/dataset_service.proto",
}
