// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/analytics/admin/v1alpha/access_report.proto

package adminpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The match type of a string filter.
type AccessStringFilter_MatchType int32

const (
	// Unspecified
	AccessStringFilter_MATCH_TYPE_UNSPECIFIED AccessStringFilter_MatchType = 0
	// Exact match of the string value.
	AccessStringFilter_EXACT AccessStringFilter_MatchType = 1
	// Begins with the string value.
	AccessStringFilter_BEGINS_WITH AccessStringFilter_MatchType = 2
	// Ends with the string value.
	AccessStringFilter_ENDS_WITH AccessStringFilter_MatchType = 3
	// Contains the string value.
	AccessStringFilter_CONTAINS AccessStringFilter_MatchType = 4
	// Full match for the regular expression with the string value.
	AccessStringFilter_FULL_REGEXP AccessStringFilter_MatchType = 5
	// Partial match for the regular expression with the string value.
	AccessStringFilter_PARTIAL_REGEXP AccessStringFilter_MatchType = 6
)

// Enum value maps for AccessStringFilter_MatchType.
var (
	AccessStringFilter_MatchType_name = map[int32]string{
		0: "MATCH_TYPE_UNSPECIFIED",
		1: "EXACT",
		2: "BEGINS_WITH",
		3: "ENDS_WITH",
		4: "CONTAINS",
		5: "FULL_REGEXP",
		6: "PARTIAL_REGEXP",
	}
	AccessStringFilter_MatchType_value = map[string]int32{
		"MATCH_TYPE_UNSPECIFIED": 0,
		"EXACT":                  1,
		"BEGINS_WITH":            2,
		"ENDS_WITH":              3,
		"CONTAINS":               4,
		"FULL_REGEXP":            5,
		"PARTIAL_REGEXP":         6,
	}
)

func (x AccessStringFilter_MatchType) Enum() *AccessStringFilter_MatchType {
	p := new(AccessStringFilter_MatchType)
	*p = x
	return p
}

func (x AccessStringFilter_MatchType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessStringFilter_MatchType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_access_report_proto_enumTypes[0].Descriptor()
}

func (AccessStringFilter_MatchType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_access_report_proto_enumTypes[0]
}

func (x AccessStringFilter_MatchType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessStringFilter_MatchType.Descriptor instead.
func (AccessStringFilter_MatchType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{6, 0}
}

// The operation applied to a numeric filter.
type AccessNumericFilter_Operation int32

const (
	// Unspecified.
	AccessNumericFilter_OPERATION_UNSPECIFIED AccessNumericFilter_Operation = 0
	// Equal
	AccessNumericFilter_EQUAL AccessNumericFilter_Operation = 1
	// Less than
	AccessNumericFilter_LESS_THAN AccessNumericFilter_Operation = 2
	// Less than or equal
	AccessNumericFilter_LESS_THAN_OR_EQUAL AccessNumericFilter_Operation = 3
	// Greater than
	AccessNumericFilter_GREATER_THAN AccessNumericFilter_Operation = 4
	// Greater than or equal
	AccessNumericFilter_GREATER_THAN_OR_EQUAL AccessNumericFilter_Operation = 5
)

// Enum value maps for AccessNumericFilter_Operation.
var (
	AccessNumericFilter_Operation_name = map[int32]string{
		0: "OPERATION_UNSPECIFIED",
		1: "EQUAL",
		2: "LESS_THAN",
		3: "LESS_THAN_OR_EQUAL",
		4: "GREATER_THAN",
		5: "GREATER_THAN_OR_EQUAL",
	}
	AccessNumericFilter_Operation_value = map[string]int32{
		"OPERATION_UNSPECIFIED": 0,
		"EQUAL":                 1,
		"LESS_THAN":             2,
		"LESS_THAN_OR_EQUAL":    3,
		"GREATER_THAN":          4,
		"GREATER_THAN_OR_EQUAL": 5,
	}
)

func (x AccessNumericFilter_Operation) Enum() *AccessNumericFilter_Operation {
	p := new(AccessNumericFilter_Operation)
	*p = x
	return p
}

func (x AccessNumericFilter_Operation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessNumericFilter_Operation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_access_report_proto_enumTypes[1].Descriptor()
}

func (AccessNumericFilter_Operation) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_access_report_proto_enumTypes[1]
}

func (x AccessNumericFilter_Operation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessNumericFilter_Operation.Descriptor instead.
func (AccessNumericFilter_Operation) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{8, 0}
}

// Rule to order the string dimension values by.
type AccessOrderBy_DimensionOrderBy_OrderType int32

const (
	// Unspecified.
	AccessOrderBy_DimensionOrderBy_ORDER_TYPE_UNSPECIFIED AccessOrderBy_DimensionOrderBy_OrderType = 0
	// Alphanumeric sort by Unicode code point. For example, "2" < "A" < "X" <
	// "b" < "z".
	AccessOrderBy_DimensionOrderBy_ALPHANUMERIC AccessOrderBy_DimensionOrderBy_OrderType = 1
	// Case insensitive alphanumeric sort by lower case Unicode code point.
	// For example, "2" < "A" < "b" < "X" < "z".
	AccessOrderBy_DimensionOrderBy_CASE_INSENSITIVE_ALPHANUMERIC AccessOrderBy_DimensionOrderBy_OrderType = 2
	// Dimension values are converted to numbers before sorting. For example
	// in NUMERIC sort, "25" < "100", and in `ALPHANUMERIC` sort, "100" <
	// "25". Non-numeric dimension values all have equal ordering value below
	// all numeric values.
	AccessOrderBy_DimensionOrderBy_NUMERIC AccessOrderBy_DimensionOrderBy_OrderType = 3
)

// Enum value maps for AccessOrderBy_DimensionOrderBy_OrderType.
var (
	AccessOrderBy_DimensionOrderBy_OrderType_name = map[int32]string{
		0: "ORDER_TYPE_UNSPECIFIED",
		1: "ALPHANUMERIC",
		2: "CASE_INSENSITIVE_ALPHANUMERIC",
		3: "NUMERIC",
	}
	AccessOrderBy_DimensionOrderBy_OrderType_value = map[string]int32{
		"ORDER_TYPE_UNSPECIFIED":        0,
		"ALPHANUMERIC":                  1,
		"CASE_INSENSITIVE_ALPHANUMERIC": 2,
		"NUMERIC":                       3,
	}
)

func (x AccessOrderBy_DimensionOrderBy_OrderType) Enum() *AccessOrderBy_DimensionOrderBy_OrderType {
	p := new(AccessOrderBy_DimensionOrderBy_OrderType)
	*p = x
	return p
}

func (x AccessOrderBy_DimensionOrderBy_OrderType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AccessOrderBy_DimensionOrderBy_OrderType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_analytics_admin_v1alpha_access_report_proto_enumTypes[2].Descriptor()
}

func (AccessOrderBy_DimensionOrderBy_OrderType) Type() protoreflect.EnumType {
	return &file_google_analytics_admin_v1alpha_access_report_proto_enumTypes[2]
}

func (x AccessOrderBy_DimensionOrderBy_OrderType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AccessOrderBy_DimensionOrderBy_OrderType.Descriptor instead.
func (AccessOrderBy_DimensionOrderBy_OrderType) EnumDescriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{11, 1, 0}
}

// Dimensions are attributes of your data. For example, the dimension
// `userEmail` indicates the email of the user that accessed reporting data.
// Dimension values in report responses are strings.
type AccessDimension struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API name of the dimension. See [Data Access
	// Schema](https://developers.google.com/analytics/devguides/config/admin/v1/access-api-schema)
	// for the list of dimensions supported in this API.
	//
	// Dimensions are referenced by name in `dimensionFilter` and `orderBys`.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
}

func (x *AccessDimension) Reset() {
	*x = AccessDimension{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessDimension) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessDimension) ProtoMessage() {}

func (x *AccessDimension) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessDimension.ProtoReflect.Descriptor instead.
func (*AccessDimension) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{0}
}

func (x *AccessDimension) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

// The quantitative measurements of a report. For example, the metric
// `accessCount` is the total number of data access records.
type AccessMetric struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API name of the metric. See [Data Access
	// Schema](https://developers.google.com/analytics/devguides/config/admin/v1/access-api-schema)
	// for the list of metrics supported in this API.
	//
	// Metrics are referenced by name in `metricFilter` & `orderBys`.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
}

func (x *AccessMetric) Reset() {
	*x = AccessMetric{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessMetric) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessMetric) ProtoMessage() {}

func (x *AccessMetric) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessMetric.ProtoReflect.Descriptor instead.
func (*AccessMetric) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{1}
}

func (x *AccessMetric) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// A contiguous range of days: startDate, startDate + 1, ..., endDate.
type AccessDateRange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The inclusive start date for the query in the format `YYYY-MM-DD`. Cannot
	// be after `endDate`. The format `NdaysAgo`, `yesterday`, or `today` is also
	// accepted, and in that case, the date is inferred based on the current time
	// in the request's time zone.
	StartDate string `protobuf:"bytes,1,opt,name=start_date,json=startDate,proto3" json:"start_date,omitempty"`
	// The inclusive end date for the query in the format `YYYY-MM-DD`. Cannot
	// be before `startDate`. The format `NdaysAgo`, `yesterday`, or `today` is
	// also accepted, and in that case, the date is inferred based on the current
	// time in the request's time zone.
	EndDate string `protobuf:"bytes,2,opt,name=end_date,json=endDate,proto3" json:"end_date,omitempty"`
}

func (x *AccessDateRange) Reset() {
	*x = AccessDateRange{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessDateRange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessDateRange) ProtoMessage() {}

func (x *AccessDateRange) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessDateRange.ProtoReflect.Descriptor instead.
func (*AccessDateRange) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{2}
}

func (x *AccessDateRange) GetStartDate() string {
	if x != nil {
		return x.StartDate
	}
	return ""
}

func (x *AccessDateRange) GetEndDate() string {
	if x != nil {
		return x.EndDate
	}
	return ""
}

// Expresses dimension or metric filters. The fields in the same expression need
// to be either all dimensions or all metrics.
type AccessFilterExpression struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter expression for `FilterExpression`.
	//
	// Types that are assignable to OneExpression:
	//
	//	*AccessFilterExpression_AndGroup
	//	*AccessFilterExpression_OrGroup
	//	*AccessFilterExpression_NotExpression
	//	*AccessFilterExpression_AccessFilter
	OneExpression isAccessFilterExpression_OneExpression `protobuf_oneof:"one_expression"`
}

func (x *AccessFilterExpression) Reset() {
	*x = AccessFilterExpression{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessFilterExpression) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessFilterExpression) ProtoMessage() {}

func (x *AccessFilterExpression) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessFilterExpression.ProtoReflect.Descriptor instead.
func (*AccessFilterExpression) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{3}
}

func (m *AccessFilterExpression) GetOneExpression() isAccessFilterExpression_OneExpression {
	if m != nil {
		return m.OneExpression
	}
	return nil
}

func (x *AccessFilterExpression) GetAndGroup() *AccessFilterExpressionList {
	if x, ok := x.GetOneExpression().(*AccessFilterExpression_AndGroup); ok {
		return x.AndGroup
	}
	return nil
}

func (x *AccessFilterExpression) GetOrGroup() *AccessFilterExpressionList {
	if x, ok := x.GetOneExpression().(*AccessFilterExpression_OrGroup); ok {
		return x.OrGroup
	}
	return nil
}

func (x *AccessFilterExpression) GetNotExpression() *AccessFilterExpression {
	if x, ok := x.GetOneExpression().(*AccessFilterExpression_NotExpression); ok {
		return x.NotExpression
	}
	return nil
}

func (x *AccessFilterExpression) GetAccessFilter() *AccessFilter {
	if x, ok := x.GetOneExpression().(*AccessFilterExpression_AccessFilter); ok {
		return x.AccessFilter
	}
	return nil
}

type isAccessFilterExpression_OneExpression interface {
	isAccessFilterExpression_OneExpression()
}

type AccessFilterExpression_AndGroup struct {
	// Each of the FilterExpressions in the and_group has an AND relationship.
	AndGroup *AccessFilterExpressionList `protobuf:"bytes,1,opt,name=and_group,json=andGroup,proto3,oneof"`
}

type AccessFilterExpression_OrGroup struct {
	// Each of the FilterExpressions in the or_group has an OR relationship.
	OrGroup *AccessFilterExpressionList `protobuf:"bytes,2,opt,name=or_group,json=orGroup,proto3,oneof"`
}

type AccessFilterExpression_NotExpression struct {
	// The FilterExpression is NOT of not_expression.
	NotExpression *AccessFilterExpression `protobuf:"bytes,3,opt,name=not_expression,json=notExpression,proto3,oneof"`
}

type AccessFilterExpression_AccessFilter struct {
	// A primitive filter. In the same FilterExpression, all of the filter's
	// field names need to be either all dimensions or all metrics.
	AccessFilter *AccessFilter `protobuf:"bytes,4,opt,name=access_filter,json=accessFilter,proto3,oneof"`
}

func (*AccessFilterExpression_AndGroup) isAccessFilterExpression_OneExpression() {}

func (*AccessFilterExpression_OrGroup) isAccessFilterExpression_OneExpression() {}

func (*AccessFilterExpression_NotExpression) isAccessFilterExpression_OneExpression() {}

func (*AccessFilterExpression_AccessFilter) isAccessFilterExpression_OneExpression() {}

// A list of filter expressions.
type AccessFilterExpressionList struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of filter expressions.
	Expressions []*AccessFilterExpression `protobuf:"bytes,1,rep,name=expressions,proto3" json:"expressions,omitempty"`
}

func (x *AccessFilterExpressionList) Reset() {
	*x = AccessFilterExpressionList{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessFilterExpressionList) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessFilterExpressionList) ProtoMessage() {}

func (x *AccessFilterExpressionList) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessFilterExpressionList.ProtoReflect.Descriptor instead.
func (*AccessFilterExpressionList) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{4}
}

func (x *AccessFilterExpressionList) GetExpressions() []*AccessFilterExpression {
	if x != nil {
		return x.Expressions
	}
	return nil
}

// An expression to filter dimension or metric values.
type AccessFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of filter for `Filter`.
	//
	// Types that are assignable to OneFilter:
	//
	//	*AccessFilter_StringFilter
	//	*AccessFilter_InListFilter
	//	*AccessFilter_NumericFilter
	//	*AccessFilter_BetweenFilter
	OneFilter isAccessFilter_OneFilter `protobuf_oneof:"one_filter"`
	// The dimension name or metric name.
	FieldName string `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
}

func (x *AccessFilter) Reset() {
	*x = AccessFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessFilter) ProtoMessage() {}

func (x *AccessFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessFilter.ProtoReflect.Descriptor instead.
func (*AccessFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{5}
}

func (m *AccessFilter) GetOneFilter() isAccessFilter_OneFilter {
	if m != nil {
		return m.OneFilter
	}
	return nil
}

func (x *AccessFilter) GetStringFilter() *AccessStringFilter {
	if x, ok := x.GetOneFilter().(*AccessFilter_StringFilter); ok {
		return x.StringFilter
	}
	return nil
}

func (x *AccessFilter) GetInListFilter() *AccessInListFilter {
	if x, ok := x.GetOneFilter().(*AccessFilter_InListFilter); ok {
		return x.InListFilter
	}
	return nil
}

func (x *AccessFilter) GetNumericFilter() *AccessNumericFilter {
	if x, ok := x.GetOneFilter().(*AccessFilter_NumericFilter); ok {
		return x.NumericFilter
	}
	return nil
}

func (x *AccessFilter) GetBetweenFilter() *AccessBetweenFilter {
	if x, ok := x.GetOneFilter().(*AccessFilter_BetweenFilter); ok {
		return x.BetweenFilter
	}
	return nil
}

func (x *AccessFilter) GetFieldName() string {
	if x != nil {
		return x.FieldName
	}
	return ""
}

type isAccessFilter_OneFilter interface {
	isAccessFilter_OneFilter()
}

type AccessFilter_StringFilter struct {
	// Strings related filter.
	StringFilter *AccessStringFilter `protobuf:"bytes,2,opt,name=string_filter,json=stringFilter,proto3,oneof"`
}

type AccessFilter_InListFilter struct {
	// A filter for in list values.
	InListFilter *AccessInListFilter `protobuf:"bytes,3,opt,name=in_list_filter,json=inListFilter,proto3,oneof"`
}

type AccessFilter_NumericFilter struct {
	// A filter for numeric or date values.
	NumericFilter *AccessNumericFilter `protobuf:"bytes,4,opt,name=numeric_filter,json=numericFilter,proto3,oneof"`
}

type AccessFilter_BetweenFilter struct {
	// A filter for two values.
	BetweenFilter *AccessBetweenFilter `protobuf:"bytes,5,opt,name=between_filter,json=betweenFilter,proto3,oneof"`
}

func (*AccessFilter_StringFilter) isAccessFilter_OneFilter() {}

func (*AccessFilter_InListFilter) isAccessFilter_OneFilter() {}

func (*AccessFilter_NumericFilter) isAccessFilter_OneFilter() {}

func (*AccessFilter_BetweenFilter) isAccessFilter_OneFilter() {}

// The filter for strings.
type AccessStringFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The match type for this filter.
	MatchType AccessStringFilter_MatchType `protobuf:"varint,1,opt,name=match_type,json=matchType,proto3,enum=google.analytics.admin.v1alpha.AccessStringFilter_MatchType" json:"match_type,omitempty"`
	// The string value used for the matching.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// If true, the string value is case sensitive.
	CaseSensitive bool `protobuf:"varint,3,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *AccessStringFilter) Reset() {
	*x = AccessStringFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessStringFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessStringFilter) ProtoMessage() {}

func (x *AccessStringFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessStringFilter.ProtoReflect.Descriptor instead.
func (*AccessStringFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{6}
}

func (x *AccessStringFilter) GetMatchType() AccessStringFilter_MatchType {
	if x != nil {
		return x.MatchType
	}
	return AccessStringFilter_MATCH_TYPE_UNSPECIFIED
}

func (x *AccessStringFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *AccessStringFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// The result needs to be in a list of string values.
type AccessInListFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of string values. Must be non-empty.
	Values []string `protobuf:"bytes,1,rep,name=values,proto3" json:"values,omitempty"`
	// If true, the string value is case sensitive.
	CaseSensitive bool `protobuf:"varint,2,opt,name=case_sensitive,json=caseSensitive,proto3" json:"case_sensitive,omitempty"`
}

func (x *AccessInListFilter) Reset() {
	*x = AccessInListFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessInListFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessInListFilter) ProtoMessage() {}

func (x *AccessInListFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessInListFilter.ProtoReflect.Descriptor instead.
func (*AccessInListFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{7}
}

func (x *AccessInListFilter) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

func (x *AccessInListFilter) GetCaseSensitive() bool {
	if x != nil {
		return x.CaseSensitive
	}
	return false
}

// Filters for numeric or date values.
type AccessNumericFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The operation type for this filter.
	Operation AccessNumericFilter_Operation `protobuf:"varint,1,opt,name=operation,proto3,enum=google.analytics.admin.v1alpha.AccessNumericFilter_Operation" json:"operation,omitempty"`
	// A numeric value or a date value.
	Value *NumericValue `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AccessNumericFilter) Reset() {
	*x = AccessNumericFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessNumericFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessNumericFilter) ProtoMessage() {}

func (x *AccessNumericFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessNumericFilter.ProtoReflect.Descriptor instead.
func (*AccessNumericFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{8}
}

func (x *AccessNumericFilter) GetOperation() AccessNumericFilter_Operation {
	if x != nil {
		return x.Operation
	}
	return AccessNumericFilter_OPERATION_UNSPECIFIED
}

func (x *AccessNumericFilter) GetValue() *NumericValue {
	if x != nil {
		return x.Value
	}
	return nil
}

// To express that the result needs to be between two numbers (inclusive).
type AccessBetweenFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Begins with this number.
	FromValue *NumericValue `protobuf:"bytes,1,opt,name=from_value,json=fromValue,proto3" json:"from_value,omitempty"`
	// Ends with this number.
	ToValue *NumericValue `protobuf:"bytes,2,opt,name=to_value,json=toValue,proto3" json:"to_value,omitempty"`
}

func (x *AccessBetweenFilter) Reset() {
	*x = AccessBetweenFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessBetweenFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessBetweenFilter) ProtoMessage() {}

func (x *AccessBetweenFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessBetweenFilter.ProtoReflect.Descriptor instead.
func (*AccessBetweenFilter) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{9}
}

func (x *AccessBetweenFilter) GetFromValue() *NumericValue {
	if x != nil {
		return x.FromValue
	}
	return nil
}

func (x *AccessBetweenFilter) GetToValue() *NumericValue {
	if x != nil {
		return x.ToValue
	}
	return nil
}

// To represent a number.
type NumericValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One of a numeric value
	//
	// Types that are assignable to OneValue:
	//
	//	*NumericValue_Int64Value
	//	*NumericValue_DoubleValue
	OneValue isNumericValue_OneValue `protobuf_oneof:"one_value"`
}

func (x *NumericValue) Reset() {
	*x = NumericValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NumericValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NumericValue) ProtoMessage() {}

func (x *NumericValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NumericValue.ProtoReflect.Descriptor instead.
func (*NumericValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{10}
}

func (m *NumericValue) GetOneValue() isNumericValue_OneValue {
	if m != nil {
		return m.OneValue
	}
	return nil
}

func (x *NumericValue) GetInt64Value() int64 {
	if x, ok := x.GetOneValue().(*NumericValue_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (x *NumericValue) GetDoubleValue() float64 {
	if x, ok := x.GetOneValue().(*NumericValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

type isNumericValue_OneValue interface {
	isNumericValue_OneValue()
}

type NumericValue_Int64Value struct {
	// Integer value
	Int64Value int64 `protobuf:"varint,1,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type NumericValue_DoubleValue struct {
	// Double value
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

func (*NumericValue_Int64Value) isNumericValue_OneValue() {}

func (*NumericValue_DoubleValue) isNumericValue_OneValue() {}

// Order bys define how rows will be sorted in the response. For example,
// ordering rows by descending access count is one ordering, and ordering rows
// by the country string is a different ordering.
type AccessOrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specify one type of order by for `OrderBy`.
	//
	// Types that are assignable to OneOrderBy:
	//
	//	*AccessOrderBy_Metric
	//	*AccessOrderBy_Dimension
	OneOrderBy isAccessOrderBy_OneOrderBy `protobuf_oneof:"one_order_by"`
	// If true, sorts by descending order. If false or unspecified, sorts in
	// ascending order.
	Desc bool `protobuf:"varint,3,opt,name=desc,proto3" json:"desc,omitempty"`
}

func (x *AccessOrderBy) Reset() {
	*x = AccessOrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessOrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessOrderBy) ProtoMessage() {}

func (x *AccessOrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessOrderBy.ProtoReflect.Descriptor instead.
func (*AccessOrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{11}
}

func (m *AccessOrderBy) GetOneOrderBy() isAccessOrderBy_OneOrderBy {
	if m != nil {
		return m.OneOrderBy
	}
	return nil
}

func (x *AccessOrderBy) GetMetric() *AccessOrderBy_MetricOrderBy {
	if x, ok := x.GetOneOrderBy().(*AccessOrderBy_Metric); ok {
		return x.Metric
	}
	return nil
}

func (x *AccessOrderBy) GetDimension() *AccessOrderBy_DimensionOrderBy {
	if x, ok := x.GetOneOrderBy().(*AccessOrderBy_Dimension); ok {
		return x.Dimension
	}
	return nil
}

func (x *AccessOrderBy) GetDesc() bool {
	if x != nil {
		return x.Desc
	}
	return false
}

type isAccessOrderBy_OneOrderBy interface {
	isAccessOrderBy_OneOrderBy()
}

type AccessOrderBy_Metric struct {
	// Sorts results by a metric's values.
	Metric *AccessOrderBy_MetricOrderBy `protobuf:"bytes,1,opt,name=metric,proto3,oneof"`
}

type AccessOrderBy_Dimension struct {
	// Sorts results by a dimension's values.
	Dimension *AccessOrderBy_DimensionOrderBy `protobuf:"bytes,2,opt,name=dimension,proto3,oneof"`
}

func (*AccessOrderBy_Metric) isAccessOrderBy_OneOrderBy() {}

func (*AccessOrderBy_Dimension) isAccessOrderBy_OneOrderBy() {}

// Describes a dimension column in the report. Dimensions requested in a report
// produce column entries within rows and DimensionHeaders. However, dimensions
// used exclusively within filters or expressions do not produce columns in a
// report; correspondingly, those dimensions do not produce headers.
type AccessDimensionHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension's name; for example 'userEmail'.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
}

func (x *AccessDimensionHeader) Reset() {
	*x = AccessDimensionHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessDimensionHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessDimensionHeader) ProtoMessage() {}

func (x *AccessDimensionHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessDimensionHeader.ProtoReflect.Descriptor instead.
func (*AccessDimensionHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{12}
}

func (x *AccessDimensionHeader) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

// Describes a metric column in the report. Visible metrics requested in a
// report produce column entries within rows and MetricHeaders. However,
// metrics used exclusively within filters or expressions do not produce columns
// in a report; correspondingly, those metrics do not produce headers.
type AccessMetricHeader struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metric's name; for example 'accessCount'.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
}

func (x *AccessMetricHeader) Reset() {
	*x = AccessMetricHeader{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessMetricHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessMetricHeader) ProtoMessage() {}

func (x *AccessMetricHeader) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessMetricHeader.ProtoReflect.Descriptor instead.
func (*AccessMetricHeader) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{13}
}

func (x *AccessMetricHeader) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// Access report data for each row.
type AccessRow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of dimension values. These values are in the same order as specified
	// in the request.
	DimensionValues []*AccessDimensionValue `protobuf:"bytes,1,rep,name=dimension_values,json=dimensionValues,proto3" json:"dimension_values,omitempty"`
	// List of metric values. These values are in the same order as specified
	// in the request.
	MetricValues []*AccessMetricValue `protobuf:"bytes,2,rep,name=metric_values,json=metricValues,proto3" json:"metric_values,omitempty"`
}

func (x *AccessRow) Reset() {
	*x = AccessRow{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessRow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessRow) ProtoMessage() {}

func (x *AccessRow) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessRow.ProtoReflect.Descriptor instead.
func (*AccessRow) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{14}
}

func (x *AccessRow) GetDimensionValues() []*AccessDimensionValue {
	if x != nil {
		return x.DimensionValues
	}
	return nil
}

func (x *AccessRow) GetMetricValues() []*AccessMetricValue {
	if x != nil {
		return x.MetricValues
	}
	return nil
}

// The value of a dimension.
type AccessDimensionValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dimension value. For example, this value may be 'France' for the
	// 'country' dimension.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AccessDimensionValue) Reset() {
	*x = AccessDimensionValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessDimensionValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessDimensionValue) ProtoMessage() {}

func (x *AccessDimensionValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessDimensionValue.ProtoReflect.Descriptor instead.
func (*AccessDimensionValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{15}
}

func (x *AccessDimensionValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// The value of a metric.
type AccessMetricValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The measurement value. For example, this value may be '13'.
	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AccessMetricValue) Reset() {
	*x = AccessMetricValue{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessMetricValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessMetricValue) ProtoMessage() {}

func (x *AccessMetricValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessMetricValue.ProtoReflect.Descriptor instead.
func (*AccessMetricValue) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{16}
}

func (x *AccessMetricValue) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Current state of all quotas for this Analytics property. If any quota for a
// property is exhausted, all requests to that property will return Resource
// Exhausted errors.
type AccessQuota struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Properties can use 250,000 tokens per day. Most requests consume fewer than
	// 10 tokens.
	TokensPerDay *AccessQuotaStatus `protobuf:"bytes,1,opt,name=tokens_per_day,json=tokensPerDay,proto3" json:"tokens_per_day,omitempty"`
	// Properties can use 50,000 tokens per hour. An API request consumes a single
	// number of tokens, and that number is deducted from all of the hourly,
	// daily, and per project hourly quotas.
	TokensPerHour *AccessQuotaStatus `protobuf:"bytes,2,opt,name=tokens_per_hour,json=tokensPerHour,proto3" json:"tokens_per_hour,omitempty"`
	// Properties can use up to 50 concurrent requests.
	ConcurrentRequests *AccessQuotaStatus `protobuf:"bytes,3,opt,name=concurrent_requests,json=concurrentRequests,proto3" json:"concurrent_requests,omitempty"`
	// Properties and cloud project pairs can have up to 50 server errors per
	// hour.
	ServerErrorsPerProjectPerHour *AccessQuotaStatus `protobuf:"bytes,4,opt,name=server_errors_per_project_per_hour,json=serverErrorsPerProjectPerHour,proto3" json:"server_errors_per_project_per_hour,omitempty"`
	// Properties can use up to 25% of their tokens per project per hour. This
	// amounts to Analytics 360 Properties can use 12,500 tokens per project per
	// hour. An API request consumes a single number of tokens, and that number is
	// deducted from all of the hourly, daily, and per project hourly quotas.
	TokensPerProjectPerHour *AccessQuotaStatus `protobuf:"bytes,5,opt,name=tokens_per_project_per_hour,json=tokensPerProjectPerHour,proto3" json:"tokens_per_project_per_hour,omitempty"`
}

func (x *AccessQuota) Reset() {
	*x = AccessQuota{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessQuota) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessQuota) ProtoMessage() {}

func (x *AccessQuota) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessQuota.ProtoReflect.Descriptor instead.
func (*AccessQuota) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{17}
}

func (x *AccessQuota) GetTokensPerDay() *AccessQuotaStatus {
	if x != nil {
		return x.TokensPerDay
	}
	return nil
}

func (x *AccessQuota) GetTokensPerHour() *AccessQuotaStatus {
	if x != nil {
		return x.TokensPerHour
	}
	return nil
}

func (x *AccessQuota) GetConcurrentRequests() *AccessQuotaStatus {
	if x != nil {
		return x.ConcurrentRequests
	}
	return nil
}

func (x *AccessQuota) GetServerErrorsPerProjectPerHour() *AccessQuotaStatus {
	if x != nil {
		return x.ServerErrorsPerProjectPerHour
	}
	return nil
}

func (x *AccessQuota) GetTokensPerProjectPerHour() *AccessQuotaStatus {
	if x != nil {
		return x.TokensPerProjectPerHour
	}
	return nil
}

// Current state for a particular quota group.
type AccessQuotaStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Quota consumed by this request.
	Consumed int32 `protobuf:"varint,1,opt,name=consumed,proto3" json:"consumed,omitempty"`
	// Quota remaining after this request.
	Remaining int32 `protobuf:"varint,2,opt,name=remaining,proto3" json:"remaining,omitempty"`
}

func (x *AccessQuotaStatus) Reset() {
	*x = AccessQuotaStatus{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessQuotaStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessQuotaStatus) ProtoMessage() {}

func (x *AccessQuotaStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessQuotaStatus.ProtoReflect.Descriptor instead.
func (*AccessQuotaStatus) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{18}
}

func (x *AccessQuotaStatus) GetConsumed() int32 {
	if x != nil {
		return x.Consumed
	}
	return 0
}

func (x *AccessQuotaStatus) GetRemaining() int32 {
	if x != nil {
		return x.Remaining
	}
	return 0
}

// Sorts by metric values.
type AccessOrderBy_MetricOrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A metric name in the request to order by.
	MetricName string `protobuf:"bytes,1,opt,name=metric_name,json=metricName,proto3" json:"metric_name,omitempty"`
}

func (x *AccessOrderBy_MetricOrderBy) Reset() {
	*x = AccessOrderBy_MetricOrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessOrderBy_MetricOrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessOrderBy_MetricOrderBy) ProtoMessage() {}

func (x *AccessOrderBy_MetricOrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessOrderBy_MetricOrderBy.ProtoReflect.Descriptor instead.
func (*AccessOrderBy_MetricOrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{11, 0}
}

func (x *AccessOrderBy_MetricOrderBy) GetMetricName() string {
	if x != nil {
		return x.MetricName
	}
	return ""
}

// Sorts by dimension values.
type AccessOrderBy_DimensionOrderBy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A dimension name in the request to order by.
	DimensionName string `protobuf:"bytes,1,opt,name=dimension_name,json=dimensionName,proto3" json:"dimension_name,omitempty"`
	// Controls the rule for dimension value ordering.
	OrderType AccessOrderBy_DimensionOrderBy_OrderType `protobuf:"varint,2,opt,name=order_type,json=orderType,proto3,enum=google.analytics.admin.v1alpha.AccessOrderBy_DimensionOrderBy_OrderType" json:"order_type,omitempty"`
}

func (x *AccessOrderBy_DimensionOrderBy) Reset() {
	*x = AccessOrderBy_DimensionOrderBy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AccessOrderBy_DimensionOrderBy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessOrderBy_DimensionOrderBy) ProtoMessage() {}

func (x *AccessOrderBy_DimensionOrderBy) ProtoReflect() protoreflect.Message {
	mi := &file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessOrderBy_DimensionOrderBy.ProtoReflect.Descriptor instead.
func (*AccessOrderBy_DimensionOrderBy) Descriptor() ([]byte, []int) {
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP(), []int{11, 1}
}

func (x *AccessOrderBy_DimensionOrderBy) GetDimensionName() string {
	if x != nil {
		return x.DimensionName
	}
	return ""
}

func (x *AccessOrderBy_DimensionOrderBy) GetOrderType() AccessOrderBy_DimensionOrderBy_OrderType {
	if x != nil {
		return x.OrderType
	}
	return AccessOrderBy_DimensionOrderBy_ORDER_TYPE_UNSPECIFIED
}

var File_google_analytics_admin_v1alpha_access_report_proto protoreflect.FileDescriptor

var file_google_analytics_admin_v1alpha_access_report_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x22, 0x38, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x2f,
	0x0a, 0x0c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x1f,
	0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x22,
	0x4b, 0x0a, 0x0f, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x61, 0x74, 0x65, 0x52, 0x61, 0x6e,
	0x67, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x44, 0x61, 0x74,
	0x65, 0x12, 0x19, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x22, 0x94, 0x03, 0x0a,
	0x16, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70,
	0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x09, 0x61, 0x6e, 0x64, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x48, 0x00, 0x52, 0x08, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x57, 0x0a, 0x08, 0x6f, 0x72, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73, 0x74,
	0x48, 0x00, 0x52, 0x07, 0x6f, 0x72, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x5f, 0x0a, 0x0e, 0x6e,
	0x6f, 0x74, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x6e,
	0x6f, 0x74, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x0d,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x48, 0x00, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x42, 0x10, 0x0a, 0x0e, 0x6f, 0x6e, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x22, 0x76, 0x0a, 0x1a, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x4c, 0x69, 0x73,
	0x74, 0x12, 0x58, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0b,
	0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xae, 0x03, 0x0a, 0x0c,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x59, 0x0a, 0x0d,
	0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61,
	0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e,
	0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x5a, 0x0a, 0x0e, 0x69, 0x6e, 0x5f, 0x6c, 0x69,
	0x73, 0x74, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x49, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x48, 0x00, 0x52, 0x0c, 0x69, 0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x5c, 0x0a, 0x0e, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x48, 0x00, 0x52, 0x0d, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x5c, 0x0a, 0x0e, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x48, 0x00,
	0x52, 0x0d, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12,
	0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x0c,
	0x0a, 0x0a, 0x6f, 0x6e, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xb6, 0x02, 0x0a,
	0x12, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x5b, 0x0a, 0x0a, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53,
	0x74, 0x72, 0x69, 0x6e, 0x67, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73,
	0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d,
	0x63, 0x61, 0x73, 0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0x85, 0x01,
	0x0a, 0x09, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x4d,
	0x41, 0x54, 0x43, 0x48, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x58, 0x41, 0x43, 0x54,
	0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x45, 0x47, 0x49, 0x4e, 0x53, 0x5f, 0x57, 0x49, 0x54,
	0x48, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x45, 0x4e, 0x44, 0x53, 0x5f, 0x57, 0x49, 0x54, 0x48,
	0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x41, 0x49, 0x4e, 0x53, 0x10, 0x04,
	0x12, 0x0f, 0x0a, 0x0b, 0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x52, 0x45, 0x47, 0x45, 0x58, 0x50, 0x10,
	0x05, 0x12, 0x12, 0x0a, 0x0e, 0x50, 0x41, 0x52, 0x54, 0x49, 0x41, 0x4c, 0x5f, 0x52, 0x45, 0x47,
	0x45, 0x58, 0x50, 0x10, 0x06, 0x22, 0x53, 0x0a, 0x12, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x49,
	0x6e, 0x4c, 0x69, 0x73, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x63, 0x61, 0x73, 0x65, 0x5f, 0x73, 0x65, 0x6e, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x63, 0x61, 0x73,
	0x65, 0x53, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x22, 0xbe, 0x02, 0x0a, 0x13, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x5b, 0x0a, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x09, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x42, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
	0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e,
	0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x22, 0x85, 0x01, 0x0a, 0x09, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x19, 0x0a, 0x15, 0x4f, 0x50, 0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05,
	0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x4c, 0x45, 0x53, 0x53, 0x5f,
	0x54, 0x48, 0x41, 0x4e, 0x10, 0x02, 0x12, 0x16, 0x0a, 0x12, 0x4c, 0x45, 0x53, 0x53, 0x5f, 0x54,
	0x48, 0x41, 0x4e, 0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x03, 0x12, 0x10,
	0x0a, 0x0c, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e, 0x10, 0x04,
	0x12, 0x19, 0x0a, 0x15, 0x47, 0x52, 0x45, 0x41, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x48, 0x41, 0x4e,
	0x5f, 0x4f, 0x52, 0x5f, 0x45, 0x51, 0x55, 0x41, 0x4c, 0x10, 0x05, 0x22, 0xab, 0x01, 0x0a, 0x13,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x46, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x12, 0x4b, 0x0a, 0x0a, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x66, 0x72, 0x6f, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x12, 0x47, 0x0a, 0x08, 0x74, 0x6f, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c,
	0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c,
	0x70, 0x68, 0x61, 0x2e, 0x4e, 0x75, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x07, 0x74, 0x6f, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x63, 0x0a, 0x0c, 0x4e, 0x75, 0x6d,
	0x65, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0b, 0x69, 0x6e, 0x74,
	0x36, 0x34, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00,
	0x52, 0x0a, 0x69, 0x6e, 0x74, 0x36, 0x34, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x23, 0x0a, 0x0c,
	0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x0b, 0x0a, 0x09, 0x6f, 0x6e, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0xac,
	0x04, 0x0a, 0x0d, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x12, 0x55, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74,
	0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x48, 0x00, 0x52,
	0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x5e, 0x0a, 0x09, 0x64, 0x69, 0x6d, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x48, 0x00, 0x52, 0x09, 0x64, 0x69,
	0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x65, 0x73, 0x63, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64, 0x65, 0x73, 0x63, 0x1a, 0x30, 0x0a, 0x0d, 0x4d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x1f, 0x0a, 0x0b,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x8d, 0x02,
	0x0a, 0x10, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x64, 0x69, 0x6d, 0x65,
	0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x0a, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73,
	0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x44, 0x69, 0x6d,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x2e, 0x4f, 0x72,
	0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x52, 0x09, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x22, 0x69, 0x0a, 0x09, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x41,
	0x4c, 0x50, 0x48, 0x41, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x01, 0x12, 0x21, 0x0a,
	0x1d, 0x43, 0x41, 0x53, 0x45, 0x5f, 0x49, 0x4e, 0x53, 0x45, 0x4e, 0x53, 0x49, 0x54, 0x49, 0x56,
	0x45, 0x5f, 0x41, 0x4c, 0x50, 0x48, 0x41, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x02,
	0x12, 0x0b, 0x0a, 0x07, 0x4e, 0x55, 0x4d, 0x45, 0x52, 0x49, 0x43, 0x10, 0x03, 0x42, 0x0e, 0x0a,
	0x0c, 0x6f, 0x6e, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x22, 0x3e, 0x0a,
	0x15, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x35, 0x0a,
	0x12, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63,
	0x4e, 0x61, 0x6d, 0x65, 0x22, 0xc4, 0x01, 0x0a, 0x09, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x6f, 0x77, 0x12, 0x5f, 0x0a, 0x10, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x0d, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x6d,
	0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22, 0x2c, 0x0a, 0x14, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x29, 0x0a, 0x11, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x22, 0x94, 0x04, 0x0a, 0x0b, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x51,
	0x75, 0x6f, 0x74, 0x61, 0x12, 0x57, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x64, 0x61, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52,
	0x0c, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x44, 0x61, 0x79, 0x12, 0x59, 0x0a,
	0x0f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e,
	0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x51, 0x75,
	0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x73, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x62, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x63,
	0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76,
	0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x51, 0x75, 0x6f,
	0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x63, 0x75, 0x72,
	0x72, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x12, 0x7c, 0x0a, 0x22,
	0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x5f, 0x70, 0x65,
	0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f,
	0x75, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x1d, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x50, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x12, 0x6f, 0x0a, 0x1b, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x5f, 0x70, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x75, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x17, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x50, 0x65, 0x72, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x50, 0x65, 0x72, 0x48, 0x6f, 0x75, 0x72, 0x22, 0x4d, 0x0a, 0x11, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x51, 0x75, 0x6f, 0x74, 0x61, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x1a, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x12, 0x1c, 0x0a, 0x09,
	0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x42, 0x79, 0x0a, 0x22, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
	0x63, 0x73, 0x2e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61,
	0x42, 0x11, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x50, 0x72,
	0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x74, 0x69, 0x63, 0x73, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x70, 0x62, 0x3b, 0x61, 0x64,
	0x6d, 0x69, 0x6e, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_analytics_admin_v1alpha_access_report_proto_rawDescOnce sync.Once
	file_google_analytics_admin_v1alpha_access_report_proto_rawDescData = file_google_analytics_admin_v1alpha_access_report_proto_rawDesc
)

func file_google_analytics_admin_v1alpha_access_report_proto_rawDescGZIP() []byte {
	file_google_analytics_admin_v1alpha_access_report_proto_rawDescOnce.Do(func() {
		file_google_analytics_admin_v1alpha_access_report_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_analytics_admin_v1alpha_access_report_proto_rawDescData)
	})
	return file_google_analytics_admin_v1alpha_access_report_proto_rawDescData
}

var file_google_analytics_admin_v1alpha_access_report_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_analytics_admin_v1alpha_access_report_proto_msgTypes = make([]protoimpl.MessageInfo, 21)
var file_google_analytics_admin_v1alpha_access_report_proto_goTypes = []interface{}{
	(AccessStringFilter_MatchType)(0),             // 0: google.analytics.admin.v1alpha.AccessStringFilter.MatchType
	(AccessNumericFilter_Operation)(0),            // 1: google.analytics.admin.v1alpha.AccessNumericFilter.Operation
	(AccessOrderBy_DimensionOrderBy_OrderType)(0), // 2: google.analytics.admin.v1alpha.AccessOrderBy.DimensionOrderBy.OrderType
	(*AccessDimension)(nil),                       // 3: google.analytics.admin.v1alpha.AccessDimension
	(*AccessMetric)(nil),                          // 4: google.analytics.admin.v1alpha.AccessMetric
	(*AccessDateRange)(nil),                       // 5: google.analytics.admin.v1alpha.AccessDateRange
	(*AccessFilterExpression)(nil),                // 6: google.analytics.admin.v1alpha.AccessFilterExpression
	(*AccessFilterExpressionList)(nil),            // 7: google.analytics.admin.v1alpha.AccessFilterExpressionList
	(*AccessFilter)(nil),                          // 8: google.analytics.admin.v1alpha.AccessFilter
	(*AccessStringFilter)(nil),                    // 9: google.analytics.admin.v1alpha.AccessStringFilter
	(*AccessInListFilter)(nil),                    // 10: google.analytics.admin.v1alpha.AccessInListFilter
	(*AccessNumericFilter)(nil),                   // 11: google.analytics.admin.v1alpha.AccessNumericFilter
	(*AccessBetweenFilter)(nil),                   // 12: google.analytics.admin.v1alpha.AccessBetweenFilter
	(*NumericValue)(nil),                          // 13: google.analytics.admin.v1alpha.NumericValue
	(*AccessOrderBy)(nil),                         // 14: google.analytics.admin.v1alpha.AccessOrderBy
	(*AccessDimensionHeader)(nil),                 // 15: google.analytics.admin.v1alpha.AccessDimensionHeader
	(*AccessMetricHeader)(nil),                    // 16: google.analytics.admin.v1alpha.AccessMetricHeader
	(*AccessRow)(nil),                             // 17: google.analytics.admin.v1alpha.AccessRow
	(*AccessDimensionValue)(nil),                  // 18: google.analytics.admin.v1alpha.AccessDimensionValue
	(*AccessMetricValue)(nil),                     // 19: google.analytics.admin.v1alpha.AccessMetricValue
	(*AccessQuota)(nil),                           // 20: google.analytics.admin.v1alpha.AccessQuota
	(*AccessQuotaStatus)(nil),                     // 21: google.analytics.admin.v1alpha.AccessQuotaStatus
	(*AccessOrderBy_MetricOrderBy)(nil),           // 22: google.analytics.admin.v1alpha.AccessOrderBy.MetricOrderBy
	(*AccessOrderBy_DimensionOrderBy)(nil),        // 23: google.analytics.admin.v1alpha.AccessOrderBy.DimensionOrderBy
}
var file_google_analytics_admin_v1alpha_access_report_proto_depIdxs = []int32{
	7,  // 0: google.analytics.admin.v1alpha.AccessFilterExpression.and_group:type_name -> google.analytics.admin.v1alpha.AccessFilterExpressionList
	7,  // 1: google.analytics.admin.v1alpha.AccessFilterExpression.or_group:type_name -> google.analytics.admin.v1alpha.AccessFilterExpressionList
	6,  // 2: google.analytics.admin.v1alpha.AccessFilterExpression.not_expression:type_name -> google.analytics.admin.v1alpha.AccessFilterExpression
	8,  // 3: google.analytics.admin.v1alpha.AccessFilterExpression.access_filter:type_name -> google.analytics.admin.v1alpha.AccessFilter
	6,  // 4: google.analytics.admin.v1alpha.AccessFilterExpressionList.expressions:type_name -> google.analytics.admin.v1alpha.AccessFilterExpression
	9,  // 5: google.analytics.admin.v1alpha.AccessFilter.string_filter:type_name -> google.analytics.admin.v1alpha.AccessStringFilter
	10, // 6: google.analytics.admin.v1alpha.AccessFilter.in_list_filter:type_name -> google.analytics.admin.v1alpha.AccessInListFilter
	11, // 7: google.analytics.admin.v1alpha.AccessFilter.numeric_filter:type_name -> google.analytics.admin.v1alpha.AccessNumericFilter
	12, // 8: google.analytics.admin.v1alpha.AccessFilter.between_filter:type_name -> google.analytics.admin.v1alpha.AccessBetweenFilter
	0,  // 9: google.analytics.admin.v1alpha.AccessStringFilter.match_type:type_name -> google.analytics.admin.v1alpha.AccessStringFilter.MatchType
	1,  // 10: google.analytics.admin.v1alpha.AccessNumericFilter.operation:type_name -> google.analytics.admin.v1alpha.AccessNumericFilter.Operation
	13, // 11: google.analytics.admin.v1alpha.AccessNumericFilter.value:type_name -> google.analytics.admin.v1alpha.NumericValue
	13, // 12: google.analytics.admin.v1alpha.AccessBetweenFilter.from_value:type_name -> google.analytics.admin.v1alpha.NumericValue
	13, // 13: google.analytics.admin.v1alpha.AccessBetweenFilter.to_value:type_name -> google.analytics.admin.v1alpha.NumericValue
	22, // 14: google.analytics.admin.v1alpha.AccessOrderBy.metric:type_name -> google.analytics.admin.v1alpha.AccessOrderBy.MetricOrderBy
	23, // 15: google.analytics.admin.v1alpha.AccessOrderBy.dimension:type_name -> google.analytics.admin.v1alpha.AccessOrderBy.DimensionOrderBy
	18, // 16: google.analytics.admin.v1alpha.AccessRow.dimension_values:type_name -> google.analytics.admin.v1alpha.AccessDimensionValue
	19, // 17: google.analytics.admin.v1alpha.AccessRow.metric_values:type_name -> google.analytics.admin.v1alpha.AccessMetricValue
	21, // 18: google.analytics.admin.v1alpha.AccessQuota.tokens_per_day:type_name -> google.analytics.admin.v1alpha.AccessQuotaStatus
	21, // 19: google.analytics.admin.v1alpha.AccessQuota.tokens_per_hour:type_name -> google.analytics.admin.v1alpha.AccessQuotaStatus
	21, // 20: google.analytics.admin.v1alpha.AccessQuota.concurrent_requests:type_name -> google.analytics.admin.v1alpha.AccessQuotaStatus
	21, // 21: google.analytics.admin.v1alpha.AccessQuota.server_errors_per_project_per_hour:type_name -> google.analytics.admin.v1alpha.AccessQuotaStatus
	21, // 22: google.analytics.admin.v1alpha.AccessQuota.tokens_per_project_per_hour:type_name -> google.analytics.admin.v1alpha.AccessQuotaStatus
	2,  // 23: google.analytics.admin.v1alpha.AccessOrderBy.DimensionOrderBy.order_type:type_name -> google.analytics.admin.v1alpha.AccessOrderBy.DimensionOrderBy.OrderType
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_google_analytics_admin_v1alpha_access_report_proto_init() }
func file_google_analytics_admin_v1alpha_access_report_proto_init() {
	if File_google_analytics_admin_v1alpha_access_report_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessDimension); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessMetric); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessDateRange); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessFilterExpression); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessFilterExpressionList); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessStringFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessInListFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessNumericFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessBetweenFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NumericValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessOrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessDimensionHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessMetricHeader); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessRow); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessDimensionValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessMetricValue); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessQuota); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessQuotaStatus); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessOrderBy_MetricOrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AccessOrderBy_DimensionOrderBy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*AccessFilterExpression_AndGroup)(nil),
		(*AccessFilterExpression_OrGroup)(nil),
		(*AccessFilterExpression_NotExpression)(nil),
		(*AccessFilterExpression_AccessFilter)(nil),
	}
	file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[5].OneofWrappers = []interface{}{
		(*AccessFilter_StringFilter)(nil),
		(*AccessFilter_InListFilter)(nil),
		(*AccessFilter_NumericFilter)(nil),
		(*AccessFilter_BetweenFilter)(nil),
	}
	file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[10].OneofWrappers = []interface{}{
		(*NumericValue_Int64Value)(nil),
		(*NumericValue_DoubleValue)(nil),
	}
	file_google_analytics_admin_v1alpha_access_report_proto_msgTypes[11].OneofWrappers = []interface{}{
		(*AccessOrderBy_Metric)(nil),
		(*AccessOrderBy_Dimension)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_analytics_admin_v1alpha_access_report_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   21,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_analytics_admin_v1alpha_access_report_proto_goTypes,
		DependencyIndexes: file_google_analytics_admin_v1alpha_access_report_proto_depIdxs,
		EnumInfos:         file_google_analytics_admin_v1alpha_access_report_proto_enumTypes,
		MessageInfos:      file_google_analytics_admin_v1alpha_access_report_proto_msgTypes,
	}.Build()
	File_google_analytics_admin_v1alpha_access_report_proto = out.File
	file_google_analytics_admin_v1alpha_access_report_proto_rawDesc = nil
	file_google_analytics_admin_v1alpha_access_report_proto_goTypes = nil
	file_google_analytics_admin_v1alpha_access_report_proto_depIdxs = nil
}
