// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/automl/v1beta1/tables.proto

package automlpb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Metadata for a dataset used for AutoML Tables.
type TablesDatasetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The table_spec_id of the primary table of this dataset.
	PrimaryTableSpecId string `protobuf:"bytes,1,opt,name=primary_table_spec_id,json=primaryTableSpecId,proto3" json:"primary_table_spec_id,omitempty"`
	// column_spec_id of the primary table's column that should be used as the
	// training & prediction target.
	// This column must be non-nullable and have one of following data types
	// (otherwise model creation will error):
	//
	// * CATEGORY
	//
	// * FLOAT64
	//
	// If the type is CATEGORY , only up to
	// 100 unique values may exist in that column across all rows.
	//
	// NOTE: Updates of this field will instantly affect any other users
	// concurrently working with the dataset.
	TargetColumnSpecId string `protobuf:"bytes,2,opt,name=target_column_spec_id,json=targetColumnSpecId,proto3" json:"target_column_spec_id,omitempty"`
	// column_spec_id of the primary table's column that should be used as the
	// weight column, i.e. the higher the value the more important the row will be
	// during model training.
	// Required type: FLOAT64.
	// Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
	//                 ignored for training.
	// If not set all rows are assumed to have equal weight of 1.
	// NOTE: Updates of this field will instantly affect any other users
	// concurrently working with the dataset.
	WeightColumnSpecId string `protobuf:"bytes,3,opt,name=weight_column_spec_id,json=weightColumnSpecId,proto3" json:"weight_column_spec_id,omitempty"`
	// column_spec_id of the primary table column which specifies a possible ML
	// use of the row, i.e. the column will be used to split the rows into TRAIN,
	// VALIDATE and TEST sets.
	// Required type: STRING.
	// This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
	// among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
	// case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
	// that if a given ml use distribution makes it impossible to create a "good"
	// model, that call will error describing the issue.
	// If both this column_spec_id and primary table's time_column_spec_id are not
	// set, then all rows are treated as `UNASSIGNED`.
	// NOTE: Updates of this field will instantly affect any other users
	// concurrently working with the dataset.
	MlUseColumnSpecId string `protobuf:"bytes,4,opt,name=ml_use_column_spec_id,json=mlUseColumnSpecId,proto3" json:"ml_use_column_spec_id,omitempty"`
	// Output only. Correlations between
	//
	// [TablesDatasetMetadata.target_column_spec_id][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_spec_id],
	// and other columns of the
	//
	// [TablesDatasetMetadataprimary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
	// Only set if the target column is set. Mapping from other column spec id to
	// its CorrelationStats with the target column.
	// This field may be stale, see the stats_update_time field for
	// for the timestamp at which these stats were last updated.
	TargetColumnCorrelations map[string]*CorrelationStats `protobuf:"bytes,6,rep,name=target_column_correlations,json=targetColumnCorrelations,proto3" json:"target_column_correlations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The most recent timestamp when target_column_correlations
	// field and all descendant ColumnSpec.data_stats and
	// ColumnSpec.top_correlated_columns fields were last (re-)generated. Any
	// changes that happened to the dataset afterwards are not reflected in these
	// fields values. The regeneration happens in the background on a best effort
	// basis.
	StatsUpdateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=stats_update_time,json=statsUpdateTime,proto3" json:"stats_update_time,omitempty"`
}

func (x *TablesDatasetMetadata) Reset() {
	*x = TablesDatasetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesDatasetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesDatasetMetadata) ProtoMessage() {}

func (x *TablesDatasetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesDatasetMetadata.ProtoReflect.Descriptor instead.
func (*TablesDatasetMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_tables_proto_rawDescGZIP(), []int{0}
}

func (x *TablesDatasetMetadata) GetPrimaryTableSpecId() string {
	if x != nil {
		return x.PrimaryTableSpecId
	}
	return ""
}

func (x *TablesDatasetMetadata) GetTargetColumnSpecId() string {
	if x != nil {
		return x.TargetColumnSpecId
	}
	return ""
}

func (x *TablesDatasetMetadata) GetWeightColumnSpecId() string {
	if x != nil {
		return x.WeightColumnSpecId
	}
	return ""
}

func (x *TablesDatasetMetadata) GetMlUseColumnSpecId() string {
	if x != nil {
		return x.MlUseColumnSpecId
	}
	return ""
}

func (x *TablesDatasetMetadata) GetTargetColumnCorrelations() map[string]*CorrelationStats {
	if x != nil {
		return x.TargetColumnCorrelations
	}
	return nil
}

func (x *TablesDatasetMetadata) GetStatsUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StatsUpdateTime
	}
	return nil
}

// Model metadata specific to AutoML Tables.
type TablesModelMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Additional optimization objective configuration. Required for
	// `MAXIMIZE_PRECISION_AT_RECALL` and `MAXIMIZE_RECALL_AT_PRECISION`,
	// otherwise unused.
	//
	// Types that are assignable to AdditionalOptimizationObjectiveConfig:
	//	*TablesModelMetadata_OptimizationObjectiveRecallValue
	//	*TablesModelMetadata_OptimizationObjectivePrecisionValue
	AdditionalOptimizationObjectiveConfig isTablesModelMetadata_AdditionalOptimizationObjectiveConfig `protobuf_oneof:"additional_optimization_objective_config"`
	// Column spec of the dataset's primary table's column the model is
	// predicting. Snapshotted when model creation started.
	// Only 3 fields are used:
	// name - May be set on CreateModel, if it's not then the ColumnSpec
	//        corresponding to the current target_column_spec_id of the dataset
	//        the model is trained from is used.
	//        If neither is set, CreateModel will error.
	// display_name - Output only.
	// data_type - Output only.
	TargetColumnSpec *ColumnSpec `protobuf:"bytes,2,opt,name=target_column_spec,json=targetColumnSpec,proto3" json:"target_column_spec,omitempty"`
	// Column specs of the dataset's primary table's columns, on which
	// the model is trained and which are used as the input for predictions.
	// The
	//
	// [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// as well as, according to dataset's state upon model creation,
	//
	// [weight_column][google.cloud.automl.v1beta1.TablesDatasetMetadata.weight_column_spec_id],
	// and
	//
	// [ml_use_column][google.cloud.automl.v1beta1.TablesDatasetMetadata.ml_use_column_spec_id]
	// must never be included here.
	//
	// Only 3 fields are used:
	//
	// * name - May be set on CreateModel, if set only the columns specified are
	//   used, otherwise all primary table's columns (except the ones listed
	//   above) are used for the training and prediction input.
	//
	// * display_name - Output only.
	//
	// * data_type - Output only.
	InputFeatureColumnSpecs []*ColumnSpec `protobuf:"bytes,3,rep,name=input_feature_column_specs,json=inputFeatureColumnSpecs,proto3" json:"input_feature_column_specs,omitempty"`
	// Objective function the model is optimizing towards. The training process
	// creates a model that maximizes/minimizes the value of the objective
	// function over the validation set.
	//
	// The supported optimization objectives depend on the prediction type.
	// If the field is not set, a default objective function is used.
	//
	// CLASSIFICATION_BINARY:
	//   "MAXIMIZE_AU_ROC" (default) - Maximize the area under the receiver
	//                                 operating characteristic (ROC) curve.
	//   "MINIMIZE_LOG_LOSS" - Minimize log loss.
	//   "MAXIMIZE_AU_PRC" - Maximize the area under the precision-recall curve.
	//   "MAXIMIZE_PRECISION_AT_RECALL" - Maximize precision for a specified
	//                                   recall value.
	//   "MAXIMIZE_RECALL_AT_PRECISION" - Maximize recall for a specified
	//                                    precision value.
	//
	// CLASSIFICATION_MULTI_CLASS :
	//   "MINIMIZE_LOG_LOSS" (default) - Minimize log loss.
	//
	//
	// REGRESSION:
	//   "MINIMIZE_RMSE" (default) - Minimize root-mean-squared error (RMSE).
	//   "MINIMIZE_MAE" - Minimize mean-absolute error (MAE).
	//   "MINIMIZE_RMSLE" - Minimize root-mean-squared log error (RMSLE).
	OptimizationObjective string `protobuf:"bytes,4,opt,name=optimization_objective,json=optimizationObjective,proto3" json:"optimization_objective,omitempty"`
	// Output only. Auxiliary information for each of the
	// input_feature_column_specs with respect to this particular model.
	TablesModelColumnInfo []*TablesModelColumnInfo `protobuf:"bytes,5,rep,name=tables_model_column_info,json=tablesModelColumnInfo,proto3" json:"tables_model_column_info,omitempty"`
	// Required. The train budget of creating this model, expressed in milli node
	// hours i.e. 1,000 value in this field means 1 node hour.
	//
	// The training cost of the model will not exceed this budget. The final cost
	// will be attempted to be close to the budget, though may end up being (even)
	// noticeably smaller - at the backend's discretion. This especially may
	// happen when further model training ceases to provide any improvements.
	//
	// If the budget is set to a value known to be insufficient to train a
	// model for the given dataset, the training won't be attempted and
	// will error.
	//
	// The train budget must be between 1,000 and 72,000 milli node hours,
	// inclusive.
	TrainBudgetMilliNodeHours int64 `protobuf:"varint,6,opt,name=train_budget_milli_node_hours,json=trainBudgetMilliNodeHours,proto3" json:"train_budget_milli_node_hours,omitempty"`
	// Output only. The actual training cost of the model, expressed in milli
	// node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed
	// to not exceed the train budget.
	TrainCostMilliNodeHours int64 `protobuf:"varint,7,opt,name=train_cost_milli_node_hours,json=trainCostMilliNodeHours,proto3" json:"train_cost_milli_node_hours,omitempty"`
	// Use the entire training budget. This disables the early stopping feature.
	// By default, the early stopping feature is enabled, which means that AutoML
	// Tables might stop training before the entire training budget has been used.
	DisableEarlyStopping bool `protobuf:"varint,12,opt,name=disable_early_stopping,json=disableEarlyStopping,proto3" json:"disable_early_stopping,omitempty"`
}

func (x *TablesModelMetadata) Reset() {
	*x = TablesModelMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesModelMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesModelMetadata) ProtoMessage() {}

func (x *TablesModelMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesModelMetadata.ProtoReflect.Descriptor instead.
func (*TablesModelMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_tables_proto_rawDescGZIP(), []int{1}
}

func (m *TablesModelMetadata) GetAdditionalOptimizationObjectiveConfig() isTablesModelMetadata_AdditionalOptimizationObjectiveConfig {
	if m != nil {
		return m.AdditionalOptimizationObjectiveConfig
	}
	return nil
}

func (x *TablesModelMetadata) GetOptimizationObjectiveRecallValue() float32 {
	if x, ok := x.GetAdditionalOptimizationObjectiveConfig().(*TablesModelMetadata_OptimizationObjectiveRecallValue); ok {
		return x.OptimizationObjectiveRecallValue
	}
	return 0
}

func (x *TablesModelMetadata) GetOptimizationObjectivePrecisionValue() float32 {
	if x, ok := x.GetAdditionalOptimizationObjectiveConfig().(*TablesModelMetadata_OptimizationObjectivePrecisionValue); ok {
		return x.OptimizationObjectivePrecisionValue
	}
	return 0
}

func (x *TablesModelMetadata) GetTargetColumnSpec() *ColumnSpec {
	if x != nil {
		return x.TargetColumnSpec
	}
	return nil
}

func (x *TablesModelMetadata) GetInputFeatureColumnSpecs() []*ColumnSpec {
	if x != nil {
		return x.InputFeatureColumnSpecs
	}
	return nil
}

func (x *TablesModelMetadata) GetOptimizationObjective() string {
	if x != nil {
		return x.OptimizationObjective
	}
	return ""
}

func (x *TablesModelMetadata) GetTablesModelColumnInfo() []*TablesModelColumnInfo {
	if x != nil {
		return x.TablesModelColumnInfo
	}
	return nil
}

func (x *TablesModelMetadata) GetTrainBudgetMilliNodeHours() int64 {
	if x != nil {
		return x.TrainBudgetMilliNodeHours
	}
	return 0
}

func (x *TablesModelMetadata) GetTrainCostMilliNodeHours() int64 {
	if x != nil {
		return x.TrainCostMilliNodeHours
	}
	return 0
}

func (x *TablesModelMetadata) GetDisableEarlyStopping() bool {
	if x != nil {
		return x.DisableEarlyStopping
	}
	return false
}

type isTablesModelMetadata_AdditionalOptimizationObjectiveConfig interface {
	isTablesModelMetadata_AdditionalOptimizationObjectiveConfig()
}

type TablesModelMetadata_OptimizationObjectiveRecallValue struct {
	// Required when optimization_objective is "MAXIMIZE_PRECISION_AT_RECALL".
	// Must be between 0 and 1, inclusive.
	OptimizationObjectiveRecallValue float32 `protobuf:"fixed32,17,opt,name=optimization_objective_recall_value,json=optimizationObjectiveRecallValue,proto3,oneof"`
}

type TablesModelMetadata_OptimizationObjectivePrecisionValue struct {
	// Required when optimization_objective is "MAXIMIZE_RECALL_AT_PRECISION".
	// Must be between 0 and 1, inclusive.
	OptimizationObjectivePrecisionValue float32 `protobuf:"fixed32,18,opt,name=optimization_objective_precision_value,json=optimizationObjectivePrecisionValue,proto3,oneof"`
}

func (*TablesModelMetadata_OptimizationObjectiveRecallValue) isTablesModelMetadata_AdditionalOptimizationObjectiveConfig() {
}

func (*TablesModelMetadata_OptimizationObjectivePrecisionValue) isTablesModelMetadata_AdditionalOptimizationObjectiveConfig() {
}

// Contains annotation details specific to Tables.
type TablesAnnotation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. A confidence estimate between 0.0 and 1.0, inclusive. A higher
	// value means greater confidence in the returned value.
	// For
	//
	// [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// of FLOAT64 data type the score is not populated.
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// Output only. Only populated when
	//
	// [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// has FLOAT64 data type. An interval in which the exactly correct target
	// value has 95% chance to be in.
	PredictionInterval *DoubleRange `protobuf:"bytes,4,opt,name=prediction_interval,json=predictionInterval,proto3" json:"prediction_interval,omitempty"`
	// The predicted value of the row's
	//
	// [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
	// The value depends on the column's DataType:
	//
	// * CATEGORY - the predicted (with the above confidence `score`) CATEGORY
	//   value.
	//
	// * FLOAT64 - the predicted (with above `prediction_interval`) FLOAT64 value.
	Value *structpb.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Output only. Auxiliary information for each of the model's
	//
	// [input_feature_column_specs][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
	// with respect to this particular prediction.
	// If no other fields than
	//
	// [column_spec_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_spec_name]
	// and
	//
	// [column_display_name][google.cloud.automl.v1beta1.TablesModelColumnInfo.column_display_name]
	// would be populated, then this whole field is not.
	TablesModelColumnInfo []*TablesModelColumnInfo `protobuf:"bytes,3,rep,name=tables_model_column_info,json=tablesModelColumnInfo,proto3" json:"tables_model_column_info,omitempty"`
	// Output only. Stores the prediction score for the baseline example, which
	// is defined as the example with all values set to their baseline values.
	// This is used as part of the Sampled Shapley explanation of the model's
	// prediction. This field is populated only when feature importance is
	// requested. For regression models, this holds the baseline prediction for
	// the baseline example. For classification models, this holds the baseline
	// prediction for the baseline example for the argmax class.
	BaselineScore float32 `protobuf:"fixed32,5,opt,name=baseline_score,json=baselineScore,proto3" json:"baseline_score,omitempty"`
}

func (x *TablesAnnotation) Reset() {
	*x = TablesAnnotation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesAnnotation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesAnnotation) ProtoMessage() {}

func (x *TablesAnnotation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesAnnotation.ProtoReflect.Descriptor instead.
func (*TablesAnnotation) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_tables_proto_rawDescGZIP(), []int{2}
}

func (x *TablesAnnotation) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *TablesAnnotation) GetPredictionInterval() *DoubleRange {
	if x != nil {
		return x.PredictionInterval
	}
	return nil
}

func (x *TablesAnnotation) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *TablesAnnotation) GetTablesModelColumnInfo() []*TablesModelColumnInfo {
	if x != nil {
		return x.TablesModelColumnInfo
	}
	return nil
}

func (x *TablesAnnotation) GetBaselineScore() float32 {
	if x != nil {
		return x.BaselineScore
	}
	return 0
}

// An information specific to given column and Tables Model, in context
// of the Model and the predictions created by it.
type TablesModelColumnInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the ColumnSpec describing the column. Not
	// populated when this proto is outputted to BigQuery.
	ColumnSpecName string `protobuf:"bytes,1,opt,name=column_spec_name,json=columnSpecName,proto3" json:"column_spec_name,omitempty"`
	// Output only. The display name of the column (same as the display_name of
	// its ColumnSpec).
	ColumnDisplayName string `protobuf:"bytes,2,opt,name=column_display_name,json=columnDisplayName,proto3" json:"column_display_name,omitempty"`
	// Output only. When given as part of a Model (always populated):
	// Measurement of how much model predictions correctness on the TEST data
	// depend on values in this column. A value between 0 and 1, higher means
	// higher influence. These values are normalized - for all input feature
	// columns of a given model they add to 1.
	//
	// When given back by Predict (populated iff
	// [feature_importance
	// param][google.cloud.automl.v1beta1.PredictRequest.params] is set) or Batch
	// Predict (populated iff
	// [feature_importance][google.cloud.automl.v1beta1.PredictRequest.params]
	// param is set):
	// Measurement of how impactful for the prediction returned for the given row
	// the value in this column was. Specifically, the feature importance
	// specifies the marginal contribution that the feature made to the prediction
	// score compared to the baseline score. These values are computed using the
	// Sampled Shapley method.
	FeatureImportance float32 `protobuf:"fixed32,3,opt,name=feature_importance,json=featureImportance,proto3" json:"feature_importance,omitempty"`
}

func (x *TablesModelColumnInfo) Reset() {
	*x = TablesModelColumnInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TablesModelColumnInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TablesModelColumnInfo) ProtoMessage() {}

func (x *TablesModelColumnInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_automl_v1beta1_tables_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TablesModelColumnInfo.ProtoReflect.Descriptor instead.
func (*TablesModelColumnInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_automl_v1beta1_tables_proto_rawDescGZIP(), []int{3}
}

func (x *TablesModelColumnInfo) GetColumnSpecName() string {
	if x != nil {
		return x.ColumnSpecName
	}
	return ""
}

func (x *TablesModelColumnInfo) GetColumnDisplayName() string {
	if x != nil {
		return x.ColumnDisplayName
	}
	return ""
}

func (x *TablesModelColumnInfo) GetFeatureImportance() float32 {
	if x != nil {
		return x.FeatureImportance
	}
	return 0
}

var File_google_cloud_automl_v1beta1_tables_proto protoreflect.FileDescriptor

var file_google_cloud_automl_v1beta1_tables_proto_rawDesc = []byte{
	0x0a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x70,
	0x65, 0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x69, 0x74, 0x65, 0x6d, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x72, 0x65, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2a, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72,
	0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x04, 0x0a, 0x15, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x12, 0x31, 0x0a, 0x15, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x53, 0x70,
	0x65, 0x63, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x15, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x15, 0x77, 0x65, 0x69, 0x67, 0x68,
	0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x30, 0x0a, 0x15, 0x6d, 0x6c,
	0x5f, 0x75, 0x73, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63,
	0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x6c, 0x55, 0x73, 0x65,
	0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x49, 0x64, 0x12, 0x8e, 0x01, 0x0a,
	0x1a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x63,
	0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x18, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x0a,
	0x11, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x52, 0x0f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x7a, 0x0a, 0x1d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x43, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x53, 0x74, 0x61, 0x74, 0x73, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x80, 0x06, 0x0a, 0x13, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4f, 0x0a, 0x23, 0x6f, 0x70, 0x74,
	0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x72, 0x65, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x20, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x52,
	0x65, 0x63, 0x61, 0x6c, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x55, 0x0a, 0x26, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x02, 0x48, 0x00, 0x52, 0x23, 0x6f, 0x70,
	0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x50, 0x72, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x12, 0x55, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x63, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x43, 0x6f,
	0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x12, 0x64, 0x0a, 0x1a, 0x69, 0x6e, 0x70, 0x75,
	0x74, 0x5f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x53, 0x70, 0x65, 0x63, 0x52, 0x17, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x73, 0x12, 0x35,
	0x0a, 0x16, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6f,
	0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15,
	0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x6b, 0x0a, 0x18, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x5f,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x69, 0x6e, 0x66,
	0x6f, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x15, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x40, 0x0a, 0x1d, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x62, 0x75, 0x64, 0x67,
	0x65, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x68, 0x6f,
	0x75, 0x72, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52, 0x19, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x42, 0x75, 0x64, 0x67, 0x65, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f, 0x64, 0x65, 0x48,
	0x6f, 0x75, 0x72, 0x73, 0x12, 0x3c, 0x0a, 0x1b, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x63, 0x6f,
	0x73, 0x74, 0x5f, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x68, 0x6f,
	0x75, 0x72, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x17, 0x74, 0x72, 0x61, 0x69, 0x6e,
	0x43, 0x6f, 0x73, 0x74, 0x4d, 0x69, 0x6c, 0x6c, 0x69, 0x4e, 0x6f, 0x64, 0x65, 0x48, 0x6f, 0x75,
	0x72, 0x73, 0x12, 0x34, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x65, 0x61,
	0x72, 0x6c, 0x79, 0x5f, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x14, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x45, 0x61, 0x72, 0x6c, 0x79,
	0x53, 0x74, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x42, 0x2a, 0x0a, 0x28, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6d, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x22, 0xc5, 0x02, 0x0a, 0x10, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x41,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f,
	0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12,
	0x59, 0x0a, 0x13, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f,
	0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x44, 0x6f, 0x75, 0x62, 0x6c,
	0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x52, 0x12, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x6b, 0x0a, 0x18, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x15,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x25, 0x0a, 0x0e, 0x62, 0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0d, 0x62,
	0x61, 0x73, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x22, 0xa0, 0x01, 0x0a,
	0x15, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x43, 0x6f, 0x6c, 0x75,
	0x6d, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x28, 0x0a, 0x10, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
	0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0e, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2e, 0x0a, 0x13, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x63,
	0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x2d, 0x0a, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x11, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42,
	0x9b, 0x01, 0x0a, 0x1f, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x37, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6d,
	0x6c, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x75, 0x74,
	0x6f, 0x6d, 0x6c, 0x70, 0x62, 0x3b, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6c, 0x70, 0x62, 0xca, 0x02,
	0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x6c, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x75,
	0x74, 0x6f, 0x4d, 0x4c, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_automl_v1beta1_tables_proto_rawDescOnce sync.Once
	file_google_cloud_automl_v1beta1_tables_proto_rawDescData = file_google_cloud_automl_v1beta1_tables_proto_rawDesc
)

func file_google_cloud_automl_v1beta1_tables_proto_rawDescGZIP() []byte {
	file_google_cloud_automl_v1beta1_tables_proto_rawDescOnce.Do(func() {
		file_google_cloud_automl_v1beta1_tables_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_automl_v1beta1_tables_proto_rawDescData)
	})
	return file_google_cloud_automl_v1beta1_tables_proto_rawDescData
}

var file_google_cloud_automl_v1beta1_tables_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_google_cloud_automl_v1beta1_tables_proto_goTypes = []interface{}{
	(*TablesDatasetMetadata)(nil), // 0: google.cloud.automl.v1beta1.TablesDatasetMetadata
	(*TablesModelMetadata)(nil),   // 1: google.cloud.automl.v1beta1.TablesModelMetadata
	(*TablesAnnotation)(nil),      // 2: google.cloud.automl.v1beta1.TablesAnnotation
	(*TablesModelColumnInfo)(nil), // 3: google.cloud.automl.v1beta1.TablesModelColumnInfo
	nil,                           // 4: google.cloud.automl.v1beta1.TablesDatasetMetadata.TargetColumnCorrelationsEntry
	(*timestamppb.Timestamp)(nil), // 5: google.protobuf.Timestamp
	(*ColumnSpec)(nil),            // 6: google.cloud.automl.v1beta1.ColumnSpec
	(*DoubleRange)(nil),           // 7: google.cloud.automl.v1beta1.DoubleRange
	(*structpb.Value)(nil),        // 8: google.protobuf.Value
	(*CorrelationStats)(nil),      // 9: google.cloud.automl.v1beta1.CorrelationStats
}
var file_google_cloud_automl_v1beta1_tables_proto_depIdxs = []int32{
	4, // 0: google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column_correlations:type_name -> google.cloud.automl.v1beta1.TablesDatasetMetadata.TargetColumnCorrelationsEntry
	5, // 1: google.cloud.automl.v1beta1.TablesDatasetMetadata.stats_update_time:type_name -> google.protobuf.Timestamp
	6, // 2: google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec:type_name -> google.cloud.automl.v1beta1.ColumnSpec
	6, // 3: google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs:type_name -> google.cloud.automl.v1beta1.ColumnSpec
	3, // 4: google.cloud.automl.v1beta1.TablesModelMetadata.tables_model_column_info:type_name -> google.cloud.automl.v1beta1.TablesModelColumnInfo
	7, // 5: google.cloud.automl.v1beta1.TablesAnnotation.prediction_interval:type_name -> google.cloud.automl.v1beta1.DoubleRange
	8, // 6: google.cloud.automl.v1beta1.TablesAnnotation.value:type_name -> google.protobuf.Value
	3, // 7: google.cloud.automl.v1beta1.TablesAnnotation.tables_model_column_info:type_name -> google.cloud.automl.v1beta1.TablesModelColumnInfo
	9, // 8: google.cloud.automl.v1beta1.TablesDatasetMetadata.TargetColumnCorrelationsEntry.value:type_name -> google.cloud.automl.v1beta1.CorrelationStats
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_automl_v1beta1_tables_proto_init() }
func file_google_cloud_automl_v1beta1_tables_proto_init() {
	if File_google_cloud_automl_v1beta1_tables_proto != nil {
		return
	}
	file_google_cloud_automl_v1beta1_classification_proto_init()
	file_google_cloud_automl_v1beta1_column_spec_proto_init()
	file_google_cloud_automl_v1beta1_data_items_proto_init()
	file_google_cloud_automl_v1beta1_data_stats_proto_init()
	file_google_cloud_automl_v1beta1_ranges_proto_init()
	file_google_cloud_automl_v1beta1_regression_proto_init()
	file_google_cloud_automl_v1beta1_temporal_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_automl_v1beta1_tables_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesDatasetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1beta1_tables_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesModelMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1beta1_tables_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesAnnotation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_automl_v1beta1_tables_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TablesModelColumnInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_automl_v1beta1_tables_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*TablesModelMetadata_OptimizationObjectiveRecallValue)(nil),
		(*TablesModelMetadata_OptimizationObjectivePrecisionValue)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_automl_v1beta1_tables_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_automl_v1beta1_tables_proto_goTypes,
		DependencyIndexes: file_google_cloud_automl_v1beta1_tables_proto_depIdxs,
		MessageInfos:      file_google_cloud_automl_v1beta1_tables_proto_msgTypes,
	}.Build()
	File_google_cloud_automl_v1beta1_tables_proto = out.File
	file_google_cloud_automl_v1beta1_tables_proto_rawDesc = nil
	file_google_cloud_automl_v1beta1_tables_proto_goTypes = nil
	file_google_cloud_automl_v1beta1_tables_proto_depIdxs = nil
}
