// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/bigquery/reservation/v1/reservation.proto

package reservationpb

import (
	iampb "cloud.google.com/go/iam/apiv1/iampb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ReservationService_CreateReservation_FullMethodName        = "/google.cloud.bigquery.reservation.v1.ReservationService/CreateReservation"
	ReservationService_ListReservations_FullMethodName         = "/google.cloud.bigquery.reservation.v1.ReservationService/ListReservations"
	ReservationService_GetReservation_FullMethodName           = "/google.cloud.bigquery.reservation.v1.ReservationService/GetReservation"
	ReservationService_DeleteReservation_FullMethodName        = "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteReservation"
	ReservationService_UpdateReservation_FullMethodName        = "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateReservation"
	ReservationService_FailoverReservation_FullMethodName      = "/google.cloud.bigquery.reservation.v1.ReservationService/FailoverReservation"
	ReservationService_CreateCapacityCommitment_FullMethodName = "/google.cloud.bigquery.reservation.v1.ReservationService/CreateCapacityCommitment"
	ReservationService_ListCapacityCommitments_FullMethodName  = "/google.cloud.bigquery.reservation.v1.ReservationService/ListCapacityCommitments"
	ReservationService_GetCapacityCommitment_FullMethodName    = "/google.cloud.bigquery.reservation.v1.ReservationService/GetCapacityCommitment"
	ReservationService_DeleteCapacityCommitment_FullMethodName = "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteCapacityCommitment"
	ReservationService_UpdateCapacityCommitment_FullMethodName = "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateCapacityCommitment"
	ReservationService_SplitCapacityCommitment_FullMethodName  = "/google.cloud.bigquery.reservation.v1.ReservationService/SplitCapacityCommitment"
	ReservationService_MergeCapacityCommitments_FullMethodName = "/google.cloud.bigquery.reservation.v1.ReservationService/MergeCapacityCommitments"
	ReservationService_CreateAssignment_FullMethodName         = "/google.cloud.bigquery.reservation.v1.ReservationService/CreateAssignment"
	ReservationService_ListAssignments_FullMethodName          = "/google.cloud.bigquery.reservation.v1.ReservationService/ListAssignments"
	ReservationService_DeleteAssignment_FullMethodName         = "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteAssignment"
	ReservationService_SearchAssignments_FullMethodName        = "/google.cloud.bigquery.reservation.v1.ReservationService/SearchAssignments"
	ReservationService_SearchAllAssignments_FullMethodName     = "/google.cloud.bigquery.reservation.v1.ReservationService/SearchAllAssignments"
	ReservationService_MoveAssignment_FullMethodName           = "/google.cloud.bigquery.reservation.v1.ReservationService/MoveAssignment"
	ReservationService_UpdateAssignment_FullMethodName         = "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateAssignment"
	ReservationService_GetBiReservation_FullMethodName         = "/google.cloud.bigquery.reservation.v1.ReservationService/GetBiReservation"
	ReservationService_UpdateBiReservation_FullMethodName      = "/google.cloud.bigquery.reservation.v1.ReservationService/UpdateBiReservation"
	ReservationService_GetIamPolicy_FullMethodName             = "/google.cloud.bigquery.reservation.v1.ReservationService/GetIamPolicy"
	ReservationService_SetIamPolicy_FullMethodName             = "/google.cloud.bigquery.reservation.v1.ReservationService/SetIamPolicy"
	ReservationService_TestIamPermissions_FullMethodName       = "/google.cloud.bigquery.reservation.v1.ReservationService/TestIamPermissions"
	ReservationService_CreateReservationGroup_FullMethodName   = "/google.cloud.bigquery.reservation.v1.ReservationService/CreateReservationGroup"
	ReservationService_GetReservationGroup_FullMethodName      = "/google.cloud.bigquery.reservation.v1.ReservationService/GetReservationGroup"
	ReservationService_DeleteReservationGroup_FullMethodName   = "/google.cloud.bigquery.reservation.v1.ReservationService/DeleteReservationGroup"
	ReservationService_ListReservationGroups_FullMethodName    = "/google.cloud.bigquery.reservation.v1.ReservationService/ListReservationGroups"
)

// ReservationServiceClient is the client API for ReservationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ReservationServiceClient interface {
	// Creates a new reservation resource.
	CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Fail over a reservation to the secondary location. The operation should be
	// done in the current secondary location, which will be promoted to the
	// new primary location for the reservation.
	// Attempting to failover a reservation in the current primary location will
	// fail with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	FailoverReservation(ctx context.Context, in *FailoverReservationRequest, opts ...grpc.CallOption) (*Reservation, error)
	// Creates a new capacity commitment resource.
	CreateCapacityCommitment(ctx context.Context, in *CreateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only `plan` and `renewal_plan` fields can be updated.
	//
	// Plan can only be changed to a plan of a longer commitment period.
	// Attempting to change to a plan with shorter commitment period will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// `commitment_end_time`.
	//
	// A common use case is to enable downgrading commitments.
	//
	// For example, in order to downgrade from 10000 slots to 8000, you might
	// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
	// you delete the first one after the commitment end time passes.
	SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into a single commitment.
	//
	// The resulting capacity commitment has the greater commitment_end_time
	// out of the to-be-merged capacity commitments.
	//
	// Attempting to merge capacity commitments of different plan will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error)
	// Creates an assignment object which allows the given project to submit jobs
	// of a certain type using slots from the specified reservation.
	//
	// Currently a
	// resource (project, folder, organization) can only have one assignment per
	// each (job_type, location) combination, and that reservation will be used
	// for all jobs of the matching type.
	//
	// Different assignments can be created on different levels of the
	// projects, folders or organization hierarchy.  During query execution,
	// the assignment is looked up at the project, folder and organization levels
	// in that order. The first assignment found is applied to the query.
	//
	// When creating assignments, it does not matter if other assignments exist at
	// higher levels.
	//
	// Example:
	//
	//   - The organization `organizationA` contains two projects, `project1`
	//     and `project2`.
	//   - Assignments for all three entities (`organizationA`, `project1`, and
	//     `project2`) could all be created and mapped to the same or different
	//     reservations.
	//
	// "None" assignments represent an absence of the assignment. Projects
	// assigned to None use on-demand pricing. To create a "None" assignment, use
	// "none" as a reservation_id in the parent. Example parent:
	// `projects/myproject/locations/US/reservations/none`.
	//
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	//
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Lists assignments.
	//
	// Only explicitly created assignments will be returned.
	//
	// Example:
	//
	//   - Organization `organizationA` contains two projects, `project1` and
	//     `project2`.
	//   - Reservation `res1` exists and was created previously.
	//   - CreateAssignment was used previously to define the following
	//     associations between entities and reservations: `<organizationA, res1>`
	//     and `<project1, res1>`
	//
	// In this example, ListAssignments will just return the above two assignments
	// for reservation `res1`, and no expansion/merge will happen.
	//
	// The wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed.
	//
	// **Note** "-" cannot be used for projects nor locations.
	ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	//
	// Example:
	//
	//   - Organization `organizationA` contains two projects, `project1` and
	//     `project2`.
	//   - Reservation `res1` exists and was created previously.
	//   - CreateAssignment was used previously to define the following
	//     associations between entities and reservations: `<organizationA, res1>`
	//     and `<project1, res1>`
	//
	// In this example, deletion of the `<organizationA, res1>` assignment won't
	// affect the other assignment `<project1, res1>`. After said deletion,
	// queries from `project1` will still use `res1` while queries from
	// `project2` will switch to use on-demand mode.
	DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Deprecated: Looks up assignments for a specified resource for a particular
	// region. If the request is about a project:
	//
	//  1. Assignments created on the project will be returned if they exist.
	//  2. Otherwise assignments created on the closest ancestor will be
	//     returned.
	//  3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	//  1. permission on the assignee will be verified in this API.
	//  2. Hierarchy lookup (project->folder->organization) happens in this API.
	//  3. Parent here is `projects/*/locations/*`, instead of
	//     `projects/*/locations/*reservations/*`.
	//
	// **Note** "-" cannot be used for projects
	// nor locations.
	SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//
	//  1. Assignments created on the project will be returned if they exist.
	//  2. Otherwise assignments created on the closest ancestor will be
	//     returned.
	//  3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	//  1. permission on the assignee will be verified in this API.
	//  2. Hierarchy lookup (project->folder->organization) happens in this API.
	//  3. Parent here is `projects/*/locations/*`, instead of
	//     `projects/*/locations/*reservations/*`.
	SearchAllAssignments(ctx context.Context, in *SearchAllAssignmentsRequest, opts ...grpc.CallOption) (*SearchAllAssignmentsResponse, error)
	// Moves an assignment under a new reservation.
	//
	// This differs from removing an existing assignment and recreating a new one
	// by providing a transactional change that ensures an assignee always has an
	// associated reservation.
	MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Updates an existing assignment.
	//
	// Only the `priority` field can be updated.
	UpdateAssignment(ctx context.Context, in *UpdateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
	// Updates a BI reservation.
	//
	// Only fields specified in the `field_mask` are updated.
	//
	// A singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error)
	// Gets the access control policy for a resource.
	// May return:
	//
	//   - A`NOT_FOUND` error if the resource doesn't exist or you don't have the
	//     permission to view it.
	//   - An empty policy if the resource exists but doesn't have a set policy.
	//
	// Supported resources are:
	// - Reservations
	// - ReservationAssignments
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	// - `bigqueryreservation.reservations.getIamPolicy` to get policies on
	// reservations.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Sets an access control policy for a resource. Replaces any existing
	// policy.
	//
	// Supported resources are:
	// - Reservations
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	// - `bigqueryreservation.reservations.setIamPolicy` to set policies on
	// reservations.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets your permissions on a resource. Returns an empty set of permissions if
	// the resource doesn't exist.
	//
	// Supported resources are:
	// - Reservations
	//
	// No Google IAM permissions are required to call this method.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Creates a new reservation group.
	CreateReservationGroup(ctx context.Context, in *CreateReservationGroupRequest, opts ...grpc.CallOption) (*ReservationGroup, error)
	// Returns information about the reservation group.
	GetReservationGroup(ctx context.Context, in *GetReservationGroupRequest, opts ...grpc.CallOption) (*ReservationGroup, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservationGroup(ctx context.Context, in *DeleteReservationGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists all the reservation groups for the project in the specified location.
	ListReservationGroups(ctx context.Context, in *ListReservationGroupsRequest, opts ...grpc.CallOption) (*ListReservationGroupsResponse, error)
}

type reservationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewReservationServiceClient(cc grpc.ClientConnInterface) ReservationServiceClient {
	return &reservationServiceClient{cc}
}

func (c *reservationServiceClient) CreateReservation(ctx context.Context, in *CreateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, ReservationService_CreateReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListReservations(ctx context.Context, in *ListReservationsRequest, opts ...grpc.CallOption) (*ListReservationsResponse, error) {
	out := new(ListReservationsResponse)
	err := c.cc.Invoke(ctx, ReservationService_ListReservations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetReservation(ctx context.Context, in *GetReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, ReservationService_GetReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteReservation(ctx context.Context, in *DeleteReservationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ReservationService_DeleteReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateReservation(ctx context.Context, in *UpdateReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, ReservationService_UpdateReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) FailoverReservation(ctx context.Context, in *FailoverReservationRequest, opts ...grpc.CallOption) (*Reservation, error) {
	out := new(Reservation)
	err := c.cc.Invoke(ctx, ReservationService_FailoverReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateCapacityCommitment(ctx context.Context, in *CreateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, ReservationService_CreateCapacityCommitment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListCapacityCommitments(ctx context.Context, in *ListCapacityCommitmentsRequest, opts ...grpc.CallOption) (*ListCapacityCommitmentsResponse, error) {
	out := new(ListCapacityCommitmentsResponse)
	err := c.cc.Invoke(ctx, ReservationService_ListCapacityCommitments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetCapacityCommitment(ctx context.Context, in *GetCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, ReservationService_GetCapacityCommitment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteCapacityCommitment(ctx context.Context, in *DeleteCapacityCommitmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ReservationService_DeleteCapacityCommitment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateCapacityCommitment(ctx context.Context, in *UpdateCapacityCommitmentRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, ReservationService_UpdateCapacityCommitment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SplitCapacityCommitment(ctx context.Context, in *SplitCapacityCommitmentRequest, opts ...grpc.CallOption) (*SplitCapacityCommitmentResponse, error) {
	out := new(SplitCapacityCommitmentResponse)
	err := c.cc.Invoke(ctx, ReservationService_SplitCapacityCommitment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MergeCapacityCommitments(ctx context.Context, in *MergeCapacityCommitmentsRequest, opts ...grpc.CallOption) (*CapacityCommitment, error) {
	out := new(CapacityCommitment)
	err := c.cc.Invoke(ctx, ReservationService_MergeCapacityCommitments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateAssignment(ctx context.Context, in *CreateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, ReservationService_CreateAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListAssignments(ctx context.Context, in *ListAssignmentsRequest, opts ...grpc.CallOption) (*ListAssignmentsResponse, error) {
	out := new(ListAssignmentsResponse)
	err := c.cc.Invoke(ctx, ReservationService_ListAssignments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteAssignment(ctx context.Context, in *DeleteAssignmentRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ReservationService_DeleteAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *reservationServiceClient) SearchAssignments(ctx context.Context, in *SearchAssignmentsRequest, opts ...grpc.CallOption) (*SearchAssignmentsResponse, error) {
	out := new(SearchAssignmentsResponse)
	err := c.cc.Invoke(ctx, ReservationService_SearchAssignments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SearchAllAssignments(ctx context.Context, in *SearchAllAssignmentsRequest, opts ...grpc.CallOption) (*SearchAllAssignmentsResponse, error) {
	out := new(SearchAllAssignmentsResponse)
	err := c.cc.Invoke(ctx, ReservationService_SearchAllAssignments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) MoveAssignment(ctx context.Context, in *MoveAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, ReservationService_MoveAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateAssignment(ctx context.Context, in *UpdateAssignmentRequest, opts ...grpc.CallOption) (*Assignment, error) {
	out := new(Assignment)
	err := c.cc.Invoke(ctx, ReservationService_UpdateAssignment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetBiReservation(ctx context.Context, in *GetBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, ReservationService_GetBiReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) UpdateBiReservation(ctx context.Context, in *UpdateBiReservationRequest, opts ...grpc.CallOption) (*BiReservation, error) {
	out := new(BiReservation)
	err := c.cc.Invoke(ctx, ReservationService_UpdateBiReservation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ReservationService_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ReservationService_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, ReservationService_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) CreateReservationGroup(ctx context.Context, in *CreateReservationGroupRequest, opts ...grpc.CallOption) (*ReservationGroup, error) {
	out := new(ReservationGroup)
	err := c.cc.Invoke(ctx, ReservationService_CreateReservationGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) GetReservationGroup(ctx context.Context, in *GetReservationGroupRequest, opts ...grpc.CallOption) (*ReservationGroup, error) {
	out := new(ReservationGroup)
	err := c.cc.Invoke(ctx, ReservationService_GetReservationGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) DeleteReservationGroup(ctx context.Context, in *DeleteReservationGroupRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ReservationService_DeleteReservationGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *reservationServiceClient) ListReservationGroups(ctx context.Context, in *ListReservationGroupsRequest, opts ...grpc.CallOption) (*ListReservationGroupsResponse, error) {
	out := new(ListReservationGroupsResponse)
	err := c.cc.Invoke(ctx, ReservationService_ListReservationGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ReservationServiceServer is the server API for ReservationService service.
// All implementations should embed UnimplementedReservationServiceServer
// for forward compatibility
type ReservationServiceServer interface {
	// Creates a new reservation resource.
	CreateReservation(context.Context, *CreateReservationRequest) (*Reservation, error)
	// Lists all the reservations for the project in the specified location.
	ListReservations(context.Context, *ListReservationsRequest) (*ListReservationsResponse, error)
	// Returns information about the reservation.
	GetReservation(context.Context, *GetReservationRequest) (*Reservation, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservation(context.Context, *DeleteReservationRequest) (*emptypb.Empty, error)
	// Updates an existing reservation resource.
	UpdateReservation(context.Context, *UpdateReservationRequest) (*Reservation, error)
	// Fail over a reservation to the secondary location. The operation should be
	// done in the current secondary location, which will be promoted to the
	// new primary location for the reservation.
	// Attempting to failover a reservation in the current primary location will
	// fail with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	FailoverReservation(context.Context, *FailoverReservationRequest) (*Reservation, error)
	// Creates a new capacity commitment resource.
	CreateCapacityCommitment(context.Context, *CreateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Lists all the capacity commitments for the admin project.
	ListCapacityCommitments(context.Context, *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error)
	// Returns information about the capacity commitment.
	GetCapacityCommitment(context.Context, *GetCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Deletes a capacity commitment. Attempting to delete capacity commitment
	// before its commitment_end_time will fail with the error code
	// `google.rpc.Code.FAILED_PRECONDITION`.
	DeleteCapacityCommitment(context.Context, *DeleteCapacityCommitmentRequest) (*emptypb.Empty, error)
	// Updates an existing capacity commitment.
	//
	// Only `plan` and `renewal_plan` fields can be updated.
	//
	// Plan can only be changed to a plan of a longer commitment period.
	// Attempting to change to a plan with shorter commitment period will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	UpdateCapacityCommitment(context.Context, *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error)
	// Splits capacity commitment to two commitments of the same plan and
	// `commitment_end_time`.
	//
	// A common use case is to enable downgrading commitments.
	//
	// For example, in order to downgrade from 10000 slots to 8000, you might
	// split a 10000 capacity commitment into commitments of 2000 and 8000. Then,
	// you delete the first one after the commitment end time passes.
	SplitCapacityCommitment(context.Context, *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error)
	// Merges capacity commitments of the same plan into a single commitment.
	//
	// The resulting capacity commitment has the greater commitment_end_time
	// out of the to-be-merged capacity commitments.
	//
	// Attempting to merge capacity commitments of different plan will fail
	// with the error code `google.rpc.Code.FAILED_PRECONDITION`.
	MergeCapacityCommitments(context.Context, *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error)
	// Creates an assignment object which allows the given project to submit jobs
	// of a certain type using slots from the specified reservation.
	//
	// Currently a
	// resource (project, folder, organization) can only have one assignment per
	// each (job_type, location) combination, and that reservation will be used
	// for all jobs of the matching type.
	//
	// Different assignments can be created on different levels of the
	// projects, folders or organization hierarchy.  During query execution,
	// the assignment is looked up at the project, folder and organization levels
	// in that order. The first assignment found is applied to the query.
	//
	// When creating assignments, it does not matter if other assignments exist at
	// higher levels.
	//
	// Example:
	//
	//   - The organization `organizationA` contains two projects, `project1`
	//     and `project2`.
	//   - Assignments for all three entities (`organizationA`, `project1`, and
	//     `project2`) could all be created and mapped to the same or different
	//     reservations.
	//
	// "None" assignments represent an absence of the assignment. Projects
	// assigned to None use on-demand pricing. To create a "None" assignment, use
	// "none" as a reservation_id in the parent. Example parent:
	// `projects/myproject/locations/US/reservations/none`.
	//
	// Returns `google.rpc.Code.PERMISSION_DENIED` if user does not have
	// 'bigquery.admin' permissions on the project using the reservation
	// and the project that owns this reservation.
	//
	// Returns `google.rpc.Code.INVALID_ARGUMENT` when location of the assignment
	// does not match location of the reservation.
	CreateAssignment(context.Context, *CreateAssignmentRequest) (*Assignment, error)
	// Lists assignments.
	//
	// Only explicitly created assignments will be returned.
	//
	// Example:
	//
	//   - Organization `organizationA` contains two projects, `project1` and
	//     `project2`.
	//   - Reservation `res1` exists and was created previously.
	//   - CreateAssignment was used previously to define the following
	//     associations between entities and reservations: `<organizationA, res1>`
	//     and `<project1, res1>`
	//
	// In this example, ListAssignments will just return the above two assignments
	// for reservation `res1`, and no expansion/merge will happen.
	//
	// The wildcard "-" can be used for
	// reservations in the request. In that case all assignments belongs to the
	// specified project and location will be listed.
	//
	// **Note** "-" cannot be used for projects nor locations.
	ListAssignments(context.Context, *ListAssignmentsRequest) (*ListAssignmentsResponse, error)
	// Deletes a assignment. No expansion will happen.
	//
	// Example:
	//
	//   - Organization `organizationA` contains two projects, `project1` and
	//     `project2`.
	//   - Reservation `res1` exists and was created previously.
	//   - CreateAssignment was used previously to define the following
	//     associations between entities and reservations: `<organizationA, res1>`
	//     and `<project1, res1>`
	//
	// In this example, deletion of the `<organizationA, res1>` assignment won't
	// affect the other assignment `<project1, res1>`. After said deletion,
	// queries from `project1` will still use `res1` while queries from
	// `project2` will switch to use on-demand mode.
	DeleteAssignment(context.Context, *DeleteAssignmentRequest) (*emptypb.Empty, error)
	// Deprecated: Do not use.
	// Deprecated: Looks up assignments for a specified resource for a particular
	// region. If the request is about a project:
	//
	//  1. Assignments created on the project will be returned if they exist.
	//  2. Otherwise assignments created on the closest ancestor will be
	//     returned.
	//  3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	//  1. permission on the assignee will be verified in this API.
	//  2. Hierarchy lookup (project->folder->organization) happens in this API.
	//  3. Parent here is `projects/*/locations/*`, instead of
	//     `projects/*/locations/*reservations/*`.
	//
	// **Note** "-" cannot be used for projects
	// nor locations.
	SearchAssignments(context.Context, *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error)
	// Looks up assignments for a specified resource for a particular region.
	// If the request is about a project:
	//
	//  1. Assignments created on the project will be returned if they exist.
	//  2. Otherwise assignments created on the closest ancestor will be
	//     returned.
	//  3. Assignments for different JobTypes will all be returned.
	//
	// The same logic applies if the request is about a folder.
	//
	// If the request is about an organization, then assignments created on the
	// organization will be returned (organization doesn't have ancestors).
	//
	// Comparing to ListAssignments, there are some behavior
	// differences:
	//
	//  1. permission on the assignee will be verified in this API.
	//  2. Hierarchy lookup (project->folder->organization) happens in this API.
	//  3. Parent here is `projects/*/locations/*`, instead of
	//     `projects/*/locations/*reservations/*`.
	SearchAllAssignments(context.Context, *SearchAllAssignmentsRequest) (*SearchAllAssignmentsResponse, error)
	// Moves an assignment under a new reservation.
	//
	// This differs from removing an existing assignment and recreating a new one
	// by providing a transactional change that ensures an assignee always has an
	// associated reservation.
	MoveAssignment(context.Context, *MoveAssignmentRequest) (*Assignment, error)
	// Updates an existing assignment.
	//
	// Only the `priority` field can be updated.
	UpdateAssignment(context.Context, *UpdateAssignmentRequest) (*Assignment, error)
	// Retrieves a BI reservation.
	GetBiReservation(context.Context, *GetBiReservationRequest) (*BiReservation, error)
	// Updates a BI reservation.
	//
	// Only fields specified in the `field_mask` are updated.
	//
	// A singleton BI reservation always exists with default size 0.
	// In order to reserve BI capacity it needs to be updated to an amount
	// greater than 0. In order to release BI capacity reservation size
	// must be set to 0.
	UpdateBiReservation(context.Context, *UpdateBiReservationRequest) (*BiReservation, error)
	// Gets the access control policy for a resource.
	// May return:
	//
	//   - A`NOT_FOUND` error if the resource doesn't exist or you don't have the
	//     permission to view it.
	//   - An empty policy if the resource exists but doesn't have a set policy.
	//
	// Supported resources are:
	// - Reservations
	// - ReservationAssignments
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	// - `bigqueryreservation.reservations.getIamPolicy` to get policies on
	// reservations.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Sets an access control policy for a resource. Replaces any existing
	// policy.
	//
	// Supported resources are:
	// - Reservations
	//
	// To call this method, you must have the following Google IAM permissions:
	//
	// - `bigqueryreservation.reservations.setIamPolicy` to set policies on
	// reservations.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets your permissions on a resource. Returns an empty set of permissions if
	// the resource doesn't exist.
	//
	// Supported resources are:
	// - Reservations
	//
	// No Google IAM permissions are required to call this method.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Creates a new reservation group.
	CreateReservationGroup(context.Context, *CreateReservationGroupRequest) (*ReservationGroup, error)
	// Returns information about the reservation group.
	GetReservationGroup(context.Context, *GetReservationGroupRequest) (*ReservationGroup, error)
	// Deletes a reservation.
	// Returns `google.rpc.Code.FAILED_PRECONDITION` when reservation has
	// assignments.
	DeleteReservationGroup(context.Context, *DeleteReservationGroupRequest) (*emptypb.Empty, error)
	// Lists all the reservation groups for the project in the specified location.
	ListReservationGroups(context.Context, *ListReservationGroupsRequest) (*ListReservationGroupsResponse, error)
}

// UnimplementedReservationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedReservationServiceServer struct {
}

func (UnimplementedReservationServiceServer) CreateReservation(context.Context, *CreateReservationRequest) (*Reservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReservation not implemented")
}
func (UnimplementedReservationServiceServer) ListReservations(context.Context, *ListReservationsRequest) (*ListReservationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReservations not implemented")
}
func (UnimplementedReservationServiceServer) GetReservation(context.Context, *GetReservationRequest) (*Reservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReservation not implemented")
}
func (UnimplementedReservationServiceServer) DeleteReservation(context.Context, *DeleteReservationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReservation not implemented")
}
func (UnimplementedReservationServiceServer) UpdateReservation(context.Context, *UpdateReservationRequest) (*Reservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateReservation not implemented")
}
func (UnimplementedReservationServiceServer) FailoverReservation(context.Context, *FailoverReservationRequest) (*Reservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FailoverReservation not implemented")
}
func (UnimplementedReservationServiceServer) CreateCapacityCommitment(context.Context, *CreateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCapacityCommitment not implemented")
}
func (UnimplementedReservationServiceServer) ListCapacityCommitments(context.Context, *ListCapacityCommitmentsRequest) (*ListCapacityCommitmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCapacityCommitments not implemented")
}
func (UnimplementedReservationServiceServer) GetCapacityCommitment(context.Context, *GetCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCapacityCommitment not implemented")
}
func (UnimplementedReservationServiceServer) DeleteCapacityCommitment(context.Context, *DeleteCapacityCommitmentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCapacityCommitment not implemented")
}
func (UnimplementedReservationServiceServer) UpdateCapacityCommitment(context.Context, *UpdateCapacityCommitmentRequest) (*CapacityCommitment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCapacityCommitment not implemented")
}
func (UnimplementedReservationServiceServer) SplitCapacityCommitment(context.Context, *SplitCapacityCommitmentRequest) (*SplitCapacityCommitmentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SplitCapacityCommitment not implemented")
}
func (UnimplementedReservationServiceServer) MergeCapacityCommitments(context.Context, *MergeCapacityCommitmentsRequest) (*CapacityCommitment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeCapacityCommitments not implemented")
}
func (UnimplementedReservationServiceServer) CreateAssignment(context.Context, *CreateAssignmentRequest) (*Assignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAssignment not implemented")
}
func (UnimplementedReservationServiceServer) ListAssignments(context.Context, *ListAssignmentsRequest) (*ListAssignmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssignments not implemented")
}
func (UnimplementedReservationServiceServer) DeleteAssignment(context.Context, *DeleteAssignmentRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAssignment not implemented")
}
func (UnimplementedReservationServiceServer) SearchAssignments(context.Context, *SearchAssignmentsRequest) (*SearchAssignmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAssignments not implemented")
}
func (UnimplementedReservationServiceServer) SearchAllAssignments(context.Context, *SearchAllAssignmentsRequest) (*SearchAllAssignmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchAllAssignments not implemented")
}
func (UnimplementedReservationServiceServer) MoveAssignment(context.Context, *MoveAssignmentRequest) (*Assignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MoveAssignment not implemented")
}
func (UnimplementedReservationServiceServer) UpdateAssignment(context.Context, *UpdateAssignmentRequest) (*Assignment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAssignment not implemented")
}
func (UnimplementedReservationServiceServer) GetBiReservation(context.Context, *GetBiReservationRequest) (*BiReservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBiReservation not implemented")
}
func (UnimplementedReservationServiceServer) UpdateBiReservation(context.Context, *UpdateBiReservationRequest) (*BiReservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBiReservation not implemented")
}
func (UnimplementedReservationServiceServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedReservationServiceServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedReservationServiceServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedReservationServiceServer) CreateReservationGroup(context.Context, *CreateReservationGroupRequest) (*ReservationGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateReservationGroup not implemented")
}
func (UnimplementedReservationServiceServer) GetReservationGroup(context.Context, *GetReservationGroupRequest) (*ReservationGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReservationGroup not implemented")
}
func (UnimplementedReservationServiceServer) DeleteReservationGroup(context.Context, *DeleteReservationGroupRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteReservationGroup not implemented")
}
func (UnimplementedReservationServiceServer) ListReservationGroups(context.Context, *ListReservationGroupsRequest) (*ListReservationGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReservationGroups not implemented")
}

// UnsafeReservationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ReservationServiceServer will
// result in compilation errors.
type UnsafeReservationServiceServer interface {
	mustEmbedUnimplementedReservationServiceServer()
}

func RegisterReservationServiceServer(s grpc.ServiceRegistrar, srv ReservationServiceServer) {
	s.RegisterService(&ReservationService_ServiceDesc, srv)
}

func _ReservationService_CreateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_CreateReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateReservation(ctx, req.(*CreateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListReservations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReservationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListReservations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_ListReservations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListReservations(ctx, req.(*ListReservationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_GetReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetReservation(ctx, req.(*GetReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_DeleteReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteReservation(ctx, req.(*DeleteReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_UpdateReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateReservation(ctx, req.(*UpdateReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_FailoverReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FailoverReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).FailoverReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_FailoverReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).FailoverReservation(ctx, req.(*FailoverReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_CreateCapacityCommitment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateCapacityCommitment(ctx, req.(*CreateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_ListCapacityCommitments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListCapacityCommitments(ctx, req.(*ListCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_GetCapacityCommitment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetCapacityCommitment(ctx, req.(*GetCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_DeleteCapacityCommitment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteCapacityCommitment(ctx, req.(*DeleteCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_UpdateCapacityCommitment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateCapacityCommitment(ctx, req.(*UpdateCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SplitCapacityCommitment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SplitCapacityCommitmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_SplitCapacityCommitment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SplitCapacityCommitment(ctx, req.(*SplitCapacityCommitmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MergeCapacityCommitments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeCapacityCommitmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_MergeCapacityCommitments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MergeCapacityCommitments(ctx, req.(*MergeCapacityCommitmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_CreateAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateAssignment(ctx, req.(*CreateAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_ListAssignments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListAssignments(ctx, req.(*ListAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_DeleteAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteAssignment(ctx, req.(*DeleteAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SearchAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_SearchAssignments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SearchAssignments(ctx, req.(*SearchAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SearchAllAssignments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchAllAssignmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SearchAllAssignments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_SearchAllAssignments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SearchAllAssignments(ctx, req.(*SearchAllAssignmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_MoveAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_MoveAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).MoveAssignment(ctx, req.(*MoveAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateAssignment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAssignmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateAssignment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_UpdateAssignment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateAssignment(ctx, req.(*UpdateAssignmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_GetBiReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetBiReservation(ctx, req.(*GetBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_UpdateBiReservation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBiReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_UpdateBiReservation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).UpdateBiReservation(ctx, req.(*UpdateBiReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_CreateReservationGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateReservationGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).CreateReservationGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_CreateReservationGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).CreateReservationGroup(ctx, req.(*CreateReservationGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_GetReservationGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReservationGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).GetReservationGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_GetReservationGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).GetReservationGroup(ctx, req.(*GetReservationGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_DeleteReservationGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteReservationGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).DeleteReservationGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_DeleteReservationGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).DeleteReservationGroup(ctx, req.(*DeleteReservationGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ReservationService_ListReservationGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReservationGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ReservationServiceServer).ListReservationGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ReservationService_ListReservationGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ReservationServiceServer).ListReservationGroups(ctx, req.(*ListReservationGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ReservationService_ServiceDesc is the grpc.ServiceDesc for ReservationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ReservationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.reservation.v1.ReservationService",
	HandlerType: (*ReservationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateReservation",
			Handler:    _ReservationService_CreateReservation_Handler,
		},
		{
			MethodName: "ListReservations",
			Handler:    _ReservationService_ListReservations_Handler,
		},
		{
			MethodName: "GetReservation",
			Handler:    _ReservationService_GetReservation_Handler,
		},
		{
			MethodName: "DeleteReservation",
			Handler:    _ReservationService_DeleteReservation_Handler,
		},
		{
			MethodName: "UpdateReservation",
			Handler:    _ReservationService_UpdateReservation_Handler,
		},
		{
			MethodName: "FailoverReservation",
			Handler:    _ReservationService_FailoverReservation_Handler,
		},
		{
			MethodName: "CreateCapacityCommitment",
			Handler:    _ReservationService_CreateCapacityCommitment_Handler,
		},
		{
			MethodName: "ListCapacityCommitments",
			Handler:    _ReservationService_ListCapacityCommitments_Handler,
		},
		{
			MethodName: "GetCapacityCommitment",
			Handler:    _ReservationService_GetCapacityCommitment_Handler,
		},
		{
			MethodName: "DeleteCapacityCommitment",
			Handler:    _ReservationService_DeleteCapacityCommitment_Handler,
		},
		{
			MethodName: "UpdateCapacityCommitment",
			Handler:    _ReservationService_UpdateCapacityCommitment_Handler,
		},
		{
			MethodName: "SplitCapacityCommitment",
			Handler:    _ReservationService_SplitCapacityCommitment_Handler,
		},
		{
			MethodName: "MergeCapacityCommitments",
			Handler:    _ReservationService_MergeCapacityCommitments_Handler,
		},
		{
			MethodName: "CreateAssignment",
			Handler:    _ReservationService_CreateAssignment_Handler,
		},
		{
			MethodName: "ListAssignments",
			Handler:    _ReservationService_ListAssignments_Handler,
		},
		{
			MethodName: "DeleteAssignment",
			Handler:    _ReservationService_DeleteAssignment_Handler,
		},
		{
			MethodName: "SearchAssignments",
			Handler:    _ReservationService_SearchAssignments_Handler,
		},
		{
			MethodName: "SearchAllAssignments",
			Handler:    _ReservationService_SearchAllAssignments_Handler,
		},
		{
			MethodName: "MoveAssignment",
			Handler:    _ReservationService_MoveAssignment_Handler,
		},
		{
			MethodName: "UpdateAssignment",
			Handler:    _ReservationService_UpdateAssignment_Handler,
		},
		{
			MethodName: "GetBiReservation",
			Handler:    _ReservationService_GetBiReservation_Handler,
		},
		{
			MethodName: "UpdateBiReservation",
			Handler:    _ReservationService_UpdateBiReservation_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ReservationService_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ReservationService_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ReservationService_TestIamPermissions_Handler,
		},
		{
			MethodName: "CreateReservationGroup",
			Handler:    _ReservationService_CreateReservationGroup_Handler,
		},
		{
			MethodName: "GetReservationGroup",
			Handler:    _ReservationService_GetReservationGroup_Handler,
		},
		{
			MethodName: "DeleteReservationGroup",
			Handler:    _ReservationService_DeleteReservationGroup_Handler,
		},
		{
			MethodName: "ListReservationGroups",
			Handler:    _ReservationService_ListReservationGroups_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/reservation/v1/reservation.proto",
}
