// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/bigtable/v2/bigtable.proto

package bigtablepb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The desired view into RequestStats that should be returned in the response.
//
// See also: RequestStats message.
type ReadRowsRequest_RequestStatsView int32

const (
	// The default / unset value. The API will default to the NONE option below.
	ReadRowsRequest_REQUEST_STATS_VIEW_UNSPECIFIED ReadRowsRequest_RequestStatsView = 0
	// Do not include any RequestStats in the response. This will leave the
	// RequestStats embedded message unset in the response.
	ReadRowsRequest_REQUEST_STATS_NONE ReadRowsRequest_RequestStatsView = 1
	// Include the full set of available RequestStats in the response,
	// applicable to this read.
	ReadRowsRequest_REQUEST_STATS_FULL ReadRowsRequest_RequestStatsView = 2
)

// Enum value maps for ReadRowsRequest_RequestStatsView.
var (
	ReadRowsRequest_RequestStatsView_name = map[int32]string{
		0: "REQUEST_STATS_VIEW_UNSPECIFIED",
		1: "REQUEST_STATS_NONE",
		2: "REQUEST_STATS_FULL",
	}
	ReadRowsRequest_RequestStatsView_value = map[string]int32{
		"REQUEST_STATS_VIEW_UNSPECIFIED": 0,
		"REQUEST_STATS_NONE":             1,
		"REQUEST_STATS_FULL":             2,
	}
)

func (x ReadRowsRequest_RequestStatsView) Enum() *ReadRowsRequest_RequestStatsView {
	p := new(ReadRowsRequest_RequestStatsView)
	*p = x
	return p
}

func (x ReadRowsRequest_RequestStatsView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReadRowsRequest_RequestStatsView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_v2_bigtable_proto_enumTypes[0].Descriptor()
}

func (ReadRowsRequest_RequestStatsView) Type() protoreflect.EnumType {
	return &file_google_bigtable_v2_bigtable_proto_enumTypes[0]
}

func (x ReadRowsRequest_RequestStatsView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReadRowsRequest_RequestStatsView.Descriptor instead.
func (ReadRowsRequest_RequestStatsView) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{0, 0}
}

// The type of mutation.
type ReadChangeStreamResponse_DataChange_Type int32

const (
	// The type is unspecified.
	ReadChangeStreamResponse_DataChange_TYPE_UNSPECIFIED ReadChangeStreamResponse_DataChange_Type = 0
	// A user-initiated mutation.
	ReadChangeStreamResponse_DataChange_USER ReadChangeStreamResponse_DataChange_Type = 1
	// A system-initiated mutation as part of garbage collection.
	// https://cloud.google.com/bigtable/docs/garbage-collection
	ReadChangeStreamResponse_DataChange_GARBAGE_COLLECTION ReadChangeStreamResponse_DataChange_Type = 2
	// This is a continuation of a multi-message change.
	ReadChangeStreamResponse_DataChange_CONTINUATION ReadChangeStreamResponse_DataChange_Type = 3
)

// Enum value maps for ReadChangeStreamResponse_DataChange_Type.
var (
	ReadChangeStreamResponse_DataChange_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "USER",
		2: "GARBAGE_COLLECTION",
		3: "CONTINUATION",
	}
	ReadChangeStreamResponse_DataChange_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED":   0,
		"USER":               1,
		"GARBAGE_COLLECTION": 2,
		"CONTINUATION":       3,
	}
)

func (x ReadChangeStreamResponse_DataChange_Type) Enum() *ReadChangeStreamResponse_DataChange_Type {
	p := new(ReadChangeStreamResponse_DataChange_Type)
	*p = x
	return p
}

func (x ReadChangeStreamResponse_DataChange_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReadChangeStreamResponse_DataChange_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_v2_bigtable_proto_enumTypes[1].Descriptor()
}

func (ReadChangeStreamResponse_DataChange_Type) Type() protoreflect.EnumType {
	return &file_google_bigtable_v2_bigtable_proto_enumTypes[1]
}

func (x ReadChangeStreamResponse_DataChange_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReadChangeStreamResponse_DataChange_Type.Descriptor instead.
func (ReadChangeStreamResponse_DataChange_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18, 1, 0}
}

// Request message for Bigtable.ReadRows.
type ReadRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name of the table from which to read.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Optional. The unique name of the AuthorizedView from which to read.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
	AuthorizedViewName string `protobuf:"bytes,9,opt,name=authorized_view_name,json=authorizedViewName,proto3" json:"authorized_view_name,omitempty"`
	// Optional. The unique name of the MaterializedView from which to read.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/materializedViews/<materialized_view>`.
	MaterializedViewName string `protobuf:"bytes,11,opt,name=materialized_view_name,json=materializedViewName,proto3" json:"materialized_view_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,5,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// The row keys and/or ranges to read sequentially. If not specified, reads
	// from all rows.
	Rows *RowSet `protobuf:"bytes,2,opt,name=rows,proto3" json:"rows,omitempty"`
	// The filter to apply to the contents of the specified row(s). If unset,
	// reads the entirety of each row.
	Filter *RowFilter `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The read will stop after committing to N rows' worth of results. The
	// default (zero) is to return all results.
	RowsLimit int64 `protobuf:"varint,4,opt,name=rows_limit,json=rowsLimit,proto3" json:"rows_limit,omitempty"`
	// The view into RequestStats, as described above.
	RequestStatsView ReadRowsRequest_RequestStatsView `protobuf:"varint,6,opt,name=request_stats_view,json=requestStatsView,proto3,enum=google.bigtable.v2.ReadRowsRequest_RequestStatsView" json:"request_stats_view,omitempty"`
	// Experimental API - Please note that this API is currently experimental
	// and can change in the future.
	//
	// Return rows in lexiographical descending order of the row keys. The row
	// contents will not be affected by this flag.
	//
	// Example result set:
	//
	//	[
	//	  {key: "k2", "f:col1": "v1", "f:col2": "v1"},
	//	  {key: "k1", "f:col1": "v2", "f:col2": "v2"}
	//	]
	Reversed bool `protobuf:"varint,7,opt,name=reversed,proto3" json:"reversed,omitempty"`
}

func (x *ReadRowsRequest) Reset() {
	*x = ReadRowsRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsRequest) ProtoMessage() {}

func (x *ReadRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsRequest.ProtoReflect.Descriptor instead.
func (*ReadRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{0}
}

func (x *ReadRowsRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *ReadRowsRequest) GetAuthorizedViewName() string {
	if x != nil {
		return x.AuthorizedViewName
	}
	return ""
}

func (x *ReadRowsRequest) GetMaterializedViewName() string {
	if x != nil {
		return x.MaterializedViewName
	}
	return ""
}

func (x *ReadRowsRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *ReadRowsRequest) GetRows() *RowSet {
	if x != nil {
		return x.Rows
	}
	return nil
}

func (x *ReadRowsRequest) GetFilter() *RowFilter {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *ReadRowsRequest) GetRowsLimit() int64 {
	if x != nil {
		return x.RowsLimit
	}
	return 0
}

func (x *ReadRowsRequest) GetRequestStatsView() ReadRowsRequest_RequestStatsView {
	if x != nil {
		return x.RequestStatsView
	}
	return ReadRowsRequest_REQUEST_STATS_VIEW_UNSPECIFIED
}

func (x *ReadRowsRequest) GetReversed() bool {
	if x != nil {
		return x.Reversed
	}
	return false
}

// Response message for Bigtable.ReadRows.
type ReadRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A collection of a row's contents as part of the read request.
	Chunks []*ReadRowsResponse_CellChunk `protobuf:"bytes,1,rep,name=chunks,proto3" json:"chunks,omitempty"`
	// Optionally the server might return the row key of the last row it
	// has scanned.  The client can use this to construct a more
	// efficient retry request if needed: any row keys or portions of
	// ranges less than this row key can be dropped from the request.
	// This is primarily useful for cases where the server has read a
	// lot of data that was filtered out since the last committed row
	// key, allowing the client to skip that work on a retry.
	LastScannedRowKey []byte `protobuf:"bytes,2,opt,name=last_scanned_row_key,json=lastScannedRowKey,proto3" json:"last_scanned_row_key,omitempty"`
	// If requested, return enhanced query performance statistics. The field
	// request_stats is empty in a streamed response unless the ReadRowsResponse
	// message contains request_stats in the last message of the stream. Always
	// returned when requested, even when the read request returns an empty
	// response.
	RequestStats *RequestStats `protobuf:"bytes,3,opt,name=request_stats,json=requestStats,proto3" json:"request_stats,omitempty"`
}

func (x *ReadRowsResponse) Reset() {
	*x = ReadRowsResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsResponse) ProtoMessage() {}

func (x *ReadRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsResponse.ProtoReflect.Descriptor instead.
func (*ReadRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{1}
}

func (x *ReadRowsResponse) GetChunks() []*ReadRowsResponse_CellChunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

func (x *ReadRowsResponse) GetLastScannedRowKey() []byte {
	if x != nil {
		return x.LastScannedRowKey
	}
	return nil
}

func (x *ReadRowsResponse) GetRequestStats() *RequestStats {
	if x != nil {
		return x.RequestStats
	}
	return nil
}

// Request message for Bigtable.SampleRowKeys.
type SampleRowKeysRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name of the table from which to sample row keys.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Optional. The unique name of the AuthorizedView from which to sample row
	// keys.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
	AuthorizedViewName string `protobuf:"bytes,4,opt,name=authorized_view_name,json=authorizedViewName,proto3" json:"authorized_view_name,omitempty"`
	// Optional. The unique name of the MaterializedView from which to read.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/materializedViews/<materialized_view>`.
	MaterializedViewName string `protobuf:"bytes,5,opt,name=materialized_view_name,json=materializedViewName,proto3" json:"materialized_view_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
}

func (x *SampleRowKeysRequest) Reset() {
	*x = SampleRowKeysRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SampleRowKeysRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleRowKeysRequest) ProtoMessage() {}

func (x *SampleRowKeysRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleRowKeysRequest.ProtoReflect.Descriptor instead.
func (*SampleRowKeysRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{2}
}

func (x *SampleRowKeysRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *SampleRowKeysRequest) GetAuthorizedViewName() string {
	if x != nil {
		return x.AuthorizedViewName
	}
	return ""
}

func (x *SampleRowKeysRequest) GetMaterializedViewName() string {
	if x != nil {
		return x.MaterializedViewName
	}
	return ""
}

func (x *SampleRowKeysRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

// Response message for Bigtable.SampleRowKeys.
type SampleRowKeysResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sorted streamed sequence of sample row keys in the table. The table might
	// have contents before the first row key in the list and after the last one,
	// but a key containing the empty string indicates "end of table" and will be
	// the last response given, if present.
	// Note that row keys in this list may not have ever been written to or read
	// from, and users should therefore not make any assumptions about the row key
	// structure that are specific to their use case.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Approximate total storage space used by all rows in the table which precede
	// `row_key`. Buffering the contents of all rows between two subsequent
	// samples would require space roughly equal to the difference in their
	// `offset_bytes` fields.
	OffsetBytes int64 `protobuf:"varint,2,opt,name=offset_bytes,json=offsetBytes,proto3" json:"offset_bytes,omitempty"`
}

func (x *SampleRowKeysResponse) Reset() {
	*x = SampleRowKeysResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SampleRowKeysResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SampleRowKeysResponse) ProtoMessage() {}

func (x *SampleRowKeysResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SampleRowKeysResponse.ProtoReflect.Descriptor instead.
func (*SampleRowKeysResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{3}
}

func (x *SampleRowKeysResponse) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *SampleRowKeysResponse) GetOffsetBytes() int64 {
	if x != nil {
		return x.OffsetBytes
	}
	return 0
}

// Request message for Bigtable.MutateRow.
type MutateRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name of the table to which the mutation should be
	// applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Optional. The unique name of the AuthorizedView to which the mutation
	// should be applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
	AuthorizedViewName string `protobuf:"bytes,6,opt,name=authorized_view_name,json=authorizedViewName,proto3" json:"authorized_view_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,4,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The key of the row to which the mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Required. Changes to be atomically applied to the specified row. Entries
	// are applied in order, meaning that earlier mutations can be masked by later
	// ones. Must contain at least one entry and at most 100000.
	Mutations []*Mutation `protobuf:"bytes,3,rep,name=mutations,proto3" json:"mutations,omitempty"`
	// If set consistently across retries, prevents this mutation from being
	// double applied to aggregate column families within a 15m window.
	Idempotency *Idempotency `protobuf:"bytes,8,opt,name=idempotency,proto3" json:"idempotency,omitempty"`
}

func (x *MutateRowRequest) Reset() {
	*x = MutateRowRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowRequest) ProtoMessage() {}

func (x *MutateRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowRequest.ProtoReflect.Descriptor instead.
func (*MutateRowRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{4}
}

func (x *MutateRowRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *MutateRowRequest) GetAuthorizedViewName() string {
	if x != nil {
		return x.AuthorizedViewName
	}
	return ""
}

func (x *MutateRowRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *MutateRowRequest) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *MutateRowRequest) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

func (x *MutateRowRequest) GetIdempotency() *Idempotency {
	if x != nil {
		return x.Idempotency
	}
	return nil
}

// Response message for Bigtable.MutateRow.
type MutateRowResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *MutateRowResponse) Reset() {
	*x = MutateRowResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateRowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowResponse) ProtoMessage() {}

func (x *MutateRowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowResponse.ProtoReflect.Descriptor instead.
func (*MutateRowResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{5}
}

// Request message for BigtableService.MutateRows.
type MutateRowsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name of the table to which the mutations should be
	// applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Optional. The unique name of the AuthorizedView to which the mutations
	// should be applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
	AuthorizedViewName string `protobuf:"bytes,5,opt,name=authorized_view_name,json=authorizedViewName,proto3" json:"authorized_view_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,3,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The row keys and corresponding mutations to be applied in bulk.
	// Each entry is applied as an atomic mutation, but the entries may be
	// applied in arbitrary order (even between entries for the same row).
	// At least one entry must be specified, and in total the entries can
	// contain at most 100000 mutations.
	Entries []*MutateRowsRequest_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (x *MutateRowsRequest) Reset() {
	*x = MutateRowsRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateRowsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsRequest) ProtoMessage() {}

func (x *MutateRowsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsRequest.ProtoReflect.Descriptor instead.
func (*MutateRowsRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{6}
}

func (x *MutateRowsRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *MutateRowsRequest) GetAuthorizedViewName() string {
	if x != nil {
		return x.AuthorizedViewName
	}
	return ""
}

func (x *MutateRowsRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *MutateRowsRequest) GetEntries() []*MutateRowsRequest_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

// Response message for BigtableService.MutateRows.
type MutateRowsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// One or more results for Entries from the batch request.
	Entries []*MutateRowsResponse_Entry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
	// Information about how client should limit the rate (QPS). Primirily used by
	// supported official Cloud Bigtable clients. If unset, the rate limit info is
	// not provided by the server.
	RateLimitInfo *RateLimitInfo `protobuf:"bytes,3,opt,name=rate_limit_info,json=rateLimitInfo,proto3,oneof" json:"rate_limit_info,omitempty"`
}

func (x *MutateRowsResponse) Reset() {
	*x = MutateRowsResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateRowsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsResponse) ProtoMessage() {}

func (x *MutateRowsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsResponse.ProtoReflect.Descriptor instead.
func (*MutateRowsResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{7}
}

func (x *MutateRowsResponse) GetEntries() []*MutateRowsResponse_Entry {
	if x != nil {
		return x.Entries
	}
	return nil
}

func (x *MutateRowsResponse) GetRateLimitInfo() *RateLimitInfo {
	if x != nil {
		return x.RateLimitInfo
	}
	return nil
}

// Information about how client should adjust the load to Bigtable.
type RateLimitInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Time that clients should wait before adjusting the target rate again.
	// If clients adjust rate too frequently, the impact of the previous
	// adjustment may not have been taken into account and may
	// over-throttle or under-throttle. If clients adjust rate too slowly, they
	// will not be responsive to load changes on server side, and may
	// over-throttle or under-throttle.
	Period *durationpb.Duration `protobuf:"bytes,1,opt,name=period,proto3" json:"period,omitempty"`
	// If it has been at least one `period` since the last load adjustment, the
	// client should multiply the current load by this value to get the new target
	// load. For example, if the current load is 100 and `factor` is 0.8, the new
	// target load should be 80. After adjusting, the client should ignore
	// `factor` until another `period` has passed.
	//
	// The client can measure its load using any unit that's comparable over time.
	// For example, QPS can be used as long as each request involves a similar
	// amount of work.
	Factor float64 `protobuf:"fixed64,2,opt,name=factor,proto3" json:"factor,omitempty"`
}

func (x *RateLimitInfo) Reset() {
	*x = RateLimitInfo{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RateLimitInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RateLimitInfo) ProtoMessage() {}

func (x *RateLimitInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RateLimitInfo.ProtoReflect.Descriptor instead.
func (*RateLimitInfo) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{8}
}

func (x *RateLimitInfo) GetPeriod() *durationpb.Duration {
	if x != nil {
		return x.Period
	}
	return nil
}

func (x *RateLimitInfo) GetFactor() float64 {
	if x != nil {
		return x.Factor
	}
	return 0
}

// Request message for Bigtable.CheckAndMutateRow.
type CheckAndMutateRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name of the table to which the conditional mutation
	// should be applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Optional. The unique name of the AuthorizedView to which the conditional
	// mutation should be applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
	AuthorizedViewName string `protobuf:"bytes,9,opt,name=authorized_view_name,json=authorizedViewName,proto3" json:"authorized_view_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,7,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The key of the row to which the conditional mutation should be
	// applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// The filter to be applied to the contents of the specified row. Depending
	// on whether or not any results are yielded, either `true_mutations` or
	// `false_mutations` will be executed. If unset, checks that the row contains
	// any values at all.
	PredicateFilter *RowFilter `protobuf:"bytes,6,opt,name=predicate_filter,json=predicateFilter,proto3" json:"predicate_filter,omitempty"`
	// Changes to be atomically applied to the specified row if `predicate_filter`
	// yields at least one cell when applied to `row_key`. Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if `false_mutations` is empty, and at most
	// 100000.
	TrueMutations []*Mutation `protobuf:"bytes,4,rep,name=true_mutations,json=trueMutations,proto3" json:"true_mutations,omitempty"`
	// Changes to be atomically applied to the specified row if `predicate_filter`
	// does not yield any cells when applied to `row_key`. Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if `true_mutations` is empty, and at most
	// 100000.
	FalseMutations []*Mutation `protobuf:"bytes,5,rep,name=false_mutations,json=falseMutations,proto3" json:"false_mutations,omitempty"`
}

func (x *CheckAndMutateRowRequest) Reset() {
	*x = CheckAndMutateRowRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckAndMutateRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAndMutateRowRequest) ProtoMessage() {}

func (x *CheckAndMutateRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAndMutateRowRequest.ProtoReflect.Descriptor instead.
func (*CheckAndMutateRowRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{9}
}

func (x *CheckAndMutateRowRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *CheckAndMutateRowRequest) GetAuthorizedViewName() string {
	if x != nil {
		return x.AuthorizedViewName
	}
	return ""
}

func (x *CheckAndMutateRowRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *CheckAndMutateRowRequest) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *CheckAndMutateRowRequest) GetPredicateFilter() *RowFilter {
	if x != nil {
		return x.PredicateFilter
	}
	return nil
}

func (x *CheckAndMutateRowRequest) GetTrueMutations() []*Mutation {
	if x != nil {
		return x.TrueMutations
	}
	return nil
}

func (x *CheckAndMutateRowRequest) GetFalseMutations() []*Mutation {
	if x != nil {
		return x.FalseMutations
	}
	return nil
}

// Response message for Bigtable.CheckAndMutateRow.
type CheckAndMutateRowResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether or not the request's `predicate_filter` yielded any results for
	// the specified row.
	PredicateMatched bool `protobuf:"varint,1,opt,name=predicate_matched,json=predicateMatched,proto3" json:"predicate_matched,omitempty"`
}

func (x *CheckAndMutateRowResponse) Reset() {
	*x = CheckAndMutateRowResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckAndMutateRowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckAndMutateRowResponse) ProtoMessage() {}

func (x *CheckAndMutateRowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckAndMutateRowResponse.ProtoReflect.Descriptor instead.
func (*CheckAndMutateRowResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{10}
}

func (x *CheckAndMutateRowResponse) GetPredicateMatched() bool {
	if x != nil {
		return x.PredicateMatched
	}
	return false
}

// Request message for client connection keep-alive and warming.
type PingAndWarmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique name of the instance to check permissions for as well
	// as respond. Values are of the form
	// `projects/<project>/instances/<instance>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
}

func (x *PingAndWarmRequest) Reset() {
	*x = PingAndWarmRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PingAndWarmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PingAndWarmRequest) ProtoMessage() {}

func (x *PingAndWarmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PingAndWarmRequest.ProtoReflect.Descriptor instead.
func (*PingAndWarmRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{11}
}

func (x *PingAndWarmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PingAndWarmRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

// Response message for Bigtable.PingAndWarm connection keepalive and warming.
type PingAndWarmResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PingAndWarmResponse) Reset() {
	*x = PingAndWarmResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PingAndWarmResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PingAndWarmResponse) ProtoMessage() {}

func (x *PingAndWarmResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PingAndWarmResponse.ProtoReflect.Descriptor instead.
func (*PingAndWarmResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{12}
}

// Request message for Bigtable.ReadModifyWriteRow.
type ReadModifyWriteRowRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The unique name of the table to which the read/modify/write rules
	// should be applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// Optional. The unique name of the AuthorizedView to which the
	// read/modify/write rules should be applied.
	//
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>/authorizedViews/<authorized_view>`.
	AuthorizedViewName string `protobuf:"bytes,6,opt,name=authorized_view_name,json=authorizedViewName,proto3" json:"authorized_view_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	AppProfileId string `protobuf:"bytes,4,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The key of the row to which the read/modify/write rules should be
	// applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Required. Rules specifying how the specified row's contents are to be
	// transformed into writes. Entries are applied in order, meaning that earlier
	// rules will affect the results of later ones. At least one entry must be
	// specified, and there can be at most 100000 rules.
	Rules []*ReadModifyWriteRule `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
}

func (x *ReadModifyWriteRowRequest) Reset() {
	*x = ReadModifyWriteRowRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadModifyWriteRowRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadModifyWriteRowRequest) ProtoMessage() {}

func (x *ReadModifyWriteRowRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadModifyWriteRowRequest.ProtoReflect.Descriptor instead.
func (*ReadModifyWriteRowRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{13}
}

func (x *ReadModifyWriteRowRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *ReadModifyWriteRowRequest) GetAuthorizedViewName() string {
	if x != nil {
		return x.AuthorizedViewName
	}
	return ""
}

func (x *ReadModifyWriteRowRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *ReadModifyWriteRowRequest) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *ReadModifyWriteRowRequest) GetRules() []*ReadModifyWriteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

// Response message for Bigtable.ReadModifyWriteRow.
type ReadModifyWriteRowResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A Row containing the new contents of all cells modified by the request.
	Row *Row `protobuf:"bytes,1,opt,name=row,proto3" json:"row,omitempty"`
}

func (x *ReadModifyWriteRowResponse) Reset() {
	*x = ReadModifyWriteRowResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadModifyWriteRowResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadModifyWriteRowResponse) ProtoMessage() {}

func (x *ReadModifyWriteRowResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadModifyWriteRowResponse.ProtoReflect.Descriptor instead.
func (*ReadModifyWriteRowResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{14}
}

func (x *ReadModifyWriteRowResponse) GetRow() *Row {
	if x != nil {
		return x.Row
	}
	return nil
}

// NOTE: This API is intended to be used by Apache Beam BigtableIO.
// Request message for Bigtable.GenerateInitialChangeStreamPartitions.
type GenerateInitialChangeStreamPartitionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique name of the table from which to get change stream
	// partitions. Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	// Change streaming must be enabled on the table.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	// Single cluster routing must be configured on the profile.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
}

func (x *GenerateInitialChangeStreamPartitionsRequest) Reset() {
	*x = GenerateInitialChangeStreamPartitionsRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateInitialChangeStreamPartitionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateInitialChangeStreamPartitionsRequest) ProtoMessage() {}

func (x *GenerateInitialChangeStreamPartitionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateInitialChangeStreamPartitionsRequest.ProtoReflect.Descriptor instead.
func (*GenerateInitialChangeStreamPartitionsRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{15}
}

func (x *GenerateInitialChangeStreamPartitionsRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *GenerateInitialChangeStreamPartitionsRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

// NOTE: This API is intended to be used by Apache Beam BigtableIO.
// Response message for Bigtable.GenerateInitialChangeStreamPartitions.
type GenerateInitialChangeStreamPartitionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A partition of the change stream.
	Partition *StreamPartition `protobuf:"bytes,1,opt,name=partition,proto3" json:"partition,omitempty"`
}

func (x *GenerateInitialChangeStreamPartitionsResponse) Reset() {
	*x = GenerateInitialChangeStreamPartitionsResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateInitialChangeStreamPartitionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateInitialChangeStreamPartitionsResponse) ProtoMessage() {}

func (x *GenerateInitialChangeStreamPartitionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateInitialChangeStreamPartitionsResponse.ProtoReflect.Descriptor instead.
func (*GenerateInitialChangeStreamPartitionsResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{16}
}

func (x *GenerateInitialChangeStreamPartitionsResponse) GetPartition() *StreamPartition {
	if x != nil {
		return x.Partition
	}
	return nil
}

// NOTE: This API is intended to be used by Apache Beam BigtableIO.
// Request message for Bigtable.ReadChangeStream.
type ReadChangeStreamRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique name of the table from which to read a change stream.
	// Values are of the form
	// `projects/<project>/instances/<instance>/tables/<table>`.
	// Change streaming must be enabled on the table.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// This value specifies routing for replication. If not specified, the
	// "default" application profile will be used.
	// Single cluster routing must be configured on the profile.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// The partition to read changes from.
	Partition *StreamPartition `protobuf:"bytes,3,opt,name=partition,proto3" json:"partition,omitempty"`
	// Options for describing where we want to start reading from the stream.
	//
	// Types that are assignable to StartFrom:
	//
	//	*ReadChangeStreamRequest_StartTime
	//	*ReadChangeStreamRequest_ContinuationTokens
	StartFrom isReadChangeStreamRequest_StartFrom `protobuf_oneof:"start_from"`
	// If specified, OK will be returned when the stream advances beyond
	// this time. Otherwise, changes will be continuously delivered on the stream.
	// This value is inclusive and will be truncated to microsecond granularity.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// If specified, the duration between `Heartbeat` messages on the stream.
	// Otherwise, defaults to 5 seconds.
	HeartbeatDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=heartbeat_duration,json=heartbeatDuration,proto3" json:"heartbeat_duration,omitempty"`
}

func (x *ReadChangeStreamRequest) Reset() {
	*x = ReadChangeStreamRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamRequest) ProtoMessage() {}

func (x *ReadChangeStreamRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamRequest.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{17}
}

func (x *ReadChangeStreamRequest) GetTableName() string {
	if x != nil {
		return x.TableName
	}
	return ""
}

func (x *ReadChangeStreamRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *ReadChangeStreamRequest) GetPartition() *StreamPartition {
	if x != nil {
		return x.Partition
	}
	return nil
}

func (m *ReadChangeStreamRequest) GetStartFrom() isReadChangeStreamRequest_StartFrom {
	if m != nil {
		return m.StartFrom
	}
	return nil
}

func (x *ReadChangeStreamRequest) GetStartTime() *timestamppb.Timestamp {
	if x, ok := x.GetStartFrom().(*ReadChangeStreamRequest_StartTime); ok {
		return x.StartTime
	}
	return nil
}

func (x *ReadChangeStreamRequest) GetContinuationTokens() *StreamContinuationTokens {
	if x, ok := x.GetStartFrom().(*ReadChangeStreamRequest_ContinuationTokens); ok {
		return x.ContinuationTokens
	}
	return nil
}

func (x *ReadChangeStreamRequest) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ReadChangeStreamRequest) GetHeartbeatDuration() *durationpb.Duration {
	if x != nil {
		return x.HeartbeatDuration
	}
	return nil
}

type isReadChangeStreamRequest_StartFrom interface {
	isReadChangeStreamRequest_StartFrom()
}

type ReadChangeStreamRequest_StartTime struct {
	// Start reading the stream at the specified timestamp. This timestamp must
	// be within the change stream retention period, less than or equal to the
	// current time, and after change stream creation, whichever is greater.
	// This value is inclusive and will be truncated to microsecond granularity.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3,oneof"`
}

type ReadChangeStreamRequest_ContinuationTokens struct {
	// Tokens that describe how to resume reading a stream where reading
	// previously left off. If specified, changes will be read starting at the
	// the position. Tokens are delivered on the stream as part of `Heartbeat`
	// and `CloseStream` messages.
	//
	// If a single token is provided, the token's partition must exactly match
	// the request's partition. If multiple tokens are provided, as in the case
	// of a partition merge, the union of the token partitions must exactly
	// cover the request's partition. Otherwise, INVALID_ARGUMENT will be
	// returned.
	ContinuationTokens *StreamContinuationTokens `protobuf:"bytes,6,opt,name=continuation_tokens,json=continuationTokens,proto3,oneof"`
}

func (*ReadChangeStreamRequest_StartTime) isReadChangeStreamRequest_StartFrom() {}

func (*ReadChangeStreamRequest_ContinuationTokens) isReadChangeStreamRequest_StartFrom() {}

// NOTE: This API is intended to be used by Apache Beam BigtableIO.
// Response message for Bigtable.ReadChangeStream.
type ReadChangeStreamResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The data or control message on the stream.
	//
	// Types that are assignable to StreamRecord:
	//
	//	*ReadChangeStreamResponse_DataChange_
	//	*ReadChangeStreamResponse_Heartbeat_
	//	*ReadChangeStreamResponse_CloseStream_
	StreamRecord isReadChangeStreamResponse_StreamRecord `protobuf_oneof:"stream_record"`
}

func (x *ReadChangeStreamResponse) Reset() {
	*x = ReadChangeStreamResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamResponse) ProtoMessage() {}

func (x *ReadChangeStreamResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamResponse.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18}
}

func (m *ReadChangeStreamResponse) GetStreamRecord() isReadChangeStreamResponse_StreamRecord {
	if m != nil {
		return m.StreamRecord
	}
	return nil
}

func (x *ReadChangeStreamResponse) GetDataChange() *ReadChangeStreamResponse_DataChange {
	if x, ok := x.GetStreamRecord().(*ReadChangeStreamResponse_DataChange_); ok {
		return x.DataChange
	}
	return nil
}

func (x *ReadChangeStreamResponse) GetHeartbeat() *ReadChangeStreamResponse_Heartbeat {
	if x, ok := x.GetStreamRecord().(*ReadChangeStreamResponse_Heartbeat_); ok {
		return x.Heartbeat
	}
	return nil
}

func (x *ReadChangeStreamResponse) GetCloseStream() *ReadChangeStreamResponse_CloseStream {
	if x, ok := x.GetStreamRecord().(*ReadChangeStreamResponse_CloseStream_); ok {
		return x.CloseStream
	}
	return nil
}

type isReadChangeStreamResponse_StreamRecord interface {
	isReadChangeStreamResponse_StreamRecord()
}

type ReadChangeStreamResponse_DataChange_ struct {
	// A mutation to the partition.
	DataChange *ReadChangeStreamResponse_DataChange `protobuf:"bytes,1,opt,name=data_change,json=dataChange,proto3,oneof"`
}

type ReadChangeStreamResponse_Heartbeat_ struct {
	// A periodic heartbeat message.
	Heartbeat *ReadChangeStreamResponse_Heartbeat `protobuf:"bytes,2,opt,name=heartbeat,proto3,oneof"`
}

type ReadChangeStreamResponse_CloseStream_ struct {
	// An indication that the stream should be closed.
	CloseStream *ReadChangeStreamResponse_CloseStream `protobuf:"bytes,3,opt,name=close_stream,json=closeStream,proto3,oneof"`
}

func (*ReadChangeStreamResponse_DataChange_) isReadChangeStreamResponse_StreamRecord() {}

func (*ReadChangeStreamResponse_Heartbeat_) isReadChangeStreamResponse_StreamRecord() {}

func (*ReadChangeStreamResponse_CloseStream_) isReadChangeStreamResponse_StreamRecord() {}

// Request message for Bigtable.ExecuteQuery
type ExecuteQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique name of the instance against which the query should be
	// executed.
	// Values are of the form `projects/<project>/instances/<instance>`
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// Optional. This value specifies routing for replication. If not specified,
	// the `default` application profile will be used.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The query string.
	//
	// Exactly one of `query` and `prepared_query` is required. Setting both
	// or neither is an `INVALID_ARGUMENT`.
	//
	// Deprecated: Marked as deprecated in google/bigtable/v2/bigtable.proto.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// A prepared query that was returned from `PrepareQueryResponse`.
	//
	// Exactly one of `query` and `prepared_query` is required. Setting both
	// or neither is an `INVALID_ARGUMENT`.
	//
	// Setting this field also places restrictions on several other fields:
	// - `data_format` must be empty.
	// - `validate_only` must be false.
	// - `params` must match the `param_types` set in the `PrepareQueryRequest`.
	PreparedQuery []byte `protobuf:"bytes,9,opt,name=prepared_query,json=preparedQuery,proto3" json:"prepared_query,omitempty"`
	// Requested data format for the response.
	//
	// If `prepared_query` is set, then the `data_format` is fixed by the
	// `PrepareQueryRequest`, and a non-empty `data_format` in the
	// `ExecuteQueryRequest` will be rejected with `INVALID_ARGUMENT`.
	//
	// Types that are assignable to DataFormat:
	//
	//	*ExecuteQueryRequest_ProtoFormat
	DataFormat isExecuteQueryRequest_DataFormat `protobuf_oneof:"data_format"`
	// Optional. If this request is resuming a previously interrupted query
	// execution, `resume_token` should be copied from the last
	// PartialResultSet yielded before the interruption. Doing this
	// enables the query execution to resume where the last one left
	// off.
	// The rest of the request parameters must exactly match the
	// request that yielded this token. Otherwise the request will fail.
	ResumeToken []byte `protobuf:"bytes,8,opt,name=resume_token,json=resumeToken,proto3" json:"resume_token,omitempty"`
	// Required. params contains string type keys and Bigtable type values that
	// bind to placeholders in the query string. In query string, a parameter
	// placeholder consists of the
	// `@` character followed by the parameter name (for example, `@firstName`) in
	// the query string.
	//
	// For example, if
	// `params["firstName"] = bytes_value: "foo" type {bytes_type {}}`
	// then `@firstName` will be replaced with googlesql bytes value "foo" in the
	// query string during query evaluation.
	//
	// If `Value.kind` is not set, the value is treated as a NULL value of the
	// given type. For example, if
	// `params["firstName"] = type {string_type {}}`
	// then `@firstName` will be replaced with googlesql null string.
	//
	// If `query` is set, any empty `Value.type` in the map will be rejected with
	// `INVALID_ARGUMENT`.
	//
	// If `prepared_query` is set, any empty `Value.type` in the map will be
	// inferred from the `param_types` in the `PrepareQueryRequest`. Any non-empty
	// `Value.type` must match the corresponding `param_types` entry, or be
	// rejected with `INVALID_ARGUMENT`.
	Params map[string]*Value `protobuf:"bytes,7,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *ExecuteQueryRequest) Reset() {
	*x = ExecuteQueryRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteQueryRequest) ProtoMessage() {}

func (x *ExecuteQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteQueryRequest.ProtoReflect.Descriptor instead.
func (*ExecuteQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{19}
}

func (x *ExecuteQueryRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *ExecuteQueryRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

// Deprecated: Marked as deprecated in google/bigtable/v2/bigtable.proto.
func (x *ExecuteQueryRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *ExecuteQueryRequest) GetPreparedQuery() []byte {
	if x != nil {
		return x.PreparedQuery
	}
	return nil
}

func (m *ExecuteQueryRequest) GetDataFormat() isExecuteQueryRequest_DataFormat {
	if m != nil {
		return m.DataFormat
	}
	return nil
}

// Deprecated: Marked as deprecated in google/bigtable/v2/bigtable.proto.
func (x *ExecuteQueryRequest) GetProtoFormat() *ProtoFormat {
	if x, ok := x.GetDataFormat().(*ExecuteQueryRequest_ProtoFormat); ok {
		return x.ProtoFormat
	}
	return nil
}

func (x *ExecuteQueryRequest) GetResumeToken() []byte {
	if x != nil {
		return x.ResumeToken
	}
	return nil
}

func (x *ExecuteQueryRequest) GetParams() map[string]*Value {
	if x != nil {
		return x.Params
	}
	return nil
}

type isExecuteQueryRequest_DataFormat interface {
	isExecuteQueryRequest_DataFormat()
}

type ExecuteQueryRequest_ProtoFormat struct {
	// Protocol buffer format as described by ProtoSchema and ProtoRows
	// messages.
	//
	// Deprecated: Marked as deprecated in google/bigtable/v2/bigtable.proto.
	ProtoFormat *ProtoFormat `protobuf:"bytes,4,opt,name=proto_format,json=protoFormat,proto3,oneof"`
}

func (*ExecuteQueryRequest_ProtoFormat) isExecuteQueryRequest_DataFormat() {}

// Response message for Bigtable.ExecuteQuery
type ExecuteQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The first response streamed from the server is of type `ResultSetMetadata`
	// and includes information about the columns and types of the result set.
	// From there on, we stream `PartialResultSet` messages with no additional
	// information. `PartialResultSet` will contain `resume_token` to restart the
	// response if query interrupts. In case of resumption with `resume_token`,
	// the server will not resend the ResultSetMetadata.
	//
	// Types that are assignable to Response:
	//
	//	*ExecuteQueryResponse_Metadata
	//	*ExecuteQueryResponse_Results
	Response isExecuteQueryResponse_Response `protobuf_oneof:"response"`
}

func (x *ExecuteQueryResponse) Reset() {
	*x = ExecuteQueryResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExecuteQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecuteQueryResponse) ProtoMessage() {}

func (x *ExecuteQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecuteQueryResponse.ProtoReflect.Descriptor instead.
func (*ExecuteQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{20}
}

func (m *ExecuteQueryResponse) GetResponse() isExecuteQueryResponse_Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func (x *ExecuteQueryResponse) GetMetadata() *ResultSetMetadata {
	if x, ok := x.GetResponse().(*ExecuteQueryResponse_Metadata); ok {
		return x.Metadata
	}
	return nil
}

func (x *ExecuteQueryResponse) GetResults() *PartialResultSet {
	if x, ok := x.GetResponse().(*ExecuteQueryResponse_Results); ok {
		return x.Results
	}
	return nil
}

type isExecuteQueryResponse_Response interface {
	isExecuteQueryResponse_Response()
}

type ExecuteQueryResponse_Metadata struct {
	// Structure of rows in this response stream. The first (and only the first)
	// response streamed from the server will be of this type.
	Metadata *ResultSetMetadata `protobuf:"bytes,1,opt,name=metadata,proto3,oneof"`
}

type ExecuteQueryResponse_Results struct {
	// A partial result set with row data potentially including additional
	// instructions on how recent past and future partial responses should be
	// interpreted.
	Results *PartialResultSet `protobuf:"bytes,2,opt,name=results,proto3,oneof"`
}

func (*ExecuteQueryResponse_Metadata) isExecuteQueryResponse_Response() {}

func (*ExecuteQueryResponse_Results) isExecuteQueryResponse_Response() {}

// Request message for Bigtable.PrepareQuery
type PrepareQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The unique name of the instance against which the query should be
	// executed.
	// Values are of the form `projects/<project>/instances/<instance>`
	InstanceName string `protobuf:"bytes,1,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
	// Optional. This value specifies routing for preparing the query. Note that
	// this `app_profile_id` is only used for preparing the query. The actual
	// query execution will use the app profile specified in the
	// `ExecuteQueryRequest`. If not specified, the `default` application profile
	// will be used.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The query string.
	Query string `protobuf:"bytes,3,opt,name=query,proto3" json:"query,omitempty"`
	// Required. Requested data format for the response. Note that the selected
	// data format is binding for all `ExecuteQuery` rpcs that use the prepared
	// query.
	//
	// Types that are assignable to DataFormat:
	//
	//	*PrepareQueryRequest_ProtoFormat
	DataFormat isPrepareQueryRequest_DataFormat `protobuf_oneof:"data_format"`
	// Required. `param_types` is a map of parameter identifier strings to their
	// `Type`s.
	//
	// In query string, a parameter placeholder consists of the
	// `@` character followed by the parameter name (for example, `@firstName`) in
	// the query string.
	//
	// For example, if param_types["firstName"] = Bytes then @firstName will be a
	// query parameter of type Bytes. The specific `Value` to be used for the
	// query execution must be sent in `ExecuteQueryRequest` in the `params` map.
	ParamTypes map[string]*Type `protobuf:"bytes,6,rep,name=param_types,json=paramTypes,proto3" json:"param_types,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *PrepareQueryRequest) Reset() {
	*x = PrepareQueryRequest{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrepareQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareQueryRequest) ProtoMessage() {}

func (x *PrepareQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareQueryRequest.ProtoReflect.Descriptor instead.
func (*PrepareQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{21}
}

func (x *PrepareQueryRequest) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

func (x *PrepareQueryRequest) GetAppProfileId() string {
	if x != nil {
		return x.AppProfileId
	}
	return ""
}

func (x *PrepareQueryRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (m *PrepareQueryRequest) GetDataFormat() isPrepareQueryRequest_DataFormat {
	if m != nil {
		return m.DataFormat
	}
	return nil
}

func (x *PrepareQueryRequest) GetProtoFormat() *ProtoFormat {
	if x, ok := x.GetDataFormat().(*PrepareQueryRequest_ProtoFormat); ok {
		return x.ProtoFormat
	}
	return nil
}

func (x *PrepareQueryRequest) GetParamTypes() map[string]*Type {
	if x != nil {
		return x.ParamTypes
	}
	return nil
}

type isPrepareQueryRequest_DataFormat interface {
	isPrepareQueryRequest_DataFormat()
}

type PrepareQueryRequest_ProtoFormat struct {
	// Protocol buffer format as described by ProtoSchema and ProtoRows
	// messages.
	ProtoFormat *ProtoFormat `protobuf:"bytes,4,opt,name=proto_format,json=protoFormat,proto3,oneof"`
}

func (*PrepareQueryRequest_ProtoFormat) isPrepareQueryRequest_DataFormat() {}

// Response message for Bigtable.PrepareQueryResponse
type PrepareQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Structure of rows in the response stream of `ExecuteQueryResponse` for the
	// returned `prepared_query`.
	Metadata *ResultSetMetadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// A serialized prepared query. Clients should treat this as an opaque
	// blob of bytes to send in `ExecuteQueryRequest`.
	PreparedQuery []byte `protobuf:"bytes,2,opt,name=prepared_query,json=preparedQuery,proto3" json:"prepared_query,omitempty"`
	// The time at which the prepared query token becomes invalid.
	// A token may become invalid early due to changes in the data being read, but
	// it provides a guideline to refresh query plans asynchronously.
	ValidUntil *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=valid_until,json=validUntil,proto3" json:"valid_until,omitempty"`
}

func (x *PrepareQueryResponse) Reset() {
	*x = PrepareQueryResponse{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrepareQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrepareQueryResponse) ProtoMessage() {}

func (x *PrepareQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrepareQueryResponse.ProtoReflect.Descriptor instead.
func (*PrepareQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{22}
}

func (x *PrepareQueryResponse) GetMetadata() *ResultSetMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PrepareQueryResponse) GetPreparedQuery() []byte {
	if x != nil {
		return x.PreparedQuery
	}
	return nil
}

func (x *PrepareQueryResponse) GetValidUntil() *timestamppb.Timestamp {
	if x != nil {
		return x.ValidUntil
	}
	return nil
}

// Specifies a piece of a row's contents returned as part of the read
// response stream.
type ReadRowsResponse_CellChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The row key for this chunk of data.  If the row key is empty,
	// this CellChunk is a continuation of the same row as the previous
	// CellChunk in the response stream, even if that CellChunk was in a
	// previous ReadRowsResponse message.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// The column family name for this chunk of data.  If this message
	// is not present this CellChunk is a continuation of the same column
	// family as the previous CellChunk.  The empty string can occur as a
	// column family name in a response so clients must check
	// explicitly for the presence of this message, not just for
	// `family_name.value` being non-empty.
	FamilyName *wrapperspb.StringValue `protobuf:"bytes,2,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// The column qualifier for this chunk of data.  If this message
	// is not present, this CellChunk is a continuation of the same column
	// as the previous CellChunk.  Column qualifiers may be empty so
	// clients must check for the presence of this message, not just
	// for `qualifier.value` being non-empty.
	Qualifier *wrapperspb.BytesValue `protobuf:"bytes,3,opt,name=qualifier,proto3" json:"qualifier,omitempty"`
	// The cell's stored timestamp, which also uniquely identifies it
	// within its column.  Values are always expressed in
	// microseconds, but individual tables may set a coarser
	// granularity to further restrict the allowed values. For
	// example, a table which specifies millisecond granularity will
	// only allow values of `timestamp_micros` which are multiples of
	// 1000.  Timestamps are only set in the first CellChunk per cell
	// (for cells split into multiple chunks).
	TimestampMicros int64 `protobuf:"varint,4,opt,name=timestamp_micros,json=timestampMicros,proto3" json:"timestamp_micros,omitempty"`
	// Labels applied to the cell by a
	// [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
	// on the first CellChunk per cell.
	Labels []string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty"`
	// The value stored in the cell.  Cell values can be split across
	// multiple CellChunks.  In that case only the value field will be
	// set in CellChunks after the first: the timestamp and labels
	// will only be present in the first CellChunk, even if the first
	// CellChunk came in a previous ReadRowsResponse.
	Value []byte `protobuf:"bytes,6,opt,name=value,proto3" json:"value,omitempty"`
	// If this CellChunk is part of a chunked cell value and this is
	// not the final chunk of that cell, value_size will be set to the
	// total length of the cell value.  The client can use this size
	// to pre-allocate memory to hold the full cell value.
	ValueSize int32 `protobuf:"varint,7,opt,name=value_size,json=valueSize,proto3" json:"value_size,omitempty"`
	// Signals to the client concerning previous CellChunks received.
	//
	// Types that are assignable to RowStatus:
	//
	//	*ReadRowsResponse_CellChunk_ResetRow
	//	*ReadRowsResponse_CellChunk_CommitRow
	RowStatus isReadRowsResponse_CellChunk_RowStatus `protobuf_oneof:"row_status"`
}

func (x *ReadRowsResponse_CellChunk) Reset() {
	*x = ReadRowsResponse_CellChunk{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadRowsResponse_CellChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadRowsResponse_CellChunk) ProtoMessage() {}

func (x *ReadRowsResponse_CellChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadRowsResponse_CellChunk.ProtoReflect.Descriptor instead.
func (*ReadRowsResponse_CellChunk) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ReadRowsResponse_CellChunk) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *ReadRowsResponse_CellChunk) GetFamilyName() *wrapperspb.StringValue {
	if x != nil {
		return x.FamilyName
	}
	return nil
}

func (x *ReadRowsResponse_CellChunk) GetQualifier() *wrapperspb.BytesValue {
	if x != nil {
		return x.Qualifier
	}
	return nil
}

func (x *ReadRowsResponse_CellChunk) GetTimestampMicros() int64 {
	if x != nil {
		return x.TimestampMicros
	}
	return 0
}

func (x *ReadRowsResponse_CellChunk) GetLabels() []string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ReadRowsResponse_CellChunk) GetValue() []byte {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *ReadRowsResponse_CellChunk) GetValueSize() int32 {
	if x != nil {
		return x.ValueSize
	}
	return 0
}

func (m *ReadRowsResponse_CellChunk) GetRowStatus() isReadRowsResponse_CellChunk_RowStatus {
	if m != nil {
		return m.RowStatus
	}
	return nil
}

func (x *ReadRowsResponse_CellChunk) GetResetRow() bool {
	if x, ok := x.GetRowStatus().(*ReadRowsResponse_CellChunk_ResetRow); ok {
		return x.ResetRow
	}
	return false
}

func (x *ReadRowsResponse_CellChunk) GetCommitRow() bool {
	if x, ok := x.GetRowStatus().(*ReadRowsResponse_CellChunk_CommitRow); ok {
		return x.CommitRow
	}
	return false
}

type isReadRowsResponse_CellChunk_RowStatus interface {
	isReadRowsResponse_CellChunk_RowStatus()
}

type ReadRowsResponse_CellChunk_ResetRow struct {
	// Indicates that the client should drop all previous chunks for
	// `row_key`, as it will be re-read from the beginning.
	ResetRow bool `protobuf:"varint,8,opt,name=reset_row,json=resetRow,proto3,oneof"`
}

type ReadRowsResponse_CellChunk_CommitRow struct {
	// Indicates that the client can safely process all previous chunks for
	// `row_key`, as its data has been fully read.
	CommitRow bool `protobuf:"varint,9,opt,name=commit_row,json=commitRow,proto3,oneof"`
}

func (*ReadRowsResponse_CellChunk_ResetRow) isReadRowsResponse_CellChunk_RowStatus() {}

func (*ReadRowsResponse_CellChunk_CommitRow) isReadRowsResponse_CellChunk_RowStatus() {}

// A mutation for a given row.
type MutateRowsRequest_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The key of the row to which the `mutations` should be applied.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Required. Changes to be atomically applied to the specified row.
	// Mutations are applied in order, meaning that earlier mutations can be
	// masked by later ones. You must specify at least one mutation.
	Mutations []*Mutation `protobuf:"bytes,2,rep,name=mutations,proto3" json:"mutations,omitempty"`
	// If set consistently across retries, prevents this mutation from being
	// double applied to aggregate column families within a 15m window.
	Idempotency *Idempotency `protobuf:"bytes,3,opt,name=idempotency,proto3" json:"idempotency,omitempty"`
}

func (x *MutateRowsRequest_Entry) Reset() {
	*x = MutateRowsRequest_Entry{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateRowsRequest_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsRequest_Entry) ProtoMessage() {}

func (x *MutateRowsRequest_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsRequest_Entry.ProtoReflect.Descriptor instead.
func (*MutateRowsRequest_Entry) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{6, 0}
}

func (x *MutateRowsRequest_Entry) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *MutateRowsRequest_Entry) GetMutations() []*Mutation {
	if x != nil {
		return x.Mutations
	}
	return nil
}

func (x *MutateRowsRequest_Entry) GetIdempotency() *Idempotency {
	if x != nil {
		return x.Idempotency
	}
	return nil
}

// The result of applying a passed mutation in the original request.
type MutateRowsResponse_Entry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The index into the original request's `entries` list of the Entry
	// for which a result is being reported.
	Index int64 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// The result of the request Entry identified by `index`.
	// Depending on how requests are batched during execution, it is possible
	// for one Entry to fail due to an error with another Entry. In the event
	// that this occurs, the same error will be reported for both entries.
	Status *status.Status `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
}

func (x *MutateRowsResponse_Entry) Reset() {
	*x = MutateRowsResponse_Entry{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MutateRowsResponse_Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MutateRowsResponse_Entry) ProtoMessage() {}

func (x *MutateRowsResponse_Entry) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MutateRowsResponse_Entry.ProtoReflect.Descriptor instead.
func (*MutateRowsResponse_Entry) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{7, 0}
}

func (x *MutateRowsResponse_Entry) GetIndex() int64 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *MutateRowsResponse_Entry) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

// A partial or complete mutation.
type ReadChangeStreamResponse_MutationChunk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If set, then the mutation is a `SetCell` with a chunked value across
	// multiple messages.
	ChunkInfo *ReadChangeStreamResponse_MutationChunk_ChunkInfo `protobuf:"bytes,1,opt,name=chunk_info,json=chunkInfo,proto3" json:"chunk_info,omitempty"`
	// If this is a continuation of a chunked message (`chunked_value_offset` >
	// 0), ignore all fields except the `SetCell`'s value and merge it with
	// the previous message by concatenating the value fields.
	Mutation *Mutation `protobuf:"bytes,2,opt,name=mutation,proto3" json:"mutation,omitempty"`
}

func (x *ReadChangeStreamResponse_MutationChunk) Reset() {
	*x = ReadChangeStreamResponse_MutationChunk{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamResponse_MutationChunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamResponse_MutationChunk) ProtoMessage() {}

func (x *ReadChangeStreamResponse_MutationChunk) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamResponse_MutationChunk.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamResponse_MutationChunk) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18, 0}
}

func (x *ReadChangeStreamResponse_MutationChunk) GetChunkInfo() *ReadChangeStreamResponse_MutationChunk_ChunkInfo {
	if x != nil {
		return x.ChunkInfo
	}
	return nil
}

func (x *ReadChangeStreamResponse_MutationChunk) GetMutation() *Mutation {
	if x != nil {
		return x.Mutation
	}
	return nil
}

// A message corresponding to one or more mutations to the partition
// being streamed. A single logical `DataChange` message may also be split
// across a sequence of multiple individual messages. Messages other than
// the first in a sequence will only have the `type` and `chunks` fields
// populated, with the final message in the sequence also containing `done`
// set to true.
type ReadChangeStreamResponse_DataChange struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of the mutation.
	Type ReadChangeStreamResponse_DataChange_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.bigtable.v2.ReadChangeStreamResponse_DataChange_Type" json:"type,omitempty"`
	// The cluster where the mutation was applied.
	// Not set when `type` is `GARBAGE_COLLECTION`.
	SourceClusterId string `protobuf:"bytes,2,opt,name=source_cluster_id,json=sourceClusterId,proto3" json:"source_cluster_id,omitempty"`
	// The row key for all mutations that are part of this `DataChange`.
	// If the `DataChange` is chunked across multiple messages, then this field
	// will only be set for the first message.
	RowKey []byte `protobuf:"bytes,3,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// The timestamp at which the mutation was applied on the Bigtable server.
	CommitTimestamp *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=commit_timestamp,json=commitTimestamp,proto3" json:"commit_timestamp,omitempty"`
	// A value that lets stream consumers reconstruct Bigtable's
	// conflict resolution semantics.
	// https://cloud.google.com/bigtable/docs/writes#conflict-resolution
	// In the event that the same row key, column family, column qualifier,
	// timestamp are modified on different clusters at the same
	// `commit_timestamp`, the mutation with the larger `tiebreaker` will be the
	// one chosen for the eventually consistent state of the system.
	Tiebreaker int32 `protobuf:"varint,5,opt,name=tiebreaker,proto3" json:"tiebreaker,omitempty"`
	// The mutations associated with this change to the partition.
	// May contain complete mutations or chunks of a multi-message chunked
	// `DataChange` record.
	Chunks []*ReadChangeStreamResponse_MutationChunk `protobuf:"bytes,6,rep,name=chunks,proto3" json:"chunks,omitempty"`
	// When true, indicates that the entire `DataChange` has been read
	// and the client can safely process the message.
	Done bool `protobuf:"varint,8,opt,name=done,proto3" json:"done,omitempty"`
	// An encoded position for this stream's partition to restart reading from.
	// This token is for the StreamPartition from the request.
	Token string `protobuf:"bytes,9,opt,name=token,proto3" json:"token,omitempty"`
	// An estimate of the commit timestamp that is usually lower than or equal
	// to any timestamp for a record that will be delivered in the future on the
	// stream. It is possible that, under particular circumstances that a future
	// record has a timestamp that is lower than a previously seen timestamp.
	// For an example usage see
	// https://beam.apache.org/documentation/basics/#watermarks
	EstimatedLowWatermark *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=estimated_low_watermark,json=estimatedLowWatermark,proto3" json:"estimated_low_watermark,omitempty"`
}

func (x *ReadChangeStreamResponse_DataChange) Reset() {
	*x = ReadChangeStreamResponse_DataChange{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamResponse_DataChange) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamResponse_DataChange) ProtoMessage() {}

func (x *ReadChangeStreamResponse_DataChange) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamResponse_DataChange.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamResponse_DataChange) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18, 1}
}

func (x *ReadChangeStreamResponse_DataChange) GetType() ReadChangeStreamResponse_DataChange_Type {
	if x != nil {
		return x.Type
	}
	return ReadChangeStreamResponse_DataChange_TYPE_UNSPECIFIED
}

func (x *ReadChangeStreamResponse_DataChange) GetSourceClusterId() string {
	if x != nil {
		return x.SourceClusterId
	}
	return ""
}

func (x *ReadChangeStreamResponse_DataChange) GetRowKey() []byte {
	if x != nil {
		return x.RowKey
	}
	return nil
}

func (x *ReadChangeStreamResponse_DataChange) GetCommitTimestamp() *timestamppb.Timestamp {
	if x != nil {
		return x.CommitTimestamp
	}
	return nil
}

func (x *ReadChangeStreamResponse_DataChange) GetTiebreaker() int32 {
	if x != nil {
		return x.Tiebreaker
	}
	return 0
}

func (x *ReadChangeStreamResponse_DataChange) GetChunks() []*ReadChangeStreamResponse_MutationChunk {
	if x != nil {
		return x.Chunks
	}
	return nil
}

func (x *ReadChangeStreamResponse_DataChange) GetDone() bool {
	if x != nil {
		return x.Done
	}
	return false
}

func (x *ReadChangeStreamResponse_DataChange) GetToken() string {
	if x != nil {
		return x.Token
	}
	return ""
}

func (x *ReadChangeStreamResponse_DataChange) GetEstimatedLowWatermark() *timestamppb.Timestamp {
	if x != nil {
		return x.EstimatedLowWatermark
	}
	return nil
}

// A periodic message with information that can be used to checkpoint
// the state of a stream.
type ReadChangeStreamResponse_Heartbeat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A token that can be provided to a subsequent `ReadChangeStream` call
	// to pick up reading at the current stream position.
	ContinuationToken *StreamContinuationToken `protobuf:"bytes,1,opt,name=continuation_token,json=continuationToken,proto3" json:"continuation_token,omitempty"`
	// An estimate of the commit timestamp that is usually lower than or equal
	// to any timestamp for a record that will be delivered in the future on the
	// stream. It is possible that, under particular circumstances that a future
	// record has a timestamp that is lower than a previously seen timestamp.
	// For an example usage see
	// https://beam.apache.org/documentation/basics/#watermarks
	EstimatedLowWatermark *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=estimated_low_watermark,json=estimatedLowWatermark,proto3" json:"estimated_low_watermark,omitempty"`
}

func (x *ReadChangeStreamResponse_Heartbeat) Reset() {
	*x = ReadChangeStreamResponse_Heartbeat{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamResponse_Heartbeat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamResponse_Heartbeat) ProtoMessage() {}

func (x *ReadChangeStreamResponse_Heartbeat) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamResponse_Heartbeat.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamResponse_Heartbeat) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18, 2}
}

func (x *ReadChangeStreamResponse_Heartbeat) GetContinuationToken() *StreamContinuationToken {
	if x != nil {
		return x.ContinuationToken
	}
	return nil
}

func (x *ReadChangeStreamResponse_Heartbeat) GetEstimatedLowWatermark() *timestamppb.Timestamp {
	if x != nil {
		return x.EstimatedLowWatermark
	}
	return nil
}

// A message indicating that the client should stop reading from the stream.
// If status is OK and `continuation_tokens` & `new_partitions` are empty, the
// stream has finished (for example if there was an `end_time` specified).
// If `continuation_tokens` & `new_partitions` are present, then a change in
// partitioning requires the client to open a new stream for each token to
// resume reading. Example:
//
//	                                 [B,      D) ends
//	                                      |
//	                                      v
//	              new_partitions:  [A,  C) [C,  E)
//	continuation_tokens.partitions:  [B,C) [C,D)
//	                                 ^---^ ^---^
//	                                 ^     ^
//	                                 |     |
//	                                 |     StreamContinuationToken 2
//	                                 |
//	                                 StreamContinuationToken 1
//
// To read the new partition [A,C), supply the continuation tokens whose
// ranges cover the new partition, for example ContinuationToken[A,B) &
// ContinuationToken[B,C).
type ReadChangeStreamResponse_CloseStream struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The status of the stream.
	Status *status.Status `protobuf:"bytes,1,opt,name=status,proto3" json:"status,omitempty"`
	// If non-empty, contains the information needed to resume reading their
	// associated partitions.
	ContinuationTokens []*StreamContinuationToken `protobuf:"bytes,2,rep,name=continuation_tokens,json=continuationTokens,proto3" json:"continuation_tokens,omitempty"`
	// If non-empty, contains the new partitions to start reading from, which
	// are related to but not necessarily identical to the partitions for the
	// above `continuation_tokens`.
	NewPartitions []*StreamPartition `protobuf:"bytes,3,rep,name=new_partitions,json=newPartitions,proto3" json:"new_partitions,omitempty"`
}

func (x *ReadChangeStreamResponse_CloseStream) Reset() {
	*x = ReadChangeStreamResponse_CloseStream{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamResponse_CloseStream) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamResponse_CloseStream) ProtoMessage() {}

func (x *ReadChangeStreamResponse_CloseStream) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamResponse_CloseStream.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamResponse_CloseStream) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18, 3}
}

func (x *ReadChangeStreamResponse_CloseStream) GetStatus() *status.Status {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ReadChangeStreamResponse_CloseStream) GetContinuationTokens() []*StreamContinuationToken {
	if x != nil {
		return x.ContinuationTokens
	}
	return nil
}

func (x *ReadChangeStreamResponse_CloseStream) GetNewPartitions() []*StreamPartition {
	if x != nil {
		return x.NewPartitions
	}
	return nil
}

// Information about the chunking of this mutation.
// Only `SetCell` mutations can be chunked, and all chunks for a `SetCell`
// will be delivered contiguously with no other mutation types interleaved.
type ReadChangeStreamResponse_MutationChunk_ChunkInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total value size of all the chunks that make up the `SetCell`.
	ChunkedValueSize int32 `protobuf:"varint,1,opt,name=chunked_value_size,json=chunkedValueSize,proto3" json:"chunked_value_size,omitempty"`
	// The byte offset of this chunk into the total value size of the
	// mutation.
	ChunkedValueOffset int32 `protobuf:"varint,2,opt,name=chunked_value_offset,json=chunkedValueOffset,proto3" json:"chunked_value_offset,omitempty"`
	// When true, this is the last chunk of a chunked `SetCell`.
	LastChunk bool `protobuf:"varint,3,opt,name=last_chunk,json=lastChunk,proto3" json:"last_chunk,omitempty"`
}

func (x *ReadChangeStreamResponse_MutationChunk_ChunkInfo) Reset() {
	*x = ReadChangeStreamResponse_MutationChunk_ChunkInfo{}
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadChangeStreamResponse_MutationChunk_ChunkInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadChangeStreamResponse_MutationChunk_ChunkInfo) ProtoMessage() {}

func (x *ReadChangeStreamResponse_MutationChunk_ChunkInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_bigtable_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReadChangeStreamResponse_MutationChunk_ChunkInfo.ProtoReflect.Descriptor instead.
func (*ReadChangeStreamResponse_MutationChunk_ChunkInfo) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_bigtable_proto_rawDescGZIP(), []int{18, 0, 0}
}

func (x *ReadChangeStreamResponse_MutationChunk_ChunkInfo) GetChunkedValueSize() int32 {
	if x != nil {
		return x.ChunkedValueSize
	}
	return 0
}

func (x *ReadChangeStreamResponse_MutationChunk_ChunkInfo) GetChunkedValueOffset() int32 {
	if x != nil {
		return x.ChunkedValueOffset
	}
	return 0
}

func (x *ReadChangeStreamResponse_MutationChunk_ChunkInfo) GetLastChunk() bool {
	if x != nil {
		return x.LastChunk
	}
	return false
}

var File_google_bigtable_v2_bigtable_proto protoreflect.FileDescriptor

var file_google_bigtable_v2_bigtable_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x76, 0x32, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x18, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x6f, 0x75, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2f, 0x76, 0x32, 0x2f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x76, 0x32, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72,
	0x61, 0x70, 0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc4, 0x05, 0x0a, 0x0f, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0,
	0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61,
	0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x16, 0x6d,
	0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x4d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69,
	0x65, 0x77, 0x52, 0x14, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x56, 0x69, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f,
	0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x2e,
	0x0a, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x6f, 0x77, 0x53, 0x65, 0x74, 0x52, 0x04, 0x72, 0x6f, 0x77, 0x73, 0x12, 0x35,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x77, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x6f, 0x77, 0x73, 0x5f, 0x6c, 0x69,
	0x6d, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x72, 0x6f, 0x77, 0x73, 0x4c,
	0x69, 0x6d, 0x69, 0x74, 0x12, 0x62, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x73, 0x56, 0x69, 0x65, 0x77, 0x52, 0x10, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x56, 0x69, 0x65, 0x77, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x76, 0x65,
	0x72, 0x73, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x76, 0x65,
	0x72, 0x73, 0x65, 0x64, 0x22, 0x66, 0x0a, 0x10, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53,
	0x74, 0x61, 0x74, 0x73, 0x56, 0x69, 0x65, 0x77, 0x12, 0x22, 0x0a, 0x1e, 0x52, 0x45, 0x51, 0x55,
	0x45, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x53, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x16, 0x0a, 0x12,
	0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x53, 0x5f, 0x4e, 0x4f,
	0x4e, 0x45, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x53, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x22, 0xb9, 0x04, 0x0a,
	0x10, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x46, 0x0a, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x65, 0x6c, 0x6c, 0x43, 0x68, 0x75, 0x6e,
	0x6b, 0x52, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x2f, 0x0a, 0x14, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x63, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x5f, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65,
	0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x11, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x63, 0x61,
	0x6e, 0x6e, 0x65, 0x64, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x0d, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74,
	0x61, 0x74, 0x73, 0x52, 0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74,
	0x73, 0x1a, 0xe4, 0x02, 0x0a, 0x09, 0x43, 0x65, 0x6c, 0x6c, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12,
	0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x3d, 0x0a, 0x0b, 0x66, 0x61, 0x6d, 0x69,
	0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x66, 0x61, 0x6d,
	0x69, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x09, 0x71, 0x75, 0x61, 0x6c, 0x69,
	0x66, 0x69, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x79, 0x74,
	0x65, 0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x09, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x12, 0x29, 0x0a, 0x10, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x5f,
	0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x4d, 0x69, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x16, 0x0a,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x09, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x09, 0x72, 0x65,
	0x73, 0x65, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x08, 0x72, 0x65, 0x73, 0x65, 0x74, 0x52, 0x6f, 0x77, 0x12, 0x1f, 0x0a, 0x0a, 0x63, 0x6f, 0x6d,
	0x6d, 0x69, 0x74, 0x5f, 0x72, 0x6f, 0x77, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52,
	0x09, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x52, 0x6f, 0x77, 0x42, 0x0c, 0x0a, 0x0a, 0x72, 0x6f,
	0x77, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22, 0xdb, 0x02, 0x0a, 0x14, 0x53, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x6b, 0x0a, 0x16, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x35, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2f, 0x0a, 0x2d, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52, 0x14, 0x6d, 0x61, 0x74, 0x65,
	0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x53, 0x0a, 0x15, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x21, 0x0a, 0x0c, 0x6f, 0x66, 0x66, 0x73,
	0x65, 0x74, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0b,
	0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x42, 0x79, 0x74, 0x65, 0x73, 0x22, 0x8c, 0x03, 0x0a, 0x10,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65,
	0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x61,
	0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x2d, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52, 0x12,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f,
	0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06,
	0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a, 0x0b, 0x69, 0x64, 0x65, 0x6d, 0x70,
	0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x49, 0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x0b, 0x69,
	0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x22, 0x13, 0x0a, 0x11, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xde, 0x03, 0x0a, 0x11, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x65, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33,
	0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56,
	0x69, 0x65, 0x77, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56,
	0x69, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x4a, 0x0a,
	0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x1a, 0xa4, 0x01, 0x0a, 0x05, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x3f, 0x0a, 0x09,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x41, 0x0a,
	0x0b, 0x69, 0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x49, 0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65,
	0x6e, 0x63, 0x79, 0x52, 0x0b, 0x69, 0x64, 0x65, 0x6d, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x63, 0x79,
	0x22, 0x8b, 0x02, 0x0a, 0x12, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75,
	0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12,
	0x4e, 0x0a, 0x0f, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x61,
	0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x48, 0x00, 0x52, 0x0d, 0x72,
	0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x88, 0x01, 0x01, 0x1a,
	0x49, 0x0a, 0x05, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x64, 0x65,
	0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x2a,
	0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x12, 0x0a, 0x10, 0x5f, 0x72,
	0x61, 0x74, 0x65, 0x5f, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x5a,
	0x0a, 0x0d, 0x52, 0x61, 0x74, 0x65, 0x4c, 0x69, 0x6d, 0x69, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x31, 0x0a, 0x06, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x65, 0x72, 0x69,
	0x6f, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x01, 0x52, 0x06, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x22, 0xe6, 0x03, 0x0a, 0x18, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x33, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x56, 0x69, 0x65, 0x77, 0x52, 0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x56, 0x69, 0x65, 0x77, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12,
	0x1c, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x48, 0x0a,
	0x10, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x77,
	0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x43, 0x0a, 0x0e, 0x74, 0x72, 0x75, 0x65, 0x5f,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x74,
	0x72, 0x75, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x45, 0x0a, 0x0f,
	0x66, 0x61, 0x6c, 0x73, 0x65, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0e, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0x48, 0x0a, 0x19, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x4d,
	0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x2b, 0x0a, 0x11, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x22, 0x7d, 0x0a,
	0x12, 0x50, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x72, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c,
	0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x15, 0x0a, 0x13,
	0x50, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x72, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x19, 0x52, 0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69,
	0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x62, 0x6c,
	0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x65, 0x0a, 0x14,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x01, 0xfa,
	0x41, 0x2d, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x52,
	0x12, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70,
	0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x07, 0x72, 0x6f, 0x77,
	0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x42, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64,
	0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x22, 0x47, 0x0a, 0x1a, 0x52,
	0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x6f,
	0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x29, 0x0a, 0x03, 0x72, 0x6f, 0x77,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x6f, 0x77, 0x52,
	0x03, 0x72, 0x6f, 0x77, 0x22, 0x9f, 0x01, 0x0a, 0x2c, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x24, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x22, 0x72, 0x0a, 0x2d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfa, 0x03, 0x0a, 0x17, 0x52,
	0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x49, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x09, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x24, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x49, 0x64, 0x12, 0x41, 0x0a, 0x09, 0x70, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x09, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0a, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x09, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x5f, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x69,
	0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x48, 0x00, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x48, 0x0a, 0x12, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x5f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61,
	0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0c, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x66, 0x72, 0x6f, 0x6d, 0x22, 0xd1, 0x0c, 0x0a, 0x18, 0x52, 0x65, 0x61, 0x64,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5a, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x63, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x12, 0x56, 0x0a, 0x09, 0x68, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x48, 0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x48, 0x00, 0x52, 0x09, 0x68,
	0x65, 0x61, 0x72, 0x74, 0x62, 0x65, 0x61, 0x74, 0x12, 0x5d, 0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x5f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6c, 0x6f,
	0x73, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x6c, 0x6f, 0x73,
	0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x1a, 0xbb, 0x02, 0x0a, 0x0d, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x63, 0x0a, 0x0a, 0x63, 0x68, 0x75,
	0x6e, 0x6b, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x49,
	0x6e, 0x66, 0x6f, 0x52, 0x09, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x38,
	0x0a, 0x08, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x8a, 0x01, 0x0a, 0x09, 0x43, 0x68, 0x75,
	0x6e, 0x6b, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x65,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x10, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x65, 0x64, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x12, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x09, 0x6c, 0x61, 0x73, 0x74,
	0x43, 0x68, 0x75, 0x6e, 0x6b, 0x1a, 0xae, 0x04, 0x0a, 0x0a, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68,
	0x61, 0x6e, 0x67, 0x65, 0x12, 0x50, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72,
	0x49, 0x64, 0x12, 0x17, 0x0a, 0x07, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x06, 0x72, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x12, 0x45, 0x0a, 0x10, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x0f, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x69, 0x65, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x65, 0x72,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0a, 0x74, 0x69, 0x65, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x65, 0x72, 0x12, 0x52, 0x0a, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e,
	0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x52, 0x06,
	0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x04, 0x64, 0x6f, 0x6e, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x52, 0x0a, 0x17, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f,
	0x77, 0x5f, 0x77, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x15, 0x65,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x77, 0x57, 0x61, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x72, 0x6b, 0x22, 0x50, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x55, 0x53, 0x45, 0x52, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12,
	0x47, 0x41, 0x52, 0x42, 0x41, 0x47, 0x45, 0x5f, 0x43, 0x4f, 0x4c, 0x4c, 0x45, 0x43, 0x54, 0x49,
	0x4f, 0x4e, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x41,
	0x54, 0x49, 0x4f, 0x4e, 0x10, 0x03, 0x1a, 0xbb, 0x01, 0x0a, 0x09, 0x48, 0x65, 0x61, 0x72, 0x74,
	0x62, 0x65, 0x61, 0x74, 0x12, 0x5a, 0x0a, 0x12, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x74,
	0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x11, 0x63,
	0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x52, 0x0a, 0x17, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x6c, 0x6f,
	0x77, 0x5f, 0x77, 0x61, 0x74, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x15, 0x65,
	0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x4c, 0x6f, 0x77, 0x57, 0x61, 0x74, 0x65, 0x72,
	0x6d, 0x61, 0x72, 0x6b, 0x1a, 0xe3, 0x01, 0x0a, 0x0b, 0x43, 0x6c, 0x6f, 0x73, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x12, 0x2a, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70,
	0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x5c, 0x0a, 0x13, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x52, 0x12, 0x63, 0x6f, 0x6e, 0x74,
	0x69, 0x6e, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x12, 0x4a,
	0x0a, 0x0e, 0x6e, 0x65, 0x77, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x6e, 0x65, 0x77,
	0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0f, 0x0a, 0x0d, 0x73, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x22, 0x81, 0x04, 0x0a, 0x13,
	0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x1b, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x05, 0xe0, 0x41, 0x02, 0x18, 0x01, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
	0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x48, 0x0a, 0x0c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x42, 0x02, 0x18,
	0x01, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x26, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x73,
	0x75, 0x6d, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x1a, 0x54, 0x0a, 0x0b, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2f, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22,
	0xa9, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x43, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x53, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x48, 0x00, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a,
	0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x53, 0x65, 0x74, 0x48, 0x00, 0x52, 0x07, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x42,
	0x0a, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbc, 0x03, 0x0a, 0x13,
	0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x27, 0x0a, 0x25, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70,
	0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x50, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x44, 0x0a,
	0x0c, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x48, 0x00, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x12, 0x5d, 0x0a, 0x0b, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70,
	0x65, 0x73, 0x1a, 0x57, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0d, 0x0a, 0x0b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x22, 0xbd, 0x01, 0x0a, 0x14, 0x50,
	0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6c,
	0x74, 0x53, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72,
	0x65, 0x64, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x0d,
	0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x64, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x3b, 0x0a,
	0x0b, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x55, 0x6e, 0x74, 0x69, 0x6c, 0x32, 0xdb, 0x27, 0x0a, 0x08, 0x42,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x12, 0xd5, 0x04, 0x0a, 0x08, 0x52, 0x65, 0x61, 0x64,
	0x52, 0x6f, 0x77, 0x73, 0x12, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x52, 0x6f,
	0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xfb, 0x03, 0xda, 0x41, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xda,
	0x41, 0x19, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x70, 0x70,
	0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xf1, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5a, 0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64,
	0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77,
	0x73, 0x5a, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6d, 0x61, 0x74,
	0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x61, 0x74, 0x65, 0x72,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x61, 0x64, 0x52, 0x6f, 0x77, 0x73, 0x22, 0x39, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x52,
	0x6f, 0x77, 0x73, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0xd3, 0x01, 0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x47, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a,
	0x2a, 0x12, 0x3a, 0x0a, 0x16, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x30, 0x01, 0x12,
	0xea, 0x04, 0x0a, 0x0d, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79,
	0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77,
	0x4b, 0x65, 0x79, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x81, 0x04, 0xda, 0x41, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x19, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xf7, 0x01, 0x5a, 0x5c, 0x12, 0x5a, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73, 0x5a, 0x57, 0x12, 0x55, 0x2f, 0x76, 0x32, 0x2f, 0x7b,
	0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x61,
	0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73,
	0x12, 0x3e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x52, 0x6f, 0x77, 0x4b, 0x65, 0x79, 0x73,
	0x8a, 0xd3, 0xe4, 0x93, 0x02, 0xd3, 0x01, 0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69,
	0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x47, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x7b,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0x3a,
	0x0a, 0x16, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x30, 0x01, 0x12, 0xe9, 0x03, 0x0a,
	0x09, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x24, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8e, 0x03, 0xda, 0x41, 0x1c, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x2c,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0xda, 0x41, 0x2b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x6d,
	0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f,
	0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9c, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x22, 0x3a,
	0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x97,
	0x01, 0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2c, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a,
	0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12,
	0x47, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69,
	0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xdc, 0x03, 0x0a, 0x0a, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xfc, 0x02, 0xda, 0x41, 0x12, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0xda, 0x41,
	0x21, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x65, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5c, 0x3a, 0x01,
	0x2a, 0x22, 0x57, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x75, 0x74,
	0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x6d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x22, 0x3b, 0x2f, 0x76, 0x32, 0x2f,
	0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x6d, 0x75, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x73, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x97, 0x01, 0x12, 0x3a,
	0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c, 0x7b, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e, 0x61, 0x70,
	0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x47, 0x0a, 0x14,
	0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x30, 0x01, 0x12, 0xdd, 0x04, 0x0a, 0x11, 0x43, 0x68, 0x65, 0x63,
	0x6b, 0x41, 0x6e, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x12, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32,
	0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52,
	0x6f, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xea, 0x03, 0xda, 0x41, 0x42,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72, 0x6f, 0x77, 0x5f, 0x6b,
	0x65, 0x79, 0x2c, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x2c, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2c, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x5f, 0x6d, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0xda, 0x41, 0x51, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c,
	0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x2c, 0x74, 0x72, 0x75, 0x65, 0x5f, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x5f, 0x6d, 0x75,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xac, 0x01, 0x3a, 0x01, 0x2a,
	0x5a, 0x63, 0x3a, 0x01, 0x2a, 0x22, 0x5e, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64, 0x4d, 0x75, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x6f, 0x77, 0x22, 0x42, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x41, 0x6e, 0x64,
	0x4d, 0x75, 0x74, 0x61, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x97, 0x01,
	0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2c,
	0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e,
	0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x47,
	0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65,
	0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xee, 0x01, 0x0a, 0x0b, 0x50, 0x69, 0x6e, 0x67,
	0x41, 0x6e, 0x64, 0x57, 0x61, 0x72, 0x6d, 0x12, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x69, 0x6e,
	0x67, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x72, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x69, 0x6e, 0x67, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x72, 0x6d,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8d, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0xda, 0x41, 0x13, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2b, 0x3a, 0x01,
	0x2a, 0x22, 0x26, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x69, 0x6e, 0x67, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12,
	0x25, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12, 0x8e, 0x04, 0x0a, 0x12, 0x52, 0x65, 0x61,
	0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x12,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57,
	0x72, 0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x76, 0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x98,
	0x03, 0xda, 0x41, 0x18, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72,
	0x6f, 0x77, 0x5f, 0x6b, 0x65, 0x79, 0x2c, 0x72, 0x75, 0x6c, 0x65, 0x73, 0xda, 0x41, 0x27, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x72, 0x6f, 0x77, 0x5f, 0x6b, 0x65,
	0x79, 0x2c, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66,
	0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xae, 0x01, 0x3a, 0x01, 0x2a,
	0x5a, 0x64, 0x3a, 0x01, 0x2a, 0x22, 0x5f, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x68,
	0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x79, 0x57, 0x72,
	0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x22, 0x43, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x61, 0x64, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x79, 0x57, 0x72, 0x69, 0x74, 0x65, 0x52, 0x6f, 0x77, 0x8a, 0xd3, 0xe4, 0x93, 0x02,
	0x97, 0x01, 0x12, 0x3a, 0x0a, 0x0a, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x2c, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10,
	0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64,
	0x12, 0x47, 0x0a, 0x14, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x5f, 0x76,
	0x69, 0x65, 0x77, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x2a, 0x2a, 0x12, 0xbb, 0x02, 0x0a, 0x25, 0x47, 0x65,
	0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x61,
	0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62,
	0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8a, 0x01, 0xda, 0x41, 0x0a, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x19, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c,
	0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5b, 0x3a, 0x01, 0x2a, 0x22, 0x56, 0x2f,
	0x76, 0x32, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x43,
	0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x50, 0x61, 0x72, 0x74, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x30, 0x01, 0x12, 0xe6, 0x01, 0x0a, 0x10, 0x52, 0x65, 0x61, 0x64,
	0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x12, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x32, 0x2e, 0x52, 0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x52,
	0x65, 0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x75, 0xda, 0x41, 0x0a, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0xda, 0x41, 0x19, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x3a, 0x01, 0x2a, 0x22, 0x41, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x61, 0x64, 0x43, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x30, 0x01,
	0x12, 0xa9, 0x02, 0x0a, 0x0c, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e,
	0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc5, 0x01, 0xda, 0x41, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0xda, 0x41, 0x22,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2c, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x32,
	0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x2e, 0x0a, 0x0d, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e, 0x61, 0x70,
	0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x12, 0xab, 0x02, 0x0a,
	0x0c, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e,
	0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x45, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xc5, 0x01, 0xda, 0x41, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0xda, 0x41, 0x22, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2c,
	0x61, 0x70, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x32, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x8a, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12, 0x2e, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x10, 0x0a, 0x0e, 0x61, 0x70, 0x70, 0x5f, 0x70, 0x72,
	0x6f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x69, 0x64, 0x30, 0x01, 0x1a, 0xdb, 0x02, 0xca, 0x41, 0x17,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0xbd, 0x02, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x64,
	0x61, 0x74, 0x61, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62,
	0x6c, 0x65, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x6f, 0x6e, 0x6c, 0x79,
	0x2c, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c,
	0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72,
	0x65, 0x61, 0x64, 0x2d, 0x6f, 0x6e, 0x6c, 0x79, 0x42, 0xf5, 0x04, 0xea, 0x41, 0x50, 0x0a, 0x25,
	0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x27, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0xea, 0x41,
	0x5c, 0x0a, 0x22, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x62, 0x6c, 0x65, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x7d, 0xea, 0x41, 0x87,
	0x01, 0x0a, 0x2b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x58,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x2f, 0x7b,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x7d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x65,
	0x64, 0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x7a,
	0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x7d, 0xea, 0x41, 0x7e, 0x0a, 0x2d, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x61, 0x74, 0x65, 0x72, 0x69,
	0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x56, 0x69, 0x65, 0x77, 0x12, 0x4d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64,
	0x56, 0x69, 0x65, 0x77, 0x73, 0x2f, 0x7b, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x64, 0x5f, 0x76, 0x69, 0x65, 0x77, 0x7d, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76,
	0x32, 0x42, 0x0d, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x70,
	0x62, 0x3b, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x74,
	0x61, 0x62, 0x6c, 0x65, 0x2e, 0x56, 0x32, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5c,
	0x56, 0x32, 0xea, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a, 0x56, 0x32,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_v2_bigtable_proto_rawDescOnce sync.Once
	file_google_bigtable_v2_bigtable_proto_rawDescData = file_google_bigtable_v2_bigtable_proto_rawDesc
)

func file_google_bigtable_v2_bigtable_proto_rawDescGZIP() []byte {
	file_google_bigtable_v2_bigtable_proto_rawDescOnce.Do(func() {
		file_google_bigtable_v2_bigtable_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_v2_bigtable_proto_rawDescData)
	})
	return file_google_bigtable_v2_bigtable_proto_rawDescData
}

var file_google_bigtable_v2_bigtable_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_bigtable_v2_bigtable_proto_msgTypes = make([]protoimpl.MessageInfo, 33)
var file_google_bigtable_v2_bigtable_proto_goTypes = []any{
	(ReadRowsRequest_RequestStatsView)(0),                    // 0: google.bigtable.v2.ReadRowsRequest.RequestStatsView
	(ReadChangeStreamResponse_DataChange_Type)(0),            // 1: google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type
	(*ReadRowsRequest)(nil),                                  // 2: google.bigtable.v2.ReadRowsRequest
	(*ReadRowsResponse)(nil),                                 // 3: google.bigtable.v2.ReadRowsResponse
	(*SampleRowKeysRequest)(nil),                             // 4: google.bigtable.v2.SampleRowKeysRequest
	(*SampleRowKeysResponse)(nil),                            // 5: google.bigtable.v2.SampleRowKeysResponse
	(*MutateRowRequest)(nil),                                 // 6: google.bigtable.v2.MutateRowRequest
	(*MutateRowResponse)(nil),                                // 7: google.bigtable.v2.MutateRowResponse
	(*MutateRowsRequest)(nil),                                // 8: google.bigtable.v2.MutateRowsRequest
	(*MutateRowsResponse)(nil),                               // 9: google.bigtable.v2.MutateRowsResponse
	(*RateLimitInfo)(nil),                                    // 10: google.bigtable.v2.RateLimitInfo
	(*CheckAndMutateRowRequest)(nil),                         // 11: google.bigtable.v2.CheckAndMutateRowRequest
	(*CheckAndMutateRowResponse)(nil),                        // 12: google.bigtable.v2.CheckAndMutateRowResponse
	(*PingAndWarmRequest)(nil),                               // 13: google.bigtable.v2.PingAndWarmRequest
	(*PingAndWarmResponse)(nil),                              // 14: google.bigtable.v2.PingAndWarmResponse
	(*ReadModifyWriteRowRequest)(nil),                        // 15: google.bigtable.v2.ReadModifyWriteRowRequest
	(*ReadModifyWriteRowResponse)(nil),                       // 16: google.bigtable.v2.ReadModifyWriteRowResponse
	(*GenerateInitialChangeStreamPartitionsRequest)(nil),     // 17: google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest
	(*GenerateInitialChangeStreamPartitionsResponse)(nil),    // 18: google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse
	(*ReadChangeStreamRequest)(nil),                          // 19: google.bigtable.v2.ReadChangeStreamRequest
	(*ReadChangeStreamResponse)(nil),                         // 20: google.bigtable.v2.ReadChangeStreamResponse
	(*ExecuteQueryRequest)(nil),                              // 21: google.bigtable.v2.ExecuteQueryRequest
	(*ExecuteQueryResponse)(nil),                             // 22: google.bigtable.v2.ExecuteQueryResponse
	(*PrepareQueryRequest)(nil),                              // 23: google.bigtable.v2.PrepareQueryRequest
	(*PrepareQueryResponse)(nil),                             // 24: google.bigtable.v2.PrepareQueryResponse
	(*ReadRowsResponse_CellChunk)(nil),                       // 25: google.bigtable.v2.ReadRowsResponse.CellChunk
	(*MutateRowsRequest_Entry)(nil),                          // 26: google.bigtable.v2.MutateRowsRequest.Entry
	(*MutateRowsResponse_Entry)(nil),                         // 27: google.bigtable.v2.MutateRowsResponse.Entry
	(*ReadChangeStreamResponse_MutationChunk)(nil),           // 28: google.bigtable.v2.ReadChangeStreamResponse.MutationChunk
	(*ReadChangeStreamResponse_DataChange)(nil),              // 29: google.bigtable.v2.ReadChangeStreamResponse.DataChange
	(*ReadChangeStreamResponse_Heartbeat)(nil),               // 30: google.bigtable.v2.ReadChangeStreamResponse.Heartbeat
	(*ReadChangeStreamResponse_CloseStream)(nil),             // 31: google.bigtable.v2.ReadChangeStreamResponse.CloseStream
	(*ReadChangeStreamResponse_MutationChunk_ChunkInfo)(nil), // 32: google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
	nil,                              // 33: google.bigtable.v2.ExecuteQueryRequest.ParamsEntry
	nil,                              // 34: google.bigtable.v2.PrepareQueryRequest.ParamTypesEntry
	(*RowSet)(nil),                   // 35: google.bigtable.v2.RowSet
	(*RowFilter)(nil),                // 36: google.bigtable.v2.RowFilter
	(*RequestStats)(nil),             // 37: google.bigtable.v2.RequestStats
	(*Mutation)(nil),                 // 38: google.bigtable.v2.Mutation
	(*Idempotency)(nil),              // 39: google.bigtable.v2.Idempotency
	(*durationpb.Duration)(nil),      // 40: google.protobuf.Duration
	(*ReadModifyWriteRule)(nil),      // 41: google.bigtable.v2.ReadModifyWriteRule
	(*Row)(nil),                      // 42: google.bigtable.v2.Row
	(*StreamPartition)(nil),          // 43: google.bigtable.v2.StreamPartition
	(*timestamppb.Timestamp)(nil),    // 44: google.protobuf.Timestamp
	(*StreamContinuationTokens)(nil), // 45: google.bigtable.v2.StreamContinuationTokens
	(*ProtoFormat)(nil),              // 46: google.bigtable.v2.ProtoFormat
	(*ResultSetMetadata)(nil),        // 47: google.bigtable.v2.ResultSetMetadata
	(*PartialResultSet)(nil),         // 48: google.bigtable.v2.PartialResultSet
	(*wrapperspb.StringValue)(nil),   // 49: google.protobuf.StringValue
	(*wrapperspb.BytesValue)(nil),    // 50: google.protobuf.BytesValue
	(*status.Status)(nil),            // 51: google.rpc.Status
	(*StreamContinuationToken)(nil),  // 52: google.bigtable.v2.StreamContinuationToken
	(*Value)(nil),                    // 53: google.bigtable.v2.Value
	(*Type)(nil),                     // 54: google.bigtable.v2.Type
}
var file_google_bigtable_v2_bigtable_proto_depIdxs = []int32{
	35, // 0: google.bigtable.v2.ReadRowsRequest.rows:type_name -> google.bigtable.v2.RowSet
	36, // 1: google.bigtable.v2.ReadRowsRequest.filter:type_name -> google.bigtable.v2.RowFilter
	0,  // 2: google.bigtable.v2.ReadRowsRequest.request_stats_view:type_name -> google.bigtable.v2.ReadRowsRequest.RequestStatsView
	25, // 3: google.bigtable.v2.ReadRowsResponse.chunks:type_name -> google.bigtable.v2.ReadRowsResponse.CellChunk
	37, // 4: google.bigtable.v2.ReadRowsResponse.request_stats:type_name -> google.bigtable.v2.RequestStats
	38, // 5: google.bigtable.v2.MutateRowRequest.mutations:type_name -> google.bigtable.v2.Mutation
	39, // 6: google.bigtable.v2.MutateRowRequest.idempotency:type_name -> google.bigtable.v2.Idempotency
	26, // 7: google.bigtable.v2.MutateRowsRequest.entries:type_name -> google.bigtable.v2.MutateRowsRequest.Entry
	27, // 8: google.bigtable.v2.MutateRowsResponse.entries:type_name -> google.bigtable.v2.MutateRowsResponse.Entry
	10, // 9: google.bigtable.v2.MutateRowsResponse.rate_limit_info:type_name -> google.bigtable.v2.RateLimitInfo
	40, // 10: google.bigtable.v2.RateLimitInfo.period:type_name -> google.protobuf.Duration
	36, // 11: google.bigtable.v2.CheckAndMutateRowRequest.predicate_filter:type_name -> google.bigtable.v2.RowFilter
	38, // 12: google.bigtable.v2.CheckAndMutateRowRequest.true_mutations:type_name -> google.bigtable.v2.Mutation
	38, // 13: google.bigtable.v2.CheckAndMutateRowRequest.false_mutations:type_name -> google.bigtable.v2.Mutation
	41, // 14: google.bigtable.v2.ReadModifyWriteRowRequest.rules:type_name -> google.bigtable.v2.ReadModifyWriteRule
	42, // 15: google.bigtable.v2.ReadModifyWriteRowResponse.row:type_name -> google.bigtable.v2.Row
	43, // 16: google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse.partition:type_name -> google.bigtable.v2.StreamPartition
	43, // 17: google.bigtable.v2.ReadChangeStreamRequest.partition:type_name -> google.bigtable.v2.StreamPartition
	44, // 18: google.bigtable.v2.ReadChangeStreamRequest.start_time:type_name -> google.protobuf.Timestamp
	45, // 19: google.bigtable.v2.ReadChangeStreamRequest.continuation_tokens:type_name -> google.bigtable.v2.StreamContinuationTokens
	44, // 20: google.bigtable.v2.ReadChangeStreamRequest.end_time:type_name -> google.protobuf.Timestamp
	40, // 21: google.bigtable.v2.ReadChangeStreamRequest.heartbeat_duration:type_name -> google.protobuf.Duration
	29, // 22: google.bigtable.v2.ReadChangeStreamResponse.data_change:type_name -> google.bigtable.v2.ReadChangeStreamResponse.DataChange
	30, // 23: google.bigtable.v2.ReadChangeStreamResponse.heartbeat:type_name -> google.bigtable.v2.ReadChangeStreamResponse.Heartbeat
	31, // 24: google.bigtable.v2.ReadChangeStreamResponse.close_stream:type_name -> google.bigtable.v2.ReadChangeStreamResponse.CloseStream
	46, // 25: google.bigtable.v2.ExecuteQueryRequest.proto_format:type_name -> google.bigtable.v2.ProtoFormat
	33, // 26: google.bigtable.v2.ExecuteQueryRequest.params:type_name -> google.bigtable.v2.ExecuteQueryRequest.ParamsEntry
	47, // 27: google.bigtable.v2.ExecuteQueryResponse.metadata:type_name -> google.bigtable.v2.ResultSetMetadata
	48, // 28: google.bigtable.v2.ExecuteQueryResponse.results:type_name -> google.bigtable.v2.PartialResultSet
	46, // 29: google.bigtable.v2.PrepareQueryRequest.proto_format:type_name -> google.bigtable.v2.ProtoFormat
	34, // 30: google.bigtable.v2.PrepareQueryRequest.param_types:type_name -> google.bigtable.v2.PrepareQueryRequest.ParamTypesEntry
	47, // 31: google.bigtable.v2.PrepareQueryResponse.metadata:type_name -> google.bigtable.v2.ResultSetMetadata
	44, // 32: google.bigtable.v2.PrepareQueryResponse.valid_until:type_name -> google.protobuf.Timestamp
	49, // 33: google.bigtable.v2.ReadRowsResponse.CellChunk.family_name:type_name -> google.protobuf.StringValue
	50, // 34: google.bigtable.v2.ReadRowsResponse.CellChunk.qualifier:type_name -> google.protobuf.BytesValue
	38, // 35: google.bigtable.v2.MutateRowsRequest.Entry.mutations:type_name -> google.bigtable.v2.Mutation
	39, // 36: google.bigtable.v2.MutateRowsRequest.Entry.idempotency:type_name -> google.bigtable.v2.Idempotency
	51, // 37: google.bigtable.v2.MutateRowsResponse.Entry.status:type_name -> google.rpc.Status
	32, // 38: google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.chunk_info:type_name -> google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.ChunkInfo
	38, // 39: google.bigtable.v2.ReadChangeStreamResponse.MutationChunk.mutation:type_name -> google.bigtable.v2.Mutation
	1,  // 40: google.bigtable.v2.ReadChangeStreamResponse.DataChange.type:type_name -> google.bigtable.v2.ReadChangeStreamResponse.DataChange.Type
	44, // 41: google.bigtable.v2.ReadChangeStreamResponse.DataChange.commit_timestamp:type_name -> google.protobuf.Timestamp
	28, // 42: google.bigtable.v2.ReadChangeStreamResponse.DataChange.chunks:type_name -> google.bigtable.v2.ReadChangeStreamResponse.MutationChunk
	44, // 43: google.bigtable.v2.ReadChangeStreamResponse.DataChange.estimated_low_watermark:type_name -> google.protobuf.Timestamp
	52, // 44: google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.continuation_token:type_name -> google.bigtable.v2.StreamContinuationToken
	44, // 45: google.bigtable.v2.ReadChangeStreamResponse.Heartbeat.estimated_low_watermark:type_name -> google.protobuf.Timestamp
	51, // 46: google.bigtable.v2.ReadChangeStreamResponse.CloseStream.status:type_name -> google.rpc.Status
	52, // 47: google.bigtable.v2.ReadChangeStreamResponse.CloseStream.continuation_tokens:type_name -> google.bigtable.v2.StreamContinuationToken
	43, // 48: google.bigtable.v2.ReadChangeStreamResponse.CloseStream.new_partitions:type_name -> google.bigtable.v2.StreamPartition
	53, // 49: google.bigtable.v2.ExecuteQueryRequest.ParamsEntry.value:type_name -> google.bigtable.v2.Value
	54, // 50: google.bigtable.v2.PrepareQueryRequest.ParamTypesEntry.value:type_name -> google.bigtable.v2.Type
	2,  // 51: google.bigtable.v2.Bigtable.ReadRows:input_type -> google.bigtable.v2.ReadRowsRequest
	4,  // 52: google.bigtable.v2.Bigtable.SampleRowKeys:input_type -> google.bigtable.v2.SampleRowKeysRequest
	6,  // 53: google.bigtable.v2.Bigtable.MutateRow:input_type -> google.bigtable.v2.MutateRowRequest
	8,  // 54: google.bigtable.v2.Bigtable.MutateRows:input_type -> google.bigtable.v2.MutateRowsRequest
	11, // 55: google.bigtable.v2.Bigtable.CheckAndMutateRow:input_type -> google.bigtable.v2.CheckAndMutateRowRequest
	13, // 56: google.bigtable.v2.Bigtable.PingAndWarm:input_type -> google.bigtable.v2.PingAndWarmRequest
	15, // 57: google.bigtable.v2.Bigtable.ReadModifyWriteRow:input_type -> google.bigtable.v2.ReadModifyWriteRowRequest
	17, // 58: google.bigtable.v2.Bigtable.GenerateInitialChangeStreamPartitions:input_type -> google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest
	19, // 59: google.bigtable.v2.Bigtable.ReadChangeStream:input_type -> google.bigtable.v2.ReadChangeStreamRequest
	23, // 60: google.bigtable.v2.Bigtable.PrepareQuery:input_type -> google.bigtable.v2.PrepareQueryRequest
	21, // 61: google.bigtable.v2.Bigtable.ExecuteQuery:input_type -> google.bigtable.v2.ExecuteQueryRequest
	3,  // 62: google.bigtable.v2.Bigtable.ReadRows:output_type -> google.bigtable.v2.ReadRowsResponse
	5,  // 63: google.bigtable.v2.Bigtable.SampleRowKeys:output_type -> google.bigtable.v2.SampleRowKeysResponse
	7,  // 64: google.bigtable.v2.Bigtable.MutateRow:output_type -> google.bigtable.v2.MutateRowResponse
	9,  // 65: google.bigtable.v2.Bigtable.MutateRows:output_type -> google.bigtable.v2.MutateRowsResponse
	12, // 66: google.bigtable.v2.Bigtable.CheckAndMutateRow:output_type -> google.bigtable.v2.CheckAndMutateRowResponse
	14, // 67: google.bigtable.v2.Bigtable.PingAndWarm:output_type -> google.bigtable.v2.PingAndWarmResponse
	16, // 68: google.bigtable.v2.Bigtable.ReadModifyWriteRow:output_type -> google.bigtable.v2.ReadModifyWriteRowResponse
	18, // 69: google.bigtable.v2.Bigtable.GenerateInitialChangeStreamPartitions:output_type -> google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse
	20, // 70: google.bigtable.v2.Bigtable.ReadChangeStream:output_type -> google.bigtable.v2.ReadChangeStreamResponse
	24, // 71: google.bigtable.v2.Bigtable.PrepareQuery:output_type -> google.bigtable.v2.PrepareQueryResponse
	22, // 72: google.bigtable.v2.Bigtable.ExecuteQuery:output_type -> google.bigtable.v2.ExecuteQueryResponse
	62, // [62:73] is the sub-list for method output_type
	51, // [51:62] is the sub-list for method input_type
	51, // [51:51] is the sub-list for extension type_name
	51, // [51:51] is the sub-list for extension extendee
	0,  // [0:51] is the sub-list for field type_name
}

func init() { file_google_bigtable_v2_bigtable_proto_init() }
func file_google_bigtable_v2_bigtable_proto_init() {
	if File_google_bigtable_v2_bigtable_proto != nil {
		return
	}
	file_google_bigtable_v2_data_proto_init()
	file_google_bigtable_v2_request_stats_proto_init()
	file_google_bigtable_v2_types_proto_init()
	file_google_bigtable_v2_bigtable_proto_msgTypes[7].OneofWrappers = []any{}
	file_google_bigtable_v2_bigtable_proto_msgTypes[17].OneofWrappers = []any{
		(*ReadChangeStreamRequest_StartTime)(nil),
		(*ReadChangeStreamRequest_ContinuationTokens)(nil),
	}
	file_google_bigtable_v2_bigtable_proto_msgTypes[18].OneofWrappers = []any{
		(*ReadChangeStreamResponse_DataChange_)(nil),
		(*ReadChangeStreamResponse_Heartbeat_)(nil),
		(*ReadChangeStreamResponse_CloseStream_)(nil),
	}
	file_google_bigtable_v2_bigtable_proto_msgTypes[19].OneofWrappers = []any{
		(*ExecuteQueryRequest_ProtoFormat)(nil),
	}
	file_google_bigtable_v2_bigtable_proto_msgTypes[20].OneofWrappers = []any{
		(*ExecuteQueryResponse_Metadata)(nil),
		(*ExecuteQueryResponse_Results)(nil),
	}
	file_google_bigtable_v2_bigtable_proto_msgTypes[21].OneofWrappers = []any{
		(*PrepareQueryRequest_ProtoFormat)(nil),
	}
	file_google_bigtable_v2_bigtable_proto_msgTypes[23].OneofWrappers = []any{
		(*ReadRowsResponse_CellChunk_ResetRow)(nil),
		(*ReadRowsResponse_CellChunk_CommitRow)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_v2_bigtable_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   33,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_bigtable_v2_bigtable_proto_goTypes,
		DependencyIndexes: file_google_bigtable_v2_bigtable_proto_depIdxs,
		EnumInfos:         file_google_bigtable_v2_bigtable_proto_enumTypes,
		MessageInfos:      file_google_bigtable_v2_bigtable_proto_msgTypes,
	}.Build()
	File_google_bigtable_v2_bigtable_proto = out.File
	file_google_bigtable_v2_bigtable_proto_rawDesc = nil
	file_google_bigtable_v2_bigtable_proto_goTypes = nil
	file_google_bigtable_v2_bigtable_proto_depIdxs = nil
}
