// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/encryption_spec.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	EncryptionSpecService_GetEncryptionSpec_FullMethodName        = "/google.cloud.dialogflow.v2.EncryptionSpecService/GetEncryptionSpec"
	EncryptionSpecService_InitializeEncryptionSpec_FullMethodName = "/google.cloud.dialogflow.v2.EncryptionSpecService/InitializeEncryptionSpec"
)

// EncryptionSpecServiceClient is the client API for EncryptionSpecService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EncryptionSpecServiceClient interface {
	// Gets location-level encryption key specification.
	GetEncryptionSpec(ctx context.Context, in *GetEncryptionSpecRequest, opts ...grpc.CallOption) (*EncryptionSpec, error)
	// Initializes a location-level encryption key specification.  An error will
	// be thrown if the location has resources already created before the
	// initialization. Once the encryption specification is initialized at a
	// location, it is immutable and all newly created resources under the
	// location will be encrypted with the existing specification.
	InitializeEncryptionSpec(ctx context.Context, in *InitializeEncryptionSpecRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type encryptionSpecServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewEncryptionSpecServiceClient(cc grpc.ClientConnInterface) EncryptionSpecServiceClient {
	return &encryptionSpecServiceClient{cc}
}

func (c *encryptionSpecServiceClient) GetEncryptionSpec(ctx context.Context, in *GetEncryptionSpecRequest, opts ...grpc.CallOption) (*EncryptionSpec, error) {
	out := new(EncryptionSpec)
	err := c.cc.Invoke(ctx, EncryptionSpecService_GetEncryptionSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *encryptionSpecServiceClient) InitializeEncryptionSpec(ctx context.Context, in *InitializeEncryptionSpecRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, EncryptionSpecService_InitializeEncryptionSpec_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EncryptionSpecServiceServer is the server API for EncryptionSpecService service.
// All implementations should embed UnimplementedEncryptionSpecServiceServer
// for forward compatibility
type EncryptionSpecServiceServer interface {
	// Gets location-level encryption key specification.
	GetEncryptionSpec(context.Context, *GetEncryptionSpecRequest) (*EncryptionSpec, error)
	// Initializes a location-level encryption key specification.  An error will
	// be thrown if the location has resources already created before the
	// initialization. Once the encryption specification is initialized at a
	// location, it is immutable and all newly created resources under the
	// location will be encrypted with the existing specification.
	InitializeEncryptionSpec(context.Context, *InitializeEncryptionSpecRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEncryptionSpecServiceServer should be embedded to have forward compatible implementations.
type UnimplementedEncryptionSpecServiceServer struct {
}

func (UnimplementedEncryptionSpecServiceServer) GetEncryptionSpec(context.Context, *GetEncryptionSpecRequest) (*EncryptionSpec, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEncryptionSpec not implemented")
}
func (UnimplementedEncryptionSpecServiceServer) InitializeEncryptionSpec(context.Context, *InitializeEncryptionSpecRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method InitializeEncryptionSpec not implemented")
}

// UnsafeEncryptionSpecServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EncryptionSpecServiceServer will
// result in compilation errors.
type UnsafeEncryptionSpecServiceServer interface {
	mustEmbedUnimplementedEncryptionSpecServiceServer()
}

func RegisterEncryptionSpecServiceServer(s grpc.ServiceRegistrar, srv EncryptionSpecServiceServer) {
	s.RegisterService(&EncryptionSpecService_ServiceDesc, srv)
}

func _EncryptionSpecService_GetEncryptionSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEncryptionSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EncryptionSpecServiceServer).GetEncryptionSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EncryptionSpecService_GetEncryptionSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EncryptionSpecServiceServer).GetEncryptionSpec(ctx, req.(*GetEncryptionSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _EncryptionSpecService_InitializeEncryptionSpec_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InitializeEncryptionSpecRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EncryptionSpecServiceServer).InitializeEncryptionSpec(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: EncryptionSpecService_InitializeEncryptionSpec_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EncryptionSpecServiceServer).InitializeEncryptionSpec(ctx, req.(*InitializeEncryptionSpecRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// EncryptionSpecService_ServiceDesc is the grpc.ServiceDesc for EncryptionSpecService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var EncryptionSpecService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.EncryptionSpecService",
	HandlerType: (*EncryptionSpecServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetEncryptionSpec",
			Handler:    _EncryptionSpecService_GetEncryptionSpec_Handler,
		},
		{
			MethodName: "InitializeEncryptionSpec",
			Handler:    _EncryptionSpecService_InitializeEncryptionSpec_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/encryption_spec.proto",
}
