// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/dialogflow/cx/v3/webhook.proto

package cxpb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicate the auth token type generated from the [Diglogflow service
// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
type Webhook_GenericWebService_ServiceAgentAuth int32

const (
	// Service agent auth type unspecified. Default to ID_TOKEN.
	Webhook_GenericWebService_SERVICE_AGENT_AUTH_UNSPECIFIED Webhook_GenericWebService_ServiceAgentAuth = 0
	// No token used.
	Webhook_GenericWebService_NONE Webhook_GenericWebService_ServiceAgentAuth = 1
	// Use [ID
	// token](https://cloud.google.com/docs/authentication/token-types#id)
	// generated from service agent. This can be used to access Cloud Function
	// and Cloud Run after you grant Invoker role to
	// `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	Webhook_GenericWebService_ID_TOKEN Webhook_GenericWebService_ServiceAgentAuth = 2
	// Use [access
	// token](https://cloud.google.com/docs/authentication/token-types#access)
	// generated from service agent. This can be used to access other Google
	// Cloud APIs after you grant required roles to
	// `service-<PROJECT-NUMBER>@gcp-sa-dialogflow.iam.gserviceaccount.com`.
	Webhook_GenericWebService_ACCESS_TOKEN Webhook_GenericWebService_ServiceAgentAuth = 3
)

// Enum value maps for Webhook_GenericWebService_ServiceAgentAuth.
var (
	Webhook_GenericWebService_ServiceAgentAuth_name = map[int32]string{
		0: "SERVICE_AGENT_AUTH_UNSPECIFIED",
		1: "NONE",
		2: "ID_TOKEN",
		3: "ACCESS_TOKEN",
	}
	Webhook_GenericWebService_ServiceAgentAuth_value = map[string]int32{
		"SERVICE_AGENT_AUTH_UNSPECIFIED": 0,
		"NONE":                           1,
		"ID_TOKEN":                       2,
		"ACCESS_TOKEN":                   3,
	}
)

func (x Webhook_GenericWebService_ServiceAgentAuth) Enum() *Webhook_GenericWebService_ServiceAgentAuth {
	p := new(Webhook_GenericWebService_ServiceAgentAuth)
	*p = x
	return p
}

func (x Webhook_GenericWebService_ServiceAgentAuth) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Webhook_GenericWebService_ServiceAgentAuth) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[0].Descriptor()
}

func (Webhook_GenericWebService_ServiceAgentAuth) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[0]
}

func (x Webhook_GenericWebService_ServiceAgentAuth) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Webhook_GenericWebService_ServiceAgentAuth.Descriptor instead.
func (Webhook_GenericWebService_ServiceAgentAuth) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0, 0, 0}
}

// Represents the type of webhook configuration.
type Webhook_GenericWebService_WebhookType int32

const (
	// Default value. This value is unused.
	Webhook_GenericWebService_WEBHOOK_TYPE_UNSPECIFIED Webhook_GenericWebService_WebhookType = 0
	// Represents a standard webhook.
	Webhook_GenericWebService_STANDARD Webhook_GenericWebService_WebhookType = 1
	// Represents a flexible webhook.
	Webhook_GenericWebService_FLEXIBLE Webhook_GenericWebService_WebhookType = 2
)

// Enum value maps for Webhook_GenericWebService_WebhookType.
var (
	Webhook_GenericWebService_WebhookType_name = map[int32]string{
		0: "WEBHOOK_TYPE_UNSPECIFIED",
		1: "STANDARD",
		2: "FLEXIBLE",
	}
	Webhook_GenericWebService_WebhookType_value = map[string]int32{
		"WEBHOOK_TYPE_UNSPECIFIED": 0,
		"STANDARD":                 1,
		"FLEXIBLE":                 2,
	}
)

func (x Webhook_GenericWebService_WebhookType) Enum() *Webhook_GenericWebService_WebhookType {
	p := new(Webhook_GenericWebService_WebhookType)
	*p = x
	return p
}

func (x Webhook_GenericWebService_WebhookType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Webhook_GenericWebService_WebhookType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[1].Descriptor()
}

func (Webhook_GenericWebService_WebhookType) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[1]
}

func (x Webhook_GenericWebService_WebhookType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Webhook_GenericWebService_WebhookType.Descriptor instead.
func (Webhook_GenericWebService_WebhookType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0, 0, 1}
}

// HTTP method to use when calling webhooks.
type Webhook_GenericWebService_HttpMethod int32

const (
	// HTTP method not specified.
	Webhook_GenericWebService_HTTP_METHOD_UNSPECIFIED Webhook_GenericWebService_HttpMethod = 0
	// HTTP POST Method.
	Webhook_GenericWebService_POST Webhook_GenericWebService_HttpMethod = 1
	// HTTP GET Method.
	Webhook_GenericWebService_GET Webhook_GenericWebService_HttpMethod = 2
	// HTTP HEAD Method.
	Webhook_GenericWebService_HEAD Webhook_GenericWebService_HttpMethod = 3
	// HTTP PUT Method.
	Webhook_GenericWebService_PUT Webhook_GenericWebService_HttpMethod = 4
	// HTTP DELETE Method.
	Webhook_GenericWebService_DELETE Webhook_GenericWebService_HttpMethod = 5
	// HTTP PATCH Method.
	Webhook_GenericWebService_PATCH Webhook_GenericWebService_HttpMethod = 6
	// HTTP OPTIONS Method.
	Webhook_GenericWebService_OPTIONS Webhook_GenericWebService_HttpMethod = 7
)

// Enum value maps for Webhook_GenericWebService_HttpMethod.
var (
	Webhook_GenericWebService_HttpMethod_name = map[int32]string{
		0: "HTTP_METHOD_UNSPECIFIED",
		1: "POST",
		2: "GET",
		3: "HEAD",
		4: "PUT",
		5: "DELETE",
		6: "PATCH",
		7: "OPTIONS",
	}
	Webhook_GenericWebService_HttpMethod_value = map[string]int32{
		"HTTP_METHOD_UNSPECIFIED": 0,
		"POST":                    1,
		"GET":                     2,
		"HEAD":                    3,
		"PUT":                     4,
		"DELETE":                  5,
		"PATCH":                   6,
		"OPTIONS":                 7,
	}
)

func (x Webhook_GenericWebService_HttpMethod) Enum() *Webhook_GenericWebService_HttpMethod {
	p := new(Webhook_GenericWebService_HttpMethod)
	*p = x
	return p
}

func (x Webhook_GenericWebService_HttpMethod) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Webhook_GenericWebService_HttpMethod) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[2].Descriptor()
}

func (Webhook_GenericWebService_HttpMethod) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[2]
}

func (x Webhook_GenericWebService_HttpMethod) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Webhook_GenericWebService_HttpMethod.Descriptor instead.
func (Webhook_GenericWebService_HttpMethod) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0, 0, 2}
}

// Defines merge behavior for `messages`.
type WebhookResponse_FulfillmentResponse_MergeBehavior int32

const (
	// Not specified. `APPEND` will be used.
	WebhookResponse_FulfillmentResponse_MERGE_BEHAVIOR_UNSPECIFIED WebhookResponse_FulfillmentResponse_MergeBehavior = 0
	// `messages` will be appended to the list of messages waiting to be sent
	// to the user.
	WebhookResponse_FulfillmentResponse_APPEND WebhookResponse_FulfillmentResponse_MergeBehavior = 1
	// `messages` will replace the list of messages waiting to be sent to the
	// user.
	WebhookResponse_FulfillmentResponse_REPLACE WebhookResponse_FulfillmentResponse_MergeBehavior = 2
)

// Enum value maps for WebhookResponse_FulfillmentResponse_MergeBehavior.
var (
	WebhookResponse_FulfillmentResponse_MergeBehavior_name = map[int32]string{
		0: "MERGE_BEHAVIOR_UNSPECIFIED",
		1: "APPEND",
		2: "REPLACE",
	}
	WebhookResponse_FulfillmentResponse_MergeBehavior_value = map[string]int32{
		"MERGE_BEHAVIOR_UNSPECIFIED": 0,
		"APPEND":                     1,
		"REPLACE":                    2,
	}
)

func (x WebhookResponse_FulfillmentResponse_MergeBehavior) Enum() *WebhookResponse_FulfillmentResponse_MergeBehavior {
	p := new(WebhookResponse_FulfillmentResponse_MergeBehavior)
	*p = x
	return p
}

func (x WebhookResponse_FulfillmentResponse_MergeBehavior) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (WebhookResponse_FulfillmentResponse_MergeBehavior) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[3].Descriptor()
}

func (WebhookResponse_FulfillmentResponse_MergeBehavior) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[3]
}

func (x WebhookResponse_FulfillmentResponse_MergeBehavior) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use WebhookResponse_FulfillmentResponse_MergeBehavior.Descriptor instead.
func (WebhookResponse_FulfillmentResponse_MergeBehavior) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{8, 0, 0}
}

// Represents the state of a parameter.
type PageInfo_FormInfo_ParameterInfo_ParameterState int32

const (
	// Not specified. This value should be never used.
	PageInfo_FormInfo_ParameterInfo_PARAMETER_STATE_UNSPECIFIED PageInfo_FormInfo_ParameterInfo_ParameterState = 0
	// Indicates that the parameter does not have a value.
	PageInfo_FormInfo_ParameterInfo_EMPTY PageInfo_FormInfo_ParameterInfo_ParameterState = 1
	// Indicates that the parameter value is invalid. This field can be used
	// by the webhook to invalidate the parameter and ask the server to
	// collect it from the user again.
	PageInfo_FormInfo_ParameterInfo_INVALID PageInfo_FormInfo_ParameterInfo_ParameterState = 2
	// Indicates that the parameter has a value.
	PageInfo_FormInfo_ParameterInfo_FILLED PageInfo_FormInfo_ParameterInfo_ParameterState = 3
)

// Enum value maps for PageInfo_FormInfo_ParameterInfo_ParameterState.
var (
	PageInfo_FormInfo_ParameterInfo_ParameterState_name = map[int32]string{
		0: "PARAMETER_STATE_UNSPECIFIED",
		1: "EMPTY",
		2: "INVALID",
		3: "FILLED",
	}
	PageInfo_FormInfo_ParameterInfo_ParameterState_value = map[string]int32{
		"PARAMETER_STATE_UNSPECIFIED": 0,
		"EMPTY":                       1,
		"INVALID":                     2,
		"FILLED":                      3,
	}
)

func (x PageInfo_FormInfo_ParameterInfo_ParameterState) Enum() *PageInfo_FormInfo_ParameterInfo_ParameterState {
	p := new(PageInfo_FormInfo_ParameterInfo_ParameterState)
	*p = x
	return p
}

func (x PageInfo_FormInfo_ParameterInfo_ParameterState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PageInfo_FormInfo_ParameterInfo_ParameterState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[4].Descriptor()
}

func (PageInfo_FormInfo_ParameterInfo_ParameterState) Type() protoreflect.EnumType {
	return &file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes[4]
}

func (x PageInfo_FormInfo_ParameterInfo_ParameterState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PageInfo_FormInfo_ParameterInfo_ParameterState.Descriptor instead.
func (PageInfo_FormInfo_ParameterInfo_ParameterState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{9, 0, 0, 0}
}

// Webhooks host the developer's business logic. During a session, webhooks
// allow the developer to use the data extracted by Dialogflow's natural
// language processing to generate dynamic responses, validate collected data,
// or trigger actions on the backend.
type Webhook struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The unique identifier of the webhook.
	// Required for the
	// [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook]
	// method.
	// [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook]
	// populates the name automatically. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The human-readable name of the webhook, unique within the agent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The webhook configuration.
	//
	// Types that are assignable to Webhook:
	//
	//	*Webhook_GenericWebService_
	//	*Webhook_ServiceDirectory
	Webhook isWebhook_Webhook `protobuf_oneof:"webhook"`
	// Webhook execution timeout. Execution is considered failed if Dialogflow
	// doesn't receive a response from webhook at the end of the timeout period.
	// Defaults to 5 seconds, maximum allowed timeout is 30 seconds.
	Timeout *durationpb.Duration `protobuf:"bytes,6,opt,name=timeout,proto3" json:"timeout,omitempty"`
	// Indicates whether the webhook is disabled.
	Disabled bool `protobuf:"varint,5,opt,name=disabled,proto3" json:"disabled,omitempty"`
}

func (x *Webhook) Reset() {
	*x = Webhook{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Webhook) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Webhook) ProtoMessage() {}

func (x *Webhook) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Webhook.ProtoReflect.Descriptor instead.
func (*Webhook) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0}
}

func (x *Webhook) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Webhook) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *Webhook) GetWebhook() isWebhook_Webhook {
	if m != nil {
		return m.Webhook
	}
	return nil
}

func (x *Webhook) GetGenericWebService() *Webhook_GenericWebService {
	if x, ok := x.GetWebhook().(*Webhook_GenericWebService_); ok {
		return x.GenericWebService
	}
	return nil
}

func (x *Webhook) GetServiceDirectory() *Webhook_ServiceDirectoryConfig {
	if x, ok := x.GetWebhook().(*Webhook_ServiceDirectory); ok {
		return x.ServiceDirectory
	}
	return nil
}

func (x *Webhook) GetTimeout() *durationpb.Duration {
	if x != nil {
		return x.Timeout
	}
	return nil
}

func (x *Webhook) GetDisabled() bool {
	if x != nil {
		return x.Disabled
	}
	return false
}

type isWebhook_Webhook interface {
	isWebhook_Webhook()
}

type Webhook_GenericWebService_ struct {
	// Configuration for a generic web service.
	GenericWebService *Webhook_GenericWebService `protobuf:"bytes,4,opt,name=generic_web_service,json=genericWebService,proto3,oneof"`
}

type Webhook_ServiceDirectory struct {
	// Configuration for a [Service
	// Directory](https://cloud.google.com/service-directory) service.
	ServiceDirectory *Webhook_ServiceDirectoryConfig `protobuf:"bytes,7,opt,name=service_directory,json=serviceDirectory,proto3,oneof"`
}

func (*Webhook_GenericWebService_) isWebhook_Webhook() {}

func (*Webhook_ServiceDirectory) isWebhook_Webhook() {}

// The request message for
// [Webhooks.ListWebhooks][google.cloud.dialogflow.cx.v3.Webhooks.ListWebhooks].
type ListWebhooksRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to list all webhooks for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return in a single page. By default 100 and
	// at most 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListWebhooksRequest) Reset() {
	*x = ListWebhooksRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListWebhooksRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWebhooksRequest) ProtoMessage() {}

func (x *ListWebhooksRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWebhooksRequest.ProtoReflect.Descriptor instead.
func (*ListWebhooksRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{1}
}

func (x *ListWebhooksRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListWebhooksRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListWebhooksRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for
// [Webhooks.ListWebhooks][google.cloud.dialogflow.cx.v3.Webhooks.ListWebhooks].
type ListWebhooksResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of webhooks. There will be a maximum number of items returned
	// based on the page_size field in the request.
	Webhooks []*Webhook `protobuf:"bytes,1,rep,name=webhooks,proto3" json:"webhooks,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListWebhooksResponse) Reset() {
	*x = ListWebhooksResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListWebhooksResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListWebhooksResponse) ProtoMessage() {}

func (x *ListWebhooksResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListWebhooksResponse.ProtoReflect.Descriptor instead.
func (*ListWebhooksResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{2}
}

func (x *ListWebhooksResponse) GetWebhooks() []*Webhook {
	if x != nil {
		return x.Webhooks
	}
	return nil
}

func (x *ListWebhooksResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The request message for
// [Webhooks.GetWebhook][google.cloud.dialogflow.cx.v3.Webhooks.GetWebhook].
type GetWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the webhook.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetWebhookRequest) Reset() {
	*x = GetWebhookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetWebhookRequest) ProtoMessage() {}

func (x *GetWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetWebhookRequest.ProtoReflect.Descriptor instead.
func (*GetWebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{3}
}

func (x *GetWebhookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for
// [Webhooks.CreateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook].
type CreateWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The agent to create a webhook for.
	// Format: `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The webhook to create.
	Webhook *Webhook `protobuf:"bytes,2,opt,name=webhook,proto3" json:"webhook,omitempty"`
}

func (x *CreateWebhookRequest) Reset() {
	*x = CreateWebhookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateWebhookRequest) ProtoMessage() {}

func (x *CreateWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateWebhookRequest.ProtoReflect.Descriptor instead.
func (*CreateWebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{4}
}

func (x *CreateWebhookRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateWebhookRequest) GetWebhook() *Webhook {
	if x != nil {
		return x.Webhook
	}
	return nil
}

// The request message for
// [Webhooks.UpdateWebhook][google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook].
type UpdateWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The webhook to update.
	Webhook *Webhook `protobuf:"bytes,1,opt,name=webhook,proto3" json:"webhook,omitempty"`
	// The mask to control which fields get updated. If the mask is not present,
	// all fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateWebhookRequest) Reset() {
	*x = UpdateWebhookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateWebhookRequest) ProtoMessage() {}

func (x *UpdateWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateWebhookRequest.ProtoReflect.Descriptor instead.
func (*UpdateWebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateWebhookRequest) GetWebhook() *Webhook {
	if x != nil {
		return x.Webhook
	}
	return nil
}

func (x *UpdateWebhookRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The request message for
// [Webhooks.DeleteWebhook][google.cloud.dialogflow.cx.v3.Webhooks.DeleteWebhook].
type DeleteWebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the webhook to delete.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/webhooks/<WebhookID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// This field has no effect for webhook not being used.
	// For webhooks that are used by pages/flows/transition route groups:
	//
	//   - If `force` is set to false, an error will be returned with message
	//     indicating the referenced resources.
	//   - If `force` is set to true, Dialogflow will remove the webhook, as well
	//     as any references to the webhook (i.e.
	//     [Webhook][google.cloud.dialogflow.cx.v3.Fulfillment.webhook] and
	//     [tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag]in fulfillments that
	//     point to this webhook will be removed).
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteWebhookRequest) Reset() {
	*x = DeleteWebhookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteWebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteWebhookRequest) ProtoMessage() {}

func (x *DeleteWebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteWebhookRequest.ProtoReflect.Descriptor instead.
func (*DeleteWebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteWebhookRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteWebhookRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// The request message for a webhook call. The request is sent as a JSON object
// and the field names will be presented in camel cases.
//
// You may see undocumented fields in an actual request. These fields are used
// internally by Dialogflow and should be ignored.
type WebhookRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present. The unique identifier of the
	// [DetectIntentResponse][google.cloud.dialogflow.cx.v3.DetectIntentResponse]
	// that will be returned to the API caller.
	DetectIntentResponseId string `protobuf:"bytes,1,opt,name=detect_intent_response_id,json=detectIntentResponseId,proto3" json:"detect_intent_response_id,omitempty"`
	// The original conversational query.
	//
	// Types that are assignable to Query:
	//
	//	*WebhookRequest_Text
	//	*WebhookRequest_TriggerIntent
	//	*WebhookRequest_Transcript
	//	*WebhookRequest_TriggerEvent
	//	*WebhookRequest_DtmfDigits
	Query isWebhookRequest_Query `protobuf_oneof:"query"`
	// The language code specified in the [original
	// request][QueryInput.language_code].
	LanguageCode string `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Always present. Information about the fulfillment that triggered this
	// webhook call.
	FulfillmentInfo *WebhookRequest_FulfillmentInfo `protobuf:"bytes,6,opt,name=fulfillment_info,json=fulfillmentInfo,proto3" json:"fulfillment_info,omitempty"`
	// Information about the last matched intent.
	IntentInfo *WebhookRequest_IntentInfo `protobuf:"bytes,3,opt,name=intent_info,json=intentInfo,proto3" json:"intent_info,omitempty"`
	// Information about page status.
	PageInfo *PageInfo `protobuf:"bytes,4,opt,name=page_info,json=pageInfo,proto3" json:"page_info,omitempty"`
	// Information about session status.
	SessionInfo *SessionInfo `protobuf:"bytes,5,opt,name=session_info,json=sessionInfo,proto3" json:"session_info,omitempty"`
	// The list of rich message responses to present to the user. Webhook can
	// choose to append or replace this list in
	// [WebhookResponse.fulfillment_response][google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response];
	Messages []*ResponseMessage `protobuf:"bytes,7,rep,name=messages,proto3" json:"messages,omitempty"`
	// Custom data set in
	// [QueryParameters.payload][google.cloud.dialogflow.cx.v3.QueryParameters.payload].
	Payload *structpb.Struct `protobuf:"bytes,8,opt,name=payload,proto3" json:"payload,omitempty"`
	// The sentiment analysis result of the current user request. The field is
	// filled when sentiment analysis is configured to be enabled for the request.
	SentimentAnalysisResult *WebhookRequest_SentimentAnalysisResult `protobuf:"bytes,9,opt,name=sentiment_analysis_result,json=sentimentAnalysisResult,proto3" json:"sentiment_analysis_result,omitempty"`
	// Information about the language of the request.
	LanguageInfo *LanguageInfo `protobuf:"bytes,18,opt,name=language_info,json=languageInfo,proto3" json:"language_info,omitempty"`
}

func (x *WebhookRequest) Reset() {
	*x = WebhookRequest{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookRequest) ProtoMessage() {}

func (x *WebhookRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookRequest.ProtoReflect.Descriptor instead.
func (*WebhookRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{7}
}

func (x *WebhookRequest) GetDetectIntentResponseId() string {
	if x != nil {
		return x.DetectIntentResponseId
	}
	return ""
}

func (m *WebhookRequest) GetQuery() isWebhookRequest_Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (x *WebhookRequest) GetText() string {
	if x, ok := x.GetQuery().(*WebhookRequest_Text); ok {
		return x.Text
	}
	return ""
}

func (x *WebhookRequest) GetTriggerIntent() string {
	if x, ok := x.GetQuery().(*WebhookRequest_TriggerIntent); ok {
		return x.TriggerIntent
	}
	return ""
}

func (x *WebhookRequest) GetTranscript() string {
	if x, ok := x.GetQuery().(*WebhookRequest_Transcript); ok {
		return x.Transcript
	}
	return ""
}

func (x *WebhookRequest) GetTriggerEvent() string {
	if x, ok := x.GetQuery().(*WebhookRequest_TriggerEvent); ok {
		return x.TriggerEvent
	}
	return ""
}

func (x *WebhookRequest) GetDtmfDigits() string {
	if x, ok := x.GetQuery().(*WebhookRequest_DtmfDigits); ok {
		return x.DtmfDigits
	}
	return ""
}

func (x *WebhookRequest) GetLanguageCode() string {
	if x != nil {
		return x.LanguageCode
	}
	return ""
}

func (x *WebhookRequest) GetFulfillmentInfo() *WebhookRequest_FulfillmentInfo {
	if x != nil {
		return x.FulfillmentInfo
	}
	return nil
}

func (x *WebhookRequest) GetIntentInfo() *WebhookRequest_IntentInfo {
	if x != nil {
		return x.IntentInfo
	}
	return nil
}

func (x *WebhookRequest) GetPageInfo() *PageInfo {
	if x != nil {
		return x.PageInfo
	}
	return nil
}

func (x *WebhookRequest) GetSessionInfo() *SessionInfo {
	if x != nil {
		return x.SessionInfo
	}
	return nil
}

func (x *WebhookRequest) GetMessages() []*ResponseMessage {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *WebhookRequest) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *WebhookRequest) GetSentimentAnalysisResult() *WebhookRequest_SentimentAnalysisResult {
	if x != nil {
		return x.SentimentAnalysisResult
	}
	return nil
}

func (x *WebhookRequest) GetLanguageInfo() *LanguageInfo {
	if x != nil {
		return x.LanguageInfo
	}
	return nil
}

type isWebhookRequest_Query interface {
	isWebhookRequest_Query()
}

type WebhookRequest_Text struct {
	// If [natural language text][google.cloud.dialogflow.cx.v3.TextInput] was
	// provided as input, this field will contain a copy of the text.
	Text string `protobuf:"bytes,10,opt,name=text,proto3,oneof"`
}

type WebhookRequest_TriggerIntent struct {
	// If an [intent][google.cloud.dialogflow.cx.v3.IntentInput] was provided as
	// input, this field will contain a copy of the intent identifier. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/intents/<IntentID>`.
	TriggerIntent string `protobuf:"bytes,11,opt,name=trigger_intent,json=triggerIntent,proto3,oneof"`
}

type WebhookRequest_Transcript struct {
	// If [natural language speech
	// audio][google.cloud.dialogflow.cx.v3.AudioInput] was provided as input,
	// this field will contain the transcript for the audio.
	Transcript string `protobuf:"bytes,12,opt,name=transcript,proto3,oneof"`
}

type WebhookRequest_TriggerEvent struct {
	// If an [event][google.cloud.dialogflow.cx.v3.EventInput] was provided as
	// input, this field will contain the name of the event.
	TriggerEvent string `protobuf:"bytes,14,opt,name=trigger_event,json=triggerEvent,proto3,oneof"`
}

type WebhookRequest_DtmfDigits struct {
	// If [DTMF][google.cloud.dialogflow.cx.v3.DtmfInput] was provided as input,
	// this field will contain the DTMF digits.
	DtmfDigits string `protobuf:"bytes,17,opt,name=dtmf_digits,json=dtmfDigits,proto3,oneof"`
}

func (*WebhookRequest_Text) isWebhookRequest_Query() {}

func (*WebhookRequest_TriggerIntent) isWebhookRequest_Query() {}

func (*WebhookRequest_Transcript) isWebhookRequest_Query() {}

func (*WebhookRequest_TriggerEvent) isWebhookRequest_Query() {}

func (*WebhookRequest_DtmfDigits) isWebhookRequest_Query() {}

// The response message for a webhook call.
type WebhookResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The fulfillment response to send to the user. This field can be omitted by
	// the webhook if it does not intend to send any response to the user.
	FulfillmentResponse *WebhookResponse_FulfillmentResponse `protobuf:"bytes,1,opt,name=fulfillment_response,json=fulfillmentResponse,proto3" json:"fulfillment_response,omitempty"`
	// Information about page status. This field can be omitted by the webhook if
	// it does not intend to modify page status.
	PageInfo *PageInfo `protobuf:"bytes,2,opt,name=page_info,json=pageInfo,proto3" json:"page_info,omitempty"`
	// Information about session status. This field can be omitted by the webhook
	// if it does not intend to modify session status.
	SessionInfo *SessionInfo `protobuf:"bytes,3,opt,name=session_info,json=sessionInfo,proto3" json:"session_info,omitempty"`
	// Value to append directly to
	// [QueryResult.webhook_payloads][google.cloud.dialogflow.cx.v3.QueryResult.webhook_payloads].
	Payload *structpb.Struct `protobuf:"bytes,4,opt,name=payload,proto3" json:"payload,omitempty"`
	// The target to transition to. This can be set optionally to indicate an
	// immediate transition to a different page in the same host flow, or a
	// different flow in the same agent.
	//
	// Types that are assignable to Transition:
	//
	//	*WebhookResponse_TargetPage
	//	*WebhookResponse_TargetFlow
	Transition isWebhookResponse_Transition `protobuf_oneof:"transition"`
}

func (x *WebhookResponse) Reset() {
	*x = WebhookResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookResponse) ProtoMessage() {}

func (x *WebhookResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookResponse.ProtoReflect.Descriptor instead.
func (*WebhookResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{8}
}

func (x *WebhookResponse) GetFulfillmentResponse() *WebhookResponse_FulfillmentResponse {
	if x != nil {
		return x.FulfillmentResponse
	}
	return nil
}

func (x *WebhookResponse) GetPageInfo() *PageInfo {
	if x != nil {
		return x.PageInfo
	}
	return nil
}

func (x *WebhookResponse) GetSessionInfo() *SessionInfo {
	if x != nil {
		return x.SessionInfo
	}
	return nil
}

func (x *WebhookResponse) GetPayload() *structpb.Struct {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (m *WebhookResponse) GetTransition() isWebhookResponse_Transition {
	if m != nil {
		return m.Transition
	}
	return nil
}

func (x *WebhookResponse) GetTargetPage() string {
	if x, ok := x.GetTransition().(*WebhookResponse_TargetPage); ok {
		return x.TargetPage
	}
	return ""
}

func (x *WebhookResponse) GetTargetFlow() string {
	if x, ok := x.GetTransition().(*WebhookResponse_TargetFlow); ok {
		return x.TargetFlow
	}
	return ""
}

type isWebhookResponse_Transition interface {
	isWebhookResponse_Transition()
}

type WebhookResponse_TargetPage struct {
	// The target page to transition to.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/pages/<PageID>`.
	TargetPage string `protobuf:"bytes,5,opt,name=target_page,json=targetPage,proto3,oneof"`
}

type WebhookResponse_TargetFlow struct {
	// The target flow to transition to.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>`.
	TargetFlow string `protobuf:"bytes,6,opt,name=target_flow,json=targetFlow,proto3,oneof"`
}

func (*WebhookResponse_TargetPage) isWebhookResponse_Transition() {}

func (*WebhookResponse_TargetFlow) isWebhookResponse_Transition() {}

// Represents page information communicated to and from the webhook.
type PageInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The
	// unique identifier of the current page. Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/flows/<FlowID>/pages/<PageID>`.
	CurrentPage string `protobuf:"bytes,1,opt,name=current_page,json=currentPage,proto3" json:"current_page,omitempty"`
	// Always present for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The
	// display name of the current page.
	DisplayName string `protobuf:"bytes,4,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional for both
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
	// Information about the form.
	FormInfo *PageInfo_FormInfo `protobuf:"bytes,3,opt,name=form_info,json=formInfo,proto3" json:"form_info,omitempty"`
}

func (x *PageInfo) Reset() {
	*x = PageInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PageInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PageInfo) ProtoMessage() {}

func (x *PageInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PageInfo.ProtoReflect.Descriptor instead.
func (*PageInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{9}
}

func (x *PageInfo) GetCurrentPage() string {
	if x != nil {
		return x.CurrentPage
	}
	return ""
}

func (x *PageInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PageInfo) GetFormInfo() *PageInfo_FormInfo {
	if x != nil {
		return x.FormInfo
	}
	return nil
}

// Represents session information communicated to and from the webhook.
type SessionInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored for
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The
	// unique identifier of the
	// [session][google.cloud.dialogflow.cx.v3.DetectIntentRequest.session]. This
	// field can be used by the webhook to identify a session.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/sessions/<SessionID>`
	// or
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/environments/<EnvironmentID>/sessions/<SessionID>`
	// if environment is specified.
	Session string `protobuf:"bytes,1,opt,name=session,proto3" json:"session,omitempty"`
	// Optional for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Optional
	// for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. All
	// parameters collected from forms and intents during the session. Parameters
	// can be created, updated, or removed by the webhook. To remove a parameter
	// from the session, the webhook should explicitly set the parameter value to
	// null in [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
	// The map is keyed by parameters' display names.
	Parameters map[string]*structpb.Value `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SessionInfo) Reset() {
	*x = SessionInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SessionInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SessionInfo) ProtoMessage() {}

func (x *SessionInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SessionInfo.ProtoReflect.Descriptor instead.
func (*SessionInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{10}
}

func (x *SessionInfo) GetSession() string {
	if x != nil {
		return x.Session
	}
	return ""
}

func (x *SessionInfo) GetParameters() map[string]*structpb.Value {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Represents the language information of the request.
type LanguageInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The language code specified in the original
	// [request][google.cloud.dialogflow.cx.v3.QueryInput.language_code].
	InputLanguageCode string `protobuf:"bytes,1,opt,name=input_language_code,json=inputLanguageCode,proto3" json:"input_language_code,omitempty"`
	// The language code detected for this request based on the user
	// conversation.
	ResolvedLanguageCode string `protobuf:"bytes,2,opt,name=resolved_language_code,json=resolvedLanguageCode,proto3" json:"resolved_language_code,omitempty"`
	// The confidence score of the detected language between 0 and 1.
	ConfidenceScore float32 `protobuf:"fixed32,3,opt,name=confidence_score,json=confidenceScore,proto3" json:"confidence_score,omitempty"`
}

func (x *LanguageInfo) Reset() {
	*x = LanguageInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LanguageInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LanguageInfo) ProtoMessage() {}

func (x *LanguageInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LanguageInfo.ProtoReflect.Descriptor instead.
func (*LanguageInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{11}
}

func (x *LanguageInfo) GetInputLanguageCode() string {
	if x != nil {
		return x.InputLanguageCode
	}
	return ""
}

func (x *LanguageInfo) GetResolvedLanguageCode() string {
	if x != nil {
		return x.ResolvedLanguageCode
	}
	return ""
}

func (x *LanguageInfo) GetConfidenceScore() float32 {
	if x != nil {
		return x.ConfidenceScore
	}
	return 0
}

// Represents configuration for a generic web service.
type Webhook_GenericWebService struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The webhook URI for receiving POST requests. It must use https
	// protocol.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// The user name for HTTP Basic authentication.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3/webhook.proto.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// The password for HTTP Basic authentication.
	//
	// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3/webhook.proto.
	Password string `protobuf:"bytes,3,opt,name=password,proto3" json:"password,omitempty"`
	// The HTTP request headers to send together with webhook requests.
	RequestHeaders map[string]string `protobuf:"bytes,4,rep,name=request_headers,json=requestHeaders,proto3" json:"request_headers,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Specifies a list of allowed custom CA certificates (in DER
	// format) for HTTPS verification. This overrides the default SSL trust
	// store. If this is empty or unspecified, Dialogflow will use Google's
	// default trust store to verify certificates. N.B. Make sure the HTTPS
	// server certificates are signed with "subject alt name". For instance a
	// certificate can be self-signed using the following command,
	// ```
	//
	//	openssl x509 -req -days 200 -in example.com.csr \
	//	  -signkey example.com.key \
	//	  -out example.com.crt \
	//	  -extfile <(printf "\nsubjectAltName='DNS:www.example.com'")
	//
	// ```
	AllowedCaCerts [][]byte `protobuf:"bytes,5,rep,name=allowed_ca_certs,json=allowedCaCerts,proto3" json:"allowed_ca_certs,omitempty"`
	// Optional. The OAuth configuration of the webhook. If specified,
	// Dialogflow will initiate the OAuth client credential flow to exchange an
	// access token from the 3rd party platform and put it in the auth header.
	OauthConfig *Webhook_GenericWebService_OAuthConfig `protobuf:"bytes,11,opt,name=oauth_config,json=oauthConfig,proto3" json:"oauth_config,omitempty"`
	// Optional. Indicate the auth token type generated from the [Diglogflow
	// service
	// agent](https://cloud.google.com/iam/docs/service-agents#dialogflow-service-agent).
	// The generated token is sent in the Authorization header.
	ServiceAgentAuth Webhook_GenericWebService_ServiceAgentAuth `protobuf:"varint,12,opt,name=service_agent_auth,json=serviceAgentAuth,proto3,enum=google.cloud.dialogflow.cx.v3.Webhook_GenericWebService_ServiceAgentAuth" json:"service_agent_auth,omitempty"`
	// Optional. Type of the webhook.
	WebhookType Webhook_GenericWebService_WebhookType `protobuf:"varint,6,opt,name=webhook_type,json=webhookType,proto3,enum=google.cloud.dialogflow.cx.v3.Webhook_GenericWebService_WebhookType" json:"webhook_type,omitempty"`
	// Optional. HTTP method for the flexible webhook calls. Standard webhook
	// always uses POST.
	HttpMethod Webhook_GenericWebService_HttpMethod `protobuf:"varint,7,opt,name=http_method,json=httpMethod,proto3,enum=google.cloud.dialogflow.cx.v3.Webhook_GenericWebService_HttpMethod" json:"http_method,omitempty"`
	// Optional. Defines a custom JSON object as request body to send to
	// flexible webhook.
	RequestBody string `protobuf:"bytes,8,opt,name=request_body,json=requestBody,proto3" json:"request_body,omitempty"`
	// Optional. Maps the values extracted from specific fields of the flexible
	// webhook response into session parameters.
	// - Key: session parameter name
	// - Value: field path in the webhook response
	ParameterMapping map[string]string `protobuf:"bytes,9,rep,name=parameter_mapping,json=parameterMapping,proto3" json:"parameter_mapping,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Webhook_GenericWebService) Reset() {
	*x = Webhook_GenericWebService{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Webhook_GenericWebService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Webhook_GenericWebService) ProtoMessage() {}

func (x *Webhook_GenericWebService) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Webhook_GenericWebService.ProtoReflect.Descriptor instead.
func (*Webhook_GenericWebService) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Webhook_GenericWebService) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3/webhook.proto.
func (x *Webhook_GenericWebService) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

// Deprecated: Marked as deprecated in google/cloud/dialogflow/cx/v3/webhook.proto.
func (x *Webhook_GenericWebService) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *Webhook_GenericWebService) GetRequestHeaders() map[string]string {
	if x != nil {
		return x.RequestHeaders
	}
	return nil
}

func (x *Webhook_GenericWebService) GetAllowedCaCerts() [][]byte {
	if x != nil {
		return x.AllowedCaCerts
	}
	return nil
}

func (x *Webhook_GenericWebService) GetOauthConfig() *Webhook_GenericWebService_OAuthConfig {
	if x != nil {
		return x.OauthConfig
	}
	return nil
}

func (x *Webhook_GenericWebService) GetServiceAgentAuth() Webhook_GenericWebService_ServiceAgentAuth {
	if x != nil {
		return x.ServiceAgentAuth
	}
	return Webhook_GenericWebService_SERVICE_AGENT_AUTH_UNSPECIFIED
}

func (x *Webhook_GenericWebService) GetWebhookType() Webhook_GenericWebService_WebhookType {
	if x != nil {
		return x.WebhookType
	}
	return Webhook_GenericWebService_WEBHOOK_TYPE_UNSPECIFIED
}

func (x *Webhook_GenericWebService) GetHttpMethod() Webhook_GenericWebService_HttpMethod {
	if x != nil {
		return x.HttpMethod
	}
	return Webhook_GenericWebService_HTTP_METHOD_UNSPECIFIED
}

func (x *Webhook_GenericWebService) GetRequestBody() string {
	if x != nil {
		return x.RequestBody
	}
	return ""
}

func (x *Webhook_GenericWebService) GetParameterMapping() map[string]string {
	if x != nil {
		return x.ParameterMapping
	}
	return nil
}

// Represents configuration for a [Service
// Directory](https://cloud.google.com/service-directory) service.
type Webhook_ServiceDirectoryConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of [Service
	// Directory](https://cloud.google.com/service-directory) service.
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/namespaces/<NamespaceID>/services/<ServiceID>`.
	// `Location ID` of the service directory must be the same as the location
	// of the agent.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Generic Service configuration of this webhook.
	GenericWebService *Webhook_GenericWebService `protobuf:"bytes,2,opt,name=generic_web_service,json=genericWebService,proto3" json:"generic_web_service,omitempty"`
}

func (x *Webhook_ServiceDirectoryConfig) Reset() {
	*x = Webhook_ServiceDirectoryConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Webhook_ServiceDirectoryConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Webhook_ServiceDirectoryConfig) ProtoMessage() {}

func (x *Webhook_ServiceDirectoryConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Webhook_ServiceDirectoryConfig.ProtoReflect.Descriptor instead.
func (*Webhook_ServiceDirectoryConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Webhook_ServiceDirectoryConfig) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *Webhook_ServiceDirectoryConfig) GetGenericWebService() *Webhook_GenericWebService {
	if x != nil {
		return x.GenericWebService
	}
	return nil
}

// Represents configuration of OAuth client credential flow for 3rd party
// API authentication.
type Webhook_GenericWebService_OAuthConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The client ID provided by the 3rd party platform.
	ClientId string `protobuf:"bytes,1,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Optional. The client secret provided by the 3rd party platform.
	ClientSecret string `protobuf:"bytes,2,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
	// Required. The token endpoint provided by the 3rd party platform to
	// exchange an access token.
	TokenEndpoint string `protobuf:"bytes,3,opt,name=token_endpoint,json=tokenEndpoint,proto3" json:"token_endpoint,omitempty"`
	// Optional. The OAuth scopes to grant.
	Scopes []string `protobuf:"bytes,4,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *Webhook_GenericWebService_OAuthConfig) Reset() {
	*x = Webhook_GenericWebService_OAuthConfig{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Webhook_GenericWebService_OAuthConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Webhook_GenericWebService_OAuthConfig) ProtoMessage() {}

func (x *Webhook_GenericWebService_OAuthConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Webhook_GenericWebService_OAuthConfig.ProtoReflect.Descriptor instead.
func (*Webhook_GenericWebService_OAuthConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{0, 0, 0}
}

func (x *Webhook_GenericWebService_OAuthConfig) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *Webhook_GenericWebService_OAuthConfig) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

func (x *Webhook_GenericWebService_OAuthConfig) GetTokenEndpoint() string {
	if x != nil {
		return x.TokenEndpoint
	}
	return ""
}

func (x *Webhook_GenericWebService_OAuthConfig) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// Represents fulfillment information communicated to the webhook.
type WebhookRequest_FulfillmentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present.
	// The value of the
	// [Fulfillment.tag][google.cloud.dialogflow.cx.v3.Fulfillment.tag] field
	// will be populated in this field by Dialogflow when the associated webhook
	// is called. The tag is typically used by the webhook service to identify
	// which fulfillment is being called, but it could be used for other
	// purposes.
	Tag string `protobuf:"bytes,1,opt,name=tag,proto3" json:"tag,omitempty"`
}

func (x *WebhookRequest_FulfillmentInfo) Reset() {
	*x = WebhookRequest_FulfillmentInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookRequest_FulfillmentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookRequest_FulfillmentInfo) ProtoMessage() {}

func (x *WebhookRequest_FulfillmentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookRequest_FulfillmentInfo.ProtoReflect.Descriptor instead.
func (*WebhookRequest_FulfillmentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{7, 0}
}

func (x *WebhookRequest_FulfillmentInfo) GetTag() string {
	if x != nil {
		return x.Tag
	}
	return ""
}

// Represents intent information communicated to the webhook.
type WebhookRequest_IntentInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present. The unique identifier of the last matched
	// [intent][google.cloud.dialogflow.cx.v3.Intent].
	// Format:
	// `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/intents/<IntentID>`.
	LastMatchedIntent string `protobuf:"bytes,1,opt,name=last_matched_intent,json=lastMatchedIntent,proto3" json:"last_matched_intent,omitempty"`
	// Always present. The display name of the last matched
	// [intent][google.cloud.dialogflow.cx.v3.Intent].
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Parameters identified as a result of intent matching. This is a map of
	// the name of the identified parameter to the value of the parameter
	// identified from the user's utterance. All parameters defined in the
	// matched intent that are identified will be surfaced here.
	Parameters map[string]*WebhookRequest_IntentInfo_IntentParameterValue `protobuf:"bytes,2,rep,name=parameters,proto3" json:"parameters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The confidence of the matched intent. Values range from 0.0 (completely
	// uncertain) to 1.0 (completely certain).
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
}

func (x *WebhookRequest_IntentInfo) Reset() {
	*x = WebhookRequest_IntentInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookRequest_IntentInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookRequest_IntentInfo) ProtoMessage() {}

func (x *WebhookRequest_IntentInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookRequest_IntentInfo.ProtoReflect.Descriptor instead.
func (*WebhookRequest_IntentInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{7, 1}
}

func (x *WebhookRequest_IntentInfo) GetLastMatchedIntent() string {
	if x != nil {
		return x.LastMatchedIntent
	}
	return ""
}

func (x *WebhookRequest_IntentInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *WebhookRequest_IntentInfo) GetParameters() map[string]*WebhookRequest_IntentInfo_IntentParameterValue {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *WebhookRequest_IntentInfo) GetConfidence() float32 {
	if x != nil {
		return x.Confidence
	}
	return 0
}

// Represents the result of sentiment analysis.
type WebhookRequest_SentimentAnalysisResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sentiment score between -1.0 (negative sentiment) and 1.0 (positive
	//
	//	sentiment).
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// A non-negative number in the [0, +inf) range, which represents the
	// absolute magnitude of sentiment, regardless of score (positive or
	// negative).
	Magnitude float32 `protobuf:"fixed32,2,opt,name=magnitude,proto3" json:"magnitude,omitempty"`
}

func (x *WebhookRequest_SentimentAnalysisResult) Reset() {
	*x = WebhookRequest_SentimentAnalysisResult{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookRequest_SentimentAnalysisResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookRequest_SentimentAnalysisResult) ProtoMessage() {}

func (x *WebhookRequest_SentimentAnalysisResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookRequest_SentimentAnalysisResult.ProtoReflect.Descriptor instead.
func (*WebhookRequest_SentimentAnalysisResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{7, 2}
}

func (x *WebhookRequest_SentimentAnalysisResult) GetScore() float32 {
	if x != nil {
		return x.Score
	}
	return 0
}

func (x *WebhookRequest_SentimentAnalysisResult) GetMagnitude() float32 {
	if x != nil {
		return x.Magnitude
	}
	return 0
}

// Represents a value for an intent parameter.
type WebhookRequest_IntentInfo_IntentParameterValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present. Original text value extracted from user utterance.
	OriginalValue string `protobuf:"bytes,1,opt,name=original_value,json=originalValue,proto3" json:"original_value,omitempty"`
	// Always present. Structured value for the parameter extracted from user
	// utterance.
	ResolvedValue *structpb.Value `protobuf:"bytes,2,opt,name=resolved_value,json=resolvedValue,proto3" json:"resolved_value,omitempty"`
}

func (x *WebhookRequest_IntentInfo_IntentParameterValue) Reset() {
	*x = WebhookRequest_IntentInfo_IntentParameterValue{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookRequest_IntentInfo_IntentParameterValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookRequest_IntentInfo_IntentParameterValue) ProtoMessage() {}

func (x *WebhookRequest_IntentInfo_IntentParameterValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookRequest_IntentInfo_IntentParameterValue.ProtoReflect.Descriptor instead.
func (*WebhookRequest_IntentInfo_IntentParameterValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{7, 1, 0}
}

func (x *WebhookRequest_IntentInfo_IntentParameterValue) GetOriginalValue() string {
	if x != nil {
		return x.OriginalValue
	}
	return ""
}

func (x *WebhookRequest_IntentInfo_IntentParameterValue) GetResolvedValue() *structpb.Value {
	if x != nil {
		return x.ResolvedValue
	}
	return nil
}

// Represents a fulfillment response to the user.
type WebhookResponse_FulfillmentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of rich message responses to present to the user.
	Messages []*ResponseMessage `protobuf:"bytes,1,rep,name=messages,proto3" json:"messages,omitempty"`
	// Merge behavior for `messages`.
	MergeBehavior WebhookResponse_FulfillmentResponse_MergeBehavior `protobuf:"varint,2,opt,name=merge_behavior,json=mergeBehavior,proto3,enum=google.cloud.dialogflow.cx.v3.WebhookResponse_FulfillmentResponse_MergeBehavior" json:"merge_behavior,omitempty"`
}

func (x *WebhookResponse_FulfillmentResponse) Reset() {
	*x = WebhookResponse_FulfillmentResponse{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *WebhookResponse_FulfillmentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WebhookResponse_FulfillmentResponse) ProtoMessage() {}

func (x *WebhookResponse_FulfillmentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WebhookResponse_FulfillmentResponse.ProtoReflect.Descriptor instead.
func (*WebhookResponse_FulfillmentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{8, 0}
}

func (x *WebhookResponse_FulfillmentResponse) GetMessages() []*ResponseMessage {
	if x != nil {
		return x.Messages
	}
	return nil
}

func (x *WebhookResponse_FulfillmentResponse) GetMergeBehavior() WebhookResponse_FulfillmentResponse_MergeBehavior {
	if x != nil {
		return x.MergeBehavior
	}
	return WebhookResponse_FulfillmentResponse_MERGE_BEHAVIOR_UNSPECIFIED
}

// Represents form information.
type PageInfo_FormInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional for both
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The
	// parameters contained in the form. Note that the webhook cannot add or
	// remove any form parameter.
	ParameterInfo []*PageInfo_FormInfo_ParameterInfo `protobuf:"bytes,2,rep,name=parameter_info,json=parameterInfo,proto3" json:"parameter_info,omitempty"`
}

func (x *PageInfo_FormInfo) Reset() {
	*x = PageInfo_FormInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PageInfo_FormInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PageInfo_FormInfo) ProtoMessage() {}

func (x *PageInfo_FormInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PageInfo_FormInfo.ProtoReflect.Descriptor instead.
func (*PageInfo_FormInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{9, 0}
}

func (x *PageInfo_FormInfo) GetParameterInfo() []*PageInfo_FormInfo_ParameterInfo {
	if x != nil {
		return x.ParameterInfo
	}
	return nil
}

// Represents parameter information.
type PageInfo_FormInfo_ParameterInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always present for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest].
	// Required for
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
	// The human-readable name of the parameter, unique within the form. This
	// field cannot be modified by the webhook.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional for both
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
	// Indicates whether the parameter is required. Optional parameters will
	// not trigger prompts; however, they are filled if the user specifies
	// them. Required parameters must be filled before form filling concludes.
	Required bool `protobuf:"varint,2,opt,name=required,proto3" json:"required,omitempty"`
	// Always present for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest].
	// Required for
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The
	// state of the parameter. This field can be set to
	// [INVALID][google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState.INVALID]
	// by the webhook to invalidate the parameter; other values set by the
	// webhook will be ignored.
	State PageInfo_FormInfo_ParameterInfo_ParameterState `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.dialogflow.cx.v3.PageInfo_FormInfo_ParameterInfo_ParameterState" json:"state,omitempty"`
	// Optional for both
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest] and
	// [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse]. The
	// value of the parameter. This field can be set by the webhook to change
	// the parameter value.
	Value *structpb.Value `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	// Optional for
	// [WebhookRequest][google.cloud.dialogflow.cx.v3.WebhookRequest]. Ignored
	// for [WebhookResponse][google.cloud.dialogflow.cx.v3.WebhookResponse].
	// Indicates if the parameter value was just collected on the last
	// conversation turn.
	JustCollected bool `protobuf:"varint,5,opt,name=just_collected,json=justCollected,proto3" json:"just_collected,omitempty"`
}

func (x *PageInfo_FormInfo_ParameterInfo) Reset() {
	*x = PageInfo_FormInfo_ParameterInfo{}
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PageInfo_FormInfo_ParameterInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PageInfo_FormInfo_ParameterInfo) ProtoMessage() {}

func (x *PageInfo_FormInfo_ParameterInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PageInfo_FormInfo_ParameterInfo.ProtoReflect.Descriptor instead.
func (*PageInfo_FormInfo_ParameterInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP(), []int{9, 0, 0}
}

func (x *PageInfo_FormInfo_ParameterInfo) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *PageInfo_FormInfo_ParameterInfo) GetRequired() bool {
	if x != nil {
		return x.Required
	}
	return false
}

func (x *PageInfo_FormInfo_ParameterInfo) GetState() PageInfo_FormInfo_ParameterInfo_ParameterState {
	if x != nil {
		return x.State
	}
	return PageInfo_FormInfo_ParameterInfo_PARAMETER_STATE_UNSPECIFIED
}

func (x *PageInfo_FormInfo_ParameterInfo) GetValue() *structpb.Value {
	if x != nil {
		return x.Value
	}
	return nil
}

func (x *PageInfo_FormInfo_ParameterInfo) GetJustCollected() bool {
	if x != nil {
		return x.JustCollected
	}
	return false
}

var File_google_cloud_dialogflow_cx_v3_webhook_proto protoreflect.FileDescriptor

var file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1d, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x34, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f, 0x76, 0x33, 0x2f, 0x72,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0x8e, 0x11, 0x0a, 0x07, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6a, 0x0a, 0x13, 0x67, 0x65,
	0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x48, 0x00, 0x52, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x6c, 0x0a, 0x11, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x48, 0x00, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x12, 0x33, 0x0a, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x07, 0x74, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x12, 0x1a, 0x0a, 0x08, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x64, 0x69, 0x73,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x1a, 0xcd, 0x0b, 0x0a, 0x11, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x12, 0x1e, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f,
	0x72, 0x64, 0x12, 0x75, 0x0a, 0x0f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x68, 0x65,
	0x61, 0x64, 0x65, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61,
	0x64, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0e, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x5f, 0x63, 0x65, 0x72, 0x74, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x43, 0x61, 0x43, 0x65, 0x72, 0x74, 0x73, 0x12, 0x6c, 0x0a, 0x0c, 0x6f, 0x61, 0x75, 0x74,
	0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65,
	0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x4f, 0x41, 0x75, 0x74, 0x68, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6f, 0x61, 0x75, 0x74, 0x68,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x7c, 0x0a, 0x12, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x75, 0x74, 0x68, 0x18, 0x0c, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x10, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x41, 0x75, 0x74, 0x68, 0x12, 0x6c, 0x0a, 0x0c, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x69, 0x0a, 0x0b, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f,
	0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x68, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x26, 0x0a,
	0x0c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x42, 0x6f, 0x64, 0x79, 0x12, 0x80, 0x01, 0x0a, 0x11, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x5f, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x18, 0x09, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69,
	0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x4d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x1a, 0xa2, 0x01, 0x0a, 0x0b, 0x4f, 0x41, 0x75,
	0x74, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x20, 0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65,
	0x63, 0x72, 0x65, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0d, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x1a, 0x41, 0x0a,
	0x13, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01,
	0x1a, 0x43, 0x0a, 0x15, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x4d, 0x61, 0x70,
	0x70, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x10, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x67, 0x65, 0x6e, 0x74, 0x41, 0x75, 0x74, 0x68, 0x12, 0x22, 0x0a, 0x1e, 0x53, 0x45, 0x52,
	0x56, 0x49, 0x43, 0x45, 0x5f, 0x41, 0x47, 0x45, 0x4e, 0x54, 0x5f, 0x41, 0x55, 0x54, 0x48, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x49, 0x44, 0x5f, 0x54, 0x4f,
	0x4b, 0x45, 0x4e, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x5f,
	0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x10, 0x03, 0x22, 0x47, 0x0a, 0x0b, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x57, 0x45, 0x42, 0x48, 0x4f, 0x4f,
	0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44,
	0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x46, 0x4c, 0x45, 0x58, 0x49, 0x42, 0x4c, 0x45, 0x10, 0x02,
	0x22, 0x73, 0x0a, 0x0a, 0x48, 0x74, 0x74, 0x70, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x1b,
	0x0a, 0x17, 0x48, 0x54, 0x54, 0x50, 0x5f, 0x4d, 0x45, 0x54, 0x48, 0x4f, 0x44, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x50,
	0x4f, 0x53, 0x54, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x45, 0x54, 0x10, 0x02, 0x12, 0x08,
	0x0a, 0x04, 0x48, 0x45, 0x41, 0x44, 0x10, 0x03, 0x12, 0x07, 0x0a, 0x03, 0x50, 0x55, 0x54, 0x10,
	0x04, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x45, 0x10, 0x05, 0x12, 0x09, 0x0a,
	0x05, 0x50, 0x41, 0x54, 0x43, 0x48, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x4f, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x53, 0x10, 0x07, 0x1a, 0xcd, 0x01, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x49, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x68, 0x0a, 0x13, 0x67,
	0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x5f, 0x77, 0x65, 0x62, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x52, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x57, 0x65, 0x62, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x3a, 0x71, 0xea, 0x41, 0x6e, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x49, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x7b,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x7d, 0x42, 0x09, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x22, 0x94, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x12, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x82, 0x01, 0x0a, 0x14, 0x4c,
	0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x42, 0x0a, 0x08, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x08, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x52, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa0, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x45, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x22, 0x9a, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x45, 0x0a, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x77,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x6b, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f,
	0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x22, 0x8e, 0x0d, 0x0a, 0x0e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x39, 0x0a, 0x19, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x16, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x49, 0x64, 0x12, 0x14,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x12, 0x4e, 0x0a, 0x0e, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x5f,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41,
	0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x48, 0x00, 0x52, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x0a, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x12, 0x25, 0x0a, 0x0d, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52,
	0x0c, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x21, 0x0a,
	0x0b, 0x64, 0x74, 0x6d, 0x66, 0x5f, 0x64, 0x69, 0x67, 0x69, 0x74, 0x73, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x64, 0x74, 0x6d, 0x66, 0x44, 0x69, 0x67, 0x69, 0x74, 0x73,
	0x12, 0x23, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x68, 0x0a, 0x10, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46,
	0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0f,
	0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x59, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0a,
	0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x44, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61,
	0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
	0x66, 0x6f, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12,
	0x4a, 0x0a, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76,
	0x33, 0x2e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67,
	0x65, 0x52, 0x08, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x07, 0x70,
	0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53,
	0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x81,
	0x01, 0x0a, 0x19, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x53, 0x65, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x17, 0x73, 0x65, 0x6e, 0x74, 0x69,
	0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73, 0x75,
	0x6c, 0x74, 0x12, 0x50, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x69,
	0x6e, 0x66, 0x6f, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66,
	0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61,
	0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x49, 0x6e, 0x66, 0x6f, 0x1a, 0x23, 0x0a, 0x0f, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d,
	0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x10, 0x0a, 0x03, 0x74, 0x61, 0x67, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x74, 0x61, 0x67, 0x1a, 0x9d, 0x04, 0x0a, 0x0a, 0x49, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x55, 0x0a, 0x13, 0x6c, 0x61, 0x73, 0x74,
	0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x25, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x11, 0x6c, 0x61,
	0x73, 0x74, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x64, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x68, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f,
	0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x1e, 0x0a, 0x0a,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x02,
	0x52, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x1a, 0x7c, 0x0a, 0x14,
	0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
	0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x72,
	0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x3d, 0x0a, 0x0e, 0x72,
	0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d, 0x72, 0x65, 0x73,
	0x6f, 0x6c, 0x76, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x8c, 0x01, 0x0a, 0x0f, 0x50,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x63, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x49, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x4d, 0x0a, 0x17, 0x53, 0x65, 0x6e,
	0x74, 0x69, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x02, 0x52, 0x05, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x12, 0x1c, 0x0a, 0x09, 0x6d, 0x61,
	0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x09, 0x6d,
	0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x42, 0x07, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x22, 0x95, 0x06, 0x0a, 0x0f, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x75, 0x0a, 0x14, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78,
	0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x52, 0x13, 0x66, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x44, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x50, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x4d, 0x0a, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x6e,
	0x66, 0x6f, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0b, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66,
	0x6f, 0x12, 0x31, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x07, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x12, 0x46, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67, 0x65, 0x48, 0x00,
	0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x46, 0x0a, 0x0b,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x23, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c,
	0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x46, 0x6c, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x46, 0x6c, 0x6f, 0x77, 0x1a, 0xa4, 0x02, 0x0a, 0x13, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c,
	0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x08,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x52, 0x08,
	0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x73, 0x12, 0x77, 0x0a, 0x0e, 0x6d, 0x65, 0x72, 0x67,
	0x65, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33,
	0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x2e, 0x46, 0x75, 0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x52, 0x0d, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x22, 0x48, 0x0a, 0x0d, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x42, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x12, 0x1e, 0x0a, 0x1a, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x42, 0x45, 0x48, 0x41,
	0x56, 0x49, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x50, 0x50, 0x45, 0x4e, 0x44, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x45, 0x50, 0x4c, 0x41, 0x43, 0x45, 0x10, 0x02, 0x42, 0x0c, 0x0a, 0x0a, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9a, 0x05, 0x0a, 0x08, 0x50, 0x61,
	0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x46, 0x0a, 0x0c, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e,
	0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x23, 0xfa, 0x41,
	0x20, 0x0a, 0x1e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x61, 0x67,
	0x65, 0x52, 0x0b, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x50, 0x61, 0x67, 0x65, 0x12, 0x21,
	0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x4d, 0x0a, 0x09, 0x66, 0x6f, 0x72, 0x6d, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46, 0x6f,
	0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x08, 0x66, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f,
	0x1a, 0xd3, 0x03, 0x0a, 0x08, 0x46, 0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x65, 0x0a,
	0x0e, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46,
	0x6f, 0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x0d, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x1a, 0xdf, 0x02, 0x0a, 0x0d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x71,
	0x75, 0x69, 0x72, 0x65, 0x64, 0x12, 0x63, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63,
	0x78, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x46, 0x6f,
	0x72, 0x6d, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x6a, 0x75, 0x73, 0x74,
	0x5f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x6a, 0x75, 0x73, 0x74, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x22,
	0x55, 0x0a, 0x0e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x50, 0x41, 0x52, 0x41, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x4d, 0x50, 0x54, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x49,
	0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x22, 0x82, 0x02, 0x0a, 0x0b, 0x53, 0x65, 0x73, 0x73, 0x69,
	0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x40, 0x0a, 0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x64, 0x69,
	0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x52,
	0x07, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x2e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x1a, 0x55, 0x0a, 0x0f, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9f, 0x01, 0x0a, 0x0c,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2e, 0x0a, 0x13,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x34, 0x0a, 0x16,
	0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
	0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x14, 0x72, 0x65,
	0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x4c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x29, 0x0a, 0x10, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x02, 0x52, 0x0f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x63, 0x6f, 0x72, 0x65, 0x32, 0xb7, 0x08,
	0x0a, 0x08, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0xbf, 0x01, 0x0a, 0x0c, 0x4c,
	0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0x32, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x46, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x12, 0xac, 0x01, 0x0a,
	0x0a, 0x47, 0x65, 0x74, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f,
	0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x57,
	0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x0d,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e,
	0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x22, 0x57, 0xda, 0x41, 0x0e, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x40, 0x3a, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x22, 0x35, 0x2f, 0x76,
	0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x73, 0x12, 0xd2, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e,
	0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x57, 0x65, 0x62, 0x68,
	0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x57, 0x65, 0x62, 0x68, 0x6f,
	0x6f, 0x6b, 0x22, 0x64, 0xda, 0x41, 0x13, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2c, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48,
	0x3a, 0x07, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x32, 0x3d, 0x2f, 0x76, 0x33, 0x2f, 0x7b,
	0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x77, 0x65, 0x62,
	0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa2, 0x01, 0x0a, 0x0d, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67,
	0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x57, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x44, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x78, 0xca,
	0x41, 0x19, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x59, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74,
	0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x64, 0x69, 0x61,
	0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0xae, 0x02, 0xea, 0x41, 0x7c, 0x0a, 0x27, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x21, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x61, 0x6c,
	0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x63, 0x78, 0x2e, 0x76, 0x33, 0x42, 0x0c, 0x57, 0x65,
	0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2f, 0x63, 0x78, 0x2f,
	0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x63, 0x78, 0x70, 0x62, 0x3b, 0x63, 0x78, 0x70, 0x62, 0xa2,
	0x02, 0x02, 0x44, 0x46, 0xaa, 0x02, 0x1d, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77, 0x2e, 0x43,
	0x78, 0x2e, 0x56, 0x33, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x66, 0x6c, 0x6f, 0x77,
	0x3a, 0x3a, 0x43, 0x58, 0x3a, 0x3a, 0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescOnce sync.Once
	file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescData = file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDesc
)

func file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescGZIP() []byte {
	file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescOnce.Do(func() {
		file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescData)
	})
	return file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDescData
}

var file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes = make([]protoimpl.EnumInfo, 5)
var file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes = make([]protoimpl.MessageInfo, 26)
var file_google_cloud_dialogflow_cx_v3_webhook_proto_goTypes = []any{
	(Webhook_GenericWebService_ServiceAgentAuth)(0),        // 0: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAgentAuth
	(Webhook_GenericWebService_WebhookType)(0),             // 1: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.WebhookType
	(Webhook_GenericWebService_HttpMethod)(0),              // 2: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.HttpMethod
	(WebhookResponse_FulfillmentResponse_MergeBehavior)(0), // 3: google.cloud.dialogflow.cx.v3.WebhookResponse.FulfillmentResponse.MergeBehavior
	(PageInfo_FormInfo_ParameterInfo_ParameterState)(0),    // 4: google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
	(*Webhook)(nil),                               // 5: google.cloud.dialogflow.cx.v3.Webhook
	(*ListWebhooksRequest)(nil),                   // 6: google.cloud.dialogflow.cx.v3.ListWebhooksRequest
	(*ListWebhooksResponse)(nil),                  // 7: google.cloud.dialogflow.cx.v3.ListWebhooksResponse
	(*GetWebhookRequest)(nil),                     // 8: google.cloud.dialogflow.cx.v3.GetWebhookRequest
	(*CreateWebhookRequest)(nil),                  // 9: google.cloud.dialogflow.cx.v3.CreateWebhookRequest
	(*UpdateWebhookRequest)(nil),                  // 10: google.cloud.dialogflow.cx.v3.UpdateWebhookRequest
	(*DeleteWebhookRequest)(nil),                  // 11: google.cloud.dialogflow.cx.v3.DeleteWebhookRequest
	(*WebhookRequest)(nil),                        // 12: google.cloud.dialogflow.cx.v3.WebhookRequest
	(*WebhookResponse)(nil),                       // 13: google.cloud.dialogflow.cx.v3.WebhookResponse
	(*PageInfo)(nil),                              // 14: google.cloud.dialogflow.cx.v3.PageInfo
	(*SessionInfo)(nil),                           // 15: google.cloud.dialogflow.cx.v3.SessionInfo
	(*LanguageInfo)(nil),                          // 16: google.cloud.dialogflow.cx.v3.LanguageInfo
	(*Webhook_GenericWebService)(nil),             // 17: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService
	(*Webhook_ServiceDirectoryConfig)(nil),        // 18: google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
	(*Webhook_GenericWebService_OAuthConfig)(nil), // 19: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.OAuthConfig
	nil,                                    // 20: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.RequestHeadersEntry
	nil,                                    // 21: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ParameterMappingEntry
	(*WebhookRequest_FulfillmentInfo)(nil), // 22: google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
	(*WebhookRequest_IntentInfo)(nil),      // 23: google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
	(*WebhookRequest_SentimentAnalysisResult)(nil),         // 24: google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
	(*WebhookRequest_IntentInfo_IntentParameterValue)(nil), // 25: google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
	nil, // 26: google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.ParametersEntry
	(*WebhookResponse_FulfillmentResponse)(nil), // 27: google.cloud.dialogflow.cx.v3.WebhookResponse.FulfillmentResponse
	(*PageInfo_FormInfo)(nil),                   // 28: google.cloud.dialogflow.cx.v3.PageInfo.FormInfo
	(*PageInfo_FormInfo_ParameterInfo)(nil),     // 29: google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
	nil,                                         // 30: google.cloud.dialogflow.cx.v3.SessionInfo.ParametersEntry
	(*durationpb.Duration)(nil),                 // 31: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil),               // 32: google.protobuf.FieldMask
	(*ResponseMessage)(nil),                     // 33: google.cloud.dialogflow.cx.v3.ResponseMessage
	(*structpb.Struct)(nil),                     // 34: google.protobuf.Struct
	(*structpb.Value)(nil),                      // 35: google.protobuf.Value
	(*emptypb.Empty)(nil),                       // 36: google.protobuf.Empty
}
var file_google_cloud_dialogflow_cx_v3_webhook_proto_depIdxs = []int32{
	17, // 0: google.cloud.dialogflow.cx.v3.Webhook.generic_web_service:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService
	18, // 1: google.cloud.dialogflow.cx.v3.Webhook.service_directory:type_name -> google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig
	31, // 2: google.cloud.dialogflow.cx.v3.Webhook.timeout:type_name -> google.protobuf.Duration
	5,  // 3: google.cloud.dialogflow.cx.v3.ListWebhooksResponse.webhooks:type_name -> google.cloud.dialogflow.cx.v3.Webhook
	5,  // 4: google.cloud.dialogflow.cx.v3.CreateWebhookRequest.webhook:type_name -> google.cloud.dialogflow.cx.v3.Webhook
	5,  // 5: google.cloud.dialogflow.cx.v3.UpdateWebhookRequest.webhook:type_name -> google.cloud.dialogflow.cx.v3.Webhook
	32, // 6: google.cloud.dialogflow.cx.v3.UpdateWebhookRequest.update_mask:type_name -> google.protobuf.FieldMask
	22, // 7: google.cloud.dialogflow.cx.v3.WebhookRequest.fulfillment_info:type_name -> google.cloud.dialogflow.cx.v3.WebhookRequest.FulfillmentInfo
	23, // 8: google.cloud.dialogflow.cx.v3.WebhookRequest.intent_info:type_name -> google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo
	14, // 9: google.cloud.dialogflow.cx.v3.WebhookRequest.page_info:type_name -> google.cloud.dialogflow.cx.v3.PageInfo
	15, // 10: google.cloud.dialogflow.cx.v3.WebhookRequest.session_info:type_name -> google.cloud.dialogflow.cx.v3.SessionInfo
	33, // 11: google.cloud.dialogflow.cx.v3.WebhookRequest.messages:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage
	34, // 12: google.cloud.dialogflow.cx.v3.WebhookRequest.payload:type_name -> google.protobuf.Struct
	24, // 13: google.cloud.dialogflow.cx.v3.WebhookRequest.sentiment_analysis_result:type_name -> google.cloud.dialogflow.cx.v3.WebhookRequest.SentimentAnalysisResult
	16, // 14: google.cloud.dialogflow.cx.v3.WebhookRequest.language_info:type_name -> google.cloud.dialogflow.cx.v3.LanguageInfo
	27, // 15: google.cloud.dialogflow.cx.v3.WebhookResponse.fulfillment_response:type_name -> google.cloud.dialogflow.cx.v3.WebhookResponse.FulfillmentResponse
	14, // 16: google.cloud.dialogflow.cx.v3.WebhookResponse.page_info:type_name -> google.cloud.dialogflow.cx.v3.PageInfo
	15, // 17: google.cloud.dialogflow.cx.v3.WebhookResponse.session_info:type_name -> google.cloud.dialogflow.cx.v3.SessionInfo
	34, // 18: google.cloud.dialogflow.cx.v3.WebhookResponse.payload:type_name -> google.protobuf.Struct
	28, // 19: google.cloud.dialogflow.cx.v3.PageInfo.form_info:type_name -> google.cloud.dialogflow.cx.v3.PageInfo.FormInfo
	30, // 20: google.cloud.dialogflow.cx.v3.SessionInfo.parameters:type_name -> google.cloud.dialogflow.cx.v3.SessionInfo.ParametersEntry
	20, // 21: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.request_headers:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.RequestHeadersEntry
	19, // 22: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.oauth_config:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.OAuthConfig
	0,  // 23: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.service_agent_auth:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ServiceAgentAuth
	1,  // 24: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.webhook_type:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.WebhookType
	2,  // 25: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.http_method:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.HttpMethod
	21, // 26: google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.parameter_mapping:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService.ParameterMappingEntry
	17, // 27: google.cloud.dialogflow.cx.v3.Webhook.ServiceDirectoryConfig.generic_web_service:type_name -> google.cloud.dialogflow.cx.v3.Webhook.GenericWebService
	26, // 28: google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.parameters:type_name -> google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.ParametersEntry
	35, // 29: google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue.resolved_value:type_name -> google.protobuf.Value
	25, // 30: google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.ParametersEntry.value:type_name -> google.cloud.dialogflow.cx.v3.WebhookRequest.IntentInfo.IntentParameterValue
	33, // 31: google.cloud.dialogflow.cx.v3.WebhookResponse.FulfillmentResponse.messages:type_name -> google.cloud.dialogflow.cx.v3.ResponseMessage
	3,  // 32: google.cloud.dialogflow.cx.v3.WebhookResponse.FulfillmentResponse.merge_behavior:type_name -> google.cloud.dialogflow.cx.v3.WebhookResponse.FulfillmentResponse.MergeBehavior
	29, // 33: google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.parameter_info:type_name -> google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo
	4,  // 34: google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.state:type_name -> google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.ParameterState
	35, // 35: google.cloud.dialogflow.cx.v3.PageInfo.FormInfo.ParameterInfo.value:type_name -> google.protobuf.Value
	35, // 36: google.cloud.dialogflow.cx.v3.SessionInfo.ParametersEntry.value:type_name -> google.protobuf.Value
	6,  // 37: google.cloud.dialogflow.cx.v3.Webhooks.ListWebhooks:input_type -> google.cloud.dialogflow.cx.v3.ListWebhooksRequest
	8,  // 38: google.cloud.dialogflow.cx.v3.Webhooks.GetWebhook:input_type -> google.cloud.dialogflow.cx.v3.GetWebhookRequest
	9,  // 39: google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook:input_type -> google.cloud.dialogflow.cx.v3.CreateWebhookRequest
	10, // 40: google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook:input_type -> google.cloud.dialogflow.cx.v3.UpdateWebhookRequest
	11, // 41: google.cloud.dialogflow.cx.v3.Webhooks.DeleteWebhook:input_type -> google.cloud.dialogflow.cx.v3.DeleteWebhookRequest
	7,  // 42: google.cloud.dialogflow.cx.v3.Webhooks.ListWebhooks:output_type -> google.cloud.dialogflow.cx.v3.ListWebhooksResponse
	5,  // 43: google.cloud.dialogflow.cx.v3.Webhooks.GetWebhook:output_type -> google.cloud.dialogflow.cx.v3.Webhook
	5,  // 44: google.cloud.dialogflow.cx.v3.Webhooks.CreateWebhook:output_type -> google.cloud.dialogflow.cx.v3.Webhook
	5,  // 45: google.cloud.dialogflow.cx.v3.Webhooks.UpdateWebhook:output_type -> google.cloud.dialogflow.cx.v3.Webhook
	36, // 46: google.cloud.dialogflow.cx.v3.Webhooks.DeleteWebhook:output_type -> google.protobuf.Empty
	42, // [42:47] is the sub-list for method output_type
	37, // [37:42] is the sub-list for method input_type
	37, // [37:37] is the sub-list for extension type_name
	37, // [37:37] is the sub-list for extension extendee
	0,  // [0:37] is the sub-list for field type_name
}

func init() { file_google_cloud_dialogflow_cx_v3_webhook_proto_init() }
func file_google_cloud_dialogflow_cx_v3_webhook_proto_init() {
	if File_google_cloud_dialogflow_cx_v3_webhook_proto != nil {
		return
	}
	file_google_cloud_dialogflow_cx_v3_response_message_proto_init()
	file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[0].OneofWrappers = []any{
		(*Webhook_GenericWebService_)(nil),
		(*Webhook_ServiceDirectory)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[7].OneofWrappers = []any{
		(*WebhookRequest_Text)(nil),
		(*WebhookRequest_TriggerIntent)(nil),
		(*WebhookRequest_Transcript)(nil),
		(*WebhookRequest_TriggerEvent)(nil),
		(*WebhookRequest_DtmfDigits)(nil),
	}
	file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes[8].OneofWrappers = []any{
		(*WebhookResponse_TargetPage)(nil),
		(*WebhookResponse_TargetFlow)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDesc,
			NumEnums:      5,
			NumMessages:   26,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_dialogflow_cx_v3_webhook_proto_goTypes,
		DependencyIndexes: file_google_cloud_dialogflow_cx_v3_webhook_proto_depIdxs,
		EnumInfos:         file_google_cloud_dialogflow_cx_v3_webhook_proto_enumTypes,
		MessageInfos:      file_google_cloud_dialogflow_cx_v3_webhook_proto_msgTypes,
	}.Build()
	File_google_cloud_dialogflow_cx_v3_webhook_proto = out.File
	file_google_cloud_dialogflow_cx_v3_webhook_proto_rawDesc = nil
	file_google_cloud_dialogflow_cx_v3_webhook_proto_goTypes = nil
	file_google_cloud_dialogflow_cx_v3_webhook_proto_depIdxs = nil
}
