// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/eventarc/publishing/v1/publisher.proto

package publishingpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Publisher_PublishChannelConnectionEvents_FullMethodName = "/google.cloud.eventarc.publishing.v1.Publisher/PublishChannelConnectionEvents"
	Publisher_PublishEvents_FullMethodName                  = "/google.cloud.eventarc.publishing.v1.Publisher/PublishEvents"
	Publisher_Publish_FullMethodName                        = "/google.cloud.eventarc.publishing.v1.Publisher/Publish"
)

// PublisherClient is the client API for Publisher service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PublisherClient interface {
	// Publish events to a ChannelConnection in a partner's project.
	PublishChannelConnectionEvents(ctx context.Context, in *PublishChannelConnectionEventsRequest, opts ...grpc.CallOption) (*PublishChannelConnectionEventsResponse, error)
	// Publish events to a subscriber's channel.
	PublishEvents(ctx context.Context, in *PublishEventsRequest, opts ...grpc.CallOption) (*PublishEventsResponse, error)
	// Publish events to a message bus.
	Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error)
}

type publisherClient struct {
	cc grpc.ClientConnInterface
}

func NewPublisherClient(cc grpc.ClientConnInterface) PublisherClient {
	return &publisherClient{cc}
}

func (c *publisherClient) PublishChannelConnectionEvents(ctx context.Context, in *PublishChannelConnectionEventsRequest, opts ...grpc.CallOption) (*PublishChannelConnectionEventsResponse, error) {
	out := new(PublishChannelConnectionEventsResponse)
	err := c.cc.Invoke(ctx, Publisher_PublishChannelConnectionEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) PublishEvents(ctx context.Context, in *PublishEventsRequest, opts ...grpc.CallOption) (*PublishEventsResponse, error) {
	out := new(PublishEventsResponse)
	err := c.cc.Invoke(ctx, Publisher_PublishEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publisherClient) Publish(ctx context.Context, in *PublishRequest, opts ...grpc.CallOption) (*PublishResponse, error) {
	out := new(PublishResponse)
	err := c.cc.Invoke(ctx, Publisher_Publish_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PublisherServer is the server API for Publisher service.
// All implementations should embed UnimplementedPublisherServer
// for forward compatibility
type PublisherServer interface {
	// Publish events to a ChannelConnection in a partner's project.
	PublishChannelConnectionEvents(context.Context, *PublishChannelConnectionEventsRequest) (*PublishChannelConnectionEventsResponse, error)
	// Publish events to a subscriber's channel.
	PublishEvents(context.Context, *PublishEventsRequest) (*PublishEventsResponse, error)
	// Publish events to a message bus.
	Publish(context.Context, *PublishRequest) (*PublishResponse, error)
}

// UnimplementedPublisherServer should be embedded to have forward compatible implementations.
type UnimplementedPublisherServer struct {
}

func (UnimplementedPublisherServer) PublishChannelConnectionEvents(context.Context, *PublishChannelConnectionEventsRequest) (*PublishChannelConnectionEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishChannelConnectionEvents not implemented")
}
func (UnimplementedPublisherServer) PublishEvents(context.Context, *PublishEventsRequest) (*PublishEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishEvents not implemented")
}
func (UnimplementedPublisherServer) Publish(context.Context, *PublishRequest) (*PublishResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Publish not implemented")
}

// UnsafePublisherServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PublisherServer will
// result in compilation errors.
type UnsafePublisherServer interface {
	mustEmbedUnimplementedPublisherServer()
}

func RegisterPublisherServer(s grpc.ServiceRegistrar, srv PublisherServer) {
	s.RegisterService(&Publisher_ServiceDesc, srv)
}

func _Publisher_PublishChannelConnectionEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishChannelConnectionEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).PublishChannelConnectionEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_PublishChannelConnectionEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).PublishChannelConnectionEvents(ctx, req.(*PublishChannelConnectionEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_PublishEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).PublishEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_PublishEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).PublishEvents(ctx, req.(*PublishEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Publisher_Publish_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublisherServer).Publish(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Publisher_Publish_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublisherServer).Publish(ctx, req.(*PublishRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Publisher_ServiceDesc is the grpc.ServiceDesc for Publisher service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Publisher_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.eventarc.publishing.v1.Publisher",
	HandlerType: (*PublisherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PublishChannelConnectionEvents",
			Handler:    _Publisher_PublishChannelConnectionEvents_Handler,
		},
		{
			MethodName: "PublishEvents",
			Handler:    _Publisher_PublishEvents_Handler,
		},
		{
			MethodName: "Publish",
			Handler:    _Publisher_Publish_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/eventarc/publishing/v1/publisher.proto",
}
