// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.25.3
// source: google/cloud/filestore/v1/cloud_filestore_service.proto

package filestorepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/cloud/common"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	wrapperspb "google.golang.org/protobuf/types/known/wrapperspb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Internet protocol versions supported by Filestore.
type NetworkConfig_AddressMode int32

const (
	// Internet protocol not set.
	NetworkConfig_ADDRESS_MODE_UNSPECIFIED NetworkConfig_AddressMode = 0
	// Use the IPv4 internet protocol.
	NetworkConfig_MODE_IPV4 NetworkConfig_AddressMode = 1
)

// Enum value maps for NetworkConfig_AddressMode.
var (
	NetworkConfig_AddressMode_name = map[int32]string{
		0: "ADDRESS_MODE_UNSPECIFIED",
		1: "MODE_IPV4",
	}
	NetworkConfig_AddressMode_value = map[string]int32{
		"ADDRESS_MODE_UNSPECIFIED": 0,
		"MODE_IPV4":                1,
	}
)

func (x NetworkConfig_AddressMode) Enum() *NetworkConfig_AddressMode {
	p := new(NetworkConfig_AddressMode)
	*p = x
	return p
}

func (x NetworkConfig_AddressMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_AddressMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[0].Descriptor()
}

func (NetworkConfig_AddressMode) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[0]
}

func (x NetworkConfig_AddressMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_AddressMode.Descriptor instead.
func (NetworkConfig_AddressMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{0, 0}
}

// Available connection modes.
type NetworkConfig_ConnectMode int32

const (
	// Not set.
	NetworkConfig_CONNECT_MODE_UNSPECIFIED NetworkConfig_ConnectMode = 0
	// Connect via direct peering to the Filestore service.
	NetworkConfig_DIRECT_PEERING NetworkConfig_ConnectMode = 1
	// Connect to your Filestore instance using Private Service
	// Access. Private services access provides an IP address range for multiple
	// Google Cloud services, including Filestore.
	NetworkConfig_PRIVATE_SERVICE_ACCESS NetworkConfig_ConnectMode = 2
)

// Enum value maps for NetworkConfig_ConnectMode.
var (
	NetworkConfig_ConnectMode_name = map[int32]string{
		0: "CONNECT_MODE_UNSPECIFIED",
		1: "DIRECT_PEERING",
		2: "PRIVATE_SERVICE_ACCESS",
	}
	NetworkConfig_ConnectMode_value = map[string]int32{
		"CONNECT_MODE_UNSPECIFIED": 0,
		"DIRECT_PEERING":           1,
		"PRIVATE_SERVICE_ACCESS":   2,
	}
)

func (x NetworkConfig_ConnectMode) Enum() *NetworkConfig_ConnectMode {
	p := new(NetworkConfig_ConnectMode)
	*p = x
	return p
}

func (x NetworkConfig_ConnectMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NetworkConfig_ConnectMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[1].Descriptor()
}

func (NetworkConfig_ConnectMode) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[1]
}

func (x NetworkConfig_ConnectMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NetworkConfig_ConnectMode.Descriptor instead.
func (NetworkConfig_ConnectMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{0, 1}
}

// The access mode.
type NfsExportOptions_AccessMode int32

const (
	// AccessMode not set.
	NfsExportOptions_ACCESS_MODE_UNSPECIFIED NfsExportOptions_AccessMode = 0
	// The client can only read the file share.
	NfsExportOptions_READ_ONLY NfsExportOptions_AccessMode = 1
	// The client can read and write the file share (default).
	NfsExportOptions_READ_WRITE NfsExportOptions_AccessMode = 2
)

// Enum value maps for NfsExportOptions_AccessMode.
var (
	NfsExportOptions_AccessMode_name = map[int32]string{
		0: "ACCESS_MODE_UNSPECIFIED",
		1: "READ_ONLY",
		2: "READ_WRITE",
	}
	NfsExportOptions_AccessMode_value = map[string]int32{
		"ACCESS_MODE_UNSPECIFIED": 0,
		"READ_ONLY":               1,
		"READ_WRITE":              2,
	}
)

func (x NfsExportOptions_AccessMode) Enum() *NfsExportOptions_AccessMode {
	p := new(NfsExportOptions_AccessMode)
	*p = x
	return p
}

func (x NfsExportOptions_AccessMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NfsExportOptions_AccessMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[2].Descriptor()
}

func (NfsExportOptions_AccessMode) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[2]
}

func (x NfsExportOptions_AccessMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NfsExportOptions_AccessMode.Descriptor instead.
func (NfsExportOptions_AccessMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{2, 0}
}

// The squash mode.
type NfsExportOptions_SquashMode int32

const (
	// SquashMode not set.
	NfsExportOptions_SQUASH_MODE_UNSPECIFIED NfsExportOptions_SquashMode = 0
	// The Root user has root access to the file share (default).
	NfsExportOptions_NO_ROOT_SQUASH NfsExportOptions_SquashMode = 1
	// The Root user has squashed access to the anonymous uid/gid.
	NfsExportOptions_ROOT_SQUASH NfsExportOptions_SquashMode = 2
)

// Enum value maps for NfsExportOptions_SquashMode.
var (
	NfsExportOptions_SquashMode_name = map[int32]string{
		0: "SQUASH_MODE_UNSPECIFIED",
		1: "NO_ROOT_SQUASH",
		2: "ROOT_SQUASH",
	}
	NfsExportOptions_SquashMode_value = map[string]int32{
		"SQUASH_MODE_UNSPECIFIED": 0,
		"NO_ROOT_SQUASH":          1,
		"ROOT_SQUASH":             2,
	}
)

func (x NfsExportOptions_SquashMode) Enum() *NfsExportOptions_SquashMode {
	p := new(NfsExportOptions_SquashMode)
	*p = x
	return p
}

func (x NfsExportOptions_SquashMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NfsExportOptions_SquashMode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[3].Descriptor()
}

func (NfsExportOptions_SquashMode) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[3]
}

func (x NfsExportOptions_SquashMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NfsExportOptions_SquashMode.Descriptor instead.
func (NfsExportOptions_SquashMode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{2, 1}
}

// The instance state.
type Instance_State int32

const (
	// State not set.
	Instance_STATE_UNSPECIFIED Instance_State = 0
	// The instance is being created.
	Instance_CREATING Instance_State = 1
	// The instance is available for use.
	Instance_READY Instance_State = 2
	// Work is being done on the instance. You can get further details from the
	// `statusMessage` field of the `Instance` resource.
	Instance_REPAIRING Instance_State = 3
	// The instance is shutting down.
	Instance_DELETING Instance_State = 4
	// The instance is experiencing an issue and might be unusable. You can get
	// further details from the `statusMessage` field of the `Instance`
	// resource.
	Instance_ERROR Instance_State = 6
	// The instance is restoring a backup to an existing file share and may be
	// unusable during this time.
	Instance_RESTORING Instance_State = 7
	// The instance is suspended. You can get further details from
	// the `suspension_reasons` field of the `Instance` resource.
	Instance_SUSPENDED Instance_State = 8
	// The instance is in the process of becoming suspended.
	Instance_SUSPENDING Instance_State = 9
	// The instance is in the process of becoming active.
	Instance_RESUMING Instance_State = 10
	// The instance is reverting to a snapshot.
	Instance_REVERTING Instance_State = 12
)

// Enum value maps for Instance_State.
var (
	Instance_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "CREATING",
		2:  "READY",
		3:  "REPAIRING",
		4:  "DELETING",
		6:  "ERROR",
		7:  "RESTORING",
		8:  "SUSPENDED",
		9:  "SUSPENDING",
		10: "RESUMING",
		12: "REVERTING",
	}
	Instance_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"REPAIRING":         3,
		"DELETING":          4,
		"ERROR":             6,
		"RESTORING":         7,
		"SUSPENDED":         8,
		"SUSPENDING":        9,
		"RESUMING":          10,
		"REVERTING":         12,
	}
)

func (x Instance_State) Enum() *Instance_State {
	p := new(Instance_State)
	*p = x
	return p
}

func (x Instance_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[4].Descriptor()
}

func (Instance_State) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[4]
}

func (x Instance_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_State.Descriptor instead.
func (Instance_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{3, 0}
}

// Available service tiers.
type Instance_Tier int32

const (
	// Not set.
	Instance_TIER_UNSPECIFIED Instance_Tier = 0
	// STANDARD tier. BASIC_HDD is the preferred term for this tier.
	Instance_STANDARD Instance_Tier = 1
	// PREMIUM tier. BASIC_SSD is the preferred term for this tier.
	Instance_PREMIUM Instance_Tier = 2
	// BASIC instances offer a maximum capacity of 63.9 TB.
	// BASIC_HDD is an alias for STANDARD Tier, offering economical
	// performance backed by HDD.
	Instance_BASIC_HDD Instance_Tier = 3
	// BASIC instances offer a maximum capacity of 63.9 TB.
	// BASIC_SSD is an alias for PREMIUM Tier, and offers improved
	// performance backed by SSD.
	Instance_BASIC_SSD Instance_Tier = 4
	// HIGH_SCALE instances offer expanded capacity and performance scaling
	// capabilities.
	Instance_HIGH_SCALE_SSD Instance_Tier = 5
	// ENTERPRISE instances offer the features and availability needed for
	// mission-critical workloads.
	Instance_ENTERPRISE Instance_Tier = 6
	// ZONAL instances offer expanded capacity and performance scaling
	// capabilities.
	Instance_ZONAL Instance_Tier = 7
	// REGIONAL instances offer the features and availability needed for
	// mission-critical workloads.
	Instance_REGIONAL Instance_Tier = 8
)

// Enum value maps for Instance_Tier.
var (
	Instance_Tier_name = map[int32]string{
		0: "TIER_UNSPECIFIED",
		1: "STANDARD",
		2: "PREMIUM",
		3: "BASIC_HDD",
		4: "BASIC_SSD",
		5: "HIGH_SCALE_SSD",
		6: "ENTERPRISE",
		7: "ZONAL",
		8: "REGIONAL",
	}
	Instance_Tier_value = map[string]int32{
		"TIER_UNSPECIFIED": 0,
		"STANDARD":         1,
		"PREMIUM":          2,
		"BASIC_HDD":        3,
		"BASIC_SSD":        4,
		"HIGH_SCALE_SSD":   5,
		"ENTERPRISE":       6,
		"ZONAL":            7,
		"REGIONAL":         8,
	}
)

func (x Instance_Tier) Enum() *Instance_Tier {
	p := new(Instance_Tier)
	*p = x
	return p
}

func (x Instance_Tier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_Tier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[5].Descriptor()
}

func (Instance_Tier) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[5]
}

func (x Instance_Tier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_Tier.Descriptor instead.
func (Instance_Tier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{3, 1}
}

// SuspensionReason contains the possible reasons for a suspension.
type Instance_SuspensionReason int32

const (
	// Not set.
	Instance_SUSPENSION_REASON_UNSPECIFIED Instance_SuspensionReason = 0
	// The KMS key used by the instance is either revoked or denied access to.
	Instance_KMS_KEY_ISSUE Instance_SuspensionReason = 1
)

// Enum value maps for Instance_SuspensionReason.
var (
	Instance_SuspensionReason_name = map[int32]string{
		0: "SUSPENSION_REASON_UNSPECIFIED",
		1: "KMS_KEY_ISSUE",
	}
	Instance_SuspensionReason_value = map[string]int32{
		"SUSPENSION_REASON_UNSPECIFIED": 0,
		"KMS_KEY_ISSUE":                 1,
	}
)

func (x Instance_SuspensionReason) Enum() *Instance_SuspensionReason {
	p := new(Instance_SuspensionReason)
	*p = x
	return p
}

func (x Instance_SuspensionReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Instance_SuspensionReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[6].Descriptor()
}

func (Instance_SuspensionReason) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[6]
}

func (x Instance_SuspensionReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Instance_SuspensionReason.Descriptor instead.
func (Instance_SuspensionReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{3, 2}
}

// The snapshot state.
type Snapshot_State int32

const (
	// State not set.
	Snapshot_STATE_UNSPECIFIED Snapshot_State = 0
	// Snapshot is being created.
	Snapshot_CREATING Snapshot_State = 1
	// Snapshot is available for use.
	Snapshot_READY Snapshot_State = 2
	// Snapshot is being deleted.
	Snapshot_DELETING Snapshot_State = 3
)

// Enum value maps for Snapshot_State.
var (
	Snapshot_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "DELETING",
	}
	Snapshot_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"DELETING":          3,
	}
)

func (x Snapshot_State) Enum() *Snapshot_State {
	p := new(Snapshot_State)
	*p = x
	return p
}

func (x Snapshot_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Snapshot_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[7].Descriptor()
}

func (Snapshot_State) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[7]
}

func (x Snapshot_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Snapshot_State.Descriptor instead.
func (Snapshot_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{12, 0}
}

// The backup state.
type Backup_State int32

const (
	// State not set.
	Backup_STATE_UNSPECIFIED Backup_State = 0
	// Backup is being created.
	Backup_CREATING Backup_State = 1
	// Backup has been taken and the operation is being finalized. At this
	// point, changes to the file share will not be reflected in the backup.
	Backup_FINALIZING Backup_State = 2
	// Backup is available for use.
	Backup_READY Backup_State = 3
	// Backup is being deleted.
	Backup_DELETING Backup_State = 4
	// Backup is not valid and cannot be used for creating new instances or
	// restoring existing instances.
	Backup_INVALID Backup_State = 5
)

// Enum value maps for Backup_State.
var (
	Backup_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "FINALIZING",
		3: "READY",
		4: "DELETING",
		5: "INVALID",
	}
	Backup_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"FINALIZING":        2,
		"READY":             3,
		"DELETING":          4,
		"INVALID":           5,
	}
)

func (x Backup_State) Enum() *Backup_State {
	p := new(Backup_State)
	*p = x
	return p
}

func (x Backup_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Backup_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[8].Descriptor()
}

func (Backup_State) Type() protoreflect.EnumType {
	return &file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes[8]
}

func (x Backup_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Backup_State.Descriptor instead.
func (Backup_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{19, 0}
}

// Network configuration for the instance.
type NetworkConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the Google Compute Engine
	// [VPC network](https://cloud.google.com/vpc/docs/vpc) to which the
	// instance is connected.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Internet protocol versions for which the instance has IP addresses
	// assigned. For this version, only MODE_IPV4 is supported.
	Modes []NetworkConfig_AddressMode `protobuf:"varint,3,rep,packed,name=modes,proto3,enum=google.cloud.filestore.v1.NetworkConfig_AddressMode" json:"modes,omitempty"`
	// Optional, reserved_ip_range can have one of the following two types of
	// values.
	//
	// * CIDR range value when using DIRECT_PEERING connect mode.
	// * [Allocated IP address
	// range](https://cloud.google.com/compute/docs/ip-addresses/reserve-static-internal-ip-address)
	// when using PRIVATE_SERVICE_ACCESS connect mode.
	//
	// When the name of an allocated IP address range is specified, it must be one
	// of the ranges associated with the private service access connection.
	// When specified as a direct CIDR value, it must be a /29 CIDR block for
	// Basic tier, a /24 CIDR block for High Scale tier, or a /26 CIDR block for
	// Enterprise tier in one of the [internal IP address
	// ranges](https://www.arin.net/reference/research/statistics/address_filters/)
	// that identifies the range of IP addresses reserved for this instance. For
	// example, 10.0.0.0/29, 192.168.0.0/24 or 192.168.0.0/26, respectively. The
	// range you specify can't overlap with either existing subnets or assigned IP
	// address ranges for other Filestore instances in the selected VPC
	// network.
	ReservedIpRange string `protobuf:"bytes,4,opt,name=reserved_ip_range,json=reservedIpRange,proto3" json:"reserved_ip_range,omitempty"`
	// Output only. IPv4 addresses in the format
	// `{octet1}.{octet2}.{octet3}.{octet4}` or IPv6 addresses in the format
	// `{block1}:{block2}:{block3}:{block4}:{block5}:{block6}:{block7}:{block8}`.
	IpAddresses []string `protobuf:"bytes,5,rep,name=ip_addresses,json=ipAddresses,proto3" json:"ip_addresses,omitempty"`
	// The network connect mode of the Filestore instance.
	// If not provided, the connect mode defaults to DIRECT_PEERING.
	ConnectMode NetworkConfig_ConnectMode `protobuf:"varint,6,opt,name=connect_mode,json=connectMode,proto3,enum=google.cloud.filestore.v1.NetworkConfig_ConnectMode" json:"connect_mode,omitempty"`
}

func (x *NetworkConfig) Reset() {
	*x = NetworkConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NetworkConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkConfig) ProtoMessage() {}

func (x *NetworkConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkConfig.ProtoReflect.Descriptor instead.
func (*NetworkConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{0}
}

func (x *NetworkConfig) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkConfig) GetModes() []NetworkConfig_AddressMode {
	if x != nil {
		return x.Modes
	}
	return nil
}

func (x *NetworkConfig) GetReservedIpRange() string {
	if x != nil {
		return x.ReservedIpRange
	}
	return ""
}

func (x *NetworkConfig) GetIpAddresses() []string {
	if x != nil {
		return x.IpAddresses
	}
	return nil
}

func (x *NetworkConfig) GetConnectMode() NetworkConfig_ConnectMode {
	if x != nil {
		return x.ConnectMode
	}
	return NetworkConfig_CONNECT_MODE_UNSPECIFIED
}

// File share configuration for the instance.
type FileShareConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the file share. Must use 1-16 characters for the
	// basic service tier and 1-63 characters for all other service tiers.
	// Must use lowercase letters, numbers, or underscores `[a-z0-9_]`. Must
	// start with a letter. Immutable.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// File share capacity in gigabytes (GB).
	// Filestore defines 1 GB as 1024^3 bytes.
	CapacityGb int64 `protobuf:"varint,2,opt,name=capacity_gb,json=capacityGb,proto3" json:"capacity_gb,omitempty"`
	// The source that this file share has been restored from. Empty if the file
	// share is created from scratch.
	//
	// Types that are assignable to Source:
	//
	//	*FileShareConfig_SourceBackup
	Source isFileShareConfig_Source `protobuf_oneof:"source"`
	// Nfs Export Options.
	// There is a limit of 10 export options per file share.
	NfsExportOptions []*NfsExportOptions `protobuf:"bytes,7,rep,name=nfs_export_options,json=nfsExportOptions,proto3" json:"nfs_export_options,omitempty"`
}

func (x *FileShareConfig) Reset() {
	*x = FileShareConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileShareConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileShareConfig) ProtoMessage() {}

func (x *FileShareConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileShareConfig.ProtoReflect.Descriptor instead.
func (*FileShareConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{1}
}

func (x *FileShareConfig) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileShareConfig) GetCapacityGb() int64 {
	if x != nil {
		return x.CapacityGb
	}
	return 0
}

func (m *FileShareConfig) GetSource() isFileShareConfig_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *FileShareConfig) GetSourceBackup() string {
	if x, ok := x.GetSource().(*FileShareConfig_SourceBackup); ok {
		return x.SourceBackup
	}
	return ""
}

func (x *FileShareConfig) GetNfsExportOptions() []*NfsExportOptions {
	if x != nil {
		return x.NfsExportOptions
	}
	return nil
}

type isFileShareConfig_Source interface {
	isFileShareConfig_Source()
}

type FileShareConfig_SourceBackup struct {
	// The resource name of the backup, in the format
	// `projects/{project_number}/locations/{location_id}/backups/{backup_id}`,
	// that this file share has been restored from.
	SourceBackup string `protobuf:"bytes,8,opt,name=source_backup,json=sourceBackup,proto3,oneof"`
}

func (*FileShareConfig_SourceBackup) isFileShareConfig_Source() {}

// NFS export options specifications.
type NfsExportOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of either an IPv4 addresses in the format
	// `{octet1}.{octet2}.{octet3}.{octet4}` or CIDR ranges in the format
	// `{octet1}.{octet2}.{octet3}.{octet4}/{mask size}` which may mount the
	// file share.
	// Overlapping IP ranges are not allowed, both within and across
	// NfsExportOptions. An error will be returned.
	// The limit is 64 IP ranges/addresses for each FileShareConfig among all
	// NfsExportOptions.
	IpRanges []string `protobuf:"bytes,1,rep,name=ip_ranges,json=ipRanges,proto3" json:"ip_ranges,omitempty"`
	// Either READ_ONLY, for allowing only read requests on the exported
	// directory, or READ_WRITE, for allowing both read and write requests.
	// The default is READ_WRITE.
	AccessMode NfsExportOptions_AccessMode `protobuf:"varint,2,opt,name=access_mode,json=accessMode,proto3,enum=google.cloud.filestore.v1.NfsExportOptions_AccessMode" json:"access_mode,omitempty"`
	// Either NO_ROOT_SQUASH, for allowing root access on the exported directory,
	// or ROOT_SQUASH, for not allowing root access. The default is
	// NO_ROOT_SQUASH.
	SquashMode NfsExportOptions_SquashMode `protobuf:"varint,3,opt,name=squash_mode,json=squashMode,proto3,enum=google.cloud.filestore.v1.NfsExportOptions_SquashMode" json:"squash_mode,omitempty"`
	// An integer representing the anonymous user id with a default value of
	// 65534.
	// Anon_uid may only be set with squash_mode of ROOT_SQUASH.  An error will be
	// returned if this field is specified for other squash_mode settings.
	AnonUid int64 `protobuf:"varint,4,opt,name=anon_uid,json=anonUid,proto3" json:"anon_uid,omitempty"`
	// An integer representing the anonymous group id with a default value of
	// 65534.
	// Anon_gid may only be set with squash_mode of ROOT_SQUASH.  An error will be
	// returned if this field is specified for other squash_mode settings.
	AnonGid int64 `protobuf:"varint,5,opt,name=anon_gid,json=anonGid,proto3" json:"anon_gid,omitempty"`
}

func (x *NfsExportOptions) Reset() {
	*x = NfsExportOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *NfsExportOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NfsExportOptions) ProtoMessage() {}

func (x *NfsExportOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NfsExportOptions.ProtoReflect.Descriptor instead.
func (*NfsExportOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{2}
}

func (x *NfsExportOptions) GetIpRanges() []string {
	if x != nil {
		return x.IpRanges
	}
	return nil
}

func (x *NfsExportOptions) GetAccessMode() NfsExportOptions_AccessMode {
	if x != nil {
		return x.AccessMode
	}
	return NfsExportOptions_ACCESS_MODE_UNSPECIFIED
}

func (x *NfsExportOptions) GetSquashMode() NfsExportOptions_SquashMode {
	if x != nil {
		return x.SquashMode
	}
	return NfsExportOptions_SQUASH_MODE_UNSPECIFIED
}

func (x *NfsExportOptions) GetAnonUid() int64 {
	if x != nil {
		return x.AnonUid
	}
	return 0
}

func (x *NfsExportOptions) GetAnonGid() int64 {
	if x != nil {
		return x.AnonGid
	}
	return 0
}

// A Filestore instance.
type Instance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the instance, in the format
	// `projects/{project}/locations/{location}/instances/{instance}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The description of the instance (2048 characters or less).
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The instance state.
	State Instance_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.filestore.v1.Instance_State" json:"state,omitempty"`
	// Output only. Additional information about the instance state, if available.
	StatusMessage string `protobuf:"bytes,6,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. The time when the instance was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The service tier of the instance.
	Tier Instance_Tier `protobuf:"varint,8,opt,name=tier,proto3,enum=google.cloud.filestore.v1.Instance_Tier" json:"tier,omitempty"`
	// Resource labels to represent user provided metadata.
	Labels map[string]string `protobuf:"bytes,9,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// File system shares on the instance.
	// For this version, only a single file share is supported.
	FileShares []*FileShareConfig `protobuf:"bytes,10,rep,name=file_shares,json=fileShares,proto3" json:"file_shares,omitempty"`
	// VPC networks to which the instance is connected.
	// For this version, only a single network is supported.
	Networks []*NetworkConfig `protobuf:"bytes,11,rep,name=networks,proto3" json:"networks,omitempty"`
	// Server-specified ETag for the instance resource to prevent simultaneous
	// updates from overwriting each other.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs *wrapperspb.BoolValue `protobuf:"bytes,13,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,18,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// KMS key name used for data encryption.
	KmsKeyName string `protobuf:"bytes,14,opt,name=kms_key_name,json=kmsKeyName,proto3" json:"kms_key_name,omitempty"`
	// Output only. Field indicates all the reasons the instance is in "SUSPENDED"
	// state.
	SuspensionReasons []Instance_SuspensionReason `protobuf:"varint,15,rep,packed,name=suspension_reasons,json=suspensionReasons,proto3,enum=google.cloud.filestore.v1.Instance_SuspensionReason" json:"suspension_reasons,omitempty"`
}

func (x *Instance) Reset() {
	*x = Instance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Instance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Instance) ProtoMessage() {}

func (x *Instance) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Instance.ProtoReflect.Descriptor instead.
func (*Instance) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{3}
}

func (x *Instance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Instance) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Instance) GetState() Instance_State {
	if x != nil {
		return x.State
	}
	return Instance_STATE_UNSPECIFIED
}

func (x *Instance) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *Instance) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Instance) GetTier() Instance_Tier {
	if x != nil {
		return x.Tier
	}
	return Instance_TIER_UNSPECIFIED
}

func (x *Instance) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Instance) GetFileShares() []*FileShareConfig {
	if x != nil {
		return x.FileShares
	}
	return nil
}

func (x *Instance) GetNetworks() []*NetworkConfig {
	if x != nil {
		return x.Networks
	}
	return nil
}

func (x *Instance) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *Instance) GetSatisfiesPzs() *wrapperspb.BoolValue {
	if x != nil {
		return x.SatisfiesPzs
	}
	return nil
}

func (x *Instance) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *Instance) GetKmsKeyName() string {
	if x != nil {
		return x.KmsKeyName
	}
	return ""
}

func (x *Instance) GetSuspensionReasons() []Instance_SuspensionReason {
	if x != nil {
		return x.SuspensionReasons
	}
	return nil
}

// CreateInstanceRequest creates an instance.
type CreateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance's project and location, in the format
	// `projects/{project_id}/locations/{location}`. In Filestore,
	// locations map to Google Cloud zones, for example **us-west1-b**.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The name of the instance to create.
	// The name must be unique for the specified project and location.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. An [instance resource][google.cloud.filestore.v1.Instance]
	Instance *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *CreateInstanceRequest) Reset() {
	*x = CreateInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateInstanceRequest) ProtoMessage() {}

func (x *CreateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateInstanceRequest.ProtoReflect.Descriptor instead.
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{4}
}

func (x *CreateInstanceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *CreateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// GetInstanceRequest gets the state of an instance.
type GetInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance resource name, in the format
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetInstanceRequest) Reset() {
	*x = GetInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetInstanceRequest) ProtoMessage() {}

func (x *GetInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetInstanceRequest.ProtoReflect.Descriptor instead.
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{5}
}

func (x *GetInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateInstanceRequest updates the settings of an instance.
type UpdateInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Mask of fields to update.  At least one path must be supplied in this
	// field.  The elements of the repeated paths field may only include these
	// fields:
	//
	// * "description"
	// * "file_shares"
	// * "labels"
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Only fields specified in update_mask are updated.
	Instance *Instance `protobuf:"bytes,2,opt,name=instance,proto3" json:"instance,omitempty"`
}

func (x *UpdateInstanceRequest) Reset() {
	*x = UpdateInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateInstanceRequest) ProtoMessage() {}

func (x *UpdateInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateInstanceRequest.ProtoReflect.Descriptor instead.
func (*UpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{6}
}

func (x *UpdateInstanceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateInstanceRequest) GetInstance() *Instance {
	if x != nil {
		return x.Instance
	}
	return nil
}

// RestoreInstanceRequest restores an existing instance's file share from a
// backup.
type RestoreInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the instance, in the format
	// `projects/{project_number}/locations/{location_id}/instances/{instance_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Name of the file share in the Filestore instance that the backup
	// is being restored to.
	FileShare string `protobuf:"bytes,2,opt,name=file_share,json=fileShare,proto3" json:"file_share,omitempty"`
	// Types that are assignable to Source:
	//
	//	*RestoreInstanceRequest_SourceBackup
	Source isRestoreInstanceRequest_Source `protobuf_oneof:"source"`
}

func (x *RestoreInstanceRequest) Reset() {
	*x = RestoreInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RestoreInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RestoreInstanceRequest) ProtoMessage() {}

func (x *RestoreInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RestoreInstanceRequest.ProtoReflect.Descriptor instead.
func (*RestoreInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{7}
}

func (x *RestoreInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RestoreInstanceRequest) GetFileShare() string {
	if x != nil {
		return x.FileShare
	}
	return ""
}

func (m *RestoreInstanceRequest) GetSource() isRestoreInstanceRequest_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *RestoreInstanceRequest) GetSourceBackup() string {
	if x, ok := x.GetSource().(*RestoreInstanceRequest_SourceBackup); ok {
		return x.SourceBackup
	}
	return ""
}

type isRestoreInstanceRequest_Source interface {
	isRestoreInstanceRequest_Source()
}

type RestoreInstanceRequest_SourceBackup struct {
	// The resource name of the backup, in the format
	// `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
	SourceBackup string `protobuf:"bytes,3,opt,name=source_backup,json=sourceBackup,proto3,oneof"`
}

func (*RestoreInstanceRequest_SourceBackup) isRestoreInstanceRequest_Source() {}

// RevertInstanceRequest reverts the given instance's file share to the
// specified snapshot.
type RevertInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	// `projects/{project_id}/locations/{location_id}/instances/{instance_id}`.
	// The resource name of the instance, in the format
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The snapshot resource ID, in the format 'my-snapshot', where the
	// specified ID is the {snapshot_id} of the fully qualified name like
	// `projects/{project_id}/locations/{location_id}/instances/{instance_id}/snapshots/{snapshot_id}`
	TargetSnapshotId string `protobuf:"bytes,2,opt,name=target_snapshot_id,json=targetSnapshotId,proto3" json:"target_snapshot_id,omitempty"`
}

func (x *RevertInstanceRequest) Reset() {
	*x = RevertInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RevertInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevertInstanceRequest) ProtoMessage() {}

func (x *RevertInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevertInstanceRequest.ProtoReflect.Descriptor instead.
func (*RevertInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{8}
}

func (x *RevertInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RevertInstanceRequest) GetTargetSnapshotId() string {
	if x != nil {
		return x.TargetSnapshotId
	}
	return ""
}

// DeleteInstanceRequest deletes an instance.
type DeleteInstanceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance resource name, in the format
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If set to true, all snapshots of the instance will also be deleted.
	// (Otherwise, the request will only work if the instance has no snapshots.)
	Force bool `protobuf:"varint,2,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteInstanceRequest) Reset() {
	*x = DeleteInstanceRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteInstanceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteInstanceRequest) ProtoMessage() {}

func (x *DeleteInstanceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteInstanceRequest.ProtoReflect.Descriptor instead.
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{9}
}

func (x *DeleteInstanceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteInstanceRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// ListInstancesRequest lists instances.
type ListInstancesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve instance
	// information, in the format `projects/{project_id}/locations/{location}`. In
	// Cloud Filestore, locations map to Google Cloud zones, for example
	// **us-west1-b**. To retrieve instance information for all locations, use "-"
	// for the
	// `{location}` value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value to use if there are additional
	// results to retrieve for this list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Sort results. Supported values are "name", "name desc" or "" (unsorted).
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListInstancesRequest) Reset() {
	*x = ListInstancesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesRequest) ProtoMessage() {}

func (x *ListInstancesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesRequest.ProtoReflect.Descriptor instead.
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{10}
}

func (x *ListInstancesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListInstancesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListInstancesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListInstancesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListInstancesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ListInstancesResponse is the result of ListInstancesRequest.
type ListInstancesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of instances in the project for the specified location.
	//
	// If the `{location}` value in the request is "-", the response contains a
	// list of instances from all locations. If any location is unreachable, the
	// response will only return instances in reachable locations and the
	// "unreachable" field will be populated with a list of unreachable locations.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// The token you can use to retrieve the next page of results. Not returned
	// if there are no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListInstancesResponse) Reset() {
	*x = ListInstancesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListInstancesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListInstancesResponse) ProtoMessage() {}

func (x *ListInstancesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListInstancesResponse.ProtoReflect.Descriptor instead.
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{11}
}

func (x *ListInstancesResponse) GetInstances() []*Instance {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ListInstancesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListInstancesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// A Filestore snapshot.
type Snapshot struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the snapshot, in the format
	// `projects/{project_id}/locations/{location_id}/instances/{instance_id}/snapshots/{snapshot_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A description of the snapshot with 2048 characters or less.
	// Requests with longer descriptions will be rejected.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The snapshot state.
	State Snapshot_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.filestore.v1.Snapshot_State" json:"state,omitempty"`
	// Output only. The time when the snapshot was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Resource labels to represent user provided metadata.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The amount of bytes needed to allocate a full copy of the
	// snapshot content
	FilesystemUsedBytes int64 `protobuf:"varint,6,opt,name=filesystem_used_bytes,json=filesystemUsedBytes,proto3" json:"filesystem_used_bytes,omitempty"`
}

func (x *Snapshot) Reset() {
	*x = Snapshot{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Snapshot) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Snapshot) ProtoMessage() {}

func (x *Snapshot) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Snapshot.ProtoReflect.Descriptor instead.
func (*Snapshot) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{12}
}

func (x *Snapshot) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Snapshot) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Snapshot) GetState() Snapshot_State {
	if x != nil {
		return x.State
	}
	return Snapshot_STATE_UNSPECIFIED
}

func (x *Snapshot) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Snapshot) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Snapshot) GetFilesystemUsedBytes() int64 {
	if x != nil {
		return x.FilesystemUsedBytes
	}
	return 0
}

// CreateSnapshotRequest creates a snapshot.
type CreateSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Filestore Instance to create the snapshots of, in the format
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the snapshot.
	// The ID must be unique within the specified instance.
	//
	// This value must start with a lowercase letter followed by up to 62
	// lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
	SnapshotId string `protobuf:"bytes,2,opt,name=snapshot_id,json=snapshotId,proto3" json:"snapshot_id,omitempty"`
	// Required. A snapshot resource.
	Snapshot *Snapshot `protobuf:"bytes,3,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (x *CreateSnapshotRequest) Reset() {
	*x = CreateSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSnapshotRequest) ProtoMessage() {}

func (x *CreateSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSnapshotRequest.ProtoReflect.Descriptor instead.
func (*CreateSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{13}
}

func (x *CreateSnapshotRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSnapshotRequest) GetSnapshotId() string {
	if x != nil {
		return x.SnapshotId
	}
	return ""
}

func (x *CreateSnapshotRequest) GetSnapshot() *Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

// GetSnapshotRequest gets the state of a snapshot.
type GetSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The snapshot resource name, in the format
	// `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSnapshotRequest) Reset() {
	*x = GetSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSnapshotRequest) ProtoMessage() {}

func (x *GetSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSnapshotRequest.ProtoReflect.Descriptor instead.
func (*GetSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{14}
}

func (x *GetSnapshotRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// DeleteSnapshotRequest deletes a snapshot.
type DeleteSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The snapshot resource name, in the format
	// `projects/{project_id}/locations/{location}/instances/{instance_id}/snapshots/{snapshot_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSnapshotRequest) Reset() {
	*x = DeleteSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSnapshotRequest) ProtoMessage() {}

func (x *DeleteSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSnapshotRequest.ProtoReflect.Descriptor instead.
func (*DeleteSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{15}
}

func (x *DeleteSnapshotRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateSnapshotRequest updates description and/or labels for a snapshot.
type UpdateSnapshotRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Mask of fields to update. At least one path must be supplied in
	// this field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. A snapshot resource.
	Snapshot *Snapshot `protobuf:"bytes,2,opt,name=snapshot,proto3" json:"snapshot,omitempty"`
}

func (x *UpdateSnapshotRequest) Reset() {
	*x = UpdateSnapshotRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSnapshotRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSnapshotRequest) ProtoMessage() {}

func (x *UpdateSnapshotRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSnapshotRequest.ProtoReflect.Descriptor instead.
func (*UpdateSnapshotRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{16}
}

func (x *UpdateSnapshotRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSnapshotRequest) GetSnapshot() *Snapshot {
	if x != nil {
		return x.Snapshot
	}
	return nil
}

// ListSnapshotsRequest lists snapshots.
type ListSnapshotsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The instance for which to retrieve snapshot information,
	// in the format
	// `projects/{project_id}/locations/{location}/instances/{instance_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value to use if there are additional
	// results to retrieve for this list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Sort results. Supported values are "name", "name desc" or "" (unsorted).
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSnapshotsRequest) Reset() {
	*x = ListSnapshotsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSnapshotsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotsRequest) ProtoMessage() {}

func (x *ListSnapshotsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotsRequest.ProtoReflect.Descriptor instead.
func (*ListSnapshotsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{17}
}

func (x *ListSnapshotsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSnapshotsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSnapshotsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSnapshotsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListSnapshotsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ListSnapshotsResponse is the result of ListSnapshotsRequest.
type ListSnapshotsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of snapshots in the project for the specified instance.
	Snapshots []*Snapshot `protobuf:"bytes,1,rep,name=snapshots,proto3" json:"snapshots,omitempty"`
	// The token you can use to retrieve the next page of results. Not returned
	// if there are no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSnapshotsResponse) Reset() {
	*x = ListSnapshotsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSnapshotsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSnapshotsResponse) ProtoMessage() {}

func (x *ListSnapshotsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSnapshotsResponse.ProtoReflect.Descriptor instead.
func (*ListSnapshotsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{18}
}

func (x *ListSnapshotsResponse) GetSnapshots() []*Snapshot {
	if x != nil {
		return x.Snapshots
	}
	return nil
}

func (x *ListSnapshotsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// A Filestore backup.
type Backup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The resource name of the backup, in the format
	// `projects/{project_number}/locations/{location_id}/backups/{backup_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A description of the backup with 2048 characters or less.
	// Requests with longer descriptions will be rejected.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The backup state.
	State Backup_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.filestore.v1.Backup_State" json:"state,omitempty"`
	// Output only. The time when the backup was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Resource labels to represent user provided metadata.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Capacity of the source file share when the backup was created.
	CapacityGb int64 `protobuf:"varint,6,opt,name=capacity_gb,json=capacityGb,proto3" json:"capacity_gb,omitempty"`
	// Output only. The size of the storage used by the backup. As backups share
	// storage, this number is expected to change with backup creation/deletion.
	StorageBytes int64 `protobuf:"varint,7,opt,name=storage_bytes,json=storageBytes,proto3" json:"storage_bytes,omitempty"`
	// The resource name of the source Filestore instance, in the format
	// `projects/{project_number}/locations/{location_id}/instances/{instance_id}`,
	// used to create this backup.
	SourceInstance string `protobuf:"bytes,8,opt,name=source_instance,json=sourceInstance,proto3" json:"source_instance,omitempty"`
	// Name of the file share in the source Filestore instance that the
	// backup is created from.
	SourceFileShare string `protobuf:"bytes,9,opt,name=source_file_share,json=sourceFileShare,proto3" json:"source_file_share,omitempty"`
	// Output only. The service tier of the source Filestore instance that this
	// backup is created from.
	SourceInstanceTier Instance_Tier `protobuf:"varint,10,opt,name=source_instance_tier,json=sourceInstanceTier,proto3,enum=google.cloud.filestore.v1.Instance_Tier" json:"source_instance_tier,omitempty"`
	// Output only. Amount of bytes that will be downloaded if the backup is
	// restored. This may be different than storage bytes, since sequential
	// backups of the same disk will share storage.
	DownloadBytes int64 `protobuf:"varint,11,opt,name=download_bytes,json=downloadBytes,proto3" json:"download_bytes,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs *wrapperspb.BoolValue `protobuf:"bytes,12,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,14,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Immutable. KMS key name used for data encryption.
	KmsKey string `protobuf:"bytes,13,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *Backup) Reset() {
	*x = Backup{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Backup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Backup) ProtoMessage() {}

func (x *Backup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Backup.ProtoReflect.Descriptor instead.
func (*Backup) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{19}
}

func (x *Backup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Backup) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Backup) GetState() Backup_State {
	if x != nil {
		return x.State
	}
	return Backup_STATE_UNSPECIFIED
}

func (x *Backup) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Backup) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Backup) GetCapacityGb() int64 {
	if x != nil {
		return x.CapacityGb
	}
	return 0
}

func (x *Backup) GetStorageBytes() int64 {
	if x != nil {
		return x.StorageBytes
	}
	return 0
}

func (x *Backup) GetSourceInstance() string {
	if x != nil {
		return x.SourceInstance
	}
	return ""
}

func (x *Backup) GetSourceFileShare() string {
	if x != nil {
		return x.SourceFileShare
	}
	return ""
}

func (x *Backup) GetSourceInstanceTier() Instance_Tier {
	if x != nil {
		return x.SourceInstanceTier
	}
	return Instance_TIER_UNSPECIFIED
}

func (x *Backup) GetDownloadBytes() int64 {
	if x != nil {
		return x.DownloadBytes
	}
	return 0
}

func (x *Backup) GetSatisfiesPzs() *wrapperspb.BoolValue {
	if x != nil {
		return x.SatisfiesPzs
	}
	return nil
}

func (x *Backup) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *Backup) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// CreateBackupRequest creates a backup.
type CreateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The backup's project and location, in the format
	// `projects/{project_number}/locations/{location}`. In Filestore,
	// backup locations map to Google Cloud regions, for example **us-west1**.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. A [backup resource][google.cloud.filestore.v1.Backup]
	Backup *Backup `protobuf:"bytes,2,opt,name=backup,proto3" json:"backup,omitempty"`
	// Required. The ID to use for the backup.
	// The ID must be unique within the specified project and location.
	//
	// This value must start with a lowercase letter followed by up to 62
	// lowercase letters, numbers, or hyphens, and cannot end with a hyphen.
	// Values that do not match this pattern will trigger an INVALID_ARGUMENT
	// error.
	BackupId string `protobuf:"bytes,3,opt,name=backup_id,json=backupId,proto3" json:"backup_id,omitempty"`
}

func (x *CreateBackupRequest) Reset() {
	*x = CreateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateBackupRequest) ProtoMessage() {}

func (x *CreateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateBackupRequest.ProtoReflect.Descriptor instead.
func (*CreateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{20}
}

func (x *CreateBackupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *CreateBackupRequest) GetBackupId() string {
	if x != nil {
		return x.BackupId
	}
	return ""
}

// DeleteBackupRequest deletes a backup.
type DeleteBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The backup resource name, in the format
	// `projects/{project_number}/locations/{location}/backups/{backup_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteBackupRequest) Reset() {
	*x = DeleteBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteBackupRequest) ProtoMessage() {}

func (x *DeleteBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteBackupRequest.ProtoReflect.Descriptor instead.
func (*DeleteBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{21}
}

func (x *DeleteBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// UpdateBackupRequest updates description and/or labels for a backup.
type UpdateBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A [backup resource][google.cloud.filestore.v1.Backup]
	Backup *Backup `protobuf:"bytes,1,opt,name=backup,proto3" json:"backup,omitempty"`
	// Required. Mask of fields to update.  At least one path must be supplied in
	// this field.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateBackupRequest) Reset() {
	*x = UpdateBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateBackupRequest) ProtoMessage() {}

func (x *UpdateBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateBackupRequest.ProtoReflect.Descriptor instead.
func (*UpdateBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{22}
}

func (x *UpdateBackupRequest) GetBackup() *Backup {
	if x != nil {
		return x.Backup
	}
	return nil
}

func (x *UpdateBackupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// GetBackupRequest gets the state of a backup.
type GetBackupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The backup resource name, in the format
	// `projects/{project_number}/locations/{location}/backups/{backup_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetBackupRequest) Reset() {
	*x = GetBackupRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetBackupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetBackupRequest) ProtoMessage() {}

func (x *GetBackupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetBackupRequest.ProtoReflect.Descriptor instead.
func (*GetBackupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{23}
}

func (x *GetBackupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListBackupsRequest lists backups.
type ListBackupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location for which to retrieve backup
	// information, in the format
	// `projects/{project_number}/locations/{location}`. In Filestore, backup
	// locations map to Google Cloud regions, for example **us-west1**. To
	// retrieve backup information for all locations, use "-" for the
	// `{location}` value.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value to use if there are additional
	// results to retrieve for this list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Sort results. Supported values are "name", "name desc" or "" (unsorted).
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListBackupsRequest) Reset() {
	*x = ListBackupsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsRequest) ProtoMessage() {}

func (x *ListBackupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsRequest.ProtoReflect.Descriptor instead.
func (*ListBackupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{24}
}

func (x *ListBackupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListBackupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListBackupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListBackupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListBackupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ListBackupsResponse is the result of ListBackupsRequest.
type ListBackupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of backups in the project for the specified location.
	//
	// If the `{location}` value in the request is "-", the response contains a
	// list of backups from all locations. If any location is unreachable, the
	// response will only return backups in reachable locations and the
	// "unreachable" field will be populated with a list of unreachable
	// locations.
	Backups []*Backup `protobuf:"bytes,1,rep,name=backups,proto3" json:"backups,omitempty"`
	// The token you can use to retrieve the next page of results. Not returned
	// if there are no more results in the list.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListBackupsResponse) Reset() {
	*x = ListBackupsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListBackupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListBackupsResponse) ProtoMessage() {}

func (x *ListBackupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListBackupsResponse.ProtoReflect.Descriptor instead.
func (*ListBackupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP(), []int{25}
}

func (x *ListBackupsResponse) GetBackups() []*Backup {
	if x != nil {
		return x.Backups
	}
	return nil
}

func (x *ListBackupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListBackupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

var File_google_cloud_filestore_v1_cloud_filestore_service_proto protoreflect.FileDescriptor

var file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDesc = []byte{
	0x0a, 0x37, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65,
	0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x77, 0x72, 0x61, 0x70,
	0x70, 0x65, 0x72, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbb, 0x03, 0x0a, 0x0d, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x18, 0x0a, 0x07,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x4a, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x05, 0x6d, 0x6f, 0x64,
	0x65, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x5f, 0x69,
	0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72,
	0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x49, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x26,
	0x0a, 0x0c, 0x69, 0x70, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x69, 0x70, 0x41, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x57, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x4d, 0x6f,
	0x64, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x22,
	0x3a, 0x0a, 0x0b, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c,
	0x0a, 0x18, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x49, 0x50, 0x56, 0x34, 0x10, 0x01, 0x22, 0x5b, 0x0a, 0x0b, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x43, 0x4f,
	0x4e, 0x4e, 0x45, 0x43, 0x54, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a, 0x0e, 0x44, 0x49, 0x52, 0x45,
	0x43, 0x54, 0x5f, 0x50, 0x45, 0x45, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16,
	0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x02, 0x22, 0xf3, 0x01, 0x0a, 0x0f, 0x46, 0x69, 0x6c,
	0x65, 0x53, 0x68, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x62, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x47,
	0x62, 0x12, 0x46, 0x0a, 0x0d, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x1f, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x59, 0x0a, 0x12, 0x6e, 0x66, 0x73,
	0x5f, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x10, 0x6e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xb1,
	0x03, 0x0a, 0x10, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x1b, 0x0a, 0x09, 0x69, 0x70, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x69, 0x70, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x73,
	0x12, 0x57, 0x0a, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x4e, 0x66, 0x73, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x57, 0x0a, 0x0b, 0x73, 0x71, 0x75,
	0x61, 0x73, 0x68, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x66, 0x73, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x53, 0x71, 0x75, 0x61,
	0x73, 0x68, 0x4d, 0x6f, 0x64, 0x65, 0x52, 0x0a, 0x73, 0x71, 0x75, 0x61, 0x73, 0x68, 0x4d, 0x6f,
	0x64, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x61, 0x6e, 0x6f, 0x6e, 0x5f, 0x75, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x61, 0x6e, 0x6f, 0x6e, 0x55, 0x69, 0x64, 0x12, 0x19, 0x0a,
	0x08, 0x61, 0x6e, 0x6f, 0x6e, 0x5f, 0x67, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x07, 0x61, 0x6e, 0x6f, 0x6e, 0x47, 0x69, 0x64, 0x22, 0x48, 0x0a, 0x0a, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4d, 0x6f, 0x64, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x41, 0x44, 0x5f, 0x57, 0x52, 0x49, 0x54, 0x45,
	0x10, 0x02, 0x22, 0x4e, 0x0a, 0x0a, 0x53, 0x71, 0x75, 0x61, 0x73, 0x68, 0x4d, 0x6f, 0x64, 0x65,
	0x12, 0x1b, 0x0a, 0x17, 0x53, 0x51, 0x55, 0x41, 0x53, 0x48, 0x5f, 0x4d, 0x4f, 0x44, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x4e, 0x4f, 0x5f, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x53, 0x51, 0x55, 0x41, 0x53, 0x48, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x52, 0x4f, 0x4f, 0x54, 0x5f, 0x53, 0x51, 0x55, 0x41, 0x53, 0x48,
	0x10, 0x02, 0x22, 0xcb, 0x0a, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3c,
	0x0a, 0x04, 0x74, 0x69, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x52, 0x04, 0x74, 0x69, 0x65, 0x72, 0x12, 0x47, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4b, 0x0a, 0x0b, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x72, 0x65,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x72,
	0x65, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x18, 0x0b,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x08,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x44, 0x0a, 0x0d,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f, 0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50,
	0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f,
	0x70, 0x7a, 0x69, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x12, 0x20, 0x0a, 0x0c,
	0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x68,
	0x0a, 0x12, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e,
	0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x73, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x22, 0xaa, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0d, 0x0a,
	0x09, 0x52, 0x45, 0x50, 0x41, 0x49, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08,
	0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x49,
	0x4e, 0x47, 0x10, 0x07, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x08, 0x12, 0x0e, 0x0a, 0x0a, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e,
	0x47, 0x10, 0x09, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x53, 0x55, 0x4d, 0x49, 0x4e, 0x47, 0x10,
	0x0a, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x56, 0x45, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x0c,
	0x22, 0x92, 0x01, 0x0a, 0x04, 0x54, 0x69, 0x65, 0x72, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x49, 0x45,
	0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12, 0x0b, 0x0a,
	0x07, 0x50, 0x52, 0x45, 0x4d, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x41,
	0x53, 0x49, 0x43, 0x5f, 0x48, 0x44, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x41, 0x53,
	0x49, 0x43, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x04, 0x12, 0x12, 0x0a, 0x0e, 0x48, 0x49, 0x47, 0x48,
	0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x5f, 0x53, 0x53, 0x44, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a,
	0x45, 0x4e, 0x54, 0x45, 0x52, 0x50, 0x52, 0x49, 0x53, 0x45, 0x10, 0x06, 0x12, 0x09, 0x0a, 0x05,
	0x5a, 0x4f, 0x4e, 0x41, 0x4c, 0x10, 0x07, 0x12, 0x0c, 0x0a, 0x08, 0x52, 0x45, 0x47, 0x49, 0x4f,
	0x4e, 0x41, 0x4c, 0x10, 0x08, 0x22, 0x48, 0x0a, 0x10, 0x53, 0x75, 0x73, 0x70, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x1d, 0x53, 0x55, 0x53,
	0x50, 0x45, 0x4e, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x11, 0x0a, 0x0d,
	0x4b, 0x4d, 0x53, 0x5f, 0x4b, 0x45, 0x59, 0x5f, 0x49, 0x53, 0x53, 0x55, 0x45, 0x10, 0x01, 0x3a,
	0x5f, 0xea, 0x41, 0x5c, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x3c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x7d,
	0x22, 0xc6, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x24, 0x0a,
	0x0b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x4e, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x95, 0x01, 0x0a, 0x15, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x3f, 0x0a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x22, 0xc8, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x66, 0x69, 0x6c, 0x65, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x46, 0x0a, 0x0d, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x1f, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x48, 0x00, 0x52, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x84, 0x01, 0x0a,
	0x15, 0x52, 0x65, 0x76, 0x65, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x31, 0x0a, 0x12, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x49, 0x64, 0x22, 0x67, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x22, 0xc8, 0x01, 0x0a,
	0x14, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0xa4, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xc7,
	0x04, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x47,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69,
	0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52,
	0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x66, 0x69, 0x6c, 0x65, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x75, 0x73, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x13, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x55, 0x73, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x45, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43,
	0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41,
	0x44, 0x59, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x3a, 0x74, 0xea, 0x41, 0x71, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x7d, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x7b, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x7d, 0x22, 0xc1, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x24, 0x0a, 0x0b, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x73, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x49, 0x64, 0x12, 0x44, 0x0a, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x4e, 0x0a, 0x12,
	0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x51, 0x0a, 0x15,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x38, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x9f, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x44, 0x0a, 0x08, 0x73,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x22, 0xc3, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x1e, 0x0a, 0x1c, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x82, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x41, 0x0a, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x09, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xed, 0x07, 0x0a,
	0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x24, 0x0a, 0x0b, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x62, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x61, 0x70, 0x61, 0x63,
	0x69, 0x74, 0x79, 0x47, 0x62, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12,
	0x4a, 0x0a, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x21, 0xfa, 0x41, 0x1e, 0x0a, 0x1c, 0x66,
	0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0e, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69,
	0x6c, 0x65, 0x53, 0x68, 0x61, 0x72, 0x65, 0x12, 0x5f, 0x0a, 0x14, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x54, 0x69, 0x65, 0x72, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x54, 0x69, 0x65, 0x72, 0x12, 0x2a, 0x0a, 0x0e, 0x64, 0x6f, 0x77, 0x6e,
	0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x03,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x44, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65,
	0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x42, 0x6f,
	0x6f, 0x6c, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61,
	0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65,
	0x73, 0x50, 0x7a, 0x69, 0x12, 0x1c, 0x0a, 0x07, 0x6b, 0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b,
	0x65, 0x79, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x62, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x46,
	0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x52,
	0x45, 0x41, 0x44, 0x59, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x10,
	0x05, 0x3a, 0x59, 0xea, 0x41, 0x56, 0x0a, 0x1a, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x7d, 0x22, 0xba, 0x01, 0x0a,
	0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3e, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x20, 0x0a, 0x09, 0x62, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x08, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x49, 0x64, 0x22, 0x4d, 0x0a, 0x13, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x22,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x97, 0x01, 0x0a, 0x13, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61,
	0x73, 0x6b, 0x22, 0x4a, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x66, 0x69,
	0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc6,
	0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12,
	0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x22, 0x9c, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3b, 0x0a, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x61, 0x63,
	0x6b, 0x75, 0x70, 0x52, 0x07, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x32, 0xa4, 0x1d, 0x0a, 0x15, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x46, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x12, 0xb2, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x9f, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x12, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf5, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41,
	0x31, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12,
	0xf7, 0x01, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x93, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x14, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x08, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x32, 0x36, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd9, 0x01, 0x0a, 0x0f, 0x52, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c,
	0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x74, 0xca, 0x41, 0x31, 0x0a, 0x08, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3a, 0x3a, 0x01, 0x2a, 0x22, 0x35,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x12, 0xd6, 0x01, 0x0a, 0x0e, 0x52, 0x65, 0x76, 0x65, 0x72, 0x74,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x65, 0x72, 0x74, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x31, 0x0a, 0x08,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x01, 0x2a, 0x22, 0x34, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x76, 0x65, 0x72, 0x74, 0x12, 0xe0,
	0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x7d, 0xca, 0x41, 0x3e, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2f, 0x2a, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xbe, 0x01, 0x0a, 0x0d, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f,
	0x74, 0x73, 0x12, 0xab, 0x01, 0x0a, 0x0b, 0x47, 0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x48, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0x81, 0x02, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9d, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x08, 0x53, 0x6e, 0x61, 0x70,
	0x73, 0x68, 0x6f, 0x74, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2c, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x45, 0x3a,
	0x08, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73,
	0x68, 0x6f, 0x74, 0x73, 0x12, 0xed, 0x01, 0x0a, 0x0e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x3e, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3b, 0x2a, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x83, 0x02, 0x0a, 0x0e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68,
	0x6f, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x08,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x14, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x08, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x32, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6e, 0x61,
	0x70, 0x73, 0x68, 0x6f, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6e,
	0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x01, 0x0a, 0x0b, 0x4c,
	0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75,
	0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0x97, 0x01, 0x0a, 0x09, 0x47, 0x65, 0x74, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x21, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x3a, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe7, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x87, 0x01, 0xca, 0x41, 0x2f, 0x0a, 0x06, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12,
	0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x69, 0x64,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x22, 0x2b,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x73, 0x12, 0xda, 0x01, 0x0a, 0x0c,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65,
	0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x42,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7b, 0xca, 0x41, 0x3e,
	0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61,
	0x63, 0x6b, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe9, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x42, 0x61, 0x63, 0x6b,
	0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x01, 0xca, 0x41, 0x2f, 0x0a, 0x06,
	0x42, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x12, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x12,
	0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x06, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70,
	0x73, 0x2f, 0x2a, 0x7d, 0x1a, 0x47, 0xca, 0x41, 0x13, 0x66, 0x69, 0x6c, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68,
	0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xb2, 0x01,
	0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2e, 0x76, 0x31, 0x42,
	0x1a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3b, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0x3b, 0x66,
	0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x19, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x5c,
	0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescOnce sync.Once
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescData = file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDesc
)

func file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescGZIP() []byte {
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescData)
	})
	return file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDescData
}

var file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes = make([]protoimpl.EnumInfo, 9)
var file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes = make([]protoimpl.MessageInfo, 29)
var file_google_cloud_filestore_v1_cloud_filestore_service_proto_goTypes = []interface{}{
	(NetworkConfig_AddressMode)(0),   // 0: google.cloud.filestore.v1.NetworkConfig.AddressMode
	(NetworkConfig_ConnectMode)(0),   // 1: google.cloud.filestore.v1.NetworkConfig.ConnectMode
	(NfsExportOptions_AccessMode)(0), // 2: google.cloud.filestore.v1.NfsExportOptions.AccessMode
	(NfsExportOptions_SquashMode)(0), // 3: google.cloud.filestore.v1.NfsExportOptions.SquashMode
	(Instance_State)(0),              // 4: google.cloud.filestore.v1.Instance.State
	(Instance_Tier)(0),               // 5: google.cloud.filestore.v1.Instance.Tier
	(Instance_SuspensionReason)(0),   // 6: google.cloud.filestore.v1.Instance.SuspensionReason
	(Snapshot_State)(0),              // 7: google.cloud.filestore.v1.Snapshot.State
	(Backup_State)(0),                // 8: google.cloud.filestore.v1.Backup.State
	(*NetworkConfig)(nil),            // 9: google.cloud.filestore.v1.NetworkConfig
	(*FileShareConfig)(nil),          // 10: google.cloud.filestore.v1.FileShareConfig
	(*NfsExportOptions)(nil),         // 11: google.cloud.filestore.v1.NfsExportOptions
	(*Instance)(nil),                 // 12: google.cloud.filestore.v1.Instance
	(*CreateInstanceRequest)(nil),    // 13: google.cloud.filestore.v1.CreateInstanceRequest
	(*GetInstanceRequest)(nil),       // 14: google.cloud.filestore.v1.GetInstanceRequest
	(*UpdateInstanceRequest)(nil),    // 15: google.cloud.filestore.v1.UpdateInstanceRequest
	(*RestoreInstanceRequest)(nil),   // 16: google.cloud.filestore.v1.RestoreInstanceRequest
	(*RevertInstanceRequest)(nil),    // 17: google.cloud.filestore.v1.RevertInstanceRequest
	(*DeleteInstanceRequest)(nil),    // 18: google.cloud.filestore.v1.DeleteInstanceRequest
	(*ListInstancesRequest)(nil),     // 19: google.cloud.filestore.v1.ListInstancesRequest
	(*ListInstancesResponse)(nil),    // 20: google.cloud.filestore.v1.ListInstancesResponse
	(*Snapshot)(nil),                 // 21: google.cloud.filestore.v1.Snapshot
	(*CreateSnapshotRequest)(nil),    // 22: google.cloud.filestore.v1.CreateSnapshotRequest
	(*GetSnapshotRequest)(nil),       // 23: google.cloud.filestore.v1.GetSnapshotRequest
	(*DeleteSnapshotRequest)(nil),    // 24: google.cloud.filestore.v1.DeleteSnapshotRequest
	(*UpdateSnapshotRequest)(nil),    // 25: google.cloud.filestore.v1.UpdateSnapshotRequest
	(*ListSnapshotsRequest)(nil),     // 26: google.cloud.filestore.v1.ListSnapshotsRequest
	(*ListSnapshotsResponse)(nil),    // 27: google.cloud.filestore.v1.ListSnapshotsResponse
	(*Backup)(nil),                   // 28: google.cloud.filestore.v1.Backup
	(*CreateBackupRequest)(nil),      // 29: google.cloud.filestore.v1.CreateBackupRequest
	(*DeleteBackupRequest)(nil),      // 30: google.cloud.filestore.v1.DeleteBackupRequest
	(*UpdateBackupRequest)(nil),      // 31: google.cloud.filestore.v1.UpdateBackupRequest
	(*GetBackupRequest)(nil),         // 32: google.cloud.filestore.v1.GetBackupRequest
	(*ListBackupsRequest)(nil),       // 33: google.cloud.filestore.v1.ListBackupsRequest
	(*ListBackupsResponse)(nil),      // 34: google.cloud.filestore.v1.ListBackupsResponse
	nil,                              // 35: google.cloud.filestore.v1.Instance.LabelsEntry
	nil,                              // 36: google.cloud.filestore.v1.Snapshot.LabelsEntry
	nil,                              // 37: google.cloud.filestore.v1.Backup.LabelsEntry
	(*timestamppb.Timestamp)(nil),    // 38: google.protobuf.Timestamp
	(*wrapperspb.BoolValue)(nil),     // 39: google.protobuf.BoolValue
	(*fieldmaskpb.FieldMask)(nil),    // 40: google.protobuf.FieldMask
	(*longrunningpb.Operation)(nil),  // 41: google.longrunning.Operation
}
var file_google_cloud_filestore_v1_cloud_filestore_service_proto_depIdxs = []int32{
	0,  // 0: google.cloud.filestore.v1.NetworkConfig.modes:type_name -> google.cloud.filestore.v1.NetworkConfig.AddressMode
	1,  // 1: google.cloud.filestore.v1.NetworkConfig.connect_mode:type_name -> google.cloud.filestore.v1.NetworkConfig.ConnectMode
	11, // 2: google.cloud.filestore.v1.FileShareConfig.nfs_export_options:type_name -> google.cloud.filestore.v1.NfsExportOptions
	2,  // 3: google.cloud.filestore.v1.NfsExportOptions.access_mode:type_name -> google.cloud.filestore.v1.NfsExportOptions.AccessMode
	3,  // 4: google.cloud.filestore.v1.NfsExportOptions.squash_mode:type_name -> google.cloud.filestore.v1.NfsExportOptions.SquashMode
	4,  // 5: google.cloud.filestore.v1.Instance.state:type_name -> google.cloud.filestore.v1.Instance.State
	38, // 6: google.cloud.filestore.v1.Instance.create_time:type_name -> google.protobuf.Timestamp
	5,  // 7: google.cloud.filestore.v1.Instance.tier:type_name -> google.cloud.filestore.v1.Instance.Tier
	35, // 8: google.cloud.filestore.v1.Instance.labels:type_name -> google.cloud.filestore.v1.Instance.LabelsEntry
	10, // 9: google.cloud.filestore.v1.Instance.file_shares:type_name -> google.cloud.filestore.v1.FileShareConfig
	9,  // 10: google.cloud.filestore.v1.Instance.networks:type_name -> google.cloud.filestore.v1.NetworkConfig
	39, // 11: google.cloud.filestore.v1.Instance.satisfies_pzs:type_name -> google.protobuf.BoolValue
	6,  // 12: google.cloud.filestore.v1.Instance.suspension_reasons:type_name -> google.cloud.filestore.v1.Instance.SuspensionReason
	12, // 13: google.cloud.filestore.v1.CreateInstanceRequest.instance:type_name -> google.cloud.filestore.v1.Instance
	40, // 14: google.cloud.filestore.v1.UpdateInstanceRequest.update_mask:type_name -> google.protobuf.FieldMask
	12, // 15: google.cloud.filestore.v1.UpdateInstanceRequest.instance:type_name -> google.cloud.filestore.v1.Instance
	12, // 16: google.cloud.filestore.v1.ListInstancesResponse.instances:type_name -> google.cloud.filestore.v1.Instance
	7,  // 17: google.cloud.filestore.v1.Snapshot.state:type_name -> google.cloud.filestore.v1.Snapshot.State
	38, // 18: google.cloud.filestore.v1.Snapshot.create_time:type_name -> google.protobuf.Timestamp
	36, // 19: google.cloud.filestore.v1.Snapshot.labels:type_name -> google.cloud.filestore.v1.Snapshot.LabelsEntry
	21, // 20: google.cloud.filestore.v1.CreateSnapshotRequest.snapshot:type_name -> google.cloud.filestore.v1.Snapshot
	40, // 21: google.cloud.filestore.v1.UpdateSnapshotRequest.update_mask:type_name -> google.protobuf.FieldMask
	21, // 22: google.cloud.filestore.v1.UpdateSnapshotRequest.snapshot:type_name -> google.cloud.filestore.v1.Snapshot
	21, // 23: google.cloud.filestore.v1.ListSnapshotsResponse.snapshots:type_name -> google.cloud.filestore.v1.Snapshot
	8,  // 24: google.cloud.filestore.v1.Backup.state:type_name -> google.cloud.filestore.v1.Backup.State
	38, // 25: google.cloud.filestore.v1.Backup.create_time:type_name -> google.protobuf.Timestamp
	37, // 26: google.cloud.filestore.v1.Backup.labels:type_name -> google.cloud.filestore.v1.Backup.LabelsEntry
	5,  // 27: google.cloud.filestore.v1.Backup.source_instance_tier:type_name -> google.cloud.filestore.v1.Instance.Tier
	39, // 28: google.cloud.filestore.v1.Backup.satisfies_pzs:type_name -> google.protobuf.BoolValue
	28, // 29: google.cloud.filestore.v1.CreateBackupRequest.backup:type_name -> google.cloud.filestore.v1.Backup
	28, // 30: google.cloud.filestore.v1.UpdateBackupRequest.backup:type_name -> google.cloud.filestore.v1.Backup
	40, // 31: google.cloud.filestore.v1.UpdateBackupRequest.update_mask:type_name -> google.protobuf.FieldMask
	28, // 32: google.cloud.filestore.v1.ListBackupsResponse.backups:type_name -> google.cloud.filestore.v1.Backup
	19, // 33: google.cloud.filestore.v1.CloudFilestoreManager.ListInstances:input_type -> google.cloud.filestore.v1.ListInstancesRequest
	14, // 34: google.cloud.filestore.v1.CloudFilestoreManager.GetInstance:input_type -> google.cloud.filestore.v1.GetInstanceRequest
	13, // 35: google.cloud.filestore.v1.CloudFilestoreManager.CreateInstance:input_type -> google.cloud.filestore.v1.CreateInstanceRequest
	15, // 36: google.cloud.filestore.v1.CloudFilestoreManager.UpdateInstance:input_type -> google.cloud.filestore.v1.UpdateInstanceRequest
	16, // 37: google.cloud.filestore.v1.CloudFilestoreManager.RestoreInstance:input_type -> google.cloud.filestore.v1.RestoreInstanceRequest
	17, // 38: google.cloud.filestore.v1.CloudFilestoreManager.RevertInstance:input_type -> google.cloud.filestore.v1.RevertInstanceRequest
	18, // 39: google.cloud.filestore.v1.CloudFilestoreManager.DeleteInstance:input_type -> google.cloud.filestore.v1.DeleteInstanceRequest
	26, // 40: google.cloud.filestore.v1.CloudFilestoreManager.ListSnapshots:input_type -> google.cloud.filestore.v1.ListSnapshotsRequest
	23, // 41: google.cloud.filestore.v1.CloudFilestoreManager.GetSnapshot:input_type -> google.cloud.filestore.v1.GetSnapshotRequest
	22, // 42: google.cloud.filestore.v1.CloudFilestoreManager.CreateSnapshot:input_type -> google.cloud.filestore.v1.CreateSnapshotRequest
	24, // 43: google.cloud.filestore.v1.CloudFilestoreManager.DeleteSnapshot:input_type -> google.cloud.filestore.v1.DeleteSnapshotRequest
	25, // 44: google.cloud.filestore.v1.CloudFilestoreManager.UpdateSnapshot:input_type -> google.cloud.filestore.v1.UpdateSnapshotRequest
	33, // 45: google.cloud.filestore.v1.CloudFilestoreManager.ListBackups:input_type -> google.cloud.filestore.v1.ListBackupsRequest
	32, // 46: google.cloud.filestore.v1.CloudFilestoreManager.GetBackup:input_type -> google.cloud.filestore.v1.GetBackupRequest
	29, // 47: google.cloud.filestore.v1.CloudFilestoreManager.CreateBackup:input_type -> google.cloud.filestore.v1.CreateBackupRequest
	30, // 48: google.cloud.filestore.v1.CloudFilestoreManager.DeleteBackup:input_type -> google.cloud.filestore.v1.DeleteBackupRequest
	31, // 49: google.cloud.filestore.v1.CloudFilestoreManager.UpdateBackup:input_type -> google.cloud.filestore.v1.UpdateBackupRequest
	20, // 50: google.cloud.filestore.v1.CloudFilestoreManager.ListInstances:output_type -> google.cloud.filestore.v1.ListInstancesResponse
	12, // 51: google.cloud.filestore.v1.CloudFilestoreManager.GetInstance:output_type -> google.cloud.filestore.v1.Instance
	41, // 52: google.cloud.filestore.v1.CloudFilestoreManager.CreateInstance:output_type -> google.longrunning.Operation
	41, // 53: google.cloud.filestore.v1.CloudFilestoreManager.UpdateInstance:output_type -> google.longrunning.Operation
	41, // 54: google.cloud.filestore.v1.CloudFilestoreManager.RestoreInstance:output_type -> google.longrunning.Operation
	41, // 55: google.cloud.filestore.v1.CloudFilestoreManager.RevertInstance:output_type -> google.longrunning.Operation
	41, // 56: google.cloud.filestore.v1.CloudFilestoreManager.DeleteInstance:output_type -> google.longrunning.Operation
	27, // 57: google.cloud.filestore.v1.CloudFilestoreManager.ListSnapshots:output_type -> google.cloud.filestore.v1.ListSnapshotsResponse
	21, // 58: google.cloud.filestore.v1.CloudFilestoreManager.GetSnapshot:output_type -> google.cloud.filestore.v1.Snapshot
	41, // 59: google.cloud.filestore.v1.CloudFilestoreManager.CreateSnapshot:output_type -> google.longrunning.Operation
	41, // 60: google.cloud.filestore.v1.CloudFilestoreManager.DeleteSnapshot:output_type -> google.longrunning.Operation
	41, // 61: google.cloud.filestore.v1.CloudFilestoreManager.UpdateSnapshot:output_type -> google.longrunning.Operation
	34, // 62: google.cloud.filestore.v1.CloudFilestoreManager.ListBackups:output_type -> google.cloud.filestore.v1.ListBackupsResponse
	28, // 63: google.cloud.filestore.v1.CloudFilestoreManager.GetBackup:output_type -> google.cloud.filestore.v1.Backup
	41, // 64: google.cloud.filestore.v1.CloudFilestoreManager.CreateBackup:output_type -> google.longrunning.Operation
	41, // 65: google.cloud.filestore.v1.CloudFilestoreManager.DeleteBackup:output_type -> google.longrunning.Operation
	41, // 66: google.cloud.filestore.v1.CloudFilestoreManager.UpdateBackup:output_type -> google.longrunning.Operation
	50, // [50:67] is the sub-list for method output_type
	33, // [33:50] is the sub-list for method input_type
	33, // [33:33] is the sub-list for extension type_name
	33, // [33:33] is the sub-list for extension extendee
	0,  // [0:33] is the sub-list for field type_name
}

func init() { file_google_cloud_filestore_v1_cloud_filestore_service_proto_init() }
func file_google_cloud_filestore_v1_cloud_filestore_service_proto_init() {
	if File_google_cloud_filestore_v1_cloud_filestore_service_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NetworkConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileShareConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*NfsExportOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Instance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RestoreInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RevertInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteInstanceRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInstancesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListInstancesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Snapshot); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSnapshotRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSnapshotsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSnapshotsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Backup); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetBackupRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListBackupsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*FileShareConfig_SourceBackup)(nil),
	}
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes[7].OneofWrappers = []interface{}{
		(*RestoreInstanceRequest_SourceBackup)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDesc,
			NumEnums:      9,
			NumMessages:   29,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_filestore_v1_cloud_filestore_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_filestore_v1_cloud_filestore_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_filestore_v1_cloud_filestore_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_filestore_v1_cloud_filestore_service_proto_msgTypes,
	}.Build()
	File_google_cloud_filestore_v1_cloud_filestore_service_proto = out.File
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_rawDesc = nil
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_goTypes = nil
	file_google_cloud_filestore_v1_cloud_filestore_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CloudFilestoreManagerClient is the client API for CloudFilestoreManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CloudFilestoreManagerClient interface {
	// Lists all instances in a project for either a specified location
	// or for all locations.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Gets the details of a specific instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Creates an instance.
	// When creating from a backup, the capacity of the new instance needs to be
	// equal to or larger than the capacity of the backup (and also equal to or
	// larger than the minimum capacity of the tier).
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific instance.
	UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Restores an existing instance's file share from a backup.
	//
	// The capacity of the instance needs to be equal to or larger than the
	// capacity of the backup (and also equal to or larger than the minimum
	// capacity of the tier).
	RestoreInstance(ctx context.Context, in *RestoreInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Revert an existing instance's file system to a specified snapshot.
	RevertInstance(ctx context.Context, in *RevertInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes an instance.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all snapshots in a project for either a specified location
	// or for all locations.
	ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error)
	// Gets the details of a specific snapshot.
	GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error)
	// Creates a snapshot.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a snapshot.
	DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific snapshot.
	UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists all backups in a project for either a specified location or for all
	// locations.
	ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error)
	// Creates a backup.
	CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a backup.
	DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the settings of a specific backup.
	UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type cloudFilestoreManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewCloudFilestoreManagerClient(cc grpc.ClientConnInterface) CloudFilestoreManagerClient {
	return &cloudFilestoreManagerClient{cc}
}

func (c *cloudFilestoreManagerClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) UpdateInstance(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) RestoreInstance(ctx context.Context, in *RestoreInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/RestoreInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) RevertInstance(ctx context.Context, in *RevertInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/RevertInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) ListSnapshots(ctx context.Context, in *ListSnapshotsRequest, opts ...grpc.CallOption) (*ListSnapshotsResponse, error) {
	out := new(ListSnapshotsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/ListSnapshots", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) GetSnapshot(ctx context.Context, in *GetSnapshotRequest, opts ...grpc.CallOption) (*Snapshot, error) {
	out := new(Snapshot)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/GetSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/CreateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) DeleteSnapshot(ctx context.Context, in *DeleteSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) UpdateSnapshot(ctx context.Context, in *UpdateSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateSnapshot", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) ListBackups(ctx context.Context, in *ListBackupsRequest, opts ...grpc.CallOption) (*ListBackupsResponse, error) {
	out := new(ListBackupsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/ListBackups", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) GetBackup(ctx context.Context, in *GetBackupRequest, opts ...grpc.CallOption) (*Backup, error) {
	out := new(Backup)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/GetBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) CreateBackup(ctx context.Context, in *CreateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/CreateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) DeleteBackup(ctx context.Context, in *DeleteBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cloudFilestoreManagerClient) UpdateBackup(ctx context.Context, in *UpdateBackupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateBackup", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CloudFilestoreManagerServer is the server API for CloudFilestoreManager service.
type CloudFilestoreManagerServer interface {
	// Lists all instances in a project for either a specified location
	// or for all locations.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Gets the details of a specific instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Creates an instance.
	// When creating from a backup, the capacity of the new instance needs to be
	// equal to or larger than the capacity of the backup (and also equal to or
	// larger than the minimum capacity of the tier).
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific instance.
	UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error)
	// Restores an existing instance's file share from a backup.
	//
	// The capacity of the instance needs to be equal to or larger than the
	// capacity of the backup (and also equal to or larger than the minimum
	// capacity of the tier).
	RestoreInstance(context.Context, *RestoreInstanceRequest) (*longrunningpb.Operation, error)
	// Revert an existing instance's file system to a specified snapshot.
	RevertInstance(context.Context, *RevertInstanceRequest) (*longrunningpb.Operation, error)
	// Deletes an instance.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error)
	// Lists all snapshots in a project for either a specified location
	// or for all locations.
	ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error)
	// Gets the details of a specific snapshot.
	GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error)
	// Creates a snapshot.
	CreateSnapshot(context.Context, *CreateSnapshotRequest) (*longrunningpb.Operation, error)
	// Deletes a snapshot.
	DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific snapshot.
	UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*longrunningpb.Operation, error)
	// Lists all backups in a project for either a specified location or for all
	// locations.
	ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error)
	// Gets the details of a specific backup.
	GetBackup(context.Context, *GetBackupRequest) (*Backup, error)
	// Creates a backup.
	CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error)
	// Deletes a backup.
	DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error)
	// Updates the settings of a specific backup.
	UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCloudFilestoreManagerServer can be embedded to have forward compatible implementations.
type UnimplementedCloudFilestoreManagerServer struct {
}

func (*UnimplementedCloudFilestoreManagerServer) ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) GetInstance(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) CreateInstance(context.Context, *CreateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) UpdateInstance(context.Context, *UpdateInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) RestoreInstance(context.Context, *RestoreInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RestoreInstance not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) RevertInstance(context.Context, *RevertInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RevertInstance not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) DeleteInstance(context.Context, *DeleteInstanceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) ListSnapshots(context.Context, *ListSnapshotsRequest) (*ListSnapshotsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSnapshots not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) GetSnapshot(context.Context, *GetSnapshotRequest) (*Snapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSnapshot not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) CreateSnapshot(context.Context, *CreateSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) DeleteSnapshot(context.Context, *DeleteSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSnapshot not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) UpdateSnapshot(context.Context, *UpdateSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSnapshot not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) ListBackups(context.Context, *ListBackupsRequest) (*ListBackupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListBackups not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) GetBackup(context.Context, *GetBackupRequest) (*Backup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetBackup not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) CreateBackup(context.Context, *CreateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateBackup not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) DeleteBackup(context.Context, *DeleteBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteBackup not implemented")
}
func (*UnimplementedCloudFilestoreManagerServer) UpdateBackup(context.Context, *UpdateBackupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateBackup not implemented")
}

func RegisterCloudFilestoreManagerServer(s *grpc.Server, srv CloudFilestoreManagerServer) {
	s.RegisterService(&_CloudFilestoreManager_serviceDesc, srv)
}

func _CloudFilestoreManager_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).UpdateInstance(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_RestoreInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RestoreInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).RestoreInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/RestoreInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).RestoreInstance(ctx, req.(*RestoreInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_RevertInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevertInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).RevertInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/RevertInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).RevertInstance(ctx, req.(*RevertInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_ListSnapshots_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).ListSnapshots(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/ListSnapshots",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).ListSnapshots(ctx, req.(*ListSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_GetSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).GetSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/GetSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).GetSnapshot(ctx, req.(*GetSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/CreateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).CreateSnapshot(ctx, req.(*CreateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_DeleteSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).DeleteSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).DeleteSnapshot(ctx, req.(*DeleteSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_UpdateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).UpdateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateSnapshot",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).UpdateSnapshot(ctx, req.(*UpdateSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_ListBackups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).ListBackups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/ListBackups",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).ListBackups(ctx, req.(*ListBackupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_GetBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).GetBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/GetBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).GetBackup(ctx, req.(*GetBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_CreateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).CreateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/CreateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).CreateBackup(ctx, req.(*CreateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_DeleteBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).DeleteBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/DeleteBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).DeleteBackup(ctx, req.(*DeleteBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CloudFilestoreManager_UpdateBackup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CloudFilestoreManagerServer).UpdateBackup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.filestore.v1.CloudFilestoreManager/UpdateBackup",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CloudFilestoreManagerServer).UpdateBackup(ctx, req.(*UpdateBackupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CloudFilestoreManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.filestore.v1.CloudFilestoreManager",
	HandlerType: (*CloudFilestoreManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListInstances",
			Handler:    _CloudFilestoreManager_ListInstances_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _CloudFilestoreManager_GetInstance_Handler,
		},
		{
			MethodName: "CreateInstance",
			Handler:    _CloudFilestoreManager_CreateInstance_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _CloudFilestoreManager_UpdateInstance_Handler,
		},
		{
			MethodName: "RestoreInstance",
			Handler:    _CloudFilestoreManager_RestoreInstance_Handler,
		},
		{
			MethodName: "RevertInstance",
			Handler:    _CloudFilestoreManager_RevertInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _CloudFilestoreManager_DeleteInstance_Handler,
		},
		{
			MethodName: "ListSnapshots",
			Handler:    _CloudFilestoreManager_ListSnapshots_Handler,
		},
		{
			MethodName: "GetSnapshot",
			Handler:    _CloudFilestoreManager_GetSnapshot_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _CloudFilestoreManager_CreateSnapshot_Handler,
		},
		{
			MethodName: "DeleteSnapshot",
			Handler:    _CloudFilestoreManager_DeleteSnapshot_Handler,
		},
		{
			MethodName: "UpdateSnapshot",
			Handler:    _CloudFilestoreManager_UpdateSnapshot_Handler,
		},
		{
			MethodName: "ListBackups",
			Handler:    _CloudFilestoreManager_ListBackups_Handler,
		},
		{
			MethodName: "GetBackup",
			Handler:    _CloudFilestoreManager_GetBackup_Handler,
		},
		{
			MethodName: "CreateBackup",
			Handler:    _CloudFilestoreManager_CreateBackup_Handler,
		},
		{
			MethodName: "DeleteBackup",
			Handler:    _CloudFilestoreManager_DeleteBackup_Handler,
		},
		{
			MethodName: "UpdateBackup",
			Handler:    _CloudFilestoreManager_UpdateBackup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/filestore/v1/cloud_filestore_service.proto",
}
